
module CLI.Types where

import Data.String
import Data.Text (Text)
import Gargantext.API.Admin.Settings
import Gargantext.Core.Config.Types (SettingsFile(..))
import Gargantext.Core.Types (NodeId)
import Gargantext.Core.Types.Query
import Prelude

newtype CorpusFile = CorpusFile { _CorpusFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype TermListFile = TermListFile { _TermsListFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype OutputFile = OutputFile { _OutputFile :: FilePath }
  deriving (Show, Eq, IsString)

data ObfuscateDBArgs = ObfuscateDBArgs {
    dbHost     :: !Text
  , dbPort     :: !Int
  , dbName     :: !Text
  , dbUser     :: !Text
  , dbPassword :: !Text
  } deriving (Show, Eq)

data AdminArgs = AdminArgs
  { settingsPath :: !SettingsFile
  , emails       :: [String]
  } deriving (Show, Eq)

data ImportFunction
  = IF_corpus
  | IF_corpusTsvHal
  | IF_annuaire
  deriving (Show, Eq, Enum, Bounded)

data ImportArgs = ImportArgs
  { imp_function :: !ImportFunction
  , imp_user     :: !Text
  , imp_name     :: !Text
  , imp_settings :: !SettingsFile
  , imp_limit    :: !Limit
  , imp_corpus_path :: !FilePath
  } deriving (Show, Eq)

data InitArgs = InitArgs
  { init_settings :: !SettingsFile
  } deriving (Show, Eq)

data InvitationsArgs = InvitationsArgs
  { inv_settings :: !SettingsFile
  , inv_user    :: !Text
  , inv_node_id :: !NodeId
  , inv_email   :: !Text
  } deriving (Show, Eq)

data PhyloArgs = PhyloArgs
  { phylo_config :: !FilePath
  } deriving (Show, Eq)

data UpgradeArgs = UpgradeArgs
  { upgrade_settings :: !SettingsFile
  } deriving (Show, Eq)

data GoldenFileDiffArgs = GoldenFileDiffArgs
  { gdf_expected :: !FilePath
  , gdf_actual   :: !FilePath
  } deriving (Show, Eq)

data CLIRoutes
  = CLIR_list
  | CLIR_export FilePath
  deriving (Show, Eq)

data CLICmd
  = CCMD_clean_csv_corpus
  | CCMD_filter_terms_and_cooc !CorpusFile !TermListFile !OutputFile
  | CCMD_obfuscate_db !ObfuscateDBArgs
  | CCMD_admin !AdminArgs
  | CCMD_import !ImportArgs
  | CCMD_init !InitArgs
  | CCMD_invitations !InvitationsArgs
  | CCMD_phylo !PhyloArgs
  | CCMD_phylo_profile
  | CCMD_upgrade !UpgradeArgs
  | CCMD_golden_file_diff !GoldenFileDiffArgs
  | CCMD_routes !CLIRoutes
  deriving (Show, Eq)

data CLI =
  CLISub CLICmd
  deriving (Show, Eq)


