# Building Gargantext using the Stack tool

Those are the instructions for developers who wish to build Gargantext using stack instead of cabal.

## Prerequisites

You need [Stack](https://docs.haskellstack.org/en/stable/) (obviously). You can install it with:
```shell
curl -sSL https://get.haskellstack.org/ | sh
```

Check that the installation is complete with:
```shell
stack --version
Version 2.9.1
```

## Building and setting up

To build with stack, follow the instructions in `README.md`, with the following changes:

- Replace the `cabal update` and `cabal install` commands with (still from within a Nix shell!):
```shell
stack build --fast
```

*Note: The default build (with optimizations) requires large amounts of RAM (16GB at least). The (recommended) `--fast` flag is here to avoid heavy compilation times and swapping out your machine; just omit it if you want to build with optimizations.*

- After you have run the `docker compose up` command, install with
```shell
stack install
```

## Keeping the stack.yaml updated with the cabal.project

Once you have a valid version of stack, building requires generating a valid `stack.yaml`. This can be obtained by installing `cabal2stack`:
```shell
git clone https://github.com/iconnect/cabal2stack.git
cd cabal2stack
```

Then, depending on what build system you are using, either build with `cabal install --overwrite-policy=always` or `stack install`.
And finally:
```shell
cabal2stack --system-ghc --allow-newer --resolver lts-21.17 --resolver-file devops/stack/lts-21.17.yaml -o stack.yaml
stack build
```

The good news is you don't have to do all of this manually; during development, after modifying `cabal.project`, it's enough to run:
```shell
./bin/update-project-dependencies
```
