
{-| Common parsers for the CLI. -}

module CLI.Parsers where

import Prelude
import Gargantext.API.Admin.Settings
import Gargantext.Core.Config.Types (SettingsFile(..))
import Options.Applicative

settings_p :: Parser SettingsFile
settings_p = maybe (SettingsFile "gargantext-settings.toml") SettingsFile <$>
  optional ( strOption ( long "settings-path"
                    <> metavar "FILEPATH"
                    <> help "Location of the gargantext-settings toml file"
                    ) )
