{-|
Module      : Gargantext.API.Context
Description : Server API
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# OPTIONS_GHC -fno-warn-orphans #-}

{-# LANGUAGE ScopedTypeVariables  #-}
{-# LANGUAGE TemplateHaskell      #-}
{-# LANGUAGE TypeOperators        #-}

module Gargantext.API.Context
  where

import Prelude

import Data.Aeson (FromJSON, ToJSON)
import Servant

import Gargantext.API.Admin.Auth (withNamedAccess)
import Gargantext.API.Admin.Auth.Types (PathId(..), AuthenticatedUser)
import Gargantext.API.Prelude
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Prelude (JSONB)
import Gargantext.Database.Query.Table.Context
import Servant.Server.Generic (AsServerT)
import Gargantext.API.Routes.Named.Context qualified as Named

-------------------------------------------------------------------
-- TODO use Context instead of Node
-- TODO NodeAPI -> ContextAPI
contextAPI :: ( IsGargServer env err m
              , JSONB a
              , FromJSON a
              , ToJSON a )
           => Proxy a
           -> AuthenticatedUser
           -> ContextId
           -> Named.ContextAPI a (AsServerT m)
contextAPI p uId id' =
  withNamedAccess uId (PathNode $ contextId2NodeId id') contextAPI'
  where
    contextAPI' = Named.ContextAPI $ getContextWith   id' p
