{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}
module Gargantext.API.Routes.Named.Annuaire (
  -- * Routes types
    AddAnnuaireWithForm(..)
  ) where

import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Node.Corpus.Annuaire (AnnuaireWithForm)
import Gargantext.Database.Admin.Types.Node
import Servant

newtype AddAnnuaireWithForm mode = AddAnnuaireWithForm
  { addWithFormEp :: mode :- Summary "Add with FormUrlEncoded to annuaire endpoint"
                          :> "annuaire"
                          :> Capture "annuaire_id" AnnuaireId
                          :> "add"
                          :> "form"
                          :> "async"
                          :> NamedRoutes (AsyncJobs JobLog '[FormUrlEncoded] AnnuaireWithForm JobLog)
  } deriving Generic
