{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}
module Gargantext.API.Routes.Named.Contact (
  -- * Routes types
    ContactAPI(..)
  , ContactAsyncAPI(..)

  -- * API types (appears in the routes)
  , AddContactParams(..)
  ) where


import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Node.Contact.Types (AddContactParams(..))
import Gargantext.API.Routes.Named.Node (NodeNodeAPI(..))
import Gargantext.Database.Admin.Types.Hyperdata.Contact
import Gargantext.Database.Admin.Types.Node
import Servant


data ContactAPI mode = ContactAPI
  { contactAsyncAPI :: mode :- "contact" :> Summary "Contact endpoint" :> NamedRoutes ContactAsyncAPI
  , getContactEp    :: mode :- Capture "contact_id" NodeId :> NamedRoutes (NodeNodeAPI HyperdataContact)
  } deriving Generic


newtype ContactAsyncAPI mode = ContactAsyncAPI
  { addContactAsyncEp :: mode :- NamedRoutes (AsyncJobs JobLog '[JSON] AddContactParams JobLog)
  } deriving Generic
