
module CLI.Types where

import Data.String
import Data.Text (Text)
import Gargantext.Core.Types.Query
import Prelude

newtype CorpusFile = CorpusFile { _CorpusFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype TermListFile = TermListFile { _TermsListFile :: FilePath }
  deriving (Show, Eq, IsString)

newtype OutputFile = OutputFile { _OutputFile :: FilePath }
  deriving (Show, Eq, IsString)

data ObfuscateDBArgs = ObfuscateDBArgs {
    dbHost     :: !Text
  , dbPort     :: !Int
  , dbName     :: !Text
  , dbUser     :: !Text
  , dbPassword :: !Text
  } deriving (Show, Eq)

data AdminArgs = AdminArgs
  { iniPath :: !FilePath
  , emails  :: [String]
  } deriving (Show, Eq)

data ImportFunction
  = IF_corpus
  | IF_corpusTsvHal
  | IF_annuaire
  deriving (Show, Eq, Enum, Bounded)

data ImportArgs = ImportArgs
  { imp_function :: !ImportFunction
  , imp_user     :: !Text
  , imp_name     :: !Text
  , imp_ini      :: !FilePath
  , imp_limit    :: !Limit
  , imp_corpus_path :: !FilePath
  } deriving (Show, Eq)

data InitArgs = InitArgs
  { init_ini :: !FilePath
  } deriving (Show, Eq)

data CLICmd
  = CCMD_clean_csv_corpus
  | CCMD_filter_terms_and_cooc !CorpusFile !TermListFile !OutputFile
  | CCMD_obfuscate_db !ObfuscateDBArgs
  | CCMD_admin !AdminArgs
  | CCMD_import !ImportArgs
  | CCMD_init !InitArgs
  deriving (Show, Eq)

data CLI =
  CLISub CLICmd
  deriving (Show, Eq)


