{-|
Module      : Main.hs
Description : Gargantext starter
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Main specifications to index a corpus with a term list

 -}

{-# LANGUAGE Strict             #-}
{-# LANGUAGE LambdaCase #-}
{-# LANGUAGE TypeApplications #-}

module Main where

import Prelude

import CLI.FilterTermsAndCooc
import CLI.ObfuscateDB (obfuscateDB, obfuscateDBCmd)
import CLI.Types
import Options.Applicative
import CLI.Admin (adminCLI, adminCmd)
import CLI.Import (importCLI, importCmd)
import CLI.Init (initCLI, initCmd)

runCLI :: CLI -> IO ()
runCLI = \case
  CLISub CCMD_clean_csv_corpus
    -> putStrLn "TODO."
  CLISub (CCMD_filter_terms_and_cooc corpusFile termListFile outputFile)
    -> filterTermsAndCoocCLI corpusFile termListFile outputFile
  CLISub (CCMD_obfuscate_db args)
    -> obfuscateDB args
  CLISub (CCMD_admin args)
    -> adminCLI args
  CLISub (CCMD_import args)
    -> importCLI args
  CLISub (CCMD_init args)
    -> initCLI args

main :: IO ()
main = runCLI =<< execParser opts
  where
    opts = info (helper <*> allOptions)
      ( fullDesc
     <> progDesc "CLI for the gargantext-server. Type --help for all the commands."
     <> header "gargantext-cli tools" )

allOptions :: Parser CLI
allOptions = subparser (
                 filterTermsAndCoocCmd <>
                 obfuscateDBCmd <>
                 adminCmd <>
                 importCmd <>
                 initCmd
                 )
