{-|
Module      : Main.hs
Description : GarganText Mailing Invitations
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX


 -}

{-# LANGUAGE Strict            #-}

module Main where

import Gargantext.API.Dev (withDevEnv, runCmdDev)
import Gargantext.API.Node () -- instances only
import Gargantext.API.Errors.Types
import Gargantext.API.Admin.Types
import Gargantext.Core.NLP (HasNLPServer)
import Gargantext.Core.Types.Individu (User(..))
import Gargantext.Database.Admin.Types.Node
import Gargantext.Database.Prelude (CmdRandom)
import Gargantext.Prelude
import Gargantext.Prelude.Config (readConfig)
import Prelude (read)
import Gargantext.API.Node.Share.Types qualified as Share
import Gargantext.API.Node.Share qualified as Share

main :: IO ()
main = do
  params@[iniPath,user,node_id,email] <- getArgs

  _ <- if length params /= 4
      then panicTrace "USAGE: ./gargantext-init gargantext.ini username node_id student@university.edu"
      else pure ()

  _cfg       <- readConfig         iniPath

  let invite :: (HasSettings env, CmdRandom env BackendInternalError m, HasNLPServer env) => m Int
      invite = Share.api (UserName $ cs user) (UnsafeMkNodeId $ (read node_id :: Int)) (Share.ShareTeamParams $ cs email)

  withDevEnv iniPath $ \env -> do
    _ <- runCmdDev env invite
    pure ()
