{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.Search (
  -- * Routes types
    SearchAPI(..)

  -- * API types (appears in the routes)
  , SearchType(..)
  , SearchQuery(..)
  , SearchResult(..)
  , SearchResultTypes(..)
  ) where


import GHC.Generics
import Gargantext.API.Search.Types ( SearchQuery(..), SearchType(..), SearchResult(..), SearchResultTypes(..) )
import Gargantext.Core.Types.Query (Limit, Offset)
import Gargantext.Database.Query.Facet
import Servant


-- TODO-ACCESS: CanSearch? or is it part of CanGetNode
-- TODO-EVENTS: No event, this is a read-only query.
newtype SearchAPI results mode = SearchAPI
  { searchEp :: mode :- Summary "Search endpoint"
                     :> ReqBody '[JSON] SearchQuery
                     :> QueryParam "offset" Offset
                     :> QueryParam "limit"  Limit
                     :> QueryParam "order"  OrderBy
                     :> Post '[JSON] results
  } deriving Generic
