
{-| Common parsers for the CLI. -}

module CLI.Parsers where

import Prelude
import Gargantext.API.Admin.Settings
import Options.Applicative

ini_p :: Parser IniFile
ini_p = maybe (IniFile "gargantext.ini") IniFile <$>
  optional ( strOption ( long "ini-path"
                    <> metavar "FILEPATH"
                    <> help "Location of the .ini file"
                    ) )

settings_p :: Parser SettingsFile
settings_p = maybe (SettingsFile "gargantext-settings.toml") SettingsFile <$>
  optional ( strOption ( long "settings-path"
                    <> metavar "FILEPATH"
                    <> help "Location of the gargantext-settings toml file"
                    ) )
