{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.EKG (
  -- * Routes types
  EkgAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Servant
import System.Metrics.Json qualified as J

-- Mimics https://github.com/tibbe/ekg/blob/master/System/Remote/Snap.hs#L98
newtype EkgAPI mode = EkgAPI
  { ekgAPI :: mode :- "ekg" :> ( "api" :> ( Get '[JSON] J.Sample :<|>
                                              CaptureAll "segments" Text :> Get '[JSON] J.Value
                                          ) :<|> Raw )
  } deriving Generic
