{--| Support in Gargantext for CORS (Cross-origin resource sharing) --}

{-# LANGUAGE TemplateHaskell   #-}
{-# LANGUAGE ViewPatterns      #-}

module Gargantext.Core.Config.CORS where

import Control.Monad.Fail (fail)
import Data.Text qualified as T
import Gargantext.Prelude
import Servant.Client.Core (BaseUrl, parseBaseUrl)
import Toml
import Toml.Schema

newtype CORSOrigin = CORSOrigin { _CORSOrigin :: BaseUrl }
  deriving (Show, Eq)

instance FromValue CORSOrigin where
  fromValue (Toml.Text' _ t) =
    case parseBaseUrl (T.unpack t) of
      Nothing -> fail $ "Cannot parse base url for: " <> T.unpack t
      Just b  -> return $ CORSOrigin b
  fromValue _ = fail "Incorrect key type, expected Text"

data CORSSettings =
  CORSSettings {
    _corsAllowedOrigins :: [CORSOrigin]
  , _corsAllowedHosts   :: [CORSOrigin]
  -- | If 'True', we will reuse the origin whitelist
  -- as the allowed hosts as well. This allows, for example,
  -- to connect from \"demo.gargantext.org\" to \"dev.sub.gargantext.org\"
  -- and vice-versa.
  , _corsUseOriginsForHosts :: !Bool
  } deriving (Show, Eq)

instance FromValue CORSSettings where
  fromValue = parseTableFromValue $ do
    _corsAllowedOrigins <- reqKey "allowed-origins"
    let _corsAllowedHosts = mempty
    _corsUseOriginsForHosts <- reqKey "use-origins-for-hosts"
    return $ CORSSettings { .. }

-- corsOriginCodec :: TomlBiMap CORSOrigin AnyValue
-- corsOriginCodec = _Orig >>> _Text
--   where
--    _Orig :: BiMap e CORSOrigin T.Text
--    _Orig = iso (T.pack . showBaseUrl . _CORSOrigin)
--                (\(T.unpack -> u) -> CORSOrigin . fromMaybe (error $ "invalid origin: " <> u) . parseBaseUrl $ u)

-- corsSettingsCodec :: TomlCodec CORSSettings
-- corsSettingsCodec = CORSSettings
--      <$> Toml.arrayOf corsOriginCodec "allowed-origins" .= _corsAllowedOrigins
--      <*> pure mempty -- FIXME(adn) Currently we don't need to support this field.
--      <*> Toml.bool "use-origins-for-hosts" .= _corsUseOriginsForHosts

makeLenses ''CORSSettings
