{-|
Module      : Gargantext.Core.Config.Database
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Gargantext.Core.Config.Database (
    TOMLConnectInfo(..)
  )
  where

import Database.PostgreSQL.Simple qualified as PGS
import Gargantext.Prelude
import Toml.Schema

newtype TOMLConnectInfo = TOMLConnectInfo { unTOMLConnectInfo :: PGS.ConnectInfo }
instance FromValue TOMLConnectInfo where
  fromValue = parseTableFromValue $ do
    host <- reqKey "host"
    port <- reqKey "port"
    user <- reqKey "user"
    password <- reqKey "pass"
    db <- reqKey "name"
    return $ TOMLConnectInfo $ PGS.ConnectInfo { PGS.connectHost = host
                                               , PGS.connectPort = port
                                               , PGS.connectUser = user
                                               , PGS.connectPassword = password
                                               , PGS.connectDatabase = db }

-- pgsCodec :: Toml.TomlCodec PGS.ConnectInfo
-- pgsCodec = PGS.ConnectInfo
--   <$> Toml.string "database.host" .= PGS.connectHost
--   <*> word16Toml "database.port" .= PGS.connectPort
--   <*> Toml.string "database.user" .= PGS.connectUser
--   <*> Toml.string "database.password" .= PGS.connectPassword
--   <*> Toml.string "database.name" .= PGS.connectDatabase
  
  -- ini <- readIniFile' fp
  -- let val' key = unpack $ val ini "database" key
  -- let dbPortRaw = val' "DB_PORT"
  -- let dbPort = case (readMaybe dbPortRaw :: Maybe Word16) of
  --       Nothing -> panicTrace $ "DB_PORT incorrect: " <> (pack dbPortRaw)
  --       Just d  -> d

  -- pure $ PGS.ConnectInfo { PGS.connectHost     = val' "DB_HOST"
  --                        , PGS.connectPort     = dbPort
  --                        , PGS.connectUser     = val' "DB_USER"
  --                        , PGS.connectPassword = val' "DB_PASS"
  --                        , PGS.connectDatabase = val' "DB_NAME"
  --                        }
