{-|
Module      : Gargantext.Core.Config.Frontend
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TemplateHaskell #-}

module Gargantext.Core.Config.Frontend (
  -- * Types
    FrontendConfig(..)
  )
  where

import Gargantext.Core.Config.CORS (CORSSettings)
import Gargantext.Core.Config.MicroServices (MicroServicesSettings)
import Gargantext.Prelude
import Toml.Schema


data FrontendConfig =
  FrontendConfig { _fc_url           :: !Text
                 , _fc_backend_name  :: !Text
                 , _fc_url_backend_api :: !Text
                 , _fc_jwt_settings  :: !Text
                 , _fc_cors          :: !CORSSettings
                 , _fc_microservices :: !MicroServicesSettings
               }
  deriving (Generic, Show)

instance FromValue FrontendConfig where
  fromValue = parseTableFromValue $ do
    _fc_url <- reqKey "url"
    _fc_backend_name <- reqKey "backend_name"
    _fc_url_backend_api <- reqKey "url_backend_api"
    _fc_jwt_settings <- reqKey "jwt_settings"
    _fc_cors <- reqKey "cors"
    _fc_microservices <- reqKey "microservices"
    return $ FrontendConfig { .. }
