{-|
Module      : Gargantext.Core.Config.MicroServices
Description :
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# LANGUAGE TemplateHaskell   #-}

module Gargantext.Core.Config.MicroServices where

import Control.Lens.TH
import Gargantext.Prelude
import Toml.Schema


data MicroServicesSettings =
  MicroServicesSettings {
    -- | The port where the microservices proxy will be listening on.
    _msProxyPort    :: !Int
  , _msProxyEnabled :: !Bool
  } deriving (Show, Eq)

instance FromValue MicroServicesSettings where
  fromValue = parseTableFromValue $ reqKeyOf "proxy" $ parseTableFromValue $ do
    _msProxyPort <- reqKey "port"
    _msProxyEnabled <- reqKey "enabled"
    return $ MicroServicesSettings { .. }


makeLenses ''MicroServicesSettings
