{-# LANGUAGE TypeOperators #-}

module Gargantext.API.Routes.Named.List (
  -- * Routes types
    GETAPI(..)
  , ListEndpoints(..)
  , JSONAPI(..)
  , TSVAPI(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Ngrams.List.Types
import Gargantext.API.Ngrams.Types
import Gargantext.API.Types (HTML)
import Gargantext.Database.Admin.Types.Node
import Gargantext.Utils.Servant qualified as GUS
import Servant

newtype GETAPI mode = GETAPI
  { getListEp :: mode :- Summary "Get List"
                      :> "lists"
                      :> Capture "listId" ListId
                      :> NamedRoutes ListEndpoints
  } deriving Generic

data ListEndpoints mode = ListEndpoints
  { listJSONEp :: mode :- "json"
                       :> Get '[JSON, HTML] (Headers '[Header "Content-Disposition" Text] NgramsList)
  , listJSONZipEp :: mode :- "json.zip"
                          :> Get '[GUS.ZIP] (Headers '[Header "Content-Disposition" Text] NgramsListZIP)
  , listTSVEp :: mode :- "tsv" :> Get '[GUS.TSV] (Headers '[Header "Content-Disposition" Text] NgramsTableMap)
  } deriving Generic

newtype JSONAPI mode = JSONAPI
  { updateListJSONEp :: mode :- Summary "Update List"
                             :> "lists"
                             :> Capture "listId" ListId
                             :> "add"
                             :> "form"
                             :> "async"
                             :> NamedRoutes (AsyncJobs JobLog '[FormUrlEncoded] WithJsonFile JobLog)
  } deriving Generic


newtype TSVAPI mode = TSVAPI
  { updateListTSVEp :: mode :- Summary "Update List (legacy v3 TSV)"
                            :> "lists"
                            :> Capture "listId" ListId
                            :> "tsv"
                            :> "add"
                            :> "form"
                            :> "async"
                            :> NamedRoutes (AsyncJobs JobLog '[FormUrlEncoded] WithTextFile JobLog)
  } deriving Generic
