{
  description = "Gargantext PureScript fronetnd";

  inputs.flake-utils.url = "github:numtide/flake-utils";

  inputs.nixpkgs.url = "github:NixOS/nixpkgs";

  inputs.purescript-overlay = {
    url = "github:thomashoneyman/purescript-overlay";
    inputs.nixpkgs.follows = "nixpkgs";
  };
  
  outputs = { self, nixpkgs, flake-utils, purescript-overlay }:
    flake-utils.lib.eachDefaultSystem (system:
      #let pkgs = nixpkgs.legacyPackages.${system};
      let
        pkgs = import nixpkgs {
          inherit system;
          overlays = builtins.attrValues { purescript = purescript-overlay.overlays.default; };
        };

        dependencies = with pkgs; [
          purs-bin.purs-0_15_16-1  # from the purescript-overlay
          spago-bin.spago-0_93_37
          #purescript
          #spago-unstable
          nodejs
          nodePackages.npm
        ];
    
      serve = pkgs.writeShellScriptBin "serve" ''
        set -e
    
        npm run server
    
      '';
    
      build-watch = pkgs.writeShellScriptBin "build-watch" ''
        set -e
    
        echo "Build watch"
        npm spago build -w --then browserify
      '';
    
      build-zephyr = pkgs.writeShellScriptBin "build-zephyr" ''
        set -e
    
        npm spago build --purs-args '--codegen corefn,js'
        zephyr -f Main.main
        browserify-zephyr
      '';
    
      minify-bundle = pkgs.writeShellScriptBin "minify-bundle" ''
        set -e
    
        npm run minify
      '';
    
      in
        {
          packages = rec {
            compile = pkgs.writeShellApplication {
              name = "compile";
              runtimeInputs = dependencies;
              text = ''
              set -e

              echo "Installing JS Dependencies"
              #npm install
              # https://docs.npmjs.com/cli/v9/commands/npm-ci
              #npm ci
              #npm/bin/npm install --dev
          
              echo "Compiling"
              npm run build
              '';
            };
            build = pkgs.writeShellApplication {
              name = "build";
              runtimeInputs = [ compile ] ++ dependencies;
              text = ''
              set -e

              # compile

              echo "Bundling"
              npm run bundle              
              '';
            };
            test-ps = pkgs.writeShellApplication {
              name = "test-ps";
              runtimeInputs = [ compile ] ++ dependencies;
              text = ''
              set -e
          
              compile
          
              echo "Testing"
              npm run test
            '';
            };    
            repl = pkgs.writeShellApplication {
              name = "repl";
              runtimeInputs = [ compile ] ++ dependencies;
              text = ''
          
              npm run repl
            '';
            };
            
            build-css = pkgs.writeShellApplication {
              name = "build-css";
              runtimeInputs = [ compile ] ++ dependencies;
              text = ''
              set -e
          
              npm run css
            '';
            };
          };
          
          devShells.default = pkgs.mkShell {
            name = "purescript-gargantext";
            #inputsFrom = builtins.attrValues self.packages.${system};
            buildInputs = with pkgs; (dependencies ++ [
              # scripts
              self.packages.${system}.build
              self.packages.${system}.build-css
              self.packages.${system}.compile
              self.packages.${system}.test-ps
              self.packages.${system}.repl

              build-watch
              build-zephyr
              minify-bundle
              serve
            ]);
          };
        }
    );
}
