{-|
Module      : Gargantext.Core.AsyncUpdates.Nanomsg
Description : Nanomsg utils
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

https://gitlab.iscpif.fr/gargantext/haskell-gargantext/issues/341

Docs:
https://dev.sub.gargantext.org/#/share/Notes/187918
    
-}

module Gargantext.Core.AsyncUpdates.Nanomsg where

import Gargantext.Prelude
import Nanomsg



withSafeSocket :: SocketType a => Text -> a -> (Socket a -> IO c) -> IO c
withSafeSocket socketName t =
  bracket onOpen onClose
  where
    onOpen = do
      s <- socket t
      setRcvBuf s 1
      setSndBuf s 1
      rcvBufInt <- rcvBuf s
      sndBufInt <- sndBuf s
      putText $ "[" <> socketName <> "] rcvBuf: " <> show rcvBufInt <> ", sndBuf: " <> show sndBufInt
      pure s
    onClose s = do
      close s
      panicTrace $ "[withSafeSocket] " <> socketName <> " closed"
