// Generated by purs bundle 0.14.2
var PS = {};
(function(exports) {
  /* global XMLHttpRequest */
  /* global process */
  "use strict";

  exports._ajax = function () {
    var platformSpecific = { };
    if (typeof module !== "undefined" && module.require && !(typeof process !== "undefined" && process.versions["electron"])) {
      // We are on node.js
      platformSpecific.newXHR = function () {
        var XHR = module.require("xhr2");
        return new XHR();
      };

      platformSpecific.fixupUrl = function (url, xhr) {
        if (xhr.nodejsBaseUrl === null) {
          var urllib = module.require("url");
          var u = urllib.parse(url);
          u.protocol = u.protocol || "http:";
          u.hostname = u.hostname || "localhost";
          return urllib.format(u);
        } else {
          return url || "/";
        }
      };

      platformSpecific.getResponse = function (xhr) {
        return xhr.response;
      };
    } else {
      // We are in the browser
      platformSpecific.newXHR = function () {
        return new XMLHttpRequest();
      };

      platformSpecific.fixupUrl = function (url) {
        return url || "/";
      };

      platformSpecific.getResponse = function (xhr) {
        return xhr.response;
      };
    }

    return function (timeoutErrorMessageIdent, requestFailedMessageIdent, mkHeader, options) {
      return function (errback, callback) {
        var xhr = platformSpecific.newXHR();
        var fixedUrl = platformSpecific.fixupUrl(options.url, xhr);
        xhr.open(options.method || "GET", fixedUrl, true, options.username, options.password);
        if (options.headers) {
          try {
            // eslint-disable-next-line no-eq-null,eqeqeq
            for (var i = 0, header; (header = options.headers[i]) != null; i++) {
              xhr.setRequestHeader(header.field, header.value);
            }
          } catch (e) {
            errback(e);
          }
        }
        var onerror = function (msgIdent) {
          return function () {
            errback(new Error(msgIdent));
          };
        };
        xhr.onerror = onerror(requestFailedMessageIdent);
        xhr.ontimeout = onerror(timeoutErrorMessageIdent);
        xhr.onload = function () {
          callback({
            status: xhr.status,
            statusText: xhr.statusText,
            headers: xhr.getAllResponseHeaders().split("\r\n")
              .filter(function (header) {
                return header.length > 0;
              })
              .map(function (header) {
                var i = header.indexOf(":");
                return mkHeader(header.substring(0, i))(header.substring(i + 2));
              }),
            body: platformSpecific.getResponse(xhr)
          });
        };
        xhr.responseType = options.responseType;
        xhr.withCredentials = options.withCredentials;
        xhr.timeout = options.timeout;
        xhr.send(options.content);

        return function (error, cancelErrback, cancelCallback) {
          try {
            xhr.abort();
          } catch (e) {
            return cancelErrback(e);
          }
          return cancelCallback();
        };
      };
    };
  }();
})(PS["Affjax"] = PS["Affjax"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Alt"] = $PS["Control.Alt"] || {};
  var exports = $PS["Control.Alt"];                          
  var Alt = function (Functor0, alt) {
      this.Functor0 = Functor0;
      this.alt = alt;
  };                                                       
  var alt = function (dict) {
      return dict.alt;
  };
  exports["Alt"] = Alt;
  exports["alt"] = alt;
})(PS);
(function(exports) {
  "use strict";

  exports.arrayApply = function (fs) {
    return function (xs) {
      var l = fs.length;
      var k = xs.length;
      var result = new Array(l*k);
      var n = 0;
      for (var i = 0; i < l; i++) {
        var f = fs[i];
        for (var j = 0; j < k; j++) {
          result[n++] = f(xs[j]);
        }
      }
      return result;
    };
  };
})(PS["Control.Apply"] = PS["Control.Apply"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Semigroupoid"] = $PS["Control.Semigroupoid"] || {};
  var exports = $PS["Control.Semigroupoid"];
  var Semigroupoid = function (compose) {
      this.compose = compose;
  };
  var semigroupoidFn = new Semigroupoid(function (f) {
      return function (g) {
          return function (x) {
              return f(g(x));
          };
      };
  });
  var compose = function (dict) {
      return dict.compose;
  };
  var composeFlipped = function (dictSemigroupoid) {
      return function (f) {
          return function (g) {
              return compose(dictSemigroupoid)(g)(f);
          };
      };
  };
  exports["compose"] = compose;
  exports["composeFlipped"] = composeFlipped;
  exports["semigroupoidFn"] = semigroupoidFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Category"] = $PS["Control.Category"] || {};
  var exports = $PS["Control.Category"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];                
  var Category = function (Semigroupoid0, identity) {
      this.Semigroupoid0 = Semigroupoid0;
      this.identity = identity;
  };
  var identity = function (dict) {
      return dict.identity;
  };
  var categoryFn = new Category(function () {
      return Control_Semigroupoid.semigroupoidFn;
  }, function (x) {
      return x;
  });
  exports["identity"] = identity;
  exports["categoryFn"] = categoryFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Function"] = $PS["Data.Function"] || {};
  var exports = $PS["Data.Function"];                    
  var on = function (f) {
      return function (g) {
          return function (x) {
              return function (y) {
                  return f(g(x))(g(y));
              };
          };
      };
  };
  var flip = function (f) {
      return function (b) {
          return function (a) {
              return f(a)(b);
          };
      };
  };
  var $$const = function (a) {
      return function (v) {
          return a;
      };
  };
  var applyFlipped = function (x) {
      return function (f) {
          return f(x);
      };
  };
  exports["flip"] = flip;
  exports["const"] = $$const;
  exports["applyFlipped"] = applyFlipped;
  exports["on"] = on;
})(PS);
(function(exports) {
  "use strict";

  exports.arrayMap = function (f) {
    return function (arr) {
      var l = arr.length;
      var result = new Array(l);
      for (var i = 0; i < l; i++) {
        result[i] = f(arr[i]);
      }
      return result;
    };
  };
})(PS["Data.Functor"] = PS["Data.Functor"] || {});
(function(exports) {
  "use strict";

  exports.unit = {};
})(PS["Data.Unit"] = PS["Data.Unit"] || {});
(function(exports) {
  "use strict";

  exports.showIntImpl = function (n) {
    return n.toString();
  };

  exports.showNumberImpl = function (n) {
    var str = n.toString();
    return isNaN(str + ".0") ? str : str + ".0";
  };

  exports.showCharImpl = function (c) {
    var code = c.charCodeAt(0);
    if (code < 0x20 || code === 0x7F) {
      switch (c) {
        case "\x07": return "'\\a'";
        case "\b": return "'\\b'";
        case "\f": return "'\\f'";
        case "\n": return "'\\n'";
        case "\r": return "'\\r'";
        case "\t": return "'\\t'";
        case "\v": return "'\\v'";
      }
      return "'\\" + code.toString(10) + "'";
    }
    return c === "'" || c === "\\" ? "'\\" + c + "'" : "'" + c + "'";
  };

  exports.showStringImpl = function (s) {
    var l = s.length;
    return "\"" + s.replace(
      /[\0-\x1F\x7F"\\]/g, // eslint-disable-line no-control-regex
      function (c, i) {
        switch (c) {
          case "\"":
          case "\\":
            return "\\" + c;
          case "\x07": return "\\a";
          case "\b": return "\\b";
          case "\f": return "\\f";
          case "\n": return "\\n";
          case "\r": return "\\r";
          case "\t": return "\\t";
          case "\v": return "\\v";
        }
        var k = i + 1;
        var empty = k < l && s[k] >= "0" && s[k] <= "9" ? "\\&" : "";
        return "\\" + c.charCodeAt(0).toString(10) + empty;
      }
    ) + "\"";
  };

  exports.showArrayImpl = function (f) {
    return function (xs) {
      var ss = [];
      for (var i = 0, l = xs.length; i < l; i++) {
        ss[i] = f(xs[i]);
      }
      return "[" + ss.join(",") + "]";
    };
  };

  exports.cons = function (head) {
    return function (tail) {
      return [head].concat(tail);
    };
  };

  exports.join = function (separator) {
    return function (xs) {
      return xs.join(separator);
    };
  };
})(PS["Data.Show"] = PS["Data.Show"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Symbol"] = $PS["Data.Symbol"] || {};
  var exports = $PS["Data.Symbol"];                  
  var SProxy = (function () {
      function SProxy() {

      };
      SProxy.value = new SProxy();
      return SProxy;
  })();
  var IsSymbol = function (reflectSymbol) {
      this.reflectSymbol = reflectSymbol;
  };
  var reflectSymbol = function (dict) {
      return dict.reflectSymbol;
  };
  exports["IsSymbol"] = IsSymbol;
  exports["reflectSymbol"] = reflectSymbol;
  exports["SProxy"] = SProxy;
})(PS);
(function(exports) {
  "use strict";

  exports.unsafeGet = function (label) {
    return function (rec) {
      return rec[label];
    };
  };

  exports.unsafeSet = function (label) {
    return function (value) {
      return function (rec) {
        var copy = {};
        for (var key in rec) {
          if ({}.hasOwnProperty.call(rec, key)) {
            copy[key] = rec[key];
          }
        }
        copy[label] = value;
        return copy;
      };
    };
  };

  exports.unsafeDelete = function (label) {
    return function (rec) {
      var copy = {};
      for (var key in rec) {
        if (key !== label && {}.hasOwnProperty.call(rec, key)) {
          copy[key] = rec[key];
        }
      }
      return copy;
    };
  };
})(PS["Record.Unsafe"] = PS["Record.Unsafe"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Record.Unsafe"] = $PS["Record.Unsafe"] || {};
  var exports = $PS["Record.Unsafe"];
  var $foreign = $PS["Record.Unsafe"];
  exports["unsafeGet"] = $foreign.unsafeGet;
  exports["unsafeSet"] = $foreign.unsafeSet;
  exports["unsafeDelete"] = $foreign.unsafeDelete;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Type.Proxy"] = $PS["Type.Proxy"] || {};
  var exports = $PS["Type.Proxy"];
  var $$Proxy = (function () {
      function $$Proxy() {

      };
      $$Proxy.value = new $$Proxy();
      return $$Proxy;
  })();
  exports["Proxy"] = $$Proxy;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Show"] = $PS["Data.Show"] || {};
  var exports = $PS["Data.Show"];
  var $foreign = $PS["Data.Show"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var ShowRecordFields = function (showRecordFields) {
      this.showRecordFields = showRecordFields;
  };
  var Show = function (show) {
      this.show = show;
  };
  var showString = new Show($foreign.showStringImpl);
  var showRecordFieldsNil = new ShowRecordFields(function (v) {
      return function (v1) {
          return [  ];
      };
  });
  var showRecordFields = function (dict) {
      return dict.showRecordFields;
  };
  var showRecord = function (dictRowToList) {
      return function (dictShowRecordFields) {
          return new Show(function (record) {
              var v = showRecordFields(dictShowRecordFields)(Type_Proxy["Proxy"].value)(record);
              if (v.length === 0) {
                  return "{}";
              };
              return $foreign.join(" ")([ "{", $foreign.join(", ")(v), "}" ]);
          });
      };
  }; 
  var showNumber = new Show($foreign.showNumberImpl);
  var showInt = new Show($foreign.showIntImpl);
  var showChar = new Show($foreign.showCharImpl);
  var show = function (dict) {
      return dict.show;
  };
  var showArray = function (dictShow) {
      return new Show($foreign.showArrayImpl(show(dictShow)));
  };
  var showRecordFieldsCons = function (dictIsSymbol) {
      return function (dictShowRecordFields) {
          return function (dictShow) {
              return new ShowRecordFields(function (v) {
                  return function (record) {
                      var tail = showRecordFields(dictShowRecordFields)(Type_Proxy["Proxy"].value)(record);
                      var key = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
                      var focus = Record_Unsafe.unsafeGet(key)(record);
                      return $foreign.cons($foreign.join(": ")([ key, show(dictShow)(focus) ]))(tail);
                  };
              });
          };
      };
  };
  exports["Show"] = Show;
  exports["show"] = show;
  exports["showInt"] = showInt;
  exports["showNumber"] = showNumber;
  exports["showChar"] = showChar;
  exports["showString"] = showString;
  exports["showArray"] = showArray;
  exports["showRecord"] = showRecord;
  exports["showRecordFieldsNil"] = showRecordFieldsNil;
  exports["showRecordFieldsCons"] = showRecordFieldsCons;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Unit"] = $PS["Data.Unit"] || {};
  var exports = $PS["Data.Unit"];
  var $foreign = $PS["Data.Unit"];
  var Data_Show = $PS["Data.Show"];                
  var showUnit = new Data_Show.Show(function (v) {
      return "unit";
  });
  exports["showUnit"] = showUnit;
  exports["unit"] = $foreign.unit;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Functor"] = $PS["Data.Functor"] || {};
  var exports = $PS["Data.Functor"];
  var $foreign = $PS["Data.Functor"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Function = $PS["Data.Function"];
  var Data_Unit = $PS["Data.Unit"];                  
  var Functor = function (map) {
      this.map = map;
  };
  var map = function (dict) {
      return dict.map;
  };
  var mapFlipped = function (dictFunctor) {
      return function (fa) {
          return function (f) {
              return map(dictFunctor)(f)(fa);
          };
      };
  };
  var $$void = function (dictFunctor) {
      return map(dictFunctor)(Data_Function["const"](Data_Unit.unit));
  };
  var voidLeft = function (dictFunctor) {
      return function (f) {
          return function (x) {
              return map(dictFunctor)(Data_Function["const"](x))(f);
          };
      };
  };
  var voidRight = function (dictFunctor) {
      return function (x) {
          return map(dictFunctor)(Data_Function["const"](x));
      };
  }; 
  var functorFn = new Functor(Control_Semigroupoid.compose(Control_Semigroupoid.semigroupoidFn));
  var functorArray = new Functor($foreign.arrayMap);
  exports["Functor"] = Functor;
  exports["map"] = map;
  exports["mapFlipped"] = mapFlipped;
  exports["void"] = $$void;
  exports["voidRight"] = voidRight;
  exports["voidLeft"] = voidLeft;
  exports["functorFn"] = functorFn;
  exports["functorArray"] = functorArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Apply"] = $PS["Control.Apply"] || {};
  var exports = $PS["Control.Apply"];
  var $foreign = $PS["Control.Apply"];
  var Control_Category = $PS["Control.Category"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];            
  var Apply = function (Functor0, apply) {
      this.Functor0 = Functor0;
      this.apply = apply;
  }; 
  var applyArray = new Apply(function () {
      return Data_Functor.functorArray;
  }, $foreign.arrayApply);
  var apply = function (dict) {
      return dict.apply;
  };
  var applyFirst = function (dictApply) {
      return function (a) {
          return function (b) {
              return apply(dictApply)(Data_Functor.map(dictApply.Functor0())(Data_Function["const"])(a))(b);
          };
      };
  };
  var applySecond = function (dictApply) {
      return function (a) {
          return function (b) {
              return apply(dictApply)(Data_Functor.map(dictApply.Functor0())(Data_Function["const"](Control_Category.identity(Control_Category.categoryFn)))(a))(b);
          };
      };
  };
  var lift2 = function (dictApply) {
      return function (f) {
          return function (a) {
              return function (b) {
                  return apply(dictApply)(Data_Functor.map(dictApply.Functor0())(f)(a))(b);
              };
          };
      };
  };
  exports["Apply"] = Apply;
  exports["apply"] = apply;
  exports["applyFirst"] = applyFirst;
  exports["applySecond"] = applySecond;
  exports["lift2"] = lift2;
  exports["applyArray"] = applyArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Applicative"] = $PS["Control.Applicative"] || {};
  var exports = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Unit = $PS["Data.Unit"];                  
  var Applicative = function (Apply0, pure) {
      this.Apply0 = Apply0;
      this.pure = pure;
  };
  var pure = function (dict) {
      return dict.pure;
  };
  var unless = function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (!v) {
                  return v1;
              };
              if (v) {
                  return pure(dictApplicative)(Data_Unit.unit);
              };
              throw new Error("Failed pattern match at Control.Applicative (line 66, column 1 - line 66, column 65): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };
  var when = function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (v) {
                  return v1;
              };
              if (!v) {
                  return pure(dictApplicative)(Data_Unit.unit);
              };
              throw new Error("Failed pattern match at Control.Applicative (line 61, column 1 - line 61, column 63): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };
  var liftA1 = function (dictApplicative) {
      return function (f) {
          return function (a) {
              return Control_Apply.apply(dictApplicative.Apply0())(pure(dictApplicative)(f))(a);
          };
      };
  }; 
  var applicativeArray = new Applicative(function () {
      return Control_Apply.applyArray;
  }, function (x) {
      return [ x ];
  });
  exports["Applicative"] = Applicative;
  exports["pure"] = pure;
  exports["liftA1"] = liftA1;
  exports["unless"] = unless;
  exports["when"] = when;
  exports["applicativeArray"] = applicativeArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Plus"] = $PS["Control.Plus"] || {};
  var exports = $PS["Control.Plus"];                     
  var Plus = function (Alt0, empty) {
      this.Alt0 = Alt0;
      this.empty = empty;
  };       
  var empty = function (dict) {
      return dict.empty;
  };
  exports["Plus"] = Plus;
  exports["empty"] = empty;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Alternative"] = $PS["Control.Alternative"] || {};
  var exports = $PS["Control.Alternative"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Plus = $PS["Control.Plus"];
  var Data_Unit = $PS["Data.Unit"];                
  var Alternative = function (Applicative0, Plus1) {
      this.Applicative0 = Applicative0;
      this.Plus1 = Plus1;
  };
  var guard = function (dictAlternative) {
      return function (v) {
          if (v) {
              return Control_Applicative.pure(dictAlternative.Applicative0())(Data_Unit.unit);
          };
          if (!v) {
              return Control_Plus.empty(dictAlternative.Plus1());
          };
          throw new Error("Failed pattern match at Control.Alternative (line 48, column 1 - line 48, column 54): " + [ v.constructor.name ]);
      };
  };
  exports["Alternative"] = Alternative;
  exports["guard"] = guard;
})(PS);
(function(exports) {
  "use strict";

  exports.arrayBind = function (arr) {
    return function (f) {
      var result = [];
      for (var i = 0, l = arr.length; i < l; i++) {
        Array.prototype.push.apply(result, f(arr[i]));
      }
      return result;
    };
  };
})(PS["Control.Bind"] = PS["Control.Bind"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Bind"] = $PS["Control.Bind"] || {};
  var exports = $PS["Control.Bind"];
  var $foreign = $PS["Control.Bind"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Category = $PS["Control.Category"];
  var Data_Function = $PS["Data.Function"];          
  var Bind = function (Apply0, bind) {
      this.Apply0 = Apply0;
      this.bind = bind;
  };
  var Discard = function (discard) {
      this.discard = discard;
  };
  var discard = function (dict) {
      return dict.discard;
  }; 
  var bindArray = new Bind(function () {
      return Control_Apply.applyArray;
  }, $foreign.arrayBind);
  var bind = function (dict) {
      return dict.bind;
  };
  var bindFlipped = function (dictBind) {
      return Data_Function.flip(bind(dictBind));
  };
  var composeKleisliFlipped = function (dictBind) {
      return function (f) {
          return function (g) {
              return function (a) {
                  return bindFlipped(dictBind)(f)(g(a));
              };
          };
      };
  }; 
  var discardUnit = new Discard(function (dictBind) {
      return bind(dictBind);
  });
  var join = function (dictBind) {
      return function (m) {
          return bind(dictBind)(m)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  exports["Bind"] = Bind;
  exports["bind"] = bind;
  exports["bindFlipped"] = bindFlipped;
  exports["discard"] = discard;
  exports["join"] = join;
  exports["composeKleisliFlipped"] = composeKleisliFlipped;
  exports["bindArray"] = bindArray;
  exports["discardUnit"] = discardUnit;
})(PS);
(function(exports) {
  "use strict";

  var refEq = function (r1) {
    return function (r2) {
      return r1 === r2;
    };
  };

  exports.eqBooleanImpl = refEq;
  exports.eqIntImpl = refEq;
  exports.eqNumberImpl = refEq;
  exports.eqCharImpl = refEq;
  exports.eqStringImpl = refEq;

  exports.eqArrayImpl = function (f) {
    return function (xs) {
      return function (ys) {
        if (xs.length !== ys.length) return false;
        for (var i = 0; i < xs.length; i++) {
          if (!f(xs[i])(ys[i])) return false;
        }
        return true;
      };
    };
  };
})(PS["Data.Eq"] = PS["Data.Eq"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Eq"] = $PS["Data.Eq"] || {};
  var exports = $PS["Data.Eq"];
  var $foreign = $PS["Data.Eq"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var EqRecord = function (eqRecord) {
      this.eqRecord = eqRecord;
  };
  var Eq = function (eq) {
      this.eq = eq;
  };
  var Eq1 = function (eq1) {
      this.eq1 = eq1;
  }; 
  var eqUnit = new Eq(function (v) {
      return function (v1) {
          return true;
      };
  });
  var eqString = new Eq($foreign.eqStringImpl);
  var eqRowNil = new EqRecord(function (v) {
      return function (v1) {
          return function (v2) {
              return true;
          };
      };
  });
  var eqRecord = function (dict) {
      return dict.eqRecord;
  };
  var eqRec = function (dictRowToList) {
      return function (dictEqRecord) {
          return new Eq(eqRecord(dictEqRecord)(Type_Proxy["Proxy"].value));
      };
  }; 
  var eqNumber = new Eq($foreign.eqNumberImpl);
  var eqInt = new Eq($foreign.eqIntImpl);
  var eqChar = new Eq($foreign.eqCharImpl);
  var eqBoolean = new Eq($foreign.eqBooleanImpl);
  var eq1 = function (dict) {
      return dict.eq1;
  };
  var eq = function (dict) {
      return dict.eq;
  };
  var eqArray = function (dictEq) {
      return new Eq($foreign.eqArrayImpl(eq(dictEq)));
  }; 
  var eqRowCons = function (dictEqRecord) {
      return function (dictCons) {
          return function (dictIsSymbol) {
              return function (dictEq) {
                  return new EqRecord(function (v) {
                      return function (ra) {
                          return function (rb) {
                              var tail = eqRecord(dictEqRecord)(Type_Proxy["Proxy"].value)(ra)(rb);
                              var key = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
                              var get = Record_Unsafe.unsafeGet(key);
                              return eq(dictEq)(get(ra))(get(rb)) && tail;
                          };
                      };
                  });
              };
          };
      };
  };
  var notEq = function (dictEq) {
      return function (x) {
          return function (y) {
              return eq(eqBoolean)(eq(dictEq)(x)(y))(false);
          };
      };
  };
  exports["Eq"] = Eq;
  exports["eq"] = eq;
  exports["notEq"] = notEq;
  exports["Eq1"] = Eq1;
  exports["eq1"] = eq1;
  exports["eqBoolean"] = eqBoolean;
  exports["eqInt"] = eqInt;
  exports["eqNumber"] = eqNumber;
  exports["eqChar"] = eqChar;
  exports["eqString"] = eqString;
  exports["eqUnit"] = eqUnit;
  exports["eqArray"] = eqArray;
  exports["eqRec"] = eqRec;
  exports["eqRowNil"] = eqRowNil;
  exports["eqRowCons"] = eqRowCons;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Maybe"] = $PS["Data.Maybe"] || {};
  var exports = $PS["Data.Maybe"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Alternative = $PS["Control.Alternative"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Category = $PS["Control.Category"];
  var Control_Plus = $PS["Control.Plus"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Show = $PS["Data.Show"];
  var Data_Unit = $PS["Data.Unit"];                
  var Nothing = (function () {
      function Nothing() {

      };
      Nothing.value = new Nothing();
      return Nothing;
  })();
  var Just = (function () {
      function Just(value0) {
          this.value0 = value0;
      };
      Just.create = function (value0) {
          return new Just(value0);
      };
      return Just;
  })();
  var showMaybe = function (dictShow) {
      return new Data_Show.Show(function (v) {
          if (v instanceof Just) {
              return "(Just " + (Data_Show.show(dictShow)(v.value0) + ")");
          };
          if (v instanceof Nothing) {
              return "Nothing";
          };
          throw new Error("Failed pattern match at Data.Maybe (line 216, column 1 - line 218, column 28): " + [ v.constructor.name ]);
      });
  };
  var maybe$prime = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Nothing) {
                  return v(Data_Unit.unit);
              };
              if (v2 instanceof Just) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Maybe (line 243, column 1 - line 243, column 62): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var maybe = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Nothing) {
                  return v;
              };
              if (v2 instanceof Just) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Maybe (line 230, column 1 - line 230, column 51): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var isNothing = maybe(true)(Data_Function["const"](false));
  var isJust = maybe(false)(Data_Function["const"](true));
  var functorMaybe = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Just) {
              return new Just(v(v1.value0));
          };
          return Nothing.value;
      };
  });                                                                                                   
  var fromMaybe$prime = function (a) {
      return maybe$prime(a)(Control_Category.identity(Control_Category.categoryFn));
  };
  var fromMaybe = function (a) {
      return maybe(a)(Control_Category.identity(Control_Category.categoryFn));
  };
  var fromJust = function (dictPartial) {
      return function (v) {
          if (v instanceof Just) {
              return v.value0;
          };
          throw new Error("Failed pattern match at Data.Maybe (line 281, column 1 - line 281, column 46): " + [ v.constructor.name ]);
      };
  }; 
  var eqMaybe = function (dictEq) {
      return new Data_Eq.Eq(function (x) {
          return function (y) {
              if (x instanceof Nothing && y instanceof Nothing) {
                  return true;
              };
              if (x instanceof Just && y instanceof Just) {
                  return Data_Eq.eq(dictEq)(x.value0)(y.value0);
              };
              return false;
          };
      });
  };
  var applyMaybe = new Control_Apply.Apply(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return Data_Functor.map(functorMaybe)(v.value0)(v1);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe (line 68, column 1 - line 70, column 30): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var bindMaybe = new Control_Bind.Bind(function () {
      return applyMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Just) {
              return v1(v.value0);
          };
          if (v instanceof Nothing) {
              return Nothing.value;
          };
          throw new Error("Failed pattern match at Data.Maybe (line 126, column 1 - line 128, column 28): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var applicativeMaybe = new Control_Applicative.Applicative(function () {
      return applyMaybe;
  }, Just.create);
  var altMaybe = new Control_Alt.Alt(function () {
      return functorMaybe;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nothing) {
              return v1;
          };
          return v;
      };
  });
  var plusMaybe = new Control_Plus.Plus(function () {
      return altMaybe;
  }, Nothing.value);
  var alternativeMaybe = new Control_Alternative.Alternative(function () {
      return applicativeMaybe;
  }, function () {
      return plusMaybe;
  });
  exports["Nothing"] = Nothing;
  exports["Just"] = Just;
  exports["maybe"] = maybe;
  exports["maybe'"] = maybe$prime;
  exports["fromMaybe"] = fromMaybe;
  exports["fromMaybe'"] = fromMaybe$prime;
  exports["isJust"] = isJust;
  exports["isNothing"] = isNothing;
  exports["fromJust"] = fromJust;
  exports["functorMaybe"] = functorMaybe;
  exports["applyMaybe"] = applyMaybe;
  exports["applicativeMaybe"] = applicativeMaybe;
  exports["alternativeMaybe"] = alternativeMaybe;
  exports["bindMaybe"] = bindMaybe;
  exports["eqMaybe"] = eqMaybe;
  exports["showMaybe"] = showMaybe;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.MediaType.Common"] = $PS["Data.MediaType.Common"] || {};
  var exports = $PS["Data.MediaType.Common"];          
  var applicationJSON = "application/json";
  var applicationFormURLEncoded = "application/x-www-form-urlencoded";
  exports["applicationFormURLEncoded"] = applicationFormURLEncoded;
  exports["applicationJSON"] = applicationJSON;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Affjax.RequestBody"] = $PS["Affjax.RequestBody"] || {};
  var exports = $PS["Affjax.RequestBody"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_MediaType_Common = $PS["Data.MediaType.Common"];                
  var ArrayView = (function () {
      function ArrayView(value0) {
          this.value0 = value0;
      };
      ArrayView.create = function (value0) {
          return new ArrayView(value0);
      };
      return ArrayView;
  })();
  var Blob = (function () {
      function Blob(value0) {
          this.value0 = value0;
      };
      Blob.create = function (value0) {
          return new Blob(value0);
      };
      return Blob;
  })();
  var Document = (function () {
      function Document(value0) {
          this.value0 = value0;
      };
      Document.create = function (value0) {
          return new Document(value0);
      };
      return Document;
  })();
  var $$String = (function () {
      function $$String(value0) {
          this.value0 = value0;
      };
      $$String.create = function (value0) {
          return new $$String(value0);
      };
      return $$String;
  })();
  var FormData = (function () {
      function FormData(value0) {
          this.value0 = value0;
      };
      FormData.create = function (value0) {
          return new FormData(value0);
      };
      return FormData;
  })();
  var FormURLEncoded = (function () {
      function FormURLEncoded(value0) {
          this.value0 = value0;
      };
      FormURLEncoded.create = function (value0) {
          return new FormURLEncoded(value0);
      };
      return FormURLEncoded;
  })();
  var Json = (function () {
      function Json(value0) {
          this.value0 = value0;
      };
      Json.create = function (value0) {
          return new Json(value0);
      };
      return Json;
  })();
  var toMediaType = function (v) {
      if (v instanceof FormURLEncoded) {
          return new Data_Maybe.Just(Data_MediaType_Common.applicationFormURLEncoded);
      };
      if (v instanceof Json) {
          return new Data_Maybe.Just(Data_MediaType_Common.applicationJSON);
      };
      return Data_Maybe.Nothing.value;
  };
  var string = $$String.create;
  var formURLEncoded = FormURLEncoded.create;
  exports["ArrayView"] = ArrayView;
  exports["Blob"] = Blob;
  exports["Document"] = Document;
  exports["String"] = $$String;
  exports["FormData"] = FormData;
  exports["FormURLEncoded"] = FormURLEncoded;
  exports["Json"] = Json;
  exports["string"] = string;
  exports["formURLEncoded"] = formURLEncoded;
  exports["toMediaType"] = toMediaType;
})(PS);
(function(exports) {
  "use strict";

  // module Unsafe.Coerce

  exports.unsafeCoerce = function (x) {
    return x;
  };
})(PS["Unsafe.Coerce"] = PS["Unsafe.Coerce"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Unsafe.Coerce"] = $PS["Unsafe.Coerce"] || {};
  var exports = $PS["Unsafe.Coerce"];
  var $foreign = $PS["Unsafe.Coerce"];
  exports["unsafeCoerce"] = $foreign.unsafeCoerce;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Safe.Coerce"] = $PS["Safe.Coerce"] || {};
  var exports = $PS["Safe.Coerce"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];                
  var coerce = function (dictCoercible) {
      return Unsafe_Coerce.unsafeCoerce;
  };
  exports["coerce"] = coerce;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Newtype"] = $PS["Data.Newtype"] || {};
  var exports = $PS["Data.Newtype"];
  var Safe_Coerce = $PS["Safe.Coerce"];
  var wrap = function (dictNewtype) {
      return Safe_Coerce.coerce();
  };
  var unwrap = function (dictNewtype) {
      return Safe_Coerce.coerce();
  };
  var under = function (dictNewtype) {
      return function (dictNewtype1) {
          return function (v) {
              return Safe_Coerce.coerce();
          };
      };
  };
  var un = function (dictNewtype) {
      return function (v) {
          return unwrap();
      };
  };
  var over = function (dictNewtype) {
      return function (dictNewtype1) {
          return function (v) {
              return Safe_Coerce.coerce();
          };
      };
  };
  var alaF = function (dictCoercible) {
      return function (dictCoercible1) {
          return function (dictNewtype) {
              return function (dictNewtype1) {
                  return function (v) {
                      return Safe_Coerce.coerce();
                  };
              };
          };
      };
  };
  exports["wrap"] = wrap;
  exports["unwrap"] = unwrap;
  exports["un"] = un;
  exports["alaF"] = alaF;
  exports["over"] = over;
  exports["under"] = under;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Affjax.RequestHeader"] = $PS["Affjax.RequestHeader"] || {};
  var exports = $PS["Affjax.RequestHeader"];
  var Data_Newtype = $PS["Data.Newtype"];          
  var Accept = (function () {
      function Accept(value0) {
          this.value0 = value0;
      };
      Accept.create = function (value0) {
          return new Accept(value0);
      };
      return Accept;
  })();
  var ContentType = (function () {
      function ContentType(value0) {
          this.value0 = value0;
      };
      ContentType.create = function (value0) {
          return new ContentType(value0);
      };
      return ContentType;
  })();
  var RequestHeader = (function () {
      function RequestHeader(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      RequestHeader.create = function (value0) {
          return function (value1) {
              return new RequestHeader(value0, value1);
          };
      };
      return RequestHeader;
  })();
  var value = function (v) {
      if (v instanceof Accept) {
          return Data_Newtype.unwrap()(v.value0);
      };
      if (v instanceof ContentType) {
          return Data_Newtype.unwrap()(v.value0);
      };
      if (v instanceof RequestHeader) {
          return v.value1;
      };
      throw new Error("Failed pattern match at Affjax.RequestHeader (line 26, column 1 - line 26, column 33): " + [ v.constructor.name ]);
  }; 
  var name = function (v) {
      if (v instanceof Accept) {
          return "Accept";
      };
      if (v instanceof ContentType) {
          return "Content-Type";
      };
      if (v instanceof RequestHeader) {
          return v.value0;
      };
      throw new Error("Failed pattern match at Affjax.RequestHeader (line 21, column 1 - line 21, column 32): " + [ v.constructor.name ]);
  };
  exports["Accept"] = Accept;
  exports["ContentType"] = ContentType;
  exports["RequestHeader"] = RequestHeader;
  exports["name"] = name;
  exports["value"] = value;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Affjax.ResponseFormat"] = $PS["Affjax.ResponseFormat"] || {};
  var exports = $PS["Affjax.ResponseFormat"];
  var Control_Category = $PS["Control.Category"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_MediaType_Common = $PS["Data.MediaType.Common"];                
  var $$ArrayBuffer = (function () {
      function $$ArrayBuffer(value0) {
          this.value0 = value0;
      };
      $$ArrayBuffer.create = function (value0) {
          return new $$ArrayBuffer(value0);
      };
      return $$ArrayBuffer;
  })();
  var Blob = (function () {
      function Blob(value0) {
          this.value0 = value0;
      };
      Blob.create = function (value0) {
          return new Blob(value0);
      };
      return Blob;
  })();
  var Document = (function () {
      function Document(value0) {
          this.value0 = value0;
      };
      Document.create = function (value0) {
          return new Document(value0);
      };
      return Document;
  })();
  var Json = (function () {
      function Json(value0) {
          this.value0 = value0;
      };
      Json.create = function (value0) {
          return new Json(value0);
      };
      return Json;
  })();
  var $$String = (function () {
      function $$String(value0) {
          this.value0 = value0;
      };
      $$String.create = function (value0) {
          return new $$String(value0);
      };
      return $$String;
  })();
  var Ignore = (function () {
      function Ignore(value0) {
          this.value0 = value0;
      };
      Ignore.create = function (value0) {
          return new Ignore(value0);
      };
      return Ignore;
  })();
  var toResponseType = function (v) {
      if (v instanceof $$ArrayBuffer) {
          return "arraybuffer";
      };
      if (v instanceof Blob) {
          return "blob";
      };
      if (v instanceof Document) {
          return "document";
      };
      if (v instanceof Json) {
          return "text";
      };
      if (v instanceof $$String) {
          return "text";
      };
      if (v instanceof Ignore) {
          return "";
      };
      throw new Error("Failed pattern match at Affjax.ResponseFormat (line 44, column 3 - line 50, column 19): " + [ v.constructor.name ]);
  };
  var toMediaType = function (v) {
      if (v instanceof Json) {
          return new Data_Maybe.Just(Data_MediaType_Common.applicationJSON);
      };
      return Data_Maybe.Nothing.value;
  };                                                                                
  var json = new Json(Control_Category.identity(Control_Category.categoryFn));
  var ignore = new Ignore(Control_Category.identity(Control_Category.categoryFn));
  exports["ArrayBuffer"] = $$ArrayBuffer;
  exports["Blob"] = Blob;
  exports["Document"] = Document;
  exports["Json"] = Json;
  exports["String"] = $$String;
  exports["Ignore"] = Ignore;
  exports["json"] = json;
  exports["ignore"] = ignore;
  exports["toResponseType"] = toResponseType;
  exports["toMediaType"] = toMediaType;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Affjax.ResponseHeader"] = $PS["Affjax.ResponseHeader"] || {};
  var exports = $PS["Affjax.ResponseHeader"];      
  var ResponseHeader = (function () {
      function ResponseHeader(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ResponseHeader.create = function (value0) {
          return function (value1) {
              return new ResponseHeader(value0, value1);
          };
      };
      return ResponseHeader;
  })();
  exports["ResponseHeader"] = ResponseHeader;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Either"] = $PS["Data.Either"] || {};
  var exports = $PS["Data.Either"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Unit = $PS["Data.Unit"];                
  var Left = (function () {
      function Left(value0) {
          this.value0 = value0;
      };
      Left.create = function (value0) {
          return new Left(value0);
      };
      return Left;
  })();
  var Right = (function () {
      function Right(value0) {
          this.value0 = value0;
      };
      Right.create = function (value0) {
          return new Right(value0);
      };
      return Right;
  })();
  var note = function (a) {
      return Data_Maybe.maybe(new Left(a))(Right.create);
  }; 
  var functorEither = new Data_Functor.Functor(function (f) {
      return function (m) {
          if (m instanceof Left) {
              return new Left(m.value0);
          };
          if (m instanceof Right) {
              return new Right(f(m.value0));
          };
          throw new Error("Failed pattern match at Data.Either (line 31, column 1 - line 31, column 52): " + [ m.constructor.name ]);
      };
  });                                                                                                     
  var fromRight$prime = function (v) {
      return function (v1) {
          if (v1 instanceof Right) {
              return v1.value0;
          };
          return v(Data_Unit.unit);
      };
  };
  var either = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Left) {
                  return v(v2.value0);
              };
              if (v2 instanceof Right) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Either (line 208, column 1 - line 208, column 64): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var hush = either(Data_Function["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create);
  var applyEither = new Control_Apply.Apply(function () {
      return functorEither;
  }, function (v) {
      return function (v1) {
          if (v instanceof Left) {
              return new Left(v.value0);
          };
          if (v instanceof Right) {
              return Data_Functor.map(functorEither)(v.value0)(v1);
          };
          throw new Error("Failed pattern match at Data.Either (line 70, column 1 - line 72, column 30): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var bindEither = new Control_Bind.Bind(function () {
      return applyEither;
  }, either(function (e) {
      return function (v) {
          return new Left(e);
      };
  })(function (a) {
      return function (f) {
          return f(a);
      };
  }));
  var applicativeEither = new Control_Applicative.Applicative(function () {
      return applyEither;
  }, Right.create);
  exports["Left"] = Left;
  exports["Right"] = Right;
  exports["either"] = either;
  exports["fromRight'"] = fromRight$prime;
  exports["note"] = note;
  exports["hush"] = hush;
  exports["functorEither"] = functorEither;
  exports["applicativeEither"] = applicativeEither;
  exports["bindEither"] = bindEither;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Error.Class"] = $PS["Control.Monad.Error.Class"] || {};
  var exports = $PS["Control.Monad.Error.Class"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Either = $PS["Data.Either"];
  var Data_Functor = $PS["Data.Functor"];                        
  var MonadThrow = function (Monad0, throwError) {
      this.Monad0 = Monad0;
      this.throwError = throwError;
  };
  var MonadError = function (MonadThrow0, catchError) {
      this.MonadThrow0 = MonadThrow0;
      this.catchError = catchError;
  };
  var throwError = function (dict) {
      return dict.throwError;
  };                                                      
  var catchError = function (dict) {
      return dict.catchError;
  };
  var $$try = function (dictMonadError) {
      return function (a) {
          return catchError(dictMonadError)(Data_Functor.map(((((dictMonadError.MonadThrow0()).Monad0()).Bind1()).Apply0()).Functor0())(Data_Either.Right.create)(a))((function () {
              var $17 = Control_Applicative.pure(((dictMonadError.MonadThrow0()).Monad0()).Applicative0());
              return function ($18) {
                  return $17(Data_Either.Left.create($18));
              };
          })());
      };
  };
  exports["throwError"] = throwError;
  exports["MonadThrow"] = MonadThrow;
  exports["MonadError"] = MonadError;
  exports["try"] = $$try;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad"] = $PS["Control.Monad"] || {};
  var exports = $PS["Control.Monad"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];                
  var Monad = function (Applicative0, Bind1) {
      this.Applicative0 = Applicative0;
      this.Bind1 = Bind1;
  };
  var ap = function (dictMonad) {
      return function (f) {
          return function (a) {
              return Control_Bind.bind(dictMonad.Bind1())(f)(function (f$prime) {
                  return Control_Bind.bind(dictMonad.Bind1())(a)(function (a$prime) {
                      return Control_Applicative.pure(dictMonad.Applicative0())(f$prime(a$prime));
                  });
              });
          };
      };
  };
  exports["Monad"] = Monad;
  exports["ap"] = ap;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Tuple"] = $PS["Data.Tuple"] || {};
  var exports = $PS["Data.Tuple"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Functor = $PS["Data.Functor"];          
  var Tuple = (function () {
      function Tuple(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Tuple.create = function (value0) {
          return function (value1) {
              return new Tuple(value0, value1);
          };
      };
      return Tuple;
  })();
  var uncurry = function (f) {
      return function (v) {
          return f(v.value0)(v.value1);
      };
  };
  var snd = function (v) {
      return v.value1;
  }; 
  var functorTuple = new Data_Functor.Functor(function (f) {
      return function (m) {
          return new Tuple(m.value0, f(m.value1));
      };
  });                                                                                                   
  var fst = function (v) {
      return v.value0;
  }; 
  var eqTuple = function (dictEq) {
      return function (dictEq1) {
          return new Data_Eq.Eq(function (x) {
              return function (y) {
                  return Data_Eq.eq(dictEq)(x.value0)(y.value0) && Data_Eq.eq(dictEq1)(x.value1)(y.value1);
              };
          });
      };
  };
  exports["Tuple"] = Tuple;
  exports["fst"] = fst;
  exports["snd"] = snd;
  exports["uncurry"] = uncurry;
  exports["eqTuple"] = eqTuple;
  exports["functorTuple"] = functorTuple;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.State.Class"] = $PS["Control.Monad.State.Class"] || {};
  var exports = $PS["Control.Monad.State.Class"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unit = $PS["Data.Unit"];                
  var MonadState = function (Monad0, state) {
      this.Monad0 = Monad0;
      this.state = state;
  };
  var state = function (dict) {
      return dict.state;
  };
  var put = function (dictMonadState) {
      return function (s) {
          return state(dictMonadState)(function (v) {
              return new Data_Tuple.Tuple(Data_Unit.unit, s);
          });
      };
  };
  var modify_ = function (dictMonadState) {
      return function (f) {
          return state(dictMonadState)(function (s) {
              return new Data_Tuple.Tuple(Data_Unit.unit, f(s));
          });
      };
  };
  var modify = function (dictMonadState) {
      return function (f) {
          return state(dictMonadState)(function (s) {
              var s$prime = f(s);
              return new Data_Tuple.Tuple(s$prime, s$prime);
          });
      };
  };
  var gets = function (dictMonadState) {
      return function (f) {
          return state(dictMonadState)(function (s) {
              return new Data_Tuple.Tuple(f(s), s);
          });
      };
  };
  var get = function (dictMonadState) {
      return state(dictMonadState)(function (s) {
          return new Data_Tuple.Tuple(s, s);
      });
  };
  exports["state"] = state;
  exports["MonadState"] = MonadState;
  exports["get"] = get;
  exports["gets"] = gets;
  exports["put"] = put;
  exports["modify"] = modify;
  exports["modify_"] = modify_;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Trans.Class"] = $PS["Control.Monad.Trans.Class"] || {};
  var exports = $PS["Control.Monad.Trans.Class"];
  var MonadTrans = function (lift) {
      this.lift = lift;
  };
  var lift = function (dict) {
      return dict.lift;
  };
  exports["lift"] = lift;
  exports["MonadTrans"] = MonadTrans;
})(PS);
(function(exports) {
  "use strict";

  exports.concatString = function (s1) {
    return function (s2) {
      return s1 + s2;
    };
  };

  exports.concatArray = function (xs) {
    return function (ys) {
      if (xs.length === 0) return ys;
      if (ys.length === 0) return xs;
      return xs.concat(ys);
    };
  };
})(PS["Data.Semigroup"] = PS["Data.Semigroup"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Semigroup"] = $PS["Data.Semigroup"] || {};
  var exports = $PS["Data.Semigroup"];
  var $foreign = $PS["Data.Semigroup"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Data_Unit = $PS["Data.Unit"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var SemigroupRecord = function (appendRecord) {
      this.appendRecord = appendRecord;
  };
  var Semigroup = function (append) {
      this.append = append;
  }; 
  var semigroupUnit = new Semigroup(function (v) {
      return function (v1) {
          return Data_Unit.unit;
      };
  });
  var semigroupString = new Semigroup($foreign.concatString);
  var semigroupRecordNil = new SemigroupRecord(function (v) {
      return function (v1) {
          return function (v2) {
              return {};
          };
      };
  });
  var semigroupArray = new Semigroup($foreign.concatArray);
  var appendRecord = function (dict) {
      return dict.appendRecord;
  };
  var semigroupRecord = function (dictRowToList) {
      return function (dictSemigroupRecord) {
          return new Semigroup(appendRecord(dictSemigroupRecord)(Type_Proxy["Proxy"].value));
      };
  };
  var append = function (dict) {
      return dict.append;
  };
  var semigroupFn = function (dictSemigroup) {
      return new Semigroup(function (f) {
          return function (g) {
              return function (x) {
                  return append(dictSemigroup)(f(x))(g(x));
              };
          };
      });
  };
  var semigroupRecordCons = function (dictIsSymbol) {
      return function (dictCons) {
          return function (dictSemigroupRecord) {
              return function (dictSemigroup) {
                  return new SemigroupRecord(function (v) {
                      return function (ra) {
                          return function (rb) {
                              var tail = appendRecord(dictSemigroupRecord)(Type_Proxy["Proxy"].value)(ra)(rb);
                              var key = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
                              var insert = Record_Unsafe.unsafeSet(key);
                              var get = Record_Unsafe.unsafeGet(key);
                              return insert(append(dictSemigroup)(get(ra))(get(rb)))(tail);
                          };
                      };
                  });
              };
          };
      };
  };
  exports["Semigroup"] = Semigroup;
  exports["append"] = append;
  exports["semigroupString"] = semigroupString;
  exports["semigroupUnit"] = semigroupUnit;
  exports["semigroupFn"] = semigroupFn;
  exports["semigroupArray"] = semigroupArray;
  exports["semigroupRecord"] = semigroupRecord;
  exports["semigroupRecordNil"] = semigroupRecordNil;
  exports["semigroupRecordCons"] = semigroupRecordCons;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Except.Trans"] = $PS["Control.Monad.Except.Trans"] || {};
  var exports = $PS["Control.Monad.Except.Trans"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Control_Monad_Error_Class = $PS["Control.Monad.Error.Class"];
  var Control_Monad_State_Class = $PS["Control.Monad.State.Class"];
  var Control_Monad_Trans_Class = $PS["Control.Monad.Trans.Class"];
  var Data_Either = $PS["Data.Either"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Semigroup = $PS["Data.Semigroup"];            
  var ExceptT = function (x) {
      return x;
  };
  var withExceptT = function (dictFunctor) {
      return function (f) {
          return function (v) {
              var mapLeft = function (v1) {
                  return function (v2) {
                      if (v2 instanceof Data_Either.Right) {
                          return new Data_Either.Right(v2.value0);
                      };
                      if (v2 instanceof Data_Either.Left) {
                          return new Data_Either.Left(v1(v2.value0));
                      };
                      throw new Error("Failed pattern match at Control.Monad.Except.Trans (line 43, column 3 - line 43, column 32): " + [ v1.constructor.name, v2.constructor.name ]);
                  };
              };
              return ExceptT(Data_Functor.map(dictFunctor)(mapLeft(f))(v));
          };
      };
  };
  var runExceptT = function (v) {
      return v;
  }; 
  var monadTransExceptT = new Control_Monad_Trans_Class.MonadTrans(function (dictMonad) {
      return function (m) {
          return Control_Bind.bind(dictMonad.Bind1())(m)(function (a) {
              return Control_Applicative.pure(dictMonad.Applicative0())(new Data_Either.Right(a));
          });
      };
  });
  var mapExceptT = function (f) {
      return function (v) {
          return f(v);
      };
  };
  var functorExceptT = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return mapExceptT(Data_Functor.map(dictFunctor)(Data_Functor.map(Data_Either.functorEither)(f)));
      });
  };
  var monadExceptT = function (dictMonad) {
      return new Control_Monad.Monad(function () {
          return applicativeExceptT(dictMonad);
      }, function () {
          return bindExceptT(dictMonad);
      });
  };
  var bindExceptT = function (dictMonad) {
      return new Control_Bind.Bind(function () {
          return applyExceptT(dictMonad);
      }, function (v) {
          return function (k) {
              return Control_Bind.bind(dictMonad.Bind1())(v)(Data_Either.either((function () {
                  var $91 = Control_Applicative.pure(dictMonad.Applicative0());
                  return function ($92) {
                      return $91(Data_Either.Left.create($92));
                  };
              })())(function (a) {
                  var v1 = k(a);
                  return v1;
              }));
          };
      });
  };
  var applyExceptT = function (dictMonad) {
      return new Control_Apply.Apply(function () {
          return functorExceptT(((dictMonad.Bind1()).Apply0()).Functor0());
      }, Control_Monad.ap(monadExceptT(dictMonad)));
  };
  var applicativeExceptT = function (dictMonad) {
      return new Control_Applicative.Applicative(function () {
          return applyExceptT(dictMonad);
      }, (function () {
          var $93 = Control_Applicative.pure(dictMonad.Applicative0());
          return function ($94) {
              return ExceptT($93(Data_Either.Right.create($94)));
          };
      })());
  };
  var monadStateExceptT = function (dictMonadState) {
      return new Control_Monad_State_Class.MonadState(function () {
          return monadExceptT(dictMonadState.Monad0());
      }, function (f) {
          return Control_Monad_Trans_Class.lift(monadTransExceptT)(dictMonadState.Monad0())(Control_Monad_State_Class.state(dictMonadState)(f));
      });
  };
  var monadThrowExceptT = function (dictMonad) {
      return new Control_Monad_Error_Class.MonadThrow(function () {
          return monadExceptT(dictMonad);
      }, (function () {
          var $103 = Control_Applicative.pure(dictMonad.Applicative0());
          return function ($104) {
              return ExceptT($103(Data_Either.Left.create($104)));
          };
      })());
  };
  var altExceptT = function (dictSemigroup) {
      return function (dictMonad) {
          return new Control_Alt.Alt(function () {
              return functorExceptT(((dictMonad.Bind1()).Apply0()).Functor0());
          }, function (v) {
              return function (v1) {
                  return Control_Bind.bind(dictMonad.Bind1())(v)(function (rm) {
                      if (rm instanceof Data_Either.Right) {
                          return Control_Applicative.pure(dictMonad.Applicative0())(new Data_Either.Right(rm.value0));
                      };
                      if (rm instanceof Data_Either.Left) {
                          return Control_Bind.bind(dictMonad.Bind1())(v1)(function (rn) {
                              if (rn instanceof Data_Either.Right) {
                                  return Control_Applicative.pure(dictMonad.Applicative0())(new Data_Either.Right(rn.value0));
                              };
                              if (rn instanceof Data_Either.Left) {
                                  return Control_Applicative.pure(dictMonad.Applicative0())(new Data_Either.Left(Data_Semigroup.append(dictSemigroup)(rm.value0)(rn.value0)));
                              };
                              throw new Error("Failed pattern match at Control.Monad.Except.Trans (line 87, column 9 - line 89, column 49): " + [ rn.constructor.name ]);
                          });
                      };
                      throw new Error("Failed pattern match at Control.Monad.Except.Trans (line 83, column 5 - line 89, column 49): " + [ rm.constructor.name ]);
                  });
              };
          });
      };
  };
  exports["ExceptT"] = ExceptT;
  exports["runExceptT"] = runExceptT;
  exports["withExceptT"] = withExceptT;
  exports["mapExceptT"] = mapExceptT;
  exports["functorExceptT"] = functorExceptT;
  exports["applyExceptT"] = applyExceptT;
  exports["applicativeExceptT"] = applicativeExceptT;
  exports["bindExceptT"] = bindExceptT;
  exports["altExceptT"] = altExceptT;
  exports["monadThrowExceptT"] = monadThrowExceptT;
  exports["monadStateExceptT"] = monadStateExceptT;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Identity"] = $PS["Data.Identity"] || {};
  var exports = $PS["Data.Identity"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Data_Functor = $PS["Data.Functor"];          
  var Identity = function (x) {
      return x;
  };
  var functorIdentity = new Data_Functor.Functor(function (f) {
      return function (m) {
          return f(m);
      };
  });
  var applyIdentity = new Control_Apply.Apply(function () {
      return functorIdentity;
  }, function (v) {
      return function (v1) {
          return v(v1);
      };
  });
  var bindIdentity = new Control_Bind.Bind(function () {
      return applyIdentity;
  }, function (v) {
      return function (f) {
          return f(v);
      };
  });
  var applicativeIdentity = new Control_Applicative.Applicative(function () {
      return applyIdentity;
  }, Identity);
  var monadIdentity = new Control_Monad.Monad(function () {
      return applicativeIdentity;
  }, function () {
      return bindIdentity;
  });
  exports["Identity"] = Identity;
  exports["functorIdentity"] = functorIdentity;
  exports["applicativeIdentity"] = applicativeIdentity;
  exports["bindIdentity"] = bindIdentity;
  exports["monadIdentity"] = monadIdentity;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Except"] = $PS["Control.Monad.Except"] || {};
  var exports = $PS["Control.Monad.Except"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_Newtype = $PS["Data.Newtype"];                
  var withExcept = Control_Monad_Except_Trans.withExceptT(Data_Identity.functorIdentity);
  var runExcept = (function () {
      var $0 = Data_Newtype.unwrap();
      return function ($1) {
          return $0(Control_Monad_Except_Trans.runExceptT($1));
      };
  })();
  exports["runExcept"] = runExcept;
  exports["withExcept"] = withExcept;
})(PS);
(function(exports) {
  /* eslint-disable no-eq-null, eqeqeq */
  "use strict";

  function id(x) {
    return x;
  }                      
  exports.fromObject = id;

  exports.stringify = function (j) {
    return JSON.stringify(j);
  };

  function isArray(a) {
    return Object.prototype.toString.call(a) === "[object Array]";
  }
})(PS["Data.Argonaut.Core"] = PS["Data.Argonaut.Core"] || {});
(function(exports) {
  "use strict";

  exports._copyST = function (m) {
    return function () {
      var r = {};
      for (var k in m) {
        if (hasOwnProperty.call(m, k)) {
          r[k] = m[k];
        }
      }
      return r;
    };
  };

  exports.empty = {};

  exports.runST = function (f) {
    return f();
  };

  exports._fmapObject = function (m0, f) {
    var m = {};
    for (var k in m0) {
      if (hasOwnProperty.call(m0, k)) {
        m[k] = f(m0[k]);
      }
    }
    return m;
  };

  exports._mapWithKey = function (m0, f) {
    var m = {};
    for (var k in m0) {
      if (hasOwnProperty.call(m0, k)) {
        m[k] = f(k)(m0[k]);
      }
    }
    return m;
  };

  exports._foldM = function (bind) {
    return function (f) {
      return function (mz) {
        return function (m) {
          var acc = mz;
          function g(k) {
            return function (z) {
              return f(z)(k)(m[k]);
            };
          }
          for (var k in m) {
            if (hasOwnProperty.call(m, k)) {
              acc = bind(acc)(g(k));
            }
          }
          return acc;
        };
      };
    };
  };

  function toArrayWithKey(f) {
    return function (m) {
      var r = [];
      for (var k in m) {
        if (hasOwnProperty.call(m, k)) {
          r.push(f(k)(m[k]));
        }
      }
      return r;
    };
  }

  exports.toArrayWithKey = toArrayWithKey;
})(PS["Foreign.Object"] = PS["Foreign.Object"] || {});
(function(exports) {
  "use strict";

  exports.map_ = function (f) {
    return function (a) {
      return function () {
        return f(a());
      };
    };
  };

  exports.pure_ = function (a) {
    return function () {
      return a;
    };
  };

  exports.bind_ = function (a) {
    return function (f) {
      return function () {
        return f(a())();
      };
    };
  };

  exports.foreach = function (as) {
    return function (f) {
      return function () {
        for (var i = 0, l = as.length; i < l; i++) {
          f(as[i])();
        }
      };
    };
  };
})(PS["Control.Monad.ST.Internal"] = PS["Control.Monad.ST.Internal"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.ST.Internal"] = $PS["Control.Monad.ST.Internal"] || {};
  var exports = $PS["Control.Monad.ST.Internal"];
  var $foreign = $PS["Control.Monad.ST.Internal"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Data_Functor = $PS["Data.Functor"];
  var functorST = new Data_Functor.Functor($foreign.map_);
  var monadST = new Control_Monad.Monad(function () {
      return applicativeST;
  }, function () {
      return bindST;
  });
  var bindST = new Control_Bind.Bind(function () {
      return applyST;
  }, $foreign.bind_);
  var applyST = new Control_Apply.Apply(function () {
      return functorST;
  }, Control_Monad.ap(monadST));
  var applicativeST = new Control_Applicative.Applicative(function () {
      return applyST;
  }, $foreign.pure_);
  exports["functorST"] = functorST;
  exports["applicativeST"] = applicativeST;
  exports["bindST"] = bindST;
  exports["monadST"] = monadST;
  exports["foreach"] = $foreign.foreach;
})(PS);
(function(exports) {
  "use strict";

  //------------------------------------------------------------------------------
  // Array creation --------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.range = function (start) {
    return function (end) {
      var step = start > end ? -1 : 1;
      var result = new Array(step * (end - start) + 1);
      var i = start, n = 0;
      while (i !== end) {
        result[n++] = i;
        i += step;
      }
      result[n] = i;
      return result;
    };
  };                                                                                                 

  exports.fromFoldableImpl = (function () {
    function Cons(head, tail) {
      this.head = head;
      this.tail = tail;
    }
    var emptyList = {};

    function curryCons(head) {
      return function (tail) {
        return new Cons(head, tail);
      };
    }

    function listToArray(list) {
      var result = [];
      var count = 0;
      var xs = list;
      while (xs !== emptyList) {
        result[count++] = xs.head;
        xs = xs.tail;
      }
      return result;
    }

    return function (foldr) {
      return function (xs) {
        return listToArray(foldr(curryCons)(emptyList)(xs));
      };
    };
  })();

  //------------------------------------------------------------------------------
  // Array size ------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.length = function (xs) {
    return xs.length;
  };

  //------------------------------------------------------------------------------
  // Non-indexed reads -----------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.unconsImpl = function (empty) {
    return function (next) {
      return function (xs) {
        return xs.length === 0 ? empty({}) : next(xs[0])(xs.slice(1));
      };
    };
  };

  //------------------------------------------------------------------------------
  // Indexed operations ----------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.indexImpl = function (just) {
    return function (nothing) {
      return function (xs) {
        return function (i) {
          return i < 0 || i >= xs.length ? nothing :  just(xs[i]);
        };
      };
    };
  };

  exports.findIndexImpl = function (just) {
    return function (nothing) {
      return function (f) {
        return function (xs) {
          for (var i = 0, l = xs.length; i < l; i++) {
            if (f(xs[i])) return just(i);
          }
          return nothing;
        };
      };
    };
  };

  exports._deleteAt = function (just) {
    return function (nothing) {
      return function (i) {
        return function (l) {
          if (i < 0 || i >= l.length) return nothing;
          var l1 = l.slice();
          l1.splice(i, 1);
          return just(l1);
        };
      };
    };
  };

  exports._updateAt = function (just) {
    return function (nothing) {
      return function (i) {
        return function (a) {
          return function (l) {
            if (i < 0 || i >= l.length) return nothing;
            var l1 = l.slice();
            l1[i] = a;
            return just(l1);
          };
        };
      };
    };
  };

  //------------------------------------------------------------------------------
  // Transformations -------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.reverse = function (l) {
    return l.slice().reverse();
  };

  exports.concat = function (xss) {
    if (xss.length <= 10000) {
      // This method is faster, but it crashes on big arrays.
      // So we use it when can and fallback to simple variant otherwise.
      return Array.prototype.concat.apply([], xss);
    }

    var result = [];
    for (var i = 0, l = xss.length; i < l; i++) {
      var xs = xss[i];
      for (var j = 0, m = xs.length; j < m; j++) {
        result.push(xs[j]);
      }
    }
    return result;
  };

  exports.filter = function (f) {
    return function (xs) {
      return xs.filter(f);
    };
  };

  //------------------------------------------------------------------------------
  // Sorting ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.sortByImpl = (function () {
    function mergeFromTo(compare, fromOrdering, xs1, xs2, from, to) {
      var mid;
      var i;
      var j;
      var k;
      var x;
      var y;
      var c;

      mid = from + ((to - from) >> 1);
      if (mid - from > 1) mergeFromTo(compare, fromOrdering, xs2, xs1, from, mid);
      if (to - mid > 1) mergeFromTo(compare, fromOrdering, xs2, xs1, mid, to);

      i = from;
      j = mid;
      k = from;
      while (i < mid && j < to) {
        x = xs2[i];
        y = xs2[j];
        c = fromOrdering(compare(x)(y));
        if (c > 0) {
          xs1[k++] = y;
          ++j;
        }
        else {
          xs1[k++] = x;
          ++i;
        }
      }
      while (i < mid) {
        xs1[k++] = xs2[i++];
      }
      while (j < to) {
        xs1[k++] = xs2[j++];
      }
    }

    return function (compare) {
      return function (fromOrdering) {
        return function (xs) {
          var out;

          if (xs.length < 2) return xs;

          out = xs.slice(0);
          mergeFromTo(compare, fromOrdering, out, xs.slice(0), 0, xs.length);

          return out;
        };
      };
    };
  })();

  //------------------------------------------------------------------------------
  // Subarrays -------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.slice = function (s) {
    return function (e) {
      return function (l) {
        return l.slice(s, e);
      };
    };
  };

  //------------------------------------------------------------------------------
  // Zipping ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.zipWith = function (f) {
    return function (xs) {
      return function (ys) {
        var l = xs.length < ys.length ? xs.length : ys.length;
        var result = new Array(l);
        for (var i = 0; i < l; i++) {
          result[i] = f(xs[i])(ys[i]);
        }
        return result;
      };
    };
  };

  //------------------------------------------------------------------------------
  // Partial ---------------------------------------------------------------------
  //------------------------------------------------------------------------------

  exports.unsafeIndexImpl = function (xs) {
    return function (n) {
      return xs[n];
    };
  };
})(PS["Data.Array"] = PS["Data.Array"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Lazy"] = $PS["Control.Lazy"] || {};
  var exports = $PS["Control.Lazy"];               
  var Lazy = function (defer) {
      this.defer = defer;
  }; 
  var defer = function (dict) {
      return dict.defer;
  };
  var fix = function (dictLazy) {
      return function (f) {
          var go = defer(dictLazy)(function (v) {
              return f(go);
          });
          return go;
      };
  };
  exports["defer"] = defer;
  exports["Lazy"] = Lazy;
  exports["fix"] = fix;
})(PS);
(function(exports) {
  "use strict";

  exports.poke = function (i) {
    return function (a) {
      return function (xs) {
        return function () {
          var ret = i >= 0 && i < xs.length;
          if (ret) xs[i] = a;
          return ret;
        };
      };
    };
  };

  exports.pushAll = function (as) {
    return function (xs) {
      return function () {
        return xs.push.apply(xs, as);
      };
    };
  };

  exports.unsafeFreeze = function (xs) {
    return function () {
      return xs;
    };
  };

  function copyImpl(xs) {
    return function () {
      return xs.slice();
    };
  }                         

  exports.thaw = copyImpl;
})(PS["Data.Array.ST"] = PS["Data.Array.ST"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Array.ST"] = $PS["Data.Array.ST"] || {};
  var exports = $PS["Data.Array.ST"];
  var $foreign = $PS["Data.Array.ST"];                     
  var withArray = function (f) {
      return function (xs) {
          return function __do() {
              var result = $foreign.thaw(xs)();
              f(result)();
              return $foreign.unsafeFreeze(result)();
          };
      };
  };
  var push = function (a) {
      return $foreign.pushAll([ a ]);
  };
  exports["withArray"] = withArray;
  exports["push"] = push;
  exports["poke"] = $foreign.poke;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Boolean"] = $PS["Data.Boolean"] || {};
  var exports = $PS["Data.Boolean"];
  var otherwise = true;
  exports["otherwise"] = otherwise;
})(PS);
(function(exports) {
  "use strict";

  exports.foldrArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = len - 1; i >= 0; i--) {
          acc = f(xs[i])(acc);
        }
        return acc;
      };
    };
  };

  exports.foldlArray = function (f) {
    return function (init) {
      return function (xs) {
        var acc = init;
        var len = xs.length;
        for (var i = 0; i < len; i++) {
          acc = f(acc)(xs[i]);
        }
        return acc;
      };
    };
  };
})(PS["Data.Foldable"] = PS["Data.Foldable"] || {});
(function(exports) {
  "use strict";

  exports.boolConj = function (b1) {
    return function (b2) {
      return b1 && b2;
    };
  };

  exports.boolDisj = function (b1) {
    return function (b2) {
      return b1 || b2;
    };
  };

  exports.boolNot = function (b) {
    return !b;
  };
})(PS["Data.HeytingAlgebra"] = PS["Data.HeytingAlgebra"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.HeytingAlgebra"] = $PS["Data.HeytingAlgebra"] || {};
  var exports = $PS["Data.HeytingAlgebra"];
  var $foreign = $PS["Data.HeytingAlgebra"];
  var HeytingAlgebra = function (conj, disj, ff, implies, not, tt) {
      this.conj = conj;
      this.disj = disj;
      this.ff = ff;
      this.implies = implies;
      this.not = not;
      this.tt = tt;
  };
  var tt = function (dict) {
      return dict.tt;
  };
  var not = function (dict) {
      return dict.not;
  };
  var implies = function (dict) {
      return dict.implies;
  };
  var ff = function (dict) {
      return dict.ff;
  };
  var disj = function (dict) {
      return dict.disj;
  };
  var heytingAlgebraBoolean = new HeytingAlgebra($foreign.boolConj, $foreign.boolDisj, false, function (a) {
      return function (b) {
          return disj(heytingAlgebraBoolean)(not(heytingAlgebraBoolean)(a))(b);
      };
  }, $foreign.boolNot, true);
  var conj = function (dict) {
      return dict.conj;
  };
  var heytingAlgebraFunction = function (dictHeytingAlgebra) {
      return new HeytingAlgebra(function (f) {
          return function (g) {
              return function (a) {
                  return conj(dictHeytingAlgebra)(f(a))(g(a));
              };
          };
      }, function (f) {
          return function (g) {
              return function (a) {
                  return disj(dictHeytingAlgebra)(f(a))(g(a));
              };
          };
      }, function (v) {
          return ff(dictHeytingAlgebra);
      }, function (f) {
          return function (g) {
              return function (a) {
                  return implies(dictHeytingAlgebra)(f(a))(g(a));
              };
          };
      }, function (f) {
          return function (a) {
              return not(dictHeytingAlgebra)(f(a));
          };
      }, function (v) {
          return tt(dictHeytingAlgebra);
      });
  };
  exports["tt"] = tt;
  exports["ff"] = ff;
  exports["conj"] = conj;
  exports["disj"] = disj;
  exports["not"] = not;
  exports["heytingAlgebraBoolean"] = heytingAlgebraBoolean;
  exports["heytingAlgebraFunction"] = heytingAlgebraFunction;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Monoid"] = $PS["Data.Monoid"] || {};
  var exports = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Data_Unit = $PS["Data.Unit"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var MonoidRecord = function (SemigroupRecord0, memptyRecord) {
      this.SemigroupRecord0 = SemigroupRecord0;
      this.memptyRecord = memptyRecord;
  };
  var Monoid = function (Semigroup0, mempty) {
      this.Semigroup0 = Semigroup0;
      this.mempty = mempty;
  };
  var monoidUnit = new Monoid(function () {
      return Data_Semigroup.semigroupUnit;
  }, Data_Unit.unit);
  var monoidString = new Monoid(function () {
      return Data_Semigroup.semigroupString;
  }, "");
  var monoidRecordNil = new MonoidRecord(function () {
      return Data_Semigroup.semigroupRecordNil;
  }, function (v) {
      return {};
  });                        
  var monoidArray = new Monoid(function () {
      return Data_Semigroup.semigroupArray;
  }, [  ]);
  var memptyRecord = function (dict) {
      return dict.memptyRecord;
  };
  var monoidRecord = function (dictRowToList) {
      return function (dictMonoidRecord) {
          return new Monoid(function () {
              return Data_Semigroup.semigroupRecord()(dictMonoidRecord.SemigroupRecord0());
          }, memptyRecord(dictMonoidRecord)(Type_Proxy["Proxy"].value));
      };
  };
  var mempty = function (dict) {
      return dict.mempty;
  };
  var monoidFn = function (dictMonoid) {
      return new Monoid(function () {
          return Data_Semigroup.semigroupFn(dictMonoid.Semigroup0());
      }, function (v) {
          return mempty(dictMonoid);
      });
  };
  var monoidRecordCons = function (dictIsSymbol) {
      return function (dictMonoid) {
          return function (dictCons) {
              return function (dictMonoidRecord) {
                  return new MonoidRecord(function () {
                      return Data_Semigroup.semigroupRecordCons(dictIsSymbol)()(dictMonoidRecord.SemigroupRecord0())(dictMonoid.Semigroup0());
                  }, function (v) {
                      var tail = memptyRecord(dictMonoidRecord)(Type_Proxy["Proxy"].value);
                      var key = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
                      var insert = Record_Unsafe.unsafeSet(key);
                      return insert(mempty(dictMonoid))(tail);
                  });
              };
          };
      };
  };
  exports["Monoid"] = Monoid;
  exports["mempty"] = mempty;
  exports["monoidUnit"] = monoidUnit;
  exports["monoidFn"] = monoidFn;
  exports["monoidString"] = monoidString;
  exports["monoidArray"] = monoidArray;
  exports["monoidRecord"] = monoidRecord;
  exports["monoidRecordNil"] = monoidRecordNil;
  exports["monoidRecordCons"] = monoidRecordCons;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Monoid.Conj"] = $PS["Data.Monoid.Conj"] || {};
  var exports = $PS["Data.Monoid.Conj"];
  var Data_HeytingAlgebra = $PS["Data.HeytingAlgebra"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];      
  var Conj = function (x) {
      return x;
  };
  var semigroupConj = function (dictHeytingAlgebra) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Data_HeytingAlgebra.conj(dictHeytingAlgebra)(v)(v1);
          };
      });
  };
  var monoidConj = function (dictHeytingAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupConj(dictHeytingAlgebra);
      }, Data_HeytingAlgebra.tt(dictHeytingAlgebra));
  };
  exports["Conj"] = Conj;
  exports["monoidConj"] = monoidConj;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Monoid.Disj"] = $PS["Data.Monoid.Disj"] || {};
  var exports = $PS["Data.Monoid.Disj"];
  var Data_HeytingAlgebra = $PS["Data.HeytingAlgebra"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];      
  var Disj = function (x) {
      return x;
  };
  var semigroupDisj = function (dictHeytingAlgebra) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Data_HeytingAlgebra.disj(dictHeytingAlgebra)(v)(v1);
          };
      });
  };
  var monoidDisj = function (dictHeytingAlgebra) {
      return new Data_Monoid.Monoid(function () {
          return semigroupDisj(dictHeytingAlgebra);
      }, Data_HeytingAlgebra.ff(dictHeytingAlgebra));
  };
  exports["Disj"] = Disj;
  exports["monoidDisj"] = monoidDisj;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Monoid.Endo"] = $PS["Data.Monoid.Endo"] || {};
  var exports = $PS["Data.Monoid.Endo"];
  var Control_Category = $PS["Control.Category"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];      
  var Endo = function (x) {
      return x;
  };
  var semigroupEndo = function (dictSemigroupoid) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Control_Semigroupoid.compose(dictSemigroupoid)(v)(v1);
          };
      });
  };
  var monoidEndo = function (dictCategory) {
      return new Data_Monoid.Monoid(function () {
          return semigroupEndo(dictCategory.Semigroupoid0());
      }, Control_Category.identity(dictCategory));
  };
  exports["Endo"] = Endo;
  exports["monoidEndo"] = monoidEndo;
})(PS);
(function(exports) {
  "use strict";

  var unsafeCompareImpl = function (lt) {
    return function (eq) {
      return function (gt) {
        return function (x) {
          return function (y) {
            return x < y ? lt : x === y ? eq : gt;
          };
        };
      };
    };
  };

  exports.ordBooleanImpl = unsafeCompareImpl;
  exports.ordIntImpl = unsafeCompareImpl;
  exports.ordNumberImpl = unsafeCompareImpl;
  exports.ordStringImpl = unsafeCompareImpl;
  exports.ordCharImpl = unsafeCompareImpl;
})(PS["Data.Ord"] = PS["Data.Ord"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Ordering"] = $PS["Data.Ordering"] || {};
  var exports = $PS["Data.Ordering"];
  var Data_Eq = $PS["Data.Eq"];                    
  var LT = (function () {
      function LT() {

      };
      LT.value = new LT();
      return LT;
  })();
  var GT = (function () {
      function GT() {

      };
      GT.value = new GT();
      return GT;
  })();
  var EQ = (function () {
      function EQ() {

      };
      EQ.value = new EQ();
      return EQ;
  })();
  var invert = function (v) {
      if (v instanceof GT) {
          return LT.value;
      };
      if (v instanceof EQ) {
          return EQ.value;
      };
      if (v instanceof LT) {
          return GT.value;
      };
      throw new Error("Failed pattern match at Data.Ordering (line 33, column 1 - line 33, column 31): " + [ v.constructor.name ]);
  };
  var eqOrdering = new Data_Eq.Eq(function (v) {
      return function (v1) {
          if (v instanceof LT && v1 instanceof LT) {
              return true;
          };
          if (v instanceof GT && v1 instanceof GT) {
              return true;
          };
          if (v instanceof EQ && v1 instanceof EQ) {
              return true;
          };
          return false;
      };
  });
  exports["LT"] = LT;
  exports["GT"] = GT;
  exports["EQ"] = EQ;
  exports["invert"] = invert;
  exports["eqOrdering"] = eqOrdering;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Ord"] = $PS["Data.Ord"] || {};
  var exports = $PS["Data.Ord"];
  var $foreign = $PS["Data.Ord"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var OrdRecord = function (EqRecord0, compareRecord) {
      this.EqRecord0 = EqRecord0;
      this.compareRecord = compareRecord;
  };
  var Ord = function (Eq0, compare) {
      this.Eq0 = Eq0;
      this.compare = compare;
  }; 
  var ordString = new Ord(function () {
      return Data_Eq.eqString;
  }, $foreign.ordStringImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var ordRecordNil = new OrdRecord(function () {
      return Data_Eq.eqRowNil;
  }, function (v) {
      return function (v1) {
          return function (v2) {
              return Data_Ordering.EQ.value;
          };
      };
  });
  var ordNumber = new Ord(function () {
      return Data_Eq.eqNumber;
  }, $foreign.ordNumberImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var ordInt = new Ord(function () {
      return Data_Eq.eqInt;
  }, $foreign.ordIntImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var ordChar = new Ord(function () {
      return Data_Eq.eqChar;
  }, $foreign.ordCharImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var ordBoolean = new Ord(function () {
      return Data_Eq.eqBoolean;
  }, $foreign.ordBooleanImpl(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var compareRecord = function (dict) {
      return dict.compareRecord;
  };
  var ordRecord = function (dictRowToList) {
      return function (dictOrdRecord) {
          return new Ord(function () {
              return Data_Eq.eqRec()(dictOrdRecord.EqRecord0());
          }, compareRecord(dictOrdRecord)(Type_Proxy["Proxy"].value));
      };
  };
  var compare = function (dict) {
      return dict.compare;
  };
  var comparing = function (dictOrd) {
      return function (f) {
          return function (x) {
              return function (y) {
                  return compare(dictOrd)(f(x))(f(y));
              };
          };
      };
  };
  var greaterThan = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var v = compare(dictOrd)(a1)(a2);
              if (v instanceof Data_Ordering.GT) {
                  return true;
              };
              return false;
          };
      };
  };
  var greaterThanOrEq = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var v = compare(dictOrd)(a1)(a2);
              if (v instanceof Data_Ordering.LT) {
                  return false;
              };
              return true;
          };
      };
  };
  var lessThan = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var v = compare(dictOrd)(a1)(a2);
              if (v instanceof Data_Ordering.LT) {
                  return true;
              };
              return false;
          };
      };
  };
  var lessThanOrEq = function (dictOrd) {
      return function (a1) {
          return function (a2) {
              var v = compare(dictOrd)(a1)(a2);
              if (v instanceof Data_Ordering.GT) {
                  return false;
              };
              return true;
          };
      };
  };
  var max = function (dictOrd) {
      return function (x) {
          return function (y) {
              var v = compare(dictOrd)(x)(y);
              if (v instanceof Data_Ordering.LT) {
                  return y;
              };
              if (v instanceof Data_Ordering.EQ) {
                  return x;
              };
              if (v instanceof Data_Ordering.GT) {
                  return x;
              };
              throw new Error("Failed pattern match at Data.Ord (line 176, column 3 - line 179, column 12): " + [ v.constructor.name ]);
          };
      };
  };
  var min = function (dictOrd) {
      return function (x) {
          return function (y) {
              var v = compare(dictOrd)(x)(y);
              if (v instanceof Data_Ordering.LT) {
                  return x;
              };
              if (v instanceof Data_Ordering.EQ) {
                  return x;
              };
              if (v instanceof Data_Ordering.GT) {
                  return y;
              };
              throw new Error("Failed pattern match at Data.Ord (line 167, column 3 - line 170, column 12): " + [ v.constructor.name ]);
          };
      };
  }; 
  var ordRecordCons = function (dictOrdRecord) {
      return function (dictCons) {
          return function (dictIsSymbol) {
              return function (dictOrd) {
                  return new OrdRecord(function () {
                      return Data_Eq.eqRowCons(dictOrdRecord.EqRecord0())()(dictIsSymbol)(dictOrd.Eq0());
                  }, function (v) {
                      return function (ra) {
                          return function (rb) {
                              var key = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
                              var left = compare(dictOrd)(Record_Unsafe.unsafeGet(key)(ra))(Record_Unsafe.unsafeGet(key)(rb));
                              var $55 = Data_Eq.notEq(Data_Ordering.eqOrdering)(left)(Data_Ordering.EQ.value);
                              if ($55) {
                                  return left;
                              };
                              return compareRecord(dictOrdRecord)(Type_Proxy["Proxy"].value)(ra)(rb);
                          };
                      };
                  });
              };
          };
      };
  };
  var clamp = function (dictOrd) {
      return function (low) {
          return function (hi) {
              return function (x) {
                  return min(dictOrd)(hi)(max(dictOrd)(low)(x));
              };
          };
      };
  };
  var between = function (dictOrd) {
      return function (low) {
          return function (hi) {
              return function (x) {
                  if (lessThan(dictOrd)(x)(low)) {
                      return false;
                  };
                  if (greaterThan(dictOrd)(x)(hi)) {
                      return false;
                  };
                  return true;
              };
          };
      };
  };
  exports["Ord"] = Ord;
  exports["compare"] = compare;
  exports["lessThan"] = lessThan;
  exports["lessThanOrEq"] = lessThanOrEq;
  exports["greaterThanOrEq"] = greaterThanOrEq;
  exports["comparing"] = comparing;
  exports["min"] = min;
  exports["max"] = max;
  exports["clamp"] = clamp;
  exports["between"] = between;
  exports["ordBoolean"] = ordBoolean;
  exports["ordInt"] = ordInt;
  exports["ordNumber"] = ordNumber;
  exports["ordString"] = ordString;
  exports["ordChar"] = ordChar;
  exports["ordRecordNil"] = ordRecordNil;
  exports["ordRecordCons"] = ordRecordCons;
  exports["ordRecord"] = ordRecord;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Foldable"] = $PS["Data.Foldable"] || {};
  var exports = $PS["Data.Foldable"];
  var $foreign = $PS["Data.Foldable"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Category = $PS["Control.Category"];
  var Control_Plus = $PS["Control.Plus"];
  var Data_Either = $PS["Data.Either"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_HeytingAlgebra = $PS["Data.HeytingAlgebra"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Monoid_Conj = $PS["Data.Monoid.Conj"];
  var Data_Monoid_Disj = $PS["Data.Monoid.Disj"];
  var Data_Monoid_Endo = $PS["Data.Monoid.Endo"];
  var Data_Newtype = $PS["Data.Newtype"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Unit = $PS["Data.Unit"];                
  var Foldable = function (foldMap, foldl, foldr) {
      this.foldMap = foldMap;
      this.foldl = foldl;
      this.foldr = foldr;
  };
  var foldr = function (dict) {
      return dict.foldr;
  };
  var oneOf = function (dictFoldable) {
      return function (dictPlus) {
          return foldr(dictFoldable)(Control_Alt.alt(dictPlus.Alt0()))(Control_Plus.empty(dictPlus));
      };
  };
  var traverse_ = function (dictApplicative) {
      return function (dictFoldable) {
          return function (f) {
              return foldr(dictFoldable)((function () {
                  var $313 = Control_Apply.applySecond(dictApplicative.Apply0());
                  return function ($314) {
                      return $313(f($314));
                  };
              })())(Control_Applicative.pure(dictApplicative)(Data_Unit.unit));
          };
      };
  };
  var sequence_ = function (dictApplicative) {
      return function (dictFoldable) {
          return traverse_(dictApplicative)(dictFoldable)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  var foldl = function (dict) {
      return dict.foldl;
  };
  var indexl = function (dictFoldable) {
      return function (idx) {
          var go = function (cursor) {
              return function (a) {
                  if (cursor.elem instanceof Data_Maybe.Just) {
                      return cursor;
                  };
                  var $155 = cursor.pos === idx;
                  if ($155) {
                      return {
                          elem: new Data_Maybe.Just(a),
                          pos: cursor.pos
                      };
                  };
                  return {
                      pos: cursor.pos + 1 | 0,
                      elem: cursor.elem
                  };
              };
          };
          var $315 = foldl(dictFoldable)(go)({
              elem: Data_Maybe.Nothing.value,
              pos: 0
          });
          return function ($316) {
              return (function (v) {
                  return v.elem;
              })($315($316));
          };
      };
  };
  var intercalate = function (dictFoldable) {
      return function (dictMonoid) {
          return function (sep) {
              return function (xs) {
                  var go = function (v) {
                      return function (x) {
                          if (v.init) {
                              return {
                                  init: false,
                                  acc: x
                              };
                          };
                          return {
                              init: false,
                              acc: Data_Semigroup.append(dictMonoid.Semigroup0())(v.acc)(Data_Semigroup.append(dictMonoid.Semigroup0())(sep)(x))
                          };
                      };
                  };
                  return (foldl(dictFoldable)(go)({
                      init: true,
                      acc: Data_Monoid.mempty(dictMonoid)
                  })(xs)).acc;
              };
          };
      };
  };
  var minimumBy = function (dictFoldable) {
      return function (cmp) {
          var min$prime = function (v) {
              return function (v1) {
                  if (v instanceof Data_Maybe.Nothing) {
                      return new Data_Maybe.Just(v1);
                  };
                  if (v instanceof Data_Maybe.Just) {
                      return new Data_Maybe.Just((function () {
                          var $166 = Data_Eq.eq(Data_Ordering.eqOrdering)(cmp(v.value0)(v1))(Data_Ordering.LT.value);
                          if ($166) {
                              return v.value0;
                          };
                          return v1;
                      })());
                  };
                  throw new Error("Failed pattern match at Data.Foldable (line 454, column 3 - line 454, column 27): " + [ v.constructor.name, v1.constructor.name ]);
              };
          };
          return foldl(dictFoldable)(min$prime)(Data_Maybe.Nothing.value);
      };
  };
  var minimum = function (dictOrd) {
      return function (dictFoldable) {
          return minimumBy(dictFoldable)(Data_Ord.compare(dictOrd));
      };
  }; 
  var foldableMaybe = new Foldable(function (dictMonoid) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof Data_Maybe.Nothing) {
                  return Data_Monoid.mempty(dictMonoid);
              };
              if (v1 instanceof Data_Maybe.Just) {
                  return v(v1.value0);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 138, column 1 - line 144, column 27): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Data_Maybe.Nothing) {
                  return z;
              };
              if (v1 instanceof Data_Maybe.Just) {
                  return v(z)(v1.value0);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 138, column 1 - line 144, column 27): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Data_Maybe.Nothing) {
                  return z;
              };
              if (v1 instanceof Data_Maybe.Just) {
                  return v(v1.value0)(z);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 138, column 1 - line 144, column 27): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var foldableEither = new Foldable(function (dictMonoid) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof Data_Either.Left) {
                  return Data_Monoid.mempty(dictMonoid);
              };
              if (v1 instanceof Data_Either.Right) {
                  return v(v1.value0);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 181, column 1 - line 187, column 28): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Data_Either.Left) {
                  return z;
              };
              if (v1 instanceof Data_Either.Right) {
                  return v(z)(v1.value0);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 181, column 1 - line 187, column 28): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Data_Either.Left) {
                  return z;
              };
              if (v1 instanceof Data_Either.Right) {
                  return v(v1.value0)(z);
              };
              throw new Error("Failed pattern match at Data.Foldable (line 181, column 1 - line 187, column 28): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var foldMapDefaultR = function (dictFoldable) {
      return function (dictMonoid) {
          return function (f) {
              return foldr(dictFoldable)(function (x) {
                  return function (acc) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(f(x))(acc);
                  };
              })(Data_Monoid.mempty(dictMonoid));
          };
      };
  };
  var foldableArray = new Foldable(function (dictMonoid) {
      return foldMapDefaultR(foldableArray)(dictMonoid);
  }, $foreign.foldlArray, $foreign.foldrArray);
  var foldMapDefaultL = function (dictFoldable) {
      return function (dictMonoid) {
          return function (f) {
              return foldl(dictFoldable)(function (acc) {
                  return function (x) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(acc)(f(x));
                  };
              })(Data_Monoid.mempty(dictMonoid));
          };
      };
  };
  var foldMap = function (dict) {
      return dict.foldMap;
  };
  var foldrDefault = function (dictFoldable) {
      return function (c) {
          return function (u) {
              return function (xs) {
                  return Data_Newtype.unwrap()(foldMap(dictFoldable)(Data_Monoid_Endo.monoidEndo(Control_Category.categoryFn))(function ($319) {
                      return Data_Monoid_Endo.Endo(c($319));
                  })(xs))(u);
              };
          };
      };
  };
  var fold = function (dictFoldable) {
      return function (dictMonoid) {
          return foldMap(dictFoldable)(dictMonoid)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  var find = function (dictFoldable) {
      return function (p) {
          var go = function (v) {
              return function (v1) {
                  if (v instanceof Data_Maybe.Nothing && p(v1)) {
                      return new Data_Maybe.Just(v1);
                  };
                  return v;
              };
          };
          return foldl(dictFoldable)(go)(Data_Maybe.Nothing.value);
      };
  };
  var any = function (dictFoldable) {
      return function (dictHeytingAlgebra) {
          return Data_Newtype.alaF()()()()(Data_Monoid_Disj.Disj)(foldMap(dictFoldable)(Data_Monoid_Disj.monoidDisj(dictHeytingAlgebra)));
      };
  };
  var elem = function (dictFoldable) {
      return function (dictEq) {
          var $323 = any(dictFoldable)(Data_HeytingAlgebra.heytingAlgebraBoolean);
          var $324 = Data_Eq.eq(dictEq);
          return function ($325) {
              return $323($324($325));
          };
      };
  };
  var notElem = function (dictFoldable) {
      return function (dictEq) {
          return function (x) {
              var $326 = Data_HeytingAlgebra.not(Data_HeytingAlgebra.heytingAlgebraBoolean);
              var $327 = elem(dictFoldable)(dictEq)(x);
              return function ($328) {
                  return $326($327($328));
              };
          };
      };
  };
  var all = function (dictFoldable) {
      return function (dictHeytingAlgebra) {
          return Data_Newtype.alaF()()()()(Data_Monoid_Conj.Conj)(foldMap(dictFoldable)(Data_Monoid_Conj.monoidConj(dictHeytingAlgebra)));
      };
  };
  exports["Foldable"] = Foldable;
  exports["foldr"] = foldr;
  exports["foldl"] = foldl;
  exports["foldMap"] = foldMap;
  exports["foldrDefault"] = foldrDefault;
  exports["foldMapDefaultL"] = foldMapDefaultL;
  exports["fold"] = fold;
  exports["traverse_"] = traverse_;
  exports["sequence_"] = sequence_;
  exports["oneOf"] = oneOf;
  exports["intercalate"] = intercalate;
  exports["all"] = all;
  exports["any"] = any;
  exports["elem"] = elem;
  exports["notElem"] = notElem;
  exports["indexl"] = indexl;
  exports["find"] = find;
  exports["minimum"] = minimum;
  exports["foldableArray"] = foldableArray;
  exports["foldableMaybe"] = foldableMaybe;
  exports["foldableEither"] = foldableEither;
})(PS);
(function(exports) {
  "use strict";

  exports.unfoldrArrayImpl = function (isNothing) {
    return function (fromJust) {
      return function (fst) {
        return function (snd) {
          return function (f) {
            return function (b) {
              var result = [];
              var value = b;
              while (true) { // eslint-disable-line no-constant-condition
                var maybe = f(value);
                if (isNothing(maybe)) return result;
                var tuple = fromJust(maybe);
                result.push(fst(tuple));
                value = snd(tuple);
              }
            };
          };
        };
      };
    };
  };
})(PS["Data.Unfoldable"] = PS["Data.Unfoldable"] || {});
(function(exports) {
  "use strict";

  exports.unfoldr1ArrayImpl = function (isNothing) {
    return function (fromJust) {
      return function (fst) {
        return function (snd) {
          return function (f) {
            return function (b) {
              var result = [];
              var value = b;
              while (true) { // eslint-disable-line no-constant-condition
                var tuple = f(value);
                result.push(fst(tuple));
                var maybe = snd(tuple);
                if (isNothing(maybe)) return result;
                value = fromJust(maybe);
              }
            };
          };
        };
      };
    };
  };
})(PS["Data.Unfoldable1"] = PS["Data.Unfoldable1"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Unfoldable1"] = $PS["Data.Unfoldable1"] || {};
  var exports = $PS["Data.Unfoldable1"];
  var $foreign = $PS["Data.Unfoldable1"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var Unfoldable1 = function (unfoldr1) {
      this.unfoldr1 = unfoldr1;
  }; 
  var unfoldable1Array = new Unfoldable1($foreign.unfoldr1ArrayImpl(Data_Maybe.isNothing)(Data_Maybe.fromJust())(Data_Tuple.fst)(Data_Tuple.snd));
  exports["Unfoldable1"] = Unfoldable1;
  exports["unfoldable1Array"] = unfoldable1Array;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Unfoldable"] = $PS["Data.Unfoldable"] || {};
  var exports = $PS["Data.Unfoldable"];
  var $foreign = $PS["Data.Unfoldable"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable1 = $PS["Data.Unfoldable1"];  
  var Unfoldable = function (Unfoldable10, unfoldr) {
      this.Unfoldable10 = Unfoldable10;
      this.unfoldr = unfoldr;
  };
  var unfoldr = function (dict) {
      return dict.unfoldr;
  }; 
  var unfoldableArray = new Unfoldable(function () {
      return Data_Unfoldable1.unfoldable1Array;
  }, $foreign.unfoldrArrayImpl(Data_Maybe.isNothing)(Data_Maybe.fromJust())(Data_Tuple.fst)(Data_Tuple.snd));
  exports["Unfoldable"] = Unfoldable;
  exports["unfoldr"] = unfoldr;
  exports["unfoldableArray"] = unfoldableArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Array"] = $PS["Data.Array"] || {};
  var exports = $PS["Data.Array"];
  var $foreign = $PS["Data.Array"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Lazy = $PS["Control.Lazy"];
  var Control_Monad_ST_Internal = $PS["Control.Monad.ST.Internal"];
  var Data_Array_ST = $PS["Data.Array.ST"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var zip = $foreign.zipWith(Data_Tuple.Tuple.create);
  var updateAtIndices = function (dictFoldable) {
      return function (us) {
          return function (xs) {
              return Data_Array_ST.withArray(function (res) {
                  return Data_Foldable.traverse_(Control_Monad_ST_Internal.applicativeST)(dictFoldable)(function (v) {
                      return Data_Array_ST.poke(v.value0)(v.value1)(res);
                  })(us);
              })(xs)();
          };
      };
  };
  var updateAt = $foreign["_updateAt"](Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var unsafeIndex = function (dictPartial) {
      return $foreign.unsafeIndexImpl;
  };
  var uncons = $foreign.unconsImpl(Data_Function["const"](Data_Maybe.Nothing.value))(function (x) {
      return function (xs) {
          return new Data_Maybe.Just({
              head: x,
              tail: xs
          });
      };
  });
  var toUnfoldable = function (dictUnfoldable) {
      return function (xs) {
          var len = $foreign.length(xs);
          var f = function (i) {
              if (i < len) {
                  return new Data_Maybe.Just(new Data_Tuple.Tuple(unsafeIndex()(xs)(i), i + 1 | 0));
              };
              if (Data_Boolean.otherwise) {
                  return Data_Maybe.Nothing.value;
              };
              throw new Error("Failed pattern match at Data.Array (line 158, column 3 - line 160, column 26): " + [ i.constructor.name ]);
          };
          return Data_Unfoldable.unfoldr(dictUnfoldable)(f)(0);
      };
  };
  var take = function (n) {
      return function (xs) {
          var $67 = n < 1;
          if ($67) {
              return [  ];
          };
          return $foreign.slice(0)(n)(xs);
      };
  };
  var sortBy = function (comp) {
      return $foreign.sortByImpl(comp)(function (v) {
          if (v instanceof Data_Ordering.GT) {
              return 1;
          };
          if (v instanceof Data_Ordering.EQ) {
              return 0;
          };
          if (v instanceof Data_Ordering.LT) {
              return -1 | 0;
          };
          throw new Error("Failed pattern match at Data.Array (line 831, column 31 - line 834, column 11): " + [ v.constructor.name ]);
      });
  };
  var sortWith = function (dictOrd) {
      return function (f) {
          return sortBy(Data_Ord.comparing(dictOrd)(f));
      };
  };
  var snoc = function (xs) {
      return function (x) {
          return Data_Array_ST.withArray(Data_Array_ST.push(x))(xs)();
      };
  };
  var singleton = function (a) {
      return [ a ];
  };
  var $$null = function (xs) {
      return $foreign.length(xs) === 0;
  };
  var mapWithIndex = function (f) {
      return function (xs) {
          return $foreign.zipWith(f)($foreign.range(0)($foreign.length(xs) - 1 | 0))(xs);
      };
  };
  var index = $foreign.indexImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var last = function (xs) {
      return index(xs)($foreign.length(xs) - 1 | 0);
  };
  var modifyAt = function (i) {
      return function (f) {
          return function (xs) {
              var go = function (x) {
                  return updateAt(i)(f(x))(xs);
              };
              return Data_Maybe.maybe(Data_Maybe.Nothing.value)(go)(index(xs)(i));
          };
      };
  };
  var head = function (xs) {
      return index(xs)(0);
  };
  var fromFoldable = function (dictFoldable) {
      return $foreign.fromFoldableImpl(Data_Foldable.foldr(dictFoldable));
  };
  var foldr = Data_Foldable.foldr(Data_Foldable.foldableArray);
  var foldl = Data_Foldable.foldl(Data_Foldable.foldableArray);
  var findIndex = $foreign.findIndexImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var elemIndex = function (dictEq) {
      return function (x) {
          return findIndex(function (v) {
              return Data_Eq.eq(dictEq)(v)(x);
          });
      };
  };
  var elem = function (dictEq) {
      return function (a) {
          return function (arr) {
              return Data_Maybe.isJust(elemIndex(dictEq)(a)(arr));
          };
      };
  };
  var drop = function (n) {
      return function (xs) {
          var $89 = n < 1;
          if ($89) {
              return xs;
          };
          return $foreign.slice(n)($foreign.length(xs))(xs);
      };
  };
  var deleteAt = $foreign["_deleteAt"](Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var cons = function (x) {
      return function (xs) {
          return Data_Semigroup.append(Data_Semigroup.semigroupArray)([ x ])(xs);
      };
  };
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Apply.apply((dictAlternative.Applicative0()).Apply0())(Data_Functor.map(((dictAlternative.Plus1()).Alt0()).Functor0())(cons)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt.alt((dictAlternative.Plus1()).Alt0())(some(dictAlternative)(dictLazy)(v))(Control_Applicative.pure(dictAlternative.Applicative0())([  ]));
          };
      };
  };
  var concatMap = Data_Function.flip(Control_Bind.bind(Control_Bind.bindArray));
  var mapMaybe = function (f) {
      return concatMap((function () {
          var $109 = Data_Maybe.maybe([  ])(singleton);
          return function ($110) {
              return $109(f($110));
          };
      })());
  };
  exports["fromFoldable"] = fromFoldable;
  exports["toUnfoldable"] = toUnfoldable;
  exports["many"] = many;
  exports["null"] = $$null;
  exports["cons"] = cons;
  exports["snoc"] = snoc;
  exports["head"] = head;
  exports["last"] = last;
  exports["uncons"] = uncons;
  exports["index"] = index;
  exports["elem"] = elem;
  exports["elemIndex"] = elemIndex;
  exports["deleteAt"] = deleteAt;
  exports["updateAt"] = updateAt;
  exports["updateAtIndices"] = updateAtIndices;
  exports["modifyAt"] = modifyAt;
  exports["mapMaybe"] = mapMaybe;
  exports["mapWithIndex"] = mapWithIndex;
  exports["foldl"] = foldl;
  exports["sortBy"] = sortBy;
  exports["sortWith"] = sortWith;
  exports["take"] = take;
  exports["drop"] = drop;
  exports["zip"] = zip;
  exports["unsafeIndex"] = unsafeIndex;
  exports["range"] = $foreign.range;
  exports["length"] = $foreign.length;
  exports["reverse"] = $foreign.reverse;
  exports["concat"] = $foreign.concat;
  exports["filter"] = $foreign.filter;
  exports["slice"] = $foreign.slice;
})(PS);
(function(exports) {
  "use strict";

  exports.mapWithIndexArray = function (f) {
    return function (xs) {
      var l = xs.length;
      var result = Array(l);
      for (var i = 0; i < l; i++) {
        result[i] = f(i)(xs[i]);
      }
      return result;
    };
  };
})(PS["Data.FunctorWithIndex"] = PS["Data.FunctorWithIndex"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.FunctorWithIndex"] = $PS["Data.FunctorWithIndex"] || {};
  var exports = $PS["Data.FunctorWithIndex"];
  var $foreign = $PS["Data.FunctorWithIndex"];
  var Data_Functor = $PS["Data.Functor"];          
  var FunctorWithIndex = function (Functor0, mapWithIndex) {
      this.Functor0 = Functor0;
      this.mapWithIndex = mapWithIndex;
  };
  var mapWithIndex = function (dict) {
      return dict.mapWithIndex;
  };
  var functorWithIndexArray = new FunctorWithIndex(function () {
      return Data_Functor.functorArray;
  }, $foreign.mapWithIndexArray);
  exports["FunctorWithIndex"] = FunctorWithIndex;
  exports["mapWithIndex"] = mapWithIndex;
  exports["functorWithIndexArray"] = functorWithIndexArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.FoldableWithIndex"] = $PS["Data.FoldableWithIndex"] || {};
  var exports = $PS["Data.FoldableWithIndex"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Tuple = $PS["Data.Tuple"];              
  var FoldableWithIndex = function (Foldable0, foldMapWithIndex, foldlWithIndex, foldrWithIndex) {
      this.Foldable0 = Foldable0;
      this.foldMapWithIndex = foldMapWithIndex;
      this.foldlWithIndex = foldlWithIndex;
      this.foldrWithIndex = foldrWithIndex;
  };
  var foldrWithIndex = function (dict) {
      return dict.foldrWithIndex;
  };
  var foldlWithIndex = function (dict) {
      return dict.foldlWithIndex;
  };
  var foldMapWithIndexDefaultR = function (dictFoldableWithIndex) {
      return function (dictMonoid) {
          return function (f) {
              return foldrWithIndex(dictFoldableWithIndex)(function (i) {
                  return function (x) {
                      return function (acc) {
                          return Data_Semigroup.append(dictMonoid.Semigroup0())(f(i)(x))(acc);
                      };
                  };
              })(Data_Monoid.mempty(dictMonoid));
          };
      };
  };
  var foldableWithIndexArray = new FoldableWithIndex(function () {
      return Data_Foldable.foldableArray;
  }, function (dictMonoid) {
      return foldMapWithIndexDefaultR(foldableWithIndexArray)(dictMonoid);
  }, function (f) {
      return function (z) {
          var $164 = Data_Foldable.foldl(Data_Foldable.foldableArray)(function (y) {
              return function (v) {
                  return f(v.value0)(y)(v.value1);
              };
          })(z);
          var $165 = Data_FunctorWithIndex.mapWithIndex(Data_FunctorWithIndex.functorWithIndexArray)(Data_Tuple.Tuple.create);
          return function ($166) {
              return $164($165($166));
          };
      };
  }, function (f) {
      return function (z) {
          var $167 = Data_Foldable.foldr(Data_Foldable.foldableArray)(function (v) {
              return function (y) {
                  return f(v.value0)(v.value1)(y);
              };
          })(z);
          var $168 = Data_FunctorWithIndex.mapWithIndex(Data_FunctorWithIndex.functorWithIndexArray)(Data_Tuple.Tuple.create);
          return function ($169) {
              return $167($168($169));
          };
      };
  });
  var foldMapWithIndex = function (dict) {
      return dict.foldMapWithIndex;
  };
  exports["FoldableWithIndex"] = FoldableWithIndex;
  exports["foldrWithIndex"] = foldrWithIndex;
  exports["foldlWithIndex"] = foldlWithIndex;
  exports["foldMapWithIndex"] = foldMapWithIndex;
  exports["foldableWithIndexArray"] = foldableWithIndexArray;
})(PS);
(function(exports) {
  "use strict";

  // jshint maxparams: 3

  exports.traverseArrayImpl = (function () {
    function array1(a) {
      return [a];
    }

    function array2(a) {
      return function (b) {
        return [a, b];
      };
    }

    function array3(a) {
      return function (b) {
        return function (c) {
          return [a, b, c];
        };
      };
    }

    function concat2(xs) {
      return function (ys) {
        return xs.concat(ys);
      };
    }

    return function (apply) {
      return function (map) {
        return function (pure) {
          return function (f) {
            return function (array) {
              function go(bot, top) {
                switch (top - bot) {
                case 0: return pure([]);
                case 1: return map(array1)(f(array[bot]));
                case 2: return apply(map(array2)(f(array[bot])))(f(array[bot + 1]));
                case 3: return apply(apply(map(array3)(f(array[bot])))(f(array[bot + 1])))(f(array[bot + 2]));
                default:
                  // This slightly tricky pivot selection aims to produce two
                  // even-length partitions where possible.
                  var pivot = bot + Math.floor((top - bot) / 4) * 2;
                  return apply(map(concat2)(go(bot, pivot)))(go(pivot, top));
                }
              }
              return go(0, array.length);
            };
          };
        };
      };
    };
  })();
})(PS["Data.Traversable"] = PS["Data.Traversable"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Traversable"] = $PS["Data.Traversable"] || {};
  var exports = $PS["Data.Traversable"];
  var $foreign = $PS["Data.Traversable"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Category = $PS["Control.Category"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];            
  var Traversable = function (Foldable1, Functor0, sequence, traverse) {
      this.Foldable1 = Foldable1;
      this.Functor0 = Functor0;
      this.sequence = sequence;
      this.traverse = traverse;
  };
  var traverse = function (dict) {
      return dict.traverse;
  }; 
  var sequenceDefault = function (dictTraversable) {
      return function (dictApplicative) {
          return traverse(dictTraversable)(dictApplicative)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  var traversableArray = new Traversable(function () {
      return Data_Foldable.foldableArray;
  }, function () {
      return Data_Functor.functorArray;
  }, function (dictApplicative) {
      return sequenceDefault(traversableArray)(dictApplicative);
  }, function (dictApplicative) {
      return $foreign.traverseArrayImpl(Control_Apply.apply(dictApplicative.Apply0()))(Data_Functor.map((dictApplicative.Apply0()).Functor0()))(Control_Applicative.pure(dictApplicative));
  });
  var sequence = function (dict) {
      return dict.sequence;
  };
  exports["Traversable"] = Traversable;
  exports["traverse"] = traverse;
  exports["sequence"] = sequence;
  exports["traversableArray"] = traversableArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.TraversableWithIndex"] = $PS["Data.TraversableWithIndex"] || {};
  var exports = $PS["Data.TraversableWithIndex"];
  var Data_FoldableWithIndex = $PS["Data.FoldableWithIndex"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_Traversable = $PS["Data.Traversable"];  
  var TraversableWithIndex = function (FoldableWithIndex1, FunctorWithIndex0, Traversable2, traverseWithIndex) {
      this.FoldableWithIndex1 = FoldableWithIndex1;
      this.FunctorWithIndex0 = FunctorWithIndex0;
      this.Traversable2 = Traversable2;
      this.traverseWithIndex = traverseWithIndex;
  };
  var traverseWithIndexDefault = function (dictTraversableWithIndex) {
      return function (dictApplicative) {
          return function (f) {
              var $63 = Data_Traversable.sequence(dictTraversableWithIndex.Traversable2())(dictApplicative);
              var $64 = Data_FunctorWithIndex.mapWithIndex(dictTraversableWithIndex.FunctorWithIndex0())(f);
              return function ($65) {
                  return $63($64($65));
              };
          };
      };
  };
  var traverseWithIndex = function (dict) {
      return dict.traverseWithIndex;
  };
  var traversableWithIndexArray = new TraversableWithIndex(function () {
      return Data_FoldableWithIndex.foldableWithIndexArray;
  }, function () {
      return Data_FunctorWithIndex.functorWithIndexArray;
  }, function () {
      return Data_Traversable.traversableArray;
  }, function (dictApplicative) {
      return traverseWithIndexDefault(traversableWithIndexArray)(dictApplicative);
  });
  exports["TraversableWithIndex"] = TraversableWithIndex;
  exports["traverseWithIndex"] = traverseWithIndex;
  exports["traversableWithIndexArray"] = traversableWithIndexArray;
})(PS);
(function(exports) {
  "use strict";

  exports["new"] = function () {
    return {};
  };

  exports.poke = function (k) {
    return function (v) {
      return function (m) {
        return function () {
          m[k] = v;
          return m;
        };
      };
    };
  };
})(PS["Foreign.Object.ST"] = PS["Foreign.Object.ST"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Foreign.Object.ST"] = $PS["Foreign.Object.ST"] || {};
  var exports = $PS["Foreign.Object.ST"];
  var $foreign = $PS["Foreign.Object.ST"];
  exports["new"] = $foreign["new"];
  exports["poke"] = $foreign.poke;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Foreign.Object"] = $PS["Foreign.Object"] || {};
  var exports = $PS["Foreign.Object"];
  var $foreign = $PS["Foreign.Object"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Category = $PS["Control.Category"];
  var Control_Monad_ST_Internal = $PS["Control.Monad.ST.Internal"];
  var Data_Array = $PS["Data.Array"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_FoldableWithIndex = $PS["Data.FoldableWithIndex"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Data_TraversableWithIndex = $PS["Data.TraversableWithIndex"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Foreign_Object_ST = $PS["Foreign.Object.ST"];        
  var values = $foreign.toArrayWithKey(function (v) {
      return function (v1) {
          return v1;
      };
  });
  var toUnfoldable = function (dictUnfoldable) {
      var $36 = Data_Array.toUnfoldable(dictUnfoldable);
      var $37 = $foreign.toArrayWithKey(Data_Tuple.Tuple.create);
      return function ($38) {
          return $36($37($38));
      };
  };                                                             
  var thawST = $foreign["_copyST"];
  var singleton = function (k) {
      return function (v) {
          return $foreign.runST(Control_Bind.bindFlipped(Control_Monad_ST_Internal.bindST)(Foreign_Object_ST.poke(k)(v))(Foreign_Object_ST["new"]));
      };
  };
  var mutate = function (f) {
      return function (m) {
          return $foreign.runST(function __do() {
              var s = thawST(m)();
              f(s)();
              return s;
          });
      };
  };                                                                                                    
  var mapWithKey = function (f) {
      return function (m) {
          return $foreign["_mapWithKey"](m, f);
      };
  }; 
  var insert = function (k) {
      return function (v) {
          return mutate(Foreign_Object_ST.poke(k)(v));
      };
  };
  var functorObject = new Data_Functor.Functor(function (f) {
      return function (m) {
          return $foreign["_fmapObject"](m, f);
      };
  });
  var functorWithIndexObject = new Data_FunctorWithIndex.FunctorWithIndex(function () {
      return functorObject;
  }, mapWithKey);
  var fromFoldable = function (dictFoldable) {
      return function (l) {
          return $foreign.runST(function __do() {
              var s = Foreign_Object_ST["new"]();
              Control_Monad_ST_Internal.foreach(Data_Array.fromFoldable(dictFoldable)(l))(function (v) {
                  return Data_Functor["void"](Control_Monad_ST_Internal.functorST)(Foreign_Object_ST.poke(v.value0)(v.value1)(s));
              })();
              return s;
          });
      };
  };
  var foldM = function (dictMonad) {
      return function (f) {
          return function (z) {
              return $foreign["_foldM"](Control_Bind.bind(dictMonad.Bind1()))(f)(Control_Applicative.pure(dictMonad.Applicative0())(z));
          };
      };
  };
  var union = function (m) {
      return mutate(function (s) {
          return foldM(Control_Monad_ST_Internal.monadST)(function (s$prime) {
              return function (k) {
                  return function (v) {
                      return Foreign_Object_ST.poke(k)(v)(s$prime);
                  };
              };
          })(s)(m);
      });
  };
  var unions = function (dictFoldable) {
      return Data_Foldable.foldl(dictFoldable)(union)($foreign.empty);
  };
  var fold = $foreign["_foldM"](Data_Function.applyFlipped);
  var foldMap = function (dictMonoid) {
      return function (f) {
          return fold(function (acc) {
              return function (k) {
                  return function (v) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(acc)(f(k)(v));
                  };
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  };
  var foldableObject = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return foldMap(dictMonoid)(Data_Function["const"](f));
      };
  }, function (f) {
      return fold(function (z) {
          return function (v) {
              return f(z);
          };
      });
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldr(Data_Foldable.foldableArray)(f)(z)(values(m));
          };
      };
  });
  var foldableWithIndexObject = new Data_FoldableWithIndex.FoldableWithIndex(function () {
      return foldableObject;
  }, function (dictMonoid) {
      return foldMap(dictMonoid);
  }, function (f) {
      return fold(Data_Function.flip(f));
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldr(Data_Foldable.foldableArray)(Data_Tuple.uncurry(f))(z)($foreign.toArrayWithKey(Data_Tuple.Tuple.create)(m));
          };
      };
  });
  var traversableWithIndexObject = new Data_TraversableWithIndex.TraversableWithIndex(function () {
      return foldableWithIndexObject;
  }, function () {
      return functorWithIndexObject;
  }, function () {
      return traversableObject;
  }, function (dictApplicative) {
      return function (f) {
          return function (ms) {
              return fold(function (acc) {
                  return function (k) {
                      return function (v) {
                          return Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(Data_Function.flip(insert(k)))(acc))(f(k)(v));
                      };
                  };
              })(Control_Applicative.pure(dictApplicative)($foreign.empty))(ms);
          };
      };
  });
  var traversableObject = new Data_Traversable.Traversable(function () {
      return foldableObject;
  }, function () {
      return functorObject;
  }, function (dictApplicative) {
      return Data_Traversable.traverse(traversableObject)(dictApplicative)(Control_Category.identity(Control_Category.categoryFn));
  }, function (dictApplicative) {
      var $43 = Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexObject)(dictApplicative);
      return function ($44) {
          return $43(Data_Function["const"]($44));
      };
  });
  exports["singleton"] = singleton;
  exports["toUnfoldable"] = toUnfoldable;
  exports["fromFoldable"] = fromFoldable;
  exports["mapWithKey"] = mapWithKey;
  exports["values"] = values;
  exports["unions"] = unions;
  exports["foldableWithIndexObject"] = foldableWithIndexObject;
  exports["traversableObject"] = traversableObject;
  exports["empty"] = $foreign.empty;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Argonaut.Core"] = $PS["Data.Argonaut.Core"] || {};
  var exports = $PS["Data.Argonaut.Core"];
  var $foreign = $PS["Data.Argonaut.Core"];
  var Foreign_Object = $PS["Foreign.Object"];   
  var jsonEmptyObject = $foreign.fromObject(Foreign_Object.empty);
  exports["jsonEmptyObject"] = jsonEmptyObject;
  exports["stringify"] = $foreign.stringify;
})(PS);
(function(exports) {
  "use strict";

  exports._jsonParser = function (fail, succ, s) {
    try {
      return succ(JSON.parse(s));
    }
    catch (e) {
      return fail(e.message);
    }
  };
})(PS["Data.Argonaut.Parser"] = PS["Data.Argonaut.Parser"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Argonaut.Parser"] = $PS["Data.Argonaut.Parser"] || {};
  var exports = $PS["Data.Argonaut.Parser"];
  var $foreign = $PS["Data.Argonaut.Parser"];
  var Data_Either = $PS["Data.Either"];                
  var jsonParser = function (j) {
      return $foreign["_jsonParser"](Data_Either.Left.create, Data_Either.Right.create, j);
  };
  exports["jsonParser"] = jsonParser;
})(PS);
(function(exports) {
  "use strict";

  exports.replace = function (s1) {
    return function (s2) {
      return function (s3) {
        return s3.replace(s1, s2);
      };
    };
  };

  exports.replaceAll = function (s1) {
    return function (s2) {
      return function (s3) {
        return s3.replace(new RegExp(s1.replace(/[-\/\\^$*+?.()|[\]{}]/g, "\\$&"), "g"), s2); // eslint-disable-line no-useless-escape
      };
    };
  };

  exports.split = function (sep) {
    return function (s) {
      return s.split(sep);
    };
  };

  exports.toLower = function (s) {
    return s.toLowerCase();
  };

  exports.toUpper = function (s) {
    return s.toUpperCase();
  };

  exports.trim = function (s) {
    return s.trim();
  };

  exports.joinWith = function (s) {
    return function (xs) {
      return xs.join(s);
    };
  };
})(PS["Data.String.Common"] = PS["Data.String.Common"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Common"] = $PS["Data.String.Common"] || {};
  var exports = $PS["Data.String.Common"];
  var $foreign = $PS["Data.String.Common"];                
  var $$null = function (s) {
      return s === "";
  };
  exports["null"] = $$null;
  exports["replace"] = $foreign.replace;
  exports["replaceAll"] = $foreign.replaceAll;
  exports["split"] = $foreign.split;
  exports["toLower"] = $foreign.toLower;
  exports["toUpper"] = $foreign.toUpper;
  exports["trim"] = $foreign.trim;
  exports["joinWith"] = $foreign.joinWith;
})(PS);
(function(exports) {
  "use strict";

  // A helper which transforms the result ofencodeURIComponent to be compliant
  // with RFC3896, as described in the MDN documentation here:
  //
  // https://web.archive.org/web/20201206001047/https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/encodeURIComponent
  function toRFC3896(input) {
    return input.replace(/[!'()*]/g, function (c) {
      return "%" + c.charCodeAt(0).toString(16);
    });
  }

  exports._encodeURIComponent = function encode(fail, succeed, input) {
    try {
      return succeed(toRFC3896(encodeURIComponent(input)));
    } catch (err) {
      return fail(err);
    }
  };

  function _decodeURIComponent(fail, succeed, input) {
    try {
      return succeed(decodeURIComponent(input));
    } catch (err) {
      return fail(err);
    }
  }

  exports._decodeURIComponent = _decodeURIComponent;
})(PS["JSURI"] = PS["JSURI"] || {});
(function(exports) {
  "use strict";

  exports.runFn2 = function (fn) {
    return function (a) {
      return function (b) {
        return fn(a, b);
      };
    };
  };

  exports.runFn3 = function (fn) {
    return function (a) {
      return function (b) {
        return function (c) {
          return fn(a, b, c);
        };
      };
    };
  };
})(PS["Data.Function.Uncurried"] = PS["Data.Function.Uncurried"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Function.Uncurried"] = $PS["Data.Function.Uncurried"] || {};
  var exports = $PS["Data.Function.Uncurried"];
  var $foreign = $PS["Data.Function.Uncurried"];
  var runFn1 = function (f) {
      return f;
  };
  exports["runFn1"] = runFn1;
  exports["runFn2"] = $foreign.runFn2;
  exports["runFn3"] = $foreign.runFn3;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["JSURI"] = $PS["JSURI"] || {};
  var exports = $PS["JSURI"];
  var $foreign = $PS["JSURI"];
  var Data_Function = $PS["Data.Function"];
  var Data_Function_Uncurried = $PS["Data.Function.Uncurried"];
  var Data_Maybe = $PS["Data.Maybe"];                
  var $$encodeURIComponent = Data_Function_Uncurried.runFn3($foreign["_encodeURIComponent"])(Data_Function["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create);      
  var $$decodeURIComponent = Data_Function_Uncurried.runFn3($foreign["_decodeURIComponent"])(Data_Function["const"](Data_Maybe.Nothing.value))(Data_Maybe.Just.create);
  exports["encodeURIComponent"] = $$encodeURIComponent;
  exports["decodeURIComponent"] = $$decodeURIComponent;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.FormURLEncoded"] = $PS["Data.FormURLEncoded"] || {};
  var exports = $PS["Data.FormURLEncoded"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_String_Common = $PS["Data.String.Common"];
  var Data_Traversable = $PS["Data.Traversable"];
  var JSURI = $PS["JSURI"];                
  var FormURLEncoded = function (x) {
      return x;
  };
  var toArray = function (v) {
      return v;
  };                                                 
  var fromArray = FormURLEncoded;                                                                                    
  var encode = (function () {
      var encodePart = function (v) {
          if (v.value1 instanceof Data_Maybe.Nothing) {
              return JSURI["encodeURIComponent"](v.value0);
          };
          if (v.value1 instanceof Data_Maybe.Just) {
              return Control_Apply.apply(Data_Maybe.applyMaybe)(Data_Functor.map(Data_Maybe.functorMaybe)(function (key) {
                  return function (val) {
                      return key + ("=" + val);
                  };
              })(JSURI["encodeURIComponent"](v.value0)))(JSURI["encodeURIComponent"](v.value1.value0));
          };
          throw new Error("Failed pattern match at Data.FormURLEncoded (line 37, column 18 - line 39, column 108): " + [ v.constructor.name ]);
      };
      var $16 = Data_Functor.map(Data_Maybe.functorMaybe)(Data_String_Common.joinWith("&"));
      var $17 = Data_Traversable.traverse(Data_Traversable.traversableArray)(Data_Maybe.applicativeMaybe)(encodePart);
      return function ($18) {
          return $16($17(toArray($18)));
      };
  })();
  exports["fromArray"] = fromArray;
  exports["encode"] = encode;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.HTTP.Method"] = $PS["Data.HTTP.Method"] || {};
  var exports = $PS["Data.HTTP.Method"];
  var Data_Either = $PS["Data.Either"];
  var Data_Show = $PS["Data.Show"];                                  
  var OPTIONS = (function () {
      function OPTIONS() {

      };
      OPTIONS.value = new OPTIONS();
      return OPTIONS;
  })();
  var GET = (function () {
      function GET() {

      };
      GET.value = new GET();
      return GET;
  })();
  var HEAD = (function () {
      function HEAD() {

      };
      HEAD.value = new HEAD();
      return HEAD;
  })();
  var POST = (function () {
      function POST() {

      };
      POST.value = new POST();
      return POST;
  })();
  var PUT = (function () {
      function PUT() {

      };
      PUT.value = new PUT();
      return PUT;
  })();
  var DELETE = (function () {
      function DELETE() {

      };
      DELETE.value = new DELETE();
      return DELETE;
  })();
  var TRACE = (function () {
      function TRACE() {

      };
      TRACE.value = new TRACE();
      return TRACE;
  })();
  var CONNECT = (function () {
      function CONNECT() {

      };
      CONNECT.value = new CONNECT();
      return CONNECT;
  })();
  var PROPFIND = (function () {
      function PROPFIND() {

      };
      PROPFIND.value = new PROPFIND();
      return PROPFIND;
  })();
  var PROPPATCH = (function () {
      function PROPPATCH() {

      };
      PROPPATCH.value = new PROPPATCH();
      return PROPPATCH;
  })();
  var MKCOL = (function () {
      function MKCOL() {

      };
      MKCOL.value = new MKCOL();
      return MKCOL;
  })();
  var COPY = (function () {
      function COPY() {

      };
      COPY.value = new COPY();
      return COPY;
  })();
  var MOVE = (function () {
      function MOVE() {

      };
      MOVE.value = new MOVE();
      return MOVE;
  })();
  var LOCK = (function () {
      function LOCK() {

      };
      LOCK.value = new LOCK();
      return LOCK;
  })();
  var UNLOCK = (function () {
      function UNLOCK() {

      };
      UNLOCK.value = new UNLOCK();
      return UNLOCK;
  })();
  var PATCH = (function () {
      function PATCH() {

      };
      PATCH.value = new PATCH();
      return PATCH;
  })();
  var unCustomMethod = function (v) {
      return v;
  };
  var showMethod = new Data_Show.Show(function (v) {
      if (v instanceof OPTIONS) {
          return "OPTIONS";
      };
      if (v instanceof GET) {
          return "GET";
      };
      if (v instanceof HEAD) {
          return "HEAD";
      };
      if (v instanceof POST) {
          return "POST";
      };
      if (v instanceof PUT) {
          return "PUT";
      };
      if (v instanceof DELETE) {
          return "DELETE";
      };
      if (v instanceof TRACE) {
          return "TRACE";
      };
      if (v instanceof CONNECT) {
          return "CONNECT";
      };
      if (v instanceof PROPFIND) {
          return "PROPFIND";
      };
      if (v instanceof PROPPATCH) {
          return "PROPPATCH";
      };
      if (v instanceof MKCOL) {
          return "MKCOL";
      };
      if (v instanceof COPY) {
          return "COPY";
      };
      if (v instanceof MOVE) {
          return "MOVE";
      };
      if (v instanceof LOCK) {
          return "LOCK";
      };
      if (v instanceof UNLOCK) {
          return "UNLOCK";
      };
      if (v instanceof PATCH) {
          return "PATCH";
      };
      throw new Error("Failed pattern match at Data.HTTP.Method (line 43, column 1 - line 59, column 23): " + [ v.constructor.name ]);
  });
  var print = Data_Either.either(Data_Show.show(showMethod))(unCustomMethod);
  exports["GET"] = GET;
  exports["POST"] = POST;
  exports["PUT"] = PUT;
  exports["DELETE"] = DELETE;
  exports["print"] = print;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.NonEmpty"] = $PS["Data.NonEmpty"] || {};
  var exports = $PS["Data.NonEmpty"];
  var Control_Plus = $PS["Control.Plus"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Show = $PS["Data.Show"];                              
  var NonEmpty = (function () {
      function NonEmpty(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      NonEmpty.create = function (value0) {
          return function (value1) {
              return new NonEmpty(value0, value1);
          };
      };
      return NonEmpty;
  })();
  var singleton = function (dictPlus) {
      return function (a) {
          return new NonEmpty(a, Control_Plus.empty(dictPlus));
      };
  };
  var showNonEmpty = function (dictShow) {
      return function (dictShow1) {
          return new Data_Show.Show(function (v) {
              return "(NonEmpty " + (Data_Show.show(dictShow)(v.value0) + (" " + (Data_Show.show(dictShow1)(v.value1) + ")")));
          });
      };
  };
  var head = function (v) {
      return v.value0;
  };
  var functorNonEmpty = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return function (m) {
              return new NonEmpty(f(m.value0), Data_Functor.map(dictFunctor)(f)(m.value1));
          };
      });
  };
  var foldableNonEmpty = function (dictFoldable) {
      return new Data_Foldable.Foldable(function (dictMonoid) {
          return function (f) {
              return function (v) {
                  return Data_Semigroup.append(dictMonoid.Semigroup0())(f(v.value0))(Data_Foldable.foldMap(dictFoldable)(dictMonoid)(f)(v.value1));
              };
          };
      }, function (f) {
          return function (b) {
              return function (v) {
                  return Data_Foldable.foldl(dictFoldable)(f)(f(b)(v.value0))(v.value1);
              };
          };
      }, function (f) {
          return function (b) {
              return function (v) {
                  return f(v.value0)(Data_Foldable.foldr(dictFoldable)(f)(b)(v.value1));
              };
          };
      });
  };
  exports["NonEmpty"] = NonEmpty;
  exports["singleton"] = singleton;
  exports["head"] = head;
  exports["showNonEmpty"] = showNonEmpty;
  exports["functorNonEmpty"] = functorNonEmpty;
  exports["foldableNonEmpty"] = foldableNonEmpty;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.List.Types"] = $PS["Data.List.Types"] || {};
  var exports = $PS["Data.List.Types"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Category = $PS["Control.Category"];
  var Control_Plus = $PS["Control.Plus"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_FoldableWithIndex = $PS["Data.FoldableWithIndex"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_NonEmpty = $PS["Data.NonEmpty"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Show = $PS["Data.Show"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var Data_Unfoldable1 = $PS["Data.Unfoldable1"];                
  var Nil = (function () {
      function Nil() {

      };
      Nil.value = new Nil();
      return Nil;
  })();
  var Cons = (function () {
      function Cons(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Cons.create = function (value0) {
          return function (value1) {
              return new Cons(value0, value1);
          };
      };
      return Cons;
  })();
  var NonEmptyList = function (x) {
      return x;
  };
  var toList = function (v) {
      return new Cons(v.value0, v.value1);
  };
  var listMap = function (f) {
      var chunkedRevMap = function ($copy_chunksAcc) {
          return function ($copy_v) {
              var $tco_var_chunksAcc = $copy_chunksAcc;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(chunksAcc, v) {
                  if (v instanceof Cons && (v.value1 instanceof Cons && v.value1.value1 instanceof Cons)) {
                      $tco_var_chunksAcc = new Cons(v, chunksAcc);
                      $copy_v = v.value1.value1.value1;
                      return;
                  };
                  var unrolledMap = function (v1) {
                      if (v1 instanceof Cons && (v1.value1 instanceof Cons && v1.value1.value1 instanceof Nil)) {
                          return new Cons(f(v1.value0), new Cons(f(v1.value1.value0), Nil.value));
                      };
                      if (v1 instanceof Cons && v1.value1 instanceof Nil) {
                          return new Cons(f(v1.value0), Nil.value);
                      };
                      return Nil.value;
                  };
                  var reverseUnrolledMap = function ($copy_v1) {
                      return function ($copy_acc) {
                          var $tco_var_v1 = $copy_v1;
                          var $tco_done1 = false;
                          var $tco_result;
                          function $tco_loop(v1, acc) {
                              if (v1 instanceof Cons && (v1.value0 instanceof Cons && (v1.value0.value1 instanceof Cons && v1.value0.value1.value1 instanceof Cons))) {
                                  $tco_var_v1 = v1.value1;
                                  $copy_acc = new Cons(f(v1.value0.value0), new Cons(f(v1.value0.value1.value0), new Cons(f(v1.value0.value1.value1.value0), acc)));
                                  return;
                              };
                              $tco_done1 = true;
                              return acc;
                          };
                          while (!$tco_done1) {
                              $tco_result = $tco_loop($tco_var_v1, $copy_acc);
                          };
                          return $tco_result;
                      };
                  };
                  $tco_done = true;
                  return reverseUnrolledMap(chunksAcc)(unrolledMap(v));
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_chunksAcc, $copy_v);
              };
              return $tco_result;
          };
      };
      return chunkedRevMap(Nil.value);
  };
  var functorList = new Data_Functor.Functor(listMap);
  var functorNonEmptyList = Data_NonEmpty.functorNonEmpty(functorList);
  var foldableList = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return Data_Foldable.foldl(foldableList)(function (acc) {
              var $205 = Data_Semigroup.append(dictMonoid.Semigroup0())(acc);
              return function ($206) {
                  return $205(f($206));
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  }, function (f) {
      var go = function ($copy_b) {
          return function ($copy_v) {
              var $tco_var_b = $copy_b;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(b, v) {
                  if (v instanceof Nil) {
                      $tco_done = true;
                      return b;
                  };
                  if (v instanceof Cons) {
                      $tco_var_b = f(b)(v.value0);
                      $copy_v = v.value1;
                      return;
                  };
                  throw new Error("Failed pattern match at Data.List.Types (line 112, column 12 - line 114, column 30): " + [ v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_b, $copy_v);
              };
              return $tco_result;
          };
      };
      return go;
  }, function (f) {
      return function (b) {
          var rev = (function () {
              var go = function ($copy_acc) {
                  return function ($copy_v) {
                      var $tco_var_acc = $copy_acc;
                      var $tco_done1 = false;
                      var $tco_result;
                      function $tco_loop(acc, v) {
                          if (v instanceof Nil) {
                              $tco_done1 = true;
                              return acc;
                          };
                          if (v instanceof Cons) {
                              $tco_var_acc = new Cons(v.value0, acc);
                              $copy_v = v.value1;
                              return;
                          };
                          throw new Error("Failed pattern match at Data.List.Types (line 108, column 7 - line 108, column 23): " + [ acc.constructor.name, v.constructor.name ]);
                      };
                      while (!$tco_done1) {
                          $tco_result = $tco_loop($tco_var_acc, $copy_v);
                      };
                      return $tco_result;
                  };
              };
              return go(Nil.value);
          })();
          var $207 = Data_Foldable.foldl(foldableList)(Data_Function.flip(f))(b);
          return function ($208) {
              return $207(rev($208));
          };
      };
  });
  var foldableNonEmptyList = Data_NonEmpty.foldableNonEmpty(foldableList);
  var foldableWithIndexList = new Data_FoldableWithIndex.FoldableWithIndex(function () {
      return foldableList;
  }, function (dictMonoid) {
      return function (f) {
          return Data_FoldableWithIndex.foldlWithIndex(foldableWithIndexList)(function (i) {
              return function (acc) {
                  var $209 = Data_Semigroup.append(dictMonoid.Semigroup0())(acc);
                  var $210 = f(i);
                  return function ($211) {
                      return $209($210($211));
                  };
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  }, function (f) {
      return function (acc) {
          var $212 = Data_Foldable.foldl(foldableList)(function (v) {
              return function (a) {
                  return new Data_Tuple.Tuple(v.value0 + 1 | 0, f(v.value0)(v.value1)(a));
              };
          })(new Data_Tuple.Tuple(0, acc));
          return function ($213) {
              return Data_Tuple.snd($212($213));
          };
      };
  }, function (f) {
      return function (b) {
          return function (xs) {
              var v = (function () {
                  var rev = Data_Foldable.foldl(foldableList)(function (v1) {
                      return function (a) {
                          return new Data_Tuple.Tuple(v1.value0 + 1 | 0, new Cons(a, v1.value1));
                      };
                  });
                  return rev(new Data_Tuple.Tuple(0, Nil.value))(xs);
              })();
              return Data_Tuple.snd(Data_Foldable.foldl(foldableList)(function (v1) {
                  return function (a) {
                      return new Data_Tuple.Tuple(v1.value0 - 1 | 0, f(v1.value0 - 1 | 0)(a)(v1.value1));
                  };
              })(new Data_Tuple.Tuple(v.value0, b))(v.value1));
          };
      };
  });
  var functorWithIndexList = new Data_FunctorWithIndex.FunctorWithIndex(function () {
      return functorList;
  }, function (f) {
      return Data_FoldableWithIndex.foldrWithIndex(foldableWithIndexList)(function (i) {
          return function (x) {
              return function (acc) {
                  return new Cons(f(i)(x), acc);
              };
          };
      })(Nil.value);
  });
  var semigroupList = new Data_Semigroup.Semigroup(function (xs) {
      return function (ys) {
          return Data_Foldable.foldr(foldableList)(Cons.create)(ys)(xs);
      };
  });
  var monoidList = new Data_Monoid.Monoid(function () {
      return semigroupList;
  }, Nil.value);
  var semigroupNonEmptyList = new Data_Semigroup.Semigroup(function (v) {
      return function (as$prime) {
          return new Data_NonEmpty.NonEmpty(v.value0, Data_Semigroup.append(semigroupList)(v.value1)(toList(as$prime)));
      };
  });
  var showList = function (dictShow) {
      return new Data_Show.Show(function (v) {
          if (v instanceof Nil) {
              return "Nil";
          };
          return "(" + (Data_Foldable.intercalate(foldableList)(Data_Monoid.monoidString)(" : ")(Data_Functor.map(functorList)(Data_Show.show(dictShow))(v)) + " : Nil)");
      });
  };
  var showNonEmptyList = function (dictShow) {
      return new Data_Show.Show(function (v) {
          return "(NonEmptyList " + (Data_Show.show(Data_NonEmpty.showNonEmpty(dictShow)(showList(dictShow)))(v) + ")");
      });
  };
  var traversableList = new Data_Traversable.Traversable(function () {
      return foldableList;
  }, function () {
      return functorList;
  }, function (dictApplicative) {
      return Data_Traversable.traverse(traversableList)(dictApplicative)(Control_Category.identity(Control_Category.categoryFn));
  }, function (dictApplicative) {
      return function (f) {
          var $222 = Data_Functor.map((dictApplicative.Apply0()).Functor0())(Data_Foldable.foldl(foldableList)(Data_Function.flip(Cons.create))(Nil.value));
          var $223 = Data_Foldable.foldl(foldableList)(function (acc) {
              var $225 = Control_Apply.lift2(dictApplicative.Apply0())(Data_Function.flip(Cons.create))(acc);
              return function ($226) {
                  return $225(f($226));
              };
          })(Control_Applicative.pure(dictApplicative)(Nil.value));
          return function ($224) {
              return $222($223($224));
          };
      };
  });
  var unfoldable1List = new Data_Unfoldable1.Unfoldable1(function (f) {
      return function (b) {
          var go = function ($copy_source) {
              return function ($copy_memo) {
                  var $tco_var_source = $copy_source;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(source, memo) {
                      var v = f(source);
                      if (v.value1 instanceof Data_Maybe.Just) {
                          $tco_var_source = v.value1.value0;
                          $copy_memo = new Cons(v.value0, memo);
                          return;
                      };
                      if (v.value1 instanceof Data_Maybe.Nothing) {
                          $tco_done = true;
                          return Data_Foldable.foldl(foldableList)(Data_Function.flip(Cons.create))(Nil.value)(new Cons(v.value0, memo));
                      };
                      throw new Error("Failed pattern match at Data.List.Types (line 136, column 22 - line 138, column 61): " + [ v.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_source, $copy_memo);
                  };
                  return $tco_result;
              };
          };
          return go(b)(Nil.value);
      };
  });
  var unfoldableList = new Data_Unfoldable.Unfoldable(function () {
      return unfoldable1List;
  }, function (f) {
      return function (b) {
          var go = function ($copy_source) {
              return function ($copy_memo) {
                  var $tco_var_source = $copy_source;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(source, memo) {
                      var v = f(source);
                      if (v instanceof Data_Maybe.Nothing) {
                          $tco_done = true;
                          return Data_Foldable.foldl(foldableList)(Data_Function.flip(Cons.create))(Nil.value)(memo);
                      };
                      if (v instanceof Data_Maybe.Just) {
                          $tco_var_source = v.value0.value1;
                          $copy_memo = new Cons(v.value0.value0, memo);
                          return;
                      };
                      throw new Error("Failed pattern match at Data.List.Types (line 143, column 22 - line 145, column 52): " + [ v.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_source, $copy_memo);
                  };
                  return $tco_result;
              };
          };
          return go(b)(Nil.value);
      };
  });
  var eq1List = new Data_Eq.Eq1(function (dictEq) {
      return function (xs) {
          return function (ys) {
              var go = function ($copy_v) {
                  return function ($copy_v1) {
                      return function ($copy_v2) {
                          var $tco_var_v = $copy_v;
                          var $tco_var_v1 = $copy_v1;
                          var $tco_done = false;
                          var $tco_result;
                          function $tco_loop(v, v1, v2) {
                              if (!v2) {
                                  $tco_done = true;
                                  return false;
                              };
                              if (v instanceof Nil && v1 instanceof Nil) {
                                  $tco_done = true;
                                  return v2;
                              };
                              if (v instanceof Cons && v1 instanceof Cons) {
                                  $tco_var_v = v.value1;
                                  $tco_var_v1 = v1.value1;
                                  $copy_v2 = v2 && Data_Eq.eq(dictEq)(v1.value0)(v.value0);
                                  return;
                              };
                              $tco_done = true;
                              return false;
                          };
                          while (!$tco_done) {
                              $tco_result = $tco_loop($tco_var_v, $tco_var_v1, $copy_v2);
                          };
                          return $tco_result;
                      };
                  };
              };
              return go(xs)(ys)(true);
          };
      };
  });                                                      
  var eqList = function (dictEq) {
      return new Data_Eq.Eq(Data_Eq.eq1(eq1List)(dictEq));
  }; 
  var applyList = new Control_Apply.Apply(function () {
      return functorList;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nil) {
              return Nil.value;
          };
          if (v instanceof Cons) {
              return Data_Semigroup.append(semigroupList)(Data_Functor.map(functorList)(v.value0)(v1))(Control_Apply.apply(applyList)(v.value1)(v1));
          };
          throw new Error("Failed pattern match at Data.List.Types (line 158, column 1 - line 160, column 48): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var applyNonEmptyList = new Control_Apply.Apply(function () {
      return functorNonEmptyList;
  }, function (v) {
      return function (v1) {
          return new Data_NonEmpty.NonEmpty(v.value0(v1.value0), Data_Semigroup.append(semigroupList)(Control_Apply.apply(applyList)(v.value1)(new Cons(v1.value0, Nil.value)))(Control_Apply.apply(applyList)(new Cons(v.value0, v.value1))(v1.value1)));
      };
  });
  var bindList = new Control_Bind.Bind(function () {
      return applyList;
  }, function (v) {
      return function (v1) {
          if (v instanceof Nil) {
              return Nil.value;
          };
          if (v instanceof Cons) {
              return Data_Semigroup.append(semigroupList)(v1(v.value0))(Control_Bind.bind(bindList)(v.value1)(v1));
          };
          throw new Error("Failed pattern match at Data.List.Types (line 165, column 1 - line 167, column 37): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var applicativeList = new Control_Applicative.Applicative(function () {
      return applyList;
  }, function (a) {
      return new Cons(a, Nil.value);
  });                                              
  var altList = new Control_Alt.Alt(function () {
      return functorList;
  }, Data_Semigroup.append(semigroupList));
  var plusList = new Control_Plus.Plus(function () {
      return altList;
  }, Nil.value);
  var applicativeNonEmptyList = new Control_Applicative.Applicative(function () {
      return applyNonEmptyList;
  }, (function () {
      var $236 = Data_NonEmpty.singleton(plusList);
      return function ($237) {
          return NonEmptyList($236($237));
      };
  })());
  exports["Nil"] = Nil;
  exports["Cons"] = Cons;
  exports["NonEmptyList"] = NonEmptyList;
  exports["eqList"] = eqList;
  exports["semigroupList"] = semigroupList;
  exports["monoidList"] = monoidList;
  exports["functorList"] = functorList;
  exports["functorWithIndexList"] = functorWithIndexList;
  exports["foldableList"] = foldableList;
  exports["unfoldableList"] = unfoldableList;
  exports["traversableList"] = traversableList;
  exports["applicativeList"] = applicativeList;
  exports["bindList"] = bindList;
  exports["plusList"] = plusList;
  exports["showNonEmptyList"] = showNonEmptyList;
  exports["functorNonEmptyList"] = functorNonEmptyList;
  exports["applicativeNonEmptyList"] = applicativeNonEmptyList;
  exports["semigroupNonEmptyList"] = semigroupNonEmptyList;
  exports["foldableNonEmptyList"] = foldableNonEmptyList;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.List.NonEmpty"] = $PS["Data.List.NonEmpty"] || {};
  var exports = $PS["Data.List.NonEmpty"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_NonEmpty = $PS["Data.NonEmpty"];
  var singleton = (function () {
      var $172 = Data_NonEmpty.singleton(Data_List_Types.plusList);
      return function ($173) {
          return Data_List_Types.NonEmptyList($172($173));
      };
  })();
  var head = function (v) {
      return v.value0;
  };
  var cons$prime = function (x) {
      return function (xs) {
          return new Data_NonEmpty.NonEmpty(x, xs);
      };
  };
  exports["singleton"] = singleton;
  exports["cons'"] = cons$prime;
  exports["head"] = head;
})(PS);
(function(exports) {
  /* eslint-disable no-eq-null, eqeqeq */

  "use strict";

  exports["null"] = null;

  exports.nullable = function (a, r, f) {
    return a == null ? r : f(a);
  };

  exports.notNull = function (x) {
    return x;
  };
})(PS["Data.Nullable"] = PS["Data.Nullable"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Nullable"] = $PS["Data.Nullable"] || {};
  var exports = $PS["Data.Nullable"];
  var $foreign = $PS["Data.Nullable"];
  var Data_Maybe = $PS["Data.Maybe"];              
  var toNullable = Data_Maybe.maybe($foreign["null"])($foreign.notNull);
  var toMaybe = function (n) {
      return $foreign.nullable(n, Data_Maybe.Nothing.value, Data_Maybe.Just.create);
  };
  exports["toMaybe"] = toMaybe;
  exports["toNullable"] = toNullable;
  exports["null"] = $foreign["null"];
})(PS);
(function(exports) {
  /* globals setImmediate, clearImmediate, setTimeout, clearTimeout */
  /* eslint-disable no-unused-vars, no-prototype-builtins, no-use-before-define, no-unused-labels, no-param-reassign */
  "use strict";

  var Aff = function () {
    // A unique value for empty.
    var EMPTY = {};

    /*

  An awkward approximation. We elide evidence we would otherwise need in PS for
  efficiency sake.

  data Aff eff a
    = Pure a
    | Throw Error
    | Catch (Aff eff a) (Error -> Aff eff a)
    | Sync (Eff eff a)
    | Async ((Either Error a -> Eff eff Unit) -> Eff eff (Canceler eff))
    | forall b. Bind (Aff eff b) (b -> Aff eff a)
    | forall b. Bracket (Aff eff b) (BracketConditions eff b) (b -> Aff eff a)
    | forall b. Fork Boolean (Aff eff b) ?(Fiber eff b -> a)
    | Sequential (ParAff aff a)

  */  
    var PURE    = "Pure";
    var THROW   = "Throw";
    var CATCH   = "Catch";
    var SYNC    = "Sync";
    var ASYNC   = "Async";
    var BIND    = "Bind";
    var BRACKET = "Bracket";
    var FORK    = "Fork";
    var SEQ     = "Sequential";

    /*

  data ParAff eff a
    = forall b. Map (b -> a) (ParAff eff b)
    | forall b. Apply (ParAff eff (b -> a)) (ParAff eff b)
    | Alt (ParAff eff a) (ParAff eff a)
    | ?Par (Aff eff a)

  */  
    var MAP   = "Map";
    var APPLY = "Apply";
    var ALT   = "Alt";

    // Various constructors used in interpretation
    var CONS      = "Cons";      // Cons-list, for stacks
    var RESUME    = "Resume";    // Continue indiscriminately
    var RELEASE   = "Release";   // Continue with bracket finalizers
    var FINALIZER = "Finalizer"; // A non-interruptible effect
    var FINALIZED = "Finalized"; // Marker for finalization
    var FORKED    = "Forked";    // Reference to a forked fiber, with resumption stack
    var FIBER     = "Fiber";     // Actual fiber reference
    var THUNK     = "Thunk";     // Primed effect, ready to invoke

    function Aff(tag, _1, _2, _3) {
      this.tag = tag;
      this._1  = _1;
      this._2  = _2;
      this._3  = _3;
    }

    function AffCtr(tag) {
      var fn = function (_1, _2, _3) {
        return new Aff(tag, _1, _2, _3);
      };
      fn.tag = tag;
      return fn;
    }

    function nonCanceler(error) {
      return new Aff(PURE, void 0);
    }

    function runEff(eff) {
      try {
        eff();
      } catch (error) {
        setTimeout(function () {
          throw error;
        }, 0);
      }
    }

    function runSync(left, right, eff) {
      try {
        return right(eff());
      } catch (error) {
        return left(error);
      }
    }

    function runAsync(left, eff, k) {
      try {
        return eff(k)();
      } catch (error) {
        k(left(error))();
        return nonCanceler;
      }
    }

    var Scheduler = function () {
      var limit    = 1024;
      var size     = 0;
      var ix       = 0;
      var queue    = new Array(limit);
      var draining = false;

      function drain() {
        var thunk;
        draining = true;
        while (size !== 0) {
          size--;
          thunk     = queue[ix];
          queue[ix] = void 0;
          ix        = (ix + 1) % limit;
          thunk();
        }
        draining = false;
      }

      return {
        isDraining: function () {
          return draining;
        },
        enqueue: function (cb) {
          var i, tmp;
          if (size === limit) {
            tmp = draining;
            drain();
            draining = tmp;
          }

          queue[(ix + size) % limit] = cb;
          size++;

          if (!draining) {
            drain();
          }
        }
      };
    }();

    function Supervisor(util) {
      var fibers  = {};
      var fiberId = 0;
      var count   = 0;

      return {
        register: function (fiber) {
          var fid = fiberId++;
          fiber.onComplete({
            rethrow: true,
            handler: function (result) {
              return function () {
                count--;
                delete fibers[fid];
              };
            }
          })();
          fibers[fid] = fiber;
          count++;
        },
        isEmpty: function () {
          return count === 0;
        },
        killAll: function (killError, cb) {
          return function () {
            if (count === 0) {
              return cb();
            }

            var killCount = 0;
            var kills     = {};

            function kill(fid) {
              kills[fid] = fibers[fid].kill(killError, function (result) {
                return function () {
                  delete kills[fid];
                  killCount--;
                  if (util.isLeft(result) && util.fromLeft(result)) {
                    setTimeout(function () {
                      throw util.fromLeft(result);
                    }, 0);
                  }
                  if (killCount === 0) {
                    cb();
                  }
                };
              })();
            }

            for (var k in fibers) {
              if (fibers.hasOwnProperty(k)) {
                killCount++;
                kill(k);
              }
            }

            fibers  = {};
            fiberId = 0;
            count   = 0;

            return function (error) {
              return new Aff(SYNC, function () {
                for (var k in kills) {
                  if (kills.hasOwnProperty(k)) {
                    kills[k]();
                  }
                }
              });
            };
          };
        }
      };
    }

    // Fiber state machine
    var SUSPENDED   = 0; // Suspended, pending a join.
    var CONTINUE    = 1; // Interpret the next instruction.
    var STEP_BIND   = 2; // Apply the next bind.
    var STEP_RESULT = 3; // Handle potential failure from a result.
    var PENDING     = 4; // An async effect is running.
    var RETURN      = 5; // The current stack has returned.
    var COMPLETED   = 6; // The entire fiber has completed.

    function Fiber(util, supervisor, aff) {
      // Monotonically increasing tick, increased on each asynchronous turn.
      var runTick = 0;

      // The current branch of the state machine.
      var status = SUSPENDED;

      // The current point of interest for the state machine branch.
      var step      = aff;  // Successful step
      var fail      = null; // Failure step
      var interrupt = null; // Asynchronous interrupt

      // Stack of continuations for the current fiber.
      var bhead = null;
      var btail = null;

      // Stack of attempts and finalizers for error recovery. Every `Cons` is also
      // tagged with current `interrupt` state. We use this to track which items
      // should be ignored or evaluated as a result of a kill.
      var attempts = null;

      // A special state is needed for Bracket, because it cannot be killed. When
      // we enter a bracket acquisition or finalizer, we increment the counter,
      // and then decrement once complete.
      var bracketCount = 0;

      // Each join gets a new id so they can be revoked.
      var joinId  = 0;
      var joins   = null;
      var rethrow = true;

      // Each invocation of `run` requires a tick. When an asynchronous effect is
      // resolved, we must check that the local tick coincides with the fiber
      // tick before resuming. This prevents multiple async continuations from
      // accidentally resuming the same fiber. A common example may be invoking
      // the provided callback in `makeAff` more than once, but it may also be an
      // async effect resuming after the fiber was already cancelled.
      function run(localRunTick) {
        var tmp, result, attempt;
        while (true) {
          tmp       = null;
          result    = null;
          attempt   = null;

          switch (status) {
          case STEP_BIND:
            status = CONTINUE;
            try {
              step   = bhead(step);
              if (btail === null) {
                bhead = null;
              } else {
                bhead = btail._1;
                btail = btail._2;
              }
            } catch (e) {
              status = RETURN;
              fail   = util.left(e);
              step   = null;
            }
            break;

          case STEP_RESULT:
            if (util.isLeft(step)) {
              status = RETURN;
              fail   = step;
              step   = null;
            } else if (bhead === null) {
              status = RETURN;
            } else {
              status = STEP_BIND;
              step   = util.fromRight(step);
            }
            break;

          case CONTINUE:
            switch (step.tag) {
            case BIND:
              if (bhead) {
                btail = new Aff(CONS, bhead, btail);
              }
              bhead  = step._2;
              status = CONTINUE;
              step   = step._1;
              break;

            case PURE:
              if (bhead === null) {
                status = RETURN;
                step   = util.right(step._1);
              } else {
                status = STEP_BIND;
                step   = step._1;
              }
              break;

            case SYNC:
              status = STEP_RESULT;
              step   = runSync(util.left, util.right, step._1);
              break;

            case ASYNC:
              status = PENDING;
              step   = runAsync(util.left, step._1, function (result) {
                return function () {
                  if (runTick !== localRunTick) {
                    return;
                  }
                  runTick++;
                  Scheduler.enqueue(function () {
                    // It's possible to interrupt the fiber between enqueuing and
                    // resuming, so we need to check that the runTick is still
                    // valid.
                    if (runTick !== localRunTick + 1) {
                      return;
                    }
                    status = STEP_RESULT;
                    step   = result;
                    run(runTick);
                  });
                };
              });
              return;

            case THROW:
              status = RETURN;
              fail   = util.left(step._1);
              step   = null;
              break;

            // Enqueue the Catch so that we can call the error handler later on
            // in case of an exception.
            case CATCH:
              if (bhead === null) {
                attempts = new Aff(CONS, step, attempts, interrupt);
              } else {
                attempts = new Aff(CONS, step, new Aff(CONS, new Aff(RESUME, bhead, btail), attempts, interrupt), interrupt);
              }
              bhead    = null;
              btail    = null;
              status   = CONTINUE;
              step     = step._1;
              break;

            // Enqueue the Bracket so that we can call the appropriate handlers
            // after resource acquisition.
            case BRACKET:
              bracketCount++;
              if (bhead === null) {
                attempts = new Aff(CONS, step, attempts, interrupt);
              } else {
                attempts = new Aff(CONS, step, new Aff(CONS, new Aff(RESUME, bhead, btail), attempts, interrupt), interrupt);
              }
              bhead  = null;
              btail  = null;
              status = CONTINUE;
              step   = step._1;
              break;

            case FORK:
              status = STEP_RESULT;
              tmp    = Fiber(util, supervisor, step._2);
              if (supervisor) {
                supervisor.register(tmp);
              }
              if (step._1) {
                tmp.run();
              }
              step = util.right(tmp);
              break;

            case SEQ:
              status = CONTINUE;
              step   = sequential(util, supervisor, step._1);
              break;
            }
            break;

          case RETURN:
            bhead = null;
            btail = null;
            // If the current stack has returned, and we have no other stacks to
            // resume or finalizers to run, the fiber has halted and we can
            // invoke all join callbacks. Otherwise we need to resume.
            if (attempts === null) {
              status = COMPLETED;
              step   = interrupt || fail || step;
            } else {
              // The interrupt status for the enqueued item.
              tmp      = attempts._3;
              attempt  = attempts._1;
              attempts = attempts._2;

              switch (attempt.tag) {
              // We cannot recover from an unmasked interrupt. Otherwise we should
              // continue stepping, or run the exception handler if an exception
              // was raised.
              case CATCH:
                // We should compare the interrupt status as well because we
                // only want it to apply if there has been an interrupt since
                // enqueuing the catch.
                if (interrupt && interrupt !== tmp && bracketCount === 0) {
                  status = RETURN;
                } else if (fail) {
                  status = CONTINUE;
                  step   = attempt._2(util.fromLeft(fail));
                  fail   = null;
                }
                break;

              // We cannot resume from an unmasked interrupt or exception.
              case RESUME:
                // As with Catch, we only want to ignore in the case of an
                // interrupt since enqueing the item.
                if (interrupt && interrupt !== tmp && bracketCount === 0 || fail) {
                  status = RETURN;
                } else {
                  bhead  = attempt._1;
                  btail  = attempt._2;
                  status = STEP_BIND;
                  step   = util.fromRight(step);
                }
                break;

              // If we have a bracket, we should enqueue the handlers,
              // and continue with the success branch only if the fiber has
              // not been interrupted. If the bracket acquisition failed, we
              // should not run either.
              case BRACKET:
                bracketCount--;
                if (fail === null) {
                  result   = util.fromRight(step);
                  // We need to enqueue the Release with the same interrupt
                  // status as the Bracket that is initiating it.
                  attempts = new Aff(CONS, new Aff(RELEASE, attempt._2, result), attempts, tmp);
                  // We should only coninue as long as the interrupt status has not changed or
                  // we are currently within a non-interruptable finalizer.
                  if (interrupt === tmp || bracketCount > 0) {
                    status = CONTINUE;
                    step   = attempt._3(result);
                  }
                }
                break;

              // Enqueue the appropriate handler. We increase the bracket count
              // because it should not be cancelled.
              case RELEASE:
                attempts = new Aff(CONS, new Aff(FINALIZED, step, fail), attempts, interrupt);
                status   = CONTINUE;
                // It has only been killed if the interrupt status has changed
                // since we enqueued the item, and the bracket count is 0. If the
                // bracket count is non-zero then we are in a masked state so it's
                // impossible to be killed.
                if (interrupt && interrupt !== tmp && bracketCount === 0) {
                  step = attempt._1.killed(util.fromLeft(interrupt))(attempt._2);
                } else if (fail) {
                  step = attempt._1.failed(util.fromLeft(fail))(attempt._2);
                } else {
                  step = attempt._1.completed(util.fromRight(step))(attempt._2);
                }
                fail = null;
                bracketCount++;
                break;

              case FINALIZER:
                bracketCount++;
                attempts = new Aff(CONS, new Aff(FINALIZED, step, fail), attempts, interrupt);
                status   = CONTINUE;
                step     = attempt._1;
                break;

              case FINALIZED:
                bracketCount--;
                status = RETURN;
                step   = attempt._1;
                fail   = attempt._2;
                break;
              }
            }
            break;

          case COMPLETED:
            for (var k in joins) {
              if (joins.hasOwnProperty(k)) {
                rethrow = rethrow && joins[k].rethrow;
                runEff(joins[k].handler(step));
              }
            }
            joins = null;
            // If we have an interrupt and a fail, then the thread threw while
            // running finalizers. This should always rethrow in a fresh stack.
            if (interrupt && fail) {
              setTimeout(function () {
                throw util.fromLeft(fail);
              }, 0);
            // If we have an unhandled exception, and no other fiber has joined
            // then we need to throw the exception in a fresh stack.
            } else if (util.isLeft(step) && rethrow) {
              setTimeout(function () {
                // Guard on reathrow because a completely synchronous fiber can
                // still have an observer which was added after-the-fact.
                if (rethrow) {
                  throw util.fromLeft(step);
                }
              }, 0);
            }
            return;
          case SUSPENDED:
            status = CONTINUE;
            break;
          case PENDING: return;
          }
        }
      }

      function onComplete(join) {
        return function () {
          if (status === COMPLETED) {
            rethrow = rethrow && join.rethrow;
            join.handler(step)();
            return function () {};
          }

          var jid    = joinId++;
          joins      = joins || {};
          joins[jid] = join;

          return function() {
            if (joins !== null) {
              delete joins[jid];
            }
          };
        };
      }

      function kill(error, cb) {
        return function () {
          if (status === COMPLETED) {
            cb(util.right(void 0))();
            return function () {};
          }

          var canceler = onComplete({
            rethrow: false,
            handler: function (/* unused */) {
              return cb(util.right(void 0));
            }
          })();

          switch (status) {
          case SUSPENDED:
            interrupt = util.left(error);
            status    = COMPLETED;
            step      = interrupt;
            run(runTick);
            break;
          case PENDING:
            if (interrupt === null) {
              interrupt = util.left(error);
            }
            if (bracketCount === 0) {
              if (status === PENDING) {
                attempts = new Aff(CONS, new Aff(FINALIZER, step(error)), attempts, interrupt);
              }
              status   = RETURN;
              step     = null;
              fail     = null;
              run(++runTick);
            }
            break;
          default:
            if (interrupt === null) {
              interrupt = util.left(error);
            }
            if (bracketCount === 0) {
              status = RETURN;
              step   = null;
              fail   = null;
            }
          }

          return canceler;
        };
      }

      function join(cb) {
        return function () {
          var canceler = onComplete({
            rethrow: false,
            handler: cb
          })();
          if (status === SUSPENDED) {
            run(runTick);
          }
          return canceler;
        };
      }

      return {
        kill: kill,
        join: join,
        onComplete: onComplete,
        isSuspended: function () {
          return status === SUSPENDED;
        },
        run: function () {
          if (status === SUSPENDED) {
            if (!Scheduler.isDraining()) {
              Scheduler.enqueue(function () {
                run(runTick);
              });
            } else {
              run(runTick);
            }
          }
        }
      };
    }

    function runPar(util, supervisor, par, cb) {
      // Table of all forked fibers.
      var fiberId   = 0;
      var fibers    = {};

      // Table of currently running cancelers, as a product of `Alt` behavior.
      var killId    = 0;
      var kills     = {};

      // Error used for early cancelation on Alt branches.
      var early     = new Error("[ParAff] Early exit");

      // Error used to kill the entire tree.
      var interrupt = null;

      // The root pointer of the tree.
      var root      = EMPTY;

      // Walks a tree, invoking all the cancelers. Returns the table of pending
      // cancellation fibers.
      function kill(error, par, cb) {
        var step  = par;
        var head  = null;
        var tail  = null;
        var count = 0;
        var kills = {};
        var tmp, kid;

        loop: while (true) {
          tmp = null;

          switch (step.tag) {
          case FORKED:
            if (step._3 === EMPTY) {
              tmp = fibers[step._1];
              kills[count++] = tmp.kill(error, function (result) {
                return function () {
                  count--;
                  if (count === 0) {
                    cb(result)();
                  }
                };
              });
            }
            // Terminal case.
            if (head === null) {
              break loop;
            }
            // Go down the right side of the tree.
            step = head._2;
            if (tail === null) {
              head = null;
            } else {
              head = tail._1;
              tail = tail._2;
            }
            break;
          case MAP:
            step = step._2;
            break;
          case APPLY:
          case ALT:
            if (head) {
              tail = new Aff(CONS, head, tail);
            }
            head = step;
            step = step._1;
            break;
          }
        }

        if (count === 0) {
          cb(util.right(void 0))();
        } else {
          // Run the cancelation effects. We alias `count` because it's mutable.
          kid = 0;
          tmp = count;
          for (; kid < tmp; kid++) {
            kills[kid] = kills[kid]();
          }
        }

        return kills;
      }

      // When a fiber resolves, we need to bubble back up the tree with the
      // result, computing the applicative nodes.
      function join(result, head, tail) {
        var fail, step, lhs, rhs, tmp, kid;

        if (util.isLeft(result)) {
          fail = result;
          step = null;
        } else {
          step = result;
          fail = null;
        }

        loop: while (true) {
          lhs = null;
          rhs = null;
          tmp = null;
          kid = null;

          // We should never continue if the entire tree has been interrupted.
          if (interrupt !== null) {
            return;
          }

          // We've made it all the way to the root of the tree, which means
          // the tree has fully evaluated.
          if (head === null) {
            cb(fail || step)();
            return;
          }

          // The tree has already been computed, so we shouldn't try to do it
          // again. This should never happen.
          // TODO: Remove this?
          if (head._3 !== EMPTY) {
            return;
          }

          switch (head.tag) {
          case MAP:
            if (fail === null) {
              head._3 = util.right(head._1(util.fromRight(step)));
              step    = head._3;
            } else {
              head._3 = fail;
            }
            break;
          case APPLY:
            lhs = head._1._3;
            rhs = head._2._3;
            // If we have a failure we should kill the other side because we
            // can't possible yield a result anymore.
            if (fail) {
              head._3 = fail;
              tmp     = true;
              kid     = killId++;

              kills[kid] = kill(early, fail === lhs ? head._2 : head._1, function (/* unused */) {
                return function () {
                  delete kills[kid];
                  if (tmp) {
                    tmp = false;
                  } else if (tail === null) {
                    join(fail, null, null);
                  } else {
                    join(fail, tail._1, tail._2);
                  }
                };
              });

              if (tmp) {
                tmp = false;
                return;
              }
            } else if (lhs === EMPTY || rhs === EMPTY) {
              // We can only proceed if both sides have resolved.
              return;
            } else {
              step    = util.right(util.fromRight(lhs)(util.fromRight(rhs)));
              head._3 = step;
            }
            break;
          case ALT:
            lhs = head._1._3;
            rhs = head._2._3;
            // We can only proceed if both have resolved or we have a success
            if (lhs === EMPTY && util.isLeft(rhs) || rhs === EMPTY && util.isLeft(lhs)) {
              return;
            }
            // If both sides resolve with an error, we should continue with the
            // first error
            if (lhs !== EMPTY && util.isLeft(lhs) && rhs !== EMPTY && util.isLeft(rhs)) {
              fail    = step === lhs ? rhs : lhs;
              step    = null;
              head._3 = fail;
            } else {
              head._3 = step;
              tmp     = true;
              kid     = killId++;
              // Once a side has resolved, we need to cancel the side that is still
              // pending before we can continue.
              kills[kid] = kill(early, step === lhs ? head._2 : head._1, function (/* unused */) {
                return function () {
                  delete kills[kid];
                  if (tmp) {
                    tmp = false;
                  } else if (tail === null) {
                    join(step, null, null);
                  } else {
                    join(step, tail._1, tail._2);
                  }
                };
              });

              if (tmp) {
                tmp = false;
                return;
              }
            }
            break;
          }

          if (tail === null) {
            head = null;
          } else {
            head = tail._1;
            tail = tail._2;
          }
        }
      }

      function resolve(fiber) {
        return function (result) {
          return function () {
            delete fibers[fiber._1];
            fiber._3 = result;
            join(result, fiber._2._1, fiber._2._2);
          };
        };
      }

      // Walks the applicative tree, substituting non-applicative nodes with
      // `FORKED` nodes. In this tree, all applicative nodes use the `_3` slot
      // as a mutable slot for memoization. In an unresolved state, the `_3`
      // slot is `EMPTY`. In the cases of `ALT` and `APPLY`, we always walk
      // the left side first, because both operations are left-associative. As
      // we `RETURN` from those branches, we then walk the right side.
      function run() {
        var status = CONTINUE;
        var step   = par;
        var head   = null;
        var tail   = null;
        var tmp, fid;

        loop: while (true) {
          tmp = null;
          fid = null;

          switch (status) {
          case CONTINUE:
            switch (step.tag) {
            case MAP:
              if (head) {
                tail = new Aff(CONS, head, tail);
              }
              head = new Aff(MAP, step._1, EMPTY, EMPTY);
              step = step._2;
              break;
            case APPLY:
              if (head) {
                tail = new Aff(CONS, head, tail);
              }
              head = new Aff(APPLY, EMPTY, step._2, EMPTY);
              step = step._1;
              break;
            case ALT:
              if (head) {
                tail = new Aff(CONS, head, tail);
              }
              head = new Aff(ALT, EMPTY, step._2, EMPTY);
              step = step._1;
              break;
            default:
              // When we hit a leaf value, we suspend the stack in the `FORKED`.
              // When the fiber resolves, it can bubble back up the tree.
              fid    = fiberId++;
              status = RETURN;
              tmp    = step;
              step   = new Aff(FORKED, fid, new Aff(CONS, head, tail), EMPTY);
              tmp    = Fiber(util, supervisor, tmp);
              tmp.onComplete({
                rethrow: false,
                handler: resolve(step)
              })();
              fibers[fid] = tmp;
              if (supervisor) {
                supervisor.register(tmp);
              }
            }
            break;
          case RETURN:
            // Terminal case, we are back at the root.
            if (head === null) {
              break loop;
            }
            // If we are done with the right side, we need to continue down the
            // left. Otherwise we should continue up the stack.
            if (head._1 === EMPTY) {
              head._1 = step;
              status  = CONTINUE;
              step    = head._2;
              head._2 = EMPTY;
            } else {
              head._2 = step;
              step    = head;
              if (tail === null) {
                head  = null;
              } else {
                head  = tail._1;
                tail  = tail._2;
              }
            }
          }
        }

        // Keep a reference to the tree root so it can be cancelled.
        root = step;

        for (fid = 0; fid < fiberId; fid++) {
          fibers[fid].run();
        }
      }

      // Cancels the entire tree. If there are already subtrees being canceled,
      // we need to first cancel those joins. We will then add fresh joins for
      // all pending branches including those that were in the process of being
      // canceled.
      function cancel(error, cb) {
        interrupt = util.left(error);
        var innerKills;
        for (var kid in kills) {
          if (kills.hasOwnProperty(kid)) {
            innerKills = kills[kid];
            for (kid in innerKills) {
              if (innerKills.hasOwnProperty(kid)) {
                innerKills[kid]();
              }
            }
          }
        }

        kills = null;
        var newKills = kill(error, root, cb);

        return function (killError) {
          return new Aff(ASYNC, function (killCb) {
            return function () {
              for (var kid in newKills) {
                if (newKills.hasOwnProperty(kid)) {
                  newKills[kid]();
                }
              }
              return nonCanceler;
            };
          });
        };
      }

      run();

      return function (killError) {
        return new Aff(ASYNC, function (killCb) {
          return function () {
            return cancel(killError, killCb);
          };
        });
      };
    }

    function sequential(util, supervisor, par) {
      return new Aff(ASYNC, function (cb) {
        return function () {
          return runPar(util, supervisor, par, cb);
        };
      });
    }

    Aff.EMPTY       = EMPTY;
    Aff.Pure        = AffCtr(PURE);
    Aff.Throw       = AffCtr(THROW);
    Aff.Catch       = AffCtr(CATCH);
    Aff.Sync        = AffCtr(SYNC);
    Aff.Async       = AffCtr(ASYNC);
    Aff.Bind        = AffCtr(BIND);
    Aff.Bracket     = AffCtr(BRACKET);
    Aff.Fork        = AffCtr(FORK);
    Aff.Seq         = AffCtr(SEQ);
    Aff.ParMap      = AffCtr(MAP);
    Aff.ParApply    = AffCtr(APPLY);
    Aff.ParAlt      = AffCtr(ALT);
    Aff.Fiber       = Fiber;
    Aff.Supervisor  = Supervisor;
    Aff.Scheduler   = Scheduler;
    Aff.nonCanceler = nonCanceler;

    return Aff;
  }();

  exports._pure = Aff.Pure;

  exports._throwError = Aff.Throw;

  exports._catchError = function (aff) {
    return function (k) {
      return Aff.Catch(aff, k);
    };
  };

  exports._map = function (f) {
    return function (aff) {
      if (aff.tag === Aff.Pure.tag) {
        return Aff.Pure(f(aff._1));
      } else {
        return Aff.Bind(aff, function (value) {
          return Aff.Pure(f(value));
        });
      }
    };
  };

  exports._bind = function (aff) {
    return function (k) {
      return Aff.Bind(aff, k);
    };
  };

  exports._liftEffect = Aff.Sync;

  exports._parAffMap = function (f) {
    return function (aff) {
      return Aff.ParMap(f, aff);
    };
  };

  exports._parAffApply = function (aff1) {
    return function (aff2) {
      return Aff.ParApply(aff1, aff2);
    };
  };

  exports.makeAff = Aff.Async;

  exports._makeFiber = function (util, aff) {
    return function () {
      return Aff.Fiber(util, null, aff);
    };
  };  

  exports._sequential = Aff.Seq;
})(PS["Effect.Aff"] = PS["Effect.Aff"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Parallel.Class"] = $PS["Control.Parallel.Class"] || {};
  var exports = $PS["Control.Parallel.Class"];       
  var Parallel = function (Applicative1, Monad0, parallel, sequential) {
      this.Applicative1 = Applicative1;
      this.Monad0 = Monad0;
      this.parallel = parallel;
      this.sequential = sequential;
  };
  var sequential = function (dict) {
      return dict.sequential;
  };
  var parallel = function (dict) {
      return dict.parallel;
  };
  exports["parallel"] = parallel;
  exports["sequential"] = sequential;
  exports["Parallel"] = Parallel;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Parallel"] = $PS["Control.Parallel"] || {};
  var exports = $PS["Control.Parallel"];
  var Control_Category = $PS["Control.Category"];
  var Control_Parallel_Class = $PS["Control.Parallel.Class"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Traversable = $PS["Data.Traversable"];                
  var parTraverse_ = function (dictParallel) {
      return function (dictFoldable) {
          return function (f) {
              var $17 = Control_Parallel_Class.sequential(dictParallel);
              var $18 = Data_Foldable.traverse_(dictParallel.Applicative1())(dictFoldable)((function () {
                  var $20 = Control_Parallel_Class.parallel(dictParallel);
                  return function ($21) {
                      return $20(f($21));
                  };
              })());
              return function ($19) {
                  return $17($18($19));
              };
          };
      };
  };
  var parTraverse = function (dictParallel) {
      return function (dictTraversable) {
          return function (f) {
              var $22 = Control_Parallel_Class.sequential(dictParallel);
              var $23 = Data_Traversable.traverse(dictTraversable)(dictParallel.Applicative1())((function () {
                  var $25 = Control_Parallel_Class.parallel(dictParallel);
                  return function ($26) {
                      return $25(f($26));
                  };
              })());
              return function ($24) {
                  return $22($23($24));
              };
          };
      };
  };
  var parSequence_ = function (dictParallel) {
      return function (dictFoldable) {
          return parTraverse_(dictParallel)(dictFoldable)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  exports["parTraverse"] = parTraverse;
  exports["parSequence_"] = parSequence_;
})(PS);
(function(exports) {
  "use strict";

  exports.pureE = function (a) {
    return function () {
      return a;
    };
  };

  exports.bindE = function (a) {
    return function (f) {
      return function () {
        return f(a())();
      };
    };
  };
})(PS["Effect"] = PS["Effect"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect"] = $PS["Effect"] || {};
  var exports = $PS["Effect"];
  var $foreign = $PS["Effect"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Data_Functor = $PS["Data.Functor"];                    
  var monadEffect = new Control_Monad.Monad(function () {
      return applicativeEffect;
  }, function () {
      return bindEffect;
  });
  var bindEffect = new Control_Bind.Bind(function () {
      return applyEffect;
  }, $foreign.bindE);
  var applyEffect = new Control_Apply.Apply(function () {
      return functorEffect;
  }, Control_Monad.ap(monadEffect));
  var applicativeEffect = new Control_Applicative.Applicative(function () {
      return applyEffect;
  }, $foreign.pureE);
  var functorEffect = new Data_Functor.Functor(Control_Applicative.liftA1(applicativeEffect));
  exports["functorEffect"] = functorEffect;
  exports["applyEffect"] = applyEffect;
  exports["applicativeEffect"] = applicativeEffect;
  exports["bindEffect"] = bindEffect;
  exports["monadEffect"] = monadEffect;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Class"] = $PS["Effect.Class"] || {};
  var exports = $PS["Effect.Class"];
  var Control_Category = $PS["Control.Category"];
  var Effect = $PS["Effect"];                
  var MonadEffect = function (Monad0, liftEffect) {
      this.Monad0 = Monad0;
      this.liftEffect = liftEffect;
  };
  var monadEffectEffect = new MonadEffect(function () {
      return Effect.monadEffect;
  }, Control_Category.identity(Control_Category.categoryFn));
  var liftEffect = function (dict) {
      return dict.liftEffect;
  };
  exports["liftEffect"] = liftEffect;
  exports["MonadEffect"] = MonadEffect;
  exports["monadEffectEffect"] = monadEffectEffect;
})(PS);
(function(exports) {
  "use strict";

  // module Partial.Unsafe

  exports._unsafePartial = function (f) {
    return f();
  };
})(PS["Partial.Unsafe"] = PS["Partial.Unsafe"] || {});
(function(exports) {
  "use strict";

  // module Partial

  exports._crashWith = function (msg) {
    throw new Error(msg);
  };
})(PS["Partial"] = PS["Partial"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Partial"] = $PS["Partial"] || {};
  var exports = $PS["Partial"];
  var $foreign = $PS["Partial"];         
  var crashWith = function (dictPartial) {
      return $foreign["_crashWith"];
  };
  exports["crashWith"] = crashWith;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Partial.Unsafe"] = $PS["Partial.Unsafe"] || {};
  var exports = $PS["Partial.Unsafe"];
  var $foreign = $PS["Partial.Unsafe"];
  var Partial = $PS["Partial"];                
  var unsafePartial = $foreign["_unsafePartial"];
  var unsafeCrashWith = function (msg) {
      return unsafePartial(function (dictPartial) {
          return Partial.crashWith()(msg);
      });
  };
  exports["unsafeCrashWith"] = unsafeCrashWith;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Aff"] = $PS["Effect.Aff"] || {};
  var exports = $PS["Effect.Aff"];
  var $foreign = $PS["Effect.Aff"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Control_Monad_Error_Class = $PS["Control.Monad.Error.Class"];
  var Control_Parallel = $PS["Control.Parallel"];
  var Control_Parallel_Class = $PS["Control.Parallel.Class"];
  var Data_Either = $PS["Data.Either"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var Effect_Class = $PS["Effect.Class"];
  var Partial_Unsafe = $PS["Partial.Unsafe"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];
  var Canceler = function (x) {
      return x;
  }; 
  var functorParAff = new Data_Functor.Functor($foreign["_parAffMap"]);
  var functorAff = new Data_Functor.Functor($foreign["_map"]);
  var ffiUtil = (function () {
      var unsafeFromRight = function (v) {
          if (v instanceof Data_Either.Right) {
              return v.value0;
          };
          if (v instanceof Data_Either.Left) {
              return Partial_Unsafe.unsafeCrashWith("unsafeFromRight: Left");
          };
          throw new Error("Failed pattern match at Effect.Aff (line 404, column 21 - line 406, column 54): " + [ v.constructor.name ]);
      };
      var unsafeFromLeft = function (v) {
          if (v instanceof Data_Either.Left) {
              return v.value0;
          };
          if (v instanceof Data_Either.Right) {
              return Partial_Unsafe.unsafeCrashWith("unsafeFromLeft: Right");
          };
          throw new Error("Failed pattern match at Effect.Aff (line 399, column 20 - line 401, column 54): " + [ v.constructor.name ]);
      };
      var isLeft = function (v) {
          if (v instanceof Data_Either.Left) {
              return true;
          };
          if (v instanceof Data_Either.Right) {
              return false;
          };
          throw new Error("Failed pattern match at Effect.Aff (line 394, column 12 - line 396, column 20): " + [ v.constructor.name ]);
      };
      return {
          isLeft: isLeft,
          fromLeft: unsafeFromLeft,
          fromRight: unsafeFromRight,
          left: Data_Either.Left.create,
          right: Data_Either.Right.create
      };
  })();
  var makeFiber = function (aff) {
      return $foreign["_makeFiber"](ffiUtil, aff);
  };
  var launchAff = function (aff) {
      return function __do() {
          var fiber = makeFiber(aff)();
          fiber.run();
          return fiber;
      };
  };
  var launchAff_ = (function () {
      var $40 = Data_Functor["void"](Effect.functorEffect);
      return function ($41) {
          return $40(launchAff($41));
      };
  })();
  var applyParAff = new Control_Apply.Apply(function () {
      return functorParAff;
  }, $foreign["_parAffApply"]);
  var monadAff = new Control_Monad.Monad(function () {
      return applicativeAff;
  }, function () {
      return bindAff;
  });
  var bindAff = new Control_Bind.Bind(function () {
      return applyAff;
  }, $foreign["_bind"]);
  var applyAff = new Control_Apply.Apply(function () {
      return functorAff;
  }, Control_Monad.ap(monadAff));
  var applicativeAff = new Control_Applicative.Applicative(function () {
      return applyAff;
  }, $foreign["_pure"]);
  var monadEffectAff = new Effect_Class.MonadEffect(function () {
      return monadAff;
  }, $foreign["_liftEffect"]);
  var effectCanceler = (function () {
      var $42 = Effect_Class.liftEffect(monadEffectAff);
      return function ($43) {
          return Canceler(Data_Function["const"]($42($43)));
      };
  })();
  var killFiber = function (e) {
      return function (v) {
          return Control_Bind.bind(bindAff)(Effect_Class.liftEffect(monadEffectAff)(v.isSuspended))(function (v1) {
              if (v1) {
                  return Effect_Class.liftEffect(monadEffectAff)(Data_Functor["void"](Effect.functorEffect)(v.kill(e, Data_Function["const"](Control_Applicative.pure(Effect.applicativeEffect)(Data_Unit.unit)))));
              };
              return $foreign.makeAff(function (k) {
                  return Data_Functor.map(Effect.functorEffect)(effectCanceler)(v.kill(e, k));
              });
          });
      };
  };   
  var monadThrowAff = new Control_Monad_Error_Class.MonadThrow(function () {
      return monadAff;
  }, $foreign["_throwError"]);
  var monadErrorAff = new Control_Monad_Error_Class.MonadError(function () {
      return monadThrowAff;
  }, $foreign["_catchError"]);
  var parallelAff = new Control_Parallel_Class.Parallel(function () {
      return applicativeParAff;
  }, function () {
      return monadAff;
  }, Unsafe_Coerce.unsafeCoerce, $foreign["_sequential"]);
  var applicativeParAff = new Control_Applicative.Applicative(function () {
      return applyParAff;
  }, (function () {
      var $50 = Control_Parallel_Class.parallel(parallelAff);
      var $51 = Control_Applicative.pure(applicativeAff);
      return function ($52) {
          return $50($51($52));
      };
  })());
  var semigroupCanceler = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          return function (err) {
              return Control_Parallel.parSequence_(parallelAff)(Data_Foldable.foldableArray)([ v(err), v1(err) ]);
          };
      };
  });
  var nonCanceler = Data_Function["const"](Control_Applicative.pure(applicativeAff)(Data_Unit.unit));
  var monoidCanceler = new Data_Monoid.Monoid(function () {
      return semigroupCanceler;
  }, nonCanceler);
  exports["launchAff"] = launchAff;
  exports["launchAff_"] = launchAff_;
  exports["killFiber"] = killFiber;
  exports["nonCanceler"] = nonCanceler;
  exports["functorAff"] = functorAff;
  exports["applyAff"] = applyAff;
  exports["applicativeAff"] = applicativeAff;
  exports["bindAff"] = bindAff;
  exports["monadThrowAff"] = monadThrowAff;
  exports["monadErrorAff"] = monadErrorAff;
  exports["monadEffectAff"] = monadEffectAff;
  exports["parallelAff"] = parallelAff;
  exports["monoidCanceler"] = monoidCanceler;
  exports["makeAff"] = $foreign.makeAff;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Aff.Compat"] = $PS["Effect.Aff.Compat"] || {};
  var exports = $PS["Effect.Aff.Compat"];
  var Data_Either = $PS["Data.Either"];
  var Effect_Aff = $PS["Effect.Aff"];
  var fromEffectFnAff = function (v) {
      return Effect_Aff.makeAff(function (k) {
          return function __do() {
              var v1 = v(function ($4) {
                  return k(Data_Either.Left.create($4))();
              }, function ($5) {
                  return k(Data_Either.Right.create($5))();
              });
              return function (e) {
                  return Effect_Aff.makeAff(function (k2) {
                      return function __do() {
                          v1(e, function ($6) {
                              return k2(Data_Either.Left.create($6))();
                          }, function ($7) {
                              return k2(Data_Either.Right.create($7))();
                          });
                          return Effect_Aff.nonCanceler;
                      };
                  });
              };
          };
      });
  };
  exports["fromEffectFnAff"] = fromEffectFnAff;
})(PS);
(function(exports) {
  "use strict";

  exports.error = function (msg) {
    return new Error(msg);
  };

  exports.message = function (e) {
    return e.message;
  };

  exports.throwException = function (e) {
    return function () {
      throw e;
    };
  };

  exports.catchException = function (c) {
    return function (t) {
      return function () {
        try {
          return t();
        } catch (e) {
          if (e instanceof Error || Object.prototype.toString.call(e) === "[object Error]") {
            return c(e)();
          } else {
            return c(new Error(e.toString()))();
          }
        }
      };
    };
  };
})(PS["Effect.Exception"] = PS["Effect.Exception"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Exception"] = $PS["Effect.Exception"] || {};
  var exports = $PS["Effect.Exception"];
  var $foreign = $PS["Effect.Exception"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Either = $PS["Data.Either"];
  var Data_Functor = $PS["Data.Functor"];
  var Effect = $PS["Effect"];                
  var $$try = function (action) {
      return $foreign.catchException((function () {
          var $0 = Control_Applicative.pure(Effect.applicativeEffect);
          return function ($1) {
              return $0(Data_Either.Left.create($1));
          };
      })())(Data_Functor.map(Effect.functorEffect)(Data_Either.Right.create)(action));
  };
  exports["try"] = $$try;
  exports["error"] = $foreign.error;
  exports["message"] = $foreign.message;
  exports["throwException"] = $foreign.throwException;
})(PS);
(function(exports) {
  "use strict";

  exports.typeOf = function (value) {
    return typeof value;
  };

  exports.tagOf = function (value) {
    return Object.prototype.toString.call(value).slice(8, -1);
  };

  exports.isNull = function (value) {
    return value === null;
  };

  exports.isUndefined = function (value) {
    return value === undefined;
  };

  exports.isArray = Array.isArray || function (value) {
    return Object.prototype.toString.call(value) === "[object Array]";
  };
})(PS["Foreign"] = PS["Foreign"] || {});
(function(exports) {
  "use strict";

  exports.fromNumberImpl = function (just) {
    return function (nothing) {
      return function (n) {
        /* jshint bitwise: false */
        return (n | 0) === n ? just(n) : nothing;
      };
    };
  };

  exports.toNumber = function (n) {
    return n;
  };

  exports.fromStringAsImpl = function (just) {
    return function (nothing) {
      return function (radix) {
        var digits;
        if (radix < 11) {
          digits = "[0-" + (radix - 1).toString() + "]";
        } else if (radix === 11) {
          digits = "[0-9a]";
        } else {
          digits = "[0-9a-" + String.fromCharCode(86 + radix) + "]";
        }
        var pattern = new RegExp("^[\\+\\-]?" + digits + "+$", "i");

        return function (s) {
          /* jshint bitwise: false */
          if (pattern.test(s)) {
            var i = parseInt(s, radix);
            return (i | 0) === i ? just(i) : nothing;
          } else {
            return nothing;
          }
        };
      };
    };
  };

  exports.toStringAs = function (radix) {
    return function (i) {
      return i.toString(radix);
    };
  };


  exports.quot = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x / y | 0;
    };
  };
})(PS["Data.Int"] = PS["Data.Int"] || {});
(function(exports) {
  "use strict";

  exports.topInt = 2147483647;
  exports.bottomInt = -2147483648;

  exports.topChar = String.fromCharCode(65535);
  exports.bottomChar = String.fromCharCode(0);
})(PS["Data.Bounded"] = PS["Data.Bounded"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Bounded"] = $PS["Data.Bounded"] || {};
  var exports = $PS["Data.Bounded"];
  var $foreign = $PS["Data.Bounded"];
  var Data_Ord = $PS["Data.Ord"];
  var Bounded = function (Ord0, bottom, top) {
      this.Ord0 = Ord0;
      this.bottom = bottom;
      this.top = top;
  };
  var top = function (dict) {
      return dict.top;
  };                                            
  var boundedInt = new Bounded(function () {
      return Data_Ord.ordInt;
  }, $foreign.bottomInt, $foreign.topInt);
  var boundedChar = new Bounded(function () {
      return Data_Ord.ordChar;
  }, $foreign.bottomChar, $foreign.topChar);
  var bottom = function (dict) {
      return dict.bottom;
  };
  exports["Bounded"] = Bounded;
  exports["bottom"] = bottom;
  exports["top"] = top;
  exports["boundedInt"] = boundedInt;
  exports["boundedChar"] = boundedChar;
})(PS);
(function(exports) {
  /* globals exports */
  "use strict";     

  exports.isNaN = isNaN;      

  exports.isFinite = isFinite;

  exports.fromStringImpl = function(str, isFinite, just, nothing) {
    var num = parseFloat(str);
    if (isFinite(num)) {
      return just(num);
    } else {
      return nothing;
    }
  };
})(PS["Data.Number"] = PS["Data.Number"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Number"] = $PS["Data.Number"] || {};
  var exports = $PS["Data.Number"];
  var $foreign = $PS["Data.Number"];
  var Data_Maybe = $PS["Data.Maybe"];                
  var fromString = function (str) {
      return $foreign.fromStringImpl(str, $foreign["isFinite"], Data_Maybe.Just.create, Data_Maybe.Nothing.value);
  };
  exports["fromString"] = fromString;
  exports["isNaN"] = $foreign["isNaN"];
  exports["isFinite"] = $foreign["isFinite"];
})(PS);
(function(exports) {
  "use strict";

  // module Math

  exports.abs = Math.abs;

  exports.floor = Math.floor;

  function nativeImul(a) {
    return function (b) {
      return Math.imul(a, b);
    };
  }

  // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/imul
  function emulatedImul(a) {
    /*jshint bitwise: false*/
    return function (b) {
      var ah = a >>> 16 & 0xffff;
      var al = a & 0xffff;
      var bh = b >>> 16 & 0xffff;
      var bl = b & 0xffff;
      // the shift by 0 fixes the sign on the high part
      // the final |0 converts the unsigned value into a signed value
      return al * bl + (ah * bl + al * bh << 16 >>> 0) | 0;
    };
  } 

  exports.log = Math.log;

  exports.remainder = function (n) {
    return function (m) {
      return n % m;
    };
  };

  exports.round = Math.round;

  exports.ln10 = Math.LN10;
})(PS["Math"] = PS["Math"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Math"] = $PS["Math"] || {};
  var exports = $PS["Math"];
  var $foreign = $PS["Math"];
  exports["abs"] = $foreign.abs;
  exports["floor"] = $foreign.floor;
  exports["log"] = $foreign.log;
  exports["round"] = $foreign.round;
  exports["remainder"] = $foreign.remainder;
  exports["ln10"] = $foreign.ln10;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Int"] = $PS["Data.Int"] || {};
  var exports = $PS["Data.Int"];
  var $foreign = $PS["Data.Int"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Bounded = $PS["Data.Bounded"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Number = $PS["Data.Number"];
  var $$Math = $PS["Math"];
  var hexadecimal = 16;
  var fromStringAs = $foreign.fromStringAsImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var fromString = fromStringAs(10);
  var fromNumber = $foreign.fromNumberImpl(Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var unsafeClamp = function (x) {
      if (!Data_Number["isFinite"](x)) {
          return 0;
      };
      if (x >= $foreign.toNumber(Data_Bounded.top(Data_Bounded.boundedInt))) {
          return Data_Bounded.top(Data_Bounded.boundedInt);
      };
      if (x <= $foreign.toNumber(Data_Bounded.bottom(Data_Bounded.boundedInt))) {
          return Data_Bounded.bottom(Data_Bounded.boundedInt);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.fromMaybe(0)(fromNumber(x));
      };
      throw new Error("Failed pattern match at Data.Int (line 66, column 1 - line 66, column 29): " + [ x.constructor.name ]);
  };
  var round = function ($23) {
      return unsafeClamp($$Math.round($23));
  };
  var floor = function ($24) {
      return unsafeClamp($$Math.floor($24));
  };
  exports["fromNumber"] = fromNumber;
  exports["floor"] = floor;
  exports["round"] = round;
  exports["fromString"] = fromString;
  exports["hexadecimal"] = hexadecimal;
  exports["toNumber"] = $foreign.toNumber;
  exports["toStringAs"] = $foreign.toStringAs;
  exports["quot"] = $foreign.quot;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Foreign"] = $PS["Foreign"] || {};
  var exports = $PS["Foreign"];
  var $foreign = $PS["Foreign"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Monad_Error_Class = $PS["Control.Monad.Error.Class"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Either = $PS["Data.Either"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Int = $PS["Data.Int"];
  var Data_List_NonEmpty = $PS["Data.List.NonEmpty"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Show = $PS["Data.Show"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];                
  var ForeignError = (function () {
      function ForeignError(value0) {
          this.value0 = value0;
      };
      ForeignError.create = function (value0) {
          return new ForeignError(value0);
      };
      return ForeignError;
  })();
  var TypeMismatch = (function () {
      function TypeMismatch(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      TypeMismatch.create = function (value0) {
          return function (value1) {
              return new TypeMismatch(value0, value1);
          };
      };
      return TypeMismatch;
  })();
  var ErrorAtIndex = (function () {
      function ErrorAtIndex(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtIndex.create = function (value0) {
          return function (value1) {
              return new ErrorAtIndex(value0, value1);
          };
      };
      return ErrorAtIndex;
  })();
  var ErrorAtProperty = (function () {
      function ErrorAtProperty(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ErrorAtProperty.create = function (value0) {
          return function (value1) {
              return new ErrorAtProperty(value0, value1);
          };
      };
      return ErrorAtProperty;
  })();
  var unsafeToForeign = Unsafe_Coerce.unsafeCoerce;
  var unsafeFromForeign = Unsafe_Coerce.unsafeCoerce;
  var showForeignError = new Data_Show.Show(function (v) {
      if (v instanceof ForeignError) {
          return "(ForeignError " + (Data_Show.show(Data_Show.showString)(v.value0) + ")");
      };
      if (v instanceof ErrorAtIndex) {
          return "(ErrorAtIndex " + (Data_Show.show(Data_Show.showInt)(v.value0) + (" " + (Data_Show.show(showForeignError)(v.value1) + ")")));
      };
      if (v instanceof ErrorAtProperty) {
          return "(ErrorAtProperty " + (Data_Show.show(Data_Show.showString)(v.value0) + (" " + (Data_Show.show(showForeignError)(v.value1) + ")")));
      };
      if (v instanceof TypeMismatch) {
          return "(TypeMismatch " + (Data_Show.show(Data_Show.showString)(v.value0) + (" " + (Data_Show.show(Data_Show.showString)(v.value1) + ")")));
      };
      throw new Error("Failed pattern match at Foreign (line 64, column 1 - line 68, column 89): " + [ v.constructor.name ]);
  });
  var renderForeignError = function (v) {
      if (v instanceof ForeignError) {
          return v.value0;
      };
      if (v instanceof ErrorAtIndex) {
          return "Error at array index " + (Data_Show.show(Data_Show.showInt)(v.value0) + (": " + renderForeignError(v.value1)));
      };
      if (v instanceof ErrorAtProperty) {
          return "Error at property " + (Data_Show.show(Data_Show.showString)(v.value0) + (": " + renderForeignError(v.value1)));
      };
      if (v instanceof TypeMismatch) {
          return "Type mismatch: expected " + (v.value0 + (", found " + v.value1));
      };
      throw new Error("Failed pattern match at Foreign (line 73, column 1 - line 73, column 45): " + [ v.constructor.name ]);
  };
  var readNullOrUndefined = function (dictMonad) {
      return function (value) {
          if ($foreign.isNull(value) || $foreign.isUndefined(value)) {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(dictMonad))(Data_Maybe.Nothing.value);
          };
          if (Data_Boolean.otherwise) {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(dictMonad))(new Data_Maybe.Just(value));
          };
          throw new Error("Failed pattern match at Foreign (line 166, column 1 - line 166, column 76): " + [ value.constructor.name ]);
      };
  };
  var fail = function (dictMonad) {
      var $118 = Control_Monad_Error_Class.throwError(Control_Monad_Except_Trans.monadThrowExceptT(dictMonad));
      return function ($119) {
          return $118(Data_List_NonEmpty.singleton($119));
      };
  };
  var readArray = function (dictMonad) {
      return function (value) {
          if ($foreign.isArray(value)) {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(dictMonad))(unsafeFromForeign(value));
          };
          if (Data_Boolean.otherwise) {
              return fail(dictMonad)(new TypeMismatch("array", $foreign.tagOf(value)));
          };
          throw new Error("Failed pattern match at Foreign (line 151, column 1 - line 151, column 66): " + [ value.constructor.name ]);
      };
  };
  var unsafeReadTagged = function (dictMonad) {
      return function (tag) {
          return function (value) {
              if ($foreign.tagOf(value) === tag) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(dictMonad))(unsafeFromForeign(value));
              };
              if (Data_Boolean.otherwise) {
                  return fail(dictMonad)(new TypeMismatch(tag, $foreign.tagOf(value)));
              };
              throw new Error("Failed pattern match at Foreign (line 110, column 1 - line 110, column 71): " + [ tag.constructor.name, value.constructor.name ]);
          };
      };
  };
  var readBoolean = function (dictMonad) {
      return unsafeReadTagged(dictMonad)("Boolean");
  };
  var readNumber = function (dictMonad) {
      return unsafeReadTagged(dictMonad)("Number");
  };
  var readInt = function (dictMonad) {
      return function (value) {
          var error = Data_Either.Left.create(Data_List_NonEmpty.singleton(new TypeMismatch("Int", $foreign.tagOf(value))));
          var fromNumber = (function () {
              var $120 = Data_Maybe.maybe(error)(Control_Applicative.pure(Data_Either.applicativeEither));
              return function ($121) {
                  return $120(Data_Int.fromNumber($121));
              };
          })();
          return Control_Monad_Except_Trans.mapExceptT(Data_Functor.map(((dictMonad.Bind1()).Apply0()).Functor0())(Data_Either.either(Data_Function["const"](error))(fromNumber)))(readNumber(dictMonad)(value));
      };
  };
  var readString = function (dictMonad) {
      return unsafeReadTagged(dictMonad)("String");
  };
  exports["ForeignError"] = ForeignError;
  exports["TypeMismatch"] = TypeMismatch;
  exports["ErrorAtIndex"] = ErrorAtIndex;
  exports["ErrorAtProperty"] = ErrorAtProperty;
  exports["renderForeignError"] = renderForeignError;
  exports["unsafeToForeign"] = unsafeToForeign;
  exports["unsafeFromForeign"] = unsafeFromForeign;
  exports["unsafeReadTagged"] = unsafeReadTagged;
  exports["readString"] = readString;
  exports["readBoolean"] = readBoolean;
  exports["readNumber"] = readNumber;
  exports["readInt"] = readInt;
  exports["readArray"] = readArray;
  exports["readNullOrUndefined"] = readNullOrUndefined;
  exports["fail"] = fail;
  exports["showForeignError"] = showForeignError;
  exports["typeOf"] = $foreign.typeOf;
  exports["tagOf"] = $foreign.tagOf;
  exports["isNull"] = $foreign.isNull;
  exports["isUndefined"] = $foreign.isUndefined;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Affjax"] = $PS["Affjax"] || {};
  var exports = $PS["Affjax"];
  var $foreign = $PS["Affjax"];
  var Affjax_RequestBody = $PS["Affjax.RequestBody"];
  var Affjax_RequestHeader = $PS["Affjax.RequestHeader"];
  var Affjax_ResponseFormat = $PS["Affjax.ResponseFormat"];
  var Affjax_ResponseHeader = $PS["Affjax.ResponseHeader"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad_Error_Class = $PS["Control.Monad.Error.Class"];
  var Control_Monad_Except = $PS["Control.Monad.Except"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Argonaut_Core = $PS["Data.Argonaut.Core"];
  var Data_Argonaut_Parser = $PS["Data.Argonaut.Parser"];
  var Data_Array = $PS["Data.Array"];
  var Data_Either = $PS["Data.Either"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_FormURLEncoded = $PS["Data.FormURLEncoded"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_HTTP_Method = $PS["Data.HTTP.Method"];
  var Data_HeytingAlgebra = $PS["Data.HeytingAlgebra"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_List_NonEmpty = $PS["Data.List.NonEmpty"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Nullable = $PS["Data.Nullable"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect_Aff = $PS["Effect.Aff"];
  var Effect_Aff_Compat = $PS["Effect.Aff.Compat"];
  var Effect_Exception = $PS["Effect.Exception"];
  var Foreign = $PS["Foreign"];                
  var RequestContentError = (function () {
      function RequestContentError(value0) {
          this.value0 = value0;
      };
      RequestContentError.create = function (value0) {
          return new RequestContentError(value0);
      };
      return RequestContentError;
  })();
  var ResponseBodyError = (function () {
      function ResponseBodyError(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ResponseBodyError.create = function (value0) {
          return function (value1) {
              return new ResponseBodyError(value0, value1);
          };
      };
      return ResponseBodyError;
  })();
  var TimeoutError = (function () {
      function TimeoutError() {

      };
      TimeoutError.value = new TimeoutError();
      return TimeoutError;
  })();
  var RequestFailedError = (function () {
      function RequestFailedError() {

      };
      RequestFailedError.value = new RequestFailedError();
      return RequestFailedError;
  })();
  var XHROtherError = (function () {
      function XHROtherError(value0) {
          this.value0 = value0;
      };
      XHROtherError.create = function (value0) {
          return new XHROtherError(value0);
      };
      return XHROtherError;
  })();
  var request = function (req) {
      var parseJSON = function (v) {
          if (v === "") {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Argonaut_Core.jsonEmptyObject);
          };
          return Data_Either.either((function () {
              var $51 = Foreign.fail(Data_Identity.monadIdentity);
              return function ($52) {
                  return $51(Foreign.ForeignError.create($52));
              };
          })())(Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity)))(Data_Argonaut_Parser.jsonParser(v));
      };
      var fromResponse = (function () {
          if (req.responseFormat instanceof Affjax_ResponseFormat["ArrayBuffer"]) {
              return Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("ArrayBuffer");
          };
          if (req.responseFormat instanceof Affjax_ResponseFormat.Blob) {
              return Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("Blob");
          };
          if (req.responseFormat instanceof Affjax_ResponseFormat.Document) {
              return function (x) {
                  return Control_Alt.alt(Control_Monad_Except_Trans.altExceptT(Data_List_Types.semigroupNonEmptyList)(Data_Identity.monadIdentity))(Control_Alt.alt(Control_Monad_Except_Trans.altExceptT(Data_List_Types.semigroupNonEmptyList)(Data_Identity.monadIdentity))(Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("Document")(x))(Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("XMLDocument")(x)))(Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("HTMLDocument")(x));
              };
          };
          if (req.responseFormat instanceof Affjax_ResponseFormat.Json) {
              return Control_Bind.composeKleisliFlipped(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(function ($53) {
                  return req.responseFormat.value0(parseJSON($53));
              })(Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("String"));
          };
          if (req.responseFormat instanceof Affjax_ResponseFormat["String"]) {
              return Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("String");
          };
          if (req.responseFormat instanceof Affjax_ResponseFormat.Ignore) {
              return Data_Function["const"](req.responseFormat.value0(Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Unit.unit)));
          };
          throw new Error("Failed pattern match at Affjax (line 257, column 18 - line 265, column 57): " + [ req.responseFormat.constructor.name ]);
      })();
      var extractContent = function (v) {
          if (v instanceof Affjax_RequestBody.ArrayView) {
              return Data_Either.Right.create(v.value0(Foreign.unsafeToForeign));
          };
          if (v instanceof Affjax_RequestBody.Blob) {
              return Data_Either.Right.create(Foreign.unsafeToForeign(v.value0));
          };
          if (v instanceof Affjax_RequestBody.Document) {
              return Data_Either.Right.create(Foreign.unsafeToForeign(v.value0));
          };
          if (v instanceof Affjax_RequestBody["String"]) {
              return Data_Either.Right.create(Foreign.unsafeToForeign(v.value0));
          };
          if (v instanceof Affjax_RequestBody.FormData) {
              return Data_Either.Right.create(Foreign.unsafeToForeign(v.value0));
          };
          if (v instanceof Affjax_RequestBody.FormURLEncoded) {
              return Data_Either.note("Body contains values that cannot be encoded as application/x-www-form-urlencoded")(Data_Functor.map(Data_Maybe.functorMaybe)(Foreign.unsafeToForeign)(Data_FormURLEncoded.encode(v.value0)));
          };
          if (v instanceof Affjax_RequestBody.Json) {
              return Data_Either.Right.create(Foreign.unsafeToForeign(Data_Argonaut_Core.stringify(v.value0)));
          };
          throw new Error("Failed pattern match at Affjax (line 217, column 20 - line 232, column 69): " + [ v.constructor.name ]);
      };
      var addHeader = function (mh) {
          return function (hs) {
              if (mh instanceof Data_Maybe.Just && !Data_Foldable.any(Data_Foldable.foldableArray)(Data_HeytingAlgebra.heytingAlgebraBoolean)(Data_Function.on(Data_Eq.eq(Data_Eq.eqString))(Affjax_RequestHeader.name)(mh.value0))(hs)) {
                  return Data_Array.snoc(hs)(mh.value0);
              };
              return hs;
          };
      };
      var headers = function (reqContent) {
          return addHeader(Data_Functor.map(Data_Maybe.functorMaybe)(Affjax_RequestHeader.ContentType.create)(Control_Bind.bindFlipped(Data_Maybe.bindMaybe)(Affjax_RequestBody.toMediaType)(reqContent)))(addHeader(Data_Functor.map(Data_Maybe.functorMaybe)(Affjax_RequestHeader.Accept.create)(Affjax_ResponseFormat.toMediaType(req.responseFormat)))(req.headers));
      };
      var ajaxRequest = function (v) {
          return {
              method: Data_HTTP_Method.print(req.method),
              url: req.url,
              headers: Data_Functor.map(Data_Functor.functorArray)(function (h) {
                  return {
                      field: Affjax_RequestHeader.name(h),
                      value: Affjax_RequestHeader.value(h)
                  };
              })(headers(req.content)),
              content: v,
              responseType: Affjax_ResponseFormat.toResponseType(req.responseFormat),
              username: Data_Nullable.toNullable(req.username),
              password: Data_Nullable.toNullable(req.password),
              withCredentials: req.withCredentials,
              timeout: Data_Maybe.fromMaybe(0.0)(Data_Functor.map(Data_Maybe.functorMaybe)(function (v1) {
                  return v1;
              })(req.timeout))
          };
      };
      var send = function (content) {
          return Data_Functor.mapFlipped(Effect_Aff.functorAff)(Control_Monad_Error_Class["try"](Effect_Aff.monadErrorAff)(Effect_Aff_Compat.fromEffectFnAff($foreign["_ajax"]("AffjaxTimeoutErrorMessageIdent", "AffjaxRequestFailedMessageIdent", Affjax_ResponseHeader.ResponseHeader.create, ajaxRequest(content)))))(function (v) {
              if (v instanceof Data_Either.Right) {
                  var v1 = Control_Monad_Except.runExcept(fromResponse(v.value0.body));
                  if (v1 instanceof Data_Either.Left) {
                      return new Data_Either.Left(new ResponseBodyError(Data_List_NonEmpty.head(v1.value0), v.value0));
                  };
                  if (v1 instanceof Data_Either.Right) {
                      return new Data_Either.Right({
                          body: v1.value0,
                          headers: v.value0.headers,
                          status: v.value0.status,
                          statusText: v.value0.statusText
                      });
                  };
                  throw new Error("Failed pattern match at Affjax (line 193, column 9 - line 195, column 52): " + [ v1.constructor.name ]);
              };
              if (v instanceof Data_Either.Left) {
                  var message = Effect_Exception.message(v.value0);
                  return Data_Either.Left.create((function () {
                      var $38 = message === "AffjaxTimeoutErrorMessageIdent";
                      if ($38) {
                          return TimeoutError.value;
                      };
                      var $39 = message === "AffjaxRequestFailedMessageIdent";
                      if ($39) {
                          return RequestFailedError.value;
                      };
                      return new XHROtherError(v.value0);
                  })());
              };
              throw new Error("Failed pattern match at Affjax (line 191, column 137 - line 201, column 33): " + [ v.constructor.name ]);
          });
      };
      if (req.content instanceof Data_Maybe.Nothing) {
          return send(Data_Nullable.toNullable(Data_Maybe.Nothing.value));
      };
      if (req.content instanceof Data_Maybe.Just) {
          var v = extractContent(req.content.value0);
          if (v instanceof Data_Either.Right) {
              return send(Data_Nullable.toNullable(new Data_Maybe.Just(v.value0)));
          };
          if (v instanceof Data_Either.Left) {
              return Control_Applicative.pure(Effect_Aff.applicativeAff)(new Data_Either.Left(new RequestContentError(v.value0)));
          };
          throw new Error("Failed pattern match at Affjax (line 183, column 7 - line 187, column 48): " + [ v.constructor.name ]);
      };
      throw new Error("Failed pattern match at Affjax (line 179, column 3 - line 187, column 48): " + [ req.content.constructor.name ]);
  };
  var printError = function (v) {
      if (v instanceof RequestContentError) {
          return "There was a problem with the request content: " + v.value0;
      };
      if (v instanceof ResponseBodyError) {
          return "There was a problem with the response body: " + Foreign.renderForeignError(v.value0);
      };
      if (v instanceof TimeoutError) {
          return "There was a problem making the request: timeout";
      };
      if (v instanceof RequestFailedError) {
          return "There was a problem making the request: request failed";
      };
      if (v instanceof XHROtherError) {
          return "There was a problem making the request: " + Effect_Exception.message(v.value0);
      };
      throw new Error("Failed pattern match at Affjax (line 97, column 14 - line 107, column 66): " + [ v.constructor.name ]);
  };
  var defaultRequest = {
      method: new Data_Either.Left(Data_HTTP_Method.GET.value),
      url: "/",
      headers: [  ],
      content: Data_Maybe.Nothing.value,
      username: Data_Maybe.Nothing.value,
      password: Data_Maybe.Nothing.value,
      withCredentials: false,
      responseFormat: Affjax_ResponseFormat.ignore,
      timeout: Data_Maybe.Nothing.value
  };
  exports["defaultRequest"] = defaultRequest;
  exports["printError"] = printError;
  exports["request"] = request;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["CSS.Common"] = $PS["CSS.Common"] || {};
  var exports = $PS["CSS.Common"];
  var Normal = function (normal) {
      this.normal = normal;
  };                                                                                        
  var normal = function (dict) {
      return dict.normal;
  };
  exports["normal"] = normal;
  exports["Normal"] = Normal;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["CSS.String"] = $PS["CSS.String"] || {};
  var exports = $PS["CSS.String"];                               
  var IsString = function (fromString) {
      this.fromString = fromString;
  };                                                                                        
  var fromString = function (dict) {
      return dict.fromString;
  };
  exports["fromString"] = fromString;
  exports["IsString"] = IsString;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["CSS.Property"] = $PS["CSS.Property"] || {};
  var exports = $PS["CSS.Property"];
  var CSS_String = $PS["CSS.String"];
  var Plain = (function () {
      function Plain(value0) {
          this.value0 = value0;
      };
      Plain.create = function (value0) {
          return new Plain(value0);
      };
      return Plain;
  })();
  var Value = function (x) {
      return x;
  };                                     
  var isStringPrefixed = new CSS_String.IsString(Plain.create);
  var isStringValue = new CSS_String.IsString((function () {
      var $102 = CSS_String.fromString(isStringPrefixed);
      return function ($103) {
          return Value($102($103));
      };
  })());
  exports["Plain"] = Plain;
  exports["isStringValue"] = isStringValue;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["CSS.Font"] = $PS["CSS.Font"] || {};
  var exports = $PS["CSS.Font"];
  var CSS_Common = $PS["CSS.Common"];
  var CSS_Property = $PS["CSS.Property"];
  var CSS_String = $PS["CSS.String"];                                                                
  var normalFontWeight = new CSS_Common.Normal(CSS_String.fromString(CSS_Property.isStringValue)("normal"));
  exports["normalFontWeight"] = normalFontWeight;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["CSS.FontStyle"] = $PS["CSS.FontStyle"] || {};
  var exports = $PS["CSS.FontStyle"];
  var CSS_Common = $PS["CSS.Common"];
  var Normal = (function () {
      function Normal() {

      };
      Normal.value = new Normal();
      return Normal;
  })();
  var Italic = (function () {
      function Italic() {

      };
      Italic.value = new Italic();
      return Italic;
  })();
  var Oblique = (function () {
      function Oblique(value0) {
          this.value0 = value0;
      };
      Oblique.create = function (value0) {
          return new Oblique(value0);
      };
      return Oblique;
  })();                                           
  var normalFontStyle = new CSS_Common.Normal(Normal.value);
  exports["Italic"] = Italic;
  exports["Oblique"] = Oblique;
  exports["normalFontStyle"] = normalFontStyle;
})(PS);
(function(exports) {
  "use strict";
  /* global Symbol */

  var hasArrayFrom = typeof Array.from === "function";
  var hasStringIterator =
    typeof Symbol !== "undefined" &&
    Symbol != null &&
    typeof Symbol.iterator !== "undefined" &&
    typeof String.prototype[Symbol.iterator] === "function";
  var hasFromCodePoint = typeof String.prototype.fromCodePoint === "function";
  var hasCodePointAt = typeof String.prototype.codePointAt === "function";

  exports._unsafeCodePointAt0 = function (fallback) {
    return hasCodePointAt
      ? function (str) { return str.codePointAt(0); }
      : fallback;
  };

  exports._singleton = function (fallback) {
    return hasFromCodePoint ? String.fromCodePoint : fallback;
  };

  exports._take = function (fallback) {
    return function (n) {
      if (hasStringIterator) {
        return function (str) {
          var accum = "";
          var iter = str[Symbol.iterator]();
          for (var i = 0; i < n; ++i) {
            var o = iter.next();
            if (o.done) return accum;
            accum += o.value;
          }
          return accum;
        };
      }
      return fallback(n);
    };
  };

  exports._toCodePointArray = function (fallback) {
    return function (unsafeCodePointAt0) {
      if (hasArrayFrom) {
        return function (str) {
          return Array.from(str, unsafeCodePointAt0);
        };
      }
      return fallback;
    };
  };
})(PS["Data.String.CodePoints"] = PS["Data.String.CodePoints"] || {});
(function(exports) {
  "use strict";

  exports.toCharCode = function (c) {
    return c.charCodeAt(0);
  };

  exports.fromCharCode = function (c) {
    return String.fromCharCode(c);
  };
})(PS["Data.Enum"] = PS["Data.Enum"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Enum"] = $PS["Data.Enum"] || {};
  var exports = $PS["Data.Enum"];
  var $foreign = $PS["Data.Enum"];
  var Data_Bounded = $PS["Data.Bounded"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];                  
  var Enum = function (Ord0, pred, succ) {
      this.Ord0 = Ord0;
      this.pred = pred;
      this.succ = succ;
  };
  var BoundedEnum = function (Bounded0, Enum1, cardinality, fromEnum, toEnum) {
      this.Bounded0 = Bounded0;
      this.Enum1 = Enum1;
      this.cardinality = cardinality;
      this.fromEnum = fromEnum;
      this.toEnum = toEnum;
  };
  var toEnum = function (dict) {
      return dict.toEnum;
  }; 
  var fromEnum = function (dict) {
      return dict.fromEnum;
  };
  var toEnumWithDefaults = function (dictBoundedEnum) {
      return function (low) {
          return function (high) {
              return function (x) {
                  var v = toEnum(dictBoundedEnum)(x);
                  if (v instanceof Data_Maybe.Just) {
                      return v.value0;
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      var $51 = x < fromEnum(dictBoundedEnum)(Data_Bounded.bottom(dictBoundedEnum.Bounded0()));
                      if ($51) {
                          return low;
                      };
                      return high;
                  };
                  throw new Error("Failed pattern match at Data.Enum (line 158, column 33 - line 160, column 62): " + [ v.constructor.name ]);
              };
          };
      };
  };
  var defaultSucc = function (toEnum$prime) {
      return function (fromEnum$prime) {
          return function (a) {
              return toEnum$prime(fromEnum$prime(a) + 1 | 0);
          };
      };
  };
  var defaultPred = function (toEnum$prime) {
      return function (fromEnum$prime) {
          return function (a) {
              return toEnum$prime(fromEnum$prime(a) - 1 | 0);
          };
      };
  };
  var charToEnum = function (v) {
      if (v >= Data_Bounded.bottom(Data_Bounded.boundedInt) && v <= Data_Bounded.top(Data_Bounded.boundedInt)) {
          return new Data_Maybe.Just($foreign.fromCharCode(v));
      };
      return Data_Maybe.Nothing.value;
  };
  var enumChar = new Enum(function () {
      return Data_Ord.ordChar;
  }, defaultPred(charToEnum)($foreign.toCharCode), defaultSucc(charToEnum)($foreign.toCharCode));
  var boundedEnumChar = new BoundedEnum(function () {
      return Data_Bounded.boundedChar;
  }, function () {
      return enumChar;
  }, $foreign.toCharCode(Data_Bounded.top(Data_Bounded.boundedChar)) - $foreign.toCharCode(Data_Bounded.bottom(Data_Bounded.boundedChar)) | 0, $foreign.toCharCode, charToEnum);
  exports["Enum"] = Enum;
  exports["BoundedEnum"] = BoundedEnum;
  exports["toEnum"] = toEnum;
  exports["fromEnum"] = fromEnum;
  exports["toEnumWithDefaults"] = toEnumWithDefaults;
  exports["defaultSucc"] = defaultSucc;
  exports["defaultPred"] = defaultPred;
  exports["boundedEnumChar"] = boundedEnumChar;
})(PS);
(function(exports) {
  "use strict";

  exports.intDegree = function (x) {
    return Math.min(Math.abs(x), 2147483647);
  };

  // See the Euclidean definition in
  // https://en.m.wikipedia.org/wiki/Modulo_operation.
  exports.intDiv = function (x) {
    return function (y) {
      if (y === 0) return 0;
      return y > 0 ? Math.floor(x / y) : -Math.floor(x / -y);
    };
  };

  exports.intMod = function (x) {
    return function (y) {
      if (y === 0) return 0;
      var yy = Math.abs(y);
      return ((x % yy) + yy) % yy;
    };
  };
})(PS["Data.EuclideanRing"] = PS["Data.EuclideanRing"] || {});
(function(exports) {
  "use strict";

  exports.intSub = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x - y | 0;
    };
  };

  exports.numSub = function (n1) {
    return function (n2) {
      return n1 - n2;
    };
  };
})(PS["Data.Ring"] = PS["Data.Ring"] || {});
(function(exports) {
  "use strict";

  exports.intAdd = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x + y | 0;
    };
  };

  exports.intMul = function (x) {
    return function (y) {
      /* jshint bitwise: false */
      return x * y | 0;
    };
  };

  exports.numAdd = function (n1) {
    return function (n2) {
      return n1 + n2;
    };
  };

  exports.numMul = function (n1) {
    return function (n2) {
      return n1 * n2;
    };
  };
})(PS["Data.Semiring"] = PS["Data.Semiring"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Semiring"] = $PS["Data.Semiring"] || {};
  var exports = $PS["Data.Semiring"];
  var $foreign = $PS["Data.Semiring"];
  var Semiring = function (add, mul, one, zero) {
      this.add = add;
      this.mul = mul;
      this.one = one;
      this.zero = zero;
  };
  var zero = function (dict) {
      return dict.zero;
  };                                                       
  var semiringNumber = new Semiring($foreign.numAdd, $foreign.numMul, 1.0, 0.0);
  var semiringInt = new Semiring($foreign.intAdd, $foreign.intMul, 1, 0);
  var one = function (dict) {
      return dict.one;
  };
  var mul = function (dict) {
      return dict.mul;
  };
  var add = function (dict) {
      return dict.add;
  };
  var semiringFn = function (dictSemiring) {
      return new Semiring(function (f) {
          return function (g) {
              return function (x) {
                  return add(dictSemiring)(f(x))(g(x));
              };
          };
      }, function (f) {
          return function (g) {
              return function (x) {
                  return mul(dictSemiring)(f(x))(g(x));
              };
          };
      }, function (v) {
          return one(dictSemiring);
      }, function (v) {
          return zero(dictSemiring);
      });
  };
  exports["Semiring"] = Semiring;
  exports["add"] = add;
  exports["zero"] = zero;
  exports["mul"] = mul;
  exports["one"] = one;
  exports["semiringInt"] = semiringInt;
  exports["semiringNumber"] = semiringNumber;
  exports["semiringFn"] = semiringFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Ring"] = $PS["Data.Ring"] || {};
  var exports = $PS["Data.Ring"];
  var $foreign = $PS["Data.Ring"];
  var Data_Semiring = $PS["Data.Semiring"];
  var Ring = function (Semiring0, sub) {
      this.Semiring0 = Semiring0;
      this.sub = sub;
  };
  var sub = function (dict) {
      return dict.sub;
  }; 
  var ringNumber = new Ring(function () {
      return Data_Semiring.semiringNumber;
  }, $foreign.numSub);
  var ringInt = new Ring(function () {
      return Data_Semiring.semiringInt;
  }, $foreign.intSub);
  var ringFn = function (dictRing) {
      return new Ring(function () {
          return Data_Semiring.semiringFn(dictRing.Semiring0());
      }, function (f) {
          return function (g) {
              return function (x) {
                  return sub(dictRing)(f(x))(g(x));
              };
          };
      });
  };
  var negate = function (dictRing) {
      return function (a) {
          return sub(dictRing)(Data_Semiring.zero(dictRing.Semiring0()))(a);
      };
  };
  exports["Ring"] = Ring;
  exports["sub"] = sub;
  exports["negate"] = negate;
  exports["ringInt"] = ringInt;
  exports["ringNumber"] = ringNumber;
  exports["ringFn"] = ringFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.CommutativeRing"] = $PS["Data.CommutativeRing"] || {};
  var exports = $PS["Data.CommutativeRing"];
  var Data_Ring = $PS["Data.Ring"];
  var CommutativeRing = function (Ring0) {
      this.Ring0 = Ring0;
  }; 
  var commutativeRingInt = new CommutativeRing(function () {
      return Data_Ring.ringInt;
  });
  exports["commutativeRingInt"] = commutativeRingInt;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.EuclideanRing"] = $PS["Data.EuclideanRing"] || {};
  var exports = $PS["Data.EuclideanRing"];
  var $foreign = $PS["Data.EuclideanRing"];
  var Data_CommutativeRing = $PS["Data.CommutativeRing"];  
  var EuclideanRing = function (CommutativeRing0, degree, div, mod) {
      this.CommutativeRing0 = CommutativeRing0;
      this.degree = degree;
      this.div = div;
      this.mod = mod;
  };
  var mod = function (dict) {
      return dict.mod;
  }; 
  var euclideanRingInt = new EuclideanRing(function () {
      return Data_CommutativeRing.commutativeRingInt;
  }, $foreign.intDegree, $foreign.intDiv, $foreign.intMod);
  var div = function (dict) {
      return dict.div;
  };
  exports["div"] = div;
  exports["mod"] = mod;
  exports["euclideanRingInt"] = euclideanRingInt;
})(PS);
(function(exports) {
  "use strict";

  exports.fromCharArray = function (a) {
    return a.join("");
  };

  exports.toCharArray = function (s) {
    return s.split("");
  };

  exports.singleton = function (c) {
    return c;
  };

  exports._charAt = function (just) {
    return function (nothing) {
      return function (i) {
        return function (s) {
          return i >= 0 && i < s.length ? just(s.charAt(i)) : nothing;
        };
      };
    };
  };

  exports.length = function (s) {
    return s.length;
  };

  exports.countPrefix = function (p) {
    return function (s) {
      var i = 0;
      while (i < s.length && p(s.charAt(i))) i++;
      return i;
    };
  };

  exports._indexOf = function (just) {
    return function (nothing) {
      return function (x) {
        return function (s) {
          var i = s.indexOf(x);
          return i === -1 ? nothing : just(i);
        };
      };
    };
  };

  exports.take = function (n) {
    return function (s) {
      return s.substr(0, n);
    };
  };

  exports.drop = function (n) {
    return function (s) {
      return s.substring(n);
    };
  };

  exports._slice = function (b) {
    return function (e) {
      return function (s) {
        return s.slice(b,e);
      };
    };
  };

  exports.splitAt = function (i) {
    return function (s) {
      return { before: s.substring(0, i), after: s.substring(i) };
    };
  };
})(PS["Data.String.CodeUnits"] = PS["Data.String.CodeUnits"] || {});
(function(exports) {
  "use strict";

  exports.charAt = function (i) {
    return function (s) {
      if (i >= 0 && i < s.length) return s.charAt(i);
      throw new Error("Data.String.Unsafe.charAt: Invalid index.");
    };
  };
})(PS["Data.String.Unsafe"] = PS["Data.String.Unsafe"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Unsafe"] = $PS["Data.String.Unsafe"] || {};
  var exports = $PS["Data.String.Unsafe"];
  var $foreign = $PS["Data.String.Unsafe"];
  exports["charAt"] = $foreign.charAt;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.CodeUnits"] = $PS["Data.String.CodeUnits"] || {};
  var exports = $PS["Data.String.CodeUnits"];
  var $foreign = $PS["Data.String.CodeUnits"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_String_Unsafe = $PS["Data.String.Unsafe"];                
  var uncons = function (v) {
      if (v === "") {
          return Data_Maybe.Nothing.value;
      };
      return new Data_Maybe.Just({
          head: Data_String_Unsafe.charAt(0)(v),
          tail: $foreign.drop(1)(v)
      });
  };
  var stripPrefix = function (v) {
      return function (str) {
          var v1 = $foreign.splitAt($foreign.length(v))(str);
          var $15 = v1.before === v;
          if ($15) {
              return new Data_Maybe.Just(v1.after);
          };
          return Data_Maybe.Nothing.value;
      };
  };
  var slice = function (b) {
      return function (e) {
          return function (s) {
              var l = $foreign.length(s);
              var norm = function (x) {
                  if (x < 0) {
                      return l + x | 0;
                  };
                  if (Data_Boolean.otherwise) {
                      return x;
                  };
                  throw new Error("Failed pattern match at Data.String.CodeUnits (line 319, column 5 - line 320, column 27): " + [ x.constructor.name ]);
              };
              var e$prime = norm(e);
              var b$prime = norm(b);
              var $19 = b$prime < 0 || (b$prime >= l || (e$prime < 0 || (e$prime > l || b$prime > e$prime)));
              if ($19) {
                  return Data_Maybe.Nothing.value;
              };
              return new Data_Maybe.Just($foreign["_slice"](b)(e)(s));
          };
      };
  };                                                                                                   
  var indexOf = $foreign["_indexOf"](Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  var dropWhile = function (p) {
      return function (s) {
          return $foreign.drop($foreign.countPrefix(p)(s))(s);
      };
  };
  var contains = function (pat) {
      var $20 = indexOf(pat);
      return function ($21) {
          return Data_Maybe.isJust($20($21));
      };
  };
  var charAt = $foreign["_charAt"](Data_Maybe.Just.create)(Data_Maybe.Nothing.value);
  exports["stripPrefix"] = stripPrefix;
  exports["contains"] = contains;
  exports["uncons"] = uncons;
  exports["indexOf"] = indexOf;
  exports["dropWhile"] = dropWhile;
  exports["slice"] = slice;
  exports["singleton"] = $foreign.singleton;
  exports["fromCharArray"] = $foreign.fromCharArray;
  exports["toCharArray"] = $foreign.toCharArray;
  exports["length"] = $foreign.length;
  exports["countPrefix"] = $foreign.countPrefix;
  exports["take"] = $foreign.take;
  exports["drop"] = $foreign.drop;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.CodePoints"] = $PS["Data.String.CodePoints"] || {};
  var exports = $PS["Data.String.CodePoints"];
  var $foreign = $PS["Data.String.CodePoints"];
  var Data_Array = $PS["Data.Array"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Bounded = $PS["Data.Bounded"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_EuclideanRing = $PS["Data.EuclideanRing"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_String_CodeUnits = $PS["Data.String.CodeUnits"];
  var Data_String_Unsafe = $PS["Data.String.Unsafe"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];                
  var CodePoint = function (x) {
      return x;
  };
  var unsurrogate = function (lead) {
      return function (trail) {
          return (((lead - 55296 | 0) * 1024 | 0) + (trail - 56320 | 0) | 0) + 65536 | 0;
      };
  }; 
  var isTrail = function (cu) {
      return 56320 <= cu && cu <= 57343;
  };
  var isLead = function (cu) {
      return 55296 <= cu && cu <= 56319;
  };
  var uncons = function (s) {
      var v = Data_String_CodeUnits.length(s);
      if (v === 0) {
          return Data_Maybe.Nothing.value;
      };
      if (v === 1) {
          return new Data_Maybe.Just({
              head: Data_Enum.fromEnum(Data_Enum.boundedEnumChar)(Data_String_Unsafe.charAt(0)(s)),
              tail: ""
          });
      };
      var cu1 = Data_Enum.fromEnum(Data_Enum.boundedEnumChar)(Data_String_Unsafe.charAt(1)(s));
      var cu0 = Data_Enum.fromEnum(Data_Enum.boundedEnumChar)(Data_String_Unsafe.charAt(0)(s));
      var $21 = isLead(cu0) && isTrail(cu1);
      if ($21) {
          return new Data_Maybe.Just({
              head: unsurrogate(cu0)(cu1),
              tail: Data_String_CodeUnits.drop(2)(s)
          });
      };
      return new Data_Maybe.Just({
          head: cu0,
          tail: Data_String_CodeUnits.drop(1)(s)
      });
  };
  var unconsButWithTuple = function (s) {
      return Data_Functor.map(Data_Maybe.functorMaybe)(function (v) {
          return new Data_Tuple.Tuple(v.head, v.tail);
      })(uncons(s));
  };
  var toCodePointArrayFallback = function (s) {
      return Data_Unfoldable.unfoldr(Data_Unfoldable.unfoldableArray)(unconsButWithTuple)(s);
  };
  var unsafeCodePointAt0Fallback = function (s) {
      var cu0 = Data_Enum.fromEnum(Data_Enum.boundedEnumChar)(Data_String_Unsafe.charAt(0)(s));
      var $25 = isLead(cu0) && Data_String_CodeUnits.length(s) > 1;
      if ($25) {
          var cu1 = Data_Enum.fromEnum(Data_Enum.boundedEnumChar)(Data_String_Unsafe.charAt(1)(s));
          var $26 = isTrail(cu1);
          if ($26) {
              return unsurrogate(cu0)(cu1);
          };
          return cu0;
      };
      return cu0;
  };
  var unsafeCodePointAt0 = $foreign["_unsafeCodePointAt0"](unsafeCodePointAt0Fallback);
  var toCodePointArray = $foreign["_toCodePointArray"](toCodePointArrayFallback)(unsafeCodePointAt0);
  var length = function ($52) {
      return Data_Array.length(toCodePointArray($52));
  };
  var indexOf = function (p) {
      return function (s) {
          return Data_Functor.map(Data_Maybe.functorMaybe)(function (i) {
              return length(Data_String_CodeUnits.take(i)(s));
          })(Data_String_CodeUnits.indexOf(p)(s));
      };
  };
  var fromCharCode = (function () {
      var $53 = Data_Enum.toEnumWithDefaults(Data_Enum.boundedEnumChar)(Data_Bounded.bottom(Data_Bounded.boundedChar))(Data_Bounded.top(Data_Bounded.boundedChar));
      return function ($54) {
          return Data_String_CodeUnits.singleton($53($54));
      };
  })();
  var singletonFallback = function (v) {
      if (v <= 65535) {
          return fromCharCode(v);
      };
      var lead = Data_EuclideanRing.div(Data_EuclideanRing.euclideanRingInt)(v - 65536 | 0)(1024) + 55296 | 0;
      var trail = Data_EuclideanRing.mod(Data_EuclideanRing.euclideanRingInt)(v - 65536 | 0)(1024) + 56320 | 0;
      return fromCharCode(lead) + fromCharCode(trail);
  };                                                                          
  var singleton = $foreign["_singleton"](singletonFallback);
  var takeFallback = function (n) {
      return function (v) {
          if (n < 1) {
              return "";
          };
          var v1 = uncons(v);
          if (v1 instanceof Data_Maybe.Just) {
              return singleton(v1.value0.head) + takeFallback(n - 1 | 0)(v1.value0.tail);
          };
          return v;
      };
  };
  var take = $foreign["_take"](takeFallback);
  var splitAt = function (i) {
      return function (s) {
          var before = take(i)(s);
          return {
              before: before,
              after: Data_String_CodeUnits.drop(Data_String_CodeUnits.length(before))(s)
          };
      };
  };
  var eqCodePoint = new Data_Eq.Eq(function (x) {
      return function (y) {
          return x === y;
      };
  });
  var ordCodePoint = new Data_Ord.Ord(function () {
      return eqCodePoint;
  }, function (x) {
      return function (y) {
          return Data_Ord.compare(Data_Ord.ordInt)(x)(y);
      };
  });
  var drop = function (n) {
      return function (s) {
          return Data_String_CodeUnits.drop(Data_String_CodeUnits.length(take(n)(s)))(s);
      };
  };
  var codePointFromChar = (function () {
      var $55 = Data_Enum.fromEnum(Data_Enum.boundedEnumChar);
      return function ($56) {
          return CodePoint($55($56));
      };
  })();
  var boundedCodePoint = new Data_Bounded.Bounded(function () {
      return ordCodePoint;
  }, 0, 1114111);
  var boundedEnumCodePoint = new Data_Enum.BoundedEnum(function () {
      return boundedCodePoint;
  }, function () {
      return enumCodePoint;
  }, 1114111 + 1 | 0, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 1114111) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.String.CodePoints (line 63, column 1 - line 68, column 26): " + [ n.constructor.name ]);
  });
  var enumCodePoint = new Data_Enum.Enum(function () {
      return ordCodePoint;
  }, Data_Enum.defaultPred(Data_Enum.toEnum(boundedEnumCodePoint))(Data_Enum.fromEnum(boundedEnumCodePoint)), Data_Enum.defaultSucc(Data_Enum.toEnum(boundedEnumCodePoint))(Data_Enum.fromEnum(boundedEnumCodePoint)));
  exports["codePointFromChar"] = codePointFromChar;
  exports["toCodePointArray"] = toCodePointArray;
  exports["length"] = length;
  exports["indexOf"] = indexOf;
  exports["take"] = take;
  exports["drop"] = drop;
  exports["splitAt"] = splitAt;
  exports["boundedEnumCodePoint"] = boundedEnumCodePoint;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Color"] = $PS["Color"] || {};
  var exports = $PS["Color"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Int = $PS["Data.Int"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_String_CodePoints = $PS["Data.String.CodePoints"];
  var $$Math = $PS["Math"];
  var HSLA = (function () {
      function HSLA(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      HSLA.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new HSLA(value0, value1, value2, value3);
                  };
              };
          };
      };
      return HSLA;
  })();
  var modPos = function (x) {
      return function (y) {
          return $$Math.remainder($$Math.remainder(x)(y) + y)(y);
      };
  };
  var rgba = function (red$prime) {
      return function (green$prime) {
          return function (blue$prime) {
              return function (alpha) {
                  var red = Data_Ord.clamp(Data_Ord.ordInt)(0)(255)(red$prime);
                  var r = Data_Int.toNumber(red) / 255.0;
                  var green = Data_Ord.clamp(Data_Ord.ordInt)(0)(255)(green$prime);
                  var g = Data_Int.toNumber(green) / 255.0;
                  var blue = Data_Ord.clamp(Data_Ord.ordInt)(0)(255)(blue$prime);
                  var maxChroma = Data_Ord.max(Data_Ord.ordInt)(Data_Ord.max(Data_Ord.ordInt)(red)(green))(blue);
                  var minChroma = Data_Ord.min(Data_Ord.ordInt)(Data_Ord.min(Data_Ord.ordInt)(red)(green))(blue);
                  var chroma = maxChroma - minChroma | 0;
                  var chroma$prime = Data_Int.toNumber(chroma) / 255.0;
                  var lightness = Data_Int.toNumber(maxChroma + minChroma | 0) / (255.0 * 2.0);
                  var saturation = (function () {
                      if (chroma === 0) {
                          return 0.0;
                      };
                      if (Data_Boolean.otherwise) {
                          return chroma$prime / (1.0 - $$Math.abs(2.0 * lightness - 1.0));
                      };
                      throw new Error("Failed pattern match at Color (line 157, column 5 - line 158, column 75): " + [  ]);
                  })();
                  var b = Data_Int.toNumber(blue) / 255.0;
                  var hue$prime = function (v) {
                      if (v === 0) {
                          return 0.0;
                      };
                      if (maxChroma === red) {
                          return modPos((g - b) / chroma$prime)(6.0);
                      };
                      if (maxChroma === green) {
                          return (b - r) / chroma$prime + 2.0;
                      };
                      if (Data_Boolean.otherwise) {
                          return (r - g) / chroma$prime + 4.0;
                      };
                      throw new Error("Failed pattern match at Color (line 148, column 5 - line 148, column 17): " + [ v.constructor.name ]);
                  };
                  var hue = 60.0 * hue$prime(chroma);
                  return new HSLA(hue, saturation, lightness, alpha);
              };
          };
      };
  };
  var rgb = function (r) {
      return function (g) {
          return function (b) {
              return rgba(r)(g)(b)(1.0);
          };
      };
  };                                   
  var clipHue = function (v) {
      var $65 = 360.0 === v;
      if ($65) {
          return v;
      };
      return modPos(v)(360.0);
  };
  var toRGBA$prime = function (v) {
      var h$prime = clipHue(v.value0) / 60.0;
      var chr = (1.0 - $$Math.abs(2.0 * v.value2 - 1.0)) * v.value1;
      var m = v.value2 - chr / 2.0;
      var x = chr * (1.0 - $$Math.abs($$Math.remainder(h$prime)(2.0) - 1.0));
      var col = (function () {
          if (h$prime < 1.0) {
              return {
                  r: chr,
                  g: x,
                  b: 0.0
              };
          };
          if (1.0 <= h$prime && h$prime < 2.0) {
              return {
                  r: x,
                  g: chr,
                  b: 0.0
              };
          };
          if (2.0 <= h$prime && h$prime < 3.0) {
              return {
                  r: 0.0,
                  g: chr,
                  b: x
              };
          };
          if (3.0 <= h$prime && h$prime < 4.0) {
              return {
                  r: 0.0,
                  g: x,
                  b: chr
              };
          };
          if (4.0 <= h$prime && h$prime < 5.0) {
              return {
                  r: x,
                  g: 0.0,
                  b: chr
              };
          };
          if (Data_Boolean.otherwise) {
              return {
                  r: chr,
                  g: 0.0,
                  b: x
              };
          };
          throw new Error("Failed pattern match at Color (line 342, column 5 - line 347, column 61): " + [  ]);
      })();
      return {
          r: col.r + m,
          g: col.g + m,
          b: col.b + m,
          a: v.value3
      };
  };
  var toRGBA = function (col) {
      var c = toRGBA$prime(col);
      var g = Data_Int.round(255.0 * c.g);
      var r = Data_Int.round(255.0 * c.r);
      var b = Data_Int.round(255.0 * c.b);
      return {
          r: r,
          g: g,
          b: b,
          a: c.a
      };
  }; 
  var toHexString = function (color) {
      var toHex = function (num) {
          var repr = Data_Int.toStringAs(Data_Int.hexadecimal)(num);
          var $93 = Data_String_CodePoints.length(repr) === 1;
          if ($93) {
              return "0" + repr;
          };
          return repr;
      };
      var c = toRGBA(color);
      return "#" + (toHex(c.r) + (toHex(c.g) + toHex(c.b)));
  };
  exports["rgba"] = rgba;
  exports["rgb"] = rgb;
  exports["toHexString"] = toHexString;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Color.Scheme.X11"] = $PS["Color.Scheme.X11"] || {};
  var exports = $PS["Color.Scheme.X11"];
  var Color = $PS["Color"];            
  var violet = Color.rgb(238)(130)(238);
  exports["violet"] = violet;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Extend"] = $PS["Control.Extend"] || {};
  var exports = $PS["Control.Extend"];                       
  var Extend = function (Functor0, extend) {
      this.Functor0 = Functor0;
      this.extend = extend;
  };                       
  var extend = function (dict) {
      return dict.extend;
  };
  exports["Extend"] = Extend;
  exports["extend"] = extend;
})(PS);
(function(exports) {
  "use strict";

  exports.defer = function (thunk) {
    var v = null;
    return function() {
      if (thunk === undefined) return v;

      v = thunk();
      thunk = undefined; // eslint-disable-line no-param-reassign
      return v;
    };
  };

  exports.force = function (l) {
    return l();
  };
})(PS["Data.Lazy"] = PS["Data.Lazy"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lazy"] = $PS["Data.Lazy"] || {};
  var exports = $PS["Data.Lazy"];
  var $foreign = $PS["Data.Lazy"];
  var Data_Functor = $PS["Data.Functor"];
  var functorLazy = new Data_Functor.Functor(function (f) {
      return function (l) {
          return $foreign.defer(function (v) {
              return f($foreign.force(l));
          });
      };
  });
  exports["functorLazy"] = functorLazy;
  exports["defer"] = $foreign.defer;
  exports["force"] = $foreign.force;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Comonad.Cofree"] = $PS["Control.Comonad.Cofree"] || {};
  var exports = $PS["Control.Comonad.Cofree"];
  var Control_Extend = $PS["Control.Extend"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Tuple = $PS["Data.Tuple"];
  var tail = function (v) {
      return Data_Tuple.snd(Data_Lazy.force(v));
  };
  var mkCofree = function (a) {
      return function (t) {
          return Data_Lazy.defer(function (v) {
              return new Data_Tuple.Tuple(a, t);
          });
      };
  };
  var head = function (v) {
      return Data_Tuple.fst(Data_Lazy.force(v));
  };
  var functorCofree = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          var loop = function (v) {
              return Data_Functor.map(Data_Lazy.functorLazy)(function (v1) {
                  return new Data_Tuple.Tuple(f(v1.value0), Data_Functor.map(dictFunctor)(loop)(v1.value1));
              })(v);
          };
          return loop;
      });
  };
  var extendCofree = function (dictFunctor) {
      return new Control_Extend.Extend(function () {
          return functorCofree(dictFunctor);
      }, function (f) {
          var loop = function (v) {
              return Data_Functor.map(Data_Lazy.functorLazy)(function (v1) {
                  return new Data_Tuple.Tuple(f(v), Data_Functor.map(dictFunctor)(loop)(v1.value1));
              })(v);
          };
          return loop;
      });
  };
  exports["mkCofree"] = mkCofree;
  exports["head"] = head;
  exports["tail"] = tail;
  exports["extendCofree"] = extendCofree;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Rec.Class"] = $PS["Control.Monad.Rec.Class"] || {};
  var exports = $PS["Control.Monad.Rec.Class"];
  var Data_Identity = $PS["Data.Identity"];          
  var Loop = (function () {
      function Loop(value0) {
          this.value0 = value0;
      };
      Loop.create = function (value0) {
          return new Loop(value0);
      };
      return Loop;
  })();
  var Done = (function () {
      function Done(value0) {
          this.value0 = value0;
      };
      Done.create = function (value0) {
          return new Done(value0);
      };
      return Done;
  })();
  var MonadRec = function (Monad0, tailRecM) {
      this.Monad0 = Monad0;
      this.tailRecM = tailRecM;
  };
  var tailRecM = function (dict) {
      return dict.tailRecM;
  };
  var tailRec = function (f) {
      var go = function ($copy_v) {
          var $tco_done = false;
          var $tco_result;
          function $tco_loop(v) {
              if (v instanceof Loop) {
                  $copy_v = f(v.value0);
                  return;
              };
              if (v instanceof Done) {
                  $tco_done = true;
                  return v.value0;
              };
              throw new Error("Failed pattern match at Control.Monad.Rec.Class (line 93, column 3 - line 93, column 25): " + [ v.constructor.name ]);
          };
          while (!$tco_done) {
              $tco_result = $tco_loop($copy_v);
          };
          return $tco_result;
      };
      return function ($58) {
          return go(f($58));
      };
  }; 
  var monadRecIdentity = new MonadRec(function () {
      return Data_Identity.monadIdentity;
  }, function (f) {
      var runIdentity = function (v) {
          return v;
      };
      var $59 = tailRec(function ($61) {
          return runIdentity(f($61));
      });
      return function ($60) {
          return Data_Identity.Identity($59($60));
      };
  });
  exports["Loop"] = Loop;
  exports["Done"] = Done;
  exports["MonadRec"] = MonadRec;
  exports["tailRecM"] = tailRecM;
  exports["monadRecIdentity"] = monadRecIdentity;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.List"] = $PS["Data.List"] || {};
  var exports = $PS["Data.List"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Lazy = $PS["Control.Lazy"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];                                  
  var uncons = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just({
              head: v.value0,
              tail: v.value1
          });
      };
      throw new Error("Failed pattern match at Data.List (line 263, column 1 - line 263, column 66): " + [ v.constructor.name ]);
  };
  var toUnfoldable = function (dictUnfoldable) {
      return Data_Unfoldable.unfoldr(dictUnfoldable)(function (xs) {
          return Data_Functor.map(Data_Maybe.functorMaybe)(function (rec) {
              return new Data_Tuple.Tuple(rec.head, rec.tail);
          })(uncons(xs));
      });
  };
  var tail = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just(v.value1);
      };
      throw new Error("Failed pattern match at Data.List (line 249, column 1 - line 249, column 43): " + [ v.constructor.name ]);
  };
  var span = function (v) {
      return function (v1) {
          if (v1 instanceof Data_List_Types.Cons && v(v1.value0)) {
              var v2 = span(v)(v1.value1);
              return {
                  init: new Data_List_Types.Cons(v1.value0, v2.init),
                  rest: v2.rest
              };
          };
          return {
              init: Data_List_Types.Nil.value,
              rest: v1
          };
      };
  };
  var snoc = function (xs) {
      return function (x) {
          return Data_Foldable.foldr(Data_List_Types.foldableList)(Data_List_Types.Cons.create)(new Data_List_Types.Cons(x, Data_List_Types.Nil.value))(xs);
      };
  };
  var singleton = function (a) {
      return new Data_List_Types.Cons(a, Data_List_Types.Nil.value);
  };
  var reverse = (function () {
      var go = function ($copy_acc) {
          return function ($copy_v) {
              var $tco_var_acc = $copy_acc;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(acc, v) {
                  if (v instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return acc;
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      $tco_var_acc = new Data_List_Types.Cons(v.value0, acc);
                      $copy_v = v.value1;
                      return;
                  };
                  throw new Error("Failed pattern match at Data.List (line 372, column 3 - line 372, column 19): " + [ acc.constructor.name, v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_acc, $copy_v);
              };
              return $tco_result;
          };
      };
      return go(Data_List_Types.Nil.value);
  })();
  var take = (function () {
      var go = function ($copy_acc) {
          return function ($copy_v) {
              return function ($copy_v1) {
                  var $tco_var_acc = $copy_acc;
                  var $tco_var_v = $copy_v;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(acc, v, v1) {
                      if (v < 1) {
                          $tco_done = true;
                          return reverse(acc);
                      };
                      if (v1 instanceof Data_List_Types.Nil) {
                          $tco_done = true;
                          return reverse(acc);
                      };
                      if (v1 instanceof Data_List_Types.Cons) {
                          $tco_var_acc = new Data_List_Types.Cons(v1.value0, acc);
                          $tco_var_v = v - 1 | 0;
                          $copy_v1 = v1.value1;
                          return;
                      };
                      throw new Error("Failed pattern match at Data.List (line 524, column 3 - line 524, column 35): " + [ acc.constructor.name, v.constructor.name, v1.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_acc, $tco_var_v, $copy_v1);
                  };
                  return $tco_result;
              };
          };
      };
      return go(Data_List_Types.Nil.value);
  })();
  var unsnoc = function (lst) {
      var go = function ($copy_v) {
          return function ($copy_v1) {
              var $tco_var_v = $copy_v;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(v, v1) {
                  if (v instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return Data_Maybe.Nothing.value;
                  };
                  if (v instanceof Data_List_Types.Cons && v.value1 instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return new Data_Maybe.Just({
                          revInit: v1,
                          last: v.value0
                      });
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      $tco_var_v = v.value1;
                      $copy_v1 = new Data_List_Types.Cons(v.value0, v1);
                      return;
                  };
                  throw new Error("Failed pattern match at Data.List (line 274, column 3 - line 274, column 21): " + [ v.constructor.name, v1.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_v, $copy_v1);
              };
              return $tco_result;
          };
      };
      return Data_Functor.map(Data_Maybe.functorMaybe)(function (h) {
          return {
              init: reverse(h.revInit),
              last: h.last
          };
      })(go(lst)(Data_List_Types.Nil.value));
  };
  var zipWith = function (f) {
      return function (xs) {
          return function (ys) {
              var go = function ($copy_v) {
                  return function ($copy_v1) {
                      return function ($copy_acc) {
                          var $tco_var_v = $copy_v;
                          var $tco_var_v1 = $copy_v1;
                          var $tco_done = false;
                          var $tco_result;
                          function $tco_loop(v, v1, acc) {
                              if (v instanceof Data_List_Types.Nil) {
                                  $tco_done = true;
                                  return acc;
                              };
                              if (v1 instanceof Data_List_Types.Nil) {
                                  $tco_done = true;
                                  return acc;
                              };
                              if (v instanceof Data_List_Types.Cons && v1 instanceof Data_List_Types.Cons) {
                                  $tco_var_v = v.value1;
                                  $tco_var_v1 = v1.value1;
                                  $copy_acc = new Data_List_Types.Cons(f(v.value0)(v1.value0), acc);
                                  return;
                              };
                              throw new Error("Failed pattern match at Data.List (line 795, column 3 - line 795, column 21): " + [ v.constructor.name, v1.constructor.name, acc.constructor.name ]);
                          };
                          while (!$tco_done) {
                              $tco_result = $tco_loop($tco_var_v, $tco_var_v1, $copy_acc);
                          };
                          return $tco_result;
                      };
                  };
              };
              return reverse(go(xs)(ys)(Data_List_Types.Nil.value));
          };
      };
  };
  var zip = zipWith(Data_Tuple.Tuple.create);
  var range = function (start) {
      return function (end) {
          if (start === end) {
              return singleton(start);
          };
          if (Data_Boolean.otherwise) {
              var go = function ($copy_s) {
                  return function ($copy_e) {
                      return function ($copy_step) {
                          return function ($copy_rest) {
                              var $tco_var_s = $copy_s;
                              var $tco_var_e = $copy_e;
                              var $tco_var_step = $copy_step;
                              var $tco_done = false;
                              var $tco_result;
                              function $tco_loop(s, e, step, rest) {
                                  if (s === e) {
                                      $tco_done = true;
                                      return new Data_List_Types.Cons(s, rest);
                                  };
                                  if (Data_Boolean.otherwise) {
                                      $tco_var_s = s + step | 0;
                                      $tco_var_e = e;
                                      $tco_var_step = step;
                                      $copy_rest = new Data_List_Types.Cons(s, rest);
                                      return;
                                  };
                                  throw new Error("Failed pattern match at Data.List (line 152, column 3 - line 153, column 65): " + [ s.constructor.name, e.constructor.name, step.constructor.name, rest.constructor.name ]);
                              };
                              while (!$tco_done) {
                                  $tco_result = $tco_loop($tco_var_s, $tco_var_e, $tco_var_step, $copy_rest);
                              };
                              return $tco_result;
                          };
                      };
                  };
              };
              return go(end)(start)((function () {
                  var $226 = start > end;
                  if ($226) {
                      return 1;
                  };
                  return -1 | 0;
              })())(Data_List_Types.Nil.value);
          };
          throw new Error("Failed pattern match at Data.List (line 148, column 1 - line 148, column 32): " + [ start.constructor.name, end.constructor.name ]);
      };
  };
  var $$null = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return true;
      };
      return false;
  }; 
  var mapWithIndex = Data_FunctorWithIndex.mapWithIndex(Data_List_Types.functorWithIndexList);
  var some = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Apply.apply((dictAlternative.Applicative0()).Apply0())(Data_Functor.map(((dictAlternative.Plus1()).Alt0()).Functor0())(Data_List_Types.Cons.create)(v))(Control_Lazy.defer(dictLazy)(function (v1) {
                  return many(dictAlternative)(dictLazy)(v);
              }));
          };
      };
  };
  var many = function (dictAlternative) {
      return function (dictLazy) {
          return function (v) {
              return Control_Alt.alt((dictAlternative.Plus1()).Alt0())(some(dictAlternative)(dictLazy)(v))(Control_Applicative.pure(dictAlternative.Applicative0())(Data_List_Types.Nil.value));
          };
      };
  };
  var length = Data_Foldable.foldl(Data_List_Types.foldableList)(function (acc) {
      return function (v) {
          return acc + 1 | 0;
      };
  })(0);
  var last = function ($copy_v) {
      var $tco_done = false;
      var $tco_result;
      function $tco_loop(v) {
          if (v instanceof Data_List_Types.Cons && v.value1 instanceof Data_List_Types.Nil) {
              $tco_done = true;
              return new Data_Maybe.Just(v.value0);
          };
          if (v instanceof Data_List_Types.Cons) {
              $copy_v = v.value1;
              return;
          };
          $tco_done = true;
          return Data_Maybe.Nothing.value;
      };
      while (!$tco_done) {
          $tco_result = $tco_loop($copy_v);
      };
      return $tco_result;
  };
  var init = function (lst) {
      return Data_Functor.map(Data_Maybe.functorMaybe)(function (v) {
          return v.init;
      })(unsnoc(lst));
  };
  var head = function (v) {
      if (v instanceof Data_List_Types.Nil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof Data_List_Types.Cons) {
          return new Data_Maybe.Just(v.value0);
      };
      throw new Error("Failed pattern match at Data.List (line 234, column 1 - line 234, column 22): " + [ v.constructor.name ]);
  };
  var fromFoldable = function (dictFoldable) {
      return Data_Foldable.foldr(dictFoldable)(Data_List_Types.Cons.create)(Data_List_Types.Nil.value);
  };
  var findIndex = function (fn) {
      var go = function ($copy_v) {
          return function ($copy_v1) {
              var $tco_var_v = $copy_v;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(v, v1) {
                  if (v1 instanceof Data_List_Types.Cons) {
                      if (fn(v1.value0)) {
                          $tco_done = true;
                          return new Data_Maybe.Just(v);
                      };
                      if (Data_Boolean.otherwise) {
                          $tco_var_v = v + 1 | 0;
                          $copy_v1 = v1.value1;
                          return;
                      };
                  };
                  if (v1 instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return Data_Maybe.Nothing.value;
                  };
                  throw new Error("Failed pattern match at Data.List (line 305, column 3 - line 305, column 35): " + [ v.constructor.name, v1.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_v, $copy_v1);
              };
              return $tco_result;
          };
      };
      return go(0);
  };
  var filter = function (p) {
      var go = function ($copy_acc) {
          return function ($copy_v) {
              var $tco_var_acc = $copy_acc;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(acc, v) {
                  if (v instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return reverse(acc);
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      if (p(v.value0)) {
                          $tco_var_acc = new Data_List_Types.Cons(v.value0, acc);
                          $copy_v = v.value1;
                          return;
                      };
                      if (Data_Boolean.otherwise) {
                          $tco_var_acc = acc;
                          $copy_v = v.value1;
                          return;
                      };
                  };
                  throw new Error("Failed pattern match at Data.List (line 394, column 3 - line 394, column 27): " + [ acc.constructor.name, v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_acc, $copy_v);
              };
              return $tco_result;
          };
      };
      return go(Data_List_Types.Nil.value);
  };
  var elemIndex = function (dictEq) {
      return function (x) {
          return findIndex(function (v) {
              return Data_Eq.eq(dictEq)(v)(x);
          });
      };
  };
  var drop = function ($copy_v) {
      return function ($copy_v1) {
          var $tco_var_v = $copy_v;
          var $tco_done = false;
          var $tco_result;
          function $tco_loop(v, v1) {
              if (v < 1) {
                  $tco_done = true;
                  return v1;
              };
              if (v1 instanceof Data_List_Types.Nil) {
                  $tco_done = true;
                  return Data_List_Types.Nil.value;
              };
              if (v1 instanceof Data_List_Types.Cons) {
                  $tco_var_v = v - 1 | 0;
                  $copy_v1 = v1.value1;
                  return;
              };
              throw new Error("Failed pattern match at Data.List (line 547, column 1 - line 547, column 42): " + [ v.constructor.name, v1.constructor.name ]);
          };
          while (!$tco_done) {
              $tco_result = $tco_loop($tco_var_v, $copy_v1);
          };
          return $tco_result;
      };
  };
  var deleteAt = function (v) {
      return function (v1) {
          if (v === 0 && v1 instanceof Data_List_Types.Cons) {
              return new Data_Maybe.Just(v1.value1);
          };
          if (v1 instanceof Data_List_Types.Cons) {
              return Data_Functor.map(Data_Maybe.functorMaybe)(function (v2) {
                  return new Data_List_Types.Cons(v1.value0, v2);
              })(deleteAt(v - 1 | 0)(v1.value1));
          };
          return Data_Maybe.Nothing.value;
      };
  };                                                                               
  var alterAt = function (v) {
      return function (v1) {
          return function (v2) {
              if (v === 0 && v2 instanceof Data_List_Types.Cons) {
                  return Data_Maybe.Just.create((function () {
                      var v3 = v1(v2.value0);
                      if (v3 instanceof Data_Maybe.Nothing) {
                          return v2.value1;
                      };
                      if (v3 instanceof Data_Maybe.Just) {
                          return new Data_List_Types.Cons(v3.value0, v2.value1);
                      };
                      throw new Error("Failed pattern match at Data.List (line 356, column 3 - line 358, column 23): " + [ v3.constructor.name ]);
                  })());
              };
              if (v2 instanceof Data_List_Types.Cons) {
                  return Data_Functor.map(Data_Maybe.functorMaybe)(function (v3) {
                      return new Data_List_Types.Cons(v2.value0, v3);
                  })(alterAt(v - 1 | 0)(v1)(v2.value1));
              };
              return Data_Maybe.Nothing.value;
          };
      };
  };
  var modifyAt = function (n) {
      return function (f) {
          return alterAt(n)(function ($354) {
              return Data_Maybe.Just.create(f($354));
          });
      };
  };
  exports["toUnfoldable"] = toUnfoldable;
  exports["fromFoldable"] = fromFoldable;
  exports["singleton"] = singleton;
  exports["range"] = range;
  exports["some"] = some;
  exports["many"] = many;
  exports["null"] = $$null;
  exports["length"] = length;
  exports["snoc"] = snoc;
  exports["head"] = head;
  exports["last"] = last;
  exports["unsnoc"] = unsnoc;
  exports["elemIndex"] = elemIndex;
  exports["deleteAt"] = deleteAt;
  exports["modifyAt"] = modifyAt;
  exports["reverse"] = reverse;
  exports["filter"] = filter;
  exports["mapWithIndex"] = mapWithIndex;
  exports["take"] = take;
  exports["drop"] = drop;
  exports["span"] = span;
  exports["zip"] = zip;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.CatQueue"] = $PS["Data.CatQueue"] || {};
  var exports = $PS["Data.CatQueue"];
  var Data_List = $PS["Data.List"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Tuple = $PS["Data.Tuple"];                            
  var CatQueue = (function () {
      function CatQueue(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      CatQueue.create = function (value0) {
          return function (value1) {
              return new CatQueue(value0, value1);
          };
      };
      return CatQueue;
  })();
  var uncons = function ($copy_v) {
      var $tco_done = false;
      var $tco_result;
      function $tco_loop(v) {
          if (v.value0 instanceof Data_List_Types.Nil && v.value1 instanceof Data_List_Types.Nil) {
              $tco_done = true;
              return Data_Maybe.Nothing.value;
          };
          if (v.value0 instanceof Data_List_Types.Nil) {
              $copy_v = new CatQueue(Data_List.reverse(v.value1), Data_List_Types.Nil.value);
              return;
          };
          if (v.value0 instanceof Data_List_Types.Cons) {
              $tco_done = true;
              return new Data_Maybe.Just(new Data_Tuple.Tuple(v.value0.value0, new CatQueue(v.value0.value1, v.value1)));
          };
          throw new Error("Failed pattern match at Data.CatQueue (line 83, column 1 - line 83, column 63): " + [ v.constructor.name ]);
      };
      while (!$tco_done) {
          $tco_result = $tco_loop($copy_v);
      };
      return $tco_result;
  };
  var snoc = function (v) {
      return function (a) {
          return new CatQueue(v.value0, new Data_List_Types.Cons(a, v.value1));
      };
  };
  var $$null = function (v) {
      if (v.value0 instanceof Data_List_Types.Nil && v.value1 instanceof Data_List_Types.Nil) {
          return true;
      };
      return false;
  };                                                                                                
  var empty = new CatQueue(Data_List_Types.Nil.value, Data_List_Types.Nil.value);
  exports["empty"] = empty;
  exports["null"] = $$null;
  exports["snoc"] = snoc;
  exports["uncons"] = uncons;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.CatList"] = $PS["Data.CatList"] || {};
  var exports = $PS["Data.CatList"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Data_CatQueue = $PS["Data.CatQueue"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Tuple = $PS["Data.Tuple"];                            
  var CatNil = (function () {
      function CatNil() {

      };
      CatNil.value = new CatNil();
      return CatNil;
  })();
  var CatCons = (function () {
      function CatCons(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      CatCons.create = function (value0) {
          return function (value1) {
              return new CatCons(value0, value1);
          };
      };
      return CatCons;
  })();
  var link = function (v) {
      return function (v1) {
          if (v instanceof CatNil) {
              return v1;
          };
          if (v1 instanceof CatNil) {
              return v;
          };
          if (v instanceof CatCons) {
              return new CatCons(v.value0, Data_CatQueue.snoc(v.value1)(v1));
          };
          throw new Error("Failed pattern match at Data.CatList (line 109, column 1 - line 109, column 54): " + [ v.constructor.name, v1.constructor.name ]);
      };
  };
  var foldr = function (k) {
      return function (b) {
          return function (q) {
              var foldl = function ($copy_v) {
                  return function ($copy_c) {
                      return function ($copy_v1) {
                          var $tco_var_v = $copy_v;
                          var $tco_var_c = $copy_c;
                          var $tco_done = false;
                          var $tco_result;
                          function $tco_loop(v, c, v1) {
                              if (v1 instanceof Data_List_Types.Nil) {
                                  $tco_done = true;
                                  return c;
                              };
                              if (v1 instanceof Data_List_Types.Cons) {
                                  $tco_var_v = v;
                                  $tco_var_c = v(c)(v1.value0);
                                  $copy_v1 = v1.value1;
                                  return;
                              };
                              throw new Error("Failed pattern match at Data.CatList (line 125, column 3 - line 125, column 59): " + [ v.constructor.name, c.constructor.name, v1.constructor.name ]);
                          };
                          while (!$tco_done) {
                              $tco_result = $tco_loop($tco_var_v, $tco_var_c, $copy_v1);
                          };
                          return $tco_result;
                      };
                  };
              };
              var go = function ($copy_xs) {
                  return function ($copy_ys) {
                      var $tco_var_xs = $copy_xs;
                      var $tco_done1 = false;
                      var $tco_result;
                      function $tco_loop(xs, ys) {
                          var v = Data_CatQueue.uncons(xs);
                          if (v instanceof Data_Maybe.Nothing) {
                              $tco_done1 = true;
                              return foldl(function (x) {
                                  return function (i) {
                                      return i(x);
                                  };
                              })(b)(ys);
                          };
                          if (v instanceof Data_Maybe.Just) {
                              $tco_var_xs = v.value0.value1;
                              $copy_ys = new Data_List_Types.Cons(k(v.value0.value0), ys);
                              return;
                          };
                          throw new Error("Failed pattern match at Data.CatList (line 121, column 14 - line 123, column 67): " + [ v.constructor.name ]);
                      };
                      while (!$tco_done1) {
                          $tco_result = $tco_loop($tco_var_xs, $copy_ys);
                      };
                      return $tco_result;
                  };
              };
              return go(q)(Data_List_Types.Nil.value);
          };
      };
  };
  var uncons = function (v) {
      if (v instanceof CatNil) {
          return Data_Maybe.Nothing.value;
      };
      if (v instanceof CatCons) {
          return new Data_Maybe.Just(new Data_Tuple.Tuple(v.value0, (function () {
              var $45 = Data_CatQueue["null"](v.value1);
              if ($45) {
                  return CatNil.value;
              };
              return foldr(link)(CatNil.value)(v.value1);
          })()));
      };
      throw new Error("Failed pattern match at Data.CatList (line 100, column 1 - line 100, column 61): " + [ v.constructor.name ]);
  };
  var foldableCatList = new Data_Foldable.Foldable(function (dictMonoid) {
      return Data_Foldable.foldMapDefaultL(foldableCatList)(dictMonoid);
  }, function (f) {
      var go = function ($copy_acc) {
          return function ($copy_q) {
              var $tco_var_acc = $copy_acc;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(acc, q) {
                  var v = uncons(q);
                  if (v instanceof Data_Maybe.Just) {
                      $tco_var_acc = f(acc)(v.value0.value0);
                      $copy_q = v.value0.value1;
                      return;
                  };
                  if (v instanceof Data_Maybe.Nothing) {
                      $tco_done = true;
                      return acc;
                  };
                  throw new Error("Failed pattern match at Data.CatList (line 157, column 16 - line 159, column 22): " + [ v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_acc, $copy_q);
              };
              return $tco_result;
          };
      };
      return go;
  }, function (f) {
      return function (s) {
          return function (l) {
              return Data_Foldable.foldrDefault(foldableCatList)(f)(s)(l);
          };
      };
  });                                                                           
  var foldMap = function (dictMonoid) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof CatNil) {
                  return Data_Monoid.mempty(dictMonoid);
              };
              if (v1 instanceof CatCons) {
                  var d = (function () {
                      var $54 = Data_CatQueue["null"](v1.value1);
                      if ($54) {
                          return CatNil.value;
                      };
                      return foldr(link)(CatNil.value)(v1.value1);
                  })();
                  return Data_Semigroup.append(dictMonoid.Semigroup0())(v(v1.value0))(foldMap(dictMonoid)(v)(d));
              };
              throw new Error("Failed pattern match at Data.CatList (line 135, column 1 - line 135, column 62): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };
  var empty = CatNil.value;
  var append = link;
  var cons = function (a) {
      return function (cat) {
          return append(new CatCons(a, Data_CatQueue.empty))(cat);
      };
  };
  var functorCatList = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof CatNil) {
              return CatNil.value;
          };
          if (v1 instanceof CatCons) {
              var d = (function () {
                  var $59 = Data_CatQueue["null"](v1.value1);
                  if ($59) {
                      return CatNil.value;
                  };
                  return foldr(link)(CatNil.value)(v1.value1);
              })();
              return cons(v(v1.value0))(Data_Functor.map(functorCatList)(v)(d));
          };
          throw new Error("Failed pattern match at Data.CatList (line 185, column 1 - line 189, column 26): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var singleton = function (a) {
      return cons(a)(CatNil.value);
  }; 
  var semigroupCatList = new Data_Semigroup.Semigroup(append);
  var monoidCatList = new Data_Monoid.Monoid(function () {
      return semigroupCatList;
  }, CatNil.value);
  var monadCatList = new Control_Monad.Monad(function () {
      return applicativeCatList;
  }, function () {
      return bindCatList;
  });
  var bindCatList = new Control_Bind.Bind(function () {
      return applyCatList;
  }, Data_Function.flip(foldMap(monoidCatList)));
  var applyCatList = new Control_Apply.Apply(function () {
      return functorCatList;
  }, Control_Monad.ap(monadCatList));
  var applicativeCatList = new Control_Applicative.Applicative(function () {
      return applyCatList;
  }, singleton);
  var snoc = function (cat) {
      return function (a) {
          return append(cat)(new CatCons(a, Data_CatQueue.empty));
      };
  };
  exports["empty"] = empty;
  exports["snoc"] = snoc;
  exports["uncons"] = uncons;
  exports["semigroupCatList"] = semigroupCatList;
  exports["monoidCatList"] = monoidCatList;
  exports["foldableCatList"] = foldableCatList;
  exports["functorCatList"] = functorCatList;
  exports["applicativeCatList"] = applicativeCatList;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Free"] = $PS["Control.Monad.Free"] || {};
  var exports = $PS["Control.Monad.Free"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Control_Monad_Rec_Class = $PS["Control.Monad.Rec.Class"];
  var Data_CatList = $PS["Data.CatList"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Free = (function () {
      function Free(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Free.create = function (value0) {
          return function (value1) {
              return new Free(value0, value1);
          };
      };
      return Free;
  })();
  var Return = (function () {
      function Return(value0) {
          this.value0 = value0;
      };
      Return.create = function (value0) {
          return new Return(value0);
      };
      return Return;
  })();
  var Bind = (function () {
      function Bind(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Bind.create = function (value0) {
          return function (value1) {
              return new Bind(value0, value1);
          };
      };
      return Bind;
  })();
  var toView = function ($copy_v) {
      var $tco_done = false;
      var $tco_result;
      function $tco_loop(v) {
          var runExpF = function (v2) {
              return v2;
          };
          var concatF = function (v2) {
              return function (r) {
                  return new Free(v2.value0, Data_Semigroup.append(Data_CatList.semigroupCatList)(v2.value1)(r));
              };
          };
          if (v.value0 instanceof Return) {
              var v2 = Data_CatList.uncons(v.value1);
              if (v2 instanceof Data_Maybe.Nothing) {
                  $tco_done = true;
                  return new Return(v.value0.value0);
              };
              if (v2 instanceof Data_Maybe.Just) {
                  $copy_v = concatF(runExpF(v2.value0.value0)(v.value0.value0))(v2.value0.value1);
                  return;
              };
              throw new Error("Failed pattern match at Control.Monad.Free (line 227, column 7 - line 231, column 64): " + [ v2.constructor.name ]);
          };
          if (v.value0 instanceof Bind) {
              $tco_done = true;
              return new Bind(v.value0.value0, function (a) {
                  return concatF(v.value0.value1(a))(v.value1);
              });
          };
          throw new Error("Failed pattern match at Control.Monad.Free (line 225, column 3 - line 233, column 56): " + [ v.value0.constructor.name ]);
      };
      while (!$tco_done) {
          $tco_result = $tco_loop($copy_v);
      };
      return $tco_result;
  };
  var fromView = function (f) {
      return new Free(f, Data_CatList.empty);
  };
  var freeMonad = new Control_Monad.Monad(function () {
      return freeApplicative;
  }, function () {
      return freeBind;
  });
  var freeFunctor = new Data_Functor.Functor(function (k) {
      return function (f) {
          return Control_Bind.bindFlipped(freeBind)((function () {
              var $119 = Control_Applicative.pure(freeApplicative);
              return function ($120) {
                  return $119(k($120));
              };
          })())(f);
      };
  });
  var freeBind = new Control_Bind.Bind(function () {
      return freeApply;
  }, function (v) {
      return function (k) {
          return new Free(v.value0, Data_CatList.snoc(v.value1)(k));
      };
  });
  var freeApply = new Control_Apply.Apply(function () {
      return freeFunctor;
  }, Control_Monad.ap(freeMonad));
  var freeApplicative = new Control_Applicative.Applicative(function () {
      return freeApply;
  }, function ($121) {
      return fromView(Return.create($121));
  });
  var liftF = function (f) {
      return fromView(new Bind(f, (function () {
          var $122 = Control_Applicative.pure(freeApplicative);
          return function ($123) {
              return $122($123);
          };
      })()));
  };
  var substFree = function (k) {
      var go = function (f) {
          var v = toView(f);
          if (v instanceof Return) {
              return Control_Applicative.pure(freeApplicative)(v.value0);
          };
          if (v instanceof Bind) {
              return Control_Bind.bind(freeBind)(k(v.value0))(Data_Functor.map(Data_Functor.functorFn)(go)(v.value1));
          };
          throw new Error("Failed pattern match at Control.Monad.Free (line 168, column 10 - line 170, column 33): " + [ v.constructor.name ]);
      };
      return go;
  };
  var hoistFree = function (k) {
      return substFree(function ($124) {
          return liftF(k($124));
      });
  };
  var foldFree = function (dictMonadRec) {
      return function (k) {
          var go = function (f) {
              var v = toView(f);
              if (v instanceof Return) {
                  return Data_Functor.map((((dictMonadRec.Monad0()).Bind1()).Apply0()).Functor0())(Control_Monad_Rec_Class.Done.create)(Control_Applicative.pure((dictMonadRec.Monad0()).Applicative0())(v.value0));
              };
              if (v instanceof Bind) {
                  return Data_Functor.map((((dictMonadRec.Monad0()).Bind1()).Apply0()).Functor0())(function ($135) {
                      return Control_Monad_Rec_Class.Loop.create(v.value1($135));
                  })(k(v.value0));
              };
              throw new Error("Failed pattern match at Control.Monad.Free (line 158, column 10 - line 160, column 37): " + [ v.constructor.name ]);
          };
          return Control_Monad_Rec_Class.tailRecM(dictMonadRec)(go);
      };
  };
  exports["liftF"] = liftF;
  exports["hoistFree"] = hoistFree;
  exports["foldFree"] = foldFree;
  exports["freeBind"] = freeBind;
  exports["freeApplicative"] = freeApplicative;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Reader"] = $PS["Control.Monad.Reader"] || {};
  var exports = $PS["Control.Monad.Reader"];
  var Data_Newtype = $PS["Data.Newtype"];                 
  var runReader = function (v) {
      var $2 = Data_Newtype.unwrap();
      return function ($3) {
          return $2(v($3));
      };
  };
  exports["runReader"] = runReader;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Reader.Class"] = $PS["Control.Monad.Reader.Class"] || {};
  var exports = $PS["Control.Monad.Reader.Class"];       
  var MonadAsk = function (Monad0, ask) {
      this.Monad0 = Monad0;
      this.ask = ask;
  };
  var ask = function (dict) {
      return dict.ask;
  };
  exports["ask"] = ask;
  exports["MonadAsk"] = MonadAsk;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.Reader.Trans"] = $PS["Control.Monad.Reader.Trans"] || {};
  var exports = $PS["Control.Monad.Reader.Trans"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Control_Monad_Reader_Class = $PS["Control.Monad.Reader.Class"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];                
  var ReaderT = function (x) {
      return x;
  }; 
  var mapReaderT = function (f) {
      return function (v) {
          return function ($65) {
              return f(v($65));
          };
      };
  };
  var functorReaderT = function (dictFunctor) {
      return new Data_Functor.Functor((function () {
          var $66 = Data_Functor.map(dictFunctor);
          return function ($67) {
              return mapReaderT($66($67));
          };
      })());
  };
  var applyReaderT = function (dictApply) {
      return new Control_Apply.Apply(function () {
          return functorReaderT(dictApply.Functor0());
      }, function (v) {
          return function (v1) {
              return function (r) {
                  return Control_Apply.apply(dictApply)(v(r))(v1(r));
              };
          };
      });
  };
  var bindReaderT = function (dictBind) {
      return new Control_Bind.Bind(function () {
          return applyReaderT(dictBind.Apply0());
      }, function (v) {
          return function (k) {
              return function (r) {
                  return Control_Bind.bind(dictBind)(v(r))(function (a) {
                      var v1 = k(a);
                      return v1(r);
                  });
              };
          };
      });
  };
  var applicativeReaderT = function (dictApplicative) {
      return new Control_Applicative.Applicative(function () {
          return applyReaderT(dictApplicative.Apply0());
      }, (function () {
          var $71 = Control_Applicative.pure(dictApplicative);
          return function ($72) {
              return ReaderT(Data_Function["const"]($71($72)));
          };
      })());
  };
  var monadReaderT = function (dictMonad) {
      return new Control_Monad.Monad(function () {
          return applicativeReaderT(dictMonad.Applicative0());
      }, function () {
          return bindReaderT(dictMonad.Bind1());
      });
  };
  var monadAskReaderT = function (dictMonad) {
      return new Control_Monad_Reader_Class.MonadAsk(function () {
          return monadReaderT(dictMonad);
      }, Control_Applicative.pure(dictMonad.Applicative0()));
  };
  exports["functorReaderT"] = functorReaderT;
  exports["applicativeReaderT"] = applicativeReaderT;
  exports["bindReaderT"] = bindReaderT;
  exports["monadAskReaderT"] = monadAskReaderT;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.State"] = $PS["Control.Monad.State"] || {};
  var exports = $PS["Control.Monad.State"];
  var execState = function (v) {
      return function (s) {
          var v1 = v(s);
          return v1.value1;
      };
  };
  var evalState = function (v) {
      return function (s) {
          var v1 = v(s);
          return v1.value0;
      };
  };
  exports["evalState"] = evalState;
  exports["execState"] = execState;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Monad.State.Trans"] = $PS["Control.Monad.State.Trans"] || {};
  var exports = $PS["Control.Monad.State.Trans"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Lazy = $PS["Control.Lazy"];
  var Control_Monad = $PS["Control.Monad"];
  var Control_Monad_Rec_Class = $PS["Control.Monad.Rec.Class"];
  var Control_Monad_State_Class = $PS["Control.Monad.State.Class"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unit = $PS["Data.Unit"];                      
  var StateT = function (x) {
      return x;
  };
  var runStateT = function (v) {
      return v;
  };
  var lazyStateT = new Control_Lazy.Lazy(function (f) {
      return function (s) {
          var v = f(Data_Unit.unit);
          return v(s);
      };
  });
  var functorStateT = function (dictFunctor) {
      return new Data_Functor.Functor(function (f) {
          return function (v) {
              return function (s) {
                  return Data_Functor.map(dictFunctor)(function (v1) {
                      return new Data_Tuple.Tuple(f(v1.value0), v1.value1);
                  })(v(s));
              };
          };
      });
  };
  var evalStateT = function (dictFunctor) {
      return function (v) {
          return function (s) {
              return Data_Functor.map(dictFunctor)(Data_Tuple.fst)(v(s));
          };
      };
  };
  var monadStateT = function (dictMonad) {
      return new Control_Monad.Monad(function () {
          return applicativeStateT(dictMonad);
      }, function () {
          return bindStateT(dictMonad);
      });
  };
  var bindStateT = function (dictMonad) {
      return new Control_Bind.Bind(function () {
          return applyStateT(dictMonad);
      }, function (v) {
          return function (f) {
              return function (s) {
                  return Control_Bind.bind(dictMonad.Bind1())(v(s))(function (v1) {
                      var v3 = f(v1.value0);
                      return v3(v1.value1);
                  });
              };
          };
      });
  };
  var applyStateT = function (dictMonad) {
      return new Control_Apply.Apply(function () {
          return functorStateT(((dictMonad.Bind1()).Apply0()).Functor0());
      }, Control_Monad.ap(monadStateT(dictMonad)));
  };
  var applicativeStateT = function (dictMonad) {
      return new Control_Applicative.Applicative(function () {
          return applyStateT(dictMonad);
      }, function (a) {
          return function (s) {
              return Control_Applicative.pure(dictMonad.Applicative0())(new Data_Tuple.Tuple(a, s));
          };
      });
  };
  var monadRecStateT = function (dictMonadRec) {
      return new Control_Monad_Rec_Class.MonadRec(function () {
          return monadStateT(dictMonadRec.Monad0());
      }, function (f) {
          return function (a) {
              var f$prime = function (v) {
                  var v1 = f(v.value0);
                  return Control_Bind.bind((dictMonadRec.Monad0()).Bind1())(v1(v.value1))(function (v2) {
                      return Control_Applicative.pure((dictMonadRec.Monad0()).Applicative0())((function () {
                          if (v2.value0 instanceof Control_Monad_Rec_Class.Loop) {
                              return new Control_Monad_Rec_Class.Loop(new Data_Tuple.Tuple(v2.value0.value0, v2.value1));
                          };
                          if (v2.value0 instanceof Control_Monad_Rec_Class.Done) {
                              return new Control_Monad_Rec_Class.Done(new Data_Tuple.Tuple(v2.value0.value0, v2.value1));
                          };
                          throw new Error("Failed pattern match at Control.Monad.State.Trans (line 88, column 16 - line 90, column 40): " + [ v2.value0.constructor.name ]);
                      })());
                  });
              };
              return function (s) {
                  return Control_Monad_Rec_Class.tailRecM(dictMonadRec)(f$prime)(new Data_Tuple.Tuple(a, s));
              };
          };
      });
  };
  var monadStateStateT = function (dictMonad) {
      return new Control_Monad_State_Class.MonadState(function () {
          return monadStateT(dictMonad);
      }, function (f) {
          return StateT((function () {
              var $113 = Control_Applicative.pure(dictMonad.Applicative0());
              return function ($114) {
                  return $113(f($114));
              };
          })());
      });
  };
  exports["StateT"] = StateT;
  exports["runStateT"] = runStateT;
  exports["evalStateT"] = evalStateT;
  exports["functorStateT"] = functorStateT;
  exports["applicativeStateT"] = applicativeStateT;
  exports["bindStateT"] = bindStateT;
  exports["monadStateT"] = monadStateT;
  exports["monadRecStateT"] = monadRecStateT;
  exports["lazyStateT"] = lazyStateT;
  exports["monadStateStateT"] = monadStateStateT;
})(PS);
(function(exports) {
    

  exports.thenImpl = function(promise) {
    return function(errCB) {
      return function(succCB) {
        return function() {
          promise.then(succCB, errCB);
        };
      };
    };
  };
})(PS["Control.Promise"] = PS["Control.Promise"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Control.Promise"] = $PS["Control.Promise"] || {};
  var exports = $PS["Control.Promise"];
  var $foreign = $PS["Control.Promise"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Category = $PS["Control.Category"];
  var Control_Monad_Except = $PS["Control.Monad.Except"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Either = $PS["Data.Either"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Effect = $PS["Effect"];
  var Effect_Aff = $PS["Effect.Aff"];
  var Effect_Class = $PS["Effect.Class"];
  var Effect_Exception = $PS["Effect.Exception"];
  var Foreign = $PS["Foreign"];                
  var toAff$prime = function (customCoerce) {
      return function (p) {
          return Effect_Aff.makeAff(function (cb) {
              return Data_Functor.voidRight(Effect.functorEffect)(Data_Monoid.mempty(Effect_Aff.monoidCanceler))($foreign.thenImpl(p)(function ($1) {
                  return cb(Data_Either.Left.create(customCoerce($1)))();
              })(function ($2) {
                  return cb(Data_Either.Right.create($2))();
              }));
          });
      };
  };
  var coerce = function (fn) {
      return Data_Either.either(function (v) {
          return Effect_Exception.error("Promise failed, couldn't extract JS Error or String");
      })(Control_Category.identity(Control_Category.categoryFn))(Control_Monad_Except.runExcept(Control_Alt.alt(Control_Monad_Except_Trans.altExceptT(Data_List_Types.semigroupNonEmptyList)(Data_Identity.monadIdentity))(Foreign.unsafeReadTagged(Data_Identity.monadIdentity)("Error")(fn))(Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Effect_Exception.error)(Foreign.readString(Data_Identity.monadIdentity)(fn)))));
  };
  var toAff = toAff$prime(coerce);
  var toAffE = function (f) {
      return Control_Bind.bind(Effect_Aff.bindAff)(Effect_Class.liftEffect(Effect_Aff.monadEffectAff)(f))(toAff);
  };
  exports["toAffE"] = toAffE;
})(PS);
(function(exports) {
  'use strict';

  function args() { return arguments; }
  exports._args2 = args;                                        
  exports._apply = function apply(f, that, args) { return f.apply(that, args); };
})(PS["FFI.Simple.Functions"] = PS["FFI.Simple.Functions"] || {});
(function(exports) {
  'use strict';

  function typeOf(v) { return typeof v; }
  function instanceOf(obj, thing) { return obj instanceof thing; }
  function isIn(prop,obj) { return prop in obj; }
  function keys(obj) { return Object.keys(obj); };
  function hasOwnProperty(prop, obj) { return obj.hasOwnProperty(prop); }
  function getProperty(prop, obj) { return obj[prop]; }
  function setProperty(prop, obj, value) {
    obj[prop] = value;
    return obj;
  }
  function defineProperty(prop, obj, value) {
    Object.defineProperty(obj, prop, {value: value, writable: false});
    return obj;
  }
  function removeProperty(prop, obj) { delete obj[prop]; return obj; }
  exports._keys = keys;                    
  exports._getProperty = getProperty;
  exports._setProperty = setProperty;
  exports._defineProperty = defineProperty;
  exports._removeProperty = removeProperty;
})(PS["FFI.Simple.Objects"] = PS["FFI.Simple.Objects"] || {});
(function(exports) {
  'use strict';                                                                     
  exports._nullUndef = function nullUndef(v) { return (typeof v === 'undefined') ? null : v; };
})(PS["FFI.Simple.Undef"] = PS["FFI.Simple.Undef"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["FFI.Simple.Undef"] = $PS["FFI.Simple.Undef"] || {};
  var exports = $PS["FFI.Simple.Undef"];
  var $foreign = $PS["FFI.Simple.Undef"];
  var Data_Nullable = $PS["Data.Nullable"];
  var nullUndef = $foreign["_nullUndef"];
  var maybeUndef = function ($1) {
      return Data_Nullable.toMaybe(nullUndef($1));
  };
  exports["maybeUndef"] = maybeUndef;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["FFI.Simple.Objects"] = $PS["FFI.Simple.Objects"] || {};
  var exports = $PS["FFI.Simple.Objects"];
  var $foreign = $PS["FFI.Simple.Objects"];
  var Data_Function = $PS["Data.Function"];
  var Data_Function_Uncurried = $PS["Data.Function.Uncurried"];
  var FFI_Simple_Undef = $PS["FFI.Simple.Undef"];
  var setProperty = Data_Function_Uncurried.runFn3($foreign["_setProperty"]);
  var setProperty$prime = Data_Function.flip(setProperty);
  var removeProperty = Data_Function_Uncurried.runFn2($foreign["_removeProperty"]);
  var removeProperty$prime = Data_Function.flip(removeProperty);
  var keys = $foreign["_keys"];                                                    
  var getProperty = Data_Function_Uncurried.runFn2($foreign["_getProperty"]);
  var getProperty$prime = Data_Function.flip(getProperty);
  var maybeGetProperty = function (p) {
      var $1 = getProperty(p);
      return function ($2) {
          return FFI_Simple_Undef.maybeUndef($1($2));
      };
  };
  var maybeGetProperty$prime = Data_Function.flip(maybeGetProperty);
  var defineProperty = Data_Function_Uncurried.runFn3($foreign["_defineProperty"]);
  exports["keys"] = keys;
  exports["getProperty"] = getProperty;
  exports["getProperty'"] = getProperty$prime;
  exports["maybeGetProperty'"] = maybeGetProperty$prime;
  exports["setProperty'"] = setProperty$prime;
  exports["defineProperty"] = defineProperty;
  exports["removeProperty'"] = removeProperty$prime;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["FFI.Simple.Functions"] = $PS["FFI.Simple.Functions"] || {};
  var exports = $PS["FFI.Simple.Functions"];
  var $foreign = $PS["FFI.Simple.Functions"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_Function = $PS["Data.Function"];
  var Data_Function_Uncurried = $PS["Data.Function.Uncurried"];
  var FFI_Simple_Objects = $PS["FFI.Simple.Objects"];                
  var Delay = function (Monad0, delay) {
      this.Monad0 = Monad0;
      this.delay = delay;
  };                                                           
  var delayMonad = function (dictMonad) {
      return new Delay(function () {
          return dictMonad;
      }, (function () {
          var $1 = Control_Bind.bind(dictMonad.Bind1());
          var $2 = Control_Applicative.pure(dictMonad.Applicative0());
          return function ($3) {
              return $1($2($3));
          };
      })());
  };
  var delay = function (dict) {
      return dict.delay;
  };                                                             
  var args2 = Data_Function_Uncurried.runFn2($foreign["_args2"]);
  var applyTo = Data_Function_Uncurried.runFn3($foreign["_apply"]);
  var applyMethod = function (n) {
      return function (o) {
          return applyTo(FFI_Simple_Objects.getProperty(n)(o))(o);
      };
  };
  var applyMethod$prime = Data_Function.flip(applyMethod);
  exports["delay"] = delay;
  exports["applyMethod'"] = applyMethod$prime;
  exports["args2"] = args2;
  exports["delayMonad"] = delayMonad;
})(PS);
(function(exports) {
  'use strict';

  const glob
    =  (typeof globalThis !== 'undefined' && globalThis)
    || (typeof window !== 'undefined' && window)
    || (typeof global !== 'undefined' && global)
    || false;

  exports._global
    = glob
    ? (function(name) { return glob[name]; })
    : (function() {
         console.warn("FFI.Simple.Globals.global: none of globalThis, window, global are defined, falling back to silently returning undef");
         return function() {};
    })();
})(PS["FFI.Simple.Globals"] = PS["FFI.Simple.Globals"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["FFI.Simple.Globals"] = $PS["FFI.Simple.Globals"] || {};
  var exports = $PS["FFI.Simple.Globals"];
  var $foreign = $PS["FFI.Simple.Globals"];                      
  var unsafeGlobal = $foreign["_global"];
  exports["unsafeGlobal"] = unsafeGlobal;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.Console"] = $PS["DOM.Simple.Console"] || {};
  var exports = $PS["DOM.Simple.Console"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var FFI_Simple_Globals = $PS["FFI.Simple.Globals"];                
  var console = FFI_Simple_Globals.unsafeGlobal("console");
  var log = function (a) {
      return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v) {
          return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](console)("log")([ a ]));
      });
  };
  var log2 = function (a) {
      return function (b) {
          return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v) {
              return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](console)("log")(FFI_Simple_Functions.args2(a)(b)));
          });
      };
  };
  exports["log"] = log;
  exports["log2"] = log2;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.Document"] = $PS["DOM.Simple.Document"] || {};
  var exports = $PS["DOM.Simple.Document"];
  var FFI_Simple_Globals = $PS["FFI.Simple.Globals"];                
  var document = FFI_Simple_Globals.unsafeGlobal("document");
  exports["document"] = document;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.Element"] = $PS["DOM.Simple.Element"] || {};
  var exports = $PS["DOM.Simple.Element"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var boundingRect = function (dictIsElement) {
      return function (e) {
          return FFI_Simple_Functions["applyMethod'"](e)("getBoundingClientRect")([  ]);
      };
  };
  exports["boundingRect"] = boundingRect;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.Event"] = $PS["DOM.Simple.Event"] || {};
  var exports = $PS["DOM.Simple.Event"];
  var FFI_Simple_Objects = $PS["FFI.Simple.Objects"];                  
  var key = function (e) {
      return FFI_Simple_Objects["getProperty'"](e)("key");
  };                                                                     
  var clientY = function (e) {
      return FFI_Simple_Objects["getProperty'"](e)("clientY");
  };
  var clientX = function (e) {
      return FFI_Simple_Objects["getProperty'"](e)("clientX");
  };
  exports["key"] = key;
  exports["clientX"] = clientX;
  exports["clientY"] = clientY;
})(PS);
(function(exports) {
  "use strict";

  exports.mkEffectFn1 = function mkEffectFn1(fn) {
    return function(x) {
      return fn(x)();
    };
  };

  exports.runEffectFn1 = function runEffectFn1(fn) {
    return function(a) {
      return function() {
        return fn(a);
      };
    };
  };

  exports.runEffectFn2 = function runEffectFn2(fn) {
    return function(a) {
      return function(b) {
        return function() {
          return fn(a, b);
        };
      };
    };
  };

  exports.runEffectFn3 = function runEffectFn3(fn) {
    return function(a) {
      return function(b) {
        return function(c) {
          return function() {
            return fn(a, b, c);
          };
        };
      };
    };
  };

  exports.runEffectFn4 = function runEffectFn4(fn) {
    return function(a) {
      return function(b) {
        return function(c) {
          return function(d) {
            return function() {
              return fn(a, b, c, d);
            };
          };
        };
      };
    };
  };
})(PS["Effect.Uncurried"] = PS["Effect.Uncurried"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Uncurried"] = $PS["Effect.Uncurried"] || {};
  var exports = $PS["Effect.Uncurried"];
  var $foreign = $PS["Effect.Uncurried"];
  exports["mkEffectFn1"] = $foreign.mkEffectFn1;
  exports["runEffectFn1"] = $foreign.runEffectFn1;
  exports["runEffectFn2"] = $foreign.runEffectFn2;
  exports["runEffectFn3"] = $foreign.runEffectFn3;
  exports["runEffectFn4"] = $foreign.runEffectFn4;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.EventListener"] = $PS["DOM.Simple.EventListener"] || {};
  var exports = $PS["DOM.Simple.EventListener"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var Effect_Uncurried = $PS["Effect.Uncurried"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];                
  var Callback = function (x) {
      return x;
  };
  var removeEventListener = function (dictIsEventListener) {
      return function (dictIsEvent) {
          return function (obj) {
              return function (name) {
                  return function (cb) {
                      return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v) {
                          return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](obj)("removeEventListener")(FFI_Simple_Functions.args2(name)(cb)));
                      });
                  };
              };
          };
      };
  };
  var callback = function ($7) {
      return Callback(Effect_Uncurried.mkEffectFn1($7));
  };
  var addEventListener = function (dictIsEventListener) {
      return function (dictIsEvent) {
          return function (obj) {
              return function (name) {
                  return function (cb) {
                      return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v) {
                          return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](obj)("addEventListener")(FFI_Simple_Functions.args2(name)(cb)));
                      });
                  };
              };
          };
      };
  };
  exports["callback"] = callback;
  exports["addEventListener"] = addEventListener;
  exports["removeEventListener"] = removeEventListener;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["DOM.Simple.Window"] = $PS["DOM.Simple.Window"] || {};
  var exports = $PS["DOM.Simple.Window"];
  var FFI_Simple_Globals = $PS["FFI.Simple.Globals"];                
  var window = FFI_Simple_Globals.unsafeGlobal("window");
  exports["window"] = window;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Array.NonEmpty.Internal"] = $PS["Data.Array.NonEmpty.Internal"] || {};
  var exports = $PS["Data.Array.NonEmpty.Internal"];             
  var NonEmptyArray = function (x) {
      return x;
  };
  exports["NonEmptyArray"] = NonEmptyArray;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Array.NonEmpty"] = $PS["Data.Array.NonEmpty"] || {};
  var exports = $PS["Data.Array.NonEmpty"];
  var Data_Array = $PS["Data.Array"];
  var Data_Array_NonEmpty_Internal = $PS["Data.Array.NonEmpty.Internal"];
  var unsafeFromArray = Data_Array_NonEmpty_Internal.NonEmptyArray;
  var toArray = function (v) {
      return v;
  };
  var cons$prime = function (x) {
      return function (xs) {
          return unsafeFromArray(Data_Array.cons(x)(xs));
      };
  };
  var fromNonEmpty = function (v) {
      return cons$prime(v.value0)(v.value1);
  };                                         
  var adaptAny = function (f) {
      return function ($78) {
          return f(toArray($78));
      };
  };
  var filter = function (f) {
      return adaptAny(Data_Array.filter(f));
  };
  var unsafeAdapt = function (f) {
      var $79 = adaptAny(f);
      return function ($80) {
          return unsafeFromArray($79($80));
      };
  };
  var cons = function (x) {
      return unsafeAdapt(Data_Array.cons(x));
  };
  exports["fromNonEmpty"] = fromNonEmpty;
  exports["filter"] = filter;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Array.Partial"] = $PS["Data.Array.Partial"] || {};
  var exports = $PS["Data.Array.Partial"];
  var Data_Array = $PS["Data.Array"];                
  var tail = function (dictPartial) {
      return function (xs) {
          return Data_Array.slice(1)(Data_Array.length(xs))(xs);
      };
  };
  var last = function (dictPartial) {
      return function (xs) {
          return xs[Data_Array.length(xs) - 1 | 0];
      };
  };
  var init = function (dictPartial) {
      return function (xs) {
          return Data_Array.slice(0)(Data_Array.length(xs) - 1 | 0)(xs);
      };
  };
  var head = function (dictPartial) {
      return function (xs) {
          return xs[0];
      };
  };
  exports["head"] = head;
  exports["tail"] = tail;
  exports["last"] = last;
  exports["init"] = init;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Bifunctor"] = $PS["Data.Bifunctor"] || {};
  var exports = $PS["Data.Bifunctor"];
  var Control_Category = $PS["Control.Category"];
  var Data_Either = $PS["Data.Either"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var Bifunctor = function (bimap) {
      this.bimap = bimap;
  };
  var bimap = function (dict) {
      return dict.bimap;
  };
  var lmap = function (dictBifunctor) {
      return function (f) {
          return bimap(dictBifunctor)(f)(Control_Category.identity(Control_Category.categoryFn));
      };
  };
  var bifunctorTuple = new Bifunctor(function (f) {
      return function (g) {
          return function (v) {
              return new Data_Tuple.Tuple(f(v.value0), g(v.value1));
          };
      };
  });
  var bifunctorEither = new Bifunctor(function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Data_Either.Left) {
                  return new Data_Either.Left(v(v2.value0));
              };
              if (v2 instanceof Data_Either.Right) {
                  return new Data_Either.Right(v1(v2.value0));
              };
              throw new Error("Failed pattern match at Data.Bifunctor (line 32, column 1 - line 34, column 36): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  });
  exports["lmap"] = lmap;
  exports["bifunctorEither"] = bifunctorEither;
  exports["bifunctorTuple"] = bifunctorTuple;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Char"] = $PS["Data.Char"] || {};
  var exports = $PS["Data.Char"];
  var Data_Enum = $PS["Data.Enum"];                
  var toCharCode = Data_Enum.fromEnum(Data_Enum.boundedEnumChar);
  exports["toCharCode"] = toCharCode;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.CodePoint.Unicode.Internal"] = $PS["Data.CodePoint.Unicode.Internal"] || {};
  var exports = $PS["Data.CodePoint.Unicode.Internal"];
  var Data_Array = $PS["Data.Array"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Int = $PS["Data.Int"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ordering = $PS["Data.Ordering"];        
  var NUMCAT_LU = (function () {
      function NUMCAT_LU() {

      };
      NUMCAT_LU.value = new NUMCAT_LU();
      return NUMCAT_LU;
  })();
  var NUMCAT_LL = (function () {
      function NUMCAT_LL() {

      };
      NUMCAT_LL.value = new NUMCAT_LL();
      return NUMCAT_LL;
  })();
  var NUMCAT_LT = (function () {
      function NUMCAT_LT() {

      };
      NUMCAT_LT.value = new NUMCAT_LT();
      return NUMCAT_LT;
  })();
  var NUMCAT_LM = (function () {
      function NUMCAT_LM() {

      };
      NUMCAT_LM.value = new NUMCAT_LM();
      return NUMCAT_LM;
  })();
  var NUMCAT_LO = (function () {
      function NUMCAT_LO() {

      };
      NUMCAT_LO.value = new NUMCAT_LO();
      return NUMCAT_LO;
  })();
  var NUMCAT_MN = (function () {
      function NUMCAT_MN() {

      };
      NUMCAT_MN.value = new NUMCAT_MN();
      return NUMCAT_MN;
  })();
  var NUMCAT_MC = (function () {
      function NUMCAT_MC() {

      };
      NUMCAT_MC.value = new NUMCAT_MC();
      return NUMCAT_MC;
  })();
  var NUMCAT_ME = (function () {
      function NUMCAT_ME() {

      };
      NUMCAT_ME.value = new NUMCAT_ME();
      return NUMCAT_ME;
  })();
  var NUMCAT_ND = (function () {
      function NUMCAT_ND() {

      };
      NUMCAT_ND.value = new NUMCAT_ND();
      return NUMCAT_ND;
  })();
  var NUMCAT_NL = (function () {
      function NUMCAT_NL() {

      };
      NUMCAT_NL.value = new NUMCAT_NL();
      return NUMCAT_NL;
  })();
  var NUMCAT_NO = (function () {
      function NUMCAT_NO() {

      };
      NUMCAT_NO.value = new NUMCAT_NO();
      return NUMCAT_NO;
  })();
  var NUMCAT_PC = (function () {
      function NUMCAT_PC() {

      };
      NUMCAT_PC.value = new NUMCAT_PC();
      return NUMCAT_PC;
  })();
  var NUMCAT_PD = (function () {
      function NUMCAT_PD() {

      };
      NUMCAT_PD.value = new NUMCAT_PD();
      return NUMCAT_PD;
  })();
  var NUMCAT_PS = (function () {
      function NUMCAT_PS() {

      };
      NUMCAT_PS.value = new NUMCAT_PS();
      return NUMCAT_PS;
  })();
  var NUMCAT_PE = (function () {
      function NUMCAT_PE() {

      };
      NUMCAT_PE.value = new NUMCAT_PE();
      return NUMCAT_PE;
  })();
  var NUMCAT_PI = (function () {
      function NUMCAT_PI() {

      };
      NUMCAT_PI.value = new NUMCAT_PI();
      return NUMCAT_PI;
  })();
  var NUMCAT_PF = (function () {
      function NUMCAT_PF() {

      };
      NUMCAT_PF.value = new NUMCAT_PF();
      return NUMCAT_PF;
  })();
  var NUMCAT_PO = (function () {
      function NUMCAT_PO() {

      };
      NUMCAT_PO.value = new NUMCAT_PO();
      return NUMCAT_PO;
  })();
  var NUMCAT_SM = (function () {
      function NUMCAT_SM() {

      };
      NUMCAT_SM.value = new NUMCAT_SM();
      return NUMCAT_SM;
  })();
  var NUMCAT_SC = (function () {
      function NUMCAT_SC() {

      };
      NUMCAT_SC.value = new NUMCAT_SC();
      return NUMCAT_SC;
  })();
  var NUMCAT_SK = (function () {
      function NUMCAT_SK() {

      };
      NUMCAT_SK.value = new NUMCAT_SK();
      return NUMCAT_SK;
  })();
  var NUMCAT_SO = (function () {
      function NUMCAT_SO() {

      };
      NUMCAT_SO.value = new NUMCAT_SO();
      return NUMCAT_SO;
  })();
  var NUMCAT_ZS = (function () {
      function NUMCAT_ZS() {

      };
      NUMCAT_ZS.value = new NUMCAT_ZS();
      return NUMCAT_ZS;
  })();
  var NUMCAT_ZL = (function () {
      function NUMCAT_ZL() {

      };
      NUMCAT_ZL.value = new NUMCAT_ZL();
      return NUMCAT_ZL;
  })();
  var NUMCAT_ZP = (function () {
      function NUMCAT_ZP() {

      };
      NUMCAT_ZP.value = new NUMCAT_ZP();
      return NUMCAT_ZP;
  })();
  var NUMCAT_CC = (function () {
      function NUMCAT_CC() {

      };
      NUMCAT_CC.value = new NUMCAT_CC();
      return NUMCAT_CC;
  })();
  var NUMCAT_CF = (function () {
      function NUMCAT_CF() {

      };
      NUMCAT_CF.value = new NUMCAT_CF();
      return NUMCAT_CF;
  })();
  var NUMCAT_CS = (function () {
      function NUMCAT_CS() {

      };
      NUMCAT_CS.value = new NUMCAT_CS();
      return NUMCAT_CS;
  })();
  var NUMCAT_CO = (function () {
      function NUMCAT_CO() {

      };
      NUMCAT_CO.value = new NUMCAT_CO();
      return NUMCAT_CO;
  })();
  var NUMCAT_CN = (function () {
      function NUMCAT_CN() {

      };
      NUMCAT_CN.value = new NUMCAT_CN();
      return NUMCAT_CN;
  })();              
  var numLat1Blocks = 63;  
  var numBlocks = 3396;    
  var gencatZS = 2;
  var rule1 = {
      category: gencatZS,
      unicodeCat: NUMCAT_ZS.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };  
  var gencatZP = 67108864;
  var rule162 = {
      category: gencatZP,
      unicodeCat: NUMCAT_ZP.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatZL = 33554432;
  var rule161 = {
      category: gencatZL,
      unicodeCat: NUMCAT_ZL.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatSO = 8192;
  var rule13 = {
      category: gencatSO,
      unicodeCat: NUMCAT_SO.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule170 = {
      category: gencatSO,
      unicodeCat: NUMCAT_SO.value,
      possible: 1,
      updist: 0,
      lowdist: 26,
      titledist: 0
  };
  var rule171 = {
      category: gencatSO,
      unicodeCat: NUMCAT_SO.value,
      possible: 1,
      updist: -26 | 0,
      lowdist: 0,
      titledist: -26 | 0
  };
  var gencatSM = 64;
  var rule6 = {
      category: gencatSM,
      unicodeCat: NUMCAT_SM.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatSK = 1024;
  var rule10 = {
      category: gencatSK,
      unicodeCat: NUMCAT_SK.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatSC = 8;
  var rule3 = {
      category: gencatSC,
      unicodeCat: NUMCAT_SC.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPS = 16;
  var rule4 = {
      category: gencatPS,
      unicodeCat: NUMCAT_PS.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPO = 4;
  var rule2 = {
      category: gencatPO,
      unicodeCat: NUMCAT_PO.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPI = 32768;
  var rule15 = {
      category: gencatPI,
      unicodeCat: NUMCAT_PI.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPF = 262144;
  var rule19 = {
      category: gencatPF,
      unicodeCat: NUMCAT_PF.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPE = 32;
  var rule5 = {
      category: gencatPE,
      unicodeCat: NUMCAT_PE.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPD = 128;
  var rule7 = {
      category: gencatPD,
      unicodeCat: NUMCAT_PD.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatPC = 2048;
  var rule11 = {
      category: gencatPC,
      unicodeCat: NUMCAT_PC.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatNO = 131072;
  var rule17 = {
      category: gencatNO,
      unicodeCat: NUMCAT_NO.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatNL = 16777216;
  var rule128 = {
      category: gencatNL,
      unicodeCat: NUMCAT_NL.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule168 = {
      category: gencatNL,
      unicodeCat: NUMCAT_NL.value,
      possible: 1,
      updist: 0,
      lowdist: 16,
      titledist: 0
  };
  var rule169 = {
      category: gencatNL,
      unicodeCat: NUMCAT_NL.value,
      possible: 1,
      updist: -16 | 0,
      lowdist: 0,
      titledist: -16 | 0
  };
  var gencatND = 256;
  var rule8 = {
      category: gencatND,
      unicodeCat: NUMCAT_ND.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatMN = 2097152;
  var rule92 = {
      category: gencatMN,
      unicodeCat: NUMCAT_MN.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule93 = {
      category: gencatMN,
      unicodeCat: NUMCAT_MN.value,
      possible: 1,
      updist: 84,
      lowdist: 0,
      titledist: 84
  };
  var gencatME = 4194304;
  var rule119 = {
      category: gencatME,
      unicodeCat: NUMCAT_ME.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatMC = 8388608;
  var rule124 = {
      category: gencatMC,
      unicodeCat: NUMCAT_MC.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatLU = 512;
  var nullrule = {
      category: gencatLU,
      unicodeCat: NUMCAT_CN.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule104 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 8,
      titledist: 0
  };
  var rule107 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule115 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -60 | 0,
      titledist: 0
  };
  var rule117 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -7 | 0,
      titledist: 0
  };
  var rule118 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 80,
      titledist: 0
  };
  var rule120 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 15,
      titledist: 0
  };
  var rule122 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 48,
      titledist: 0
  };
  var rule125 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 7264,
      titledist: 0
  };
  var rule127 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 38864,
      titledist: 0
  };
  var rule137 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -3008 | 0,
      titledist: 0
  };
  var rule142 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -7615 | 0,
      titledist: 0
  };
  var rule144 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -8 | 0,
      titledist: 0
  };
  var rule153 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -74 | 0,
      titledist: 0
  };
  var rule156 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -86 | 0,
      titledist: 0
  };
  var rule157 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -100 | 0,
      titledist: 0
  };
  var rule158 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -112 | 0,
      titledist: 0
  };
  var rule159 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -128 | 0,
      titledist: 0
  };
  var rule160 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -126 | 0,
      titledist: 0
  };
  var rule163 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -7517 | 0,
      titledist: 0
  };
  var rule164 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -8383 | 0,
      titledist: 0
  };
  var rule165 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -8262 | 0,
      titledist: 0
  };
  var rule166 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 28,
      titledist: 0
  };
  var rule172 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10743 | 0,
      titledist: 0
  };
  var rule173 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -3814 | 0,
      titledist: 0
  };
  var rule174 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10727 | 0,
      titledist: 0
  };
  var rule177 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10780 | 0,
      titledist: 0
  };
  var rule178 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10749 | 0,
      titledist: 0
  };
  var rule179 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10783 | 0,
      titledist: 0
  };
  var rule180 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10782 | 0,
      titledist: 0
  };
  var rule181 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -10815 | 0,
      titledist: 0
  };
  var rule183 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -35332 | 0,
      titledist: 0
  };
  var rule184 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42280 | 0,
      titledist: 0
  };
  var rule186 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42308 | 0,
      titledist: 0
  };
  var rule187 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42319 | 0,
      titledist: 0
  };
  var rule188 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42315 | 0,
      titledist: 0
  };
  var rule189 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42305 | 0,
      titledist: 0
  };
  var rule190 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42258 | 0,
      titledist: 0
  };
  var rule191 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42282 | 0,
      titledist: 0
  };
  var rule192 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42261 | 0,
      titledist: 0
  };
  var rule193 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 928,
      titledist: 0
  };
  var rule194 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -48 | 0,
      titledist: 0
  };
  var rule195 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -42307 | 0,
      titledist: 0
  };
  var rule196 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -35384 | 0,
      titledist: 0
  };
  var rule201 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 40,
      titledist: 0
  };
  var rule203 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 34,
      titledist: 0
  };
  var rule22 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 1,
      titledist: 0
  };
  var rule24 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -199 | 0,
      titledist: 0
  };
  var rule26 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -121 | 0,
      titledist: 0
  };
  var rule29 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 210,
      titledist: 0
  };
  var rule30 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 206,
      titledist: 0
  };
  var rule31 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 205,
      titledist: 0
  };
  var rule32 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 79,
      titledist: 0
  };
  var rule33 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 202,
      titledist: 0
  };
  var rule34 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 203,
      titledist: 0
  };
  var rule35 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 207,
      titledist: 0
  };
  var rule37 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 211,
      titledist: 0
  };
  var rule38 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 209,
      titledist: 0
  };
  var rule40 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 213,
      titledist: 0
  };
  var rule42 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 214,
      titledist: 0
  };
  var rule43 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 218,
      titledist: 0
  };
  var rule44 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 217,
      titledist: 0
  };
  var rule45 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 219,
      titledist: 0
  };
  var rule47 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 2,
      titledist: 1
  };
  var rule51 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -97 | 0,
      titledist: 0
  };
  var rule52 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -56 | 0,
      titledist: 0
  };
  var rule53 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -130 | 0,
      titledist: 0
  };
  var rule54 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 10795,
      titledist: 0
  };
  var rule55 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -163 | 0,
      titledist: 0
  };
  var rule56 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 10792,
      titledist: 0
  };
  var rule58 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: -195 | 0,
      titledist: 0
  };
  var rule59 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 69,
      titledist: 0
  };
  var rule60 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 71,
      titledist: 0
  };
  var rule9 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 32,
      titledist: 0
  };
  var rule94 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 116,
      titledist: 0
  };
  var rule95 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 38,
      titledist: 0
  };
  var rule96 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 37,
      titledist: 0
  };
  var rule97 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 64,
      titledist: 0
  };
  var rule98 = {
      category: gencatLU,
      unicodeCat: NUMCAT_LU.value,
      possible: 1,
      updist: 0,
      lowdist: 63,
      titledist: 0
  };
  var gencatLT = 524288;
  var rule151 = {
      category: gencatLT,
      unicodeCat: NUMCAT_LT.value,
      possible: 1,
      updist: 0,
      lowdist: -8 | 0,
      titledist: 0
  };
  var rule154 = {
      category: gencatLT,
      unicodeCat: NUMCAT_LT.value,
      possible: 1,
      updist: 0,
      lowdist: -9 | 0,
      titledist: 0
  };
  var rule48 = {
      category: gencatLT,
      unicodeCat: NUMCAT_LT.value,
      possible: 1,
      updist: -1 | 0,
      lowdist: 1,
      titledist: 0
  };
  var gencatLO = 16384;
  var rule14 = {
      category: gencatLO,
      unicodeCat: NUMCAT_LO.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatLM = 1048576;
  var rule91 = {
      category: gencatLM,
      unicodeCat: NUMCAT_LM.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatLL = 4096;
  var rule100 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -37 | 0,
      lowdist: 0,
      titledist: -37 | 0
  };
  var rule101 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -31 | 0,
      lowdist: 0,
      titledist: -31 | 0
  };
  var rule102 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -64 | 0,
      lowdist: 0,
      titledist: -64 | 0
  };
  var rule103 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -63 | 0,
      lowdist: 0,
      titledist: -63 | 0
  };
  var rule105 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -62 | 0,
      lowdist: 0,
      titledist: -62 | 0
  };
  var rule106 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -57 | 0,
      lowdist: 0,
      titledist: -57 | 0
  };
  var rule108 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -47 | 0,
      lowdist: 0,
      titledist: -47 | 0
  };
  var rule109 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -54 | 0,
      lowdist: 0,
      titledist: -54 | 0
  };
  var rule110 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -8 | 0,
      lowdist: 0,
      titledist: -8 | 0
  };
  var rule111 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -86 | 0,
      lowdist: 0,
      titledist: -86 | 0
  };
  var rule112 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -80 | 0,
      lowdist: 0,
      titledist: -80 | 0
  };
  var rule113 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 7,
      lowdist: 0,
      titledist: 7
  };
  var rule114 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -116 | 0,
      lowdist: 0,
      titledist: -116 | 0
  };
  var rule116 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -96 | 0,
      lowdist: 0,
      titledist: -96 | 0
  };
  var rule12 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -32 | 0,
      lowdist: 0,
      titledist: -32 | 0
  };
  var rule121 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -15 | 0,
      lowdist: 0,
      titledist: -15 | 0
  };
  var rule123 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -48 | 0,
      lowdist: 0,
      titledist: -48 | 0
  };
  var rule126 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 3008,
      lowdist: 0,
      titledist: 0
  };
  var rule129 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6254 | 0,
      lowdist: 0,
      titledist: -6254 | 0
  };
  var rule130 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6253 | 0,
      lowdist: 0,
      titledist: -6253 | 0
  };
  var rule131 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6244 | 0,
      lowdist: 0,
      titledist: -6244 | 0
  };
  var rule132 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6242 | 0,
      lowdist: 0,
      titledist: -6242 | 0
  };
  var rule133 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6243 | 0,
      lowdist: 0,
      titledist: -6243 | 0
  };
  var rule134 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6236 | 0,
      lowdist: 0,
      titledist: -6236 | 0
  };
  var rule135 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -6181 | 0,
      lowdist: 0,
      titledist: -6181 | 0
  };
  var rule136 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 35266,
      lowdist: 0,
      titledist: 35266
  };
  var rule138 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 35332,
      lowdist: 0,
      titledist: 35332
  };
  var rule139 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 3814,
      lowdist: 0,
      titledist: 3814
  };
  var rule140 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 35384,
      lowdist: 0,
      titledist: 35384
  };
  var rule141 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -59 | 0,
      lowdist: 0,
      titledist: -59 | 0
  };
  var rule143 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 8,
      lowdist: 0,
      titledist: 8
  };
  var rule145 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 74,
      lowdist: 0,
      titledist: 74
  };
  var rule146 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 86,
      lowdist: 0,
      titledist: 86
  };
  var rule147 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 100,
      lowdist: 0,
      titledist: 100
  };
  var rule148 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 128,
      lowdist: 0,
      titledist: 128
  };
  var rule149 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 112,
      lowdist: 0,
      titledist: 112
  };
  var rule150 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 126,
      lowdist: 0,
      titledist: 126
  };
  var rule152 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 9,
      lowdist: 0,
      titledist: 9
  };
  var rule155 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -7205 | 0,
      lowdist: 0,
      titledist: -7205 | 0
  };
  var rule167 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -28 | 0,
      lowdist: 0,
      titledist: -28 | 0
  };
  var rule175 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -10795 | 0,
      lowdist: 0,
      titledist: -10795 | 0
  };
  var rule176 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -10792 | 0,
      lowdist: 0,
      titledist: -10792 | 0
  };
  var rule18 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 743,
      lowdist: 0,
      titledist: 743
  };
  var rule182 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -7264 | 0,
      lowdist: 0,
      titledist: -7264 | 0
  };
  var rule185 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 48,
      lowdist: 0,
      titledist: 48
  };
  var rule197 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -928 | 0,
      lowdist: 0,
      titledist: -928 | 0
  };
  var rule198 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -38864 | 0,
      lowdist: 0,
      titledist: -38864 | 0
  };
  var rule20 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var rule202 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -40 | 0,
      lowdist: 0,
      titledist: -40 | 0
  };
  var rule204 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -34 | 0,
      lowdist: 0,
      titledist: -34 | 0
  };
  var rule21 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 121,
      lowdist: 0,
      titledist: 121
  };
  var rule23 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -1 | 0,
      lowdist: 0,
      titledist: -1 | 0
  };
  var rule25 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -232 | 0,
      lowdist: 0,
      titledist: -232 | 0
  };
  var rule27 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -300 | 0,
      lowdist: 0,
      titledist: -300 | 0
  };
  var rule28 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 195,
      lowdist: 0,
      titledist: 195
  };
  var rule36 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 97,
      lowdist: 0,
      titledist: 97
  };
  var rule39 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 163,
      lowdist: 0,
      titledist: 163
  };
  var rule41 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 130,
      lowdist: 0,
      titledist: 130
  };
  var rule46 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 56,
      lowdist: 0,
      titledist: 56
  };
  var rule49 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -2 | 0,
      lowdist: 0,
      titledist: -1 | 0
  };
  var rule50 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -79 | 0,
      lowdist: 0,
      titledist: -79 | 0
  };
  var rule57 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10815,
      lowdist: 0,
      titledist: 10815
  };
  var rule61 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10783,
      lowdist: 0,
      titledist: 10783
  };
  var rule62 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10780,
      lowdist: 0,
      titledist: 10780
  };
  var rule63 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10782,
      lowdist: 0,
      titledist: 10782
  };
  var rule64 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -210 | 0,
      lowdist: 0,
      titledist: -210 | 0
  };
  var rule65 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -206 | 0,
      lowdist: 0,
      titledist: -206 | 0
  };
  var rule66 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -205 | 0,
      lowdist: 0,
      titledist: -205 | 0
  };
  var rule67 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -202 | 0,
      lowdist: 0,
      titledist: -202 | 0
  };
  var rule68 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -203 | 0,
      lowdist: 0,
      titledist: -203 | 0
  };
  var rule69 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42319,
      lowdist: 0,
      titledist: 42319
  };
  var rule70 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42315,
      lowdist: 0,
      titledist: 42315
  };
  var rule71 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -207 | 0,
      lowdist: 0,
      titledist: -207 | 0
  };
  var rule72 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42280,
      lowdist: 0,
      titledist: 42280
  };
  var rule73 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42308,
      lowdist: 0,
      titledist: 42308
  };
  var rule74 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -209 | 0,
      lowdist: 0,
      titledist: -209 | 0
  };
  var rule75 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -211 | 0,
      lowdist: 0,
      titledist: -211 | 0
  };
  var rule76 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10743,
      lowdist: 0,
      titledist: 10743
  };
  var rule77 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42305,
      lowdist: 0,
      titledist: 42305
  };
  var rule78 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10749,
      lowdist: 0,
      titledist: 10749
  };
  var rule79 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -213 | 0,
      lowdist: 0,
      titledist: -213 | 0
  };
  var rule80 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -214 | 0,
      lowdist: 0,
      titledist: -214 | 0
  };
  var rule81 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 10727,
      lowdist: 0,
      titledist: 10727
  };
  var rule82 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -218 | 0,
      lowdist: 0,
      titledist: -218 | 0
  };
  var rule83 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42307,
      lowdist: 0,
      titledist: 42307
  };
  var rule84 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42282,
      lowdist: 0,
      titledist: 42282
  };
  var rule85 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -69 | 0,
      lowdist: 0,
      titledist: -69 | 0
  };
  var rule86 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -217 | 0,
      lowdist: 0,
      titledist: -217 | 0
  };
  var rule87 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -71 | 0,
      lowdist: 0,
      titledist: -71 | 0
  };
  var rule88 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -219 | 0,
      lowdist: 0,
      titledist: -219 | 0
  };
  var rule89 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42261,
      lowdist: 0,
      titledist: 42261
  };
  var rule90 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: 42258,
      lowdist: 0,
      titledist: 42258
  };
  var rule99 = {
      category: gencatLL,
      unicodeCat: NUMCAT_LL.value,
      possible: 1,
      updist: -38 | 0,
      lowdist: 0,
      titledist: -38 | 0
  };
  var gencatCS = 134217728;
  var rule199 = {
      category: gencatCS,
      unicodeCat: NUMCAT_CS.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatCO = 268435456;
  var rule200 = {
      category: gencatCO,
      unicodeCat: NUMCAT_CO.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatCF = 65536;
  var rule16 = {
      category: gencatCF,
      unicodeCat: NUMCAT_CF.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };
  var gencatCC = 1;
  var rule0 = {
      category: gencatCC,
      unicodeCat: NUMCAT_CC.value,
      possible: 0,
      updist: 0,
      lowdist: 0,
      titledist: 0
  };  
  var bsearch = function (a) {
      return function (array) {
          return function (size) {
              return function (compare) {
                  var go = function ($copy_i) {
                      return function ($copy_k) {
                          var $tco_var_i = $copy_i;
                          var $tco_done = false;
                          var $tco_result;
                          function $tco_loop(i, k) {
                              if (i > k || i >= Data_Array.length(array)) {
                                  $tco_done = true;
                                  return Data_Maybe.Nothing.value;
                              };
                              if (Data_Boolean.otherwise) {
                                  var j = Data_Int.floor(Data_Int.toNumber(i + k | 0) / 2.0);
                                  var v = compare(a)(array[j]);
                                  if (v instanceof Data_Ordering.EQ) {
                                      $tco_done = true;
                                      return new Data_Maybe.Just(array[j]);
                                  };
                                  if (v instanceof Data_Ordering.GT) {
                                      $tco_var_i = j + 1 | 0;
                                      $copy_k = k;
                                      return;
                                  };
                                  $tco_var_i = i;
                                  $copy_k = j - 1 | 0;
                                  return;
                              };
                              throw new Error("Failed pattern match at Data.CodePoint.Unicode.Internal (line 5611, column 5 - line 5617, column 49): " + [ i.constructor.name, k.constructor.name ]);
                          };
                          while (!$tco_done) {
                              $tco_result = $tco_loop($tco_var_i, $copy_k);
                          };
                          return $tco_result;
                      };
                  };
                  return go(0)(size);
              };
          };
      };
  };
  var blkCmp = function (v) {
      return function (v1) {
          if (v.start >= v1.start && v.start < (v1.start + v1.length | 0)) {
              return Data_Ordering.EQ.value;
          };
          if (v.start > v1.start) {
              return Data_Ordering.GT.value;
          };
          if (Data_Boolean.otherwise) {
              return Data_Ordering.LT.value;
          };
          throw new Error("Failed pattern match at Data.CodePoint.Unicode.Internal (line 5588, column 1 - line 5588, column 45): " + [ v.constructor.name, v1.constructor.name ]);
      };
  };
  var getRule = function (blocks) {
      return function (unichar) {
          return function (size) {
              var key = {
                  start: unichar,
                  length: 1,
                  convRule: nullrule
              };
              var maybeCharBlock = bsearch(key)(blocks)(size)(blkCmp);
              if (maybeCharBlock instanceof Data_Maybe.Nothing) {
                  return Data_Maybe.Nothing.value;
              };
              if (maybeCharBlock instanceof Data_Maybe.Just) {
                  return new Data_Maybe.Just(maybeCharBlock.value0.convRule);
              };
              throw new Error("Failed pattern match at Data.CodePoint.Unicode.Internal (line 5601, column 8 - line 5603, column 62): " + [ maybeCharBlock.constructor.name ]);
          };
      };
  };                                       
  var allchars = [ {
      start: 0,
      length: 32,
      convRule: rule0
  }, {
      start: 32,
      length: 1,
      convRule: rule1
  }, {
      start: 33,
      length: 3,
      convRule: rule2
  }, {
      start: 36,
      length: 1,
      convRule: rule3
  }, {
      start: 37,
      length: 3,
      convRule: rule2
  }, {
      start: 40,
      length: 1,
      convRule: rule4
  }, {
      start: 41,
      length: 1,
      convRule: rule5
  }, {
      start: 42,
      length: 1,
      convRule: rule2
  }, {
      start: 43,
      length: 1,
      convRule: rule6
  }, {
      start: 44,
      length: 1,
      convRule: rule2
  }, {
      start: 45,
      length: 1,
      convRule: rule7
  }, {
      start: 46,
      length: 2,
      convRule: rule2
  }, {
      start: 48,
      length: 10,
      convRule: rule8
  }, {
      start: 58,
      length: 2,
      convRule: rule2
  }, {
      start: 60,
      length: 3,
      convRule: rule6
  }, {
      start: 63,
      length: 2,
      convRule: rule2
  }, {
      start: 65,
      length: 26,
      convRule: rule9
  }, {
      start: 91,
      length: 1,
      convRule: rule4
  }, {
      start: 92,
      length: 1,
      convRule: rule2
  }, {
      start: 93,
      length: 1,
      convRule: rule5
  }, {
      start: 94,
      length: 1,
      convRule: rule10
  }, {
      start: 95,
      length: 1,
      convRule: rule11
  }, {
      start: 96,
      length: 1,
      convRule: rule10
  }, {
      start: 97,
      length: 26,
      convRule: rule12
  }, {
      start: 123,
      length: 1,
      convRule: rule4
  }, {
      start: 124,
      length: 1,
      convRule: rule6
  }, {
      start: 125,
      length: 1,
      convRule: rule5
  }, {
      start: 126,
      length: 1,
      convRule: rule6
  }, {
      start: 127,
      length: 33,
      convRule: rule0
  }, {
      start: 160,
      length: 1,
      convRule: rule1
  }, {
      start: 161,
      length: 1,
      convRule: rule2
  }, {
      start: 162,
      length: 4,
      convRule: rule3
  }, {
      start: 166,
      length: 1,
      convRule: rule13
  }, {
      start: 167,
      length: 1,
      convRule: rule2
  }, {
      start: 168,
      length: 1,
      convRule: rule10
  }, {
      start: 169,
      length: 1,
      convRule: rule13
  }, {
      start: 170,
      length: 1,
      convRule: rule14
  }, {
      start: 171,
      length: 1,
      convRule: rule15
  }, {
      start: 172,
      length: 1,
      convRule: rule6
  }, {
      start: 173,
      length: 1,
      convRule: rule16
  }, {
      start: 174,
      length: 1,
      convRule: rule13
  }, {
      start: 175,
      length: 1,
      convRule: rule10
  }, {
      start: 176,
      length: 1,
      convRule: rule13
  }, {
      start: 177,
      length: 1,
      convRule: rule6
  }, {
      start: 178,
      length: 2,
      convRule: rule17
  }, {
      start: 180,
      length: 1,
      convRule: rule10
  }, {
      start: 181,
      length: 1,
      convRule: rule18
  }, {
      start: 182,
      length: 2,
      convRule: rule2
  }, {
      start: 184,
      length: 1,
      convRule: rule10
  }, {
      start: 185,
      length: 1,
      convRule: rule17
  }, {
      start: 186,
      length: 1,
      convRule: rule14
  }, {
      start: 187,
      length: 1,
      convRule: rule19
  }, {
      start: 188,
      length: 3,
      convRule: rule17
  }, {
      start: 191,
      length: 1,
      convRule: rule2
  }, {
      start: 192,
      length: 23,
      convRule: rule9
  }, {
      start: 215,
      length: 1,
      convRule: rule6
  }, {
      start: 216,
      length: 7,
      convRule: rule9
  }, {
      start: 223,
      length: 1,
      convRule: rule20
  }, {
      start: 224,
      length: 23,
      convRule: rule12
  }, {
      start: 247,
      length: 1,
      convRule: rule6
  }, {
      start: 248,
      length: 7,
      convRule: rule12
  }, {
      start: 255,
      length: 1,
      convRule: rule21
  }, {
      start: 256,
      length: 1,
      convRule: rule22
  }, {
      start: 257,
      length: 1,
      convRule: rule23
  }, {
      start: 258,
      length: 1,
      convRule: rule22
  }, {
      start: 259,
      length: 1,
      convRule: rule23
  }, {
      start: 260,
      length: 1,
      convRule: rule22
  }, {
      start: 261,
      length: 1,
      convRule: rule23
  }, {
      start: 262,
      length: 1,
      convRule: rule22
  }, {
      start: 263,
      length: 1,
      convRule: rule23
  }, {
      start: 264,
      length: 1,
      convRule: rule22
  }, {
      start: 265,
      length: 1,
      convRule: rule23
  }, {
      start: 266,
      length: 1,
      convRule: rule22
  }, {
      start: 267,
      length: 1,
      convRule: rule23
  }, {
      start: 268,
      length: 1,
      convRule: rule22
  }, {
      start: 269,
      length: 1,
      convRule: rule23
  }, {
      start: 270,
      length: 1,
      convRule: rule22
  }, {
      start: 271,
      length: 1,
      convRule: rule23
  }, {
      start: 272,
      length: 1,
      convRule: rule22
  }, {
      start: 273,
      length: 1,
      convRule: rule23
  }, {
      start: 274,
      length: 1,
      convRule: rule22
  }, {
      start: 275,
      length: 1,
      convRule: rule23
  }, {
      start: 276,
      length: 1,
      convRule: rule22
  }, {
      start: 277,
      length: 1,
      convRule: rule23
  }, {
      start: 278,
      length: 1,
      convRule: rule22
  }, {
      start: 279,
      length: 1,
      convRule: rule23
  }, {
      start: 280,
      length: 1,
      convRule: rule22
  }, {
      start: 281,
      length: 1,
      convRule: rule23
  }, {
      start: 282,
      length: 1,
      convRule: rule22
  }, {
      start: 283,
      length: 1,
      convRule: rule23
  }, {
      start: 284,
      length: 1,
      convRule: rule22
  }, {
      start: 285,
      length: 1,
      convRule: rule23
  }, {
      start: 286,
      length: 1,
      convRule: rule22
  }, {
      start: 287,
      length: 1,
      convRule: rule23
  }, {
      start: 288,
      length: 1,
      convRule: rule22
  }, {
      start: 289,
      length: 1,
      convRule: rule23
  }, {
      start: 290,
      length: 1,
      convRule: rule22
  }, {
      start: 291,
      length: 1,
      convRule: rule23
  }, {
      start: 292,
      length: 1,
      convRule: rule22
  }, {
      start: 293,
      length: 1,
      convRule: rule23
  }, {
      start: 294,
      length: 1,
      convRule: rule22
  }, {
      start: 295,
      length: 1,
      convRule: rule23
  }, {
      start: 296,
      length: 1,
      convRule: rule22
  }, {
      start: 297,
      length: 1,
      convRule: rule23
  }, {
      start: 298,
      length: 1,
      convRule: rule22
  }, {
      start: 299,
      length: 1,
      convRule: rule23
  }, {
      start: 300,
      length: 1,
      convRule: rule22
  }, {
      start: 301,
      length: 1,
      convRule: rule23
  }, {
      start: 302,
      length: 1,
      convRule: rule22
  }, {
      start: 303,
      length: 1,
      convRule: rule23
  }, {
      start: 304,
      length: 1,
      convRule: rule24
  }, {
      start: 305,
      length: 1,
      convRule: rule25
  }, {
      start: 306,
      length: 1,
      convRule: rule22
  }, {
      start: 307,
      length: 1,
      convRule: rule23
  }, {
      start: 308,
      length: 1,
      convRule: rule22
  }, {
      start: 309,
      length: 1,
      convRule: rule23
  }, {
      start: 310,
      length: 1,
      convRule: rule22
  }, {
      start: 311,
      length: 1,
      convRule: rule23
  }, {
      start: 312,
      length: 1,
      convRule: rule20
  }, {
      start: 313,
      length: 1,
      convRule: rule22
  }, {
      start: 314,
      length: 1,
      convRule: rule23
  }, {
      start: 315,
      length: 1,
      convRule: rule22
  }, {
      start: 316,
      length: 1,
      convRule: rule23
  }, {
      start: 317,
      length: 1,
      convRule: rule22
  }, {
      start: 318,
      length: 1,
      convRule: rule23
  }, {
      start: 319,
      length: 1,
      convRule: rule22
  }, {
      start: 320,
      length: 1,
      convRule: rule23
  }, {
      start: 321,
      length: 1,
      convRule: rule22
  }, {
      start: 322,
      length: 1,
      convRule: rule23
  }, {
      start: 323,
      length: 1,
      convRule: rule22
  }, {
      start: 324,
      length: 1,
      convRule: rule23
  }, {
      start: 325,
      length: 1,
      convRule: rule22
  }, {
      start: 326,
      length: 1,
      convRule: rule23
  }, {
      start: 327,
      length: 1,
      convRule: rule22
  }, {
      start: 328,
      length: 1,
      convRule: rule23
  }, {
      start: 329,
      length: 1,
      convRule: rule20
  }, {
      start: 330,
      length: 1,
      convRule: rule22
  }, {
      start: 331,
      length: 1,
      convRule: rule23
  }, {
      start: 332,
      length: 1,
      convRule: rule22
  }, {
      start: 333,
      length: 1,
      convRule: rule23
  }, {
      start: 334,
      length: 1,
      convRule: rule22
  }, {
      start: 335,
      length: 1,
      convRule: rule23
  }, {
      start: 336,
      length: 1,
      convRule: rule22
  }, {
      start: 337,
      length: 1,
      convRule: rule23
  }, {
      start: 338,
      length: 1,
      convRule: rule22
  }, {
      start: 339,
      length: 1,
      convRule: rule23
  }, {
      start: 340,
      length: 1,
      convRule: rule22
  }, {
      start: 341,
      length: 1,
      convRule: rule23
  }, {
      start: 342,
      length: 1,
      convRule: rule22
  }, {
      start: 343,
      length: 1,
      convRule: rule23
  }, {
      start: 344,
      length: 1,
      convRule: rule22
  }, {
      start: 345,
      length: 1,
      convRule: rule23
  }, {
      start: 346,
      length: 1,
      convRule: rule22
  }, {
      start: 347,
      length: 1,
      convRule: rule23
  }, {
      start: 348,
      length: 1,
      convRule: rule22
  }, {
      start: 349,
      length: 1,
      convRule: rule23
  }, {
      start: 350,
      length: 1,
      convRule: rule22
  }, {
      start: 351,
      length: 1,
      convRule: rule23
  }, {
      start: 352,
      length: 1,
      convRule: rule22
  }, {
      start: 353,
      length: 1,
      convRule: rule23
  }, {
      start: 354,
      length: 1,
      convRule: rule22
  }, {
      start: 355,
      length: 1,
      convRule: rule23
  }, {
      start: 356,
      length: 1,
      convRule: rule22
  }, {
      start: 357,
      length: 1,
      convRule: rule23
  }, {
      start: 358,
      length: 1,
      convRule: rule22
  }, {
      start: 359,
      length: 1,
      convRule: rule23
  }, {
      start: 360,
      length: 1,
      convRule: rule22
  }, {
      start: 361,
      length: 1,
      convRule: rule23
  }, {
      start: 362,
      length: 1,
      convRule: rule22
  }, {
      start: 363,
      length: 1,
      convRule: rule23
  }, {
      start: 364,
      length: 1,
      convRule: rule22
  }, {
      start: 365,
      length: 1,
      convRule: rule23
  }, {
      start: 366,
      length: 1,
      convRule: rule22
  }, {
      start: 367,
      length: 1,
      convRule: rule23
  }, {
      start: 368,
      length: 1,
      convRule: rule22
  }, {
      start: 369,
      length: 1,
      convRule: rule23
  }, {
      start: 370,
      length: 1,
      convRule: rule22
  }, {
      start: 371,
      length: 1,
      convRule: rule23
  }, {
      start: 372,
      length: 1,
      convRule: rule22
  }, {
      start: 373,
      length: 1,
      convRule: rule23
  }, {
      start: 374,
      length: 1,
      convRule: rule22
  }, {
      start: 375,
      length: 1,
      convRule: rule23
  }, {
      start: 376,
      length: 1,
      convRule: rule26
  }, {
      start: 377,
      length: 1,
      convRule: rule22
  }, {
      start: 378,
      length: 1,
      convRule: rule23
  }, {
      start: 379,
      length: 1,
      convRule: rule22
  }, {
      start: 380,
      length: 1,
      convRule: rule23
  }, {
      start: 381,
      length: 1,
      convRule: rule22
  }, {
      start: 382,
      length: 1,
      convRule: rule23
  }, {
      start: 383,
      length: 1,
      convRule: rule27
  }, {
      start: 384,
      length: 1,
      convRule: rule28
  }, {
      start: 385,
      length: 1,
      convRule: rule29
  }, {
      start: 386,
      length: 1,
      convRule: rule22
  }, {
      start: 387,
      length: 1,
      convRule: rule23
  }, {
      start: 388,
      length: 1,
      convRule: rule22
  }, {
      start: 389,
      length: 1,
      convRule: rule23
  }, {
      start: 390,
      length: 1,
      convRule: rule30
  }, {
      start: 391,
      length: 1,
      convRule: rule22
  }, {
      start: 392,
      length: 1,
      convRule: rule23
  }, {
      start: 393,
      length: 2,
      convRule: rule31
  }, {
      start: 395,
      length: 1,
      convRule: rule22
  }, {
      start: 396,
      length: 1,
      convRule: rule23
  }, {
      start: 397,
      length: 1,
      convRule: rule20
  }, {
      start: 398,
      length: 1,
      convRule: rule32
  }, {
      start: 399,
      length: 1,
      convRule: rule33
  }, {
      start: 400,
      length: 1,
      convRule: rule34
  }, {
      start: 401,
      length: 1,
      convRule: rule22
  }, {
      start: 402,
      length: 1,
      convRule: rule23
  }, {
      start: 403,
      length: 1,
      convRule: rule31
  }, {
      start: 404,
      length: 1,
      convRule: rule35
  }, {
      start: 405,
      length: 1,
      convRule: rule36
  }, {
      start: 406,
      length: 1,
      convRule: rule37
  }, {
      start: 407,
      length: 1,
      convRule: rule38
  }, {
      start: 408,
      length: 1,
      convRule: rule22
  }, {
      start: 409,
      length: 1,
      convRule: rule23
  }, {
      start: 410,
      length: 1,
      convRule: rule39
  }, {
      start: 411,
      length: 1,
      convRule: rule20
  }, {
      start: 412,
      length: 1,
      convRule: rule37
  }, {
      start: 413,
      length: 1,
      convRule: rule40
  }, {
      start: 414,
      length: 1,
      convRule: rule41
  }, {
      start: 415,
      length: 1,
      convRule: rule42
  }, {
      start: 416,
      length: 1,
      convRule: rule22
  }, {
      start: 417,
      length: 1,
      convRule: rule23
  }, {
      start: 418,
      length: 1,
      convRule: rule22
  }, {
      start: 419,
      length: 1,
      convRule: rule23
  }, {
      start: 420,
      length: 1,
      convRule: rule22
  }, {
      start: 421,
      length: 1,
      convRule: rule23
  }, {
      start: 422,
      length: 1,
      convRule: rule43
  }, {
      start: 423,
      length: 1,
      convRule: rule22
  }, {
      start: 424,
      length: 1,
      convRule: rule23
  }, {
      start: 425,
      length: 1,
      convRule: rule43
  }, {
      start: 426,
      length: 2,
      convRule: rule20
  }, {
      start: 428,
      length: 1,
      convRule: rule22
  }, {
      start: 429,
      length: 1,
      convRule: rule23
  }, {
      start: 430,
      length: 1,
      convRule: rule43
  }, {
      start: 431,
      length: 1,
      convRule: rule22
  }, {
      start: 432,
      length: 1,
      convRule: rule23
  }, {
      start: 433,
      length: 2,
      convRule: rule44
  }, {
      start: 435,
      length: 1,
      convRule: rule22
  }, {
      start: 436,
      length: 1,
      convRule: rule23
  }, {
      start: 437,
      length: 1,
      convRule: rule22
  }, {
      start: 438,
      length: 1,
      convRule: rule23
  }, {
      start: 439,
      length: 1,
      convRule: rule45
  }, {
      start: 440,
      length: 1,
      convRule: rule22
  }, {
      start: 441,
      length: 1,
      convRule: rule23
  }, {
      start: 442,
      length: 1,
      convRule: rule20
  }, {
      start: 443,
      length: 1,
      convRule: rule14
  }, {
      start: 444,
      length: 1,
      convRule: rule22
  }, {
      start: 445,
      length: 1,
      convRule: rule23
  }, {
      start: 446,
      length: 1,
      convRule: rule20
  }, {
      start: 447,
      length: 1,
      convRule: rule46
  }, {
      start: 448,
      length: 4,
      convRule: rule14
  }, {
      start: 452,
      length: 1,
      convRule: rule47
  }, {
      start: 453,
      length: 1,
      convRule: rule48
  }, {
      start: 454,
      length: 1,
      convRule: rule49
  }, {
      start: 455,
      length: 1,
      convRule: rule47
  }, {
      start: 456,
      length: 1,
      convRule: rule48
  }, {
      start: 457,
      length: 1,
      convRule: rule49
  }, {
      start: 458,
      length: 1,
      convRule: rule47
  }, {
      start: 459,
      length: 1,
      convRule: rule48
  }, {
      start: 460,
      length: 1,
      convRule: rule49
  }, {
      start: 461,
      length: 1,
      convRule: rule22
  }, {
      start: 462,
      length: 1,
      convRule: rule23
  }, {
      start: 463,
      length: 1,
      convRule: rule22
  }, {
      start: 464,
      length: 1,
      convRule: rule23
  }, {
      start: 465,
      length: 1,
      convRule: rule22
  }, {
      start: 466,
      length: 1,
      convRule: rule23
  }, {
      start: 467,
      length: 1,
      convRule: rule22
  }, {
      start: 468,
      length: 1,
      convRule: rule23
  }, {
      start: 469,
      length: 1,
      convRule: rule22
  }, {
      start: 470,
      length: 1,
      convRule: rule23
  }, {
      start: 471,
      length: 1,
      convRule: rule22
  }, {
      start: 472,
      length: 1,
      convRule: rule23
  }, {
      start: 473,
      length: 1,
      convRule: rule22
  }, {
      start: 474,
      length: 1,
      convRule: rule23
  }, {
      start: 475,
      length: 1,
      convRule: rule22
  }, {
      start: 476,
      length: 1,
      convRule: rule23
  }, {
      start: 477,
      length: 1,
      convRule: rule50
  }, {
      start: 478,
      length: 1,
      convRule: rule22
  }, {
      start: 479,
      length: 1,
      convRule: rule23
  }, {
      start: 480,
      length: 1,
      convRule: rule22
  }, {
      start: 481,
      length: 1,
      convRule: rule23
  }, {
      start: 482,
      length: 1,
      convRule: rule22
  }, {
      start: 483,
      length: 1,
      convRule: rule23
  }, {
      start: 484,
      length: 1,
      convRule: rule22
  }, {
      start: 485,
      length: 1,
      convRule: rule23
  }, {
      start: 486,
      length: 1,
      convRule: rule22
  }, {
      start: 487,
      length: 1,
      convRule: rule23
  }, {
      start: 488,
      length: 1,
      convRule: rule22
  }, {
      start: 489,
      length: 1,
      convRule: rule23
  }, {
      start: 490,
      length: 1,
      convRule: rule22
  }, {
      start: 491,
      length: 1,
      convRule: rule23
  }, {
      start: 492,
      length: 1,
      convRule: rule22
  }, {
      start: 493,
      length: 1,
      convRule: rule23
  }, {
      start: 494,
      length: 1,
      convRule: rule22
  }, {
      start: 495,
      length: 1,
      convRule: rule23
  }, {
      start: 496,
      length: 1,
      convRule: rule20
  }, {
      start: 497,
      length: 1,
      convRule: rule47
  }, {
      start: 498,
      length: 1,
      convRule: rule48
  }, {
      start: 499,
      length: 1,
      convRule: rule49
  }, {
      start: 500,
      length: 1,
      convRule: rule22
  }, {
      start: 501,
      length: 1,
      convRule: rule23
  }, {
      start: 502,
      length: 1,
      convRule: rule51
  }, {
      start: 503,
      length: 1,
      convRule: rule52
  }, {
      start: 504,
      length: 1,
      convRule: rule22
  }, {
      start: 505,
      length: 1,
      convRule: rule23
  }, {
      start: 506,
      length: 1,
      convRule: rule22
  }, {
      start: 507,
      length: 1,
      convRule: rule23
  }, {
      start: 508,
      length: 1,
      convRule: rule22
  }, {
      start: 509,
      length: 1,
      convRule: rule23
  }, {
      start: 510,
      length: 1,
      convRule: rule22
  }, {
      start: 511,
      length: 1,
      convRule: rule23
  }, {
      start: 512,
      length: 1,
      convRule: rule22
  }, {
      start: 513,
      length: 1,
      convRule: rule23
  }, {
      start: 514,
      length: 1,
      convRule: rule22
  }, {
      start: 515,
      length: 1,
      convRule: rule23
  }, {
      start: 516,
      length: 1,
      convRule: rule22
  }, {
      start: 517,
      length: 1,
      convRule: rule23
  }, {
      start: 518,
      length: 1,
      convRule: rule22
  }, {
      start: 519,
      length: 1,
      convRule: rule23
  }, {
      start: 520,
      length: 1,
      convRule: rule22
  }, {
      start: 521,
      length: 1,
      convRule: rule23
  }, {
      start: 522,
      length: 1,
      convRule: rule22
  }, {
      start: 523,
      length: 1,
      convRule: rule23
  }, {
      start: 524,
      length: 1,
      convRule: rule22
  }, {
      start: 525,
      length: 1,
      convRule: rule23
  }, {
      start: 526,
      length: 1,
      convRule: rule22
  }, {
      start: 527,
      length: 1,
      convRule: rule23
  }, {
      start: 528,
      length: 1,
      convRule: rule22
  }, {
      start: 529,
      length: 1,
      convRule: rule23
  }, {
      start: 530,
      length: 1,
      convRule: rule22
  }, {
      start: 531,
      length: 1,
      convRule: rule23
  }, {
      start: 532,
      length: 1,
      convRule: rule22
  }, {
      start: 533,
      length: 1,
      convRule: rule23
  }, {
      start: 534,
      length: 1,
      convRule: rule22
  }, {
      start: 535,
      length: 1,
      convRule: rule23
  }, {
      start: 536,
      length: 1,
      convRule: rule22
  }, {
      start: 537,
      length: 1,
      convRule: rule23
  }, {
      start: 538,
      length: 1,
      convRule: rule22
  }, {
      start: 539,
      length: 1,
      convRule: rule23
  }, {
      start: 540,
      length: 1,
      convRule: rule22
  }, {
      start: 541,
      length: 1,
      convRule: rule23
  }, {
      start: 542,
      length: 1,
      convRule: rule22
  }, {
      start: 543,
      length: 1,
      convRule: rule23
  }, {
      start: 544,
      length: 1,
      convRule: rule53
  }, {
      start: 545,
      length: 1,
      convRule: rule20
  }, {
      start: 546,
      length: 1,
      convRule: rule22
  }, {
      start: 547,
      length: 1,
      convRule: rule23
  }, {
      start: 548,
      length: 1,
      convRule: rule22
  }, {
      start: 549,
      length: 1,
      convRule: rule23
  }, {
      start: 550,
      length: 1,
      convRule: rule22
  }, {
      start: 551,
      length: 1,
      convRule: rule23
  }, {
      start: 552,
      length: 1,
      convRule: rule22
  }, {
      start: 553,
      length: 1,
      convRule: rule23
  }, {
      start: 554,
      length: 1,
      convRule: rule22
  }, {
      start: 555,
      length: 1,
      convRule: rule23
  }, {
      start: 556,
      length: 1,
      convRule: rule22
  }, {
      start: 557,
      length: 1,
      convRule: rule23
  }, {
      start: 558,
      length: 1,
      convRule: rule22
  }, {
      start: 559,
      length: 1,
      convRule: rule23
  }, {
      start: 560,
      length: 1,
      convRule: rule22
  }, {
      start: 561,
      length: 1,
      convRule: rule23
  }, {
      start: 562,
      length: 1,
      convRule: rule22
  }, {
      start: 563,
      length: 1,
      convRule: rule23
  }, {
      start: 564,
      length: 6,
      convRule: rule20
  }, {
      start: 570,
      length: 1,
      convRule: rule54
  }, {
      start: 571,
      length: 1,
      convRule: rule22
  }, {
      start: 572,
      length: 1,
      convRule: rule23
  }, {
      start: 573,
      length: 1,
      convRule: rule55
  }, {
      start: 574,
      length: 1,
      convRule: rule56
  }, {
      start: 575,
      length: 2,
      convRule: rule57
  }, {
      start: 577,
      length: 1,
      convRule: rule22
  }, {
      start: 578,
      length: 1,
      convRule: rule23
  }, {
      start: 579,
      length: 1,
      convRule: rule58
  }, {
      start: 580,
      length: 1,
      convRule: rule59
  }, {
      start: 581,
      length: 1,
      convRule: rule60
  }, {
      start: 582,
      length: 1,
      convRule: rule22
  }, {
      start: 583,
      length: 1,
      convRule: rule23
  }, {
      start: 584,
      length: 1,
      convRule: rule22
  }, {
      start: 585,
      length: 1,
      convRule: rule23
  }, {
      start: 586,
      length: 1,
      convRule: rule22
  }, {
      start: 587,
      length: 1,
      convRule: rule23
  }, {
      start: 588,
      length: 1,
      convRule: rule22
  }, {
      start: 589,
      length: 1,
      convRule: rule23
  }, {
      start: 590,
      length: 1,
      convRule: rule22
  }, {
      start: 591,
      length: 1,
      convRule: rule23
  }, {
      start: 592,
      length: 1,
      convRule: rule61
  }, {
      start: 593,
      length: 1,
      convRule: rule62
  }, {
      start: 594,
      length: 1,
      convRule: rule63
  }, {
      start: 595,
      length: 1,
      convRule: rule64
  }, {
      start: 596,
      length: 1,
      convRule: rule65
  }, {
      start: 597,
      length: 1,
      convRule: rule20
  }, {
      start: 598,
      length: 2,
      convRule: rule66
  }, {
      start: 600,
      length: 1,
      convRule: rule20
  }, {
      start: 601,
      length: 1,
      convRule: rule67
  }, {
      start: 602,
      length: 1,
      convRule: rule20
  }, {
      start: 603,
      length: 1,
      convRule: rule68
  }, {
      start: 604,
      length: 1,
      convRule: rule69
  }, {
      start: 605,
      length: 3,
      convRule: rule20
  }, {
      start: 608,
      length: 1,
      convRule: rule66
  }, {
      start: 609,
      length: 1,
      convRule: rule70
  }, {
      start: 610,
      length: 1,
      convRule: rule20
  }, {
      start: 611,
      length: 1,
      convRule: rule71
  }, {
      start: 612,
      length: 1,
      convRule: rule20
  }, {
      start: 613,
      length: 1,
      convRule: rule72
  }, {
      start: 614,
      length: 1,
      convRule: rule73
  }, {
      start: 615,
      length: 1,
      convRule: rule20
  }, {
      start: 616,
      length: 1,
      convRule: rule74
  }, {
      start: 617,
      length: 1,
      convRule: rule75
  }, {
      start: 618,
      length: 1,
      convRule: rule73
  }, {
      start: 619,
      length: 1,
      convRule: rule76
  }, {
      start: 620,
      length: 1,
      convRule: rule77
  }, {
      start: 621,
      length: 2,
      convRule: rule20
  }, {
      start: 623,
      length: 1,
      convRule: rule75
  }, {
      start: 624,
      length: 1,
      convRule: rule20
  }, {
      start: 625,
      length: 1,
      convRule: rule78
  }, {
      start: 626,
      length: 1,
      convRule: rule79
  }, {
      start: 627,
      length: 2,
      convRule: rule20
  }, {
      start: 629,
      length: 1,
      convRule: rule80
  }, {
      start: 630,
      length: 7,
      convRule: rule20
  }, {
      start: 637,
      length: 1,
      convRule: rule81
  }, {
      start: 638,
      length: 2,
      convRule: rule20
  }, {
      start: 640,
      length: 1,
      convRule: rule82
  }, {
      start: 641,
      length: 1,
      convRule: rule20
  }, {
      start: 642,
      length: 1,
      convRule: rule83
  }, {
      start: 643,
      length: 1,
      convRule: rule82
  }, {
      start: 644,
      length: 3,
      convRule: rule20
  }, {
      start: 647,
      length: 1,
      convRule: rule84
  }, {
      start: 648,
      length: 1,
      convRule: rule82
  }, {
      start: 649,
      length: 1,
      convRule: rule85
  }, {
      start: 650,
      length: 2,
      convRule: rule86
  }, {
      start: 652,
      length: 1,
      convRule: rule87
  }, {
      start: 653,
      length: 5,
      convRule: rule20
  }, {
      start: 658,
      length: 1,
      convRule: rule88
  }, {
      start: 659,
      length: 1,
      convRule: rule20
  }, {
      start: 660,
      length: 1,
      convRule: rule14
  }, {
      start: 661,
      length: 8,
      convRule: rule20
  }, {
      start: 669,
      length: 1,
      convRule: rule89
  }, {
      start: 670,
      length: 1,
      convRule: rule90
  }, {
      start: 671,
      length: 17,
      convRule: rule20
  }, {
      start: 688,
      length: 18,
      convRule: rule91
  }, {
      start: 706,
      length: 4,
      convRule: rule10
  }, {
      start: 710,
      length: 12,
      convRule: rule91
  }, {
      start: 722,
      length: 14,
      convRule: rule10
  }, {
      start: 736,
      length: 5,
      convRule: rule91
  }, {
      start: 741,
      length: 7,
      convRule: rule10
  }, {
      start: 748,
      length: 1,
      convRule: rule91
  }, {
      start: 749,
      length: 1,
      convRule: rule10
  }, {
      start: 750,
      length: 1,
      convRule: rule91
  }, {
      start: 751,
      length: 17,
      convRule: rule10
  }, {
      start: 768,
      length: 69,
      convRule: rule92
  }, {
      start: 837,
      length: 1,
      convRule: rule93
  }, {
      start: 838,
      length: 42,
      convRule: rule92
  }, {
      start: 880,
      length: 1,
      convRule: rule22
  }, {
      start: 881,
      length: 1,
      convRule: rule23
  }, {
      start: 882,
      length: 1,
      convRule: rule22
  }, {
      start: 883,
      length: 1,
      convRule: rule23
  }, {
      start: 884,
      length: 1,
      convRule: rule91
  }, {
      start: 885,
      length: 1,
      convRule: rule10
  }, {
      start: 886,
      length: 1,
      convRule: rule22
  }, {
      start: 887,
      length: 1,
      convRule: rule23
  }, {
      start: 890,
      length: 1,
      convRule: rule91
  }, {
      start: 891,
      length: 3,
      convRule: rule41
  }, {
      start: 894,
      length: 1,
      convRule: rule2
  }, {
      start: 895,
      length: 1,
      convRule: rule94
  }, {
      start: 900,
      length: 2,
      convRule: rule10
  }, {
      start: 902,
      length: 1,
      convRule: rule95
  }, {
      start: 903,
      length: 1,
      convRule: rule2
  }, {
      start: 904,
      length: 3,
      convRule: rule96
  }, {
      start: 908,
      length: 1,
      convRule: rule97
  }, {
      start: 910,
      length: 2,
      convRule: rule98
  }, {
      start: 912,
      length: 1,
      convRule: rule20
  }, {
      start: 913,
      length: 17,
      convRule: rule9
  }, {
      start: 931,
      length: 9,
      convRule: rule9
  }, {
      start: 940,
      length: 1,
      convRule: rule99
  }, {
      start: 941,
      length: 3,
      convRule: rule100
  }, {
      start: 944,
      length: 1,
      convRule: rule20
  }, {
      start: 945,
      length: 17,
      convRule: rule12
  }, {
      start: 962,
      length: 1,
      convRule: rule101
  }, {
      start: 963,
      length: 9,
      convRule: rule12
  }, {
      start: 972,
      length: 1,
      convRule: rule102
  }, {
      start: 973,
      length: 2,
      convRule: rule103
  }, {
      start: 975,
      length: 1,
      convRule: rule104
  }, {
      start: 976,
      length: 1,
      convRule: rule105
  }, {
      start: 977,
      length: 1,
      convRule: rule106
  }, {
      start: 978,
      length: 3,
      convRule: rule107
  }, {
      start: 981,
      length: 1,
      convRule: rule108
  }, {
      start: 982,
      length: 1,
      convRule: rule109
  }, {
      start: 983,
      length: 1,
      convRule: rule110
  }, {
      start: 984,
      length: 1,
      convRule: rule22
  }, {
      start: 985,
      length: 1,
      convRule: rule23
  }, {
      start: 986,
      length: 1,
      convRule: rule22
  }, {
      start: 987,
      length: 1,
      convRule: rule23
  }, {
      start: 988,
      length: 1,
      convRule: rule22
  }, {
      start: 989,
      length: 1,
      convRule: rule23
  }, {
      start: 990,
      length: 1,
      convRule: rule22
  }, {
      start: 991,
      length: 1,
      convRule: rule23
  }, {
      start: 992,
      length: 1,
      convRule: rule22
  }, {
      start: 993,
      length: 1,
      convRule: rule23
  }, {
      start: 994,
      length: 1,
      convRule: rule22
  }, {
      start: 995,
      length: 1,
      convRule: rule23
  }, {
      start: 996,
      length: 1,
      convRule: rule22
  }, {
      start: 997,
      length: 1,
      convRule: rule23
  }, {
      start: 998,
      length: 1,
      convRule: rule22
  }, {
      start: 999,
      length: 1,
      convRule: rule23
  }, {
      start: 1000,
      length: 1,
      convRule: rule22
  }, {
      start: 1001,
      length: 1,
      convRule: rule23
  }, {
      start: 1002,
      length: 1,
      convRule: rule22
  }, {
      start: 1003,
      length: 1,
      convRule: rule23
  }, {
      start: 1004,
      length: 1,
      convRule: rule22
  }, {
      start: 1005,
      length: 1,
      convRule: rule23
  }, {
      start: 1006,
      length: 1,
      convRule: rule22
  }, {
      start: 1007,
      length: 1,
      convRule: rule23
  }, {
      start: 1008,
      length: 1,
      convRule: rule111
  }, {
      start: 1009,
      length: 1,
      convRule: rule112
  }, {
      start: 1010,
      length: 1,
      convRule: rule113
  }, {
      start: 1011,
      length: 1,
      convRule: rule114
  }, {
      start: 1012,
      length: 1,
      convRule: rule115
  }, {
      start: 1013,
      length: 1,
      convRule: rule116
  }, {
      start: 1014,
      length: 1,
      convRule: rule6
  }, {
      start: 1015,
      length: 1,
      convRule: rule22
  }, {
      start: 1016,
      length: 1,
      convRule: rule23
  }, {
      start: 1017,
      length: 1,
      convRule: rule117
  }, {
      start: 1018,
      length: 1,
      convRule: rule22
  }, {
      start: 1019,
      length: 1,
      convRule: rule23
  }, {
      start: 1020,
      length: 1,
      convRule: rule20
  }, {
      start: 1021,
      length: 3,
      convRule: rule53
  }, {
      start: 1024,
      length: 16,
      convRule: rule118
  }, {
      start: 1040,
      length: 32,
      convRule: rule9
  }, {
      start: 1072,
      length: 32,
      convRule: rule12
  }, {
      start: 1104,
      length: 16,
      convRule: rule112
  }, {
      start: 1120,
      length: 1,
      convRule: rule22
  }, {
      start: 1121,
      length: 1,
      convRule: rule23
  }, {
      start: 1122,
      length: 1,
      convRule: rule22
  }, {
      start: 1123,
      length: 1,
      convRule: rule23
  }, {
      start: 1124,
      length: 1,
      convRule: rule22
  }, {
      start: 1125,
      length: 1,
      convRule: rule23
  }, {
      start: 1126,
      length: 1,
      convRule: rule22
  }, {
      start: 1127,
      length: 1,
      convRule: rule23
  }, {
      start: 1128,
      length: 1,
      convRule: rule22
  }, {
      start: 1129,
      length: 1,
      convRule: rule23
  }, {
      start: 1130,
      length: 1,
      convRule: rule22
  }, {
      start: 1131,
      length: 1,
      convRule: rule23
  }, {
      start: 1132,
      length: 1,
      convRule: rule22
  }, {
      start: 1133,
      length: 1,
      convRule: rule23
  }, {
      start: 1134,
      length: 1,
      convRule: rule22
  }, {
      start: 1135,
      length: 1,
      convRule: rule23
  }, {
      start: 1136,
      length: 1,
      convRule: rule22
  }, {
      start: 1137,
      length: 1,
      convRule: rule23
  }, {
      start: 1138,
      length: 1,
      convRule: rule22
  }, {
      start: 1139,
      length: 1,
      convRule: rule23
  }, {
      start: 1140,
      length: 1,
      convRule: rule22
  }, {
      start: 1141,
      length: 1,
      convRule: rule23
  }, {
      start: 1142,
      length: 1,
      convRule: rule22
  }, {
      start: 1143,
      length: 1,
      convRule: rule23
  }, {
      start: 1144,
      length: 1,
      convRule: rule22
  }, {
      start: 1145,
      length: 1,
      convRule: rule23
  }, {
      start: 1146,
      length: 1,
      convRule: rule22
  }, {
      start: 1147,
      length: 1,
      convRule: rule23
  }, {
      start: 1148,
      length: 1,
      convRule: rule22
  }, {
      start: 1149,
      length: 1,
      convRule: rule23
  }, {
      start: 1150,
      length: 1,
      convRule: rule22
  }, {
      start: 1151,
      length: 1,
      convRule: rule23
  }, {
      start: 1152,
      length: 1,
      convRule: rule22
  }, {
      start: 1153,
      length: 1,
      convRule: rule23
  }, {
      start: 1154,
      length: 1,
      convRule: rule13
  }, {
      start: 1155,
      length: 5,
      convRule: rule92
  }, {
      start: 1160,
      length: 2,
      convRule: rule119
  }, {
      start: 1162,
      length: 1,
      convRule: rule22
  }, {
      start: 1163,
      length: 1,
      convRule: rule23
  }, {
      start: 1164,
      length: 1,
      convRule: rule22
  }, {
      start: 1165,
      length: 1,
      convRule: rule23
  }, {
      start: 1166,
      length: 1,
      convRule: rule22
  }, {
      start: 1167,
      length: 1,
      convRule: rule23
  }, {
      start: 1168,
      length: 1,
      convRule: rule22
  }, {
      start: 1169,
      length: 1,
      convRule: rule23
  }, {
      start: 1170,
      length: 1,
      convRule: rule22
  }, {
      start: 1171,
      length: 1,
      convRule: rule23
  }, {
      start: 1172,
      length: 1,
      convRule: rule22
  }, {
      start: 1173,
      length: 1,
      convRule: rule23
  }, {
      start: 1174,
      length: 1,
      convRule: rule22
  }, {
      start: 1175,
      length: 1,
      convRule: rule23
  }, {
      start: 1176,
      length: 1,
      convRule: rule22
  }, {
      start: 1177,
      length: 1,
      convRule: rule23
  }, {
      start: 1178,
      length: 1,
      convRule: rule22
  }, {
      start: 1179,
      length: 1,
      convRule: rule23
  }, {
      start: 1180,
      length: 1,
      convRule: rule22
  }, {
      start: 1181,
      length: 1,
      convRule: rule23
  }, {
      start: 1182,
      length: 1,
      convRule: rule22
  }, {
      start: 1183,
      length: 1,
      convRule: rule23
  }, {
      start: 1184,
      length: 1,
      convRule: rule22
  }, {
      start: 1185,
      length: 1,
      convRule: rule23
  }, {
      start: 1186,
      length: 1,
      convRule: rule22
  }, {
      start: 1187,
      length: 1,
      convRule: rule23
  }, {
      start: 1188,
      length: 1,
      convRule: rule22
  }, {
      start: 1189,
      length: 1,
      convRule: rule23
  }, {
      start: 1190,
      length: 1,
      convRule: rule22
  }, {
      start: 1191,
      length: 1,
      convRule: rule23
  }, {
      start: 1192,
      length: 1,
      convRule: rule22
  }, {
      start: 1193,
      length: 1,
      convRule: rule23
  }, {
      start: 1194,
      length: 1,
      convRule: rule22
  }, {
      start: 1195,
      length: 1,
      convRule: rule23
  }, {
      start: 1196,
      length: 1,
      convRule: rule22
  }, {
      start: 1197,
      length: 1,
      convRule: rule23
  }, {
      start: 1198,
      length: 1,
      convRule: rule22
  }, {
      start: 1199,
      length: 1,
      convRule: rule23
  }, {
      start: 1200,
      length: 1,
      convRule: rule22
  }, {
      start: 1201,
      length: 1,
      convRule: rule23
  }, {
      start: 1202,
      length: 1,
      convRule: rule22
  }, {
      start: 1203,
      length: 1,
      convRule: rule23
  }, {
      start: 1204,
      length: 1,
      convRule: rule22
  }, {
      start: 1205,
      length: 1,
      convRule: rule23
  }, {
      start: 1206,
      length: 1,
      convRule: rule22
  }, {
      start: 1207,
      length: 1,
      convRule: rule23
  }, {
      start: 1208,
      length: 1,
      convRule: rule22
  }, {
      start: 1209,
      length: 1,
      convRule: rule23
  }, {
      start: 1210,
      length: 1,
      convRule: rule22
  }, {
      start: 1211,
      length: 1,
      convRule: rule23
  }, {
      start: 1212,
      length: 1,
      convRule: rule22
  }, {
      start: 1213,
      length: 1,
      convRule: rule23
  }, {
      start: 1214,
      length: 1,
      convRule: rule22
  }, {
      start: 1215,
      length: 1,
      convRule: rule23
  }, {
      start: 1216,
      length: 1,
      convRule: rule120
  }, {
      start: 1217,
      length: 1,
      convRule: rule22
  }, {
      start: 1218,
      length: 1,
      convRule: rule23
  }, {
      start: 1219,
      length: 1,
      convRule: rule22
  }, {
      start: 1220,
      length: 1,
      convRule: rule23
  }, {
      start: 1221,
      length: 1,
      convRule: rule22
  }, {
      start: 1222,
      length: 1,
      convRule: rule23
  }, {
      start: 1223,
      length: 1,
      convRule: rule22
  }, {
      start: 1224,
      length: 1,
      convRule: rule23
  }, {
      start: 1225,
      length: 1,
      convRule: rule22
  }, {
      start: 1226,
      length: 1,
      convRule: rule23
  }, {
      start: 1227,
      length: 1,
      convRule: rule22
  }, {
      start: 1228,
      length: 1,
      convRule: rule23
  }, {
      start: 1229,
      length: 1,
      convRule: rule22
  }, {
      start: 1230,
      length: 1,
      convRule: rule23
  }, {
      start: 1231,
      length: 1,
      convRule: rule121
  }, {
      start: 1232,
      length: 1,
      convRule: rule22
  }, {
      start: 1233,
      length: 1,
      convRule: rule23
  }, {
      start: 1234,
      length: 1,
      convRule: rule22
  }, {
      start: 1235,
      length: 1,
      convRule: rule23
  }, {
      start: 1236,
      length: 1,
      convRule: rule22
  }, {
      start: 1237,
      length: 1,
      convRule: rule23
  }, {
      start: 1238,
      length: 1,
      convRule: rule22
  }, {
      start: 1239,
      length: 1,
      convRule: rule23
  }, {
      start: 1240,
      length: 1,
      convRule: rule22
  }, {
      start: 1241,
      length: 1,
      convRule: rule23
  }, {
      start: 1242,
      length: 1,
      convRule: rule22
  }, {
      start: 1243,
      length: 1,
      convRule: rule23
  }, {
      start: 1244,
      length: 1,
      convRule: rule22
  }, {
      start: 1245,
      length: 1,
      convRule: rule23
  }, {
      start: 1246,
      length: 1,
      convRule: rule22
  }, {
      start: 1247,
      length: 1,
      convRule: rule23
  }, {
      start: 1248,
      length: 1,
      convRule: rule22
  }, {
      start: 1249,
      length: 1,
      convRule: rule23
  }, {
      start: 1250,
      length: 1,
      convRule: rule22
  }, {
      start: 1251,
      length: 1,
      convRule: rule23
  }, {
      start: 1252,
      length: 1,
      convRule: rule22
  }, {
      start: 1253,
      length: 1,
      convRule: rule23
  }, {
      start: 1254,
      length: 1,
      convRule: rule22
  }, {
      start: 1255,
      length: 1,
      convRule: rule23
  }, {
      start: 1256,
      length: 1,
      convRule: rule22
  }, {
      start: 1257,
      length: 1,
      convRule: rule23
  }, {
      start: 1258,
      length: 1,
      convRule: rule22
  }, {
      start: 1259,
      length: 1,
      convRule: rule23
  }, {
      start: 1260,
      length: 1,
      convRule: rule22
  }, {
      start: 1261,
      length: 1,
      convRule: rule23
  }, {
      start: 1262,
      length: 1,
      convRule: rule22
  }, {
      start: 1263,
      length: 1,
      convRule: rule23
  }, {
      start: 1264,
      length: 1,
      convRule: rule22
  }, {
      start: 1265,
      length: 1,
      convRule: rule23
  }, {
      start: 1266,
      length: 1,
      convRule: rule22
  }, {
      start: 1267,
      length: 1,
      convRule: rule23
  }, {
      start: 1268,
      length: 1,
      convRule: rule22
  }, {
      start: 1269,
      length: 1,
      convRule: rule23
  }, {
      start: 1270,
      length: 1,
      convRule: rule22
  }, {
      start: 1271,
      length: 1,
      convRule: rule23
  }, {
      start: 1272,
      length: 1,
      convRule: rule22
  }, {
      start: 1273,
      length: 1,
      convRule: rule23
  }, {
      start: 1274,
      length: 1,
      convRule: rule22
  }, {
      start: 1275,
      length: 1,
      convRule: rule23
  }, {
      start: 1276,
      length: 1,
      convRule: rule22
  }, {
      start: 1277,
      length: 1,
      convRule: rule23
  }, {
      start: 1278,
      length: 1,
      convRule: rule22
  }, {
      start: 1279,
      length: 1,
      convRule: rule23
  }, {
      start: 1280,
      length: 1,
      convRule: rule22
  }, {
      start: 1281,
      length: 1,
      convRule: rule23
  }, {
      start: 1282,
      length: 1,
      convRule: rule22
  }, {
      start: 1283,
      length: 1,
      convRule: rule23
  }, {
      start: 1284,
      length: 1,
      convRule: rule22
  }, {
      start: 1285,
      length: 1,
      convRule: rule23
  }, {
      start: 1286,
      length: 1,
      convRule: rule22
  }, {
      start: 1287,
      length: 1,
      convRule: rule23
  }, {
      start: 1288,
      length: 1,
      convRule: rule22
  }, {
      start: 1289,
      length: 1,
      convRule: rule23
  }, {
      start: 1290,
      length: 1,
      convRule: rule22
  }, {
      start: 1291,
      length: 1,
      convRule: rule23
  }, {
      start: 1292,
      length: 1,
      convRule: rule22
  }, {
      start: 1293,
      length: 1,
      convRule: rule23
  }, {
      start: 1294,
      length: 1,
      convRule: rule22
  }, {
      start: 1295,
      length: 1,
      convRule: rule23
  }, {
      start: 1296,
      length: 1,
      convRule: rule22
  }, {
      start: 1297,
      length: 1,
      convRule: rule23
  }, {
      start: 1298,
      length: 1,
      convRule: rule22
  }, {
      start: 1299,
      length: 1,
      convRule: rule23
  }, {
      start: 1300,
      length: 1,
      convRule: rule22
  }, {
      start: 1301,
      length: 1,
      convRule: rule23
  }, {
      start: 1302,
      length: 1,
      convRule: rule22
  }, {
      start: 1303,
      length: 1,
      convRule: rule23
  }, {
      start: 1304,
      length: 1,
      convRule: rule22
  }, {
      start: 1305,
      length: 1,
      convRule: rule23
  }, {
      start: 1306,
      length: 1,
      convRule: rule22
  }, {
      start: 1307,
      length: 1,
      convRule: rule23
  }, {
      start: 1308,
      length: 1,
      convRule: rule22
  }, {
      start: 1309,
      length: 1,
      convRule: rule23
  }, {
      start: 1310,
      length: 1,
      convRule: rule22
  }, {
      start: 1311,
      length: 1,
      convRule: rule23
  }, {
      start: 1312,
      length: 1,
      convRule: rule22
  }, {
      start: 1313,
      length: 1,
      convRule: rule23
  }, {
      start: 1314,
      length: 1,
      convRule: rule22
  }, {
      start: 1315,
      length: 1,
      convRule: rule23
  }, {
      start: 1316,
      length: 1,
      convRule: rule22
  }, {
      start: 1317,
      length: 1,
      convRule: rule23
  }, {
      start: 1318,
      length: 1,
      convRule: rule22
  }, {
      start: 1319,
      length: 1,
      convRule: rule23
  }, {
      start: 1320,
      length: 1,
      convRule: rule22
  }, {
      start: 1321,
      length: 1,
      convRule: rule23
  }, {
      start: 1322,
      length: 1,
      convRule: rule22
  }, {
      start: 1323,
      length: 1,
      convRule: rule23
  }, {
      start: 1324,
      length: 1,
      convRule: rule22
  }, {
      start: 1325,
      length: 1,
      convRule: rule23
  }, {
      start: 1326,
      length: 1,
      convRule: rule22
  }, {
      start: 1327,
      length: 1,
      convRule: rule23
  }, {
      start: 1329,
      length: 38,
      convRule: rule122
  }, {
      start: 1369,
      length: 1,
      convRule: rule91
  }, {
      start: 1370,
      length: 6,
      convRule: rule2
  }, {
      start: 1376,
      length: 1,
      convRule: rule20
  }, {
      start: 1377,
      length: 38,
      convRule: rule123
  }, {
      start: 1415,
      length: 2,
      convRule: rule20
  }, {
      start: 1417,
      length: 1,
      convRule: rule2
  }, {
      start: 1418,
      length: 1,
      convRule: rule7
  }, {
      start: 1421,
      length: 2,
      convRule: rule13
  }, {
      start: 1423,
      length: 1,
      convRule: rule3
  }, {
      start: 1425,
      length: 45,
      convRule: rule92
  }, {
      start: 1470,
      length: 1,
      convRule: rule7
  }, {
      start: 1471,
      length: 1,
      convRule: rule92
  }, {
      start: 1472,
      length: 1,
      convRule: rule2
  }, {
      start: 1473,
      length: 2,
      convRule: rule92
  }, {
      start: 1475,
      length: 1,
      convRule: rule2
  }, {
      start: 1476,
      length: 2,
      convRule: rule92
  }, {
      start: 1478,
      length: 1,
      convRule: rule2
  }, {
      start: 1479,
      length: 1,
      convRule: rule92
  }, {
      start: 1488,
      length: 27,
      convRule: rule14
  }, {
      start: 1519,
      length: 4,
      convRule: rule14
  }, {
      start: 1523,
      length: 2,
      convRule: rule2
  }, {
      start: 1536,
      length: 6,
      convRule: rule16
  }, {
      start: 1542,
      length: 3,
      convRule: rule6
  }, {
      start: 1545,
      length: 2,
      convRule: rule2
  }, {
      start: 1547,
      length: 1,
      convRule: rule3
  }, {
      start: 1548,
      length: 2,
      convRule: rule2
  }, {
      start: 1550,
      length: 2,
      convRule: rule13
  }, {
      start: 1552,
      length: 11,
      convRule: rule92
  }, {
      start: 1563,
      length: 1,
      convRule: rule2
  }, {
      start: 1564,
      length: 1,
      convRule: rule16
  }, {
      start: 1566,
      length: 2,
      convRule: rule2
  }, {
      start: 1568,
      length: 32,
      convRule: rule14
  }, {
      start: 1600,
      length: 1,
      convRule: rule91
  }, {
      start: 1601,
      length: 10,
      convRule: rule14
  }, {
      start: 1611,
      length: 21,
      convRule: rule92
  }, {
      start: 1632,
      length: 10,
      convRule: rule8
  }, {
      start: 1642,
      length: 4,
      convRule: rule2
  }, {
      start: 1646,
      length: 2,
      convRule: rule14
  }, {
      start: 1648,
      length: 1,
      convRule: rule92
  }, {
      start: 1649,
      length: 99,
      convRule: rule14
  }, {
      start: 1748,
      length: 1,
      convRule: rule2
  }, {
      start: 1749,
      length: 1,
      convRule: rule14
  }, {
      start: 1750,
      length: 7,
      convRule: rule92
  }, {
      start: 1757,
      length: 1,
      convRule: rule16
  }, {
      start: 1758,
      length: 1,
      convRule: rule13
  }, {
      start: 1759,
      length: 6,
      convRule: rule92
  }, {
      start: 1765,
      length: 2,
      convRule: rule91
  }, {
      start: 1767,
      length: 2,
      convRule: rule92
  }, {
      start: 1769,
      length: 1,
      convRule: rule13
  }, {
      start: 1770,
      length: 4,
      convRule: rule92
  }, {
      start: 1774,
      length: 2,
      convRule: rule14
  }, {
      start: 1776,
      length: 10,
      convRule: rule8
  }, {
      start: 1786,
      length: 3,
      convRule: rule14
  }, {
      start: 1789,
      length: 2,
      convRule: rule13
  }, {
      start: 1791,
      length: 1,
      convRule: rule14
  }, {
      start: 1792,
      length: 14,
      convRule: rule2
  }, {
      start: 1807,
      length: 1,
      convRule: rule16
  }, {
      start: 1808,
      length: 1,
      convRule: rule14
  }, {
      start: 1809,
      length: 1,
      convRule: rule92
  }, {
      start: 1810,
      length: 30,
      convRule: rule14
  }, {
      start: 1840,
      length: 27,
      convRule: rule92
  }, {
      start: 1869,
      length: 89,
      convRule: rule14
  }, {
      start: 1958,
      length: 11,
      convRule: rule92
  }, {
      start: 1969,
      length: 1,
      convRule: rule14
  }, {
      start: 1984,
      length: 10,
      convRule: rule8
  }, {
      start: 1994,
      length: 33,
      convRule: rule14
  }, {
      start: 2027,
      length: 9,
      convRule: rule92
  }, {
      start: 2036,
      length: 2,
      convRule: rule91
  }, {
      start: 2038,
      length: 1,
      convRule: rule13
  }, {
      start: 2039,
      length: 3,
      convRule: rule2
  }, {
      start: 2042,
      length: 1,
      convRule: rule91
  }, {
      start: 2045,
      length: 1,
      convRule: rule92
  }, {
      start: 2046,
      length: 2,
      convRule: rule3
  }, {
      start: 2048,
      length: 22,
      convRule: rule14
  }, {
      start: 2070,
      length: 4,
      convRule: rule92
  }, {
      start: 2074,
      length: 1,
      convRule: rule91
  }, {
      start: 2075,
      length: 9,
      convRule: rule92
  }, {
      start: 2084,
      length: 1,
      convRule: rule91
  }, {
      start: 2085,
      length: 3,
      convRule: rule92
  }, {
      start: 2088,
      length: 1,
      convRule: rule91
  }, {
      start: 2089,
      length: 5,
      convRule: rule92
  }, {
      start: 2096,
      length: 15,
      convRule: rule2
  }, {
      start: 2112,
      length: 25,
      convRule: rule14
  }, {
      start: 2137,
      length: 3,
      convRule: rule92
  }, {
      start: 2142,
      length: 1,
      convRule: rule2
  }, {
      start: 2144,
      length: 11,
      convRule: rule14
  }, {
      start: 2208,
      length: 21,
      convRule: rule14
  }, {
      start: 2230,
      length: 18,
      convRule: rule14
  }, {
      start: 2259,
      length: 15,
      convRule: rule92
  }, {
      start: 2274,
      length: 1,
      convRule: rule16
  }, {
      start: 2275,
      length: 32,
      convRule: rule92
  }, {
      start: 2307,
      length: 1,
      convRule: rule124
  }, {
      start: 2308,
      length: 54,
      convRule: rule14
  }, {
      start: 2362,
      length: 1,
      convRule: rule92
  }, {
      start: 2363,
      length: 1,
      convRule: rule124
  }, {
      start: 2364,
      length: 1,
      convRule: rule92
  }, {
      start: 2365,
      length: 1,
      convRule: rule14
  }, {
      start: 2366,
      length: 3,
      convRule: rule124
  }, {
      start: 2369,
      length: 8,
      convRule: rule92
  }, {
      start: 2377,
      length: 4,
      convRule: rule124
  }, {
      start: 2381,
      length: 1,
      convRule: rule92
  }, {
      start: 2382,
      length: 2,
      convRule: rule124
  }, {
      start: 2384,
      length: 1,
      convRule: rule14
  }, {
      start: 2385,
      length: 7,
      convRule: rule92
  }, {
      start: 2392,
      length: 10,
      convRule: rule14
  }, {
      start: 2402,
      length: 2,
      convRule: rule92
  }, {
      start: 2404,
      length: 2,
      convRule: rule2
  }, {
      start: 2406,
      length: 10,
      convRule: rule8
  }, {
      start: 2416,
      length: 1,
      convRule: rule2
  }, {
      start: 2417,
      length: 1,
      convRule: rule91
  }, {
      start: 2418,
      length: 15,
      convRule: rule14
  }, {
      start: 2433,
      length: 1,
      convRule: rule92
  }, {
      start: 2434,
      length: 2,
      convRule: rule124
  }, {
      start: 2437,
      length: 8,
      convRule: rule14
  }, {
      start: 2447,
      length: 2,
      convRule: rule14
  }, {
      start: 2451,
      length: 22,
      convRule: rule14
  }, {
      start: 2474,
      length: 7,
      convRule: rule14
  }, {
      start: 2482,
      length: 1,
      convRule: rule14
  }, {
      start: 2486,
      length: 4,
      convRule: rule14
  }, {
      start: 2492,
      length: 1,
      convRule: rule92
  }, {
      start: 2493,
      length: 1,
      convRule: rule14
  }, {
      start: 2494,
      length: 3,
      convRule: rule124
  }, {
      start: 2497,
      length: 4,
      convRule: rule92
  }, {
      start: 2503,
      length: 2,
      convRule: rule124
  }, {
      start: 2507,
      length: 2,
      convRule: rule124
  }, {
      start: 2509,
      length: 1,
      convRule: rule92
  }, {
      start: 2510,
      length: 1,
      convRule: rule14
  }, {
      start: 2519,
      length: 1,
      convRule: rule124
  }, {
      start: 2524,
      length: 2,
      convRule: rule14
  }, {
      start: 2527,
      length: 3,
      convRule: rule14
  }, {
      start: 2530,
      length: 2,
      convRule: rule92
  }, {
      start: 2534,
      length: 10,
      convRule: rule8
  }, {
      start: 2544,
      length: 2,
      convRule: rule14
  }, {
      start: 2546,
      length: 2,
      convRule: rule3
  }, {
      start: 2548,
      length: 6,
      convRule: rule17
  }, {
      start: 2554,
      length: 1,
      convRule: rule13
  }, {
      start: 2555,
      length: 1,
      convRule: rule3
  }, {
      start: 2556,
      length: 1,
      convRule: rule14
  }, {
      start: 2557,
      length: 1,
      convRule: rule2
  }, {
      start: 2558,
      length: 1,
      convRule: rule92
  }, {
      start: 2561,
      length: 2,
      convRule: rule92
  }, {
      start: 2563,
      length: 1,
      convRule: rule124
  }, {
      start: 2565,
      length: 6,
      convRule: rule14
  }, {
      start: 2575,
      length: 2,
      convRule: rule14
  }, {
      start: 2579,
      length: 22,
      convRule: rule14
  }, {
      start: 2602,
      length: 7,
      convRule: rule14
  }, {
      start: 2610,
      length: 2,
      convRule: rule14
  }, {
      start: 2613,
      length: 2,
      convRule: rule14
  }, {
      start: 2616,
      length: 2,
      convRule: rule14
  }, {
      start: 2620,
      length: 1,
      convRule: rule92
  }, {
      start: 2622,
      length: 3,
      convRule: rule124
  }, {
      start: 2625,
      length: 2,
      convRule: rule92
  }, {
      start: 2631,
      length: 2,
      convRule: rule92
  }, {
      start: 2635,
      length: 3,
      convRule: rule92
  }, {
      start: 2641,
      length: 1,
      convRule: rule92
  }, {
      start: 2649,
      length: 4,
      convRule: rule14
  }, {
      start: 2654,
      length: 1,
      convRule: rule14
  }, {
      start: 2662,
      length: 10,
      convRule: rule8
  }, {
      start: 2672,
      length: 2,
      convRule: rule92
  }, {
      start: 2674,
      length: 3,
      convRule: rule14
  }, {
      start: 2677,
      length: 1,
      convRule: rule92
  }, {
      start: 2678,
      length: 1,
      convRule: rule2
  }, {
      start: 2689,
      length: 2,
      convRule: rule92
  }, {
      start: 2691,
      length: 1,
      convRule: rule124
  }, {
      start: 2693,
      length: 9,
      convRule: rule14
  }, {
      start: 2703,
      length: 3,
      convRule: rule14
  }, {
      start: 2707,
      length: 22,
      convRule: rule14
  }, {
      start: 2730,
      length: 7,
      convRule: rule14
  }, {
      start: 2738,
      length: 2,
      convRule: rule14
  }, {
      start: 2741,
      length: 5,
      convRule: rule14
  }, {
      start: 2748,
      length: 1,
      convRule: rule92
  }, {
      start: 2749,
      length: 1,
      convRule: rule14
  }, {
      start: 2750,
      length: 3,
      convRule: rule124
  }, {
      start: 2753,
      length: 5,
      convRule: rule92
  }, {
      start: 2759,
      length: 2,
      convRule: rule92
  }, {
      start: 2761,
      length: 1,
      convRule: rule124
  }, {
      start: 2763,
      length: 2,
      convRule: rule124
  }, {
      start: 2765,
      length: 1,
      convRule: rule92
  }, {
      start: 2768,
      length: 1,
      convRule: rule14
  }, {
      start: 2784,
      length: 2,
      convRule: rule14
  }, {
      start: 2786,
      length: 2,
      convRule: rule92
  }, {
      start: 2790,
      length: 10,
      convRule: rule8
  }, {
      start: 2800,
      length: 1,
      convRule: rule2
  }, {
      start: 2801,
      length: 1,
      convRule: rule3
  }, {
      start: 2809,
      length: 1,
      convRule: rule14
  }, {
      start: 2810,
      length: 6,
      convRule: rule92
  }, {
      start: 2817,
      length: 1,
      convRule: rule92
  }, {
      start: 2818,
      length: 2,
      convRule: rule124
  }, {
      start: 2821,
      length: 8,
      convRule: rule14
  }, {
      start: 2831,
      length: 2,
      convRule: rule14
  }, {
      start: 2835,
      length: 22,
      convRule: rule14
  }, {
      start: 2858,
      length: 7,
      convRule: rule14
  }, {
      start: 2866,
      length: 2,
      convRule: rule14
  }, {
      start: 2869,
      length: 5,
      convRule: rule14
  }, {
      start: 2876,
      length: 1,
      convRule: rule92
  }, {
      start: 2877,
      length: 1,
      convRule: rule14
  }, {
      start: 2878,
      length: 1,
      convRule: rule124
  }, {
      start: 2879,
      length: 1,
      convRule: rule92
  }, {
      start: 2880,
      length: 1,
      convRule: rule124
  }, {
      start: 2881,
      length: 4,
      convRule: rule92
  }, {
      start: 2887,
      length: 2,
      convRule: rule124
  }, {
      start: 2891,
      length: 2,
      convRule: rule124
  }, {
      start: 2893,
      length: 1,
      convRule: rule92
  }, {
      start: 2901,
      length: 2,
      convRule: rule92
  }, {
      start: 2903,
      length: 1,
      convRule: rule124
  }, {
      start: 2908,
      length: 2,
      convRule: rule14
  }, {
      start: 2911,
      length: 3,
      convRule: rule14
  }, {
      start: 2914,
      length: 2,
      convRule: rule92
  }, {
      start: 2918,
      length: 10,
      convRule: rule8
  }, {
      start: 2928,
      length: 1,
      convRule: rule13
  }, {
      start: 2929,
      length: 1,
      convRule: rule14
  }, {
      start: 2930,
      length: 6,
      convRule: rule17
  }, {
      start: 2946,
      length: 1,
      convRule: rule92
  }, {
      start: 2947,
      length: 1,
      convRule: rule14
  }, {
      start: 2949,
      length: 6,
      convRule: rule14
  }, {
      start: 2958,
      length: 3,
      convRule: rule14
  }, {
      start: 2962,
      length: 4,
      convRule: rule14
  }, {
      start: 2969,
      length: 2,
      convRule: rule14
  }, {
      start: 2972,
      length: 1,
      convRule: rule14
  }, {
      start: 2974,
      length: 2,
      convRule: rule14
  }, {
      start: 2979,
      length: 2,
      convRule: rule14
  }, {
      start: 2984,
      length: 3,
      convRule: rule14
  }, {
      start: 2990,
      length: 12,
      convRule: rule14
  }, {
      start: 3006,
      length: 2,
      convRule: rule124
  }, {
      start: 3008,
      length: 1,
      convRule: rule92
  }, {
      start: 3009,
      length: 2,
      convRule: rule124
  }, {
      start: 3014,
      length: 3,
      convRule: rule124
  }, {
      start: 3018,
      length: 3,
      convRule: rule124
  }, {
      start: 3021,
      length: 1,
      convRule: rule92
  }, {
      start: 3024,
      length: 1,
      convRule: rule14
  }, {
      start: 3031,
      length: 1,
      convRule: rule124
  }, {
      start: 3046,
      length: 10,
      convRule: rule8
  }, {
      start: 3056,
      length: 3,
      convRule: rule17
  }, {
      start: 3059,
      length: 6,
      convRule: rule13
  }, {
      start: 3065,
      length: 1,
      convRule: rule3
  }, {
      start: 3066,
      length: 1,
      convRule: rule13
  }, {
      start: 3072,
      length: 1,
      convRule: rule92
  }, {
      start: 3073,
      length: 3,
      convRule: rule124
  }, {
      start: 3076,
      length: 1,
      convRule: rule92
  }, {
      start: 3077,
      length: 8,
      convRule: rule14
  }, {
      start: 3086,
      length: 3,
      convRule: rule14
  }, {
      start: 3090,
      length: 23,
      convRule: rule14
  }, {
      start: 3114,
      length: 16,
      convRule: rule14
  }, {
      start: 3133,
      length: 1,
      convRule: rule14
  }, {
      start: 3134,
      length: 3,
      convRule: rule92
  }, {
      start: 3137,
      length: 4,
      convRule: rule124
  }, {
      start: 3142,
      length: 3,
      convRule: rule92
  }, {
      start: 3146,
      length: 4,
      convRule: rule92
  }, {
      start: 3157,
      length: 2,
      convRule: rule92
  }, {
      start: 3160,
      length: 3,
      convRule: rule14
  }, {
      start: 3168,
      length: 2,
      convRule: rule14
  }, {
      start: 3170,
      length: 2,
      convRule: rule92
  }, {
      start: 3174,
      length: 10,
      convRule: rule8
  }, {
      start: 3191,
      length: 1,
      convRule: rule2
  }, {
      start: 3192,
      length: 7,
      convRule: rule17
  }, {
      start: 3199,
      length: 1,
      convRule: rule13
  }, {
      start: 3200,
      length: 1,
      convRule: rule14
  }, {
      start: 3201,
      length: 1,
      convRule: rule92
  }, {
      start: 3202,
      length: 2,
      convRule: rule124
  }, {
      start: 3204,
      length: 1,
      convRule: rule2
  }, {
      start: 3205,
      length: 8,
      convRule: rule14
  }, {
      start: 3214,
      length: 3,
      convRule: rule14
  }, {
      start: 3218,
      length: 23,
      convRule: rule14
  }, {
      start: 3242,
      length: 10,
      convRule: rule14
  }, {
      start: 3253,
      length: 5,
      convRule: rule14
  }, {
      start: 3260,
      length: 1,
      convRule: rule92
  }, {
      start: 3261,
      length: 1,
      convRule: rule14
  }, {
      start: 3262,
      length: 1,
      convRule: rule124
  }, {
      start: 3263,
      length: 1,
      convRule: rule92
  }, {
      start: 3264,
      length: 5,
      convRule: rule124
  }, {
      start: 3270,
      length: 1,
      convRule: rule92
  }, {
      start: 3271,
      length: 2,
      convRule: rule124
  }, {
      start: 3274,
      length: 2,
      convRule: rule124
  }, {
      start: 3276,
      length: 2,
      convRule: rule92
  }, {
      start: 3285,
      length: 2,
      convRule: rule124
  }, {
      start: 3294,
      length: 1,
      convRule: rule14
  }, {
      start: 3296,
      length: 2,
      convRule: rule14
  }, {
      start: 3298,
      length: 2,
      convRule: rule92
  }, {
      start: 3302,
      length: 10,
      convRule: rule8
  }, {
      start: 3313,
      length: 2,
      convRule: rule14
  }, {
      start: 3328,
      length: 2,
      convRule: rule92
  }, {
      start: 3330,
      length: 2,
      convRule: rule124
  }, {
      start: 3332,
      length: 9,
      convRule: rule14
  }, {
      start: 3342,
      length: 3,
      convRule: rule14
  }, {
      start: 3346,
      length: 41,
      convRule: rule14
  }, {
      start: 3387,
      length: 2,
      convRule: rule92
  }, {
      start: 3389,
      length: 1,
      convRule: rule14
  }, {
      start: 3390,
      length: 3,
      convRule: rule124
  }, {
      start: 3393,
      length: 4,
      convRule: rule92
  }, {
      start: 3398,
      length: 3,
      convRule: rule124
  }, {
      start: 3402,
      length: 3,
      convRule: rule124
  }, {
      start: 3405,
      length: 1,
      convRule: rule92
  }, {
      start: 3406,
      length: 1,
      convRule: rule14
  }, {
      start: 3407,
      length: 1,
      convRule: rule13
  }, {
      start: 3412,
      length: 3,
      convRule: rule14
  }, {
      start: 3415,
      length: 1,
      convRule: rule124
  }, {
      start: 3416,
      length: 7,
      convRule: rule17
  }, {
      start: 3423,
      length: 3,
      convRule: rule14
  }, {
      start: 3426,
      length: 2,
      convRule: rule92
  }, {
      start: 3430,
      length: 10,
      convRule: rule8
  }, {
      start: 3440,
      length: 9,
      convRule: rule17
  }, {
      start: 3449,
      length: 1,
      convRule: rule13
  }, {
      start: 3450,
      length: 6,
      convRule: rule14
  }, {
      start: 3457,
      length: 1,
      convRule: rule92
  }, {
      start: 3458,
      length: 2,
      convRule: rule124
  }, {
      start: 3461,
      length: 18,
      convRule: rule14
  }, {
      start: 3482,
      length: 24,
      convRule: rule14
  }, {
      start: 3507,
      length: 9,
      convRule: rule14
  }, {
      start: 3517,
      length: 1,
      convRule: rule14
  }, {
      start: 3520,
      length: 7,
      convRule: rule14
  }, {
      start: 3530,
      length: 1,
      convRule: rule92
  }, {
      start: 3535,
      length: 3,
      convRule: rule124
  }, {
      start: 3538,
      length: 3,
      convRule: rule92
  }, {
      start: 3542,
      length: 1,
      convRule: rule92
  }, {
      start: 3544,
      length: 8,
      convRule: rule124
  }, {
      start: 3558,
      length: 10,
      convRule: rule8
  }, {
      start: 3570,
      length: 2,
      convRule: rule124
  }, {
      start: 3572,
      length: 1,
      convRule: rule2
  }, {
      start: 3585,
      length: 48,
      convRule: rule14
  }, {
      start: 3633,
      length: 1,
      convRule: rule92
  }, {
      start: 3634,
      length: 2,
      convRule: rule14
  }, {
      start: 3636,
      length: 7,
      convRule: rule92
  }, {
      start: 3647,
      length: 1,
      convRule: rule3
  }, {
      start: 3648,
      length: 6,
      convRule: rule14
  }, {
      start: 3654,
      length: 1,
      convRule: rule91
  }, {
      start: 3655,
      length: 8,
      convRule: rule92
  }, {
      start: 3663,
      length: 1,
      convRule: rule2
  }, {
      start: 3664,
      length: 10,
      convRule: rule8
  }, {
      start: 3674,
      length: 2,
      convRule: rule2
  }, {
      start: 3713,
      length: 2,
      convRule: rule14
  }, {
      start: 3716,
      length: 1,
      convRule: rule14
  }, {
      start: 3718,
      length: 5,
      convRule: rule14
  }, {
      start: 3724,
      length: 24,
      convRule: rule14
  }, {
      start: 3749,
      length: 1,
      convRule: rule14
  }, {
      start: 3751,
      length: 10,
      convRule: rule14
  }, {
      start: 3761,
      length: 1,
      convRule: rule92
  }, {
      start: 3762,
      length: 2,
      convRule: rule14
  }, {
      start: 3764,
      length: 9,
      convRule: rule92
  }, {
      start: 3773,
      length: 1,
      convRule: rule14
  }, {
      start: 3776,
      length: 5,
      convRule: rule14
  }, {
      start: 3782,
      length: 1,
      convRule: rule91
  }, {
      start: 3784,
      length: 6,
      convRule: rule92
  }, {
      start: 3792,
      length: 10,
      convRule: rule8
  }, {
      start: 3804,
      length: 4,
      convRule: rule14
  }, {
      start: 3840,
      length: 1,
      convRule: rule14
  }, {
      start: 3841,
      length: 3,
      convRule: rule13
  }, {
      start: 3844,
      length: 15,
      convRule: rule2
  }, {
      start: 3859,
      length: 1,
      convRule: rule13
  }, {
      start: 3860,
      length: 1,
      convRule: rule2
  }, {
      start: 3861,
      length: 3,
      convRule: rule13
  }, {
      start: 3864,
      length: 2,
      convRule: rule92
  }, {
      start: 3866,
      length: 6,
      convRule: rule13
  }, {
      start: 3872,
      length: 10,
      convRule: rule8
  }, {
      start: 3882,
      length: 10,
      convRule: rule17
  }, {
      start: 3892,
      length: 1,
      convRule: rule13
  }, {
      start: 3893,
      length: 1,
      convRule: rule92
  }, {
      start: 3894,
      length: 1,
      convRule: rule13
  }, {
      start: 3895,
      length: 1,
      convRule: rule92
  }, {
      start: 3896,
      length: 1,
      convRule: rule13
  }, {
      start: 3897,
      length: 1,
      convRule: rule92
  }, {
      start: 3898,
      length: 1,
      convRule: rule4
  }, {
      start: 3899,
      length: 1,
      convRule: rule5
  }, {
      start: 3900,
      length: 1,
      convRule: rule4
  }, {
      start: 3901,
      length: 1,
      convRule: rule5
  }, {
      start: 3902,
      length: 2,
      convRule: rule124
  }, {
      start: 3904,
      length: 8,
      convRule: rule14
  }, {
      start: 3913,
      length: 36,
      convRule: rule14
  }, {
      start: 3953,
      length: 14,
      convRule: rule92
  }, {
      start: 3967,
      length: 1,
      convRule: rule124
  }, {
      start: 3968,
      length: 5,
      convRule: rule92
  }, {
      start: 3973,
      length: 1,
      convRule: rule2
  }, {
      start: 3974,
      length: 2,
      convRule: rule92
  }, {
      start: 3976,
      length: 5,
      convRule: rule14
  }, {
      start: 3981,
      length: 11,
      convRule: rule92
  }, {
      start: 3993,
      length: 36,
      convRule: rule92
  }, {
      start: 4030,
      length: 8,
      convRule: rule13
  }, {
      start: 4038,
      length: 1,
      convRule: rule92
  }, {
      start: 4039,
      length: 6,
      convRule: rule13
  }, {
      start: 4046,
      length: 2,
      convRule: rule13
  }, {
      start: 4048,
      length: 5,
      convRule: rule2
  }, {
      start: 4053,
      length: 4,
      convRule: rule13
  }, {
      start: 4057,
      length: 2,
      convRule: rule2
  }, {
      start: 4096,
      length: 43,
      convRule: rule14
  }, {
      start: 4139,
      length: 2,
      convRule: rule124
  }, {
      start: 4141,
      length: 4,
      convRule: rule92
  }, {
      start: 4145,
      length: 1,
      convRule: rule124
  }, {
      start: 4146,
      length: 6,
      convRule: rule92
  }, {
      start: 4152,
      length: 1,
      convRule: rule124
  }, {
      start: 4153,
      length: 2,
      convRule: rule92
  }, {
      start: 4155,
      length: 2,
      convRule: rule124
  }, {
      start: 4157,
      length: 2,
      convRule: rule92
  }, {
      start: 4159,
      length: 1,
      convRule: rule14
  }, {
      start: 4160,
      length: 10,
      convRule: rule8
  }, {
      start: 4170,
      length: 6,
      convRule: rule2
  }, {
      start: 4176,
      length: 6,
      convRule: rule14
  }, {
      start: 4182,
      length: 2,
      convRule: rule124
  }, {
      start: 4184,
      length: 2,
      convRule: rule92
  }, {
      start: 4186,
      length: 4,
      convRule: rule14
  }, {
      start: 4190,
      length: 3,
      convRule: rule92
  }, {
      start: 4193,
      length: 1,
      convRule: rule14
  }, {
      start: 4194,
      length: 3,
      convRule: rule124
  }, {
      start: 4197,
      length: 2,
      convRule: rule14
  }, {
      start: 4199,
      length: 7,
      convRule: rule124
  }, {
      start: 4206,
      length: 3,
      convRule: rule14
  }, {
      start: 4209,
      length: 4,
      convRule: rule92
  }, {
      start: 4213,
      length: 13,
      convRule: rule14
  }, {
      start: 4226,
      length: 1,
      convRule: rule92
  }, {
      start: 4227,
      length: 2,
      convRule: rule124
  }, {
      start: 4229,
      length: 2,
      convRule: rule92
  }, {
      start: 4231,
      length: 6,
      convRule: rule124
  }, {
      start: 4237,
      length: 1,
      convRule: rule92
  }, {
      start: 4238,
      length: 1,
      convRule: rule14
  }, {
      start: 4239,
      length: 1,
      convRule: rule124
  }, {
      start: 4240,
      length: 10,
      convRule: rule8
  }, {
      start: 4250,
      length: 3,
      convRule: rule124
  }, {
      start: 4253,
      length: 1,
      convRule: rule92
  }, {
      start: 4254,
      length: 2,
      convRule: rule13
  }, {
      start: 4256,
      length: 38,
      convRule: rule125
  }, {
      start: 4295,
      length: 1,
      convRule: rule125
  }, {
      start: 4301,
      length: 1,
      convRule: rule125
  }, {
      start: 4304,
      length: 43,
      convRule: rule126
  }, {
      start: 4347,
      length: 1,
      convRule: rule2
  }, {
      start: 4348,
      length: 1,
      convRule: rule91
  }, {
      start: 4349,
      length: 3,
      convRule: rule126
  }, {
      start: 4352,
      length: 329,
      convRule: rule14
  }, {
      start: 4682,
      length: 4,
      convRule: rule14
  }, {
      start: 4688,
      length: 7,
      convRule: rule14
  }, {
      start: 4696,
      length: 1,
      convRule: rule14
  }, {
      start: 4698,
      length: 4,
      convRule: rule14
  }, {
      start: 4704,
      length: 41,
      convRule: rule14
  }, {
      start: 4746,
      length: 4,
      convRule: rule14
  }, {
      start: 4752,
      length: 33,
      convRule: rule14
  }, {
      start: 4786,
      length: 4,
      convRule: rule14
  }, {
      start: 4792,
      length: 7,
      convRule: rule14
  }, {
      start: 4800,
      length: 1,
      convRule: rule14
  }, {
      start: 4802,
      length: 4,
      convRule: rule14
  }, {
      start: 4808,
      length: 15,
      convRule: rule14
  }, {
      start: 4824,
      length: 57,
      convRule: rule14
  }, {
      start: 4882,
      length: 4,
      convRule: rule14
  }, {
      start: 4888,
      length: 67,
      convRule: rule14
  }, {
      start: 4957,
      length: 3,
      convRule: rule92
  }, {
      start: 4960,
      length: 9,
      convRule: rule2
  }, {
      start: 4969,
      length: 20,
      convRule: rule17
  }, {
      start: 4992,
      length: 16,
      convRule: rule14
  }, {
      start: 5008,
      length: 10,
      convRule: rule13
  }, {
      start: 5024,
      length: 80,
      convRule: rule127
  }, {
      start: 5104,
      length: 6,
      convRule: rule104
  }, {
      start: 5112,
      length: 6,
      convRule: rule110
  }, {
      start: 5120,
      length: 1,
      convRule: rule7
  }, {
      start: 5121,
      length: 620,
      convRule: rule14
  }, {
      start: 5741,
      length: 1,
      convRule: rule13
  }, {
      start: 5742,
      length: 1,
      convRule: rule2
  }, {
      start: 5743,
      length: 17,
      convRule: rule14
  }, {
      start: 5760,
      length: 1,
      convRule: rule1
  }, {
      start: 5761,
      length: 26,
      convRule: rule14
  }, {
      start: 5787,
      length: 1,
      convRule: rule4
  }, {
      start: 5788,
      length: 1,
      convRule: rule5
  }, {
      start: 5792,
      length: 75,
      convRule: rule14
  }, {
      start: 5867,
      length: 3,
      convRule: rule2
  }, {
      start: 5870,
      length: 3,
      convRule: rule128
  }, {
      start: 5873,
      length: 8,
      convRule: rule14
  }, {
      start: 5888,
      length: 13,
      convRule: rule14
  }, {
      start: 5902,
      length: 4,
      convRule: rule14
  }, {
      start: 5906,
      length: 3,
      convRule: rule92
  }, {
      start: 5920,
      length: 18,
      convRule: rule14
  }, {
      start: 5938,
      length: 3,
      convRule: rule92
  }, {
      start: 5941,
      length: 2,
      convRule: rule2
  }, {
      start: 5952,
      length: 18,
      convRule: rule14
  }, {
      start: 5970,
      length: 2,
      convRule: rule92
  }, {
      start: 5984,
      length: 13,
      convRule: rule14
  }, {
      start: 5998,
      length: 3,
      convRule: rule14
  }, {
      start: 6002,
      length: 2,
      convRule: rule92
  }, {
      start: 6016,
      length: 52,
      convRule: rule14
  }, {
      start: 6068,
      length: 2,
      convRule: rule92
  }, {
      start: 6070,
      length: 1,
      convRule: rule124
  }, {
      start: 6071,
      length: 7,
      convRule: rule92
  }, {
      start: 6078,
      length: 8,
      convRule: rule124
  }, {
      start: 6086,
      length: 1,
      convRule: rule92
  }, {
      start: 6087,
      length: 2,
      convRule: rule124
  }, {
      start: 6089,
      length: 11,
      convRule: rule92
  }, {
      start: 6100,
      length: 3,
      convRule: rule2
  }, {
      start: 6103,
      length: 1,
      convRule: rule91
  }, {
      start: 6104,
      length: 3,
      convRule: rule2
  }, {
      start: 6107,
      length: 1,
      convRule: rule3
  }, {
      start: 6108,
      length: 1,
      convRule: rule14
  }, {
      start: 6109,
      length: 1,
      convRule: rule92
  }, {
      start: 6112,
      length: 10,
      convRule: rule8
  }, {
      start: 6128,
      length: 10,
      convRule: rule17
  }, {
      start: 6144,
      length: 6,
      convRule: rule2
  }, {
      start: 6150,
      length: 1,
      convRule: rule7
  }, {
      start: 6151,
      length: 4,
      convRule: rule2
  }, {
      start: 6155,
      length: 3,
      convRule: rule92
  }, {
      start: 6158,
      length: 1,
      convRule: rule16
  }, {
      start: 6160,
      length: 10,
      convRule: rule8
  }, {
      start: 6176,
      length: 35,
      convRule: rule14
  }, {
      start: 6211,
      length: 1,
      convRule: rule91
  }, {
      start: 6212,
      length: 53,
      convRule: rule14
  }, {
      start: 6272,
      length: 5,
      convRule: rule14
  }, {
      start: 6277,
      length: 2,
      convRule: rule92
  }, {
      start: 6279,
      length: 34,
      convRule: rule14
  }, {
      start: 6313,
      length: 1,
      convRule: rule92
  }, {
      start: 6314,
      length: 1,
      convRule: rule14
  }, {
      start: 6320,
      length: 70,
      convRule: rule14
  }, {
      start: 6400,
      length: 31,
      convRule: rule14
  }, {
      start: 6432,
      length: 3,
      convRule: rule92
  }, {
      start: 6435,
      length: 4,
      convRule: rule124
  }, {
      start: 6439,
      length: 2,
      convRule: rule92
  }, {
      start: 6441,
      length: 3,
      convRule: rule124
  }, {
      start: 6448,
      length: 2,
      convRule: rule124
  }, {
      start: 6450,
      length: 1,
      convRule: rule92
  }, {
      start: 6451,
      length: 6,
      convRule: rule124
  }, {
      start: 6457,
      length: 3,
      convRule: rule92
  }, {
      start: 6464,
      length: 1,
      convRule: rule13
  }, {
      start: 6468,
      length: 2,
      convRule: rule2
  }, {
      start: 6470,
      length: 10,
      convRule: rule8
  }, {
      start: 6480,
      length: 30,
      convRule: rule14
  }, {
      start: 6512,
      length: 5,
      convRule: rule14
  }, {
      start: 6528,
      length: 44,
      convRule: rule14
  }, {
      start: 6576,
      length: 26,
      convRule: rule14
  }, {
      start: 6608,
      length: 10,
      convRule: rule8
  }, {
      start: 6618,
      length: 1,
      convRule: rule17
  }, {
      start: 6622,
      length: 34,
      convRule: rule13
  }, {
      start: 6656,
      length: 23,
      convRule: rule14
  }, {
      start: 6679,
      length: 2,
      convRule: rule92
  }, {
      start: 6681,
      length: 2,
      convRule: rule124
  }, {
      start: 6683,
      length: 1,
      convRule: rule92
  }, {
      start: 6686,
      length: 2,
      convRule: rule2
  }, {
      start: 6688,
      length: 53,
      convRule: rule14
  }, {
      start: 6741,
      length: 1,
      convRule: rule124
  }, {
      start: 6742,
      length: 1,
      convRule: rule92
  }, {
      start: 6743,
      length: 1,
      convRule: rule124
  }, {
      start: 6744,
      length: 7,
      convRule: rule92
  }, {
      start: 6752,
      length: 1,
      convRule: rule92
  }, {
      start: 6753,
      length: 1,
      convRule: rule124
  }, {
      start: 6754,
      length: 1,
      convRule: rule92
  }, {
      start: 6755,
      length: 2,
      convRule: rule124
  }, {
      start: 6757,
      length: 8,
      convRule: rule92
  }, {
      start: 6765,
      length: 6,
      convRule: rule124
  }, {
      start: 6771,
      length: 10,
      convRule: rule92
  }, {
      start: 6783,
      length: 1,
      convRule: rule92
  }, {
      start: 6784,
      length: 10,
      convRule: rule8
  }, {
      start: 6800,
      length: 10,
      convRule: rule8
  }, {
      start: 6816,
      length: 7,
      convRule: rule2
  }, {
      start: 6823,
      length: 1,
      convRule: rule91
  }, {
      start: 6824,
      length: 6,
      convRule: rule2
  }, {
      start: 6832,
      length: 14,
      convRule: rule92
  }, {
      start: 6846,
      length: 1,
      convRule: rule119
  }, {
      start: 6847,
      length: 2,
      convRule: rule92
  }, {
      start: 6912,
      length: 4,
      convRule: rule92
  }, {
      start: 6916,
      length: 1,
      convRule: rule124
  }, {
      start: 6917,
      length: 47,
      convRule: rule14
  }, {
      start: 6964,
      length: 1,
      convRule: rule92
  }, {
      start: 6965,
      length: 1,
      convRule: rule124
  }, {
      start: 6966,
      length: 5,
      convRule: rule92
  }, {
      start: 6971,
      length: 1,
      convRule: rule124
  }, {
      start: 6972,
      length: 1,
      convRule: rule92
  }, {
      start: 6973,
      length: 5,
      convRule: rule124
  }, {
      start: 6978,
      length: 1,
      convRule: rule92
  }, {
      start: 6979,
      length: 2,
      convRule: rule124
  }, {
      start: 6981,
      length: 7,
      convRule: rule14
  }, {
      start: 6992,
      length: 10,
      convRule: rule8
  }, {
      start: 7002,
      length: 7,
      convRule: rule2
  }, {
      start: 7009,
      length: 10,
      convRule: rule13
  }, {
      start: 7019,
      length: 9,
      convRule: rule92
  }, {
      start: 7028,
      length: 9,
      convRule: rule13
  }, {
      start: 7040,
      length: 2,
      convRule: rule92
  }, {
      start: 7042,
      length: 1,
      convRule: rule124
  }, {
      start: 7043,
      length: 30,
      convRule: rule14
  }, {
      start: 7073,
      length: 1,
      convRule: rule124
  }, {
      start: 7074,
      length: 4,
      convRule: rule92
  }, {
      start: 7078,
      length: 2,
      convRule: rule124
  }, {
      start: 7080,
      length: 2,
      convRule: rule92
  }, {
      start: 7082,
      length: 1,
      convRule: rule124
  }, {
      start: 7083,
      length: 3,
      convRule: rule92
  }, {
      start: 7086,
      length: 2,
      convRule: rule14
  }, {
      start: 7088,
      length: 10,
      convRule: rule8
  }, {
      start: 7098,
      length: 44,
      convRule: rule14
  }, {
      start: 7142,
      length: 1,
      convRule: rule92
  }, {
      start: 7143,
      length: 1,
      convRule: rule124
  }, {
      start: 7144,
      length: 2,
      convRule: rule92
  }, {
      start: 7146,
      length: 3,
      convRule: rule124
  }, {
      start: 7149,
      length: 1,
      convRule: rule92
  }, {
      start: 7150,
      length: 1,
      convRule: rule124
  }, {
      start: 7151,
      length: 3,
      convRule: rule92
  }, {
      start: 7154,
      length: 2,
      convRule: rule124
  }, {
      start: 7164,
      length: 4,
      convRule: rule2
  }, {
      start: 7168,
      length: 36,
      convRule: rule14
  }, {
      start: 7204,
      length: 8,
      convRule: rule124
  }, {
      start: 7212,
      length: 8,
      convRule: rule92
  }, {
      start: 7220,
      length: 2,
      convRule: rule124
  }, {
      start: 7222,
      length: 2,
      convRule: rule92
  }, {
      start: 7227,
      length: 5,
      convRule: rule2
  }, {
      start: 7232,
      length: 10,
      convRule: rule8
  }, {
      start: 7245,
      length: 3,
      convRule: rule14
  }, {
      start: 7248,
      length: 10,
      convRule: rule8
  }, {
      start: 7258,
      length: 30,
      convRule: rule14
  }, {
      start: 7288,
      length: 6,
      convRule: rule91
  }, {
      start: 7294,
      length: 2,
      convRule: rule2
  }, {
      start: 7296,
      length: 1,
      convRule: rule129
  }, {
      start: 7297,
      length: 1,
      convRule: rule130
  }, {
      start: 7298,
      length: 1,
      convRule: rule131
  }, {
      start: 7299,
      length: 2,
      convRule: rule132
  }, {
      start: 7301,
      length: 1,
      convRule: rule133
  }, {
      start: 7302,
      length: 1,
      convRule: rule134
  }, {
      start: 7303,
      length: 1,
      convRule: rule135
  }, {
      start: 7304,
      length: 1,
      convRule: rule136
  }, {
      start: 7312,
      length: 43,
      convRule: rule137
  }, {
      start: 7357,
      length: 3,
      convRule: rule137
  }, {
      start: 7360,
      length: 8,
      convRule: rule2
  }, {
      start: 7376,
      length: 3,
      convRule: rule92
  }, {
      start: 7379,
      length: 1,
      convRule: rule2
  }, {
      start: 7380,
      length: 13,
      convRule: rule92
  }, {
      start: 7393,
      length: 1,
      convRule: rule124
  }, {
      start: 7394,
      length: 7,
      convRule: rule92
  }, {
      start: 7401,
      length: 4,
      convRule: rule14
  }, {
      start: 7405,
      length: 1,
      convRule: rule92
  }, {
      start: 7406,
      length: 6,
      convRule: rule14
  }, {
      start: 7412,
      length: 1,
      convRule: rule92
  }, {
      start: 7413,
      length: 2,
      convRule: rule14
  }, {
      start: 7415,
      length: 1,
      convRule: rule124
  }, {
      start: 7416,
      length: 2,
      convRule: rule92
  }, {
      start: 7418,
      length: 1,
      convRule: rule14
  }, {
      start: 7424,
      length: 44,
      convRule: rule20
  }, {
      start: 7468,
      length: 63,
      convRule: rule91
  }, {
      start: 7531,
      length: 13,
      convRule: rule20
  }, {
      start: 7544,
      length: 1,
      convRule: rule91
  }, {
      start: 7545,
      length: 1,
      convRule: rule138
  }, {
      start: 7546,
      length: 3,
      convRule: rule20
  }, {
      start: 7549,
      length: 1,
      convRule: rule139
  }, {
      start: 7550,
      length: 16,
      convRule: rule20
  }, {
      start: 7566,
      length: 1,
      convRule: rule140
  }, {
      start: 7567,
      length: 12,
      convRule: rule20
  }, {
      start: 7579,
      length: 37,
      convRule: rule91
  }, {
      start: 7616,
      length: 58,
      convRule: rule92
  }, {
      start: 7675,
      length: 5,
      convRule: rule92
  }, {
      start: 7680,
      length: 1,
      convRule: rule22
  }, {
      start: 7681,
      length: 1,
      convRule: rule23
  }, {
      start: 7682,
      length: 1,
      convRule: rule22
  }, {
      start: 7683,
      length: 1,
      convRule: rule23
  }, {
      start: 7684,
      length: 1,
      convRule: rule22
  }, {
      start: 7685,
      length: 1,
      convRule: rule23
  }, {
      start: 7686,
      length: 1,
      convRule: rule22
  }, {
      start: 7687,
      length: 1,
      convRule: rule23
  }, {
      start: 7688,
      length: 1,
      convRule: rule22
  }, {
      start: 7689,
      length: 1,
      convRule: rule23
  }, {
      start: 7690,
      length: 1,
      convRule: rule22
  }, {
      start: 7691,
      length: 1,
      convRule: rule23
  }, {
      start: 7692,
      length: 1,
      convRule: rule22
  }, {
      start: 7693,
      length: 1,
      convRule: rule23
  }, {
      start: 7694,
      length: 1,
      convRule: rule22
  }, {
      start: 7695,
      length: 1,
      convRule: rule23
  }, {
      start: 7696,
      length: 1,
      convRule: rule22
  }, {
      start: 7697,
      length: 1,
      convRule: rule23
  }, {
      start: 7698,
      length: 1,
      convRule: rule22
  }, {
      start: 7699,
      length: 1,
      convRule: rule23
  }, {
      start: 7700,
      length: 1,
      convRule: rule22
  }, {
      start: 7701,
      length: 1,
      convRule: rule23
  }, {
      start: 7702,
      length: 1,
      convRule: rule22
  }, {
      start: 7703,
      length: 1,
      convRule: rule23
  }, {
      start: 7704,
      length: 1,
      convRule: rule22
  }, {
      start: 7705,
      length: 1,
      convRule: rule23
  }, {
      start: 7706,
      length: 1,
      convRule: rule22
  }, {
      start: 7707,
      length: 1,
      convRule: rule23
  }, {
      start: 7708,
      length: 1,
      convRule: rule22
  }, {
      start: 7709,
      length: 1,
      convRule: rule23
  }, {
      start: 7710,
      length: 1,
      convRule: rule22
  }, {
      start: 7711,
      length: 1,
      convRule: rule23
  }, {
      start: 7712,
      length: 1,
      convRule: rule22
  }, {
      start: 7713,
      length: 1,
      convRule: rule23
  }, {
      start: 7714,
      length: 1,
      convRule: rule22
  }, {
      start: 7715,
      length: 1,
      convRule: rule23
  }, {
      start: 7716,
      length: 1,
      convRule: rule22
  }, {
      start: 7717,
      length: 1,
      convRule: rule23
  }, {
      start: 7718,
      length: 1,
      convRule: rule22
  }, {
      start: 7719,
      length: 1,
      convRule: rule23
  }, {
      start: 7720,
      length: 1,
      convRule: rule22
  }, {
      start: 7721,
      length: 1,
      convRule: rule23
  }, {
      start: 7722,
      length: 1,
      convRule: rule22
  }, {
      start: 7723,
      length: 1,
      convRule: rule23
  }, {
      start: 7724,
      length: 1,
      convRule: rule22
  }, {
      start: 7725,
      length: 1,
      convRule: rule23
  }, {
      start: 7726,
      length: 1,
      convRule: rule22
  }, {
      start: 7727,
      length: 1,
      convRule: rule23
  }, {
      start: 7728,
      length: 1,
      convRule: rule22
  }, {
      start: 7729,
      length: 1,
      convRule: rule23
  }, {
      start: 7730,
      length: 1,
      convRule: rule22
  }, {
      start: 7731,
      length: 1,
      convRule: rule23
  }, {
      start: 7732,
      length: 1,
      convRule: rule22
  }, {
      start: 7733,
      length: 1,
      convRule: rule23
  }, {
      start: 7734,
      length: 1,
      convRule: rule22
  }, {
      start: 7735,
      length: 1,
      convRule: rule23
  }, {
      start: 7736,
      length: 1,
      convRule: rule22
  }, {
      start: 7737,
      length: 1,
      convRule: rule23
  }, {
      start: 7738,
      length: 1,
      convRule: rule22
  }, {
      start: 7739,
      length: 1,
      convRule: rule23
  }, {
      start: 7740,
      length: 1,
      convRule: rule22
  }, {
      start: 7741,
      length: 1,
      convRule: rule23
  }, {
      start: 7742,
      length: 1,
      convRule: rule22
  }, {
      start: 7743,
      length: 1,
      convRule: rule23
  }, {
      start: 7744,
      length: 1,
      convRule: rule22
  }, {
      start: 7745,
      length: 1,
      convRule: rule23
  }, {
      start: 7746,
      length: 1,
      convRule: rule22
  }, {
      start: 7747,
      length: 1,
      convRule: rule23
  }, {
      start: 7748,
      length: 1,
      convRule: rule22
  }, {
      start: 7749,
      length: 1,
      convRule: rule23
  }, {
      start: 7750,
      length: 1,
      convRule: rule22
  }, {
      start: 7751,
      length: 1,
      convRule: rule23
  }, {
      start: 7752,
      length: 1,
      convRule: rule22
  }, {
      start: 7753,
      length: 1,
      convRule: rule23
  }, {
      start: 7754,
      length: 1,
      convRule: rule22
  }, {
      start: 7755,
      length: 1,
      convRule: rule23
  }, {
      start: 7756,
      length: 1,
      convRule: rule22
  }, {
      start: 7757,
      length: 1,
      convRule: rule23
  }, {
      start: 7758,
      length: 1,
      convRule: rule22
  }, {
      start: 7759,
      length: 1,
      convRule: rule23
  }, {
      start: 7760,
      length: 1,
      convRule: rule22
  }, {
      start: 7761,
      length: 1,
      convRule: rule23
  }, {
      start: 7762,
      length: 1,
      convRule: rule22
  }, {
      start: 7763,
      length: 1,
      convRule: rule23
  }, {
      start: 7764,
      length: 1,
      convRule: rule22
  }, {
      start: 7765,
      length: 1,
      convRule: rule23
  }, {
      start: 7766,
      length: 1,
      convRule: rule22
  }, {
      start: 7767,
      length: 1,
      convRule: rule23
  }, {
      start: 7768,
      length: 1,
      convRule: rule22
  }, {
      start: 7769,
      length: 1,
      convRule: rule23
  }, {
      start: 7770,
      length: 1,
      convRule: rule22
  }, {
      start: 7771,
      length: 1,
      convRule: rule23
  }, {
      start: 7772,
      length: 1,
      convRule: rule22
  }, {
      start: 7773,
      length: 1,
      convRule: rule23
  }, {
      start: 7774,
      length: 1,
      convRule: rule22
  }, {
      start: 7775,
      length: 1,
      convRule: rule23
  }, {
      start: 7776,
      length: 1,
      convRule: rule22
  }, {
      start: 7777,
      length: 1,
      convRule: rule23
  }, {
      start: 7778,
      length: 1,
      convRule: rule22
  }, {
      start: 7779,
      length: 1,
      convRule: rule23
  }, {
      start: 7780,
      length: 1,
      convRule: rule22
  }, {
      start: 7781,
      length: 1,
      convRule: rule23
  }, {
      start: 7782,
      length: 1,
      convRule: rule22
  }, {
      start: 7783,
      length: 1,
      convRule: rule23
  }, {
      start: 7784,
      length: 1,
      convRule: rule22
  }, {
      start: 7785,
      length: 1,
      convRule: rule23
  }, {
      start: 7786,
      length: 1,
      convRule: rule22
  }, {
      start: 7787,
      length: 1,
      convRule: rule23
  }, {
      start: 7788,
      length: 1,
      convRule: rule22
  }, {
      start: 7789,
      length: 1,
      convRule: rule23
  }, {
      start: 7790,
      length: 1,
      convRule: rule22
  }, {
      start: 7791,
      length: 1,
      convRule: rule23
  }, {
      start: 7792,
      length: 1,
      convRule: rule22
  }, {
      start: 7793,
      length: 1,
      convRule: rule23
  }, {
      start: 7794,
      length: 1,
      convRule: rule22
  }, {
      start: 7795,
      length: 1,
      convRule: rule23
  }, {
      start: 7796,
      length: 1,
      convRule: rule22
  }, {
      start: 7797,
      length: 1,
      convRule: rule23
  }, {
      start: 7798,
      length: 1,
      convRule: rule22
  }, {
      start: 7799,
      length: 1,
      convRule: rule23
  }, {
      start: 7800,
      length: 1,
      convRule: rule22
  }, {
      start: 7801,
      length: 1,
      convRule: rule23
  }, {
      start: 7802,
      length: 1,
      convRule: rule22
  }, {
      start: 7803,
      length: 1,
      convRule: rule23
  }, {
      start: 7804,
      length: 1,
      convRule: rule22
  }, {
      start: 7805,
      length: 1,
      convRule: rule23
  }, {
      start: 7806,
      length: 1,
      convRule: rule22
  }, {
      start: 7807,
      length: 1,
      convRule: rule23
  }, {
      start: 7808,
      length: 1,
      convRule: rule22
  }, {
      start: 7809,
      length: 1,
      convRule: rule23
  }, {
      start: 7810,
      length: 1,
      convRule: rule22
  }, {
      start: 7811,
      length: 1,
      convRule: rule23
  }, {
      start: 7812,
      length: 1,
      convRule: rule22
  }, {
      start: 7813,
      length: 1,
      convRule: rule23
  }, {
      start: 7814,
      length: 1,
      convRule: rule22
  }, {
      start: 7815,
      length: 1,
      convRule: rule23
  }, {
      start: 7816,
      length: 1,
      convRule: rule22
  }, {
      start: 7817,
      length: 1,
      convRule: rule23
  }, {
      start: 7818,
      length: 1,
      convRule: rule22
  }, {
      start: 7819,
      length: 1,
      convRule: rule23
  }, {
      start: 7820,
      length: 1,
      convRule: rule22
  }, {
      start: 7821,
      length: 1,
      convRule: rule23
  }, {
      start: 7822,
      length: 1,
      convRule: rule22
  }, {
      start: 7823,
      length: 1,
      convRule: rule23
  }, {
      start: 7824,
      length: 1,
      convRule: rule22
  }, {
      start: 7825,
      length: 1,
      convRule: rule23
  }, {
      start: 7826,
      length: 1,
      convRule: rule22
  }, {
      start: 7827,
      length: 1,
      convRule: rule23
  }, {
      start: 7828,
      length: 1,
      convRule: rule22
  }, {
      start: 7829,
      length: 1,
      convRule: rule23
  }, {
      start: 7830,
      length: 5,
      convRule: rule20
  }, {
      start: 7835,
      length: 1,
      convRule: rule141
  }, {
      start: 7836,
      length: 2,
      convRule: rule20
  }, {
      start: 7838,
      length: 1,
      convRule: rule142
  }, {
      start: 7839,
      length: 1,
      convRule: rule20
  }, {
      start: 7840,
      length: 1,
      convRule: rule22
  }, {
      start: 7841,
      length: 1,
      convRule: rule23
  }, {
      start: 7842,
      length: 1,
      convRule: rule22
  }, {
      start: 7843,
      length: 1,
      convRule: rule23
  }, {
      start: 7844,
      length: 1,
      convRule: rule22
  }, {
      start: 7845,
      length: 1,
      convRule: rule23
  }, {
      start: 7846,
      length: 1,
      convRule: rule22
  }, {
      start: 7847,
      length: 1,
      convRule: rule23
  }, {
      start: 7848,
      length: 1,
      convRule: rule22
  }, {
      start: 7849,
      length: 1,
      convRule: rule23
  }, {
      start: 7850,
      length: 1,
      convRule: rule22
  }, {
      start: 7851,
      length: 1,
      convRule: rule23
  }, {
      start: 7852,
      length: 1,
      convRule: rule22
  }, {
      start: 7853,
      length: 1,
      convRule: rule23
  }, {
      start: 7854,
      length: 1,
      convRule: rule22
  }, {
      start: 7855,
      length: 1,
      convRule: rule23
  }, {
      start: 7856,
      length: 1,
      convRule: rule22
  }, {
      start: 7857,
      length: 1,
      convRule: rule23
  }, {
      start: 7858,
      length: 1,
      convRule: rule22
  }, {
      start: 7859,
      length: 1,
      convRule: rule23
  }, {
      start: 7860,
      length: 1,
      convRule: rule22
  }, {
      start: 7861,
      length: 1,
      convRule: rule23
  }, {
      start: 7862,
      length: 1,
      convRule: rule22
  }, {
      start: 7863,
      length: 1,
      convRule: rule23
  }, {
      start: 7864,
      length: 1,
      convRule: rule22
  }, {
      start: 7865,
      length: 1,
      convRule: rule23
  }, {
      start: 7866,
      length: 1,
      convRule: rule22
  }, {
      start: 7867,
      length: 1,
      convRule: rule23
  }, {
      start: 7868,
      length: 1,
      convRule: rule22
  }, {
      start: 7869,
      length: 1,
      convRule: rule23
  }, {
      start: 7870,
      length: 1,
      convRule: rule22
  }, {
      start: 7871,
      length: 1,
      convRule: rule23
  }, {
      start: 7872,
      length: 1,
      convRule: rule22
  }, {
      start: 7873,
      length: 1,
      convRule: rule23
  }, {
      start: 7874,
      length: 1,
      convRule: rule22
  }, {
      start: 7875,
      length: 1,
      convRule: rule23
  }, {
      start: 7876,
      length: 1,
      convRule: rule22
  }, {
      start: 7877,
      length: 1,
      convRule: rule23
  }, {
      start: 7878,
      length: 1,
      convRule: rule22
  }, {
      start: 7879,
      length: 1,
      convRule: rule23
  }, {
      start: 7880,
      length: 1,
      convRule: rule22
  }, {
      start: 7881,
      length: 1,
      convRule: rule23
  }, {
      start: 7882,
      length: 1,
      convRule: rule22
  }, {
      start: 7883,
      length: 1,
      convRule: rule23
  }, {
      start: 7884,
      length: 1,
      convRule: rule22
  }, {
      start: 7885,
      length: 1,
      convRule: rule23
  }, {
      start: 7886,
      length: 1,
      convRule: rule22
  }, {
      start: 7887,
      length: 1,
      convRule: rule23
  }, {
      start: 7888,
      length: 1,
      convRule: rule22
  }, {
      start: 7889,
      length: 1,
      convRule: rule23
  }, {
      start: 7890,
      length: 1,
      convRule: rule22
  }, {
      start: 7891,
      length: 1,
      convRule: rule23
  }, {
      start: 7892,
      length: 1,
      convRule: rule22
  }, {
      start: 7893,
      length: 1,
      convRule: rule23
  }, {
      start: 7894,
      length: 1,
      convRule: rule22
  }, {
      start: 7895,
      length: 1,
      convRule: rule23
  }, {
      start: 7896,
      length: 1,
      convRule: rule22
  }, {
      start: 7897,
      length: 1,
      convRule: rule23
  }, {
      start: 7898,
      length: 1,
      convRule: rule22
  }, {
      start: 7899,
      length: 1,
      convRule: rule23
  }, {
      start: 7900,
      length: 1,
      convRule: rule22
  }, {
      start: 7901,
      length: 1,
      convRule: rule23
  }, {
      start: 7902,
      length: 1,
      convRule: rule22
  }, {
      start: 7903,
      length: 1,
      convRule: rule23
  }, {
      start: 7904,
      length: 1,
      convRule: rule22
  }, {
      start: 7905,
      length: 1,
      convRule: rule23
  }, {
      start: 7906,
      length: 1,
      convRule: rule22
  }, {
      start: 7907,
      length: 1,
      convRule: rule23
  }, {
      start: 7908,
      length: 1,
      convRule: rule22
  }, {
      start: 7909,
      length: 1,
      convRule: rule23
  }, {
      start: 7910,
      length: 1,
      convRule: rule22
  }, {
      start: 7911,
      length: 1,
      convRule: rule23
  }, {
      start: 7912,
      length: 1,
      convRule: rule22
  }, {
      start: 7913,
      length: 1,
      convRule: rule23
  }, {
      start: 7914,
      length: 1,
      convRule: rule22
  }, {
      start: 7915,
      length: 1,
      convRule: rule23
  }, {
      start: 7916,
      length: 1,
      convRule: rule22
  }, {
      start: 7917,
      length: 1,
      convRule: rule23
  }, {
      start: 7918,
      length: 1,
      convRule: rule22
  }, {
      start: 7919,
      length: 1,
      convRule: rule23
  }, {
      start: 7920,
      length: 1,
      convRule: rule22
  }, {
      start: 7921,
      length: 1,
      convRule: rule23
  }, {
      start: 7922,
      length: 1,
      convRule: rule22
  }, {
      start: 7923,
      length: 1,
      convRule: rule23
  }, {
      start: 7924,
      length: 1,
      convRule: rule22
  }, {
      start: 7925,
      length: 1,
      convRule: rule23
  }, {
      start: 7926,
      length: 1,
      convRule: rule22
  }, {
      start: 7927,
      length: 1,
      convRule: rule23
  }, {
      start: 7928,
      length: 1,
      convRule: rule22
  }, {
      start: 7929,
      length: 1,
      convRule: rule23
  }, {
      start: 7930,
      length: 1,
      convRule: rule22
  }, {
      start: 7931,
      length: 1,
      convRule: rule23
  }, {
      start: 7932,
      length: 1,
      convRule: rule22
  }, {
      start: 7933,
      length: 1,
      convRule: rule23
  }, {
      start: 7934,
      length: 1,
      convRule: rule22
  }, {
      start: 7935,
      length: 1,
      convRule: rule23
  }, {
      start: 7936,
      length: 8,
      convRule: rule143
  }, {
      start: 7944,
      length: 8,
      convRule: rule144
  }, {
      start: 7952,
      length: 6,
      convRule: rule143
  }, {
      start: 7960,
      length: 6,
      convRule: rule144
  }, {
      start: 7968,
      length: 8,
      convRule: rule143
  }, {
      start: 7976,
      length: 8,
      convRule: rule144
  }, {
      start: 7984,
      length: 8,
      convRule: rule143
  }, {
      start: 7992,
      length: 8,
      convRule: rule144
  }, {
      start: 8000,
      length: 6,
      convRule: rule143
  }, {
      start: 8008,
      length: 6,
      convRule: rule144
  }, {
      start: 8016,
      length: 1,
      convRule: rule20
  }, {
      start: 8017,
      length: 1,
      convRule: rule143
  }, {
      start: 8018,
      length: 1,
      convRule: rule20
  }, {
      start: 8019,
      length: 1,
      convRule: rule143
  }, {
      start: 8020,
      length: 1,
      convRule: rule20
  }, {
      start: 8021,
      length: 1,
      convRule: rule143
  }, {
      start: 8022,
      length: 1,
      convRule: rule20
  }, {
      start: 8023,
      length: 1,
      convRule: rule143
  }, {
      start: 8025,
      length: 1,
      convRule: rule144
  }, {
      start: 8027,
      length: 1,
      convRule: rule144
  }, {
      start: 8029,
      length: 1,
      convRule: rule144
  }, {
      start: 8031,
      length: 1,
      convRule: rule144
  }, {
      start: 8032,
      length: 8,
      convRule: rule143
  }, {
      start: 8040,
      length: 8,
      convRule: rule144
  }, {
      start: 8048,
      length: 2,
      convRule: rule145
  }, {
      start: 8050,
      length: 4,
      convRule: rule146
  }, {
      start: 8054,
      length: 2,
      convRule: rule147
  }, {
      start: 8056,
      length: 2,
      convRule: rule148
  }, {
      start: 8058,
      length: 2,
      convRule: rule149
  }, {
      start: 8060,
      length: 2,
      convRule: rule150
  }, {
      start: 8064,
      length: 8,
      convRule: rule143
  }, {
      start: 8072,
      length: 8,
      convRule: rule151
  }, {
      start: 8080,
      length: 8,
      convRule: rule143
  }, {
      start: 8088,
      length: 8,
      convRule: rule151
  }, {
      start: 8096,
      length: 8,
      convRule: rule143
  }, {
      start: 8104,
      length: 8,
      convRule: rule151
  }, {
      start: 8112,
      length: 2,
      convRule: rule143
  }, {
      start: 8114,
      length: 1,
      convRule: rule20
  }, {
      start: 8115,
      length: 1,
      convRule: rule152
  }, {
      start: 8116,
      length: 1,
      convRule: rule20
  }, {
      start: 8118,
      length: 2,
      convRule: rule20
  }, {
      start: 8120,
      length: 2,
      convRule: rule144
  }, {
      start: 8122,
      length: 2,
      convRule: rule153
  }, {
      start: 8124,
      length: 1,
      convRule: rule154
  }, {
      start: 8125,
      length: 1,
      convRule: rule10
  }, {
      start: 8126,
      length: 1,
      convRule: rule155
  }, {
      start: 8127,
      length: 3,
      convRule: rule10
  }, {
      start: 8130,
      length: 1,
      convRule: rule20
  }, {
      start: 8131,
      length: 1,
      convRule: rule152
  }, {
      start: 8132,
      length: 1,
      convRule: rule20
  }, {
      start: 8134,
      length: 2,
      convRule: rule20
  }, {
      start: 8136,
      length: 4,
      convRule: rule156
  }, {
      start: 8140,
      length: 1,
      convRule: rule154
  }, {
      start: 8141,
      length: 3,
      convRule: rule10
  }, {
      start: 8144,
      length: 2,
      convRule: rule143
  }, {
      start: 8146,
      length: 2,
      convRule: rule20
  }, {
      start: 8150,
      length: 2,
      convRule: rule20
  }, {
      start: 8152,
      length: 2,
      convRule: rule144
  }, {
      start: 8154,
      length: 2,
      convRule: rule157
  }, {
      start: 8157,
      length: 3,
      convRule: rule10
  }, {
      start: 8160,
      length: 2,
      convRule: rule143
  }, {
      start: 8162,
      length: 3,
      convRule: rule20
  }, {
      start: 8165,
      length: 1,
      convRule: rule113
  }, {
      start: 8166,
      length: 2,
      convRule: rule20
  }, {
      start: 8168,
      length: 2,
      convRule: rule144
  }, {
      start: 8170,
      length: 2,
      convRule: rule158
  }, {
      start: 8172,
      length: 1,
      convRule: rule117
  }, {
      start: 8173,
      length: 3,
      convRule: rule10
  }, {
      start: 8178,
      length: 1,
      convRule: rule20
  }, {
      start: 8179,
      length: 1,
      convRule: rule152
  }, {
      start: 8180,
      length: 1,
      convRule: rule20
  }, {
      start: 8182,
      length: 2,
      convRule: rule20
  }, {
      start: 8184,
      length: 2,
      convRule: rule159
  }, {
      start: 8186,
      length: 2,
      convRule: rule160
  }, {
      start: 8188,
      length: 1,
      convRule: rule154
  }, {
      start: 8189,
      length: 2,
      convRule: rule10
  }, {
      start: 8192,
      length: 11,
      convRule: rule1
  }, {
      start: 8203,
      length: 5,
      convRule: rule16
  }, {
      start: 8208,
      length: 6,
      convRule: rule7
  }, {
      start: 8214,
      length: 2,
      convRule: rule2
  }, {
      start: 8216,
      length: 1,
      convRule: rule15
  }, {
      start: 8217,
      length: 1,
      convRule: rule19
  }, {
      start: 8218,
      length: 1,
      convRule: rule4
  }, {
      start: 8219,
      length: 2,
      convRule: rule15
  }, {
      start: 8221,
      length: 1,
      convRule: rule19
  }, {
      start: 8222,
      length: 1,
      convRule: rule4
  }, {
      start: 8223,
      length: 1,
      convRule: rule15
  }, {
      start: 8224,
      length: 8,
      convRule: rule2
  }, {
      start: 8232,
      length: 1,
      convRule: rule161
  }, {
      start: 8233,
      length: 1,
      convRule: rule162
  }, {
      start: 8234,
      length: 5,
      convRule: rule16
  }, {
      start: 8239,
      length: 1,
      convRule: rule1
  }, {
      start: 8240,
      length: 9,
      convRule: rule2
  }, {
      start: 8249,
      length: 1,
      convRule: rule15
  }, {
      start: 8250,
      length: 1,
      convRule: rule19
  }, {
      start: 8251,
      length: 4,
      convRule: rule2
  }, {
      start: 8255,
      length: 2,
      convRule: rule11
  }, {
      start: 8257,
      length: 3,
      convRule: rule2
  }, {
      start: 8260,
      length: 1,
      convRule: rule6
  }, {
      start: 8261,
      length: 1,
      convRule: rule4
  }, {
      start: 8262,
      length: 1,
      convRule: rule5
  }, {
      start: 8263,
      length: 11,
      convRule: rule2
  }, {
      start: 8274,
      length: 1,
      convRule: rule6
  }, {
      start: 8275,
      length: 1,
      convRule: rule2
  }, {
      start: 8276,
      length: 1,
      convRule: rule11
  }, {
      start: 8277,
      length: 10,
      convRule: rule2
  }, {
      start: 8287,
      length: 1,
      convRule: rule1
  }, {
      start: 8288,
      length: 5,
      convRule: rule16
  }, {
      start: 8294,
      length: 10,
      convRule: rule16
  }, {
      start: 8304,
      length: 1,
      convRule: rule17
  }, {
      start: 8305,
      length: 1,
      convRule: rule91
  }, {
      start: 8308,
      length: 6,
      convRule: rule17
  }, {
      start: 8314,
      length: 3,
      convRule: rule6
  }, {
      start: 8317,
      length: 1,
      convRule: rule4
  }, {
      start: 8318,
      length: 1,
      convRule: rule5
  }, {
      start: 8319,
      length: 1,
      convRule: rule91
  }, {
      start: 8320,
      length: 10,
      convRule: rule17
  }, {
      start: 8330,
      length: 3,
      convRule: rule6
  }, {
      start: 8333,
      length: 1,
      convRule: rule4
  }, {
      start: 8334,
      length: 1,
      convRule: rule5
  }, {
      start: 8336,
      length: 13,
      convRule: rule91
  }, {
      start: 8352,
      length: 32,
      convRule: rule3
  }, {
      start: 8400,
      length: 13,
      convRule: rule92
  }, {
      start: 8413,
      length: 4,
      convRule: rule119
  }, {
      start: 8417,
      length: 1,
      convRule: rule92
  }, {
      start: 8418,
      length: 3,
      convRule: rule119
  }, {
      start: 8421,
      length: 12,
      convRule: rule92
  }, {
      start: 8448,
      length: 2,
      convRule: rule13
  }, {
      start: 8450,
      length: 1,
      convRule: rule107
  }, {
      start: 8451,
      length: 4,
      convRule: rule13
  }, {
      start: 8455,
      length: 1,
      convRule: rule107
  }, {
      start: 8456,
      length: 2,
      convRule: rule13
  }, {
      start: 8458,
      length: 1,
      convRule: rule20
  }, {
      start: 8459,
      length: 3,
      convRule: rule107
  }, {
      start: 8462,
      length: 2,
      convRule: rule20
  }, {
      start: 8464,
      length: 3,
      convRule: rule107
  }, {
      start: 8467,
      length: 1,
      convRule: rule20
  }, {
      start: 8468,
      length: 1,
      convRule: rule13
  }, {
      start: 8469,
      length: 1,
      convRule: rule107
  }, {
      start: 8470,
      length: 2,
      convRule: rule13
  }, {
      start: 8472,
      length: 1,
      convRule: rule6
  }, {
      start: 8473,
      length: 5,
      convRule: rule107
  }, {
      start: 8478,
      length: 6,
      convRule: rule13
  }, {
      start: 8484,
      length: 1,
      convRule: rule107
  }, {
      start: 8485,
      length: 1,
      convRule: rule13
  }, {
      start: 8486,
      length: 1,
      convRule: rule163
  }, {
      start: 8487,
      length: 1,
      convRule: rule13
  }, {
      start: 8488,
      length: 1,
      convRule: rule107
  }, {
      start: 8489,
      length: 1,
      convRule: rule13
  }, {
      start: 8490,
      length: 1,
      convRule: rule164
  }, {
      start: 8491,
      length: 1,
      convRule: rule165
  }, {
      start: 8492,
      length: 2,
      convRule: rule107
  }, {
      start: 8494,
      length: 1,
      convRule: rule13
  }, {
      start: 8495,
      length: 1,
      convRule: rule20
  }, {
      start: 8496,
      length: 2,
      convRule: rule107
  }, {
      start: 8498,
      length: 1,
      convRule: rule166
  }, {
      start: 8499,
      length: 1,
      convRule: rule107
  }, {
      start: 8500,
      length: 1,
      convRule: rule20
  }, {
      start: 8501,
      length: 4,
      convRule: rule14
  }, {
      start: 8505,
      length: 1,
      convRule: rule20
  }, {
      start: 8506,
      length: 2,
      convRule: rule13
  }, {
      start: 8508,
      length: 2,
      convRule: rule20
  }, {
      start: 8510,
      length: 2,
      convRule: rule107
  }, {
      start: 8512,
      length: 5,
      convRule: rule6
  }, {
      start: 8517,
      length: 1,
      convRule: rule107
  }, {
      start: 8518,
      length: 4,
      convRule: rule20
  }, {
      start: 8522,
      length: 1,
      convRule: rule13
  }, {
      start: 8523,
      length: 1,
      convRule: rule6
  }, {
      start: 8524,
      length: 2,
      convRule: rule13
  }, {
      start: 8526,
      length: 1,
      convRule: rule167
  }, {
      start: 8527,
      length: 1,
      convRule: rule13
  }, {
      start: 8528,
      length: 16,
      convRule: rule17
  }, {
      start: 8544,
      length: 16,
      convRule: rule168
  }, {
      start: 8560,
      length: 16,
      convRule: rule169
  }, {
      start: 8576,
      length: 3,
      convRule: rule128
  }, {
      start: 8579,
      length: 1,
      convRule: rule22
  }, {
      start: 8580,
      length: 1,
      convRule: rule23
  }, {
      start: 8581,
      length: 4,
      convRule: rule128
  }, {
      start: 8585,
      length: 1,
      convRule: rule17
  }, {
      start: 8586,
      length: 2,
      convRule: rule13
  }, {
      start: 8592,
      length: 5,
      convRule: rule6
  }, {
      start: 8597,
      length: 5,
      convRule: rule13
  }, {
      start: 8602,
      length: 2,
      convRule: rule6
  }, {
      start: 8604,
      length: 4,
      convRule: rule13
  }, {
      start: 8608,
      length: 1,
      convRule: rule6
  }, {
      start: 8609,
      length: 2,
      convRule: rule13
  }, {
      start: 8611,
      length: 1,
      convRule: rule6
  }, {
      start: 8612,
      length: 2,
      convRule: rule13
  }, {
      start: 8614,
      length: 1,
      convRule: rule6
  }, {
      start: 8615,
      length: 7,
      convRule: rule13
  }, {
      start: 8622,
      length: 1,
      convRule: rule6
  }, {
      start: 8623,
      length: 31,
      convRule: rule13
  }, {
      start: 8654,
      length: 2,
      convRule: rule6
  }, {
      start: 8656,
      length: 2,
      convRule: rule13
  }, {
      start: 8658,
      length: 1,
      convRule: rule6
  }, {
      start: 8659,
      length: 1,
      convRule: rule13
  }, {
      start: 8660,
      length: 1,
      convRule: rule6
  }, {
      start: 8661,
      length: 31,
      convRule: rule13
  }, {
      start: 8692,
      length: 268,
      convRule: rule6
  }, {
      start: 8960,
      length: 8,
      convRule: rule13
  }, {
      start: 8968,
      length: 1,
      convRule: rule4
  }, {
      start: 8969,
      length: 1,
      convRule: rule5
  }, {
      start: 8970,
      length: 1,
      convRule: rule4
  }, {
      start: 8971,
      length: 1,
      convRule: rule5
  }, {
      start: 8972,
      length: 20,
      convRule: rule13
  }, {
      start: 8992,
      length: 2,
      convRule: rule6
  }, {
      start: 8994,
      length: 7,
      convRule: rule13
  }, {
      start: 9001,
      length: 1,
      convRule: rule4
  }, {
      start: 9002,
      length: 1,
      convRule: rule5
  }, {
      start: 9003,
      length: 81,
      convRule: rule13
  }, {
      start: 9084,
      length: 1,
      convRule: rule6
  }, {
      start: 9085,
      length: 30,
      convRule: rule13
  }, {
      start: 9115,
      length: 25,
      convRule: rule6
  }, {
      start: 9140,
      length: 40,
      convRule: rule13
  }, {
      start: 9180,
      length: 6,
      convRule: rule6
  }, {
      start: 9186,
      length: 69,
      convRule: rule13
  }, {
      start: 9280,
      length: 11,
      convRule: rule13
  }, {
      start: 9312,
      length: 60,
      convRule: rule17
  }, {
      start: 9372,
      length: 26,
      convRule: rule13
  }, {
      start: 9398,
      length: 26,
      convRule: rule170
  }, {
      start: 9424,
      length: 26,
      convRule: rule171
  }, {
      start: 9450,
      length: 22,
      convRule: rule17
  }, {
      start: 9472,
      length: 183,
      convRule: rule13
  }, {
      start: 9655,
      length: 1,
      convRule: rule6
  }, {
      start: 9656,
      length: 9,
      convRule: rule13
  }, {
      start: 9665,
      length: 1,
      convRule: rule6
  }, {
      start: 9666,
      length: 54,
      convRule: rule13
  }, {
      start: 9720,
      length: 8,
      convRule: rule6
  }, {
      start: 9728,
      length: 111,
      convRule: rule13
  }, {
      start: 9839,
      length: 1,
      convRule: rule6
  }, {
      start: 9840,
      length: 248,
      convRule: rule13
  }, {
      start: 10088,
      length: 1,
      convRule: rule4
  }, {
      start: 10089,
      length: 1,
      convRule: rule5
  }, {
      start: 10090,
      length: 1,
      convRule: rule4
  }, {
      start: 10091,
      length: 1,
      convRule: rule5
  }, {
      start: 10092,
      length: 1,
      convRule: rule4
  }, {
      start: 10093,
      length: 1,
      convRule: rule5
  }, {
      start: 10094,
      length: 1,
      convRule: rule4
  }, {
      start: 10095,
      length: 1,
      convRule: rule5
  }, {
      start: 10096,
      length: 1,
      convRule: rule4
  }, {
      start: 10097,
      length: 1,
      convRule: rule5
  }, {
      start: 10098,
      length: 1,
      convRule: rule4
  }, {
      start: 10099,
      length: 1,
      convRule: rule5
  }, {
      start: 10100,
      length: 1,
      convRule: rule4
  }, {
      start: 10101,
      length: 1,
      convRule: rule5
  }, {
      start: 10102,
      length: 30,
      convRule: rule17
  }, {
      start: 10132,
      length: 44,
      convRule: rule13
  }, {
      start: 10176,
      length: 5,
      convRule: rule6
  }, {
      start: 10181,
      length: 1,
      convRule: rule4
  }, {
      start: 10182,
      length: 1,
      convRule: rule5
  }, {
      start: 10183,
      length: 31,
      convRule: rule6
  }, {
      start: 10214,
      length: 1,
      convRule: rule4
  }, {
      start: 10215,
      length: 1,
      convRule: rule5
  }, {
      start: 10216,
      length: 1,
      convRule: rule4
  }, {
      start: 10217,
      length: 1,
      convRule: rule5
  }, {
      start: 10218,
      length: 1,
      convRule: rule4
  }, {
      start: 10219,
      length: 1,
      convRule: rule5
  }, {
      start: 10220,
      length: 1,
      convRule: rule4
  }, {
      start: 10221,
      length: 1,
      convRule: rule5
  }, {
      start: 10222,
      length: 1,
      convRule: rule4
  }, {
      start: 10223,
      length: 1,
      convRule: rule5
  }, {
      start: 10224,
      length: 16,
      convRule: rule6
  }, {
      start: 10240,
      length: 256,
      convRule: rule13
  }, {
      start: 10496,
      length: 131,
      convRule: rule6
  }, {
      start: 10627,
      length: 1,
      convRule: rule4
  }, {
      start: 10628,
      length: 1,
      convRule: rule5
  }, {
      start: 10629,
      length: 1,
      convRule: rule4
  }, {
      start: 10630,
      length: 1,
      convRule: rule5
  }, {
      start: 10631,
      length: 1,
      convRule: rule4
  }, {
      start: 10632,
      length: 1,
      convRule: rule5
  }, {
      start: 10633,
      length: 1,
      convRule: rule4
  }, {
      start: 10634,
      length: 1,
      convRule: rule5
  }, {
      start: 10635,
      length: 1,
      convRule: rule4
  }, {
      start: 10636,
      length: 1,
      convRule: rule5
  }, {
      start: 10637,
      length: 1,
      convRule: rule4
  }, {
      start: 10638,
      length: 1,
      convRule: rule5
  }, {
      start: 10639,
      length: 1,
      convRule: rule4
  }, {
      start: 10640,
      length: 1,
      convRule: rule5
  }, {
      start: 10641,
      length: 1,
      convRule: rule4
  }, {
      start: 10642,
      length: 1,
      convRule: rule5
  }, {
      start: 10643,
      length: 1,
      convRule: rule4
  }, {
      start: 10644,
      length: 1,
      convRule: rule5
  }, {
      start: 10645,
      length: 1,
      convRule: rule4
  }, {
      start: 10646,
      length: 1,
      convRule: rule5
  }, {
      start: 10647,
      length: 1,
      convRule: rule4
  }, {
      start: 10648,
      length: 1,
      convRule: rule5
  }, {
      start: 10649,
      length: 63,
      convRule: rule6
  }, {
      start: 10712,
      length: 1,
      convRule: rule4
  }, {
      start: 10713,
      length: 1,
      convRule: rule5
  }, {
      start: 10714,
      length: 1,
      convRule: rule4
  }, {
      start: 10715,
      length: 1,
      convRule: rule5
  }, {
      start: 10716,
      length: 32,
      convRule: rule6
  }, {
      start: 10748,
      length: 1,
      convRule: rule4
  }, {
      start: 10749,
      length: 1,
      convRule: rule5
  }, {
      start: 10750,
      length: 258,
      convRule: rule6
  }, {
      start: 11008,
      length: 48,
      convRule: rule13
  }, {
      start: 11056,
      length: 21,
      convRule: rule6
  }, {
      start: 11077,
      length: 2,
      convRule: rule13
  }, {
      start: 11079,
      length: 6,
      convRule: rule6
  }, {
      start: 11085,
      length: 39,
      convRule: rule13
  }, {
      start: 11126,
      length: 32,
      convRule: rule13
  }, {
      start: 11159,
      length: 105,
      convRule: rule13
  }, {
      start: 11264,
      length: 47,
      convRule: rule122
  }, {
      start: 11312,
      length: 47,
      convRule: rule123
  }, {
      start: 11360,
      length: 1,
      convRule: rule22
  }, {
      start: 11361,
      length: 1,
      convRule: rule23
  }, {
      start: 11362,
      length: 1,
      convRule: rule172
  }, {
      start: 11363,
      length: 1,
      convRule: rule173
  }, {
      start: 11364,
      length: 1,
      convRule: rule174
  }, {
      start: 11365,
      length: 1,
      convRule: rule175
  }, {
      start: 11366,
      length: 1,
      convRule: rule176
  }, {
      start: 11367,
      length: 1,
      convRule: rule22
  }, {
      start: 11368,
      length: 1,
      convRule: rule23
  }, {
      start: 11369,
      length: 1,
      convRule: rule22
  }, {
      start: 11370,
      length: 1,
      convRule: rule23
  }, {
      start: 11371,
      length: 1,
      convRule: rule22
  }, {
      start: 11372,
      length: 1,
      convRule: rule23
  }, {
      start: 11373,
      length: 1,
      convRule: rule177
  }, {
      start: 11374,
      length: 1,
      convRule: rule178
  }, {
      start: 11375,
      length: 1,
      convRule: rule179
  }, {
      start: 11376,
      length: 1,
      convRule: rule180
  }, {
      start: 11377,
      length: 1,
      convRule: rule20
  }, {
      start: 11378,
      length: 1,
      convRule: rule22
  }, {
      start: 11379,
      length: 1,
      convRule: rule23
  }, {
      start: 11380,
      length: 1,
      convRule: rule20
  }, {
      start: 11381,
      length: 1,
      convRule: rule22
  }, {
      start: 11382,
      length: 1,
      convRule: rule23
  }, {
      start: 11383,
      length: 5,
      convRule: rule20
  }, {
      start: 11388,
      length: 2,
      convRule: rule91
  }, {
      start: 11390,
      length: 2,
      convRule: rule181
  }, {
      start: 11392,
      length: 1,
      convRule: rule22
  }, {
      start: 11393,
      length: 1,
      convRule: rule23
  }, {
      start: 11394,
      length: 1,
      convRule: rule22
  }, {
      start: 11395,
      length: 1,
      convRule: rule23
  }, {
      start: 11396,
      length: 1,
      convRule: rule22
  }, {
      start: 11397,
      length: 1,
      convRule: rule23
  }, {
      start: 11398,
      length: 1,
      convRule: rule22
  }, {
      start: 11399,
      length: 1,
      convRule: rule23
  }, {
      start: 11400,
      length: 1,
      convRule: rule22
  }, {
      start: 11401,
      length: 1,
      convRule: rule23
  }, {
      start: 11402,
      length: 1,
      convRule: rule22
  }, {
      start: 11403,
      length: 1,
      convRule: rule23
  }, {
      start: 11404,
      length: 1,
      convRule: rule22
  }, {
      start: 11405,
      length: 1,
      convRule: rule23
  }, {
      start: 11406,
      length: 1,
      convRule: rule22
  }, {
      start: 11407,
      length: 1,
      convRule: rule23
  }, {
      start: 11408,
      length: 1,
      convRule: rule22
  }, {
      start: 11409,
      length: 1,
      convRule: rule23
  }, {
      start: 11410,
      length: 1,
      convRule: rule22
  }, {
      start: 11411,
      length: 1,
      convRule: rule23
  }, {
      start: 11412,
      length: 1,
      convRule: rule22
  }, {
      start: 11413,
      length: 1,
      convRule: rule23
  }, {
      start: 11414,
      length: 1,
      convRule: rule22
  }, {
      start: 11415,
      length: 1,
      convRule: rule23
  }, {
      start: 11416,
      length: 1,
      convRule: rule22
  }, {
      start: 11417,
      length: 1,
      convRule: rule23
  }, {
      start: 11418,
      length: 1,
      convRule: rule22
  }, {
      start: 11419,
      length: 1,
      convRule: rule23
  }, {
      start: 11420,
      length: 1,
      convRule: rule22
  }, {
      start: 11421,
      length: 1,
      convRule: rule23
  }, {
      start: 11422,
      length: 1,
      convRule: rule22
  }, {
      start: 11423,
      length: 1,
      convRule: rule23
  }, {
      start: 11424,
      length: 1,
      convRule: rule22
  }, {
      start: 11425,
      length: 1,
      convRule: rule23
  }, {
      start: 11426,
      length: 1,
      convRule: rule22
  }, {
      start: 11427,
      length: 1,
      convRule: rule23
  }, {
      start: 11428,
      length: 1,
      convRule: rule22
  }, {
      start: 11429,
      length: 1,
      convRule: rule23
  }, {
      start: 11430,
      length: 1,
      convRule: rule22
  }, {
      start: 11431,
      length: 1,
      convRule: rule23
  }, {
      start: 11432,
      length: 1,
      convRule: rule22
  }, {
      start: 11433,
      length: 1,
      convRule: rule23
  }, {
      start: 11434,
      length: 1,
      convRule: rule22
  }, {
      start: 11435,
      length: 1,
      convRule: rule23
  }, {
      start: 11436,
      length: 1,
      convRule: rule22
  }, {
      start: 11437,
      length: 1,
      convRule: rule23
  }, {
      start: 11438,
      length: 1,
      convRule: rule22
  }, {
      start: 11439,
      length: 1,
      convRule: rule23
  }, {
      start: 11440,
      length: 1,
      convRule: rule22
  }, {
      start: 11441,
      length: 1,
      convRule: rule23
  }, {
      start: 11442,
      length: 1,
      convRule: rule22
  }, {
      start: 11443,
      length: 1,
      convRule: rule23
  }, {
      start: 11444,
      length: 1,
      convRule: rule22
  }, {
      start: 11445,
      length: 1,
      convRule: rule23
  }, {
      start: 11446,
      length: 1,
      convRule: rule22
  }, {
      start: 11447,
      length: 1,
      convRule: rule23
  }, {
      start: 11448,
      length: 1,
      convRule: rule22
  }, {
      start: 11449,
      length: 1,
      convRule: rule23
  }, {
      start: 11450,
      length: 1,
      convRule: rule22
  }, {
      start: 11451,
      length: 1,
      convRule: rule23
  }, {
      start: 11452,
      length: 1,
      convRule: rule22
  }, {
      start: 11453,
      length: 1,
      convRule: rule23
  }, {
      start: 11454,
      length: 1,
      convRule: rule22
  }, {
      start: 11455,
      length: 1,
      convRule: rule23
  }, {
      start: 11456,
      length: 1,
      convRule: rule22
  }, {
      start: 11457,
      length: 1,
      convRule: rule23
  }, {
      start: 11458,
      length: 1,
      convRule: rule22
  }, {
      start: 11459,
      length: 1,
      convRule: rule23
  }, {
      start: 11460,
      length: 1,
      convRule: rule22
  }, {
      start: 11461,
      length: 1,
      convRule: rule23
  }, {
      start: 11462,
      length: 1,
      convRule: rule22
  }, {
      start: 11463,
      length: 1,
      convRule: rule23
  }, {
      start: 11464,
      length: 1,
      convRule: rule22
  }, {
      start: 11465,
      length: 1,
      convRule: rule23
  }, {
      start: 11466,
      length: 1,
      convRule: rule22
  }, {
      start: 11467,
      length: 1,
      convRule: rule23
  }, {
      start: 11468,
      length: 1,
      convRule: rule22
  }, {
      start: 11469,
      length: 1,
      convRule: rule23
  }, {
      start: 11470,
      length: 1,
      convRule: rule22
  }, {
      start: 11471,
      length: 1,
      convRule: rule23
  }, {
      start: 11472,
      length: 1,
      convRule: rule22
  }, {
      start: 11473,
      length: 1,
      convRule: rule23
  }, {
      start: 11474,
      length: 1,
      convRule: rule22
  }, {
      start: 11475,
      length: 1,
      convRule: rule23
  }, {
      start: 11476,
      length: 1,
      convRule: rule22
  }, {
      start: 11477,
      length: 1,
      convRule: rule23
  }, {
      start: 11478,
      length: 1,
      convRule: rule22
  }, {
      start: 11479,
      length: 1,
      convRule: rule23
  }, {
      start: 11480,
      length: 1,
      convRule: rule22
  }, {
      start: 11481,
      length: 1,
      convRule: rule23
  }, {
      start: 11482,
      length: 1,
      convRule: rule22
  }, {
      start: 11483,
      length: 1,
      convRule: rule23
  }, {
      start: 11484,
      length: 1,
      convRule: rule22
  }, {
      start: 11485,
      length: 1,
      convRule: rule23
  }, {
      start: 11486,
      length: 1,
      convRule: rule22
  }, {
      start: 11487,
      length: 1,
      convRule: rule23
  }, {
      start: 11488,
      length: 1,
      convRule: rule22
  }, {
      start: 11489,
      length: 1,
      convRule: rule23
  }, {
      start: 11490,
      length: 1,
      convRule: rule22
  }, {
      start: 11491,
      length: 1,
      convRule: rule23
  }, {
      start: 11492,
      length: 1,
      convRule: rule20
  }, {
      start: 11493,
      length: 6,
      convRule: rule13
  }, {
      start: 11499,
      length: 1,
      convRule: rule22
  }, {
      start: 11500,
      length: 1,
      convRule: rule23
  }, {
      start: 11501,
      length: 1,
      convRule: rule22
  }, {
      start: 11502,
      length: 1,
      convRule: rule23
  }, {
      start: 11503,
      length: 3,
      convRule: rule92
  }, {
      start: 11506,
      length: 1,
      convRule: rule22
  }, {
      start: 11507,
      length: 1,
      convRule: rule23
  }, {
      start: 11513,
      length: 4,
      convRule: rule2
  }, {
      start: 11517,
      length: 1,
      convRule: rule17
  }, {
      start: 11518,
      length: 2,
      convRule: rule2
  }, {
      start: 11520,
      length: 38,
      convRule: rule182
  }, {
      start: 11559,
      length: 1,
      convRule: rule182
  }, {
      start: 11565,
      length: 1,
      convRule: rule182
  }, {
      start: 11568,
      length: 56,
      convRule: rule14
  }, {
      start: 11631,
      length: 1,
      convRule: rule91
  }, {
      start: 11632,
      length: 1,
      convRule: rule2
  }, {
      start: 11647,
      length: 1,
      convRule: rule92
  }, {
      start: 11648,
      length: 23,
      convRule: rule14
  }, {
      start: 11680,
      length: 7,
      convRule: rule14
  }, {
      start: 11688,
      length: 7,
      convRule: rule14
  }, {
      start: 11696,
      length: 7,
      convRule: rule14
  }, {
      start: 11704,
      length: 7,
      convRule: rule14
  }, {
      start: 11712,
      length: 7,
      convRule: rule14
  }, {
      start: 11720,
      length: 7,
      convRule: rule14
  }, {
      start: 11728,
      length: 7,
      convRule: rule14
  }, {
      start: 11736,
      length: 7,
      convRule: rule14
  }, {
      start: 11744,
      length: 32,
      convRule: rule92
  }, {
      start: 11776,
      length: 2,
      convRule: rule2
  }, {
      start: 11778,
      length: 1,
      convRule: rule15
  }, {
      start: 11779,
      length: 1,
      convRule: rule19
  }, {
      start: 11780,
      length: 1,
      convRule: rule15
  }, {
      start: 11781,
      length: 1,
      convRule: rule19
  }, {
      start: 11782,
      length: 3,
      convRule: rule2
  }, {
      start: 11785,
      length: 1,
      convRule: rule15
  }, {
      start: 11786,
      length: 1,
      convRule: rule19
  }, {
      start: 11787,
      length: 1,
      convRule: rule2
  }, {
      start: 11788,
      length: 1,
      convRule: rule15
  }, {
      start: 11789,
      length: 1,
      convRule: rule19
  }, {
      start: 11790,
      length: 9,
      convRule: rule2
  }, {
      start: 11799,
      length: 1,
      convRule: rule7
  }, {
      start: 11800,
      length: 2,
      convRule: rule2
  }, {
      start: 11802,
      length: 1,
      convRule: rule7
  }, {
      start: 11803,
      length: 1,
      convRule: rule2
  }, {
      start: 11804,
      length: 1,
      convRule: rule15
  }, {
      start: 11805,
      length: 1,
      convRule: rule19
  }, {
      start: 11806,
      length: 2,
      convRule: rule2
  }, {
      start: 11808,
      length: 1,
      convRule: rule15
  }, {
      start: 11809,
      length: 1,
      convRule: rule19
  }, {
      start: 11810,
      length: 1,
      convRule: rule4
  }, {
      start: 11811,
      length: 1,
      convRule: rule5
  }, {
      start: 11812,
      length: 1,
      convRule: rule4
  }, {
      start: 11813,
      length: 1,
      convRule: rule5
  }, {
      start: 11814,
      length: 1,
      convRule: rule4
  }, {
      start: 11815,
      length: 1,
      convRule: rule5
  }, {
      start: 11816,
      length: 1,
      convRule: rule4
  }, {
      start: 11817,
      length: 1,
      convRule: rule5
  }, {
      start: 11818,
      length: 5,
      convRule: rule2
  }, {
      start: 11823,
      length: 1,
      convRule: rule91
  }, {
      start: 11824,
      length: 10,
      convRule: rule2
  }, {
      start: 11834,
      length: 2,
      convRule: rule7
  }, {
      start: 11836,
      length: 4,
      convRule: rule2
  }, {
      start: 11840,
      length: 1,
      convRule: rule7
  }, {
      start: 11841,
      length: 1,
      convRule: rule2
  }, {
      start: 11842,
      length: 1,
      convRule: rule4
  }, {
      start: 11843,
      length: 13,
      convRule: rule2
  }, {
      start: 11856,
      length: 2,
      convRule: rule13
  }, {
      start: 11858,
      length: 1,
      convRule: rule2
  }, {
      start: 11904,
      length: 26,
      convRule: rule13
  }, {
      start: 11931,
      length: 89,
      convRule: rule13
  }, {
      start: 12032,
      length: 214,
      convRule: rule13
  }, {
      start: 12272,
      length: 12,
      convRule: rule13
  }, {
      start: 12288,
      length: 1,
      convRule: rule1
  }, {
      start: 12289,
      length: 3,
      convRule: rule2
  }, {
      start: 12292,
      length: 1,
      convRule: rule13
  }, {
      start: 12293,
      length: 1,
      convRule: rule91
  }, {
      start: 12294,
      length: 1,
      convRule: rule14
  }, {
      start: 12295,
      length: 1,
      convRule: rule128
  }, {
      start: 12296,
      length: 1,
      convRule: rule4
  }, {
      start: 12297,
      length: 1,
      convRule: rule5
  }, {
      start: 12298,
      length: 1,
      convRule: rule4
  }, {
      start: 12299,
      length: 1,
      convRule: rule5
  }, {
      start: 12300,
      length: 1,
      convRule: rule4
  }, {
      start: 12301,
      length: 1,
      convRule: rule5
  }, {
      start: 12302,
      length: 1,
      convRule: rule4
  }, {
      start: 12303,
      length: 1,
      convRule: rule5
  }, {
      start: 12304,
      length: 1,
      convRule: rule4
  }, {
      start: 12305,
      length: 1,
      convRule: rule5
  }, {
      start: 12306,
      length: 2,
      convRule: rule13
  }, {
      start: 12308,
      length: 1,
      convRule: rule4
  }, {
      start: 12309,
      length: 1,
      convRule: rule5
  }, {
      start: 12310,
      length: 1,
      convRule: rule4
  }, {
      start: 12311,
      length: 1,
      convRule: rule5
  }, {
      start: 12312,
      length: 1,
      convRule: rule4
  }, {
      start: 12313,
      length: 1,
      convRule: rule5
  }, {
      start: 12314,
      length: 1,
      convRule: rule4
  }, {
      start: 12315,
      length: 1,
      convRule: rule5
  }, {
      start: 12316,
      length: 1,
      convRule: rule7
  }, {
      start: 12317,
      length: 1,
      convRule: rule4
  }, {
      start: 12318,
      length: 2,
      convRule: rule5
  }, {
      start: 12320,
      length: 1,
      convRule: rule13
  }, {
      start: 12321,
      length: 9,
      convRule: rule128
  }, {
      start: 12330,
      length: 4,
      convRule: rule92
  }, {
      start: 12334,
      length: 2,
      convRule: rule124
  }, {
      start: 12336,
      length: 1,
      convRule: rule7
  }, {
      start: 12337,
      length: 5,
      convRule: rule91
  }, {
      start: 12342,
      length: 2,
      convRule: rule13
  }, {
      start: 12344,
      length: 3,
      convRule: rule128
  }, {
      start: 12347,
      length: 1,
      convRule: rule91
  }, {
      start: 12348,
      length: 1,
      convRule: rule14
  }, {
      start: 12349,
      length: 1,
      convRule: rule2
  }, {
      start: 12350,
      length: 2,
      convRule: rule13
  }, {
      start: 12353,
      length: 86,
      convRule: rule14
  }, {
      start: 12441,
      length: 2,
      convRule: rule92
  }, {
      start: 12443,
      length: 2,
      convRule: rule10
  }, {
      start: 12445,
      length: 2,
      convRule: rule91
  }, {
      start: 12447,
      length: 1,
      convRule: rule14
  }, {
      start: 12448,
      length: 1,
      convRule: rule7
  }, {
      start: 12449,
      length: 90,
      convRule: rule14
  }, {
      start: 12539,
      length: 1,
      convRule: rule2
  }, {
      start: 12540,
      length: 3,
      convRule: rule91
  }, {
      start: 12543,
      length: 1,
      convRule: rule14
  }, {
      start: 12549,
      length: 43,
      convRule: rule14
  }, {
      start: 12593,
      length: 94,
      convRule: rule14
  }, {
      start: 12688,
      length: 2,
      convRule: rule13
  }, {
      start: 12690,
      length: 4,
      convRule: rule17
  }, {
      start: 12694,
      length: 10,
      convRule: rule13
  }, {
      start: 12704,
      length: 32,
      convRule: rule14
  }, {
      start: 12736,
      length: 36,
      convRule: rule13
  }, {
      start: 12784,
      length: 16,
      convRule: rule14
  }, {
      start: 12800,
      length: 31,
      convRule: rule13
  }, {
      start: 12832,
      length: 10,
      convRule: rule17
  }, {
      start: 12842,
      length: 30,
      convRule: rule13
  }, {
      start: 12872,
      length: 8,
      convRule: rule17
  }, {
      start: 12880,
      length: 1,
      convRule: rule13
  }, {
      start: 12881,
      length: 15,
      convRule: rule17
  }, {
      start: 12896,
      length: 32,
      convRule: rule13
  }, {
      start: 12928,
      length: 10,
      convRule: rule17
  }, {
      start: 12938,
      length: 39,
      convRule: rule13
  }, {
      start: 12977,
      length: 15,
      convRule: rule17
  }, {
      start: 12992,
      length: 320,
      convRule: rule13
  }, {
      start: 13312,
      length: 6592,
      convRule: rule14
  }, {
      start: 19904,
      length: 64,
      convRule: rule13
  }, {
      start: 19968,
      length: 20989,
      convRule: rule14
  }, {
      start: 40960,
      length: 21,
      convRule: rule14
  }, {
      start: 40981,
      length: 1,
      convRule: rule91
  }, {
      start: 40982,
      length: 1143,
      convRule: rule14
  }, {
      start: 42128,
      length: 55,
      convRule: rule13
  }, {
      start: 42192,
      length: 40,
      convRule: rule14
  }, {
      start: 42232,
      length: 6,
      convRule: rule91
  }, {
      start: 42238,
      length: 2,
      convRule: rule2
  }, {
      start: 42240,
      length: 268,
      convRule: rule14
  }, {
      start: 42508,
      length: 1,
      convRule: rule91
  }, {
      start: 42509,
      length: 3,
      convRule: rule2
  }, {
      start: 42512,
      length: 16,
      convRule: rule14
  }, {
      start: 42528,
      length: 10,
      convRule: rule8
  }, {
      start: 42538,
      length: 2,
      convRule: rule14
  }, {
      start: 42560,
      length: 1,
      convRule: rule22
  }, {
      start: 42561,
      length: 1,
      convRule: rule23
  }, {
      start: 42562,
      length: 1,
      convRule: rule22
  }, {
      start: 42563,
      length: 1,
      convRule: rule23
  }, {
      start: 42564,
      length: 1,
      convRule: rule22
  }, {
      start: 42565,
      length: 1,
      convRule: rule23
  }, {
      start: 42566,
      length: 1,
      convRule: rule22
  }, {
      start: 42567,
      length: 1,
      convRule: rule23
  }, {
      start: 42568,
      length: 1,
      convRule: rule22
  }, {
      start: 42569,
      length: 1,
      convRule: rule23
  }, {
      start: 42570,
      length: 1,
      convRule: rule22
  }, {
      start: 42571,
      length: 1,
      convRule: rule23
  }, {
      start: 42572,
      length: 1,
      convRule: rule22
  }, {
      start: 42573,
      length: 1,
      convRule: rule23
  }, {
      start: 42574,
      length: 1,
      convRule: rule22
  }, {
      start: 42575,
      length: 1,
      convRule: rule23
  }, {
      start: 42576,
      length: 1,
      convRule: rule22
  }, {
      start: 42577,
      length: 1,
      convRule: rule23
  }, {
      start: 42578,
      length: 1,
      convRule: rule22
  }, {
      start: 42579,
      length: 1,
      convRule: rule23
  }, {
      start: 42580,
      length: 1,
      convRule: rule22
  }, {
      start: 42581,
      length: 1,
      convRule: rule23
  }, {
      start: 42582,
      length: 1,
      convRule: rule22
  }, {
      start: 42583,
      length: 1,
      convRule: rule23
  }, {
      start: 42584,
      length: 1,
      convRule: rule22
  }, {
      start: 42585,
      length: 1,
      convRule: rule23
  }, {
      start: 42586,
      length: 1,
      convRule: rule22
  }, {
      start: 42587,
      length: 1,
      convRule: rule23
  }, {
      start: 42588,
      length: 1,
      convRule: rule22
  }, {
      start: 42589,
      length: 1,
      convRule: rule23
  }, {
      start: 42590,
      length: 1,
      convRule: rule22
  }, {
      start: 42591,
      length: 1,
      convRule: rule23
  }, {
      start: 42592,
      length: 1,
      convRule: rule22
  }, {
      start: 42593,
      length: 1,
      convRule: rule23
  }, {
      start: 42594,
      length: 1,
      convRule: rule22
  }, {
      start: 42595,
      length: 1,
      convRule: rule23
  }, {
      start: 42596,
      length: 1,
      convRule: rule22
  }, {
      start: 42597,
      length: 1,
      convRule: rule23
  }, {
      start: 42598,
      length: 1,
      convRule: rule22
  }, {
      start: 42599,
      length: 1,
      convRule: rule23
  }, {
      start: 42600,
      length: 1,
      convRule: rule22
  }, {
      start: 42601,
      length: 1,
      convRule: rule23
  }, {
      start: 42602,
      length: 1,
      convRule: rule22
  }, {
      start: 42603,
      length: 1,
      convRule: rule23
  }, {
      start: 42604,
      length: 1,
      convRule: rule22
  }, {
      start: 42605,
      length: 1,
      convRule: rule23
  }, {
      start: 42606,
      length: 1,
      convRule: rule14
  }, {
      start: 42607,
      length: 1,
      convRule: rule92
  }, {
      start: 42608,
      length: 3,
      convRule: rule119
  }, {
      start: 42611,
      length: 1,
      convRule: rule2
  }, {
      start: 42612,
      length: 10,
      convRule: rule92
  }, {
      start: 42622,
      length: 1,
      convRule: rule2
  }, {
      start: 42623,
      length: 1,
      convRule: rule91
  }, {
      start: 42624,
      length: 1,
      convRule: rule22
  }, {
      start: 42625,
      length: 1,
      convRule: rule23
  }, {
      start: 42626,
      length: 1,
      convRule: rule22
  }, {
      start: 42627,
      length: 1,
      convRule: rule23
  }, {
      start: 42628,
      length: 1,
      convRule: rule22
  }, {
      start: 42629,
      length: 1,
      convRule: rule23
  }, {
      start: 42630,
      length: 1,
      convRule: rule22
  }, {
      start: 42631,
      length: 1,
      convRule: rule23
  }, {
      start: 42632,
      length: 1,
      convRule: rule22
  }, {
      start: 42633,
      length: 1,
      convRule: rule23
  }, {
      start: 42634,
      length: 1,
      convRule: rule22
  }, {
      start: 42635,
      length: 1,
      convRule: rule23
  }, {
      start: 42636,
      length: 1,
      convRule: rule22
  }, {
      start: 42637,
      length: 1,
      convRule: rule23
  }, {
      start: 42638,
      length: 1,
      convRule: rule22
  }, {
      start: 42639,
      length: 1,
      convRule: rule23
  }, {
      start: 42640,
      length: 1,
      convRule: rule22
  }, {
      start: 42641,
      length: 1,
      convRule: rule23
  }, {
      start: 42642,
      length: 1,
      convRule: rule22
  }, {
      start: 42643,
      length: 1,
      convRule: rule23
  }, {
      start: 42644,
      length: 1,
      convRule: rule22
  }, {
      start: 42645,
      length: 1,
      convRule: rule23
  }, {
      start: 42646,
      length: 1,
      convRule: rule22
  }, {
      start: 42647,
      length: 1,
      convRule: rule23
  }, {
      start: 42648,
      length: 1,
      convRule: rule22
  }, {
      start: 42649,
      length: 1,
      convRule: rule23
  }, {
      start: 42650,
      length: 1,
      convRule: rule22
  }, {
      start: 42651,
      length: 1,
      convRule: rule23
  }, {
      start: 42652,
      length: 2,
      convRule: rule91
  }, {
      start: 42654,
      length: 2,
      convRule: rule92
  }, {
      start: 42656,
      length: 70,
      convRule: rule14
  }, {
      start: 42726,
      length: 10,
      convRule: rule128
  }, {
      start: 42736,
      length: 2,
      convRule: rule92
  }, {
      start: 42738,
      length: 6,
      convRule: rule2
  }, {
      start: 42752,
      length: 23,
      convRule: rule10
  }, {
      start: 42775,
      length: 9,
      convRule: rule91
  }, {
      start: 42784,
      length: 2,
      convRule: rule10
  }, {
      start: 42786,
      length: 1,
      convRule: rule22
  }, {
      start: 42787,
      length: 1,
      convRule: rule23
  }, {
      start: 42788,
      length: 1,
      convRule: rule22
  }, {
      start: 42789,
      length: 1,
      convRule: rule23
  }, {
      start: 42790,
      length: 1,
      convRule: rule22
  }, {
      start: 42791,
      length: 1,
      convRule: rule23
  }, {
      start: 42792,
      length: 1,
      convRule: rule22
  }, {
      start: 42793,
      length: 1,
      convRule: rule23
  }, {
      start: 42794,
      length: 1,
      convRule: rule22
  }, {
      start: 42795,
      length: 1,
      convRule: rule23
  }, {
      start: 42796,
      length: 1,
      convRule: rule22
  }, {
      start: 42797,
      length: 1,
      convRule: rule23
  }, {
      start: 42798,
      length: 1,
      convRule: rule22
  }, {
      start: 42799,
      length: 1,
      convRule: rule23
  }, {
      start: 42800,
      length: 2,
      convRule: rule20
  }, {
      start: 42802,
      length: 1,
      convRule: rule22
  }, {
      start: 42803,
      length: 1,
      convRule: rule23
  }, {
      start: 42804,
      length: 1,
      convRule: rule22
  }, {
      start: 42805,
      length: 1,
      convRule: rule23
  }, {
      start: 42806,
      length: 1,
      convRule: rule22
  }, {
      start: 42807,
      length: 1,
      convRule: rule23
  }, {
      start: 42808,
      length: 1,
      convRule: rule22
  }, {
      start: 42809,
      length: 1,
      convRule: rule23
  }, {
      start: 42810,
      length: 1,
      convRule: rule22
  }, {
      start: 42811,
      length: 1,
      convRule: rule23
  }, {
      start: 42812,
      length: 1,
      convRule: rule22
  }, {
      start: 42813,
      length: 1,
      convRule: rule23
  }, {
      start: 42814,
      length: 1,
      convRule: rule22
  }, {
      start: 42815,
      length: 1,
      convRule: rule23
  }, {
      start: 42816,
      length: 1,
      convRule: rule22
  }, {
      start: 42817,
      length: 1,
      convRule: rule23
  }, {
      start: 42818,
      length: 1,
      convRule: rule22
  }, {
      start: 42819,
      length: 1,
      convRule: rule23
  }, {
      start: 42820,
      length: 1,
      convRule: rule22
  }, {
      start: 42821,
      length: 1,
      convRule: rule23
  }, {
      start: 42822,
      length: 1,
      convRule: rule22
  }, {
      start: 42823,
      length: 1,
      convRule: rule23
  }, {
      start: 42824,
      length: 1,
      convRule: rule22
  }, {
      start: 42825,
      length: 1,
      convRule: rule23
  }, {
      start: 42826,
      length: 1,
      convRule: rule22
  }, {
      start: 42827,
      length: 1,
      convRule: rule23
  }, {
      start: 42828,
      length: 1,
      convRule: rule22
  }, {
      start: 42829,
      length: 1,
      convRule: rule23
  }, {
      start: 42830,
      length: 1,
      convRule: rule22
  }, {
      start: 42831,
      length: 1,
      convRule: rule23
  }, {
      start: 42832,
      length: 1,
      convRule: rule22
  }, {
      start: 42833,
      length: 1,
      convRule: rule23
  }, {
      start: 42834,
      length: 1,
      convRule: rule22
  }, {
      start: 42835,
      length: 1,
      convRule: rule23
  }, {
      start: 42836,
      length: 1,
      convRule: rule22
  }, {
      start: 42837,
      length: 1,
      convRule: rule23
  }, {
      start: 42838,
      length: 1,
      convRule: rule22
  }, {
      start: 42839,
      length: 1,
      convRule: rule23
  }, {
      start: 42840,
      length: 1,
      convRule: rule22
  }, {
      start: 42841,
      length: 1,
      convRule: rule23
  }, {
      start: 42842,
      length: 1,
      convRule: rule22
  }, {
      start: 42843,
      length: 1,
      convRule: rule23
  }, {
      start: 42844,
      length: 1,
      convRule: rule22
  }, {
      start: 42845,
      length: 1,
      convRule: rule23
  }, {
      start: 42846,
      length: 1,
      convRule: rule22
  }, {
      start: 42847,
      length: 1,
      convRule: rule23
  }, {
      start: 42848,
      length: 1,
      convRule: rule22
  }, {
      start: 42849,
      length: 1,
      convRule: rule23
  }, {
      start: 42850,
      length: 1,
      convRule: rule22
  }, {
      start: 42851,
      length: 1,
      convRule: rule23
  }, {
      start: 42852,
      length: 1,
      convRule: rule22
  }, {
      start: 42853,
      length: 1,
      convRule: rule23
  }, {
      start: 42854,
      length: 1,
      convRule: rule22
  }, {
      start: 42855,
      length: 1,
      convRule: rule23
  }, {
      start: 42856,
      length: 1,
      convRule: rule22
  }, {
      start: 42857,
      length: 1,
      convRule: rule23
  }, {
      start: 42858,
      length: 1,
      convRule: rule22
  }, {
      start: 42859,
      length: 1,
      convRule: rule23
  }, {
      start: 42860,
      length: 1,
      convRule: rule22
  }, {
      start: 42861,
      length: 1,
      convRule: rule23
  }, {
      start: 42862,
      length: 1,
      convRule: rule22
  }, {
      start: 42863,
      length: 1,
      convRule: rule23
  }, {
      start: 42864,
      length: 1,
      convRule: rule91
  }, {
      start: 42865,
      length: 8,
      convRule: rule20
  }, {
      start: 42873,
      length: 1,
      convRule: rule22
  }, {
      start: 42874,
      length: 1,
      convRule: rule23
  }, {
      start: 42875,
      length: 1,
      convRule: rule22
  }, {
      start: 42876,
      length: 1,
      convRule: rule23
  }, {
      start: 42877,
      length: 1,
      convRule: rule183
  }, {
      start: 42878,
      length: 1,
      convRule: rule22
  }, {
      start: 42879,
      length: 1,
      convRule: rule23
  }, {
      start: 42880,
      length: 1,
      convRule: rule22
  }, {
      start: 42881,
      length: 1,
      convRule: rule23
  }, {
      start: 42882,
      length: 1,
      convRule: rule22
  }, {
      start: 42883,
      length: 1,
      convRule: rule23
  }, {
      start: 42884,
      length: 1,
      convRule: rule22
  }, {
      start: 42885,
      length: 1,
      convRule: rule23
  }, {
      start: 42886,
      length: 1,
      convRule: rule22
  }, {
      start: 42887,
      length: 1,
      convRule: rule23
  }, {
      start: 42888,
      length: 1,
      convRule: rule91
  }, {
      start: 42889,
      length: 2,
      convRule: rule10
  }, {
      start: 42891,
      length: 1,
      convRule: rule22
  }, {
      start: 42892,
      length: 1,
      convRule: rule23
  }, {
      start: 42893,
      length: 1,
      convRule: rule184
  }, {
      start: 42894,
      length: 1,
      convRule: rule20
  }, {
      start: 42895,
      length: 1,
      convRule: rule14
  }, {
      start: 42896,
      length: 1,
      convRule: rule22
  }, {
      start: 42897,
      length: 1,
      convRule: rule23
  }, {
      start: 42898,
      length: 1,
      convRule: rule22
  }, {
      start: 42899,
      length: 1,
      convRule: rule23
  }, {
      start: 42900,
      length: 1,
      convRule: rule185
  }, {
      start: 42901,
      length: 1,
      convRule: rule20
  }, {
      start: 42902,
      length: 1,
      convRule: rule22
  }, {
      start: 42903,
      length: 1,
      convRule: rule23
  }, {
      start: 42904,
      length: 1,
      convRule: rule22
  }, {
      start: 42905,
      length: 1,
      convRule: rule23
  }, {
      start: 42906,
      length: 1,
      convRule: rule22
  }, {
      start: 42907,
      length: 1,
      convRule: rule23
  }, {
      start: 42908,
      length: 1,
      convRule: rule22
  }, {
      start: 42909,
      length: 1,
      convRule: rule23
  }, {
      start: 42910,
      length: 1,
      convRule: rule22
  }, {
      start: 42911,
      length: 1,
      convRule: rule23
  }, {
      start: 42912,
      length: 1,
      convRule: rule22
  }, {
      start: 42913,
      length: 1,
      convRule: rule23
  }, {
      start: 42914,
      length: 1,
      convRule: rule22
  }, {
      start: 42915,
      length: 1,
      convRule: rule23
  }, {
      start: 42916,
      length: 1,
      convRule: rule22
  }, {
      start: 42917,
      length: 1,
      convRule: rule23
  }, {
      start: 42918,
      length: 1,
      convRule: rule22
  }, {
      start: 42919,
      length: 1,
      convRule: rule23
  }, {
      start: 42920,
      length: 1,
      convRule: rule22
  }, {
      start: 42921,
      length: 1,
      convRule: rule23
  }, {
      start: 42922,
      length: 1,
      convRule: rule186
  }, {
      start: 42923,
      length: 1,
      convRule: rule187
  }, {
      start: 42924,
      length: 1,
      convRule: rule188
  }, {
      start: 42925,
      length: 1,
      convRule: rule189
  }, {
      start: 42926,
      length: 1,
      convRule: rule186
  }, {
      start: 42927,
      length: 1,
      convRule: rule20
  }, {
      start: 42928,
      length: 1,
      convRule: rule190
  }, {
      start: 42929,
      length: 1,
      convRule: rule191
  }, {
      start: 42930,
      length: 1,
      convRule: rule192
  }, {
      start: 42931,
      length: 1,
      convRule: rule193
  }, {
      start: 42932,
      length: 1,
      convRule: rule22
  }, {
      start: 42933,
      length: 1,
      convRule: rule23
  }, {
      start: 42934,
      length: 1,
      convRule: rule22
  }, {
      start: 42935,
      length: 1,
      convRule: rule23
  }, {
      start: 42936,
      length: 1,
      convRule: rule22
  }, {
      start: 42937,
      length: 1,
      convRule: rule23
  }, {
      start: 42938,
      length: 1,
      convRule: rule22
  }, {
      start: 42939,
      length: 1,
      convRule: rule23
  }, {
      start: 42940,
      length: 1,
      convRule: rule22
  }, {
      start: 42941,
      length: 1,
      convRule: rule23
  }, {
      start: 42942,
      length: 1,
      convRule: rule22
  }, {
      start: 42943,
      length: 1,
      convRule: rule23
  }, {
      start: 42946,
      length: 1,
      convRule: rule22
  }, {
      start: 42947,
      length: 1,
      convRule: rule23
  }, {
      start: 42948,
      length: 1,
      convRule: rule194
  }, {
      start: 42949,
      length: 1,
      convRule: rule195
  }, {
      start: 42950,
      length: 1,
      convRule: rule196
  }, {
      start: 42951,
      length: 1,
      convRule: rule22
  }, {
      start: 42952,
      length: 1,
      convRule: rule23
  }, {
      start: 42953,
      length: 1,
      convRule: rule22
  }, {
      start: 42954,
      length: 1,
      convRule: rule23
  }, {
      start: 42997,
      length: 1,
      convRule: rule22
  }, {
      start: 42998,
      length: 1,
      convRule: rule23
  }, {
      start: 42999,
      length: 1,
      convRule: rule14
  }, {
      start: 43000,
      length: 2,
      convRule: rule91
  }, {
      start: 43002,
      length: 1,
      convRule: rule20
  }, {
      start: 43003,
      length: 7,
      convRule: rule14
  }, {
      start: 43010,
      length: 1,
      convRule: rule92
  }, {
      start: 43011,
      length: 3,
      convRule: rule14
  }, {
      start: 43014,
      length: 1,
      convRule: rule92
  }, {
      start: 43015,
      length: 4,
      convRule: rule14
  }, {
      start: 43019,
      length: 1,
      convRule: rule92
  }, {
      start: 43020,
      length: 23,
      convRule: rule14
  }, {
      start: 43043,
      length: 2,
      convRule: rule124
  }, {
      start: 43045,
      length: 2,
      convRule: rule92
  }, {
      start: 43047,
      length: 1,
      convRule: rule124
  }, {
      start: 43048,
      length: 4,
      convRule: rule13
  }, {
      start: 43052,
      length: 1,
      convRule: rule92
  }, {
      start: 43056,
      length: 6,
      convRule: rule17
  }, {
      start: 43062,
      length: 2,
      convRule: rule13
  }, {
      start: 43064,
      length: 1,
      convRule: rule3
  }, {
      start: 43065,
      length: 1,
      convRule: rule13
  }, {
      start: 43072,
      length: 52,
      convRule: rule14
  }, {
      start: 43124,
      length: 4,
      convRule: rule2
  }, {
      start: 43136,
      length: 2,
      convRule: rule124
  }, {
      start: 43138,
      length: 50,
      convRule: rule14
  }, {
      start: 43188,
      length: 16,
      convRule: rule124
  }, {
      start: 43204,
      length: 2,
      convRule: rule92
  }, {
      start: 43214,
      length: 2,
      convRule: rule2
  }, {
      start: 43216,
      length: 10,
      convRule: rule8
  }, {
      start: 43232,
      length: 18,
      convRule: rule92
  }, {
      start: 43250,
      length: 6,
      convRule: rule14
  }, {
      start: 43256,
      length: 3,
      convRule: rule2
  }, {
      start: 43259,
      length: 1,
      convRule: rule14
  }, {
      start: 43260,
      length: 1,
      convRule: rule2
  }, {
      start: 43261,
      length: 2,
      convRule: rule14
  }, {
      start: 43263,
      length: 1,
      convRule: rule92
  }, {
      start: 43264,
      length: 10,
      convRule: rule8
  }, {
      start: 43274,
      length: 28,
      convRule: rule14
  }, {
      start: 43302,
      length: 8,
      convRule: rule92
  }, {
      start: 43310,
      length: 2,
      convRule: rule2
  }, {
      start: 43312,
      length: 23,
      convRule: rule14
  }, {
      start: 43335,
      length: 11,
      convRule: rule92
  }, {
      start: 43346,
      length: 2,
      convRule: rule124
  }, {
      start: 43359,
      length: 1,
      convRule: rule2
  }, {
      start: 43360,
      length: 29,
      convRule: rule14
  }, {
      start: 43392,
      length: 3,
      convRule: rule92
  }, {
      start: 43395,
      length: 1,
      convRule: rule124
  }, {
      start: 43396,
      length: 47,
      convRule: rule14
  }, {
      start: 43443,
      length: 1,
      convRule: rule92
  }, {
      start: 43444,
      length: 2,
      convRule: rule124
  }, {
      start: 43446,
      length: 4,
      convRule: rule92
  }, {
      start: 43450,
      length: 2,
      convRule: rule124
  }, {
      start: 43452,
      length: 2,
      convRule: rule92
  }, {
      start: 43454,
      length: 3,
      convRule: rule124
  }, {
      start: 43457,
      length: 13,
      convRule: rule2
  }, {
      start: 43471,
      length: 1,
      convRule: rule91
  }, {
      start: 43472,
      length: 10,
      convRule: rule8
  }, {
      start: 43486,
      length: 2,
      convRule: rule2
  }, {
      start: 43488,
      length: 5,
      convRule: rule14
  }, {
      start: 43493,
      length: 1,
      convRule: rule92
  }, {
      start: 43494,
      length: 1,
      convRule: rule91
  }, {
      start: 43495,
      length: 9,
      convRule: rule14
  }, {
      start: 43504,
      length: 10,
      convRule: rule8
  }, {
      start: 43514,
      length: 5,
      convRule: rule14
  }, {
      start: 43520,
      length: 41,
      convRule: rule14
  }, {
      start: 43561,
      length: 6,
      convRule: rule92
  }, {
      start: 43567,
      length: 2,
      convRule: rule124
  }, {
      start: 43569,
      length: 2,
      convRule: rule92
  }, {
      start: 43571,
      length: 2,
      convRule: rule124
  }, {
      start: 43573,
      length: 2,
      convRule: rule92
  }, {
      start: 43584,
      length: 3,
      convRule: rule14
  }, {
      start: 43587,
      length: 1,
      convRule: rule92
  }, {
      start: 43588,
      length: 8,
      convRule: rule14
  }, {
      start: 43596,
      length: 1,
      convRule: rule92
  }, {
      start: 43597,
      length: 1,
      convRule: rule124
  }, {
      start: 43600,
      length: 10,
      convRule: rule8
  }, {
      start: 43612,
      length: 4,
      convRule: rule2
  }, {
      start: 43616,
      length: 16,
      convRule: rule14
  }, {
      start: 43632,
      length: 1,
      convRule: rule91
  }, {
      start: 43633,
      length: 6,
      convRule: rule14
  }, {
      start: 43639,
      length: 3,
      convRule: rule13
  }, {
      start: 43642,
      length: 1,
      convRule: rule14
  }, {
      start: 43643,
      length: 1,
      convRule: rule124
  }, {
      start: 43644,
      length: 1,
      convRule: rule92
  }, {
      start: 43645,
      length: 1,
      convRule: rule124
  }, {
      start: 43646,
      length: 50,
      convRule: rule14
  }, {
      start: 43696,
      length: 1,
      convRule: rule92
  }, {
      start: 43697,
      length: 1,
      convRule: rule14
  }, {
      start: 43698,
      length: 3,
      convRule: rule92
  }, {
      start: 43701,
      length: 2,
      convRule: rule14
  }, {
      start: 43703,
      length: 2,
      convRule: rule92
  }, {
      start: 43705,
      length: 5,
      convRule: rule14
  }, {
      start: 43710,
      length: 2,
      convRule: rule92
  }, {
      start: 43712,
      length: 1,
      convRule: rule14
  }, {
      start: 43713,
      length: 1,
      convRule: rule92
  }, {
      start: 43714,
      length: 1,
      convRule: rule14
  }, {
      start: 43739,
      length: 2,
      convRule: rule14
  }, {
      start: 43741,
      length: 1,
      convRule: rule91
  }, {
      start: 43742,
      length: 2,
      convRule: rule2
  }, {
      start: 43744,
      length: 11,
      convRule: rule14
  }, {
      start: 43755,
      length: 1,
      convRule: rule124
  }, {
      start: 43756,
      length: 2,
      convRule: rule92
  }, {
      start: 43758,
      length: 2,
      convRule: rule124
  }, {
      start: 43760,
      length: 2,
      convRule: rule2
  }, {
      start: 43762,
      length: 1,
      convRule: rule14
  }, {
      start: 43763,
      length: 2,
      convRule: rule91
  }, {
      start: 43765,
      length: 1,
      convRule: rule124
  }, {
      start: 43766,
      length: 1,
      convRule: rule92
  }, {
      start: 43777,
      length: 6,
      convRule: rule14
  }, {
      start: 43785,
      length: 6,
      convRule: rule14
  }, {
      start: 43793,
      length: 6,
      convRule: rule14
  }, {
      start: 43808,
      length: 7,
      convRule: rule14
  }, {
      start: 43816,
      length: 7,
      convRule: rule14
  }, {
      start: 43824,
      length: 35,
      convRule: rule20
  }, {
      start: 43859,
      length: 1,
      convRule: rule197
  }, {
      start: 43860,
      length: 7,
      convRule: rule20
  }, {
      start: 43867,
      length: 1,
      convRule: rule10
  }, {
      start: 43868,
      length: 4,
      convRule: rule91
  }, {
      start: 43872,
      length: 9,
      convRule: rule20
  }, {
      start: 43881,
      length: 1,
      convRule: rule91
  }, {
      start: 43882,
      length: 2,
      convRule: rule10
  }, {
      start: 43888,
      length: 80,
      convRule: rule198
  }, {
      start: 43968,
      length: 35,
      convRule: rule14
  }, {
      start: 44003,
      length: 2,
      convRule: rule124
  }, {
      start: 44005,
      length: 1,
      convRule: rule92
  }, {
      start: 44006,
      length: 2,
      convRule: rule124
  }, {
      start: 44008,
      length: 1,
      convRule: rule92
  }, {
      start: 44009,
      length: 2,
      convRule: rule124
  }, {
      start: 44011,
      length: 1,
      convRule: rule2
  }, {
      start: 44012,
      length: 1,
      convRule: rule124
  }, {
      start: 44013,
      length: 1,
      convRule: rule92
  }, {
      start: 44016,
      length: 10,
      convRule: rule8
  }, {
      start: 44032,
      length: 11172,
      convRule: rule14
  }, {
      start: 55216,
      length: 23,
      convRule: rule14
  }, {
      start: 55243,
      length: 49,
      convRule: rule14
  }, {
      start: 55296,
      length: 896,
      convRule: rule199
  }, {
      start: 56192,
      length: 128,
      convRule: rule199
  }, {
      start: 56320,
      length: 1024,
      convRule: rule199
  }, {
      start: 57344,
      length: 6400,
      convRule: rule200
  }, {
      start: 63744,
      length: 366,
      convRule: rule14
  }, {
      start: 64112,
      length: 106,
      convRule: rule14
  }, {
      start: 64256,
      length: 7,
      convRule: rule20
  }, {
      start: 64275,
      length: 5,
      convRule: rule20
  }, {
      start: 64285,
      length: 1,
      convRule: rule14
  }, {
      start: 64286,
      length: 1,
      convRule: rule92
  }, {
      start: 64287,
      length: 10,
      convRule: rule14
  }, {
      start: 64297,
      length: 1,
      convRule: rule6
  }, {
      start: 64298,
      length: 13,
      convRule: rule14
  }, {
      start: 64312,
      length: 5,
      convRule: rule14
  }, {
      start: 64318,
      length: 1,
      convRule: rule14
  }, {
      start: 64320,
      length: 2,
      convRule: rule14
  }, {
      start: 64323,
      length: 2,
      convRule: rule14
  }, {
      start: 64326,
      length: 108,
      convRule: rule14
  }, {
      start: 64434,
      length: 16,
      convRule: rule10
  }, {
      start: 64467,
      length: 363,
      convRule: rule14
  }, {
      start: 64830,
      length: 1,
      convRule: rule5
  }, {
      start: 64831,
      length: 1,
      convRule: rule4
  }, {
      start: 64848,
      length: 64,
      convRule: rule14
  }, {
      start: 64914,
      length: 54,
      convRule: rule14
  }, {
      start: 65008,
      length: 12,
      convRule: rule14
  }, {
      start: 65020,
      length: 1,
      convRule: rule3
  }, {
      start: 65021,
      length: 1,
      convRule: rule13
  }, {
      start: 65024,
      length: 16,
      convRule: rule92
  }, {
      start: 65040,
      length: 7,
      convRule: rule2
  }, {
      start: 65047,
      length: 1,
      convRule: rule4
  }, {
      start: 65048,
      length: 1,
      convRule: rule5
  }, {
      start: 65049,
      length: 1,
      convRule: rule2
  }, {
      start: 65056,
      length: 16,
      convRule: rule92
  }, {
      start: 65072,
      length: 1,
      convRule: rule2
  }, {
      start: 65073,
      length: 2,
      convRule: rule7
  }, {
      start: 65075,
      length: 2,
      convRule: rule11
  }, {
      start: 65077,
      length: 1,
      convRule: rule4
  }, {
      start: 65078,
      length: 1,
      convRule: rule5
  }, {
      start: 65079,
      length: 1,
      convRule: rule4
  }, {
      start: 65080,
      length: 1,
      convRule: rule5
  }, {
      start: 65081,
      length: 1,
      convRule: rule4
  }, {
      start: 65082,
      length: 1,
      convRule: rule5
  }, {
      start: 65083,
      length: 1,
      convRule: rule4
  }, {
      start: 65084,
      length: 1,
      convRule: rule5
  }, {
      start: 65085,
      length: 1,
      convRule: rule4
  }, {
      start: 65086,
      length: 1,
      convRule: rule5
  }, {
      start: 65087,
      length: 1,
      convRule: rule4
  }, {
      start: 65088,
      length: 1,
      convRule: rule5
  }, {
      start: 65089,
      length: 1,
      convRule: rule4
  }, {
      start: 65090,
      length: 1,
      convRule: rule5
  }, {
      start: 65091,
      length: 1,
      convRule: rule4
  }, {
      start: 65092,
      length: 1,
      convRule: rule5
  }, {
      start: 65093,
      length: 2,
      convRule: rule2
  }, {
      start: 65095,
      length: 1,
      convRule: rule4
  }, {
      start: 65096,
      length: 1,
      convRule: rule5
  }, {
      start: 65097,
      length: 4,
      convRule: rule2
  }, {
      start: 65101,
      length: 3,
      convRule: rule11
  }, {
      start: 65104,
      length: 3,
      convRule: rule2
  }, {
      start: 65108,
      length: 4,
      convRule: rule2
  }, {
      start: 65112,
      length: 1,
      convRule: rule7
  }, {
      start: 65113,
      length: 1,
      convRule: rule4
  }, {
      start: 65114,
      length: 1,
      convRule: rule5
  }, {
      start: 65115,
      length: 1,
      convRule: rule4
  }, {
      start: 65116,
      length: 1,
      convRule: rule5
  }, {
      start: 65117,
      length: 1,
      convRule: rule4
  }, {
      start: 65118,
      length: 1,
      convRule: rule5
  }, {
      start: 65119,
      length: 3,
      convRule: rule2
  }, {
      start: 65122,
      length: 1,
      convRule: rule6
  }, {
      start: 65123,
      length: 1,
      convRule: rule7
  }, {
      start: 65124,
      length: 3,
      convRule: rule6
  }, {
      start: 65128,
      length: 1,
      convRule: rule2
  }, {
      start: 65129,
      length: 1,
      convRule: rule3
  }, {
      start: 65130,
      length: 2,
      convRule: rule2
  }, {
      start: 65136,
      length: 5,
      convRule: rule14
  }, {
      start: 65142,
      length: 135,
      convRule: rule14
  }, {
      start: 65279,
      length: 1,
      convRule: rule16
  }, {
      start: 65281,
      length: 3,
      convRule: rule2
  }, {
      start: 65284,
      length: 1,
      convRule: rule3
  }, {
      start: 65285,
      length: 3,
      convRule: rule2
  }, {
      start: 65288,
      length: 1,
      convRule: rule4
  }, {
      start: 65289,
      length: 1,
      convRule: rule5
  }, {
      start: 65290,
      length: 1,
      convRule: rule2
  }, {
      start: 65291,
      length: 1,
      convRule: rule6
  }, {
      start: 65292,
      length: 1,
      convRule: rule2
  }, {
      start: 65293,
      length: 1,
      convRule: rule7
  }, {
      start: 65294,
      length: 2,
      convRule: rule2
  }, {
      start: 65296,
      length: 10,
      convRule: rule8
  }, {
      start: 65306,
      length: 2,
      convRule: rule2
  }, {
      start: 65308,
      length: 3,
      convRule: rule6
  }, {
      start: 65311,
      length: 2,
      convRule: rule2
  }, {
      start: 65313,
      length: 26,
      convRule: rule9
  }, {
      start: 65339,
      length: 1,
      convRule: rule4
  }, {
      start: 65340,
      length: 1,
      convRule: rule2
  }, {
      start: 65341,
      length: 1,
      convRule: rule5
  }, {
      start: 65342,
      length: 1,
      convRule: rule10
  }, {
      start: 65343,
      length: 1,
      convRule: rule11
  }, {
      start: 65344,
      length: 1,
      convRule: rule10
  }, {
      start: 65345,
      length: 26,
      convRule: rule12
  }, {
      start: 65371,
      length: 1,
      convRule: rule4
  }, {
      start: 65372,
      length: 1,
      convRule: rule6
  }, {
      start: 65373,
      length: 1,
      convRule: rule5
  }, {
      start: 65374,
      length: 1,
      convRule: rule6
  }, {
      start: 65375,
      length: 1,
      convRule: rule4
  }, {
      start: 65376,
      length: 1,
      convRule: rule5
  }, {
      start: 65377,
      length: 1,
      convRule: rule2
  }, {
      start: 65378,
      length: 1,
      convRule: rule4
  }, {
      start: 65379,
      length: 1,
      convRule: rule5
  }, {
      start: 65380,
      length: 2,
      convRule: rule2
  }, {
      start: 65382,
      length: 10,
      convRule: rule14
  }, {
      start: 65392,
      length: 1,
      convRule: rule91
  }, {
      start: 65393,
      length: 45,
      convRule: rule14
  }, {
      start: 65438,
      length: 2,
      convRule: rule91
  }, {
      start: 65440,
      length: 31,
      convRule: rule14
  }, {
      start: 65474,
      length: 6,
      convRule: rule14
  }, {
      start: 65482,
      length: 6,
      convRule: rule14
  }, {
      start: 65490,
      length: 6,
      convRule: rule14
  }, {
      start: 65498,
      length: 3,
      convRule: rule14
  }, {
      start: 65504,
      length: 2,
      convRule: rule3
  }, {
      start: 65506,
      length: 1,
      convRule: rule6
  }, {
      start: 65507,
      length: 1,
      convRule: rule10
  }, {
      start: 65508,
      length: 1,
      convRule: rule13
  }, {
      start: 65509,
      length: 2,
      convRule: rule3
  }, {
      start: 65512,
      length: 1,
      convRule: rule13
  }, {
      start: 65513,
      length: 4,
      convRule: rule6
  }, {
      start: 65517,
      length: 2,
      convRule: rule13
  }, {
      start: 65529,
      length: 3,
      convRule: rule16
  }, {
      start: 65532,
      length: 2,
      convRule: rule13
  }, {
      start: 65536,
      length: 12,
      convRule: rule14
  }, {
      start: 65549,
      length: 26,
      convRule: rule14
  }, {
      start: 65576,
      length: 19,
      convRule: rule14
  }, {
      start: 65596,
      length: 2,
      convRule: rule14
  }, {
      start: 65599,
      length: 15,
      convRule: rule14
  }, {
      start: 65616,
      length: 14,
      convRule: rule14
  }, {
      start: 65664,
      length: 123,
      convRule: rule14
  }, {
      start: 65792,
      length: 3,
      convRule: rule2
  }, {
      start: 65799,
      length: 45,
      convRule: rule17
  }, {
      start: 65847,
      length: 9,
      convRule: rule13
  }, {
      start: 65856,
      length: 53,
      convRule: rule128
  }, {
      start: 65909,
      length: 4,
      convRule: rule17
  }, {
      start: 65913,
      length: 17,
      convRule: rule13
  }, {
      start: 65930,
      length: 2,
      convRule: rule17
  }, {
      start: 65932,
      length: 3,
      convRule: rule13
  }, {
      start: 65936,
      length: 13,
      convRule: rule13
  }, {
      start: 65952,
      length: 1,
      convRule: rule13
  }, {
      start: 66000,
      length: 45,
      convRule: rule13
  }, {
      start: 66045,
      length: 1,
      convRule: rule92
  }, {
      start: 66176,
      length: 29,
      convRule: rule14
  }, {
      start: 66208,
      length: 49,
      convRule: rule14
  }, {
      start: 66272,
      length: 1,
      convRule: rule92
  }, {
      start: 66273,
      length: 27,
      convRule: rule17
  }, {
      start: 66304,
      length: 32,
      convRule: rule14
  }, {
      start: 66336,
      length: 4,
      convRule: rule17
  }, {
      start: 66349,
      length: 20,
      convRule: rule14
  }, {
      start: 66369,
      length: 1,
      convRule: rule128
  }, {
      start: 66370,
      length: 8,
      convRule: rule14
  }, {
      start: 66378,
      length: 1,
      convRule: rule128
  }, {
      start: 66384,
      length: 38,
      convRule: rule14
  }, {
      start: 66422,
      length: 5,
      convRule: rule92
  }, {
      start: 66432,
      length: 30,
      convRule: rule14
  }, {
      start: 66463,
      length: 1,
      convRule: rule2
  }, {
      start: 66464,
      length: 36,
      convRule: rule14
  }, {
      start: 66504,
      length: 8,
      convRule: rule14
  }, {
      start: 66512,
      length: 1,
      convRule: rule2
  }, {
      start: 66513,
      length: 5,
      convRule: rule128
  }, {
      start: 66560,
      length: 40,
      convRule: rule201
  }, {
      start: 66600,
      length: 40,
      convRule: rule202
  }, {
      start: 66640,
      length: 78,
      convRule: rule14
  }, {
      start: 66720,
      length: 10,
      convRule: rule8
  }, {
      start: 66736,
      length: 36,
      convRule: rule201
  }, {
      start: 66776,
      length: 36,
      convRule: rule202
  }, {
      start: 66816,
      length: 40,
      convRule: rule14
  }, {
      start: 66864,
      length: 52,
      convRule: rule14
  }, {
      start: 66927,
      length: 1,
      convRule: rule2
  }, {
      start: 67072,
      length: 311,
      convRule: rule14
  }, {
      start: 67392,
      length: 22,
      convRule: rule14
  }, {
      start: 67424,
      length: 8,
      convRule: rule14
  }, {
      start: 67584,
      length: 6,
      convRule: rule14
  }, {
      start: 67592,
      length: 1,
      convRule: rule14
  }, {
      start: 67594,
      length: 44,
      convRule: rule14
  }, {
      start: 67639,
      length: 2,
      convRule: rule14
  }, {
      start: 67644,
      length: 1,
      convRule: rule14
  }, {
      start: 67647,
      length: 23,
      convRule: rule14
  }, {
      start: 67671,
      length: 1,
      convRule: rule2
  }, {
      start: 67672,
      length: 8,
      convRule: rule17
  }, {
      start: 67680,
      length: 23,
      convRule: rule14
  }, {
      start: 67703,
      length: 2,
      convRule: rule13
  }, {
      start: 67705,
      length: 7,
      convRule: rule17
  }, {
      start: 67712,
      length: 31,
      convRule: rule14
  }, {
      start: 67751,
      length: 9,
      convRule: rule17
  }, {
      start: 67808,
      length: 19,
      convRule: rule14
  }, {
      start: 67828,
      length: 2,
      convRule: rule14
  }, {
      start: 67835,
      length: 5,
      convRule: rule17
  }, {
      start: 67840,
      length: 22,
      convRule: rule14
  }, {
      start: 67862,
      length: 6,
      convRule: rule17
  }, {
      start: 67871,
      length: 1,
      convRule: rule2
  }, {
      start: 67872,
      length: 26,
      convRule: rule14
  }, {
      start: 67903,
      length: 1,
      convRule: rule2
  }, {
      start: 67968,
      length: 56,
      convRule: rule14
  }, {
      start: 68028,
      length: 2,
      convRule: rule17
  }, {
      start: 68030,
      length: 2,
      convRule: rule14
  }, {
      start: 68032,
      length: 16,
      convRule: rule17
  }, {
      start: 68050,
      length: 46,
      convRule: rule17
  }, {
      start: 68096,
      length: 1,
      convRule: rule14
  }, {
      start: 68097,
      length: 3,
      convRule: rule92
  }, {
      start: 68101,
      length: 2,
      convRule: rule92
  }, {
      start: 68108,
      length: 4,
      convRule: rule92
  }, {
      start: 68112,
      length: 4,
      convRule: rule14
  }, {
      start: 68117,
      length: 3,
      convRule: rule14
  }, {
      start: 68121,
      length: 29,
      convRule: rule14
  }, {
      start: 68152,
      length: 3,
      convRule: rule92
  }, {
      start: 68159,
      length: 1,
      convRule: rule92
  }, {
      start: 68160,
      length: 9,
      convRule: rule17
  }, {
      start: 68176,
      length: 9,
      convRule: rule2
  }, {
      start: 68192,
      length: 29,
      convRule: rule14
  }, {
      start: 68221,
      length: 2,
      convRule: rule17
  }, {
      start: 68223,
      length: 1,
      convRule: rule2
  }, {
      start: 68224,
      length: 29,
      convRule: rule14
  }, {
      start: 68253,
      length: 3,
      convRule: rule17
  }, {
      start: 68288,
      length: 8,
      convRule: rule14
  }, {
      start: 68296,
      length: 1,
      convRule: rule13
  }, {
      start: 68297,
      length: 28,
      convRule: rule14
  }, {
      start: 68325,
      length: 2,
      convRule: rule92
  }, {
      start: 68331,
      length: 5,
      convRule: rule17
  }, {
      start: 68336,
      length: 7,
      convRule: rule2
  }, {
      start: 68352,
      length: 54,
      convRule: rule14
  }, {
      start: 68409,
      length: 7,
      convRule: rule2
  }, {
      start: 68416,
      length: 22,
      convRule: rule14
  }, {
      start: 68440,
      length: 8,
      convRule: rule17
  }, {
      start: 68448,
      length: 19,
      convRule: rule14
  }, {
      start: 68472,
      length: 8,
      convRule: rule17
  }, {
      start: 68480,
      length: 18,
      convRule: rule14
  }, {
      start: 68505,
      length: 4,
      convRule: rule2
  }, {
      start: 68521,
      length: 7,
      convRule: rule17
  }, {
      start: 68608,
      length: 73,
      convRule: rule14
  }, {
      start: 68736,
      length: 51,
      convRule: rule97
  }, {
      start: 68800,
      length: 51,
      convRule: rule102
  }, {
      start: 68858,
      length: 6,
      convRule: rule17
  }, {
      start: 68864,
      length: 36,
      convRule: rule14
  }, {
      start: 68900,
      length: 4,
      convRule: rule92
  }, {
      start: 68912,
      length: 10,
      convRule: rule8
  }, {
      start: 69216,
      length: 31,
      convRule: rule17
  }, {
      start: 69248,
      length: 42,
      convRule: rule14
  }, {
      start: 69291,
      length: 2,
      convRule: rule92
  }, {
      start: 69293,
      length: 1,
      convRule: rule7
  }, {
      start: 69296,
      length: 2,
      convRule: rule14
  }, {
      start: 69376,
      length: 29,
      convRule: rule14
  }, {
      start: 69405,
      length: 10,
      convRule: rule17
  }, {
      start: 69415,
      length: 1,
      convRule: rule14
  }, {
      start: 69424,
      length: 22,
      convRule: rule14
  }, {
      start: 69446,
      length: 11,
      convRule: rule92
  }, {
      start: 69457,
      length: 4,
      convRule: rule17
  }, {
      start: 69461,
      length: 5,
      convRule: rule2
  }, {
      start: 69552,
      length: 21,
      convRule: rule14
  }, {
      start: 69573,
      length: 7,
      convRule: rule17
  }, {
      start: 69600,
      length: 23,
      convRule: rule14
  }, {
      start: 69632,
      length: 1,
      convRule: rule124
  }, {
      start: 69633,
      length: 1,
      convRule: rule92
  }, {
      start: 69634,
      length: 1,
      convRule: rule124
  }, {
      start: 69635,
      length: 53,
      convRule: rule14
  }, {
      start: 69688,
      length: 15,
      convRule: rule92
  }, {
      start: 69703,
      length: 7,
      convRule: rule2
  }, {
      start: 69714,
      length: 20,
      convRule: rule17
  }, {
      start: 69734,
      length: 10,
      convRule: rule8
  }, {
      start: 69759,
      length: 3,
      convRule: rule92
  }, {
      start: 69762,
      length: 1,
      convRule: rule124
  }, {
      start: 69763,
      length: 45,
      convRule: rule14
  }, {
      start: 69808,
      length: 3,
      convRule: rule124
  }, {
      start: 69811,
      length: 4,
      convRule: rule92
  }, {
      start: 69815,
      length: 2,
      convRule: rule124
  }, {
      start: 69817,
      length: 2,
      convRule: rule92
  }, {
      start: 69819,
      length: 2,
      convRule: rule2
  }, {
      start: 69821,
      length: 1,
      convRule: rule16
  }, {
      start: 69822,
      length: 4,
      convRule: rule2
  }, {
      start: 69837,
      length: 1,
      convRule: rule16
  }, {
      start: 69840,
      length: 25,
      convRule: rule14
  }, {
      start: 69872,
      length: 10,
      convRule: rule8
  }, {
      start: 69888,
      length: 3,
      convRule: rule92
  }, {
      start: 69891,
      length: 36,
      convRule: rule14
  }, {
      start: 69927,
      length: 5,
      convRule: rule92
  }, {
      start: 69932,
      length: 1,
      convRule: rule124
  }, {
      start: 69933,
      length: 8,
      convRule: rule92
  }, {
      start: 69942,
      length: 10,
      convRule: rule8
  }, {
      start: 69952,
      length: 4,
      convRule: rule2
  }, {
      start: 69956,
      length: 1,
      convRule: rule14
  }, {
      start: 69957,
      length: 2,
      convRule: rule124
  }, {
      start: 69959,
      length: 1,
      convRule: rule14
  }, {
      start: 69968,
      length: 35,
      convRule: rule14
  }, {
      start: 70003,
      length: 1,
      convRule: rule92
  }, {
      start: 70004,
      length: 2,
      convRule: rule2
  }, {
      start: 70006,
      length: 1,
      convRule: rule14
  }, {
      start: 70016,
      length: 2,
      convRule: rule92
  }, {
      start: 70018,
      length: 1,
      convRule: rule124
  }, {
      start: 70019,
      length: 48,
      convRule: rule14
  }, {
      start: 70067,
      length: 3,
      convRule: rule124
  }, {
      start: 70070,
      length: 9,
      convRule: rule92
  }, {
      start: 70079,
      length: 2,
      convRule: rule124
  }, {
      start: 70081,
      length: 4,
      convRule: rule14
  }, {
      start: 70085,
      length: 4,
      convRule: rule2
  }, {
      start: 70089,
      length: 4,
      convRule: rule92
  }, {
      start: 70093,
      length: 1,
      convRule: rule2
  }, {
      start: 70094,
      length: 1,
      convRule: rule124
  }, {
      start: 70095,
      length: 1,
      convRule: rule92
  }, {
      start: 70096,
      length: 10,
      convRule: rule8
  }, {
      start: 70106,
      length: 1,
      convRule: rule14
  }, {
      start: 70107,
      length: 1,
      convRule: rule2
  }, {
      start: 70108,
      length: 1,
      convRule: rule14
  }, {
      start: 70109,
      length: 3,
      convRule: rule2
  }, {
      start: 70113,
      length: 20,
      convRule: rule17
  }, {
      start: 70144,
      length: 18,
      convRule: rule14
  }, {
      start: 70163,
      length: 25,
      convRule: rule14
  }, {
      start: 70188,
      length: 3,
      convRule: rule124
  }, {
      start: 70191,
      length: 3,
      convRule: rule92
  }, {
      start: 70194,
      length: 2,
      convRule: rule124
  }, {
      start: 70196,
      length: 1,
      convRule: rule92
  }, {
      start: 70197,
      length: 1,
      convRule: rule124
  }, {
      start: 70198,
      length: 2,
      convRule: rule92
  }, {
      start: 70200,
      length: 6,
      convRule: rule2
  }, {
      start: 70206,
      length: 1,
      convRule: rule92
  }, {
      start: 70272,
      length: 7,
      convRule: rule14
  }, {
      start: 70280,
      length: 1,
      convRule: rule14
  }, {
      start: 70282,
      length: 4,
      convRule: rule14
  }, {
      start: 70287,
      length: 15,
      convRule: rule14
  }, {
      start: 70303,
      length: 10,
      convRule: rule14
  }, {
      start: 70313,
      length: 1,
      convRule: rule2
  }, {
      start: 70320,
      length: 47,
      convRule: rule14
  }, {
      start: 70367,
      length: 1,
      convRule: rule92
  }, {
      start: 70368,
      length: 3,
      convRule: rule124
  }, {
      start: 70371,
      length: 8,
      convRule: rule92
  }, {
      start: 70384,
      length: 10,
      convRule: rule8
  }, {
      start: 70400,
      length: 2,
      convRule: rule92
  }, {
      start: 70402,
      length: 2,
      convRule: rule124
  }, {
      start: 70405,
      length: 8,
      convRule: rule14
  }, {
      start: 70415,
      length: 2,
      convRule: rule14
  }, {
      start: 70419,
      length: 22,
      convRule: rule14
  }, {
      start: 70442,
      length: 7,
      convRule: rule14
  }, {
      start: 70450,
      length: 2,
      convRule: rule14
  }, {
      start: 70453,
      length: 5,
      convRule: rule14
  }, {
      start: 70459,
      length: 2,
      convRule: rule92
  }, {
      start: 70461,
      length: 1,
      convRule: rule14
  }, {
      start: 70462,
      length: 2,
      convRule: rule124
  }, {
      start: 70464,
      length: 1,
      convRule: rule92
  }, {
      start: 70465,
      length: 4,
      convRule: rule124
  }, {
      start: 70471,
      length: 2,
      convRule: rule124
  }, {
      start: 70475,
      length: 3,
      convRule: rule124
  }, {
      start: 70480,
      length: 1,
      convRule: rule14
  }, {
      start: 70487,
      length: 1,
      convRule: rule124
  }, {
      start: 70493,
      length: 5,
      convRule: rule14
  }, {
      start: 70498,
      length: 2,
      convRule: rule124
  }, {
      start: 70502,
      length: 7,
      convRule: rule92
  }, {
      start: 70512,
      length: 5,
      convRule: rule92
  }, {
      start: 70656,
      length: 53,
      convRule: rule14
  }, {
      start: 70709,
      length: 3,
      convRule: rule124
  }, {
      start: 70712,
      length: 8,
      convRule: rule92
  }, {
      start: 70720,
      length: 2,
      convRule: rule124
  }, {
      start: 70722,
      length: 3,
      convRule: rule92
  }, {
      start: 70725,
      length: 1,
      convRule: rule124
  }, {
      start: 70726,
      length: 1,
      convRule: rule92
  }, {
      start: 70727,
      length: 4,
      convRule: rule14
  }, {
      start: 70731,
      length: 5,
      convRule: rule2
  }, {
      start: 70736,
      length: 10,
      convRule: rule8
  }, {
      start: 70746,
      length: 2,
      convRule: rule2
  }, {
      start: 70749,
      length: 1,
      convRule: rule2
  }, {
      start: 70750,
      length: 1,
      convRule: rule92
  }, {
      start: 70751,
      length: 3,
      convRule: rule14
  }, {
      start: 70784,
      length: 48,
      convRule: rule14
  }, {
      start: 70832,
      length: 3,
      convRule: rule124
  }, {
      start: 70835,
      length: 6,
      convRule: rule92
  }, {
      start: 70841,
      length: 1,
      convRule: rule124
  }, {
      start: 70842,
      length: 1,
      convRule: rule92
  }, {
      start: 70843,
      length: 4,
      convRule: rule124
  }, {
      start: 70847,
      length: 2,
      convRule: rule92
  }, {
      start: 70849,
      length: 1,
      convRule: rule124
  }, {
      start: 70850,
      length: 2,
      convRule: rule92
  }, {
      start: 70852,
      length: 2,
      convRule: rule14
  }, {
      start: 70854,
      length: 1,
      convRule: rule2
  }, {
      start: 70855,
      length: 1,
      convRule: rule14
  }, {
      start: 70864,
      length: 10,
      convRule: rule8
  }, {
      start: 71040,
      length: 47,
      convRule: rule14
  }, {
      start: 71087,
      length: 3,
      convRule: rule124
  }, {
      start: 71090,
      length: 4,
      convRule: rule92
  }, {
      start: 71096,
      length: 4,
      convRule: rule124
  }, {
      start: 71100,
      length: 2,
      convRule: rule92
  }, {
      start: 71102,
      length: 1,
      convRule: rule124
  }, {
      start: 71103,
      length: 2,
      convRule: rule92
  }, {
      start: 71105,
      length: 23,
      convRule: rule2
  }, {
      start: 71128,
      length: 4,
      convRule: rule14
  }, {
      start: 71132,
      length: 2,
      convRule: rule92
  }, {
      start: 71168,
      length: 48,
      convRule: rule14
  }, {
      start: 71216,
      length: 3,
      convRule: rule124
  }, {
      start: 71219,
      length: 8,
      convRule: rule92
  }, {
      start: 71227,
      length: 2,
      convRule: rule124
  }, {
      start: 71229,
      length: 1,
      convRule: rule92
  }, {
      start: 71230,
      length: 1,
      convRule: rule124
  }, {
      start: 71231,
      length: 2,
      convRule: rule92
  }, {
      start: 71233,
      length: 3,
      convRule: rule2
  }, {
      start: 71236,
      length: 1,
      convRule: rule14
  }, {
      start: 71248,
      length: 10,
      convRule: rule8
  }, {
      start: 71264,
      length: 13,
      convRule: rule2
  }, {
      start: 71296,
      length: 43,
      convRule: rule14
  }, {
      start: 71339,
      length: 1,
      convRule: rule92
  }, {
      start: 71340,
      length: 1,
      convRule: rule124
  }, {
      start: 71341,
      length: 1,
      convRule: rule92
  }, {
      start: 71342,
      length: 2,
      convRule: rule124
  }, {
      start: 71344,
      length: 6,
      convRule: rule92
  }, {
      start: 71350,
      length: 1,
      convRule: rule124
  }, {
      start: 71351,
      length: 1,
      convRule: rule92
  }, {
      start: 71352,
      length: 1,
      convRule: rule14
  }, {
      start: 71360,
      length: 10,
      convRule: rule8
  }, {
      start: 71424,
      length: 27,
      convRule: rule14
  }, {
      start: 71453,
      length: 3,
      convRule: rule92
  }, {
      start: 71456,
      length: 2,
      convRule: rule124
  }, {
      start: 71458,
      length: 4,
      convRule: rule92
  }, {
      start: 71462,
      length: 1,
      convRule: rule124
  }, {
      start: 71463,
      length: 5,
      convRule: rule92
  }, {
      start: 71472,
      length: 10,
      convRule: rule8
  }, {
      start: 71482,
      length: 2,
      convRule: rule17
  }, {
      start: 71484,
      length: 3,
      convRule: rule2
  }, {
      start: 71487,
      length: 1,
      convRule: rule13
  }, {
      start: 71680,
      length: 44,
      convRule: rule14
  }, {
      start: 71724,
      length: 3,
      convRule: rule124
  }, {
      start: 71727,
      length: 9,
      convRule: rule92
  }, {
      start: 71736,
      length: 1,
      convRule: rule124
  }, {
      start: 71737,
      length: 2,
      convRule: rule92
  }, {
      start: 71739,
      length: 1,
      convRule: rule2
  }, {
      start: 71840,
      length: 32,
      convRule: rule9
  }, {
      start: 71872,
      length: 32,
      convRule: rule12
  }, {
      start: 71904,
      length: 10,
      convRule: rule8
  }, {
      start: 71914,
      length: 9,
      convRule: rule17
  }, {
      start: 71935,
      length: 8,
      convRule: rule14
  }, {
      start: 71945,
      length: 1,
      convRule: rule14
  }, {
      start: 71948,
      length: 8,
      convRule: rule14
  }, {
      start: 71957,
      length: 2,
      convRule: rule14
  }, {
      start: 71960,
      length: 24,
      convRule: rule14
  }, {
      start: 71984,
      length: 6,
      convRule: rule124
  }, {
      start: 71991,
      length: 2,
      convRule: rule124
  }, {
      start: 71995,
      length: 2,
      convRule: rule92
  }, {
      start: 71997,
      length: 1,
      convRule: rule124
  }, {
      start: 71998,
      length: 1,
      convRule: rule92
  }, {
      start: 71999,
      length: 1,
      convRule: rule14
  }, {
      start: 72000,
      length: 1,
      convRule: rule124
  }, {
      start: 72001,
      length: 1,
      convRule: rule14
  }, {
      start: 72002,
      length: 1,
      convRule: rule124
  }, {
      start: 72003,
      length: 1,
      convRule: rule92
  }, {
      start: 72004,
      length: 3,
      convRule: rule2
  }, {
      start: 72016,
      length: 10,
      convRule: rule8
  }, {
      start: 72096,
      length: 8,
      convRule: rule14
  }, {
      start: 72106,
      length: 39,
      convRule: rule14
  }, {
      start: 72145,
      length: 3,
      convRule: rule124
  }, {
      start: 72148,
      length: 4,
      convRule: rule92
  }, {
      start: 72154,
      length: 2,
      convRule: rule92
  }, {
      start: 72156,
      length: 4,
      convRule: rule124
  }, {
      start: 72160,
      length: 1,
      convRule: rule92
  }, {
      start: 72161,
      length: 1,
      convRule: rule14
  }, {
      start: 72162,
      length: 1,
      convRule: rule2
  }, {
      start: 72163,
      length: 1,
      convRule: rule14
  }, {
      start: 72164,
      length: 1,
      convRule: rule124
  }, {
      start: 72192,
      length: 1,
      convRule: rule14
  }, {
      start: 72193,
      length: 10,
      convRule: rule92
  }, {
      start: 72203,
      length: 40,
      convRule: rule14
  }, {
      start: 72243,
      length: 6,
      convRule: rule92
  }, {
      start: 72249,
      length: 1,
      convRule: rule124
  }, {
      start: 72250,
      length: 1,
      convRule: rule14
  }, {
      start: 72251,
      length: 4,
      convRule: rule92
  }, {
      start: 72255,
      length: 8,
      convRule: rule2
  }, {
      start: 72263,
      length: 1,
      convRule: rule92
  }, {
      start: 72272,
      length: 1,
      convRule: rule14
  }, {
      start: 72273,
      length: 6,
      convRule: rule92
  }, {
      start: 72279,
      length: 2,
      convRule: rule124
  }, {
      start: 72281,
      length: 3,
      convRule: rule92
  }, {
      start: 72284,
      length: 46,
      convRule: rule14
  }, {
      start: 72330,
      length: 13,
      convRule: rule92
  }, {
      start: 72343,
      length: 1,
      convRule: rule124
  }, {
      start: 72344,
      length: 2,
      convRule: rule92
  }, {
      start: 72346,
      length: 3,
      convRule: rule2
  }, {
      start: 72349,
      length: 1,
      convRule: rule14
  }, {
      start: 72350,
      length: 5,
      convRule: rule2
  }, {
      start: 72384,
      length: 57,
      convRule: rule14
  }, {
      start: 72704,
      length: 9,
      convRule: rule14
  }, {
      start: 72714,
      length: 37,
      convRule: rule14
  }, {
      start: 72751,
      length: 1,
      convRule: rule124
  }, {
      start: 72752,
      length: 7,
      convRule: rule92
  }, {
      start: 72760,
      length: 6,
      convRule: rule92
  }, {
      start: 72766,
      length: 1,
      convRule: rule124
  }, {
      start: 72767,
      length: 1,
      convRule: rule92
  }, {
      start: 72768,
      length: 1,
      convRule: rule14
  }, {
      start: 72769,
      length: 5,
      convRule: rule2
  }, {
      start: 72784,
      length: 10,
      convRule: rule8
  }, {
      start: 72794,
      length: 19,
      convRule: rule17
  }, {
      start: 72816,
      length: 2,
      convRule: rule2
  }, {
      start: 72818,
      length: 30,
      convRule: rule14
  }, {
      start: 72850,
      length: 22,
      convRule: rule92
  }, {
      start: 72873,
      length: 1,
      convRule: rule124
  }, {
      start: 72874,
      length: 7,
      convRule: rule92
  }, {
      start: 72881,
      length: 1,
      convRule: rule124
  }, {
      start: 72882,
      length: 2,
      convRule: rule92
  }, {
      start: 72884,
      length: 1,
      convRule: rule124
  }, {
      start: 72885,
      length: 2,
      convRule: rule92
  }, {
      start: 72960,
      length: 7,
      convRule: rule14
  }, {
      start: 72968,
      length: 2,
      convRule: rule14
  }, {
      start: 72971,
      length: 38,
      convRule: rule14
  }, {
      start: 73009,
      length: 6,
      convRule: rule92
  }, {
      start: 73018,
      length: 1,
      convRule: rule92
  }, {
      start: 73020,
      length: 2,
      convRule: rule92
  }, {
      start: 73023,
      length: 7,
      convRule: rule92
  }, {
      start: 73030,
      length: 1,
      convRule: rule14
  }, {
      start: 73031,
      length: 1,
      convRule: rule92
  }, {
      start: 73040,
      length: 10,
      convRule: rule8
  }, {
      start: 73056,
      length: 6,
      convRule: rule14
  }, {
      start: 73063,
      length: 2,
      convRule: rule14
  }, {
      start: 73066,
      length: 32,
      convRule: rule14
  }, {
      start: 73098,
      length: 5,
      convRule: rule124
  }, {
      start: 73104,
      length: 2,
      convRule: rule92
  }, {
      start: 73107,
      length: 2,
      convRule: rule124
  }, {
      start: 73109,
      length: 1,
      convRule: rule92
  }, {
      start: 73110,
      length: 1,
      convRule: rule124
  }, {
      start: 73111,
      length: 1,
      convRule: rule92
  }, {
      start: 73112,
      length: 1,
      convRule: rule14
  }, {
      start: 73120,
      length: 10,
      convRule: rule8
  }, {
      start: 73440,
      length: 19,
      convRule: rule14
  }, {
      start: 73459,
      length: 2,
      convRule: rule92
  }, {
      start: 73461,
      length: 2,
      convRule: rule124
  }, {
      start: 73463,
      length: 2,
      convRule: rule2
  }, {
      start: 73648,
      length: 1,
      convRule: rule14
  }, {
      start: 73664,
      length: 21,
      convRule: rule17
  }, {
      start: 73685,
      length: 8,
      convRule: rule13
  }, {
      start: 73693,
      length: 4,
      convRule: rule3
  }, {
      start: 73697,
      length: 17,
      convRule: rule13
  }, {
      start: 73727,
      length: 1,
      convRule: rule2
  }, {
      start: 73728,
      length: 922,
      convRule: rule14
  }, {
      start: 74752,
      length: 111,
      convRule: rule128
  }, {
      start: 74864,
      length: 5,
      convRule: rule2
  }, {
      start: 74880,
      length: 196,
      convRule: rule14
  }, {
      start: 77824,
      length: 1071,
      convRule: rule14
  }, {
      start: 78896,
      length: 9,
      convRule: rule16
  }, {
      start: 82944,
      length: 583,
      convRule: rule14
  }, {
      start: 92160,
      length: 569,
      convRule: rule14
  }, {
      start: 92736,
      length: 31,
      convRule: rule14
  }, {
      start: 92768,
      length: 10,
      convRule: rule8
  }, {
      start: 92782,
      length: 2,
      convRule: rule2
  }, {
      start: 92880,
      length: 30,
      convRule: rule14
  }, {
      start: 92912,
      length: 5,
      convRule: rule92
  }, {
      start: 92917,
      length: 1,
      convRule: rule2
  }, {
      start: 92928,
      length: 48,
      convRule: rule14
  }, {
      start: 92976,
      length: 7,
      convRule: rule92
  }, {
      start: 92983,
      length: 5,
      convRule: rule2
  }, {
      start: 92988,
      length: 4,
      convRule: rule13
  }, {
      start: 92992,
      length: 4,
      convRule: rule91
  }, {
      start: 92996,
      length: 1,
      convRule: rule2
  }, {
      start: 92997,
      length: 1,
      convRule: rule13
  }, {
      start: 93008,
      length: 10,
      convRule: rule8
  }, {
      start: 93019,
      length: 7,
      convRule: rule17
  }, {
      start: 93027,
      length: 21,
      convRule: rule14
  }, {
      start: 93053,
      length: 19,
      convRule: rule14
  }, {
      start: 93760,
      length: 32,
      convRule: rule9
  }, {
      start: 93792,
      length: 32,
      convRule: rule12
  }, {
      start: 93824,
      length: 23,
      convRule: rule17
  }, {
      start: 93847,
      length: 4,
      convRule: rule2
  }, {
      start: 93952,
      length: 75,
      convRule: rule14
  }, {
      start: 94031,
      length: 1,
      convRule: rule92
  }, {
      start: 94032,
      length: 1,
      convRule: rule14
  }, {
      start: 94033,
      length: 55,
      convRule: rule124
  }, {
      start: 94095,
      length: 4,
      convRule: rule92
  }, {
      start: 94099,
      length: 13,
      convRule: rule91
  }, {
      start: 94176,
      length: 2,
      convRule: rule91
  }, {
      start: 94178,
      length: 1,
      convRule: rule2
  }, {
      start: 94179,
      length: 1,
      convRule: rule91
  }, {
      start: 94180,
      length: 1,
      convRule: rule92
  }, {
      start: 94192,
      length: 2,
      convRule: rule124
  }, {
      start: 94208,
      length: 6136,
      convRule: rule14
  }, {
      start: 100352,
      length: 1238,
      convRule: rule14
  }, {
      start: 101632,
      length: 9,
      convRule: rule14
  }, {
      start: 110592,
      length: 287,
      convRule: rule14
  }, {
      start: 110928,
      length: 3,
      convRule: rule14
  }, {
      start: 110948,
      length: 4,
      convRule: rule14
  }, {
      start: 110960,
      length: 396,
      convRule: rule14
  }, {
      start: 113664,
      length: 107,
      convRule: rule14
  }, {
      start: 113776,
      length: 13,
      convRule: rule14
  }, {
      start: 113792,
      length: 9,
      convRule: rule14
  }, {
      start: 113808,
      length: 10,
      convRule: rule14
  }, {
      start: 113820,
      length: 1,
      convRule: rule13
  }, {
      start: 113821,
      length: 2,
      convRule: rule92
  }, {
      start: 113823,
      length: 1,
      convRule: rule2
  }, {
      start: 113824,
      length: 4,
      convRule: rule16
  }, {
      start: 118784,
      length: 246,
      convRule: rule13
  }, {
      start: 119040,
      length: 39,
      convRule: rule13
  }, {
      start: 119081,
      length: 60,
      convRule: rule13
  }, {
      start: 119141,
      length: 2,
      convRule: rule124
  }, {
      start: 119143,
      length: 3,
      convRule: rule92
  }, {
      start: 119146,
      length: 3,
      convRule: rule13
  }, {
      start: 119149,
      length: 6,
      convRule: rule124
  }, {
      start: 119155,
      length: 8,
      convRule: rule16
  }, {
      start: 119163,
      length: 8,
      convRule: rule92
  }, {
      start: 119171,
      length: 2,
      convRule: rule13
  }, {
      start: 119173,
      length: 7,
      convRule: rule92
  }, {
      start: 119180,
      length: 30,
      convRule: rule13
  }, {
      start: 119210,
      length: 4,
      convRule: rule92
  }, {
      start: 119214,
      length: 59,
      convRule: rule13
  }, {
      start: 119296,
      length: 66,
      convRule: rule13
  }, {
      start: 119362,
      length: 3,
      convRule: rule92
  }, {
      start: 119365,
      length: 1,
      convRule: rule13
  }, {
      start: 119520,
      length: 20,
      convRule: rule17
  }, {
      start: 119552,
      length: 87,
      convRule: rule13
  }, {
      start: 119648,
      length: 25,
      convRule: rule17
  }, {
      start: 119808,
      length: 26,
      convRule: rule107
  }, {
      start: 119834,
      length: 26,
      convRule: rule20
  }, {
      start: 119860,
      length: 26,
      convRule: rule107
  }, {
      start: 119886,
      length: 7,
      convRule: rule20
  }, {
      start: 119894,
      length: 18,
      convRule: rule20
  }, {
      start: 119912,
      length: 26,
      convRule: rule107
  }, {
      start: 119938,
      length: 26,
      convRule: rule20
  }, {
      start: 119964,
      length: 1,
      convRule: rule107
  }, {
      start: 119966,
      length: 2,
      convRule: rule107
  }, {
      start: 119970,
      length: 1,
      convRule: rule107
  }, {
      start: 119973,
      length: 2,
      convRule: rule107
  }, {
      start: 119977,
      length: 4,
      convRule: rule107
  }, {
      start: 119982,
      length: 8,
      convRule: rule107
  }, {
      start: 119990,
      length: 4,
      convRule: rule20
  }, {
      start: 119995,
      length: 1,
      convRule: rule20
  }, {
      start: 119997,
      length: 7,
      convRule: rule20
  }, {
      start: 120005,
      length: 11,
      convRule: rule20
  }, {
      start: 120016,
      length: 26,
      convRule: rule107
  }, {
      start: 120042,
      length: 26,
      convRule: rule20
  }, {
      start: 120068,
      length: 2,
      convRule: rule107
  }, {
      start: 120071,
      length: 4,
      convRule: rule107
  }, {
      start: 120077,
      length: 8,
      convRule: rule107
  }, {
      start: 120086,
      length: 7,
      convRule: rule107
  }, {
      start: 120094,
      length: 26,
      convRule: rule20
  }, {
      start: 120120,
      length: 2,
      convRule: rule107
  }, {
      start: 120123,
      length: 4,
      convRule: rule107
  }, {
      start: 120128,
      length: 5,
      convRule: rule107
  }, {
      start: 120134,
      length: 1,
      convRule: rule107
  }, {
      start: 120138,
      length: 7,
      convRule: rule107
  }, {
      start: 120146,
      length: 26,
      convRule: rule20
  }, {
      start: 120172,
      length: 26,
      convRule: rule107
  }, {
      start: 120198,
      length: 26,
      convRule: rule20
  }, {
      start: 120224,
      length: 26,
      convRule: rule107
  }, {
      start: 120250,
      length: 26,
      convRule: rule20
  }, {
      start: 120276,
      length: 26,
      convRule: rule107
  }, {
      start: 120302,
      length: 26,
      convRule: rule20
  }, {
      start: 120328,
      length: 26,
      convRule: rule107
  }, {
      start: 120354,
      length: 26,
      convRule: rule20
  }, {
      start: 120380,
      length: 26,
      convRule: rule107
  }, {
      start: 120406,
      length: 26,
      convRule: rule20
  }, {
      start: 120432,
      length: 26,
      convRule: rule107
  }, {
      start: 120458,
      length: 28,
      convRule: rule20
  }, {
      start: 120488,
      length: 25,
      convRule: rule107
  }, {
      start: 120513,
      length: 1,
      convRule: rule6
  }, {
      start: 120514,
      length: 25,
      convRule: rule20
  }, {
      start: 120539,
      length: 1,
      convRule: rule6
  }, {
      start: 120540,
      length: 6,
      convRule: rule20
  }, {
      start: 120546,
      length: 25,
      convRule: rule107
  }, {
      start: 120571,
      length: 1,
      convRule: rule6
  }, {
      start: 120572,
      length: 25,
      convRule: rule20
  }, {
      start: 120597,
      length: 1,
      convRule: rule6
  }, {
      start: 120598,
      length: 6,
      convRule: rule20
  }, {
      start: 120604,
      length: 25,
      convRule: rule107
  }, {
      start: 120629,
      length: 1,
      convRule: rule6
  }, {
      start: 120630,
      length: 25,
      convRule: rule20
  }, {
      start: 120655,
      length: 1,
      convRule: rule6
  }, {
      start: 120656,
      length: 6,
      convRule: rule20
  }, {
      start: 120662,
      length: 25,
      convRule: rule107
  }, {
      start: 120687,
      length: 1,
      convRule: rule6
  }, {
      start: 120688,
      length: 25,
      convRule: rule20
  }, {
      start: 120713,
      length: 1,
      convRule: rule6
  }, {
      start: 120714,
      length: 6,
      convRule: rule20
  }, {
      start: 120720,
      length: 25,
      convRule: rule107
  }, {
      start: 120745,
      length: 1,
      convRule: rule6
  }, {
      start: 120746,
      length: 25,
      convRule: rule20
  }, {
      start: 120771,
      length: 1,
      convRule: rule6
  }, {
      start: 120772,
      length: 6,
      convRule: rule20
  }, {
      start: 120778,
      length: 1,
      convRule: rule107
  }, {
      start: 120779,
      length: 1,
      convRule: rule20
  }, {
      start: 120782,
      length: 50,
      convRule: rule8
  }, {
      start: 120832,
      length: 512,
      convRule: rule13
  }, {
      start: 121344,
      length: 55,
      convRule: rule92
  }, {
      start: 121399,
      length: 4,
      convRule: rule13
  }, {
      start: 121403,
      length: 50,
      convRule: rule92
  }, {
      start: 121453,
      length: 8,
      convRule: rule13
  }, {
      start: 121461,
      length: 1,
      convRule: rule92
  }, {
      start: 121462,
      length: 14,
      convRule: rule13
  }, {
      start: 121476,
      length: 1,
      convRule: rule92
  }, {
      start: 121477,
      length: 2,
      convRule: rule13
  }, {
      start: 121479,
      length: 5,
      convRule: rule2
  }, {
      start: 121499,
      length: 5,
      convRule: rule92
  }, {
      start: 121505,
      length: 15,
      convRule: rule92
  }, {
      start: 122880,
      length: 7,
      convRule: rule92
  }, {
      start: 122888,
      length: 17,
      convRule: rule92
  }, {
      start: 122907,
      length: 7,
      convRule: rule92
  }, {
      start: 122915,
      length: 2,
      convRule: rule92
  }, {
      start: 122918,
      length: 5,
      convRule: rule92
  }, {
      start: 123136,
      length: 45,
      convRule: rule14
  }, {
      start: 123184,
      length: 7,
      convRule: rule92
  }, {
      start: 123191,
      length: 7,
      convRule: rule91
  }, {
      start: 123200,
      length: 10,
      convRule: rule8
  }, {
      start: 123214,
      length: 1,
      convRule: rule14
  }, {
      start: 123215,
      length: 1,
      convRule: rule13
  }, {
      start: 123584,
      length: 44,
      convRule: rule14
  }, {
      start: 123628,
      length: 4,
      convRule: rule92
  }, {
      start: 123632,
      length: 10,
      convRule: rule8
  }, {
      start: 123647,
      length: 1,
      convRule: rule3
  }, {
      start: 124928,
      length: 197,
      convRule: rule14
  }, {
      start: 125127,
      length: 9,
      convRule: rule17
  }, {
      start: 125136,
      length: 7,
      convRule: rule92
  }, {
      start: 125184,
      length: 34,
      convRule: rule203
  }, {
      start: 125218,
      length: 34,
      convRule: rule204
  }, {
      start: 125252,
      length: 7,
      convRule: rule92
  }, {
      start: 125259,
      length: 1,
      convRule: rule91
  }, {
      start: 125264,
      length: 10,
      convRule: rule8
  }, {
      start: 125278,
      length: 2,
      convRule: rule2
  }, {
      start: 126065,
      length: 59,
      convRule: rule17
  }, {
      start: 126124,
      length: 1,
      convRule: rule13
  }, {
      start: 126125,
      length: 3,
      convRule: rule17
  }, {
      start: 126128,
      length: 1,
      convRule: rule3
  }, {
      start: 126129,
      length: 4,
      convRule: rule17
  }, {
      start: 126209,
      length: 45,
      convRule: rule17
  }, {
      start: 126254,
      length: 1,
      convRule: rule13
  }, {
      start: 126255,
      length: 15,
      convRule: rule17
  }, {
      start: 126464,
      length: 4,
      convRule: rule14
  }, {
      start: 126469,
      length: 27,
      convRule: rule14
  }, {
      start: 126497,
      length: 2,
      convRule: rule14
  }, {
      start: 126500,
      length: 1,
      convRule: rule14
  }, {
      start: 126503,
      length: 1,
      convRule: rule14
  }, {
      start: 126505,
      length: 10,
      convRule: rule14
  }, {
      start: 126516,
      length: 4,
      convRule: rule14
  }, {
      start: 126521,
      length: 1,
      convRule: rule14
  }, {
      start: 126523,
      length: 1,
      convRule: rule14
  }, {
      start: 126530,
      length: 1,
      convRule: rule14
  }, {
      start: 126535,
      length: 1,
      convRule: rule14
  }, {
      start: 126537,
      length: 1,
      convRule: rule14
  }, {
      start: 126539,
      length: 1,
      convRule: rule14
  }, {
      start: 126541,
      length: 3,
      convRule: rule14
  }, {
      start: 126545,
      length: 2,
      convRule: rule14
  }, {
      start: 126548,
      length: 1,
      convRule: rule14
  }, {
      start: 126551,
      length: 1,
      convRule: rule14
  }, {
      start: 126553,
      length: 1,
      convRule: rule14
  }, {
      start: 126555,
      length: 1,
      convRule: rule14
  }, {
      start: 126557,
      length: 1,
      convRule: rule14
  }, {
      start: 126559,
      length: 1,
      convRule: rule14
  }, {
      start: 126561,
      length: 2,
      convRule: rule14
  }, {
      start: 126564,
      length: 1,
      convRule: rule14
  }, {
      start: 126567,
      length: 4,
      convRule: rule14
  }, {
      start: 126572,
      length: 7,
      convRule: rule14
  }, {
      start: 126580,
      length: 4,
      convRule: rule14
  }, {
      start: 126585,
      length: 4,
      convRule: rule14
  }, {
      start: 126590,
      length: 1,
      convRule: rule14
  }, {
      start: 126592,
      length: 10,
      convRule: rule14
  }, {
      start: 126603,
      length: 17,
      convRule: rule14
  }, {
      start: 126625,
      length: 3,
      convRule: rule14
  }, {
      start: 126629,
      length: 5,
      convRule: rule14
  }, {
      start: 126635,
      length: 17,
      convRule: rule14
  }, {
      start: 126704,
      length: 2,
      convRule: rule6
  }, {
      start: 126976,
      length: 44,
      convRule: rule13
  }, {
      start: 127024,
      length: 100,
      convRule: rule13
  }, {
      start: 127136,
      length: 15,
      convRule: rule13
  }, {
      start: 127153,
      length: 15,
      convRule: rule13
  }, {
      start: 127169,
      length: 15,
      convRule: rule13
  }, {
      start: 127185,
      length: 37,
      convRule: rule13
  }, {
      start: 127232,
      length: 13,
      convRule: rule17
  }, {
      start: 127245,
      length: 161,
      convRule: rule13
  }, {
      start: 127462,
      length: 29,
      convRule: rule13
  }, {
      start: 127504,
      length: 44,
      convRule: rule13
  }, {
      start: 127552,
      length: 9,
      convRule: rule13
  }, {
      start: 127568,
      length: 2,
      convRule: rule13
  }, {
      start: 127584,
      length: 6,
      convRule: rule13
  }, {
      start: 127744,
      length: 251,
      convRule: rule13
  }, {
      start: 127995,
      length: 5,
      convRule: rule10
  }, {
      start: 128000,
      length: 728,
      convRule: rule13
  }, {
      start: 128736,
      length: 13,
      convRule: rule13
  }, {
      start: 128752,
      length: 13,
      convRule: rule13
  }, {
      start: 128768,
      length: 116,
      convRule: rule13
  }, {
      start: 128896,
      length: 89,
      convRule: rule13
  }, {
      start: 128992,
      length: 12,
      convRule: rule13
  }, {
      start: 129024,
      length: 12,
      convRule: rule13
  }, {
      start: 129040,
      length: 56,
      convRule: rule13
  }, {
      start: 129104,
      length: 10,
      convRule: rule13
  }, {
      start: 129120,
      length: 40,
      convRule: rule13
  }, {
      start: 129168,
      length: 30,
      convRule: rule13
  }, {
      start: 129200,
      length: 2,
      convRule: rule13
  }, {
      start: 129280,
      length: 121,
      convRule: rule13
  }, {
      start: 129402,
      length: 82,
      convRule: rule13
  }, {
      start: 129485,
      length: 135,
      convRule: rule13
  }, {
      start: 129632,
      length: 14,
      convRule: rule13
  }, {
      start: 129648,
      length: 5,
      convRule: rule13
  }, {
      start: 129656,
      length: 3,
      convRule: rule13
  }, {
      start: 129664,
      length: 7,
      convRule: rule13
  }, {
      start: 129680,
      length: 25,
      convRule: rule13
  }, {
      start: 129712,
      length: 7,
      convRule: rule13
  }, {
      start: 129728,
      length: 3,
      convRule: rule13
  }, {
      start: 129744,
      length: 7,
      convRule: rule13
  }, {
      start: 129792,
      length: 147,
      convRule: rule13
  }, {
      start: 129940,
      length: 55,
      convRule: rule13
  }, {
      start: 130032,
      length: 10,
      convRule: rule8
  }, {
      start: 131072,
      length: 42718,
      convRule: rule14
  }, {
      start: 173824,
      length: 4149,
      convRule: rule14
  }, {
      start: 177984,
      length: 222,
      convRule: rule14
  }, {
      start: 178208,
      length: 5762,
      convRule: rule14
  }, {
      start: 183984,
      length: 7473,
      convRule: rule14
  }, {
      start: 194560,
      length: 542,
      convRule: rule14
  }, {
      start: 196608,
      length: 4939,
      convRule: rule14
  }, {
      start: 917505,
      length: 1,
      convRule: rule16
  }, {
      start: 917536,
      length: 96,
      convRule: rule16
  }, {
      start: 917760,
      length: 240,
      convRule: rule92
  }, {
      start: 983040,
      length: 65534,
      convRule: rule200
  }, {
      start: 1048576,
      length: 65534,
      convRule: rule200
  } ];
  var checkAttr = function (categories) {
      return function ($$char) {
          var numOfBlocks = (function () {
              var $28 = $$char < 256;
              if ($28) {
                  return numLat1Blocks;
              };
              return numBlocks;
          })();
          var maybeConversionRule = getRule(allchars)($$char)(numOfBlocks);
          if (maybeConversionRule instanceof Data_Maybe.Nothing) {
              return false;
          };
          if (maybeConversionRule instanceof Data_Maybe.Just) {
              return Data_Maybe.isJust(Data_Array.elemIndex(Data_Eq.eqInt)(maybeConversionRule.value0.category)(categories));
          };
          throw new Error("Failed pattern match at Data.CodePoint.Unicode.Internal (line 5628, column 8 - line 5630, column 92): " + [ maybeConversionRule.constructor.name ]);
      };
  };
  var uIswalnum = checkAttr([ gencatLT, gencatLU, gencatLL, gencatLM, gencatLO, gencatMC, gencatME, gencatMN, gencatNO, gencatND, gencatNL ]);
  exports["uIswalnum"] = uIswalnum;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.CodePoint.Unicode"] = $PS["Data.CodePoint.Unicode"] || {};
  var exports = $PS["Data.CodePoint.Unicode"];
  var Data_Char = $PS["Data.Char"];
  var Data_CodePoint_Unicode_Internal = $PS["Data.CodePoint.Unicode.Internal"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_String_CodePoints = $PS["Data.String.CodePoints"];
  var isDecDigit = function (c) {
      var diff = Data_Enum.fromEnum(Data_String_CodePoints.boundedEnumCodePoint)(c) - Data_Char.toCharCode("0") | 0;
      return diff <= 9 && diff >= 0;
  };
  var isAlphaNum = (function () {
      var $62 = Data_Enum.fromEnum(Data_String_CodePoints.boundedEnumCodePoint);
      return function ($63) {
          return Data_CodePoint_Unicode_Internal.uIswalnum($62($63));
      };
  })();
  exports["isAlphaNum"] = isAlphaNum;
  exports["isDecDigit"] = isDecDigit;
})(PS);
(function(exports) {
  "use strict";

  var createDate = function (y, m, d) {
    var date = new Date(Date.UTC(y, m, d));
    if (y >= 0 && y < 100) {
      date.setUTCFullYear(y);
    }
    return date;
  };

  exports.canonicalDateImpl = function (ctor, y, m, d) {
    var date = createDate(y, m - 1, d);
    return ctor(date.getUTCFullYear())(date.getUTCMonth() + 1)(date.getUTCDate());
  };
})(PS["Data.Date"] = PS["Data.Date"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Date.Component"] = $PS["Data.Date.Component"] || {};
  var exports = $PS["Data.Date.Component"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Bounded = $PS["Data.Bounded"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var January = (function () {
      function January() {

      };
      January.value = new January();
      return January;
  })();
  var February = (function () {
      function February() {

      };
      February.value = new February();
      return February;
  })();
  var March = (function () {
      function March() {

      };
      March.value = new March();
      return March;
  })();
  var April = (function () {
      function April() {

      };
      April.value = new April();
      return April;
  })();
  var May = (function () {
      function May() {

      };
      May.value = new May();
      return May;
  })();
  var June = (function () {
      function June() {

      };
      June.value = new June();
      return June;
  })();
  var July = (function () {
      function July() {

      };
      July.value = new July();
      return July;
  })();
  var August = (function () {
      function August() {

      };
      August.value = new August();
      return August;
  })();
  var September = (function () {
      function September() {

      };
      September.value = new September();
      return September;
  })();
  var October = (function () {
      function October() {

      };
      October.value = new October();
      return October;
  })();
  var November = (function () {
      function November() {

      };
      November.value = new November();
      return November;
  })();
  var December = (function () {
      function December() {

      };
      December.value = new December();
      return December;
  })();
  var ordYear = Data_Ord.ordInt;
  var ordDay = Data_Ord.ordInt;
  var eqMonth = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof January && y instanceof January) {
              return true;
          };
          if (x instanceof February && y instanceof February) {
              return true;
          };
          if (x instanceof March && y instanceof March) {
              return true;
          };
          if (x instanceof April && y instanceof April) {
              return true;
          };
          if (x instanceof May && y instanceof May) {
              return true;
          };
          if (x instanceof June && y instanceof June) {
              return true;
          };
          if (x instanceof July && y instanceof July) {
              return true;
          };
          if (x instanceof August && y instanceof August) {
              return true;
          };
          if (x instanceof September && y instanceof September) {
              return true;
          };
          if (x instanceof October && y instanceof October) {
              return true;
          };
          if (x instanceof November && y instanceof November) {
              return true;
          };
          if (x instanceof December && y instanceof December) {
              return true;
          };
          return false;
      };
  });
  var ordMonth = new Data_Ord.Ord(function () {
      return eqMonth;
  }, function (x) {
      return function (y) {
          if (x instanceof January && y instanceof January) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof January) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof January) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof February && y instanceof February) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof February) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof February) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof March && y instanceof March) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof March) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof March) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof April && y instanceof April) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof April) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof April) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof May && y instanceof May) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof May) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof May) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof June && y instanceof June) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof June) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof June) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof July && y instanceof July) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof July) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof July) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof August && y instanceof August) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof August) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof August) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof September && y instanceof September) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof September) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof September) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof October && y instanceof October) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof October) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof October) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof November && y instanceof November) {
              return Data_Ordering.EQ.value;
          };
          if (x instanceof November) {
              return Data_Ordering.LT.value;
          };
          if (y instanceof November) {
              return Data_Ordering.GT.value;
          };
          if (x instanceof December && y instanceof December) {
              return Data_Ordering.EQ.value;
          };
          throw new Error("Failed pattern match at Data.Date.Component (line 61, column 1 - line 61, column 38): " + [ x.constructor.name, y.constructor.name ]);
      };
  });                       
  var boundedYear = new Data_Bounded.Bounded(function () {
      return ordYear;
  }, -271820 | 0, 275759);       
  var boundedMonth = new Data_Bounded.Bounded(function () {
      return ordMonth;
  }, January.value, December.value);
  var boundedEnumYear = new Data_Enum.BoundedEnum(function () {
      return boundedYear;
  }, function () {
      return enumYear;
  }, 547580, function (v) {
      return v;
  }, function (n) {
      if (n >= (-271820 | 0) && n <= 275759) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Date.Component (line 35, column 1 - line 40, column 24): " + [ n.constructor.name ]);
  });
  var enumYear = new Data_Enum.Enum(function () {
      return ordYear;
  }, (function () {
      var $46 = Data_Enum.toEnum(boundedEnumYear);
      var $47 = Data_Enum.fromEnum(boundedEnumYear);
      return function ($48) {
          return $46((function (v) {
              return v - 1 | 0;
          })($47($48)));
      };
  })(), (function () {
      var $49 = Data_Enum.toEnum(boundedEnumYear);
      var $50 = Data_Enum.fromEnum(boundedEnumYear);
      return function ($51) {
          return $49((function (v) {
              return v + 1 | 0;
          })($50($51)));
      };
  })());
  var boundedEnumMonth = new Data_Enum.BoundedEnum(function () {
      return boundedMonth;
  }, function () {
      return enumMonth;
  }, 12, function (v) {
      if (v instanceof January) {
          return 1;
      };
      if (v instanceof February) {
          return 2;
      };
      if (v instanceof March) {
          return 3;
      };
      if (v instanceof April) {
          return 4;
      };
      if (v instanceof May) {
          return 5;
      };
      if (v instanceof June) {
          return 6;
      };
      if (v instanceof July) {
          return 7;
      };
      if (v instanceof August) {
          return 8;
      };
      if (v instanceof September) {
          return 9;
      };
      if (v instanceof October) {
          return 10;
      };
      if (v instanceof November) {
          return 11;
      };
      if (v instanceof December) {
          return 12;
      };
      throw new Error("Failed pattern match at Data.Date.Component (line 87, column 14 - line 99, column 19): " + [ v.constructor.name ]);
  }, function (v) {
      if (v === 1) {
          return new Data_Maybe.Just(January.value);
      };
      if (v === 2) {
          return new Data_Maybe.Just(February.value);
      };
      if (v === 3) {
          return new Data_Maybe.Just(March.value);
      };
      if (v === 4) {
          return new Data_Maybe.Just(April.value);
      };
      if (v === 5) {
          return new Data_Maybe.Just(May.value);
      };
      if (v === 6) {
          return new Data_Maybe.Just(June.value);
      };
      if (v === 7) {
          return new Data_Maybe.Just(July.value);
      };
      if (v === 8) {
          return new Data_Maybe.Just(August.value);
      };
      if (v === 9) {
          return new Data_Maybe.Just(September.value);
      };
      if (v === 10) {
          return new Data_Maybe.Just(October.value);
      };
      if (v === 11) {
          return new Data_Maybe.Just(November.value);
      };
      if (v === 12) {
          return new Data_Maybe.Just(December.value);
      };
      return Data_Maybe.Nothing.value;
  });
  var enumMonth = new Data_Enum.Enum(function () {
      return ordMonth;
  }, (function () {
      var $58 = Data_Enum.toEnum(boundedEnumMonth);
      var $59 = Data_Enum.fromEnum(boundedEnumMonth);
      return function ($60) {
          return $58((function (v) {
              return v - 1 | 0;
          })($59($60)));
      };
  })(), (function () {
      var $61 = Data_Enum.toEnum(boundedEnumMonth);
      var $62 = Data_Enum.fromEnum(boundedEnumMonth);
      return function ($63) {
          return $61((function (v) {
              return v + 1 | 0;
          })($62($63)));
      };
  })());
  var boundedDay = new Data_Bounded.Bounded(function () {
      return ordDay;
  }, 1, 31);
  var boundedEnumDay = new Data_Enum.BoundedEnum(function () {
      return boundedDay;
  }, function () {
      return enumDay;
  }, 31, function (v) {
      return v;
  }, function (n) {
      if (n >= 1 && n <= 31) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Date.Component (line 133, column 1 - line 138, column 23): " + [ n.constructor.name ]);
  });
  var enumDay = new Data_Enum.Enum(function () {
      return ordDay;
  }, (function () {
      var $64 = Data_Enum.toEnum(boundedEnumDay);
      var $65 = Data_Enum.fromEnum(boundedEnumDay);
      return function ($66) {
          return $64((function (v) {
              return v - 1 | 0;
          })($65($66)));
      };
  })(), (function () {
      var $67 = Data_Enum.toEnum(boundedEnumDay);
      var $68 = Data_Enum.fromEnum(boundedEnumDay);
      return function ($69) {
          return $67((function (v) {
              return v + 1 | 0;
          })($68($69)));
      };
  })());
  exports["boundedEnumYear"] = boundedEnumYear;
  exports["boundedEnumMonth"] = boundedEnumMonth;
  exports["boundedEnumDay"] = boundedEnumDay;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Date"] = $PS["Data.Date"] || {};
  var exports = $PS["Data.Date"];
  var $foreign = $PS["Data.Date"];
  var Data_Date_Component = $PS["Data.Date.Component"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_Maybe = $PS["Data.Maybe"];                                
  var $$Date = (function () {
      function $$Date(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      $$Date.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new $$Date(value0, value1, value2);
              };
          };
      };
      return $$Date;
  })();
  var year = function (v) {
      return v.value0;
  }; 
  var month = function (v) {
      return v.value1;
  };
  var day = function (v) {
      return v.value2;
  };
  var canonicalDate = function (y) {
      return function (m) {
          return function (d) {
              var mkDate = function (y$prime) {
                  return function (m$prime) {
                      return function (d$prime) {
                          return new $$Date(y$prime, Data_Maybe.fromJust()(Data_Enum.toEnum(Data_Date_Component.boundedEnumMonth)(m$prime)), d$prime);
                      };
                  };
              };
              return $foreign.canonicalDateImpl(mkDate, y, Data_Enum.fromEnum(Data_Date_Component.boundedEnumMonth)(m), d);
          };
      };
  };
  exports["canonicalDate"] = canonicalDate;
  exports["year"] = year;
  exports["month"] = month;
  exports["day"] = day;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.DateTime"] = $PS["Data.DateTime"] || {};
  var exports = $PS["Data.DateTime"];                                
  var DateTime = (function () {
      function DateTime(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      DateTime.create = function (value0) {
          return function (value1) {
              return new DateTime(value0, value1);
          };
      };
      return DateTime;
  })();
  var time = function (v) {
      return v.value1;
  };
  var date = function (v) {
      return v.value0;
  };
  exports["DateTime"] = DateTime;
  exports["date"] = date;
  exports["time"] = time;
})(PS);
(function(exports) {
  "use strict";

  exports.toDateTimeImpl = function (ctor) {
    return function (instant) {
      var dt = new Date(instant);
      return ctor (dt.getUTCFullYear())(dt.getUTCMonth() + 1)(dt.getUTCDate())(dt.getUTCHours())(dt.getUTCMinutes())(dt.getUTCSeconds())(dt.getUTCMilliseconds());
    };
  };
})(PS["Data.DateTime.Instant"] = PS["Data.DateTime.Instant"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Time"] = $PS["Data.Time"] || {};
  var exports = $PS["Data.Time"];          
  var Time = (function () {
      function Time(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Time.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Time(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Time;
  })();
  var second = function (v) {
      return v.value2;
  };
  var minute = function (v) {
      return v.value1;
  };
  var hour = function (v) {
      return v.value0;
  };
  exports["Time"] = Time;
  exports["hour"] = hour;
  exports["minute"] = minute;
  exports["second"] = second;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.DateTime.Instant"] = $PS["Data.DateTime.Instant"] || {};
  var exports = $PS["Data.DateTime.Instant"];
  var $foreign = $PS["Data.DateTime.Instant"];
  var Data_Date = $PS["Data.Date"];
  var Data_Date_Component = $PS["Data.Date.Component"];
  var Data_DateTime = $PS["Data.DateTime"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Time = $PS["Data.Time"];
  var toDateTime = (function () {
      var mkDateTime = function (y) {
          return function (mo) {
              return function (d) {
                  return function (h) {
                      return function (mi) {
                          return function (s) {
                              return function (ms) {
                                  return new Data_DateTime.DateTime(Data_Date.canonicalDate(y)(Data_Maybe.fromJust()(Data_Enum.toEnum(Data_Date_Component.boundedEnumMonth)(mo)))(d), new Data_Time.Time(h, mi, s, ms));
                              };
                          };
                      };
                  };
              };
          };
      };
      return $foreign.toDateTimeImpl(mkDateTime);
  })();
  exports["toDateTime"] = toDateTime;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Digit"] = $PS["Data.Digit"] || {};
  var exports = $PS["Data.Digit"];
  var Data_Char = $PS["Data.Char"];
  var Data_Maybe = $PS["Data.Maybe"];              
  var Digit = function (x) {
      return x;
  };
  var fromChar = function (c) {
      var code = Data_Char.toCharCode(c);
      var $16 = code >= 48 && code <= 57;
      if ($16) {
          return new Data_Maybe.Just(Digit(code - 48 | 0));
      };
      return Data_Maybe.Nothing.value;
  };
  exports["fromChar"] = fromChar;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Generic.Rep"] = $PS["Data.Generic.Rep"] || {};
  var exports = $PS["Data.Generic.Rep"];             
  var Inl = (function () {
      function Inl(value0) {
          this.value0 = value0;
      };
      Inl.create = function (value0) {
          return new Inl(value0);
      };
      return Inl;
  })();
  var Inr = (function () {
      function Inr(value0) {
          this.value0 = value0;
      };
      Inr.create = function (value0) {
          return new Inr(value0);
      };
      return Inr;
  })();
  var NoArguments = (function () {
      function NoArguments() {

      };
      NoArguments.value = new NoArguments();
      return NoArguments;
  })();
  var Generic = function (from, to) {
      this.from = from;
      this.to = to;
  };
  var Constructor = function (x) {
      return x;
  };
  var Argument = function (x) {
      return x;
  };
  var to = function (dict) {
      return dict.to;
  };
  var from = function (dict) {
      return dict.from;
  };
  exports["Generic"] = Generic;
  exports["to"] = to;
  exports["from"] = from;
  exports["NoArguments"] = NoArguments;
  exports["Inl"] = Inl;
  exports["Inr"] = Inr;
  exports["Constructor"] = Constructor;
  exports["Argument"] = Argument;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Eq.Generic"] = $PS["Data.Eq.Generic"] || {};
  var exports = $PS["Data.Eq.Generic"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Generic_Rep = $PS["Data.Generic.Rep"];                
  var GenericEq = function (genericEq$prime) {
      this["genericEq'"] = genericEq$prime;
  }; 
  var genericEqNoArguments = new GenericEq(function (v) {
      return function (v1) {
          return true;
      };
  });
  var genericEqArgument = function (dictEq) {
      return new GenericEq(function (v) {
          return function (v1) {
              return Data_Eq.eq(dictEq)(v)(v1);
          };
      });
  };
  var genericEq$prime = function (dict) {
      return dict["genericEq'"];
  };
  var genericEqConstructor = function (dictGenericEq) {
      return new GenericEq(function (v) {
          return function (v1) {
              return genericEq$prime(dictGenericEq)(v)(v1);
          };
      });
  };
  var genericEqSum = function (dictGenericEq) {
      return function (dictGenericEq1) {
          return new GenericEq(function (v) {
              return function (v1) {
                  if (v instanceof Data_Generic_Rep.Inl && v1 instanceof Data_Generic_Rep.Inl) {
                      return genericEq$prime(dictGenericEq)(v.value0)(v1.value0);
                  };
                  if (v instanceof Data_Generic_Rep.Inr && v1 instanceof Data_Generic_Rep.Inr) {
                      return genericEq$prime(dictGenericEq1)(v.value0)(v1.value0);
                  };
                  return false;
              };
          });
      };
  };
  var genericEq = function (dictGeneric) {
      return function (dictGenericEq) {
          return function (x) {
              return function (y) {
                  return genericEq$prime(dictGenericEq)(Data_Generic_Rep.from(dictGeneric)(x))(Data_Generic_Rep.from(dictGeneric)(y));
              };
          };
      };
  };
  exports["genericEq"] = genericEq;
  exports["genericEqNoArguments"] = genericEqNoArguments;
  exports["genericEqSum"] = genericEqSum;
  exports["genericEqConstructor"] = genericEqConstructor;
  exports["genericEqArgument"] = genericEqArgument;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Sequence.Internal"] = $PS["Data.Sequence.Internal"] || {};
  var exports = $PS["Data.Sequence.Internal"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];                
  var Measured = function (measure) {
      this.measure = measure;
  };
  var NoKey = (function () {
      function NoKey() {

      };
      NoKey.value = new NoKey();
      return NoKey;
  })();
  var Key = (function () {
      function Key(value0) {
          this.value0 = value0;
      };
      Key.create = function (value0) {
          return new Key(value0);
      };
      return Key;
  })();
  var semigroupKey = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          if (v1 instanceof NoKey) {
              return v;
          };
          return v1;
      };
  });
  var monoidKey = new Data_Monoid.Monoid(function () {
      return semigroupKey;
  }, NoKey.value);
  var measuredElemKey = new Measured(function (v) {
      return new Key(v);
  });
  var measuredElem = new Measured(function (v) {
      return 1;
  });
  var measure = function (dict) {
      return dict.measure;
  };
  var measuredArray = function (dictMonoid) {
      return function (dictMeasured) {
          return new Measured(function (xs) {
              return Data_Foldable.foldl(Data_Foldable.foldableArray)(function (i) {
                  return function (a) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(i)(measure(dictMeasured)(a));
                  };
              })(Data_Monoid.mempty(dictMonoid))(xs);
          });
      };
  };
  var measuredLazy = function (dictMonoid) {
      return function (dictMeasured) {
          return new Measured(function (s) {
              return measure(dictMeasured)(Data_Lazy.force(s));
          });
      };
  };
  var mapmap = function (dictFunctor) {
      return function (dictFunctor1) {
          var $75 = Data_Functor.map(dictFunctor);
          var $76 = Data_Functor.map(dictFunctor1);
          return function ($77) {
              return $75($76($77));
          };
      };
  };
  var mapmapmap = function (dictFunctor) {
      return function (dictFunctor1) {
          return function (dictFunctor2) {
              var $78 = mapmap(dictFunctor)(dictFunctor1);
              var $79 = Data_Functor.map(dictFunctor2);
              return function ($80) {
                  return $78($79($80));
              };
          };
      };
  };
  var mapGetElem = function (dictFunctor) {
      return Unsafe_Coerce.unsafeCoerce;
  };
  var liftElem = Unsafe_Coerce.unsafeCoerce;
  var lift2Elem = Unsafe_Coerce.unsafeCoerce;
  var eqKey = function (dictEq) {
      return new Data_Eq.Eq(function (v) {
          return function (v1) {
              if (v instanceof Key && v1 instanceof Key) {
                  return Data_Eq.eq(dictEq)(v.value0)(v1.value0);
              };
              if (v instanceof NoKey && v1 instanceof NoKey) {
                  return true;
              };
              return false;
          };
      });
  };
  var ordKey = function (dictOrd) {
      return new Data_Ord.Ord(function () {
          return eqKey(dictOrd.Eq0());
      }, function (v) {
          return function (v1) {
              if (v instanceof NoKey) {
                  return Data_Ordering.LT.value;
              };
              if (v1 instanceof NoKey) {
                  return Data_Ordering.GT.value;
              };
              if (v instanceof Key && v1 instanceof Key) {
                  return Data_Ord.compare(dictOrd)(v.value0)(v1.value0);
              };
              throw new Error("Failed pattern match at Data.Sequence.Internal (line 114, column 1 - line 117, column 40): " + [ v.constructor.name, v1.constructor.name ]);
          };
      });
  };
  var eqElem = function (dictEq) {
      return new Data_Eq.Eq(function (v) {
          return function (v1) {
              return Data_Eq.eq(dictEq)(v)(v1);
          };
      });
  };
  exports["mapmapmap"] = mapmapmap;
  exports["Measured"] = Measured;
  exports["measure"] = measure;
  exports["mapGetElem"] = mapGetElem;
  exports["lift2Elem"] = lift2Elem;
  exports["liftElem"] = liftElem;
  exports["Key"] = Key;
  exports["measuredArray"] = measuredArray;
  exports["measuredLazy"] = measuredLazy;
  exports["measuredElem"] = measuredElem;
  exports["eqElem"] = eqElem;
  exports["ordKey"] = ordKey;
  exports["monoidKey"] = monoidKey;
  exports["measuredElemKey"] = measuredElemKey;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.FingerTree.Digit"] = $PS["Data.FingerTree.Digit"] || {};
  var exports = $PS["Data.FingerTree.Digit"];
  var Data_Array = $PS["Data.Array"];
  var Data_Array_Partial = $PS["Data.Array.Partial"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Sequence_Internal = $PS["Data.Sequence.Internal"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];                
  var Digit = function (x) {
      return x;
  };
  var runDigit = function (v) {
      return v;
  };
  var tailDigit = (function () {
      var $14 = Data_Array_Partial.tail();
      return function ($15) {
          return $14(runDigit($15));
      };
  })();
  var overDigit = Unsafe_Coerce.unsafeCoerce;
  var snocDigit = function (dictPartial) {
      return function (dg) {
          return function (x) {
              return overDigit(function (xs) {
                  return Data_Array.snoc(xs)(x);
              })(dg);
          };
      };
  };
  var mkDigitMay = function (xs) {
      var $13 = Data_Ord.between(Data_Ord.ordInt)(1)(4)(Data_Array.length(xs));
      if ($13) {
          return new Data_Maybe.Just(xs);
      };
      return Data_Maybe.Nothing.value;
  };
  var mkDigit3 = function (x) {
      return function (y) {
          return function (z) {
              return [ x, y, z ];
          };
      };
  };
  var mkDigit2 = function (x) {
      return function (y) {
          return [ x, y ];
      };
  };
  var mkDigit1 = function (x) {
      return [ x ];
  };
  var mkDigit = function (dictPartial) {
      return Digit;
  };
  var measuredDigit = function (dictMonoid) {
      return function (dictMeasured) {
          return new Data_Sequence_Internal.Measured((function () {
              var $16 = Data_Sequence_Internal.measure(Data_Sequence_Internal.measuredArray(dictMonoid)(dictMeasured));
              return function ($17) {
                  return $16(runDigit($17));
              };
          })());
      };
  };
  var lastDigit = (function () {
      var $18 = Data_Array_Partial.last();
      return function ($19) {
          return $18(runDigit($19));
      };
  })();
  var initDigit = (function () {
      var $20 = Data_Array_Partial.init();
      return function ($21) {
          return $20(runDigit($21));
      };
  })();
  var headDigit = (function () {
      var $22 = Data_Array_Partial.head();
      return function ($23) {
          return $22(runDigit($23));
      };
  })();
  var functorDigit = Data_Functor.functorArray;
  var foldableDigit = Data_Foldable.foldableArray;
  var digitLength = function ($26) {
      return Data_Array.length(runDigit($26));
  };
  var consDigit = function (dictPartial) {
      return function (x) {
          return function (dg) {
              return overDigit(Data_Array.cons(x))(dg);
          };
      };
  };
  exports["mkDigit"] = mkDigit;
  exports["mkDigitMay"] = mkDigitMay;
  exports["mkDigit1"] = mkDigit1;
  exports["mkDigit2"] = mkDigit2;
  exports["mkDigit3"] = mkDigit3;
  exports["runDigit"] = runDigit;
  exports["headDigit"] = headDigit;
  exports["tailDigit"] = tailDigit;
  exports["initDigit"] = initDigit;
  exports["lastDigit"] = lastDigit;
  exports["snocDigit"] = snocDigit;
  exports["consDigit"] = consDigit;
  exports["digitLength"] = digitLength;
  exports["functorDigit"] = functorDigit;
  exports["foldableDigit"] = foldableDigit;
  exports["measuredDigit"] = measuredDigit;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.FingerTree"] = $PS["Data.FingerTree"] || {};
  var exports = $PS["Data.FingerTree"];
  var Data_Array = $PS["Data.Array"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_FingerTree_Digit = $PS["Data.FingerTree.Digit"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Sequence_Internal = $PS["Data.Sequence.Internal"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var Partial = $PS["Partial"];                
  var NilR = (function () {
      function NilR() {

      };
      NilR.value = new NilR();
      return NilR;
  })();
  var SnocR = (function () {
      function SnocR(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      SnocR.create = function (value0) {
          return function (value1) {
              return new SnocR(value0, value1);
          };
      };
      return SnocR;
  })();
  var NilL = (function () {
      function NilL() {

      };
      NilL.value = new NilL();
      return NilL;
  })();
  var ConsL = (function () {
      function ConsL(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      ConsL.create = function (value0) {
          return function (value1) {
              return new ConsL(value0, value1);
          };
      };
      return ConsL;
  })();
  var Split = (function () {
      function Split(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      Split.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new Split(value0, value1, value2);
              };
          };
      };
      return Split;
  })();
  var Node2 = (function () {
      function Node2(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      Node2.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new Node2(value0, value1, value2);
              };
          };
      };
      return Node2;
  })();
  var Node3 = (function () {
      function Node3(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Node3.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Node3(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Node3;
  })();
  var LazySplit = (function () {
      function LazySplit(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      LazySplit.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new LazySplit(value0, value1, value2);
              };
          };
      };
      return LazySplit;
  })();
  var Empty = (function () {
      function Empty() {

      };
      Empty.value = new Empty();
      return Empty;
  })();
  var Single = (function () {
      function Single(value0) {
          this.value0 = value0;
      };
      Single.create = function (value0) {
          return new Single(value0);
      };
      return Single;
  })();
  var Deep = (function () {
      function Deep(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Deep.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Deep(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Deep;
  })();
  var splitDigit = function (dictMonoid) {
      return function (dictMeasured) {
          return function (p) {
              return function (i) {
                  return function (as) {
                      var v = Data_FingerTree_Digit.digitLength(as);
                      if (v === 1) {
                          return new Split([  ], Data_FingerTree_Digit.headDigit(as), [  ]);
                      };
                      var bs$prime = Data_FingerTree_Digit.tailDigit(as);
                      var bs = Data_FingerTree_Digit.mkDigit()(bs$prime);
                      var a = Data_FingerTree_Digit.headDigit(as);
                      var i$prime = Data_Semigroup.append(dictMonoid.Semigroup0())(i)(Data_Sequence_Internal.measure(dictMeasured)(a));
                      var $150 = p(i$prime);
                      if ($150) {
                          return new Split([  ], a, bs$prime);
                      };
                      var v1 = splitDigit(dictMonoid)(dictMeasured)(p)(i$prime)(bs);
                      return new Split(Data_Array.cons(a)(v1.value0), v1.value1, v1.value2);
                  };
              };
          };
      };
  };
  var nodeToDigit = (function () {
      var go = function (v) {
          if (v instanceof Node2) {
              return Data_FingerTree_Digit.mkDigit2(v.value1)(v.value2);
          };
          if (v instanceof Node3) {
              return Data_FingerTree_Digit.mkDigit3(v.value1)(v.value2)(v.value3);
          };
          throw new Error("Failed pattern match at Data.FingerTree (line 88, column 3 - line 88, column 34): " + [ v.constructor.name ]);
      };
      return go;
  })();
  var node3 = function (dictMonoid) {
      return function (dictMeasured) {
          return function (a) {
              return function (b) {
                  return function (c) {
                      return new Node3(Data_Semigroup.append(dictMonoid.Semigroup0())(Data_Sequence_Internal.measure(dictMeasured)(a))(Data_Semigroup.append(dictMonoid.Semigroup0())(Data_Sequence_Internal.measure(dictMeasured)(b))(Data_Sequence_Internal.measure(dictMeasured)(c))), a, b, c);
                  };
              };
          };
      };
  };
  var node2 = function (dictMonoid) {
      return function (dictMeasured) {
          return function (a) {
              return function (b) {
                  return new Node2(Data_Semigroup.append(dictMonoid.Semigroup0())(Data_Sequence_Internal.measure(dictMeasured)(a))(Data_Sequence_Internal.measure(dictMeasured)(b)), a, b);
              };
          };
      };
  };
  var nodes = function (dictMonoid) {
      return function (dictMeasured) {
          return function (xs) {
              if (xs.length === 2) {
                  return [ node2(dictMonoid)(dictMeasured)(xs[0])(xs[1]) ];
              };
              if (xs.length === 3) {
                  return [ node3(dictMonoid)(dictMeasured)(xs[0])(xs[1])(xs[2]) ];
              };
              if (xs.length === 4) {
                  return [ node2(dictMonoid)(dictMeasured)(xs[0])(xs[1]), node2(dictMonoid)(dictMeasured)(xs[2])(xs[3]) ];
              };
              var idx = Data_Array.unsafeIndex();
              return Data_Array.cons(node3(dictMonoid)(dictMeasured)(idx(xs)(0))(idx(xs)(1))(idx(xs)(2)))(nodes(dictMonoid)(dictMeasured)(Data_Array.drop(3)(xs)));
          };
      };
  };
  var measuredNode = new Data_Sequence_Internal.Measured(function (v) {
      if (v instanceof Node2) {
          return v.value0;
      };
      if (v instanceof Node3) {
          return v.value0;
      };
      throw new Error("Failed pattern match at Data.FingerTree (line 107, column 1 - line 109, column 30): " + [ v.constructor.name ]);
  });
  var measuredFingerTree = function (dictMonoid) {
      return function (dictMeasured) {
          return new Data_Sequence_Internal.Measured(function (v) {
              if (v instanceof Empty) {
                  return Data_Monoid.mempty(dictMonoid);
              };
              if (v instanceof Single) {
                  return Data_Sequence_Internal.measure(dictMeasured)(v.value0);
              };
              if (v instanceof Deep) {
                  return Data_Lazy.force(v.value0);
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 228, column 1 - line 232, column 37): " + [ v.constructor.name ]);
          });
      };
  };
  var lazyEmpty = Data_Lazy.defer(function (v) {
      return Empty.value;
  });
  var functorNode = new Data_Functor.Functor(function (f) {
      return function (v) {
          if (v instanceof Node2) {
              return new Node2(v.value0, f(v.value1), f(v.value2));
          };
          if (v instanceof Node3) {
              return new Node3(v.value0, f(v.value1), f(v.value2), f(v.value3));
          };
          throw new Error("Failed pattern match at Data.FingerTree (line 91, column 1 - line 93, column 52): " + [ f.constructor.name, v.constructor.name ]);
      };
  });
  var functorFingerTree = new Data_Functor.Functor(function (f) {
      return function (v) {
          if (v instanceof Empty) {
              return Empty.value;
          };
          if (v instanceof Single) {
              return new Single(f(v.value0));
          };
          if (v instanceof Deep) {
              return new Deep(v.value0, Data_Functor.map(Data_FingerTree_Digit.functorDigit)(f)(v.value1), Data_Sequence_Internal.mapmapmap(Data_Lazy.functorLazy)(functorFingerTree)(functorNode)(f)(v.value2), Data_Functor.map(Data_FingerTree_Digit.functorDigit)(f)(v.value3));
          };
          throw new Error("Failed pattern match at Data.FingerTree (line 183, column 1 - line 186, column 68): " + [ f.constructor.name, v.constructor.name ]);
      };
  });
  var foldableNode = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return function (xs) {
              return Data_Foldable.foldr(foldableNode)(function (x) {
                  return function (acc) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(f(x))(acc);
                  };
              })(Data_Monoid.mempty(dictMonoid))(xs);
          };
      };
  }, function (l) {
      return function (z) {
          return function (v) {
              if (v instanceof Node2) {
                  return l(l(z)(v.value1))(v.value2);
              };
              if (v instanceof Node3) {
                  return l(l(l(z)(v.value1))(v.value2))(v.value3);
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 95, column 1 - line 100, column 56): " + [ l.constructor.name, z.constructor.name, v.constructor.name ]);
          };
      };
  }, function (r) {
      return function (z) {
          return function (v) {
              if (v instanceof Node2) {
                  return r(v.value1)(r(v.value2)(z));
              };
              if (v instanceof Node3) {
                  return r(v.value1)(r(v.value2)(r(v.value3)(z)));
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 95, column 1 - line 100, column 56): " + [ r.constructor.name, z.constructor.name, v.constructor.name ]);
          };
      };
  });
  var foldableFingerTree = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return function (xs) {
              return Data_Foldable.foldr(foldableFingerTree)(function (x) {
                  return function (acc) {
                      return Data_Semigroup.append(dictMonoid.Semigroup0())(f(x))(acc);
                  };
              })(Data_Monoid.mempty(dictMonoid))(xs);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Empty) {
                  return z;
              };
              if (v1 instanceof Single) {
                  return v(z)(v1.value0);
              };
              if (v1 instanceof Deep) {
                  var leftFold = Data_Foldable.foldl(Data_FingerTree_Digit.foldableDigit)(v);
                  var deepLeftFold = Data_Foldable.foldl(foldableFingerTree)(Data_Foldable.foldl(foldableNode)(v));
                  return leftFold(deepLeftFold(leftFold(z)(v1.value1))(Data_Lazy.force(v1.value2)))(v1.value3);
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 188, column 1 - line 212, column 56): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  }, function (v) {
      return function (z) {
          return function (v1) {
              if (v1 instanceof Empty) {
                  return z;
              };
              if (v1 instanceof Single) {
                  return v(v1.value0)(z);
              };
              if (v1 instanceof Deep) {
                  var flipFoldr$prime = Data_Function.flip(Data_Foldable.foldr(Data_FingerTree_Digit.foldableDigit)(v));
                  var flipFoldr = Data_Function.flip(Data_Foldable.foldr(Data_FingerTree_Digit.foldableDigit)(v));
                  var deepFlipFoldr = Data_Function.flip(Data_Foldable.foldr(foldableFingerTree)(Data_Function.flip(Data_Foldable.foldr(foldableNode)(v))));
                  return flipFoldr$prime(v1.value1)(deepFlipFoldr(Data_Lazy.force(v1.value2))(flipFoldr(v1.value3)(z)));
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 188, column 1 - line 212, column 56): " + [ v.constructor.name, z.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var deep = function (dictMonoid) {
      return function (dictMeasured) {
          return function (pr) {
              return function (m) {
                  return function (sf) {
                      return new Deep(Data_Lazy.defer(function (v) {
                          return Data_Semigroup.append(dictMonoid.Semigroup0())(Data_Sequence_Internal.measure(Data_FingerTree_Digit.measuredDigit(dictMonoid)(dictMeasured))(pr))(Data_Semigroup.append(dictMonoid.Semigroup0())(Data_Sequence_Internal.measure(Data_Sequence_Internal.measuredLazy(dictMonoid)(measuredFingerTree(dictMonoid)(measuredNode)))(m))(Data_Sequence_Internal.measure(Data_FingerTree_Digit.measuredDigit(dictMonoid)(dictMeasured))(sf)));
                      }), pr, m, sf);
                  };
              };
          };
      };
  };
  var snoc = function (dictMonoid) {
      return function (dictMeasured) {
          return function (v) {
              return function (a) {
                  if (v instanceof Empty) {
                      return new Single(a);
                  };
                  if (v instanceof Single) {
                      return deep(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.mkDigit1(v.value0))(lazyEmpty)(Data_FingerTree_Digit.mkDigit1(a));
                  };
                  if (v instanceof Deep) {
                      var v1 = Data_FingerTree_Digit.runDigit(v.value3);
                      if (v1.length === 4) {
                          var forcedM = Data_Lazy.force(v.value2);
                          return deep(dictMonoid)(dictMeasured)(v.value1)(Data_Lazy.defer(function (v2) {
                              return snoc(dictMonoid)(measuredNode)(forcedM)(node3(dictMonoid)(dictMeasured)(v1[0])(v1[1])(v1[2]));
                          }))(Data_FingerTree_Digit.mkDigit2(v1[3])(a));
                      };
                      return deep(dictMonoid)(dictMeasured)(v.value1)(v.value2)(Data_FingerTree_Digit.snocDigit()(v.value3)(a));
                  };
                  throw new Error("Failed pattern match at Data.FingerTree (line 262, column 1 - line 263, column 40): " + [ v.constructor.name, a.constructor.name ]);
              };
          };
      };
  };
  var snocAll = function (dictMonoid) {
      return function (dictMeasured) {
          return function (dictFoldable) {
              return Data_Foldable.foldl(dictFoldable)(snoc(dictMonoid)(dictMeasured));
          };
      };
  };
  var toFingerTree = function (dictMonoid) {
      return function (dictMeasured) {
          return function (dictFoldable) {
              return function (s) {
                  return snocAll(dictMonoid)(dictMeasured)(dictFoldable)(Empty.value)(s);
              };
          };
      };
  };
  var viewL = function (dictMonoid) {
      return function (dictMeasured) {
          return function (v) {
              if (v instanceof Empty) {
                  return NilL.value;
              };
              if (v instanceof Single) {
                  return new ConsL(v.value0, lazyEmpty);
              };
              if (v instanceof Deep) {
                  return new ConsL(Data_FingerTree_Digit.headDigit(v.value1), Data_Lazy.defer(function (v1) {
                      return deepL(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.tailDigit(v.value1))(v.value2)(v.value3);
                  }));
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 294, column 1 - line 295, column 50): " + [ v.constructor.name ]);
          };
      };
  };
  var deepL = function (dictMonoid) {
      return function (dictMeasured) {
          return function (pr$prime) {
              return function (m) {
                  return function (sf) {
                      var v = Data_FingerTree_Digit.mkDigitMay(pr$prime);
                      if (v instanceof Data_Maybe.Just) {
                          return deep(dictMonoid)(dictMeasured)(v.value0)(m)(sf);
                      };
                      if (v instanceof Data_Maybe.Nothing) {
                          var v1 = viewL(dictMonoid)(measuredNode)(Data_Lazy.force(m));
                          if (v1 instanceof NilL) {
                              return toFingerTree(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.foldableDigit)(sf);
                          };
                          if (v1 instanceof ConsL) {
                              return deep(dictMonoid)(dictMeasured)(nodeToDigit(v1.value0))(v1.value1)(sf);
                          };
                          throw new Error("Failed pattern match at Data.FingerTree (line 321, column 7 - line 323, column 49): " + [ v1.constructor.name ]);
                      };
                      throw new Error("Failed pattern match at Data.FingerTree (line 317, column 3 - line 323, column 49): " + [ v.constructor.name ]);
                  };
              };
          };
      };
  };
  var eqFingerTree = function ($copy_dictMonoid) {
      return function ($copy_dictMeasured) {
          return function ($copy_dictEq) {
              return function ($copy_xs) {
                  return function ($copy_ys) {
                      var $tco_var_dictMonoid = $copy_dictMonoid;
                      var $tco_var_dictMeasured = $copy_dictMeasured;
                      var $tco_var_dictEq = $copy_dictEq;
                      var $tco_var_xs = $copy_xs;
                      var $tco_done = false;
                      var $tco_result;
                      function $tco_loop(dictMonoid, dictMeasured, dictEq, xs, ys) {
                          var v = new Data_Tuple.Tuple(viewL(dictMonoid)(dictMeasured)(xs), viewL(dictMonoid)(dictMeasured)(ys));
                          if (v.value0 instanceof NilL && v.value1 instanceof NilL) {
                              $tco_done = true;
                              return true;
                          };
                          if (v.value0 instanceof NilL) {
                              $tco_done = true;
                              return false;
                          };
                          if (v.value1 instanceof NilL) {
                              $tco_done = true;
                              return false;
                          };
                          if (v.value0 instanceof ConsL && v.value1 instanceof ConsL) {
                              var $308 = Data_Eq.eq(dictEq)(v.value0.value0)(v.value1.value0);
                              if ($308) {
                                  var ys$prime$prime = Data_Lazy.force(v.value1.value1);
                                  var xs$prime$prime = Data_Lazy.force(v.value0.value1);
                                  $tco_var_dictMonoid = dictMonoid;
                                  $tco_var_dictMeasured = dictMeasured;
                                  $tco_var_dictEq = dictEq;
                                  $tco_var_xs = xs$prime$prime;
                                  $copy_ys = ys$prime$prime;
                                  return;
                              };
                              $tco_done = true;
                              return false;
                          };
                          throw new Error("Failed pattern match at Data.FingerTree (line 153, column 3 - line 164, column 17): " + [ v.constructor.name ]);
                      };
                      while (!$tco_done) {
                          $tco_result = $tco_loop($tco_var_dictMonoid, $tco_var_dictMeasured, $tco_var_dictEq, $tco_var_xs, $copy_ys);
                      };
                      return $tco_result;
                  };
              };
          };
      };
  };
  var head = function (dictMonoid) {
      return function (dictMeasured) {
          return function (x) {
              var v = viewL(dictMonoid)(dictMeasured)(x);
              if (v instanceof ConsL) {
                  return new Data_Maybe.Just(v.value0);
              };
              if (v instanceof NilL) {
                  return Data_Maybe.Nothing.value;
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 331, column 10 - line 333, column 23): " + [ v.constructor.name ]);
          };
      };
  };
  var unfoldLeft = function (dictUnfoldable) {
      return function (dictMonoid) {
          return function (dictMeasured) {
              var step = function (tree) {
                  var v = viewL(dictMonoid)(dictMeasured)(tree);
                  if (v instanceof ConsL) {
                      return new Data_Maybe.Just(new Data_Tuple.Tuple(v.value0, Data_Lazy.force(v.value1)));
                  };
                  if (v instanceof NilL) {
                      return Data_Maybe.Nothing.value;
                  };
                  throw new Error("Failed pattern match at Data.FingerTree (line 482, column 15 - line 484, column 38): " + [ v.constructor.name ]);
              };
              return Data_Unfoldable.unfoldr(dictUnfoldable)(step);
          };
      };
  };
  var viewR = function (dictMonoid) {
      return function (dictMeasured) {
          return function (v) {
              if (v instanceof Empty) {
                  return NilR.value;
              };
              if (v instanceof Single) {
                  return new SnocR(lazyEmpty, v.value0);
              };
              if (v instanceof Deep) {
                  return new SnocR(Data_Lazy.defer(function (v1) {
                      return deepR(dictMonoid)(dictMeasured)(v.value1)(v.value2)(Data_FingerTree_Digit.initDigit(v.value3));
                  }), Data_FingerTree_Digit.lastDigit(v.value3));
              };
              throw new Error("Failed pattern match at Data.FingerTree (line 343, column 1 - line 344, column 50): " + [ v.constructor.name ]);
          };
      };
  };
  var deepR = function (dictMonoid) {
      return function (dictMeasured) {
          return function (pr) {
              return function (m) {
                  return function (sf$prime) {
                      var v = Data_FingerTree_Digit.mkDigitMay(sf$prime);
                      if (v instanceof Data_Maybe.Just) {
                          return deep(dictMonoid)(dictMeasured)(pr)(m)(v.value0);
                      };
                      if (v instanceof Data_Maybe.Nothing) {
                          var v1 = viewR(dictMonoid)(measuredNode)(Data_Lazy.force(m));
                          if (v1 instanceof NilR) {
                              return toFingerTree(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.foldableDigit)(pr);
                          };
                          if (v1 instanceof SnocR) {
                              return deep(dictMonoid)(dictMeasured)(pr)(v1.value0)(nodeToDigit(v1.value1));
                          };
                          throw new Error("Failed pattern match at Data.FingerTree (line 357, column 7 - line 359, column 49): " + [ v1.constructor.name ]);
                      };
                      throw new Error("Failed pattern match at Data.FingerTree (line 353, column 3 - line 359, column 49): " + [ v.constructor.name ]);
                  };
              };
          };
      };
  };
  var splitTree = function (dictMonoid) {
      return function (dictMeasured) {
          return function (dictPartial) {
              return function (v) {
                  return function (v1) {
                      return function (v2) {
                          if (v2 instanceof Single) {
                              return new LazySplit(lazyEmpty, v2.value0, lazyEmpty);
                          };
                          if (v2 instanceof Empty) {
                              return Partial.crashWith()("Data.FingerTree.splitTree: Empty");
                          };
                          if (v2 instanceof Deep) {
                              var vpr = Data_Semigroup.append(dictMonoid.Semigroup0())(v1)(Data_Sequence_Internal.measure(Data_FingerTree_Digit.measuredDigit(dictMonoid)(dictMeasured))(v2.value1));
                              var $351 = v(vpr);
                              if ($351) {
                                  var v3 = splitDigit(dictMonoid)(dictMeasured)(v)(v1)(v2.value1);
                                  return new LazySplit(Data_Lazy.defer(function (v4) {
                                      return toFingerTree(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(v3.value0);
                                  }), v3.value1, Data_Lazy.defer(function (v4) {
                                      return deepL(dictMonoid)(dictMeasured)(v3.value2)(v2.value2)(v2.value3);
                                  }));
                              };
                              var vm = Data_Semigroup.append(dictMonoid.Semigroup0())(vpr)(Data_Sequence_Internal.measure(Data_Sequence_Internal.measuredLazy(dictMonoid)(measuredFingerTree(dictMonoid)(measuredNode)))(v2.value2));
                              var $356 = v(vm);
                              if ($356) {
                                  var v3 = splitTree(dictMonoid)(measuredNode)()(v)(vpr)(Data_Lazy.force(v2.value2));
                                  var v4 = splitDigit(dictMonoid)(dictMeasured)(v)(Data_Semigroup.append(dictMonoid.Semigroup0())(vpr)(Data_Sequence_Internal.measure(Data_Sequence_Internal.measuredLazy(dictMonoid)(measuredFingerTree(dictMonoid)(measuredNode)))(v3.value0)))(nodeToDigit(v3.value1));
                                  return new LazySplit(Data_Lazy.defer(function (v5) {
                                      return deepR(dictMonoid)(dictMeasured)(v2.value1)(v3.value0)(v4.value0);
                                  }), v4.value1, Data_Lazy.defer(function (v5) {
                                      return deepL(dictMonoid)(dictMeasured)(v4.value2)(v3.value2)(v2.value3);
                                  }));
                              };
                              var v3 = splitDigit(dictMonoid)(dictMeasured)(v)(vm)(v2.value3);
                              return new LazySplit(Data_Lazy.defer(function (v4) {
                                  return deepR(dictMonoid)(dictMeasured)(v2.value1)(v2.value2)(v3.value0);
                              }), v3.value1, Data_Lazy.defer(function (v4) {
                                  return toFingerTree(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(v3.value2);
                              }));
                          };
                          throw new Error("Failed pattern match at Data.FingerTree (line 428, column 1 - line 429, column 70): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
                      };
                  };
              };
          };
      };
  };
  var cons = function (dictMonoid) {
      return function (dictMeasured) {
          return function (a) {
              return function (v) {
                  if (v instanceof Empty) {
                      return new Single(a);
                  };
                  if (v instanceof Single) {
                      return deep(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.mkDigit1(a))(lazyEmpty)(Data_FingerTree_Digit.mkDigit1(v.value0));
                  };
                  if (v instanceof Deep) {
                      var v1 = Data_FingerTree_Digit.runDigit(v.value1);
                      if (v1.length === 4) {
                          var forcedM = Data_Lazy.force(v.value2);
                          return deep(dictMonoid)(dictMeasured)(Data_FingerTree_Digit.mkDigit2(a)(v1[0]))(Data_Lazy.defer(function (v2) {
                              return cons(dictMonoid)(measuredNode)(node3(dictMonoid)(dictMeasured)(v1[1])(v1[2])(v1[3]))(forcedM);
                          }))(v.value3);
                      };
                      var pr$prime = Data_FingerTree_Digit.consDigit()(a)(v.value1);
                      return deep(dictMonoid)(dictMeasured)(pr$prime)(v.value2)(v.value3);
                  };
                  throw new Error("Failed pattern match at Data.FingerTree (line 234, column 1 - line 235, column 40): " + [ a.constructor.name, v.constructor.name ]);
              };
          };
      };
  };
  var consAll = function (dictMonoid) {
      return function (dictMeasured) {
          return function (dictFoldable) {
              return Data_Function.flip(Data_Foldable.foldr(dictFoldable)(cons(dictMonoid)(dictMeasured)));
          };
      };
  };
  var filter = function (dictMonoid) {
      return function (dictMeasured) {
          return function (p) {
              return Data_Foldable.foldr(foldableFingerTree)(function (x) {
                  return function (acc) {
                      var $385 = p(x);
                      if ($385) {
                          return cons(dictMonoid)(dictMeasured)(x)(acc);
                      };
                      return acc;
                  };
              })(Empty.value);
          };
      };
  };
  var split = function (dictMonoid) {
      return function (dictMeasured) {
          return function (dictPartial) {
              return function (p) {
                  return function (v) {
                      if (v instanceof Empty) {
                          return new Data_Tuple.Tuple(lazyEmpty, lazyEmpty);
                      };
                      var $388 = p(Data_Sequence_Internal.measure(measuredFingerTree(dictMonoid)(dictMeasured))(v));
                      if ($388) {
                          var v1 = splitTree(dictMonoid)(dictMeasured)()(p)(Data_Monoid.mempty(dictMonoid))(v);
                          return new Data_Tuple.Tuple(v1.value0, Data_Lazy.defer(function (v2) {
                              return cons(dictMonoid)(dictMeasured)(v1.value1)(Data_Lazy.force(v1.value2));
                          }));
                      };
                      return new Data_Tuple.Tuple(Data_Lazy.defer(function (v1) {
                          return v;
                      }), lazyEmpty);
                  };
              };
          };
      };
  };
  var app3 = function (dictMonoid) {
      return function (dictMeasured) {
          return function (v) {
              return function (ts) {
                  return function (v1) {
                      if (v instanceof Empty) {
                          return consAll(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(ts)(v1);
                      };
                      if (v1 instanceof Empty) {
                          return snocAll(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(v)(ts);
                      };
                      if (v instanceof Single) {
                          return cons(dictMonoid)(dictMeasured)(v.value0)(consAll(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(ts)(v1));
                      };
                      if (v1 instanceof Single) {
                          return snoc(dictMonoid)(dictMeasured)(snocAll(dictMonoid)(dictMeasured)(Data_Foldable.foldableArray)(v)(ts))(v1.value0);
                      };
                      if (v instanceof Deep && v1 instanceof Deep) {
                          var computeM$prime = function (v2) {
                              return app3(dictMonoid)(measuredNode)(Data_Lazy.force(v.value2))(nodes(dictMonoid)(dictMeasured)(Data_Semigroup.append(Data_Semigroup.semigroupArray)(Data_FingerTree_Digit.runDigit(v.value3))(Data_Semigroup.append(Data_Semigroup.semigroupArray)(ts)(Data_FingerTree_Digit.runDigit(v1.value1)))))(Data_Lazy.force(v1.value2));
                          };
                          return deep(dictMonoid)(dictMeasured)(v.value1)(Data_Lazy.defer(computeM$prime))(v1.value3);
                      };
                      throw new Error("Failed pattern match at Data.FingerTree (line 372, column 1 - line 373, column 70): " + [ v.constructor.name, ts.constructor.name, v1.constructor.name ]);
                  };
              };
          };
      };
  };
  var append = function (dictMonoid) {
      return function (dictMeasured) {
          return function (xs) {
              return function (ys) {
                  return app3(dictMonoid)(dictMeasured)(xs)([  ])(ys);
              };
          };
      };
  };
  exports["Empty"] = Empty;
  exports["eqFingerTree"] = eqFingerTree;
  exports["cons"] = cons;
  exports["snoc"] = snoc;
  exports["head"] = head;
  exports["append"] = append;
  exports["split"] = split;
  exports["filter"] = filter;
  exports["unfoldLeft"] = unfoldLeft;
  exports["functorFingerTree"] = functorFingerTree;
  exports["foldableFingerTree"] = foldableFingerTree;
  exports["measuredFingerTree"] = measuredFingerTree;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Functor.Compose"] = $PS["Data.Functor.Compose"] || {};
  var exports = $PS["Data.Functor.Compose"];       
  var Compose = function (x) {
      return x;
  };
  exports["Compose"] = Compose;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.HugeNum"] = $PS["Data.HugeNum"] || {};
  var exports = $PS["Data.HugeNum"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_Digit = $PS["Data.Digit"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_List = $PS["Data.List"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_String_CodeUnits = $PS["Data.String.CodeUnits"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Plus = (function () {
      function Plus() {

      };
      Plus.value = new Plus();
      return Plus;
  })();
  var Minus = (function () {
      function Minus() {

      };
      Minus.value = new Minus();
      return Minus;
  })();
  var fromString = function (s) {
      var charlist = Data_List.fromFoldable(Data_Foldable.foldableArray)(Data_String_CodeUnits.toCharArray(s));
      return Control_Bind.bind(Data_Maybe.bindMaybe)(Data_List.head(charlist))(function (leadingChar) {
          var signDigits = (function () {
              if (leadingChar === "-") {
                  return {
                      sign: Minus.value,
                      digits: Data_List.drop(1)(charlist)
                  };
              };
              return {
                  sign: Plus.value,
                  digits: charlist
              };
          })();
          return Control_Bind.bind(Data_Maybe.bindMaybe)(Data_List.elemIndex(Data_Eq.eqChar)(".")(signDigits.digits))(function (decimal) {
              return Control_Bind.bind(Data_Maybe.bindMaybe)(Data_List.deleteAt(decimal)(signDigits.digits))(function (newCharlist) {
                  return Control_Bind.bind(Data_Maybe.bindMaybe)(Data_Traversable.sequence(Data_List_Types.traversableList)(Data_Maybe.applicativeMaybe)(Data_Functor.map(Data_List_Types.functorList)(Data_Digit.fromChar)(newCharlist)))(function (digits) {
                      return Control_Applicative.pure(Data_Maybe.applicativeMaybe)({
                          sign: signDigits.sign,
                          decimal: decimal,
                          digits: digits
                      });
                  });
              });
          });
      });
  };
  exports["fromString"] = fromString;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Profunctor"] = $PS["Data.Profunctor"] || {};
  var exports = $PS["Data.Profunctor"];
  var Control_Category = $PS["Control.Category"];        
  var Profunctor = function (dimap) {
      this.dimap = dimap;
  };
  var profunctorFn = new Profunctor(function (a2b) {
      return function (c2d) {
          return function (b2c) {
              return function ($9) {
                  return c2d(b2c(a2b($9)));
              };
          };
      };
  });
  var dimap = function (dict) {
      return dict.dimap;
  };
  var rmap = function (dictProfunctor) {
      return function (b2c) {
          return dimap(dictProfunctor)(Control_Category.identity(Control_Category.categoryFn))(b2c);
      };
  };
  exports["dimap"] = dimap;
  exports["Profunctor"] = Profunctor;
  exports["rmap"] = rmap;
  exports["profunctorFn"] = profunctorFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Profunctor.Choice"] = $PS["Data.Profunctor.Choice"] || {};
  var exports = $PS["Data.Profunctor.Choice"];
  var Data_Either = $PS["Data.Either"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Profunctor = $PS["Data.Profunctor"];                
  var Choice = function (Profunctor0, left, right) {
      this.Profunctor0 = Profunctor0;
      this.left = left;
      this.right = right;
  };
  var right = function (dict) {
      return dict.right;
  };
  var choiceFn = new Choice(function () {
      return Data_Profunctor.profunctorFn;
  }, function (v) {
      return function (v1) {
          if (v1 instanceof Data_Either.Left) {
              return Data_Either.Left.create(v(v1.value0));
          };
          if (v1 instanceof Data_Either.Right) {
              return new Data_Either.Right(v1.value0);
          };
          throw new Error("Failed pattern match at Data.Profunctor.Choice (line 32, column 1 - line 35, column 16): " + [ v.constructor.name, v1.constructor.name ]);
      };
  }, Data_Functor.map(Data_Either.functorEither));
  exports["right"] = right;
  exports["Choice"] = Choice;
  exports["choiceFn"] = choiceFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Profunctor.Strong"] = $PS["Data.Profunctor.Strong"] || {};
  var exports = $PS["Data.Profunctor.Strong"];
  var Control_Category = $PS["Control.Category"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var Strong = function (Profunctor0, first, second) {
      this.Profunctor0 = Profunctor0;
      this.first = first;
      this.second = second;
  };
  var strongFn = new Strong(function () {
      return Data_Profunctor.profunctorFn;
  }, function (a2b) {
      return function (v) {
          return new Data_Tuple.Tuple(a2b(v.value0), v.value1);
      };
  }, Data_Functor.map(Data_Tuple.functorTuple));
  var second = function (dict) {
      return dict.second;
  };
  var first = function (dict) {
      return dict.first;
  };
  var splitStrong = function (dictCategory) {
      return function (dictStrong) {
          return function (l) {
              return function (r) {
                  return Control_Semigroupoid.composeFlipped(dictCategory.Semigroupoid0())(first(dictStrong)(l))(second(dictStrong)(r));
              };
          };
      };
  };
  var fanout = function (dictCategory) {
      return function (dictStrong) {
          return function (l) {
              return function (r) {
                  var split = Data_Profunctor.dimap(dictStrong.Profunctor0())(Control_Category.identity(Control_Category.categoryFn))(function (a) {
                      return new Data_Tuple.Tuple(a, a);
                  })(Control_Category.identity(dictCategory));
                  return Control_Semigroupoid.composeFlipped(dictCategory.Semigroupoid0())(split)(splitStrong(dictCategory)(dictStrong)(l)(r));
              };
          };
      };
  };
  exports["first"] = first;
  exports["second"] = second;
  exports["Strong"] = Strong;
  exports["fanout"] = fanout;
  exports["strongFn"] = strongFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.AffineTraversal"] = $PS["Data.Lens.AffineTraversal"] || {};
  var exports = $PS["Data.Lens.AffineTraversal"];
  var Control_Category = $PS["Control.Category"];
  var Data_Either = $PS["Data.Either"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Profunctor_Choice = $PS["Data.Profunctor.Choice"];
  var Data_Profunctor_Strong = $PS["Data.Profunctor.Strong"];
  var affineTraversal$prime = function (to) {
      return function (dictStrong) {
          return function (dictChoice) {
              return function (pab) {
                  return Data_Profunctor.dimap(dictChoice.Profunctor0())(to)(function (v) {
                      return Data_Either.either(Control_Category.identity(Control_Category.categoryFn))(v.value0)(v.value1);
                  })(Data_Profunctor_Strong.second(dictStrong)(Data_Profunctor_Choice.right(dictChoice)(pab)));
              };
          };
      };
  };
  var affineTraversal = function (set) {
      return function (pre) {
          return function (dictStrong) {
              return function (dictChoice) {
                  return affineTraversal$prime(Data_Profunctor_Strong.fanout(Control_Category.categoryFn)(Data_Profunctor_Strong.strongFn)(set)(pre))(dictStrong)(dictChoice);
              };
          };
      };
  };
  exports["affineTraversal"] = affineTraversal;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.List.Lazy.Types"] = $PS["Data.List.Lazy.Types"] || {};
  var exports = $PS["Data.List.Lazy.Types"];
  var Control_Lazy = $PS["Control.Lazy"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Newtype = $PS["Data.Newtype"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var Data_Unfoldable1 = $PS["Data.Unfoldable1"];                
  var List = function (x) {
      return x;
  };
  var Nil = (function () {
      function Nil() {

      };
      Nil.value = new Nil();
      return Nil;
  })();
  var Cons = (function () {
      function Cons(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Cons.create = function (value0) {
          return function (value1) {
              return new Cons(value0, value1);
          };
      };
      return Cons;
  })();
  var nil = List(Data_Lazy.defer(function (v) {
      return Nil.value;
  }));
  var step = (function () {
      var $225 = Data_Newtype.unwrap();
      return function ($226) {
          return Data_Lazy.force($225($226));
      };
  })();   
  var lazyList = new Control_Lazy.Lazy(function (f) {
      return List(Data_Lazy.defer(function ($227) {
          return step(f($227));
      }));
  });
  var cons = function (x) {
      return function (xs) {
          return List(Data_Lazy.defer(function (v) {
              return new Cons(x, xs);
          }));
      };
  };
  var foldableList = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return Data_Foldable.foldl(foldableList)(function (b) {
              return function (a) {
                  return Data_Semigroup.append(dictMonoid.Semigroup0())(b)(f(a));
              };
          })(Data_Monoid.mempty(dictMonoid));
      };
  }, function (op) {
      var go = function ($copy_b) {
          return function ($copy_xs) {
              var $tco_var_b = $copy_b;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(b, xs) {
                  var v = step(xs);
                  if (v instanceof Nil) {
                      $tco_done = true;
                      return b;
                  };
                  if (v instanceof Cons) {
                      $tco_var_b = op(b)(v.value0);
                      $copy_xs = v.value1;
                      return;
                  };
                  throw new Error("Failed pattern match at Data.List.Lazy.Types (line 128, column 7 - line 130, column 40): " + [ v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_b, $copy_xs);
              };
              return $tco_result;
          };
      };
      return go;
  }, function (op) {
      return function (z) {
          return function (xs) {
              var rev = Data_Foldable.foldl(foldableList)(Data_Function.flip(cons))(nil);
              return Data_Foldable.foldl(foldableList)(Data_Function.flip(op))(z)(rev(xs));
          };
      };
  });
  var unfoldable1List = new Data_Unfoldable1.Unfoldable1((function () {
      var go = function (f) {
          return function (b) {
              return Control_Lazy.defer(lazyList)(function (v) {
                  var v1 = f(b);
                  if (v1.value1 instanceof Data_Maybe.Just) {
                      return cons(v1.value0)(go(f)(v1.value1.value0));
                  };
                  if (v1.value1 instanceof Data_Maybe.Nothing) {
                      return cons(v1.value0)(nil);
                  };
                  throw new Error("Failed pattern match at Data.List.Lazy.Types (line 152, column 28 - line 154, column 33): " + [ v1.constructor.name ]);
              });
          };
      };
      return go;
  })());
  var unfoldableList = new Data_Unfoldable.Unfoldable(function () {
      return unfoldable1List;
  }, (function () {
      var go = function (f) {
          return function (b) {
              return Control_Lazy.defer(lazyList)(function (v) {
                  var v1 = f(b);
                  if (v1 instanceof Data_Maybe.Nothing) {
                      return nil;
                  };
                  if (v1 instanceof Data_Maybe.Just) {
                      return cons(v1.value0.value0)(go(f)(v1.value0.value1));
                  };
                  throw new Error("Failed pattern match at Data.List.Lazy.Types (line 158, column 28 - line 160, column 39): " + [ v1.constructor.name ]);
              });
          };
      };
      return go;
  })());
  exports["List"] = List;
  exports["Nil"] = Nil;
  exports["Cons"] = Cons;
  exports["step"] = step;
  exports["foldableList"] = foldableList;
  exports["unfoldableList"] = unfoldableList;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.List.Lazy"] = $PS["Data.List.Lazy"] || {};
  var exports = $PS["Data.List.Lazy"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_List_Lazy_Types = $PS["Data.List.Lazy.Types"];
  var Data_Newtype = $PS["Data.Newtype"];
  var filter = function (p) {
      var go = function ($copy_v) {
          var $tco_done = false;
          var $tco_result;
          function $tco_loop(v) {
              if (v instanceof Data_List_Lazy_Types.Nil) {
                  $tco_done = true;
                  return Data_List_Lazy_Types.Nil.value;
              };
              if (v instanceof Data_List_Lazy_Types.Cons) {
                  if (p(v.value0)) {
                      $tco_done = true;
                      return new Data_List_Lazy_Types.Cons(v.value0, filter(p)(v.value1));
                  };
                  if (Data_Boolean.otherwise) {
                      $copy_v = Data_List_Lazy_Types.step(v.value1);
                      return;
                  };
              };
              throw new Error("Failed pattern match at Data.List.Lazy (line 416, column 3 - line 416, column 15): " + [ v.constructor.name ]);
          };
          while (!$tco_done) {
              $tco_result = $tco_loop($copy_v);
          };
          return $tco_result;
      };
      var $268 = Data_Functor.map(Data_Lazy.functorLazy)(go);
      var $269 = Data_Newtype.unwrap();
      return function ($270) {
          return Data_List_Lazy_Types.List($268($269($270)));
      };
  };
  exports["filter"] = filter;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Map.Internal"] = $PS["Data.Map.Internal"] || {};
  var exports = $PS["Data.Map.Internal"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Category = $PS["Control.Category"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_FoldableWithIndex = $PS["Data.FoldableWithIndex"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_FunctorWithIndex = $PS["Data.FunctorWithIndex"];
  var Data_List_Lazy = $PS["Data.List.Lazy"];
  var Data_List_Lazy_Types = $PS["Data.List.Lazy.Types"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Data_TraversableWithIndex = $PS["Data.TraversableWithIndex"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];                
  var Leaf = (function () {
      function Leaf() {

      };
      Leaf.value = new Leaf();
      return Leaf;
  })();
  var Two = (function () {
      function Two(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      Two.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new Two(value0, value1, value2, value3);
                  };
              };
          };
      };
      return Two;
  })();
  var Three = (function () {
      function Three(value0, value1, value2, value3, value4, value5, value6) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
          this.value6 = value6;
      };
      Three.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return function (value6) {
                                  return new Three(value0, value1, value2, value3, value4, value5, value6);
                              };
                          };
                      };
                  };
              };
          };
      };
      return Three;
  })();
  var TwoLeft = (function () {
      function TwoLeft(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoLeft(value0, value1, value2);
              };
          };
      };
      return TwoLeft;
  })();
  var TwoRight = (function () {
      function TwoRight(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      TwoRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new TwoRight(value0, value1, value2);
              };
          };
      };
      return TwoRight;
  })();
  var ThreeLeft = (function () {
      function ThreeLeft(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeLeft.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeLeft(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeLeft;
  })();
  var ThreeMiddle = (function () {
      function ThreeMiddle(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeMiddle.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeMiddle(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeMiddle;
  })();
  var ThreeRight = (function () {
      function ThreeRight(value0, value1, value2, value3, value4, value5) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
          this.value4 = value4;
          this.value5 = value5;
      };
      ThreeRight.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return function (value4) {
                          return function (value5) {
                              return new ThreeRight(value0, value1, value2, value3, value4, value5);
                          };
                      };
                  };
              };
          };
      };
      return ThreeRight;
  })();
  var KickUp = (function () {
      function KickUp(value0, value1, value2, value3) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
          this.value3 = value3;
      };
      KickUp.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return function (value3) {
                      return new KickUp(value0, value1, value2, value3);
                  };
              };
          };
      };
      return KickUp;
  })();
  var values = function (v) {
      if (v instanceof Leaf) {
          return Data_List_Types.Nil.value;
      };
      if (v instanceof Two) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(values(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value2))(values(v.value3)));
      };
      if (v instanceof Three) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(values(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value2))(Data_Semigroup.append(Data_List_Types.semigroupList)(values(v.value3))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value5))(values(v.value6)))));
      };
      throw new Error("Failed pattern match at Data.Map.Internal (line 626, column 1 - line 626, column 40): " + [ v.constructor.name ]);
  };
  var singleton = function (k) {
      return function (v) {
          return new Two(Leaf.value, k, v, Leaf.value);
      };
  };
  var toUnfoldable = function (dictUnfoldable) {
      return function (m) {
          var go = function ($copy_v) {
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(v) {
                  if (v instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return Data_Maybe.Nothing.value;
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      if (v.value0 instanceof Leaf) {
                          $copy_v = v.value1;
                          return;
                      };
                      if (v.value0 instanceof Two && (v.value0.value0 instanceof Leaf && v.value0.value3 instanceof Leaf)) {
                          $tco_done = true;
                          return Data_Maybe.Just.create(new Data_Tuple.Tuple(new Data_Tuple.Tuple(v.value0.value1, v.value0.value2), v.value1));
                      };
                      if (v.value0 instanceof Two && v.value0.value0 instanceof Leaf) {
                          $tco_done = true;
                          return Data_Maybe.Just.create(new Data_Tuple.Tuple(new Data_Tuple.Tuple(v.value0.value1, v.value0.value2), new Data_List_Types.Cons(v.value0.value3, v.value1)));
                      };
                      if (v.value0 instanceof Two) {
                          $copy_v = new Data_List_Types.Cons(v.value0.value0, new Data_List_Types.Cons(singleton(v.value0.value1)(v.value0.value2), new Data_List_Types.Cons(v.value0.value3, v.value1)));
                          return;
                      };
                      if (v.value0 instanceof Three) {
                          $copy_v = new Data_List_Types.Cons(v.value0.value0, new Data_List_Types.Cons(singleton(v.value0.value1)(v.value0.value2), new Data_List_Types.Cons(v.value0.value3, new Data_List_Types.Cons(singleton(v.value0.value4)(v.value0.value5), new Data_List_Types.Cons(v.value0.value6, v.value1)))));
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 591, column 18 - line 600, column 71): " + [ v.value0.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map.Internal (line 590, column 3 - line 590, column 19): " + [ v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($copy_v);
              };
              return $tco_result;
          };
          return Data_Unfoldable.unfoldr(dictUnfoldable)(go)(new Data_List_Types.Cons(m, Data_List_Types.Nil.value));
      };
  };
  var toAscArray = toUnfoldable(Data_Unfoldable.unfoldableArray);
  var lookup = function (dictOrd) {
      return function (k) {
          var comp = Data_Ord.compare(dictOrd);
          var go = function ($copy_v) {
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(v) {
                  if (v instanceof Leaf) {
                      $tco_done = true;
                      return Data_Maybe.Nothing.value;
                  };
                  if (v instanceof Two) {
                      var v2 = comp(k)(v.value1);
                      if (v2 instanceof Data_Ordering.EQ) {
                          $tco_done = true;
                          return new Data_Maybe.Just(v.value2);
                      };
                      if (v2 instanceof Data_Ordering.LT) {
                          $copy_v = v.value0;
                          return;
                      };
                      $copy_v = v.value3;
                      return;
                  };
                  if (v instanceof Three) {
                      var v3 = comp(k)(v.value1);
                      if (v3 instanceof Data_Ordering.EQ) {
                          $tco_done = true;
                          return new Data_Maybe.Just(v.value2);
                      };
                      var v4 = comp(k)(v.value4);
                      if (v4 instanceof Data_Ordering.EQ) {
                          $tco_done = true;
                          return new Data_Maybe.Just(v.value5);
                      };
                      if (v3 instanceof Data_Ordering.LT) {
                          $copy_v = v.value0;
                          return;
                      };
                      if (v4 instanceof Data_Ordering.GT) {
                          $copy_v = v.value6;
                          return;
                      };
                      $copy_v = v.value3;
                      return;
                  };
                  throw new Error("Failed pattern match at Data.Map.Internal (line 211, column 5 - line 211, column 22): " + [ v.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($copy_v);
              };
              return $tco_result;
          };
          return go;
      };
  };
  var member = function (dictOrd) {
      return function (k) {
          return function (m) {
              return Data_Maybe.isJust(lookup(dictOrd)(k)(m));
          };
      };
  };
  var keys = function (v) {
      if (v instanceof Leaf) {
          return Data_List_Types.Nil.value;
      };
      if (v instanceof Two) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value1))(keys(v.value3)));
      };
      if (v instanceof Three) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value0))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value1))(Data_Semigroup.append(Data_List_Types.semigroupList)(keys(v.value3))(Data_Semigroup.append(Data_List_Types.semigroupList)(Control_Applicative.pure(Data_List_Types.applicativeList)(v.value4))(keys(v.value6)))));
      };
      throw new Error("Failed pattern match at Data.Map.Internal (line 620, column 1 - line 620, column 38): " + [ v.constructor.name ]);
  };
  var isEmpty = function (v) {
      if (v instanceof Leaf) {
          return true;
      };
      return false;
  };
  var functorMap = new Data_Functor.Functor(function (v) {
      return function (v1) {
          if (v1 instanceof Leaf) {
              return Leaf.value;
          };
          if (v1 instanceof Two) {
              return new Two(Data_Functor.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Data_Functor.map(functorMap)(v)(v1.value3));
          };
          if (v1 instanceof Three) {
              return new Three(Data_Functor.map(functorMap)(v)(v1.value0), v1.value1, v(v1.value2), Data_Functor.map(functorMap)(v)(v1.value3), v1.value4, v(v1.value5), Data_Functor.map(functorMap)(v)(v1.value6));
          };
          throw new Error("Failed pattern match at Data.Map.Internal (line 101, column 1 - line 104, column 110): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var functorWithIndexMap = new Data_FunctorWithIndex.FunctorWithIndex(function () {
      return functorMap;
  }, function (v) {
      return function (v1) {
          if (v1 instanceof Leaf) {
              return Leaf.value;
          };
          if (v1 instanceof Two) {
              return new Two(Data_FunctorWithIndex.mapWithIndex(functorWithIndexMap)(v)(v1.value0), v1.value1, v(v1.value1)(v1.value2), Data_FunctorWithIndex.mapWithIndex(functorWithIndexMap)(v)(v1.value3));
          };
          if (v1 instanceof Three) {
              return new Three(Data_FunctorWithIndex.mapWithIndex(functorWithIndexMap)(v)(v1.value0), v1.value1, v(v1.value1)(v1.value2), Data_FunctorWithIndex.mapWithIndex(functorWithIndexMap)(v)(v1.value3), v1.value4, v(v1.value4)(v1.value5), Data_FunctorWithIndex.mapWithIndex(functorWithIndexMap)(v)(v1.value6));
          };
          throw new Error("Failed pattern match at Data.Map.Internal (line 106, column 1 - line 109, column 152): " + [ v.constructor.name, v1.constructor.name ]);
      };
  });
  var fromZipper = function ($copy_dictOrd) {
      return function ($copy_v) {
          return function ($copy_tree) {
              var $tco_var_dictOrd = $copy_dictOrd;
              var $tco_var_v = $copy_v;
              var $tco_done = false;
              var $tco_result;
              function $tco_loop(dictOrd, v, tree) {
                  if (v instanceof Data_List_Types.Nil) {
                      $tco_done = true;
                      return tree;
                  };
                  if (v instanceof Data_List_Types.Cons) {
                      if (v.value0 instanceof TwoLeft) {
                          $tco_var_dictOrd = dictOrd;
                          $tco_var_v = v.value1;
                          $copy_tree = new Two(tree, v.value0.value0, v.value0.value1, v.value0.value2);
                          return;
                      };
                      if (v.value0 instanceof TwoRight) {
                          $tco_var_dictOrd = dictOrd;
                          $tco_var_v = v.value1;
                          $copy_tree = new Two(v.value0.value0, v.value0.value1, v.value0.value2, tree);
                          return;
                      };
                      if (v.value0 instanceof ThreeLeft) {
                          $tco_var_dictOrd = dictOrd;
                          $tco_var_v = v.value1;
                          $copy_tree = new Three(tree, v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5);
                          return;
                      };
                      if (v.value0 instanceof ThreeMiddle) {
                          $tco_var_dictOrd = dictOrd;
                          $tco_var_v = v.value1;
                          $copy_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, tree, v.value0.value3, v.value0.value4, v.value0.value5);
                          return;
                      };
                      if (v.value0 instanceof ThreeRight) {
                          $tco_var_dictOrd = dictOrd;
                          $tco_var_v = v.value1;
                          $copy_tree = new Three(v.value0.value0, v.value0.value1, v.value0.value2, v.value0.value3, v.value0.value4, v.value0.value5, tree);
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 432, column 3 - line 437, column 88): " + [ v.value0.constructor.name ]);
                  };
                  throw new Error("Failed pattern match at Data.Map.Internal (line 429, column 1 - line 429, column 80): " + [ v.constructor.name, tree.constructor.name ]);
              };
              while (!$tco_done) {
                  $tco_result = $tco_loop($tco_var_dictOrd, $tco_var_v, $copy_tree);
              };
              return $tco_result;
          };
      };
  };
  var insert = function (dictOrd) {
      return function (k) {
          return function (v) {
              var up = function ($copy_v1) {
                  return function ($copy_v2) {
                      var $tco_var_v1 = $copy_v1;
                      var $tco_done = false;
                      var $tco_result;
                      function $tco_loop(v1, v2) {
                          if (v1 instanceof Data_List_Types.Nil) {
                              $tco_done = true;
                              return new Two(v2.value0, v2.value1, v2.value2, v2.value3);
                          };
                          if (v1 instanceof Data_List_Types.Cons) {
                              if (v1.value0 instanceof TwoLeft) {
                                  $tco_done = true;
                                  return fromZipper(dictOrd)(v1.value1)(new Three(v2.value0, v2.value1, v2.value2, v2.value3, v1.value0.value0, v1.value0.value1, v1.value0.value2));
                              };
                              if (v1.value0 instanceof TwoRight) {
                                  $tco_done = true;
                                  return fromZipper(dictOrd)(v1.value1)(new Three(v1.value0.value0, v1.value0.value1, v1.value0.value2, v2.value0, v2.value1, v2.value2, v2.value3));
                              };
                              if (v1.value0 instanceof ThreeLeft) {
                                  $tco_var_v1 = v1.value1;
                                  $copy_v2 = new KickUp(new Two(v2.value0, v2.value1, v2.value2, v2.value3), v1.value0.value0, v1.value0.value1, new Two(v1.value0.value2, v1.value0.value3, v1.value0.value4, v1.value0.value5));
                                  return;
                              };
                              if (v1.value0 instanceof ThreeMiddle) {
                                  $tco_var_v1 = v1.value1;
                                  $copy_v2 = new KickUp(new Two(v1.value0.value0, v1.value0.value1, v1.value0.value2, v2.value0), v2.value1, v2.value2, new Two(v2.value3, v1.value0.value3, v1.value0.value4, v1.value0.value5));
                                  return;
                              };
                              if (v1.value0 instanceof ThreeRight) {
                                  $tco_var_v1 = v1.value1;
                                  $copy_v2 = new KickUp(new Two(v1.value0.value0, v1.value0.value1, v1.value0.value2, v1.value0.value3), v1.value0.value4, v1.value0.value5, new Two(v2.value0, v2.value1, v2.value2, v2.value3));
                                  return;
                              };
                              throw new Error("Failed pattern match at Data.Map.Internal (line 468, column 5 - line 473, column 108): " + [ v1.value0.constructor.name, v2.constructor.name ]);
                          };
                          throw new Error("Failed pattern match at Data.Map.Internal (line 465, column 3 - line 465, column 56): " + [ v1.constructor.name, v2.constructor.name ]);
                      };
                      while (!$tco_done) {
                          $tco_result = $tco_loop($tco_var_v1, $copy_v2);
                      };
                      return $tco_result;
                  };
              };
              var comp = Data_Ord.compare(dictOrd);
              var down = function ($copy_ctx) {
                  return function ($copy_v1) {
                      var $tco_var_ctx = $copy_ctx;
                      var $tco_done1 = false;
                      var $tco_result;
                      function $tco_loop(ctx, v1) {
                          if (v1 instanceof Leaf) {
                              $tco_done1 = true;
                              return up(ctx)(new KickUp(Leaf.value, k, v, Leaf.value));
                          };
                          if (v1 instanceof Two) {
                              var v2 = comp(k)(v1.value1);
                              if (v2 instanceof Data_Ordering.EQ) {
                                  $tco_done1 = true;
                                  return fromZipper(dictOrd)(ctx)(new Two(v1.value0, k, v, v1.value3));
                              };
                              if (v2 instanceof Data_Ordering.LT) {
                                  $tco_var_ctx = new Data_List_Types.Cons(new TwoLeft(v1.value1, v1.value2, v1.value3), ctx);
                                  $copy_v1 = v1.value0;
                                  return;
                              };
                              $tco_var_ctx = new Data_List_Types.Cons(new TwoRight(v1.value0, v1.value1, v1.value2), ctx);
                              $copy_v1 = v1.value3;
                              return;
                          };
                          if (v1 instanceof Three) {
                              var v3 = comp(k)(v1.value1);
                              if (v3 instanceof Data_Ordering.EQ) {
                                  $tco_done1 = true;
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, k, v, v1.value3, v1.value4, v1.value5, v1.value6));
                              };
                              var v4 = comp(k)(v1.value4);
                              if (v4 instanceof Data_Ordering.EQ) {
                                  $tco_done1 = true;
                                  return fromZipper(dictOrd)(ctx)(new Three(v1.value0, v1.value1, v1.value2, v1.value3, k, v, v1.value6));
                              };
                              if (v3 instanceof Data_Ordering.LT) {
                                  $tco_var_ctx = new Data_List_Types.Cons(new ThreeLeft(v1.value1, v1.value2, v1.value3, v1.value4, v1.value5, v1.value6), ctx);
                                  $copy_v1 = v1.value0;
                                  return;
                              };
                              if (v3 instanceof Data_Ordering.GT && v4 instanceof Data_Ordering.LT) {
                                  $tco_var_ctx = new Data_List_Types.Cons(new ThreeMiddle(v1.value0, v1.value1, v1.value2, v1.value4, v1.value5, v1.value6), ctx);
                                  $copy_v1 = v1.value3;
                                  return;
                              };
                              $tco_var_ctx = new Data_List_Types.Cons(new ThreeRight(v1.value0, v1.value1, v1.value2, v1.value3, v1.value4, v1.value5), ctx);
                              $copy_v1 = v1.value6;
                              return;
                          };
                          throw new Error("Failed pattern match at Data.Map.Internal (line 448, column 3 - line 448, column 55): " + [ ctx.constructor.name, v1.constructor.name ]);
                      };
                      while (!$tco_done1) {
                          $tco_result = $tco_loop($tco_var_ctx, $copy_v1);
                      };
                      return $tco_result;
                  };
              };
              return down(Data_List_Types.Nil.value);
          };
      };
  };
  var pop = function (dictOrd) {
      return function (k) {
          var up = function ($copy_ctxs) {
              return function ($copy_tree) {
                  var $tco_var_ctxs = $copy_ctxs;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(ctxs, tree) {
                      if (ctxs instanceof Data_List_Types.Nil) {
                          $tco_done = true;
                          return tree;
                      };
                      if (ctxs instanceof Data_List_Types.Cons) {
                          if (ctxs.value0 instanceof TwoLeft && (ctxs.value0.value2 instanceof Leaf && tree instanceof Leaf)) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(Leaf.value, ctxs.value0.value0, ctxs.value0.value1, Leaf.value));
                          };
                          if (ctxs.value0 instanceof TwoRight && (ctxs.value0.value0 instanceof Leaf && tree instanceof Leaf)) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value));
                          };
                          if (ctxs.value0 instanceof TwoLeft && ctxs.value0.value2 instanceof Two) {
                              $tco_var_ctxs = ctxs.value1;
                              $copy_tree = new Three(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0, ctxs.value0.value2.value1, ctxs.value0.value2.value2, ctxs.value0.value2.value3);
                              return;
                          };
                          if (ctxs.value0 instanceof TwoRight && ctxs.value0.value0 instanceof Two) {
                              $tco_var_ctxs = ctxs.value1;
                              $copy_tree = new Three(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3, ctxs.value0.value1, ctxs.value0.value2, tree);
                              return;
                          };
                          if (ctxs.value0 instanceof TwoLeft && ctxs.value0.value2 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Two(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0), ctxs.value0.value2.value1, ctxs.value0.value2.value2, new Two(ctxs.value0.value2.value3, ctxs.value0.value2.value4, ctxs.value0.value2.value5, ctxs.value0.value2.value6)));
                          };
                          if (ctxs.value0 instanceof TwoRight && ctxs.value0.value0 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Two(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3), ctxs.value0.value0.value4, ctxs.value0.value0.value5, new Two(ctxs.value0.value0.value6, ctxs.value0.value1, ctxs.value0.value2, tree)));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && (ctxs.value0.value2 instanceof Leaf && (ctxs.value0.value5 instanceof Leaf && tree instanceof Leaf))) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value0, ctxs.value0.value1, Leaf.value, ctxs.value0.value3, ctxs.value0.value4, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && (ctxs.value0.value0 instanceof Leaf && (ctxs.value0.value5 instanceof Leaf && tree instanceof Leaf))) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value, ctxs.value0.value3, ctxs.value0.value4, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeRight && (ctxs.value0.value0 instanceof Leaf && (ctxs.value0.value3 instanceof Leaf && tree instanceof Leaf))) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(Leaf.value, ctxs.value0.value1, ctxs.value0.value2, Leaf.value, ctxs.value0.value4, ctxs.value0.value5, Leaf.value));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && ctxs.value0.value2 instanceof Two) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Three(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0, ctxs.value0.value2.value1, ctxs.value0.value2.value2, ctxs.value0.value2.value3), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value0 instanceof Two) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(new Three(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3, ctxs.value0.value1, ctxs.value0.value2, tree), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value5 instanceof Two) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Three(tree, ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5.value0, ctxs.value0.value5.value1, ctxs.value0.value5.value2, ctxs.value0.value5.value3)));
                          };
                          if (ctxs.value0 instanceof ThreeRight && ctxs.value0.value3 instanceof Two) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Two(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Three(ctxs.value0.value3.value0, ctxs.value0.value3.value1, ctxs.value0.value3.value2, ctxs.value0.value3.value3, ctxs.value0.value4, ctxs.value0.value5, tree)));
                          };
                          if (ctxs.value0 instanceof ThreeLeft && ctxs.value0.value2 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(new Two(tree, ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2.value0), ctxs.value0.value2.value1, ctxs.value0.value2.value2, new Two(ctxs.value0.value2.value3, ctxs.value0.value2.value4, ctxs.value0.value2.value5, ctxs.value0.value2.value6), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value0 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(new Two(ctxs.value0.value0.value0, ctxs.value0.value0.value1, ctxs.value0.value0.value2, ctxs.value0.value0.value3), ctxs.value0.value0.value4, ctxs.value0.value0.value5, new Two(ctxs.value0.value0.value6, ctxs.value0.value1, ctxs.value0.value2, tree), ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5));
                          };
                          if (ctxs.value0 instanceof ThreeMiddle && ctxs.value0.value5 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Two(tree, ctxs.value0.value3, ctxs.value0.value4, ctxs.value0.value5.value0), ctxs.value0.value5.value1, ctxs.value0.value5.value2, new Two(ctxs.value0.value5.value3, ctxs.value0.value5.value4, ctxs.value0.value5.value5, ctxs.value0.value5.value6)));
                          };
                          if (ctxs.value0 instanceof ThreeRight && ctxs.value0.value3 instanceof Three) {
                              $tco_done = true;
                              return fromZipper(dictOrd)(ctxs.value1)(new Three(ctxs.value0.value0, ctxs.value0.value1, ctxs.value0.value2, new Two(ctxs.value0.value3.value0, ctxs.value0.value3.value1, ctxs.value0.value3.value2, ctxs.value0.value3.value3), ctxs.value0.value3.value4, ctxs.value0.value3.value5, new Two(ctxs.value0.value3.value6, ctxs.value0.value4, ctxs.value0.value5, tree)));
                          };
                          throw new Error("Failed pattern match at Data.Map.Internal (line 525, column 9 - line 542, column 136): " + [ ctxs.value0.constructor.name, tree.constructor.name ]);
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 522, column 5 - line 542, column 136): " + [ ctxs.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_ctxs, $copy_tree);
                  };
                  return $tco_result;
              };
          };
          var removeMaxNode = function ($copy_ctx) {
              return function ($copy_m) {
                  var $tco_var_ctx = $copy_ctx;
                  var $tco_done1 = false;
                  var $tco_result;
                  function $tco_loop(ctx, m) {
                      if (m instanceof Two && (m.value0 instanceof Leaf && m.value3 instanceof Leaf)) {
                          $tco_done1 = true;
                          return up(ctx)(Leaf.value);
                      };
                      if (m instanceof Two) {
                          $tco_var_ctx = new Data_List_Types.Cons(new TwoRight(m.value0, m.value1, m.value2), ctx);
                          $copy_m = m.value3;
                          return;
                      };
                      if (m instanceof Three && (m.value0 instanceof Leaf && (m.value3 instanceof Leaf && m.value6 instanceof Leaf))) {
                          $tco_done1 = true;
                          return up(new Data_List_Types.Cons(new TwoRight(Leaf.value, m.value1, m.value2), ctx))(Leaf.value);
                      };
                      if (m instanceof Three) {
                          $tco_var_ctx = new Data_List_Types.Cons(new ThreeRight(m.value0, m.value1, m.value2, m.value3, m.value4, m.value5), ctx);
                          $copy_m = m.value6;
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 554, column 5 - line 558, column 107): " + [ m.constructor.name ]);
                  };
                  while (!$tco_done1) {
                      $tco_result = $tco_loop($tco_var_ctx, $copy_m);
                  };
                  return $tco_result;
              };
          };
          var maxNode = function ($copy_m) {
              var $tco_done2 = false;
              var $tco_result;
              function $tco_loop(m) {
                  if (m instanceof Two && m.value3 instanceof Leaf) {
                      $tco_done2 = true;
                      return {
                          key: m.value1,
                          value: m.value2
                      };
                  };
                  if (m instanceof Two) {
                      $copy_m = m.value3;
                      return;
                  };
                  if (m instanceof Three && m.value6 instanceof Leaf) {
                      $tco_done2 = true;
                      return {
                          key: m.value4,
                          value: m.value5
                      };
                  };
                  if (m instanceof Three) {
                      $copy_m = m.value6;
                      return;
                  };
                  throw new Error("Failed pattern match at Data.Map.Internal (line 545, column 33 - line 549, column 45): " + [ m.constructor.name ]);
              };
              while (!$tco_done2) {
                  $tco_result = $tco_loop($copy_m);
              };
              return $tco_result;
          };
          var comp = Data_Ord.compare(dictOrd);
          var down = function ($copy_ctx) {
              return function ($copy_m) {
                  var $tco_var_ctx = $copy_ctx;
                  var $tco_done3 = false;
                  var $tco_result;
                  function $tco_loop(ctx, m) {
                      if (m instanceof Leaf) {
                          $tco_done3 = true;
                          return Data_Maybe.Nothing.value;
                      };
                      if (m instanceof Two) {
                          var v = comp(k)(m.value1);
                          if (m.value3 instanceof Leaf && v instanceof Data_Ordering.EQ) {
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, up(ctx)(Leaf.value)));
                          };
                          if (v instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value0);
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, removeMaxNode(new Data_List_Types.Cons(new TwoLeft(max.key, max.value, m.value3), ctx))(m.value0)));
                          };
                          if (v instanceof Data_Ordering.LT) {
                              $tco_var_ctx = new Data_List_Types.Cons(new TwoLeft(m.value1, m.value2, m.value3), ctx);
                              $copy_m = m.value0;
                              return;
                          };
                          $tco_var_ctx = new Data_List_Types.Cons(new TwoRight(m.value0, m.value1, m.value2), ctx);
                          $copy_m = m.value3;
                          return;
                      };
                      if (m instanceof Three) {
                          var leaves = (function () {
                              if (m.value0 instanceof Leaf && (m.value3 instanceof Leaf && m.value6 instanceof Leaf)) {
                                  return true;
                              };
                              return false;
                          })();
                          var v = comp(k)(m.value4);
                          var v3 = comp(k)(m.value1);
                          if (leaves && v3 instanceof Data_Ordering.EQ) {
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, fromZipper(dictOrd)(ctx)(new Two(Leaf.value, m.value4, m.value5, Leaf.value))));
                          };
                          if (leaves && v instanceof Data_Ordering.EQ) {
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value5, fromZipper(dictOrd)(ctx)(new Two(Leaf.value, m.value1, m.value2, Leaf.value))));
                          };
                          if (v3 instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value0);
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value2, removeMaxNode(new Data_List_Types.Cons(new ThreeLeft(max.key, max.value, m.value3, m.value4, m.value5, m.value6), ctx))(m.value0)));
                          };
                          if (v instanceof Data_Ordering.EQ) {
                              var max = maxNode(m.value3);
                              $tco_done3 = true;
                              return new Data_Maybe.Just(new Data_Tuple.Tuple(m.value5, removeMaxNode(new Data_List_Types.Cons(new ThreeMiddle(m.value0, m.value1, m.value2, max.key, max.value, m.value6), ctx))(m.value3)));
                          };
                          if (v3 instanceof Data_Ordering.LT) {
                              $tco_var_ctx = new Data_List_Types.Cons(new ThreeLeft(m.value1, m.value2, m.value3, m.value4, m.value5, m.value6), ctx);
                              $copy_m = m.value0;
                              return;
                          };
                          if (v3 instanceof Data_Ordering.GT && v instanceof Data_Ordering.LT) {
                              $tco_var_ctx = new Data_List_Types.Cons(new ThreeMiddle(m.value0, m.value1, m.value2, m.value4, m.value5, m.value6), ctx);
                              $copy_m = m.value3;
                              return;
                          };
                          $tco_var_ctx = new Data_List_Types.Cons(new ThreeRight(m.value0, m.value1, m.value2, m.value3, m.value4, m.value5), ctx);
                          $copy_m = m.value6;
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 495, column 34 - line 518, column 80): " + [ m.constructor.name ]);
                  };
                  while (!$tco_done3) {
                      $tco_result = $tco_loop($tco_var_ctx, $copy_m);
                  };
                  return $tco_result;
              };
          };
          return down(Data_List_Types.Nil.value);
      };
  };
  var foldableMap = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return function (m) {
              return Data_Foldable.foldMap(Data_List_Types.foldableList)(dictMonoid)(f)(values(m));
          };
      };
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldl(Data_List_Types.foldableList)(f)(z)(values(m));
          };
      };
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldr(Data_List_Types.foldableList)(f)(z)(values(m));
          };
      };
  });
  var traversableMap = new Data_Traversable.Traversable(function () {
      return foldableMap;
  }, function () {
      return functorMap;
  }, function (dictApplicative) {
      return Data_Traversable.traverse(traversableMap)(dictApplicative)(Control_Category.identity(Control_Category.categoryFn));
  }, function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof Leaf) {
                  return Control_Applicative.pure(dictApplicative)(Leaf.value);
              };
              if (v1 instanceof Two) {
                  return Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(Two.create)(Data_Traversable.traverse(traversableMap)(dictApplicative)(v)(v1.value0)))(Control_Applicative.pure(dictApplicative)(v1.value1)))(v(v1.value2)))(Data_Traversable.traverse(traversableMap)(dictApplicative)(v)(v1.value3));
              };
              if (v1 instanceof Three) {
                  return Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(Three.create)(Data_Traversable.traverse(traversableMap)(dictApplicative)(v)(v1.value0)))(Control_Applicative.pure(dictApplicative)(v1.value1)))(v(v1.value2)))(Data_Traversable.traverse(traversableMap)(dictApplicative)(v)(v1.value3)))(Control_Applicative.pure(dictApplicative)(v1.value4)))(v(v1.value5)))(Data_Traversable.traverse(traversableMap)(dictApplicative)(v)(v1.value6));
              };
              throw new Error("Failed pattern match at Data.Map.Internal (line 127, column 1 - line 142, column 31): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var eqMap = function (dictEq) {
      return function (dictEq1) {
          return new Data_Eq.Eq(function (m1) {
              return function (m2) {
                  return Data_Eq.eq(Data_Eq.eqArray(Data_Tuple.eqTuple(dictEq)(dictEq1)))(toAscArray(m1))(toAscArray(m2));
              };
          });
      };
  };
  var empty = Leaf.value;
  var fromFoldable = function (dictOrd) {
      return function (dictFoldable) {
          return Data_Foldable.foldl(dictFoldable)(function (m) {
              return function (v) {
                  return insert(dictOrd)(v.value0)(v.value1)(m);
              };
          })(empty);
      };
  };
  var filterWithKey = function (dictOrd) {
      return function (predicate) {
          var $764 = fromFoldable(dictOrd)(Data_List_Lazy_Types.foldableList);
          var $765 = Data_List_Lazy.filter(Data_Tuple.uncurry(predicate));
          var $766 = toUnfoldable(Data_List_Lazy_Types.unfoldableList);
          return function ($767) {
              return $764($765($766($767)));
          };
      };
  };
  var filter = function (dictOrd) {
      return function (predicate) {
          return filterWithKey(dictOrd)(Data_Function["const"](predicate));
      };
  };
  var $$delete = function (dictOrd) {
      return function (k) {
          return function (m) {
              return Data_Maybe.maybe(m)(Data_Tuple.snd)(pop(dictOrd)(k)(m));
          };
      };
  };
  var asList = Control_Category.identity(Control_Category.categoryFn);
  var foldableWithIndexMap = new Data_FoldableWithIndex.FoldableWithIndex(function () {
      return foldableMap;
  }, function (dictMonoid) {
      return function (f) {
          return function (m) {
              return Data_Foldable.foldMap(Data_List_Types.foldableList)(dictMonoid)(Data_Tuple.uncurry(f))(asList(toUnfoldable(Data_List_Types.unfoldableList)(m)));
          };
      };
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldl(Data_List_Types.foldableList)((function () {
                  var $769 = Data_Function.flip(f);
                  return function ($770) {
                      return Data_Tuple.uncurry($769($770));
                  };
              })())(z)(asList(toUnfoldable(Data_List_Types.unfoldableList)(m)));
          };
      };
  }, function (f) {
      return function (z) {
          return function (m) {
              return Data_Foldable.foldr(Data_List_Types.foldableList)(Data_Tuple.uncurry(f))(z)(asList(toUnfoldable(Data_List_Types.unfoldableList)(m)));
          };
      };
  });
  var mapMaybeWithKey = function (dictOrd) {
      return function (f) {
          return Data_FoldableWithIndex.foldrWithIndex(foldableWithIndexMap)(function (k) {
              return function (a) {
                  return function (acc) {
                      return Data_Maybe.maybe(acc)(function (b) {
                          return insert(dictOrd)(k)(b)(acc);
                      })(f(k)(a));
                  };
              };
          })(empty);
      };
  };
  var mapMaybe = function (dictOrd) {
      var $771 = mapMaybeWithKey(dictOrd);
      return function ($772) {
          return $771(Data_Function["const"]($772));
      };
  };
  var traversableWithIndexMap = new Data_TraversableWithIndex.TraversableWithIndex(function () {
      return foldableWithIndexMap;
  }, function () {
      return functorWithIndexMap;
  }, function () {
      return traversableMap;
  }, function (dictApplicative) {
      return function (v) {
          return function (v1) {
              if (v1 instanceof Leaf) {
                  return Control_Applicative.pure(dictApplicative)(Leaf.value);
              };
              if (v1 instanceof Two) {
                  return Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(Two.create)(Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexMap)(dictApplicative)(v)(v1.value0)))(Control_Applicative.pure(dictApplicative)(v1.value1)))(v(v1.value1)(v1.value2)))(Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexMap)(dictApplicative)(v)(v1.value3));
              };
              if (v1 instanceof Three) {
                  return Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(Three.create)(Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexMap)(dictApplicative)(v)(v1.value0)))(Control_Applicative.pure(dictApplicative)(v1.value1)))(v(v1.value1)(v1.value2)))(Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexMap)(dictApplicative)(v)(v1.value3)))(Control_Applicative.pure(dictApplicative)(v1.value4)))(v(v1.value4)(v1.value5)))(Data_TraversableWithIndex.traverseWithIndex(traversableWithIndexMap)(dictApplicative)(v)(v1.value6));
              };
              throw new Error("Failed pattern match at Data.Map.Internal (line 144, column 1 - line 158, column 40): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  });
  var alter = function (dictOrd) {
      return function (f) {
          return function (k) {
              return function (m) {
                  var v = f(lookup(dictOrd)(k)(m));
                  if (v instanceof Data_Maybe.Nothing) {
                      return $$delete(dictOrd)(k)(m);
                  };
                  if (v instanceof Data_Maybe.Just) {
                      return insert(dictOrd)(k)(v.value0)(m);
                  };
                  throw new Error("Failed pattern match at Data.Map.Internal (line 563, column 15 - line 565, column 25): " + [ v.constructor.name ]);
              };
          };
      };
  };
  var fromFoldableWith = function (dictOrd) {
      return function (dictFoldable) {
          return function (f) {
              var combine = function (v) {
                  return function (v1) {
                      if (v1 instanceof Data_Maybe.Just) {
                          return Data_Maybe.Just.create(f(v)(v1.value0));
                      };
                      if (v1 instanceof Data_Maybe.Nothing) {
                          return new Data_Maybe.Just(v);
                      };
                      throw new Error("Failed pattern match at Data.Map.Internal (line 580, column 3 - line 580, column 38): " + [ v.constructor.name, v1.constructor.name ]);
                  };
              };
              return Data_Foldable.foldl(dictFoldable)(function (m) {
                  return function (v) {
                      return alter(dictOrd)(combine(v.value1))(v.value0)(m);
                  };
              })(empty);
          };
      };
  };
  var unionWith = function (dictOrd) {
      return function (f) {
          return function (m1) {
              return function (m2) {
                  var go = function (m) {
                      return function (v) {
                          return alter(dictOrd)((function () {
                              var $777 = Data_Maybe.maybe(v.value1)(f(v.value1));
                              return function ($778) {
                                  return Data_Maybe.Just.create($777($778));
                              };
                          })())(v.value0)(m);
                      };
                  };
                  return Data_Foldable.foldl(Data_List_Types.foldableList)(go)(m2)(toUnfoldable(Data_List_Types.unfoldableList)(m1));
              };
          };
      };
  };
  var union = function (dictOrd) {
      return unionWith(dictOrd)(Data_Function["const"]);
  };
  var unions = function (dictOrd) {
      return function (dictFoldable) {
          return Data_Foldable.foldl(dictFoldable)(union(dictOrd))(empty);
      };
  };
  var update = function (dictOrd) {
      return function (f) {
          return function (k) {
              return function (m) {
                  return alter(dictOrd)(Data_Maybe.maybe(Data_Maybe.Nothing.value)(f))(k)(m);
              };
          };
      };
  };
  exports["empty"] = empty;
  exports["isEmpty"] = isEmpty;
  exports["singleton"] = singleton;
  exports["insert"] = insert;
  exports["lookup"] = lookup;
  exports["fromFoldable"] = fromFoldable;
  exports["fromFoldableWith"] = fromFoldableWith;
  exports["toUnfoldable"] = toUnfoldable;
  exports["delete"] = $$delete;
  exports["member"] = member;
  exports["alter"] = alter;
  exports["update"] = update;
  exports["keys"] = keys;
  exports["values"] = values;
  exports["union"] = union;
  exports["unionWith"] = unionWith;
  exports["unions"] = unions;
  exports["filter"] = filter;
  exports["mapMaybe"] = mapMaybe;
  exports["eqMap"] = eqMap;
  exports["functorMap"] = functorMap;
  exports["functorWithIndexMap"] = functorWithIndexMap;
  exports["traversableWithIndexMap"] = traversableWithIndexMap;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Index"] = $PS["Data.Lens.Index"] || {};
  var exports = $PS["Data.Lens.Index"];
  var Data_Either = $PS["Data.Either"];
  var Data_Lens_AffineTraversal = $PS["Data.Lens.AffineTraversal"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Maybe = $PS["Data.Maybe"];                        
  var Index = function (ix) {
      this.ix = ix;
  };
  var ix = function (dict) {
      return dict.ix;
  }; 
  var indexMap = function (dictOrd) {
      return new Index(function (k) {
          return function (dictStrong) {
              return function (dictChoice) {
                  var set = function (s) {
                      return function (b) {
                          return Data_Map_Internal.update(dictOrd)(function (v) {
                              return new Data_Maybe.Just(b);
                          })(k)(s);
                      };
                  };
                  var pre = function (s) {
                      return Data_Maybe.maybe(new Data_Either.Left(s))(Data_Either.Right.create)(Data_Map_Internal.lookup(dictOrd)(k)(s));
                  };
                  return Data_Lens_AffineTraversal.affineTraversal(set)(pre)(dictStrong)(dictChoice);
              };
          };
      });
  };
  exports["Index"] = Index;
  exports["ix"] = ix;
  exports["indexMap"] = indexMap;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Internal.Shop"] = $PS["Data.Lens.Internal.Shop"] || {};
  var exports = $PS["Data.Lens.Internal.Shop"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Profunctor_Strong = $PS["Data.Profunctor.Strong"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var Shop = (function () {
      function Shop(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Shop.create = function (value0) {
          return function (value1) {
              return new Shop(value0, value1);
          };
      };
      return Shop;
  })();
  var profunctorShop = new Data_Profunctor.Profunctor(function (f) {
      return function (g) {
          return function (v) {
              return new Shop(function ($30) {
                  return v.value0(f($30));
              }, function (s) {
                  var $31 = v.value1(f(s));
                  return function ($32) {
                      return g($31($32));
                  };
              });
          };
      };
  });
  var strongShop = new Data_Profunctor_Strong.Strong(function () {
      return profunctorShop;
  }, function (v) {
      return new Shop(function (v1) {
          return v.value0(v1.value0);
      }, function (v1) {
          return function (b) {
              return new Data_Tuple.Tuple(v.value1(v1.value0)(b), v1.value1);
          };
      });
  }, function (v) {
      return new Shop(function (v1) {
          return v.value0(v1.value1);
      }, function (v1) {
          return function (b) {
              return new Data_Tuple.Tuple(v1.value0, v.value1(v1.value1)(b));
          };
      });
  });
  exports["Shop"] = Shop;
  exports["strongShop"] = strongShop;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Lens"] = $PS["Data.Lens.Lens"] || {};
  var exports = $PS["Data.Lens.Lens"];
  var Control_Category = $PS["Control.Category"];
  var Data_Lens_Internal_Shop = $PS["Data.Lens.Internal.Shop"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Profunctor_Strong = $PS["Data.Profunctor.Strong"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var withLens = function (l) {
      return function (f) {
          var v = l(new Data_Lens_Internal_Shop.Shop(Control_Category.identity(Control_Category.categoryFn), function (v1) {
              return function (b) {
                  return b;
              };
          }));
          return f(v.value0)(v.value1);
      };
  };
  var lens$prime = function (to) {
      return function (dictStrong) {
          return function (pab) {
              return Data_Profunctor.dimap(dictStrong.Profunctor0())(to)(function (v) {
                  return v.value1(v.value0);
              })(Data_Profunctor_Strong.first(dictStrong)(pab));
          };
      };
  };
  var lens = function (get) {
      return function (set) {
          return function (dictStrong) {
              return lens$prime(function (s) {
                  return new Data_Tuple.Tuple(get(s), function (b) {
                      return set(s)(b);
                  });
              })(dictStrong);
          };
      };
  };
  var cloneLens = function (l) {
      return function (dictStrong) {
          return withLens(l)(function (x) {
              return function (y) {
                  return function (p) {
                      return lens(x)(y)(dictStrong)(p);
                  };
              };
          });
      };
  };
  exports["lens"] = lens;
  exports["cloneLens"] = cloneLens;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.At"] = $PS["Data.Lens.At"] || {};
  var exports = $PS["Data.Lens.At"];
  var Data_Lens_Index = $PS["Data.Lens.Index"];
  var Data_Lens_Lens = $PS["Data.Lens.Lens"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Maybe = $PS["Data.Maybe"];                        
  var At = function (Index0, at) {
      this.Index0 = Index0;
      this.at = at;
  }; 
  var atMap = function (dictOrd) {
      return new At(function () {
          return Data_Lens_Index.indexMap(dictOrd);
      }, function (k) {
          return function (dictStrong) {
              return Data_Lens_Lens.lens(Data_Map_Internal.lookup(dictOrd)(k))(function (m) {
                  return Data_Maybe["maybe'"](function (v) {
                      return Data_Map_Internal["delete"](dictOrd)(k)(m);
                  })(function (v) {
                      return Data_Map_Internal.insert(dictOrd)(k)(v)(m);
                  });
              })(dictStrong);
          };
      });
  }; 
  var at = function (dict) {
      return dict.at;
  };
  exports["At"] = At;
  exports["at"] = at;
  exports["atMap"] = atMap;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Internal.Forget"] = $PS["Data.Lens.Internal.Forget"] || {};
  var exports = $PS["Data.Lens.Internal.Forget"];
  var Data_Either = $PS["Data.Either"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Profunctor_Choice = $PS["Data.Profunctor.Choice"];
  var Data_Profunctor_Strong = $PS["Data.Profunctor.Strong"];
  var Data_Tuple = $PS["Data.Tuple"];                
  var Forget = function (x) {
      return x;
  };
  var profunctorForget = new Data_Profunctor.Profunctor(function (f) {
      return function (v) {
          return function (v1) {
              return function ($24) {
                  return v1(f($24));
              };
          };
      };
  });
  var strongForget = new Data_Profunctor_Strong.Strong(function () {
      return profunctorForget;
  }, function (v) {
      return function ($25) {
          return v(Data_Tuple.fst($25));
      };
  }, function (v) {
      return function ($26) {
          return v(Data_Tuple.snd($26));
      };
  });
  var choiceForget = function (dictMonoid) {
      return new Data_Profunctor_Choice.Choice(function () {
          return profunctorForget;
      }, function (v) {
          return Data_Either.either(v)(Data_Monoid.mempty(Data_Monoid.monoidFn(dictMonoid)));
      }, function (v) {
          return Data_Either.either(Data_Monoid.mempty(Data_Monoid.monoidFn(dictMonoid)))(v);
      });
  };
  exports["Forget"] = Forget;
  exports["profunctorForget"] = profunctorForget;
  exports["choiceForget"] = choiceForget;
  exports["strongForget"] = strongForget;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Maybe.First"] = $PS["Data.Maybe.First"] || {};
  var exports = $PS["Data.Maybe.First"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];      
  var First = function (x) {
      return x;
  };
  var semigroupFirst = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          if (v instanceof Data_Maybe.Just) {
              return v;
          };
          return v1;
      };
  });
  var monoidFirst = new Data_Monoid.Monoid(function () {
      return semigroupFirst;
  }, Data_Maybe.Nothing.value);
  exports["First"] = First;
  exports["monoidFirst"] = monoidFirst;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Fold"] = $PS["Data.Lens.Fold"] || {};
  var exports = $PS["Data.Lens.Fold"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lens_Internal_Forget = $PS["Data.Lens.Internal.Forget"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Maybe_First = $PS["Data.Maybe.First"];
  var Data_Monoid_Endo = $PS["Data.Monoid.Endo"];
  var Data_Newtype = $PS["Data.Newtype"];
  var Data_Unit = $PS["Data.Unit"];
  var folded = function (dictMonoid) {
      return function (dictFoldable) {
          return function (v) {
              return Data_Foldable.foldMap(dictFoldable)(dictMonoid)(v);
          };
      };
  };
  var foldMapOf = Data_Newtype.under()()(Data_Lens_Internal_Forget.Forget);
  var foldrOf = function (p) {
      return function (f) {
          return function (r) {
              var $75 = Data_Function.flip(Data_Newtype.unwrap())(r);
              var $76 = foldMapOf(p)(function ($78) {
                  return Data_Monoid_Endo.Endo(f($78));
              });
              return function ($77) {
                  return $75($76($77));
              };
          };
      };
  };
  var toListOf = function (p) {
      return foldrOf(p)(Data_List_Types.Cons.create)(Data_List_Types.Nil.value);
  };
  var toListOfOn = function (s) {
      return function (p) {
          return toListOf(p)(s);
      };
  };
  var traverseOf_ = function (dictApplicative) {
      return function (p) {
          return function (f) {
              return foldrOf(p)(function (a) {
                  return function (fu) {
                      return Control_Apply.applySecond(dictApplicative.Apply0())(Data_Functor["void"]((dictApplicative.Apply0()).Functor0())(f(a)))(fu);
                  };
              })(Control_Applicative.pure(dictApplicative)(Data_Unit.unit));
          };
      };
  };
  var preview = function (p) {
      var $99 = Data_Newtype.unwrap();
      var $100 = foldMapOf(p)(function ($102) {
          return Data_Maybe_First.First(Data_Maybe.Just.create($102));
      });
      return function ($101) {
          return $99($100($101));
      };
  };
  var previewOn = function (s) {
      return function (p) {
          return preview(p)(s);
      };
  };
  exports["previewOn"] = previewOn;
  exports["toListOfOn"] = toListOfOn;
  exports["traverseOf_"] = traverseOf_;
  exports["folded"] = folded;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Getter"] = $PS["Data.Lens.Getter"] || {};
  var exports = $PS["Data.Lens.Getter"];
  var Control_Category = $PS["Control.Category"];
  var Control_Monad_State_Class = $PS["Control.Monad.State.Class"];
  var Data_Newtype = $PS["Data.Newtype"];                                    
  var view = function (l) {
      return Data_Newtype.unwrap()(l(Control_Category.identity(Control_Category.categoryFn)));
  };
  var viewOn = function (s) {
      return function (l) {
          return view(l)(s);
      };
  };
  var use = function (dictMonadState) {
      return function (p) {
          return Control_Monad_State_Class.gets(dictMonadState)(function (v) {
              return viewOn(v)(p);
          });
      };
  };
  var to = function (f) {
      return function (p) {
          var $3 = Data_Newtype.unwrap()(p);
          return function ($4) {
              return $3(f($4));
          };
      };
  };
  exports["viewOn"] = viewOn;
  exports["view"] = view;
  exports["to"] = to;
  exports["use"] = use;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Iso"] = $PS["Data.Lens.Iso"] || {};
  var exports = $PS["Data.Lens.Iso"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var iso = function (f) {
      return function (g) {
          return function (dictProfunctor) {
              return function (pab) {
                  return Data_Profunctor.dimap(dictProfunctor)(f)(g)(pab);
              };
          };
      };
  };
  exports["iso"] = iso;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Iso.Newtype"] = $PS["Data.Lens.Iso.Newtype"] || {};
  var exports = $PS["Data.Lens.Iso.Newtype"];
  var Data_Lens_Iso = $PS["Data.Lens.Iso"];
  var Data_Newtype = $PS["Data.Newtype"];                
  var _Newtype = function (dictNewtype) {
      return function (dictNewtype1) {
          return function (dictProfunctor) {
              return Data_Lens_Iso.iso(Data_Newtype.unwrap())(Data_Newtype.wrap())(dictProfunctor);
          };
      };
  };
  exports["_Newtype"] = _Newtype;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Prism"] = $PS["Data.Lens.Prism"] || {};
  var exports = $PS["Data.Lens.Prism"];
  var Control_Category = $PS["Control.Category"];
  var Data_Either = $PS["Data.Either"];
  var Data_Profunctor = $PS["Data.Profunctor"];
  var Data_Profunctor_Choice = $PS["Data.Profunctor.Choice"];           
  var prism = function (to) {
      return function (fro) {
          return function (dictChoice) {
              return function (pab) {
                  return Data_Profunctor.dimap(dictChoice.Profunctor0())(fro)(Data_Either.either(Control_Category.identity(Control_Category.categoryFn))(Control_Category.identity(Control_Category.categoryFn)))(Data_Profunctor_Choice.right(dictChoice)(Data_Profunctor.rmap(dictChoice.Profunctor0())(to)(pab)));
              };
          };
      };
  };
  exports["prism"] = prism;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Prism.Maybe"] = $PS["Data.Lens.Prism.Maybe"] || {};
  var exports = $PS["Data.Lens.Prism.Maybe"];
  var Data_Either = $PS["Data.Either"];
  var Data_Lens_Prism = $PS["Data.Lens.Prism"];
  var Data_Maybe = $PS["Data.Maybe"];
  var _Just = function (dictChoice) {
      return Data_Lens_Prism.prism(Data_Maybe.Just.create)(Data_Maybe.maybe(new Data_Either.Left(Data_Maybe.Nothing.value))(Data_Either.Right.create))(dictChoice);
  };
  exports["_Just"] = _Just;
})(PS);
(function(exports) {
  "use strict";

  exports.unsafeUnionFn = function(r1, r2) {
    var copy = {};
    for (var k1 in r2) {
      if ({}.hasOwnProperty.call(r2, k1)) {
        copy[k1] = r2[k1];
      }
    }
    for (var k2 in r1) {
      if ({}.hasOwnProperty.call(r1, k2)) {
        copy[k2] = r1[k2];
      }
    }
    return copy;
  };
})(PS["Record.Unsafe.Union"] = PS["Record.Unsafe.Union"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Record.Unsafe.Union"] = $PS["Record.Unsafe.Union"] || {};
  var exports = $PS["Record.Unsafe.Union"];
  var $foreign = $PS["Record.Unsafe.Union"];
  exports["unsafeUnionFn"] = $foreign.unsafeUnionFn;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Record"] = $PS["Record"] || {};
  var exports = $PS["Record"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Record_Unsafe = $PS["Record.Unsafe"];
  var Record_Unsafe_Union = $PS["Record.Unsafe.Union"];
  var set = function (dictIsSymbol) {
      return function (dictCons) {
          return function (dictCons1) {
              return function (l) {
                  return function (b) {
                      return function (r) {
                          return Record_Unsafe.unsafeSet(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(b)(r);
                      };
                  };
              };
          };
      };
  };
  var merge = function (dictUnion) {
      return function (dictNub) {
          return function (l) {
              return function (r) {
                  return Record_Unsafe_Union.unsafeUnionFn(l, r);
              };
          };
      };
  };
  var insert = function (dictIsSymbol) {
      return function (dictLacks) {
          return function (dictCons) {
              return function (l) {
                  return function (a) {
                      return function (r) {
                          return Record_Unsafe.unsafeSet(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(a)(r);
                      };
                  };
              };
          };
      };
  };
  var get = function (dictIsSymbol) {
      return function (dictCons) {
          return function (l) {
              return function (r) {
                  return Record_Unsafe.unsafeGet(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(r);
              };
          };
      };
  };
  var $$delete = function (dictIsSymbol) {
      return function (dictLacks) {
          return function (dictCons) {
              return function (l) {
                  return function (r) {
                      return Record_Unsafe.unsafeDelete(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(r);
                  };
              };
          };
      };
  };
  var rename = function (dictIsSymbol) {
      return function (dictIsSymbol1) {
          return function (dictCons) {
              return function (dictLacks) {
                  return function (dictCons1) {
                      return function (dictLacks1) {
                          return function (prev) {
                              return function (next) {
                                  return function (record) {
                                      return insert(dictIsSymbol1)()()(next)(get(dictIsSymbol)()(prev)(record))($$delete(dictIsSymbol)()()(prev)(record));
                                  };
                              };
                          };
                      };
                  };
              };
          };
      };
  };
  exports["get"] = get;
  exports["set"] = set;
  exports["delete"] = $$delete;
  exports["rename"] = rename;
  exports["merge"] = merge;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Record"] = $PS["Data.Lens.Record"] || {};
  var exports = $PS["Data.Lens.Record"];
  var Data_Function = $PS["Data.Function"];
  var Data_Lens_Lens = $PS["Data.Lens.Lens"];
  var Record = $PS["Record"];                
  var prop = function (dictIsSymbol) {
      return function (dictCons) {
          return function (dictCons1) {
              return function (l) {
                  return function (dictStrong) {
                      return Data_Lens_Lens.lens(Record.get(dictIsSymbol)()(l))(Data_Function.flip(Record.set(dictIsSymbol)()()(l)))(dictStrong);
                  };
              };
          };
      };
  };
  exports["prop"] = prop;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Lens.Setter"] = $PS["Data.Lens.Setter"] || {};
  var exports = $PS["Data.Lens.Setter"];
  var Control_Monad_State_Class = $PS["Control.Monad.State.Class"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Maybe = $PS["Data.Maybe"];                
  var over = function (l) {
      return l;
  };
  var set = function (l) {
      return function (b) {
          return over(l)(Data_Function["const"](b));
      };
  };
  var modifying = function (dictMonadState) {
      return function (p) {
          return function (f) {
              return Data_Functor["void"]((((dictMonadState.Monad0()).Bind1()).Apply0()).Functor0())(Control_Monad_State_Class.modify(dictMonadState)(over(p)(f)));
          };
      };
  };
  var assign = function (dictMonadState) {
      return function (p) {
          return function (b) {
              return Data_Functor["void"]((((dictMonadState.Monad0()).Bind1()).Apply0()).Functor0())(Control_Monad_State_Class.modify(dictMonadState)(set(p)(b)));
          };
      };
  };
  var assignJust = function (dictMonadState) {
      return function (p) {
          var $56 = assign(dictMonadState)(p);
          return function ($57) {
              return $56(Data_Maybe.Just.create($57));
          };
      };
  };
  exports["over"] = over;
  exports["set"] = set;
  exports["modifying"] = modifying;
  exports["assignJust"] = assignJust;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Set"] = $PS["Data.Set"] || {};
  var exports = $PS["Data.Set"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Function = $PS["Data.Function"];
  var Data_List = $PS["Data.List"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Unit = $PS["Data.Unit"];                
  var $$Set = function (x) {
      return x;
  };
  var union = function (dictOrd) {
      return function (v) {
          return function (v1) {
              return Data_Map_Internal.union(dictOrd)(v)(v1);
          };
      };
  };
  var toList = function (v) {
      return Data_Map_Internal.keys(v);
  };
  var toUnfoldable = function (dictUnfoldable) {
      var $66 = Data_List.toUnfoldable(dictUnfoldable);
      return function ($67) {
          return $66(toList($67));
      };
  };
  var singleton = function (a) {
      return Data_Map_Internal.singleton(a)(Data_Unit.unit);
  };
  var semigroupSet = function (dictOrd) {
      return new Data_Semigroup.Semigroup(union(dictOrd));
  };
  var member = function (dictOrd) {
      return function (a) {
          return function (v) {
              return Data_Map_Internal.member(dictOrd)(a)(v);
          };
      };
  };
  var isEmpty = function (v) {
      return Data_Map_Internal.isEmpty(v);
  };
  var insert = function (dictOrd) {
      return function (a) {
          return function (v) {
              return Data_Map_Internal.insert(dictOrd)(a)(Data_Unit.unit)(v);
          };
      };
  };
  var fromMap = $$Set;
  var foldableSet = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          var $68 = Data_Foldable.foldMap(Data_List_Types.foldableList)(dictMonoid)(f);
          return function ($69) {
              return $68(toList($69));
          };
      };
  }, function (f) {
      return function (x) {
          var $70 = Data_Foldable.foldl(Data_List_Types.foldableList)(f)(x);
          return function ($71) {
              return $70(toList($71));
          };
      };
  }, function (f) {
      return function (x) {
          var $72 = Data_Foldable.foldr(Data_List_Types.foldableList)(f)(x);
          return function ($73) {
              return $72(toList($73));
          };
      };
  });
  var eqSet = function (dictEq) {
      return new Data_Eq.Eq(function (v) {
          return function (v1) {
              return Data_Eq.eq(Data_Map_Internal.eqMap(dictEq)(Data_Eq.eqUnit))(v)(v1);
          };
      });
  }; 
  var empty = Data_Map_Internal.empty;
  var fromFoldable = function (dictFoldable) {
      return function (dictOrd) {
          return Data_Foldable.foldl(dictFoldable)(function (m) {
              return function (a) {
                  return insert(dictOrd)(a)(m);
              };
          })(empty);
      };
  };
  var monoidSet = function (dictOrd) {
      return new Data_Monoid.Monoid(function () {
          return semigroupSet(dictOrd);
      }, empty);
  };
  var unions = function (dictFoldable) {
      return function (dictOrd) {
          return Data_Foldable.foldl(dictFoldable)(union(dictOrd))(empty);
      };
  };
  var $$delete = function (dictOrd) {
      return function (a) {
          return function (v) {
              return Data_Map_Internal["delete"](dictOrd)(a)(v);
          };
      };
  };
  var difference = function (dictOrd) {
      return function (s1) {
          return function (s2) {
              return Data_Foldable.foldl(Data_List_Types.foldableList)(Data_Function.flip($$delete(dictOrd)))(s1)(toList(s2));
          };
      };
  };
  exports["fromFoldable"] = fromFoldable;
  exports["toUnfoldable"] = toUnfoldable;
  exports["empty"] = empty;
  exports["isEmpty"] = isEmpty;
  exports["singleton"] = singleton;
  exports["insert"] = insert;
  exports["member"] = member;
  exports["delete"] = $$delete;
  exports["union"] = union;
  exports["unions"] = unions;
  exports["difference"] = difference;
  exports["fromMap"] = fromMap;
  exports["eqSet"] = eqSet;
  exports["monoidSet"] = monoidSet;
  exports["semigroupSet"] = semigroupSet;
  exports["foldableSet"] = foldableSet;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Map"] = $PS["Data.Map"] || {};
  var exports = $PS["Data.Map"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Set = $PS["Data.Set"];                
  var SemigroupMap = function (x) {
      return x;
  };
  var semigroupSemigroupMap = function (dictOrd) {
      return function (dictSemigroup) {
          return new Data_Semigroup.Semigroup(function (v) {
              return function (v1) {
                  return Data_Map_Internal.unionWith(dictOrd)(Data_Semigroup.append(dictSemigroup))(v)(v1);
              };
          });
      };
  }; 
  var monoidSemigroupMap = function (dictOrd) {
      return function (dictSemigroup) {
          return new Data_Monoid.Monoid(function () {
              return semigroupSemigroupMap(dictOrd)(dictSemigroup);
          }, Data_Map_Internal.empty);
      };
  };
  var keys = (function () {
      var $20 = Data_Functor["void"](Data_Map_Internal.functorMap);
      return function ($21) {
          return Data_Set.fromMap($20($21));
      };
  })();
  exports["keys"] = keys;
  exports["SemigroupMap"] = SemigroupMap;
  exports["monoidSemigroupMap"] = monoidSemigroupMap;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Monoid.Additive"] = $PS["Data.Monoid.Additive"] || {};
  var exports = $PS["Data.Monoid.Additive"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Semiring = $PS["Data.Semiring"];        
  var Additive = function (x) {
      return x;
  };
  var semigroupAdditive = function (dictSemiring) {
      return new Data_Semigroup.Semigroup(function (v) {
          return function (v1) {
              return Data_Semiring.add(dictSemiring)(v)(v1);
          };
      });
  };
  var monoidAdditive = function (dictSemiring) {
      return new Data_Monoid.Monoid(function () {
          return semigroupAdditive(dictSemiring);
      }, Data_Semiring.zero(dictSemiring));
  }; 
  var eqAdditive = function (dictEq) {
      return dictEq;
  };
  exports["Additive"] = Additive;
  exports["eqAdditive"] = eqAdditive;
  exports["semigroupAdditive"] = semigroupAdditive;
  exports["monoidAdditive"] = monoidAdditive;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Ord.Down"] = $PS["Data.Ord.Down"] || {};
  var exports = $PS["Data.Ord.Down"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];        
  var Down = function (x) {
      return x;
  }; 
  var eqDown = function (dictEq) {
      return dictEq;
  };
  var ordDown = function (dictOrd) {
      return new Data_Ord.Ord(function () {
          return eqDown(dictOrd.Eq0());
      }, function (v) {
          return function (v1) {
              return Data_Ordering.invert(Data_Ord.compare(dictOrd)(v)(v1));
          };
      });
  };
  exports["Down"] = Down;
  exports["ordDown"] = ordDown;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Ord.Generic"] = $PS["Data.Ord.Generic"] || {};
  var exports = $PS["Data.Ord.Generic"];
  var Data_Generic_Rep = $PS["Data.Generic.Rep"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];                
  var GenericOrd = function (genericCompare$prime) {
      this["genericCompare'"] = genericCompare$prime;
  }; 
  var genericOrdNoArguments = new GenericOrd(function (v) {
      return function (v1) {
          return Data_Ordering.EQ.value;
      };
  });
  var genericOrdArgument = function (dictOrd) {
      return new GenericOrd(function (v) {
          return function (v1) {
              return Data_Ord.compare(dictOrd)(v)(v1);
          };
      });
  };
  var genericCompare$prime = function (dict) {
      return dict["genericCompare'"];
  };
  var genericOrdConstructor = function (dictGenericOrd) {
      return new GenericOrd(function (v) {
          return function (v1) {
              return genericCompare$prime(dictGenericOrd)(v)(v1);
          };
      });
  };
  var genericOrdSum = function (dictGenericOrd) {
      return function (dictGenericOrd1) {
          return new GenericOrd(function (v) {
              return function (v1) {
                  if (v instanceof Data_Generic_Rep.Inl && v1 instanceof Data_Generic_Rep.Inl) {
                      return genericCompare$prime(dictGenericOrd)(v.value0)(v1.value0);
                  };
                  if (v instanceof Data_Generic_Rep.Inr && v1 instanceof Data_Generic_Rep.Inr) {
                      return genericCompare$prime(dictGenericOrd1)(v.value0)(v1.value0);
                  };
                  if (v instanceof Data_Generic_Rep.Inl && v1 instanceof Data_Generic_Rep.Inr) {
                      return Data_Ordering.LT.value;
                  };
                  if (v instanceof Data_Generic_Rep.Inr && v1 instanceof Data_Generic_Rep.Inl) {
                      return Data_Ordering.GT.value;
                  };
                  throw new Error("Failed pattern match at Data.Ord.Generic (line 19, column 1 - line 23, column 39): " + [ v.constructor.name, v1.constructor.name ]);
              };
          });
      };
  };
  var genericCompare = function (dictGeneric) {
      return function (dictGenericOrd) {
          return function (x) {
              return function (y) {
                  return genericCompare$prime(dictGenericOrd)(Data_Generic_Rep.from(dictGeneric)(x))(Data_Generic_Rep.from(dictGeneric)(y));
              };
          };
      };
  };
  exports["genericCompare"] = genericCompare;
  exports["genericOrdNoArguments"] = genericOrdNoArguments;
  exports["genericOrdSum"] = genericOrdSum;
  exports["genericOrdConstructor"] = genericOrdConstructor;
  exports["genericOrdArgument"] = genericOrdArgument;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Semiring.Free"] = $PS["Data.Semiring.Free"] || {};
  var exports = $PS["Data.Semiring.Free"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_List = $PS["Data.List"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Semiring = $PS["Data.Semiring"];
  var semiringFree = new Data_Semiring.Semiring(function (v) {
      return function (v1) {
          return Data_Semigroup.append(Data_List_Types.semigroupList)(v)(v1);
      };
  }, function (v) {
      return function (v1) {
          return Control_Bind.bind(Data_List_Types.bindList)(v)(function (xs) {
              return Control_Bind.bind(Data_List_Types.bindList)(v1)(function (ys) {
                  return Control_Applicative.pure(Data_List_Types.applicativeList)(Data_Semigroup.append(Data_List_Types.semigroupList)(xs)(ys));
              });
          });
      };
  }, Data_List.singleton(Data_List_Types.Nil.value), Data_List_Types.Nil.value);
  var free = function (a) {
      return Data_List.singleton(Data_List.singleton(a));
  };
  exports["free"] = free;
  exports["semiringFree"] = semiringFree;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Sequence"] = $PS["Data.Sequence"] || {};
  var exports = $PS["Data.Sequence"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_FingerTree = $PS["Data.FingerTree"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Monoid_Additive = $PS["Data.Monoid.Additive"];
  var Data_Newtype = $PS["Data.Newtype"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Semiring = $PS["Data.Semiring"];
  var Data_Sequence_Internal = $PS["Data.Sequence.Internal"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var Data_Unfoldable1 = $PS["Data.Unfoldable1"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];
  var toUnfoldable = function (dictFunctor) {
      return function (dictUnfoldable) {
          return function (v) {
              return Data_Sequence_Internal.mapGetElem(dictFunctor)(Data_FingerTree.unfoldLeft(dictUnfoldable)(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(v));
          };
      };
  };
  var splitAt$prime = function (i) {
      return function (v) {
          var tuple = Data_FingerTree.split(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)()(function (n) {
              return i < Data_Newtype.unwrap()(n);
          })(v);
          var seqify = function (dictFunctor) {
              return Unsafe_Coerce.unsafeCoerce;
          };
          return seqify(Data_Lazy.functorLazy)(tuple);
      };
  };
  var take = function (i) {
      var $119 = splitAt$prime(i);
      return function ($120) {
          return Data_Lazy.force(Data_Tuple.fst($119($120)));
      };
  };
  var snoc = function (v) {
      return function (x) {
          return Data_FingerTree.snoc(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(v)(x);
      };
  };
  var $$null = function (v) {
      if (v instanceof Data_FingerTree.Empty) {
          return true;
      };
      return false;
  };
  var map = function (f) {
      return function (v) {
          return Data_Functor.map(Data_FingerTree.functorFingerTree)(f)(v);
      };
  };
  var length = function (v) {
      return Data_Newtype.un()(Data_Monoid_Additive.Additive)(Data_Sequence_Internal.measure(Data_FingerTree.measuredFingerTree(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem))(v));
  };
  var head = function (v) {
      return Data_Sequence_Internal.mapGetElem(Data_Maybe.functorMaybe)(Data_FingerTree.head(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(v));
  };
  var functorSeq = new Data_Functor.Functor(map);
  var foldableSeq = new Data_Foldable.Foldable(function (dictMonoid) {
      return function (f) {
          return function (v) {
              return Data_Foldable.foldMap(Data_FingerTree.foldableFingerTree)(dictMonoid)(Data_Sequence_Internal.liftElem(f))(v);
          };
      };
  }, function (f) {
      return function (z) {
          return function (v) {
              return Data_Foldable.foldl(Data_FingerTree.foldableFingerTree)(Data_Sequence_Internal.lift2Elem(f))(z)(v);
          };
      };
  }, function (f) {
      return function (z) {
          return function (v) {
              return Data_Foldable.foldr(Data_FingerTree.foldableFingerTree)(Data_Sequence_Internal.liftElem(f))(z)(v);
          };
      };
  });
  var filter = function (p) {
      return function (v) {
          return Data_FingerTree.filter(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(p)(v);
      };
  };
  var eqSeq = function (dictEq) {
      return new Data_Eq.Eq(function (v) {
          return function (v1) {
              return Data_FingerTree.eqFingerTree(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(Data_Sequence_Internal.eqElem(dictEq))(v)(v1);
          };
      });
  };
  var empty = Data_FingerTree.Empty.value;
  var unfoldable1Seq = new Data_Unfoldable1.Unfoldable1(function (f) {
      return function (xs) {
          var go = function ($copy_source) {
              return function ($copy_memo) {
                  var $tco_var_source = $copy_source;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(source, memo) {
                      var v = f(source);
                      if (v.value1 instanceof Data_Maybe.Nothing) {
                          $tco_done = true;
                          return snoc(memo)(v.value0);
                      };
                      if (v.value1 instanceof Data_Maybe.Just) {
                          $tco_var_source = v.value1.value0;
                          $copy_memo = snoc(memo)(v.value0);
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Sequence (line 128, column 9 - line 133, column 32): " + [ v.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_source, $copy_memo);
                  };
                  return $tco_result;
              };
          };
          return go(xs)(empty);
      };
  });
  var unfoldableSeq = new Data_Unfoldable.Unfoldable(function () {
      return unfoldable1Seq;
  }, function (f) {
      return function (xs) {
          var go = function ($copy_source) {
              return function ($copy_memo) {
                  var $tco_var_source = $copy_source;
                  var $tco_done = false;
                  var $tco_result;
                  function $tco_loop(source, memo) {
                      var v = f(source);
                      if (v instanceof Data_Maybe.Nothing) {
                          $tco_done = true;
                          return memo;
                      };
                      if (v instanceof Data_Maybe.Just) {
                          $tco_var_source = v.value0.value1;
                          $copy_memo = snoc(memo)(v.value0.value0);
                          return;
                      };
                      throw new Error("Failed pattern match at Data.Sequence (line 139, column 7 - line 144, column 30): " + [ v.constructor.name ]);
                  };
                  while (!$tco_done) {
                      $tco_result = $tco_loop($tco_var_source, $copy_memo);
                  };
                  return $tco_result;
              };
          };
          return go(xs)(empty);
      };
  });
  var drop = function (i) {
      var $121 = splitAt$prime(i);
      return function ($122) {
          return Data_Lazy.force(Data_Tuple.snd($121($122)));
      };
  };
  var cons = function (x) {
      return function (v) {
          return Data_FingerTree.cons(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(x)(v);
      };
  };
  var fromFoldable = function (dictFoldable) {
      return Data_Foldable.foldr(dictFoldable)(cons)(empty);
  };
  var singleton = function (x) {
      return cons(x)(empty);
  };
  var append = function (v) {
      return function (v1) {
          return Data_FingerTree.append(Data_Monoid_Additive.monoidAdditive(Data_Semiring.semiringInt))(Data_Sequence_Internal.measuredElem)(v)(v1);
      };
  };
  var concat = Data_Foldable.foldr(foldableSeq)(append)(empty);
  var concatMap = function (f) {
      var $123 = map(f);
      return function ($124) {
          return concat($123($124));
      };
  };            
  var semigroupSeq = new Data_Semigroup.Semigroup(append);
  var monoidSeq = new Data_Monoid.Monoid(function () {
      return semigroupSeq;
  }, empty);
  exports["empty"] = empty;
  exports["singleton"] = singleton;
  exports["cons"] = cons;
  exports["map"] = map;
  exports["concatMap"] = concatMap;
  exports["fromFoldable"] = fromFoldable;
  exports["length"] = length;
  exports["null"] = $$null;
  exports["head"] = head;
  exports["toUnfoldable"] = toUnfoldable;
  exports["take"] = take;
  exports["drop"] = drop;
  exports["filter"] = filter;
  exports["eqSeq"] = eqSeq;
  exports["monoidSeq"] = monoidSeq;
  exports["foldableSeq"] = foldableSeq;
  exports["unfoldableSeq"] = unfoldableSeq;
  exports["functorSeq"] = functorSeq;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Sequence.Ordered"] = $PS["Data.Sequence.Ordered"] || {};
  var exports = $PS["Data.Sequence.Ordered"];
  var Data_FingerTree = $PS["Data.FingerTree"];
  var Data_Lazy = $PS["Data.Lazy"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Sequence_Internal = $PS["Data.Sequence.Internal"];
  var Data_Tuple = $PS["Data.Tuple"];
  var toUnfoldable = function (dictFunctor) {
      return function (dictUnfoldable) {
          return function (v) {
              return Data_Sequence_Internal.mapGetElem(dictFunctor)(Data_FingerTree.unfoldLeft(dictUnfoldable)(Data_Sequence_Internal.monoidKey)(Data_Sequence_Internal.measuredElemKey)(v));
          };
      };
  };
  var split = function (dictPartial) {
      return function (f) {
          return function (x) {
              return Data_FingerTree.split(Data_Sequence_Internal.monoidKey)(Data_Sequence_Internal.measuredElemKey)()(function (y) {
                  return f(y)(new Data_Sequence_Internal.Key(x));
              });
          };
      };
  };
  var splitGEQ = function (dictOrd) {
      return split()(Data_Ord.greaterThanOrEq(Data_Sequence_Internal.ordKey(dictOrd)));
  };
  var insert = function (dictOrd) {
      return function (x) {
          return function (v) {
              var t = splitGEQ(dictOrd)(x)(v);
              var r = Data_Tuple.snd(t);
              var l = Data_Tuple.fst(t);
              return Data_FingerTree.append(Data_Sequence_Internal.monoidKey)(Data_Sequence_Internal.measuredElemKey)(Data_Lazy.force(l))(Data_FingerTree.cons(Data_Sequence_Internal.monoidKey)(Data_Sequence_Internal.measuredElemKey)(x)(Data_Lazy.force(r)));
          };
      };
  };
  var empty = Data_FingerTree.Empty.value;
  exports["empty"] = empty;
  exports["insert"] = insert;
  exports["toUnfoldable"] = toUnfoldable;
})(PS);
(function(exports) {
  "use strict";

  exports.intercalate = function (separator) {
    return function (xs) {
      var len = xs.length;
      if (len === 0) return "";

      var res = xs[0];
      for (var i = 1; i < len; i++) {
        res = res + separator + xs[i];
      }
      return res;
    };
  };
})(PS["Data.Show.Generic"] = PS["Data.Show.Generic"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Show.Generic"] = $PS["Data.Show.Generic"] || {};
  var exports = $PS["Data.Show.Generic"];
  var $foreign = $PS["Data.Show.Generic"];
  var Data_Generic_Rep = $PS["Data.Generic.Rep"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Show = $PS["Data.Show"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Type_Proxy = $PS["Type.Proxy"];                
  var GenericShowArgs = function (genericShowArgs) {
      this.genericShowArgs = genericShowArgs;
  };
  var GenericShow = function (genericShow$prime) {
      this["genericShow'"] = genericShow$prime;
  };
  var genericShowArgsNoArguments = new GenericShowArgs(function (v) {
      return [  ];
  });
  var genericShowArgsArgument = function (dictShow) {
      return new GenericShowArgs(function (v) {
          return [ Data_Show.show(dictShow)(v) ];
      });
  };
  var genericShowArgs = function (dict) {
      return dict.genericShowArgs;
  };
  var genericShowConstructor = function (dictGenericShowArgs) {
      return function (dictIsSymbol) {
          return new GenericShow(function (v) {
              var ctor = Data_Symbol.reflectSymbol(dictIsSymbol)(Type_Proxy["Proxy"].value);
              var v1 = genericShowArgs(dictGenericShowArgs)(v);
              if (v1.length === 0) {
                  return ctor;
              };
              return "(" + ($foreign.intercalate(" ")(Data_Semigroup.append(Data_Semigroup.semigroupArray)([ ctor ])(v1)) + ")");
          });
      };
  };
  var genericShow$prime = function (dict) {
      return dict["genericShow'"];
  }; 
  var genericShowSum = function (dictGenericShow) {
      return function (dictGenericShow1) {
          return new GenericShow(function (v) {
              if (v instanceof Data_Generic_Rep.Inl) {
                  return genericShow$prime(dictGenericShow)(v.value0);
              };
              if (v instanceof Data_Generic_Rep.Inr) {
                  return genericShow$prime(dictGenericShow1)(v.value0);
              };
              throw new Error("Failed pattern match at Data.Show.Generic (line 26, column 1 - line 28, column 40): " + [ v.constructor.name ]);
          });
      };
  };
  var genericShow = function (dictGeneric) {
      return function (dictGenericShow) {
          return function (x) {
              return genericShow$prime(dictGenericShow)(Data_Generic_Rep.from(dictGeneric)(x));
          };
      };
  };
  exports["genericShow"] = genericShow;
  exports["genericShowArgsNoArguments"] = genericShowArgsNoArguments;
  exports["genericShowSum"] = genericShowSum;
  exports["genericShowConstructor"] = genericShowConstructor;
  exports["genericShowArgsArgument"] = genericShowArgsArgument;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Pattern"] = $PS["Data.String.Pattern"] || {};
  var exports = $PS["Data.String.Pattern"];
  var Pattern = function (x) {
      return x;
  };
  exports["Pattern"] = Pattern;
})(PS);
(function(exports) {
  "use strict";

  exports.regexImpl = function (left) {
    return function (right) {
      return function (s1) {
        return function (s2) {
          try {
            return right(new RegExp(s1, s2));
          } catch (e) {
            return left(e.message);
          }
        };
      };
    };
  };

  exports.test = function (r) {
    return function (s) {
      var lastIndex = r.lastIndex;
      var result = r.test(s);
      r.lastIndex = lastIndex;
      return result;
    };
  };

  exports.replace = function (r) {
    return function (s1) {
      return function (s2) {
        return s2.replace(r, s1);
      };
    };
  };
})(PS["Data.String.Regex"] = PS["Data.String.Regex"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Regex"] = $PS["Data.String.Regex"] || {};
  var exports = $PS["Data.String.Regex"];
  var $foreign = $PS["Data.String.Regex"];
  var Data_Either = $PS["Data.Either"];                                                        
  var renderFlags = function (v) {
      return (function () {
          if (v.value0.global) {
              return "g";
          };
          return "";
      })() + ((function () {
          if (v.value0.ignoreCase) {
              return "i";
          };
          return "";
      })() + ((function () {
          if (v.value0.multiline) {
              return "m";
          };
          return "";
      })() + ((function () {
          if (v.value0.dotAll) {
              return "s";
          };
          return "";
      })() + ((function () {
          if (v.value0.sticky) {
              return "y";
          };
          return "";
      })() + (function () {
          if (v.value0.unicode) {
              return "u";
          };
          return "";
      })()))));
  };
  var regex = function (s) {
      return function (f) {
          return $foreign.regexImpl(Data_Either.Left.create)(Data_Either.Right.create)(s)(renderFlags(f));
      };
  };
  exports["regex"] = regex;
  exports["test"] = $foreign.test;
  exports["replace"] = $foreign.replace;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Regex.Flags"] = $PS["Data.String.Regex.Flags"] || {};
  var exports = $PS["Data.String.Regex.Flags"];
  var Data_Semigroup = $PS["Data.Semigroup"];                        
  var RegexFlags = (function () {
      function RegexFlags(value0) {
          this.value0 = value0;
      };
      RegexFlags.create = function (value0) {
          return new RegexFlags(value0);
      };
      return RegexFlags;
  })();
  var unicode = new RegexFlags({
      global: false,
      ignoreCase: false,
      multiline: false,
      dotAll: false,
      sticky: false,
      unicode: true
  });
  var sticky = new RegexFlags({
      global: false,
      ignoreCase: false,
      multiline: false,
      dotAll: false,
      sticky: true,
      unicode: false
  });
  var semigroupRegexFlags = new Data_Semigroup.Semigroup(function (v) {
      return function (v1) {
          return new RegexFlags({
              global: v.value0.global || v1.value0.global,
              ignoreCase: v.value0.ignoreCase || v1.value0.ignoreCase,
              multiline: v.value0.multiline || v1.value0.multiline,
              dotAll: v.value0.dotAll || v1.value0.dotAll,
              sticky: v.value0.sticky || v1.value0.sticky,
              unicode: v.value0.unicode || v1.value0.unicode
          });
      };
  });
  var noFlags = new RegexFlags({
      global: false,
      ignoreCase: false,
      multiline: false,
      dotAll: false,
      sticky: false,
      unicode: false
  });
  var multiline = new RegexFlags({
      global: false,
      ignoreCase: false,
      multiline: true,
      dotAll: false,
      sticky: false,
      unicode: false
  });         
  var ignoreCase = new RegexFlags({
      global: false,
      ignoreCase: true,
      multiline: false,
      dotAll: false,
      sticky: false,
      unicode: false
  });
  var global = new RegexFlags({
      global: true,
      ignoreCase: false,
      multiline: false,
      dotAll: false,
      sticky: false,
      unicode: false
  });
  var dotAll = new RegexFlags({
      global: false,
      ignoreCase: false,
      multiline: false,
      dotAll: true,
      sticky: false,
      unicode: false
  });
  exports["noFlags"] = noFlags;
  exports["global"] = global;
  exports["multiline"] = multiline;
  exports["semigroupRegexFlags"] = semigroupRegexFlags;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Regex.Unsafe"] = $PS["Data.String.Regex.Unsafe"] || {};
  var exports = $PS["Data.String.Regex.Unsafe"];
  var Control_Category = $PS["Control.Category"];
  var Data_Either = $PS["Data.Either"];
  var Data_String_Regex = $PS["Data.String.Regex"];
  var Partial_Unsafe = $PS["Partial.Unsafe"];                
  var unsafeRegex = function (s) {
      return function (f) {
          return Data_Either.either(Partial_Unsafe.unsafeCrashWith)(Control_Category.identity(Control_Category.categoryFn))(Data_String_Regex.regex(s)(f));
      };
  };
  exports["unsafeRegex"] = unsafeRegex;
})(PS);
(function(exports) {
  "use strict";

  function codePointAtImpl (just, nothing, i, s) {
    var codePointArray = Array.from(s);
    var isWithinRange  = i >= 0 && i < codePointArray.length;

    return isWithinRange ? just(codePointArray[i].codePointAt(0)) : nothing;
  }

  function codePointAtPrimeImpl (just, nothing, i, s) {
    return i >= 0 && i < s.length ? just(s.codePointAt(i)) : nothing;
  }

  function endsWithImpl (searchString, s) {
    return s.endsWith(searchString);
  }

  function endsWithPrimeImpl (searchString, position, s) {
    return s.endsWith(searchString, position);
  }

  function escapeRegexImpl (str) {
    return str.replace(/[.*+?^${}()|[\]\-\\]/g, "\\$&");
  }

  function fromCharArrayImpl (array) {
    return array.join("");
  }

  function includesImpl (searchString, str) {
    return str.includes(searchString);
  }

  function includesPrimeImpl (needle, position, haystack) {
    // For negative `position` values, we search from the beginning of the
    // string. This is in accordance with the native
    // `String.prototype.include` function.
    var pos = Math.max(0, position);

    // Converting to arrays takes care of any surrogate code points
    var needleA    = Array.from(needle);
    var haystackA  = Array.from(haystack).slice(pos);
    var needleALen = needleA.length;

    var maxIndex = haystackA.length + 1 - needleALen;
    var found    = false;
    var i;

    // Naive implementation, at some point we should check whether Boyer-Moore
    // or Knuth-Morris-Pratt are worthwhile
    for (i = 0; i < maxIndex; i++) {
      if (needleA.every(function (e, j) { return e === haystackA[i+j]; })) {
        found = true;
        break;
      }
    }

    return found;
  }

  function lengthImpl (str) {
    return Array.from(str).length;
  }

  function linesImpl (str) {
    // See http://www.unicode.org/reports/tr18/#RL1.6
    return str.split(/\r\n|[\n\v\f\r\u0085\u2028\u2029]/);
  }

  function normalizeImpl (str) {
    return str.normalize();
  }

  function normalizePrimeImpl (normalizationForm, str) {
    return str.normalize(normalizationForm);
  }

  function padEndPrimeImpl (targetLength, str) {
    return str.padEnd(targetLength);
  }

  function padStartPrimeImpl (targetLength, str) {
    return str.padStart(targetLength);
  }

  function repeatImpl (just, nothing, n, str) {
    var result;

    try {
      result = just(str.repeat(n));
    }
    catch (error) {
      result = nothing;
    }

    return result;
  }

  function startsWithImpl (searchString, s) {
    return s.startsWith(searchString);
  }

  function startsWithPrimeImpl (searchString, position, s) {
    return s.startsWith(searchString, position);
  }

  function stripCharsImpl (chars, s) {
    return s.replace(RegExp("[" + escapeRegexImpl(chars) + "]", "g"), "");
  }

  function stripDiacriticsImpl (str) {
    return str.normalize("NFD").replace(/[\u0300-\u036f]/g, "");
  }

  function toCharArrayImpl (str) {
    return Array.from(str);
  }

  function unsafeCodePointAtImpl (i, s) {
    var codePointArray = Array.from(s);
    var isWithinRange = i >= 0 && i < codePointArray.length;

    if (isWithinRange) {
      return codePointArray[i].codePointAt(0);
    }
    else {
      throw new Error("Data.String.Utils.unsafeCodePointAt: Invalid index");
    }
  }

  function unsafeCodePointAtPrimeImpl (i, s) {
    if (i >= 0 && i < s.length) {
      return s.codePointAt(i);
    }
    else {
      throw new Error("Data.String.Utils.unsafeCodePointAt': Invalid index");
    }
  }

  function unsafeRepeatImpl (n, str) {
    try {
      return str.repeat(n);
    }
    catch (error) {
      throw new Error("Data.String.Utils.unsafeRepeat: Invalid count");
    }
  }

  function wordsImpl (s) {
    // Split at every Unicode whitespace character (25 as of Unicode 12.1)
    return s.split(/[\u000a-\u000d\u0085\u2028\u2029\u0009\u0020\u00a0\u1680\u2000-\u200a\u202f\u205f\u3000]+/);
  }                                                         
  exports.endsWithImpl               = endsWithImpl;
  exports.startsWithImpl             = startsWithImpl;  
  exports.wordsImpl                  = wordsImpl;
})(PS["Data.String.Utils"] = PS["Data.String.Utils"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.String.Utils"] = $PS["Data.String.Utils"] || {};
  var exports = $PS["Data.String.Utils"];
  var $foreign = $PS["Data.String.Utils"];
  var words = function (s) {
      return $foreign.wordsImpl(s);
  };
  var startsWith = function (searchString) {
      return function (s) {
          return $foreign.startsWithImpl(searchString, s);
      };
  };
  var endsWith = function (searchString) {
      return function (s) {
          return $foreign.endsWithImpl(searchString, s);
      };
  };
  exports["endsWith"] = endsWith;
  exports["startsWith"] = startsWith;
  exports["words"] = words;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Time.Component"] = $PS["Data.Time.Component"] || {};
  var exports = $PS["Data.Time.Component"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Bounded = $PS["Data.Bounded"];
  var Data_Enum = $PS["Data.Enum"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var ordSecond = Data_Ord.ordInt;
  var ordMinute = Data_Ord.ordInt;
  var ordMillisecond = Data_Ord.ordInt;
  var ordHour = Data_Ord.ordInt;
  var boundedSecond = new Data_Bounded.Bounded(function () {
      return ordSecond;
  }, 0, 59);
  var boundedMinute = new Data_Bounded.Bounded(function () {
      return ordMinute;
  }, 0, 59);
  var boundedMillisecond = new Data_Bounded.Bounded(function () {
      return ordMillisecond;
  }, 0, 999);
  var boundedHour = new Data_Bounded.Bounded(function () {
      return ordHour;
  }, 0, 23);
  var boundedEnumSecond = new Data_Enum.BoundedEnum(function () {
      return boundedSecond;
  }, function () {
      return enumSecond;
  }, 60, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 59) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component (line 90, column 1 - line 95, column 26): " + [ n.constructor.name ]);
  });
  var enumSecond = new Data_Enum.Enum(function () {
      return ordSecond;
  }, (function () {
      var $28 = Data_Enum.toEnum(boundedEnumSecond);
      var $29 = Data_Enum.fromEnum(boundedEnumSecond);
      return function ($30) {
          return $28((function (v) {
              return v - 1 | 0;
          })($29($30)));
      };
  })(), (function () {
      var $31 = Data_Enum.toEnum(boundedEnumSecond);
      var $32 = Data_Enum.fromEnum(boundedEnumSecond);
      return function ($33) {
          return $31((function (v) {
              return v + 1 | 0;
          })($32($33)));
      };
  })());
  var boundedEnumMinute = new Data_Enum.BoundedEnum(function () {
      return boundedMinute;
  }, function () {
      return enumMinute;
  }, 60, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 59) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component (line 61, column 1 - line 66, column 26): " + [ n.constructor.name ]);
  });
  var enumMinute = new Data_Enum.Enum(function () {
      return ordMinute;
  }, (function () {
      var $34 = Data_Enum.toEnum(boundedEnumMinute);
      var $35 = Data_Enum.fromEnum(boundedEnumMinute);
      return function ($36) {
          return $34((function (v) {
              return v - 1 | 0;
          })($35($36)));
      };
  })(), (function () {
      var $37 = Data_Enum.toEnum(boundedEnumMinute);
      var $38 = Data_Enum.fromEnum(boundedEnumMinute);
      return function ($39) {
          return $37((function (v) {
              return v + 1 | 0;
          })($38($39)));
      };
  })());
  var boundedEnumHour = new Data_Enum.BoundedEnum(function () {
      return boundedHour;
  }, function () {
      return enumHour;
  }, 24, function (v) {
      return v;
  }, function (n) {
      if (n >= 0 && n <= 23) {
          return new Data_Maybe.Just(n);
      };
      if (Data_Boolean.otherwise) {
          return Data_Maybe.Nothing.value;
      };
      throw new Error("Failed pattern match at Data.Time.Component (line 32, column 1 - line 37, column 24): " + [ n.constructor.name ]);
  });
  var enumHour = new Data_Enum.Enum(function () {
      return ordHour;
  }, (function () {
      var $46 = Data_Enum.toEnum(boundedEnumHour);
      var $47 = Data_Enum.fromEnum(boundedEnumHour);
      return function ($48) {
          return $46((function (v) {
              return v - 1 | 0;
          })($47($48)));
      };
  })(), (function () {
      var $49 = Data_Enum.toEnum(boundedEnumHour);
      var $50 = Data_Enum.fromEnum(boundedEnumHour);
      return function ($51) {
          return $49((function (v) {
              return v + 1 | 0;
          })($50($51)));
      };
  })());
  exports["boundedEnumHour"] = boundedEnumHour;
  exports["boundedEnumMinute"] = boundedEnumMinute;
  exports["boundedEnumSecond"] = boundedEnumSecond;
  exports["boundedMillisecond"] = boundedMillisecond;
})(PS);
(function(exports) {
  'use strict';

  exports.prjImpl = function projImpl1 (n, t) {
    return t[n];
  };
})(PS["Data.Tuple.Native"] = PS["Data.Tuple.Native"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Typelevel.Num.Sets"] = $PS["Data.Typelevel.Num.Sets"] || {};
  var exports = $PS["Data.Typelevel.Num.Sets"];              
  var Nat = function (toInt) {
      this.toInt = toInt;
  };
  var toInt = function (dict) {
      return dict.toInt;
  }; 
  var natD1 = new Nat(function (v) {
      return 1;
  });
  var natD0 = new Nat(function (v) {
      return 0;
  });
  exports["toInt"] = toInt;
  exports["natD0"] = natD0;
  exports["natD1"] = natD1;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Tuple.Native"] = $PS["Data.Tuple.Native"] || {};
  var exports = $PS["Data.Tuple.Native"];
  var $foreign = $PS["Data.Tuple.Native"];
  var Data_Typelevel_Num_Sets = $PS["Data.Typelevel.Num.Sets"];
  var prj = function (dictTupleSize) {
      return function (dictLt) {
          return function (dictShowNat) {
              return function (dictListToRow) {
                  return function (dictCons) {
                      return function (dictNat) {
                          return function (n) {
                              return function (t) {
                                  return $foreign.prjImpl(Data_Typelevel_Num_Sets.toInt(dictNat)(n), t);
                              };
                          };
                      };
                  };
              };
          };
      };
  };
  exports["prj"] = prj;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Typelevel.Undefined"] = $PS["Data.Typelevel.Undefined"] || {};
  var exports = $PS["Data.Typelevel.Undefined"];
  var Data_Unit = $PS["Data.Unit"];                
  var $$undefined = Data_Unit.unit;
  exports["undefined"] = $$undefined;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Typelevel.Num.Reps"] = $PS["Data.Typelevel.Num.Reps"] || {};
  var exports = $PS["Data.Typelevel.Num.Reps"];
  var Data_Typelevel_Undefined = $PS["Data.Typelevel.Undefined"];
  var d1 = Data_Typelevel_Undefined["undefined"];
  var d0 = Data_Typelevel_Undefined["undefined"];
  exports["d0"] = d0;
  exports["d1"] = d1;
})(PS);
(function(exports) {
  "use strict";

  exports.from = function (val) {
      return val >>> 0;
  };

  exports.uintAdd = function (x) {
      return function (y) {
          return (x + y) >>> 0;
      };
  };

  exports.uintMul = function (x) {
      return function (y) {
          return (x * y) >>> 0;
      };
  };

  exports.uintSub = function (x) {
      return function (y) {
          return (x - y) >>> 0;
      };
  };

  exports.uintEq = function (x) {
      return function (y) {
          return x == y;
      };
  };

  exports.uintCmp = function (lt) {
      return function (eq) {
          return function (gt) {
              return function (x) {
                  return function (y) {
                      if (x < y) return lt;
                      if (x === y) return eq;
                      return gt;
                  };
              };
          };
      };
  };

  exports.shl = function (n1) {
      return function (n2) {
          return (n1 << n2) >>> 0;
      };
  };
})(PS["Data.UInt"] = PS["Data.UInt"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.UInt"] = $PS["Data.UInt"] || {};
  var exports = $PS["Data.UInt"];
  var $foreign = $PS["Data.UInt"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ordering = $PS["Data.Ordering"];
  var Data_Ring = $PS["Data.Ring"];
  var Data_Semiring = $PS["Data.Semiring"];
  var uintEqInstance = new Data_Eq.Eq($foreign.uintEq);
  var uintOrd = new Data_Ord.Ord(function () {
      return uintEqInstance;
  }, $foreign.uintCmp(Data_Ordering.LT.value)(Data_Ordering.EQ.value)(Data_Ordering.GT.value));
  var fromInt = $foreign.from;    
  var uintSemiring = new Data_Semiring.Semiring($foreign.uintAdd, $foreign.uintMul, fromInt(1), fromInt(0));
  var uintRing = new Data_Ring.Ring(function () {
      return uintSemiring;
  }, $foreign.uintSub);
  exports["fromInt"] = fromInt;
  exports["uintSemiring"] = uintSemiring;
  exports["uintRing"] = uintRing;
  exports["uintOrd"] = uintOrd;
  exports["shl"] = $foreign.shl;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Data.Validation.Semiring"] = $PS["Data.Validation.Semiring"] || {};
  var exports = $PS["Data.Validation.Semiring"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Either = $PS["Data.Either"];
  var Data_Semiring = $PS["Data.Semiring"];                      
  var V = function (x) {
      return x;
  };
  var validation = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof Data_Either.Left) {
                  return v(v2.value0);
              };
              if (v2 instanceof Data_Either.Right) {
                  return v1(v2.value0);
              };
              throw new Error("Failed pattern match at Data.Validation.Semiring (line 51, column 1 - line 51, column 84): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var invalid = function ($69) {
      return V(Data_Either.Left.create($69));
  };
  var functorV = Data_Either.functorEither;       
  var applyV = function (dictSemiring) {
      return new Control_Apply.Apply(function () {
          return functorV;
      }, function (v) {
          return function (v1) {
              if (v instanceof Data_Either.Left && v1 instanceof Data_Either.Left) {
                  return new Data_Either.Left(Data_Semiring.mul(dictSemiring)(v.value0)(v1.value0));
              };
              if (v instanceof Data_Either.Left) {
                  return new Data_Either.Left(v.value0);
              };
              if (v1 instanceof Data_Either.Left) {
                  return new Data_Either.Left(v1.value0);
              };
              if (v instanceof Data_Either.Right && v1 instanceof Data_Either.Right) {
                  return new Data_Either.Right(v.value0(v1.value0));
              };
              throw new Error("Failed pattern match at Data.Validation.Semiring (line 96, column 1 - line 100, column 54): " + [ v.constructor.name, v1.constructor.name ]);
          };
      });
  };
  var applicativeV = function (dictSemiring) {
      return new Control_Applicative.Applicative(function () {
          return applyV(dictSemiring);
      }, function ($78) {
          return V(Data_Either.Right.create($78));
      });
  };
  var altV = function (dictSemiring) {
      return new Control_Alt.Alt(function () {
          return functorV;
      }, function (v) {
          return function (v1) {
              if (v instanceof Data_Either.Left && v1 instanceof Data_Either.Left) {
                  return new Data_Either.Left(Data_Semiring.add(dictSemiring)(v.value0)(v1.value0));
              };
              if (v instanceof Data_Either.Left) {
                  return v1;
              };
              if (v instanceof Data_Either.Right) {
                  return new Data_Either.Right(v.value0);
              };
              throw new Error("Failed pattern match at Data.Validation.Semiring (line 111, column 1 - line 114, column 36): " + [ v.constructor.name, v1.constructor.name ]);
          };
      });
  };
  exports["validation"] = validation;
  exports["invalid"] = invalid;
  exports["applicativeV"] = applicativeV;
  exports["altV"] = altV;
})(PS);
(function(exports) {
  "use strict";

  exports.error = function (s) {
    return function () {
      console.error(s);
    };
  };
})(PS["Effect.Console"] = PS["Effect.Console"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Console"] = $PS["Effect.Console"] || {};
  var exports = $PS["Effect.Console"];
  var $foreign = $PS["Effect.Console"];
  exports["error"] = $foreign.error;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Class.Console"] = $PS["Effect.Class.Console"] || {};
  var exports = $PS["Effect.Class.Console"];
  var Effect_Class = $PS["Effect.Class"];
  var Effect_Console = $PS["Effect.Console"];
  var error = function (dictMonadEffect) {
      var $40 = Effect_Class.liftEffect(dictMonadEffect);
      return function ($41) {
          return $40(Effect_Console.error($41));
      };
  };
  exports["error"] = error;
})(PS);
(function(exports) {
  "use strict";

  exports.unsafePerformEffect = function (f) {
    return f();
  };
})(PS["Effect.Unsafe"] = PS["Effect.Unsafe"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Unsafe"] = $PS["Effect.Unsafe"] || {};
  var exports = $PS["Effect.Unsafe"];
  var $foreign = $PS["Effect.Unsafe"];
  exports["unsafePerformEffect"] = $foreign.unsafePerformEffect;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Exception.Unsafe"] = $PS["Effect.Exception.Unsafe"] || {};
  var exports = $PS["Effect.Exception.Unsafe"];
  var Effect_Exception = $PS["Effect.Exception"];
  var Effect_Unsafe = $PS["Effect.Unsafe"];                
  var unsafeThrowException = function ($0) {
      return Effect_Unsafe.unsafePerformEffect(Effect_Exception.throwException($0));
  };
  var unsafeThrow = function ($1) {
      return unsafeThrowException(Effect_Exception.error($1));
  };
  exports["unsafeThrow"] = unsafeThrow;
})(PS);
(function(exports) {
  "use strict";

  exports.now = function () {
    return Date.now();
  };
})(PS["Effect.Now"] = PS["Effect.Now"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Now"] = $PS["Effect.Now"] || {};
  var exports = $PS["Effect.Now"];
  var $foreign = $PS["Effect.Now"];
  exports["now"] = $foreign.now;
})(PS);
(function(exports) {
  "use strict";

  exports.new = function (val) {
    return function () {
      return { value: val };
    };
  };

  exports.read = function (ref) {
    return function () {
      return ref.value;
    };
  };

  exports.write = function (val) {
    return function (ref) {
      return function () {
        ref.value = val;
      };
    };
  };
})(PS["Effect.Ref"] = PS["Effect.Ref"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Ref"] = $PS["Effect.Ref"] || {};
  var exports = $PS["Effect.Ref"];
  var $foreign = $PS["Effect.Ref"];
  exports["new"] = $foreign["new"];
  exports["read"] = $foreign.read;
  exports["write"] = $foreign.write;
})(PS);
(function(exports) {
  /* no-redeclare global exports */
  "use strict";

  exports.setTimeout = function (ms) {
    return function (fn) {
      return function () {
        return setTimeout(fn, ms);
      };
    };
  };

  exports.clearTimeout = function (id) {
    return function () {
      clearTimeout(id);
    };
  };

  exports.setInterval = function (ms) {
    return function (fn) {
      return function () {
        return setInterval(fn, ms);
      };
    };
  };

  exports.clearInterval = function (id) {
    return function () {
      clearInterval(id);
    };
  };
})(PS["Effect.Timer"] = PS["Effect.Timer"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Effect.Timer"] = $PS["Effect.Timer"] || {};
  var exports = $PS["Effect.Timer"];
  var $foreign = $PS["Effect.Timer"];
  exports["setTimeout"] = $foreign.setTimeout;
  exports["clearTimeout"] = $foreign.clearTimeout;
  exports["setInterval"] = $foreign.setInterval;
  exports["clearInterval"] = $foreign.clearInterval;
})(PS);
(function(exports) {
  'use strict';
  exports._from = function(a) { return Array.from(a); };                           
  exports._unshift = function(i,a) { a.unshift(i); return a; };
})(PS["FFI.Simple.PseudoArray"] = PS["FFI.Simple.PseudoArray"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["FFI.Simple.PseudoArray"] = $PS["FFI.Simple.PseudoArray"] || {};
  var exports = $PS["FFI.Simple.PseudoArray"];
  var $foreign = $PS["FFI.Simple.PseudoArray"];
  var Data_Function_Uncurried = $PS["Data.Function.Uncurried"];      
  var unshift = Data_Function_Uncurried.runFn2($foreign["_unshift"]);
  var from = $foreign["_from"];
  exports["from"] = from;
  exports["unshift"] = unshift;
})(PS);
(function(exports) {
  "use strict";

  exports.unsafeReadPropImpl = function (f, s, key, value) {
    return value == null ? f : s(value[key]);
  };
})(PS["Foreign.Index"] = PS["Foreign.Index"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Foreign.Index"] = $PS["Foreign.Index"] || {};
  var exports = $PS["Foreign.Index"];
  var $foreign = $PS["Foreign.Index"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Foreign = $PS["Foreign"];
  var unsafeReadProp = function (dictMonad) {
      return function (k) {
          return function (value) {
              return $foreign.unsafeReadPropImpl(Foreign.fail(dictMonad)(new Foreign.TypeMismatch("object", Foreign.typeOf(value))), Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(dictMonad)), k, value);
          };
      };
  };
  var readProp = function (dictMonad) {
      return unsafeReadProp(dictMonad);
  };
  exports["readProp"] = readProp;
})(PS);
(function(exports) {
  'use strict';
  exports.react = require("react");
  exports.reactDOM = require('react-dom');
})(PS["Reactix.React"] = PS["Reactix.React"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Reactix.React"] = $PS["Reactix.React"] || {};
  var exports = $PS["Reactix.React"];
  var $foreign = $PS["Reactix.React"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad = $PS["Control.Monad"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Monoid = $PS["Data.Monoid"];
  var Data_Nullable = $PS["Data.Nullable"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var Effect_Uncurried = $PS["Effect.Uncurried"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var FFI_Simple_Objects = $PS["FFI.Simple.Objects"];
  var FFI_Simple_PseudoArray = $PS["FFI.Simple.PseudoArray"];                
  var MonadDelay = function (Monad0) {
      this.Monad0 = Monad0;
  };
  var Hooks = function (x) {
      return x;
  };
  var IsComponent = function (createElement) {
      this.createElement = createElement;
  };
  var Component = function (x) {
      return x;
  };
  var unsafeHooksEffect = Hooks;
  var setRef = function (r) {
      return function (v) {
          return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v1) {
              return Control_Apply.applySecond(Effect.applyEffect)(Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Objects["setProperty'"](r)("current")(v)))(Control_Applicative.pure(Effect.applicativeEffect)(Data_Unit.unit));
          });
      };
  };
  var runHooks = function (v) {
      return v;
  };
  var readRef = function (r) {
      return FFI_Simple_Objects["getProperty'"](r)("current");
  };
  var readRefM = function (dictMonadDelay) {
      return function (r) {
          return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(dictMonadDelay.Monad0()))(r)((function () {
              var $17 = Control_Applicative.pure((dictMonadDelay.Monad0()).Applicative0());
              return function ($18) {
                  return $17(readRef($18));
              };
          })());
      };
  };
  var readNullableRef = function (r) {
      return Data_Nullable.toMaybe(FFI_Simple_Objects["getProperty'"](r)("current"));
  };
  var rawCreateElement = function (c) {
      return function (p) {
          return function (cs) {
              var args = FFI_Simple_PseudoArray.unshift(c)(FFI_Simple_PseudoArray.unshift(p)(cs));
              return FFI_Simple_Functions["applyMethod'"]($foreign.react)("createElement")(args);
          };
      };
  };
  var named = Data_Function.flip(FFI_Simple_Objects.defineProperty("name"));
  var monadDelayEffect = new MonadDelay(function () {
      return Effect.monadEffect;
  });
  var memoIsComponent = new IsComponent(rawCreateElement);
  var memo$prime = function (c) {
      return FFI_Simple_Functions["applyMethod'"]($foreign.react)("memo")([ c ]);
  };
  var functorHooks = new Data_Functor.Functor(function (f) {
      return function (v) {
          return Data_Functor.map(Effect.functorEffect)(f)(v);
      };
  });
  var fragment = function (es) {
      return rawCreateElement(FFI_Simple_Objects["getProperty'"]($foreign.react)("Fragment"))({})(es);
  };
  var semigroupElement = new Data_Semigroup.Semigroup(function (a) {
      return function (b) {
          return fragment([ a, b ]);
      };
  });
  var monoidElement = new Data_Monoid.Monoid(function () {
      return semigroupElement;
  }, fragment([  ]));
  var createPortal = function (es) {
      return function (e) {
          return FFI_Simple_Functions["applyMethod'"]($foreign.reactDOM)("createPortal")(FFI_Simple_Functions.args2(es)(e));
      };
  };
  var createElement = function (dict) {
      return dict.createElement;
  };
  var createDOMElement = rawCreateElement;
  var componentIsComponent = new IsComponent(rawCreateElement);
  var children = function (a) {
      return FFI_Simple_Functions["applyMethod'"](FFI_Simple_Objects["getProperty'"]($foreign.react)("Children"))("toArray")([ FFI_Simple_Objects["getProperty'"](a)("children") ]);
  };
  var hooksComponent = function (name) {
      return function (c) {
          var c$prime = function (props) {
              return runHooks(c(props)(children(props)));
          };
          return Component(named(name)(Effect_Uncurried.mkEffectFn1(c$prime)));
      };
  };
  var hooksComponentWithModule = function (module$prime) {
      return function (name) {
          return function (c) {
              return hooksComponent(module$prime + ("." + name))(c);
          };
      };
  };
  var applyHooks = new Control_Apply.Apply(function () {
      return functorHooks;
  }, function (v) {
      return function (v1) {
          return Control_Apply.apply(Effect.applyEffect)(v)(v1);
      };
  });
  var bindHooks = new Control_Bind.Bind(function () {
      return applyHooks;
  }, function (v) {
      return function (f) {
          return function __do() {
              var $21 = v();
              return runHooks(f($21))();
          };
      };
  });
  var applicativeHooks = new Control_Applicative.Applicative(function () {
      return applyHooks;
  }, (function () {
      var $22 = Control_Applicative.pure(Effect.applicativeEffect);
      return function ($23) {
          return Hooks($22($23));
      };
  })());
  var monadHooks = new Control_Monad.Monad(function () {
      return applicativeHooks;
  }, function () {
      return bindHooks;
  });
  var monadDelayHooks = new MonadDelay(function () {
      return monadHooks;
  });
  exports["unsafeHooksEffect"] = unsafeHooksEffect;
  exports["runHooks"] = runHooks;
  exports["createPortal"] = createPortal;
  exports["createElement"] = createElement;
  exports["createDOMElement"] = createDOMElement;
  exports["rawCreateElement"] = rawCreateElement;
  exports["hooksComponent"] = hooksComponent;
  exports["hooksComponentWithModule"] = hooksComponentWithModule;
  exports["fragment"] = fragment;
  exports["readRef"] = readRef;
  exports["readRefM"] = readRefM;
  exports["readNullableRef"] = readNullableRef;
  exports["setRef"] = setRef;
  exports["memo'"] = memo$prime;
  exports["functorHooks"] = functorHooks;
  exports["applyHooks"] = applyHooks;
  exports["applicativeHooks"] = applicativeHooks;
  exports["bindHooks"] = bindHooks;
  exports["monadDelayEffect"] = monadDelayEffect;
  exports["monadDelayHooks"] = monadDelayHooks;
  exports["componentIsComponent"] = componentIsComponent;
  exports["memoIsComponent"] = memoIsComponent;
  exports["monoidElement"] = monoidElement;
  exports["react"] = $foreign.react;
  exports["reactDOM"] = $foreign.reactDOM;
})(PS);
(function(exports) {
  'use strict';
  exports._tuple = function tuple(ctor, v) { return ctor(v[0])(v[1]); };
})(PS["Reactix.Utils"] = PS["Reactix.Utils"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Reactix.Utils"] = $PS["Reactix.Utils"] || {};
  var exports = $PS["Reactix.Utils"];
  var $foreign = $PS["Reactix.Utils"];
  var Data_Function_Uncurried = $PS["Data.Function.Uncurried"];
  var Data_String_CodePoints = $PS["Data.String.CodePoints"];
  var Data_String_Common = $PS["Data.String.Common"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var Effect_Uncurried = $PS["Effect.Uncurried"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var Reactix_React = $PS["Reactix.React"];                
  var ucFirst = (function () {
      var help = function (v) {
          return Data_String_Common.toUpper(v.before) + v.after;
      };
      var $8 = Data_String_CodePoints.splitAt(1);
      return function ($9) {
          return help($8($9));
      };
  })();
  var tuple = Data_Function_Uncurried.runFn2($foreign["_tuple"])(Data_Tuple.Tuple.create);
  var hook = function (f) {
      return Reactix_React.unsafeHooksEffect(FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(f));
  };
  var currySecond = function (v) {
      return new Data_Tuple.Tuple(v.value0, Effect_Uncurried.runEffectFn1(v.value1));
  };
  exports["tuple"] = tuple;
  exports["currySecond"] = currySecond;
  exports["hook"] = hook;
  exports["ucFirst"] = ucFirst;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Reactix.DOM.HTML"] = $PS["Reactix.DOM.HTML"] || {};
  var exports = $PS["Reactix.DOM.HTML"];
  var Control_Category = $PS["Control.Category"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Effect_Uncurried = $PS["Effect.Uncurried"];
  var FFI_Simple_Objects = $PS["FFI.Simple.Objects"];
  var Reactix_React = $PS["Reactix.React"];
  var Reactix_Utils = $PS["Reactix.Utils"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];                
  var text = Unsafe_Coerce.unsafeCoerce;
  var mapCopyAll = function (xf) {
      return function (yf) {
          return function (dest) {
              return function (src) {
                  var f = function (dest$prime) {
                      return function (k) {
                          return FFI_Simple_Objects["setProperty'"](dest$prime)(xf(k))(yf(FFI_Simple_Objects["getProperty'"](src)(k)));
                      };
                  };
                  return Data_Foldable.foldl(Data_Foldable.foldableArray)(f)(dest)(FFI_Simple_Objects.keys(src));
              };
          };
      };
  };
  var prefixCopyAll = function (pre$prime) {
      return mapCopyAll(function (v) {
          return pre$prime + v;
      })(Control_Category.identity(Control_Category.categoryFn));
  };
  var xformEventProps = function (props) {
      var eventPropName = function (other) {
          return "on" + Reactix_Utils.ucFirst(other);
      };
      var help = mapCopyAll(eventPropName)(Effect_Uncurried.mkEffectFn1)(props);
      return Data_Maybe.maybe(props)(help)(FFI_Simple_Objects["maybeGetProperty'"](props)("on"));
  };
  var magicPrefixProp = function (prop) {
      return function (pre$prime) {
          return function (props) {
              var help = function (val) {
                  return FFI_Simple_Objects["removeProperty'"](prefixCopyAll(pre$prime)(props)(val))(prop);
              };
              return Data_Maybe.maybe(props)(help)(FFI_Simple_Objects["maybeGetProperty'"](props)(prop));
          };
      };
  };
  var magicProps = (function () {
      var xformDataProps = magicPrefixProp("data")("data-");
      var xformAriaProps = magicPrefixProp("aria")("aria-");
      return function ($1) {
          return xformAriaProps(xformDataProps(xformEventProps($1)));
      };
  })();
  var createDOM = function (e) {
      return function (props) {
          return Reactix_React.createDOMElement(e)(magicProps(props));
      };
  };
  var createLeafDOM = function (e) {
      return function (props) {
          return createDOM(e)(props)([  ]);
      };
  };                                 
  var hr = createLeafDOM("hr");
  var img = createLeafDOM("img");
  var input = createLeafDOM("input");
  var div = createDOM("div");      
  var footer = createDOM("footer");
  var form = createDOM("form");
  var h1 = createDOM("h1");
  var h2 = createDOM("h2");
  var h3 = createDOM("h3");
  var h4 = createDOM("h4");
  var h5 = createDOM("h5");
  var h6 = createDOM("h6");        
  var i = createDOM("i");
  var iframe = createDOM("iframe");
  var label = createDOM("label");  
  var li = createDOM("li");      
  var nav = createDOM("nav");          
  var option = createDOM("option");
  var p = createDOM("p");            
  var pre = createDOM("pre");        
  var span = createDOM("span");
  var table = createDOM("table");
  var tbody = createDOM("tbody");
  var td = createDOM("td");            
  var textarea = createDOM("textarea");
  var th = createDOM("th");
  var thead = createDOM("thead");
  var tr = createDOM("tr");
  var u = createDOM("u");
  var ul = createDOM("ul");    
  var video = createDOM("video");  
  var button = createDOM("button");
  var br = createLeafDOM("br");
  var b = createDOM("b");      
  var a = createDOM("a");
  exports["createDOM"] = createDOM;
  exports["text"] = text;
  exports["a"] = a;
  exports["b"] = b;
  exports["br"] = br;
  exports["button"] = button;
  exports["div"] = div;
  exports["footer"] = footer;
  exports["form"] = form;
  exports["h1"] = h1;
  exports["h2"] = h2;
  exports["h3"] = h3;
  exports["h4"] = h4;
  exports["h5"] = h5;
  exports["h6"] = h6;
  exports["hr"] = hr;
  exports["i"] = i;
  exports["iframe"] = iframe;
  exports["img"] = img;
  exports["input"] = input;
  exports["label"] = label;
  exports["li"] = li;
  exports["nav"] = nav;
  exports["option"] = option;
  exports["p"] = p;
  exports["pre"] = pre;
  exports["span"] = span;
  exports["table"] = table;
  exports["tbody"] = tbody;
  exports["td"] = td;
  exports["textarea"] = textarea;
  exports["th"] = th;
  exports["thead"] = thead;
  exports["tr"] = tr;
  exports["u"] = u;
  exports["ul"] = ul;
  exports["video"] = video;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Reactix.SyntheticEvent"] = $PS["Reactix.SyntheticEvent"] || {};
  var exports = $PS["Reactix.SyntheticEvent"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var FFI_Simple_Objects = $PS["FFI.Simple.Objects"];
  var unsafeEventValue = function (e) {
      return e.target.value;
  };
  var unsafeEventTarget = function (e) {
      return e.target;
  };
  var target = function (dictIsEvent) {
      return function (e) {
          return FFI_Simple_Objects["getProperty'"](e)("target");
      };
  };
  var preventDefault = function (dictIsEvent) {
      return function (e) {
          return FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect))(Data_Unit.unit)(function (v) {
              return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](e)("preventDefault")([  ]));
          });
      };
  };
  var clientY = function (dictIsMouseEvent) {
      return function (e) {
          return FFI_Simple_Objects["getProperty'"](e)("clientY");
      };
  };
  var clientX = function (dictIsMouseEvent) {
      return function (e) {
          return FFI_Simple_Objects["getProperty'"](e)("clientX");
      };
  };
  exports["unsafeEventValue"] = unsafeEventValue;
  exports["unsafeEventTarget"] = unsafeEventTarget;
  exports["preventDefault"] = preventDefault;
  exports["clientX"] = clientX;
  exports["clientY"] = clientY;
})(PS);
(function(exports) {
  "use strict";

  exports.copyRecord = function(rec) {
    var copy = {};
    for (var key in rec) {
      if ({}.hasOwnProperty.call(rec, key)) {
        copy[key] = rec[key];
      }
    }
    return copy;
  };

  exports.unsafeInsert = function(l) {
    return function(a) {
      return function(rec) {
        rec[l] = a;
        return rec;
      };
    };
  };

  exports.unsafeModify = function(l) {
    return function (f) {
      return function(rec) {
        rec[l] = f(rec[l]);
        return rec;
      };
    };
  };

  exports.unsafeDelete = function(l) {
    return function(rec) {
      delete rec[l];
      return rec;
    };
  };
})(PS["Record.Builder"] = PS["Record.Builder"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Record.Builder"] = $PS["Record.Builder"] || {};
  var exports = $PS["Record.Builder"];
  var $foreign = $PS["Record.Builder"];
  var Control_Category = $PS["Control.Category"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Symbol = $PS["Data.Symbol"];
  var semigroupoidBuilder = Control_Semigroupoid.semigroupoidFn;
  var modify = function (dictCons) {
      return function (dictCons1) {
          return function (dictIsSymbol) {
              return function (l) {
                  return function (f) {
                      return function (r1) {
                          return $foreign.unsafeModify(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(f)(r1);
                      };
                  };
              };
          };
      };
  };
  var insert = function (dictCons) {
      return function (dictLacks) {
          return function (dictIsSymbol) {
              return function (l) {
                  return function (a) {
                      return function (r1) {
                          return $foreign.unsafeInsert(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(a)(r1);
                      };
                  };
              };
          };
      };
  };
  var $$delete = function (dictIsSymbol) {
      return function (dictLacks) {
          return function (dictCons) {
              return function (l) {
                  return function (r2) {
                      return $foreign.unsafeDelete(Data_Symbol.reflectSymbol(dictIsSymbol)(l))(r2);
                  };
              };
          };
      };
  };
  var categoryBuilder = Control_Category.categoryFn;
  var build = function (v) {
      return function (r1) {
          return v($foreign.copyRecord(r1));
      };
  };
  exports["build"] = build;
  exports["insert"] = insert;
  exports["modify"] = modify;
  exports["delete"] = $$delete;
  exports["semigroupoidBuilder"] = semigroupoidBuilder;
  exports["categoryBuilder"] = categoryBuilder;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Reactix.Hooks"] = $PS["Reactix.Hooks"] || {};
  var exports = $PS["Reactix.Hooks"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Function = $PS["Data.Function"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var FFI_Simple_Functions = $PS["FFI.Simple.Functions"];
  var FFI_Simple_PseudoArray = $PS["FFI.Simple.PseudoArray"];
  var Reactix_React = $PS["Reactix.React"];
  var Reactix_Utils = $PS["Reactix.Utils"];                
  var useRef = function (r) {
      return Reactix_Utils.hook(function (v) {
          return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](Reactix_React.react)("useRef")([ r ]));
      });
  };
  var useEffect = function (e) {
      return Reactix_Utils.hook(function (v) {
          return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](Reactix_React.react)("useEffect")([ e ]));
      });
  };
  var unsafeUseLayoutEffect = function (e) {
      return function (a) {
          return Reactix_Utils.hook(function (v) {
              return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](Reactix_React.react)("useLayoutEffect")(FFI_Simple_Functions.args2(e)(FFI_Simple_PseudoArray.from(a))));
          });
      };
  };
  var useLayoutEffect1 = function (a) {
      return function (e) {
          return unsafeUseLayoutEffect(e)([ a ]);
      };
  };
  var useLayoutEffect2 = function (a) {
      return function (b) {
          return function (e) {
              return unsafeUseLayoutEffect(e)(FFI_Simple_Functions.args2(a)(b));
          };
      };
  };
  var unsafeUseEffect = function (e) {
      return function (a) {
          return Reactix_Utils.hook(function (v) {
              return Control_Applicative.pure(Effect.applicativeEffect)(FFI_Simple_Functions["applyMethod'"](Reactix_React.react)("useEffect")(FFI_Simple_Functions.args2(e)(FFI_Simple_PseudoArray.from(a))));
          });
      };
  };
  var useEffect1 = function (a) {
      return function (e) {
          return unsafeUseEffect(e)([ a ]);
      };
  };
  var useEffect2 = function (a) {
      return function (b) {
          return function (e) {
              return unsafeUseEffect(e)(FFI_Simple_Functions.args2(a)(b));
          };
      };
  };
  var useEffectOnce = function (e) {
      return unsafeUseEffect(e)([  ]);
  };
  var nothing = Control_Applicative.pure(Effect.applicativeEffect)(Data_Unit.unit);
  var thenNothing = function (e) {
      return Control_Apply.applySecond(Effect.applyEffect)(e)(Control_Applicative.pure(Effect.applicativeEffect)(nothing));
  };
  var useEffect$prime = function ($19) {
      return useEffect(thenNothing($19));
  };
  var useEffect1$prime = function (a) {
      var $20 = useEffect1(a);
      return function ($21) {
          return $20(thenNothing($21));
      };
  };
  var useEffect2$prime = function (a) {
      return function (b) {
          var $22 = useEffect2(a)(b);
          return function ($23) {
              return $22(thenNothing($23));
          };
      };
  };
  var useEffectOnce$prime = function ($30) {
      return useEffectOnce(thenNothing($30));
  };
  var delayEffect = FFI_Simple_Functions.delay(FFI_Simple_Functions.delayMonad(Effect.monadEffect));
  var useState = function (s) {
      return Reactix_Utils.hook(function (v) {
          return Control_Applicative.pure(Effect.applicativeEffect)(Reactix_Utils.currySecond(Reactix_Utils.tuple(FFI_Simple_Functions["applyMethod'"](Reactix_React.react)("useState")([ delayEffect(Data_Unit.unit)((function () {
              var $42 = Control_Applicative.pure(Effect.applicativeEffect);
              return function ($43) {
                  return $42(s($43));
              };
          })()) ]))));
      });
  };
  var useState$prime = function ($44) {
      return useState(Data_Function["const"]($44));
  };
  exports["useState'"] = useState$prime;
  exports["useRef"] = useRef;
  exports["nothing"] = nothing;
  exports["useEffectOnce"] = useEffectOnce;
  exports["useEffectOnce'"] = useEffectOnce$prime;
  exports["useEffect'"] = useEffect$prime;
  exports["useEffect1'"] = useEffect1$prime;
  exports["useEffect2'"] = useEffect2$prime;
  exports["useLayoutEffect1"] = useLayoutEffect1;
  exports["useLayoutEffect2"] = useLayoutEffect2;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Toestand.Changes"] = $PS["Toestand.Changes"] || {};
  var exports = $PS["Toestand.Changes"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Data_Eq = $PS["Data.Eq"];
  var Effect = $PS["Effect"];                
  var unequal = function (dictEq) {
      return function (v) {
          return Control_Applicative.pure(Effect.applicativeEffect)(Data_Eq.notEq(dictEq)(v["new"])(v.old));
      };
  };
  var mapChange = function (f) {
      return function (v) {
          return {
              "new": f(v["new"]),
              old: f(v.old)
          };
      };
  };
  exports["mapChange"] = mapChange;
  exports["unequal"] = unequal;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Toestand.Classes"] = $PS["Toestand.Classes"] || {};
  var exports = $PS["Toestand.Classes"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Effect = $PS["Effect"];
  var Reactix_React = $PS["Reactix.React"];                
  var Write = function (write) {
      this.write = write;
  };
  var Read = function (listen, read) {
      this.listen = listen;
      this.read = read;
  };
  var ReadWrite = function (Read0, Write1) {
      this.Read0 = Read0;
      this.Write1 = Write1;
  };
  var write = function (dict) {
      return dict.write;
  };
  var write_ = function (dictWrite) {
      return function (v) {
          return function (box) {
              return Data_Functor["void"](Effect.functorEffect)(write(dictWrite)(v)(box));
          };
      };
  };
  var readWrite = function (dictRead) {
      return function (dictWrite) {
          return new ReadWrite(function () {
              return dictRead;
          }, function () {
              return dictWrite;
          });
      };
  };
  var read = function (dict) {
      return dict.read;
  };
  var modify = function (dictReadWrite) {
      return function (f) {
          return function (box) {
              return Control_Bind.bind(Effect.bindEffect)(Data_Functor.map(Effect.functorEffect)(f)(read(dictReadWrite.Read0())(Reactix_React.monadDelayEffect)(box)))(Data_Function.flip(write(dictReadWrite.Write1()))(box));
          };
      };
  };
  var modify_ = function (dictReadWrite) {
      return function (f) {
          return function (box) {
              return Data_Functor["void"](Effect.functorEffect)(modify(dictReadWrite)(f)(box));
          };
      };
  };
  var listen = function (dict) {
      return dict.listen;
  };
  exports["Read"] = Read;
  exports["Write"] = Write;
  exports["read"] = read;
  exports["listen"] = listen;
  exports["write"] = write;
  exports["write_"] = write_;
  exports["modify"] = modify;
  exports["modify_"] = modify_;
  exports["readWrite"] = readWrite;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Toestand.Watches"] = $PS["Toestand.Watches"] || {};
  var exports = $PS["Toestand.Watches"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Effect = $PS["Effect"];                
  var Watches = (function () {
      function Watches(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      Watches.create = function (value0) {
          return function (value1) {
              return new Watches(value0, value1);
          };
      };
      return Watches;
  })();
  var watches = new Watches(0, Data_Map_Internal.empty);
  var unlisten = function (v) {
      return function (id) {
          return new Watches(v.value0, Data_Map_Internal["delete"](Data_Ord.ordInt)(id)(v.value1));
      };
  };
  var notify = function (v) {
      return function (change) {
          return Control_Apply.applyFirst(Effect.applyEffect)(Control_Applicative.pure(Effect.applicativeEffect)(change))(Data_Foldable.traverse_(Effect.applicativeEffect)(Data_List_Types.foldableList)(function (v1) {
              return v1(change);
          })(Data_Map_Internal.values(v.value1)));
      };
  };
  var listen = function (f) {
      return function (v) {
          return Data_Tuple.Tuple.create(v.value0)(new Watches(v.value0 + 1 | 0, Data_Map_Internal.insert(Data_Ord.ordInt)(v.value0)(f)(v.value1)));
      };
  };
  exports["watches"] = watches;
  exports["listen"] = listen;
  exports["notify"] = notify;
  exports["unlisten"] = unlisten;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Toestand.Boxes"] = $PS["Toestand.Boxes"] || {};
  var exports = $PS["Toestand.Boxes"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Unit = $PS["Data.Unit"];
  var Effect = $PS["Effect"];
  var Reactix_Hooks = $PS["Reactix.Hooks"];
  var Reactix_React = $PS["Reactix.React"];
  var Toestand_Changes = $PS["Toestand.Changes"];
  var Toestand_Classes = $PS["Toestand.Classes"];
  var Toestand_Watches = $PS["Toestand.Watches"];                
  var R = (function () {
      function R(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      R.create = function (value0) {
          return function (value1) {
              return new R(value0, value1);
          };
      };
      return R;
  })();
  var Root = (function () {
      function Root(value0) {
          this.value0 = value0;
      };
      Root.create = function (value0) {
          return new Root(value0);
      };
      return Root;
  })();
  var Focus = (function () {
      function Focus(value0) {
          this.value0 = value0;
      };
      Focus.create = function (value0) {
          return new Focus(value0);
      };
      return Focus;
  })();
  var writeWith = function (dictReadWrite) {
      return function (w) {
          return function (v) {
              return function (c) {
                  return function (box) {
                      return Control_Apply.applyFirst(Effect.applyEffect)(Control_Applicative.pure(Effect.applicativeEffect)(v))(Toestand_Classes.write(dictReadWrite.Write1())(w(v)(c))(box));
                  };
              };
          };
      };
  };
  var writeBox = new Toestand_Classes.Write(function ($$new) {
      return function (v) {
          if (v instanceof Root) {
              var write$prime = function (v1) {
                  return Control_Apply.applyFirst(Effect.applyEffect)(Reactix_React.setRef(v.value0)(new R($$new, v1.value1)))(Toestand_Watches.notify(v1.value1)({
                      "new": $$new,
                      old: v1.value0
                  }));
              };
              return Control_Apply.applyFirst(Effect.applyEffect)(Control_Applicative.pure(Effect.applicativeEffect)($$new))(Control_Bind.bind(Effect.bindEffect)(Reactix_React.readRefM(Reactix_React.monadDelayEffect)(v.value0))(write$prime));
          };
          if (v instanceof Focus) {
              return function __do() {
                  var v1 = Reactix_React.readRefM(Reactix_React.monadDelayEffect)(v.value0)();
                  return v1.write($$new)();
              };
          };
          throw new Error("Failed pattern match at Toestand.Boxes (line 40, column 1 - line 43, column 67): " + [ $$new.constructor.name, v.constructor.name ]);
      };
  });
  var useLive = function (dictRead) {
      return function (shouldReload) {
          return function (box) {
              var uL = function (v) {
                  var listener = function (change) {
                      var maybeReload = function (check) {
                          return Control_Applicative.when(Effect.applicativeEffect)(check)(v.value1(function (v1) {
                              return v1 + 1 | 0;
                          }));
                      };
                      return Control_Bind.bind(Effect.bindEffect)(shouldReload(change))(maybeReload);
                  };
                  return Reactix_Hooks.useEffectOnce(Toestand_Classes.listen(dictRead)(listener)(box));
              };
              return Control_Apply.applyFirst(Reactix_React.applyHooks)(Toestand_Classes.read(dictRead)(Reactix_React.monadDelayHooks)(box))(Control_Bind.bind(Reactix_React.bindHooks)(Reactix_Hooks["useState'"](0))(uL));
          };
      };
  };
  var useBox = function (value) {
      return Data_Functor.map(Reactix_React.functorHooks)(Root.create)(Reactix_Hooks.useRef(new R(value, Toestand_Watches.watches)));
  };
  var readWith = function (dictRead) {
      return function (r) {
          return function (box) {
              return function (dictMonadDelay) {
                  return Data_Functor.map((((dictMonadDelay.Monad0()).Bind1()).Apply0()).Functor0())(r)(Toestand_Classes.read(dictRead)(dictMonadDelay)(box));
              };
          };
      };
  };
  var readRoot = function (v) {
      return v.value0;
  };
  var readFocus = function (v) {
      return function (dictMonadDelay) {
          return function (u) {
              return v.read(dictMonadDelay)(u);
          };
      };
  };
  var readBox = new Toestand_Classes.Read(function (l) {
      return function (v) {
          if (v instanceof Root) {
              var on = function (v1) {
                  var v2 = Toestand_Watches.listen(l)(v1.value1);
                  return Control_Apply.applyFirst(Effect.applyEffect)(Control_Applicative.pure(Effect.applicativeEffect)(v2.value0))(Reactix_React.setRef(v.value0)(new R(v1.value0, v2.value1)));
              };
              var off = function (id) {
                  var off$prime = function (v1) {
                      return Reactix_React.setRef(v.value0)(R.create(v1.value0)(Toestand_Watches.unlisten(v1.value1)(id)));
                  };
                  return Control_Bind.bind(Effect.bindEffect)(Reactix_React.readRefM(Reactix_React.monadDelayEffect)(v.value0))(off$prime);
              };
              return Data_Functor.map(Effect.functorEffect)(off)(Control_Bind.bind(Effect.bindEffect)(Reactix_React.readRefM(Reactix_React.monadDelayEffect)(v.value0))(on));
          };
          if (v instanceof Focus) {
              return function __do() {
                  var v1 = Reactix_React.readRefM(Reactix_React.monadDelayEffect)(v.value0)();
                  return v1.listen(l)();
              };
          };
          throw new Error("Failed pattern match at Toestand.Boxes (line 24, column 1 - line 32, column 65): " + [ l.constructor.name, v.constructor.name ]);
      };
  }, function (dictMonadDelay) {
      return function (v) {
          if (v instanceof Root) {
              return Data_Functor.map((((dictMonadDelay.Monad0()).Bind1()).Apply0()).Functor0())(readRoot)(Reactix_React.readRefM(dictMonadDelay)(v.value0));
          };
          if (v instanceof Focus) {
              return Control_Bind.bind((dictMonadDelay.Monad0()).Bind1())(Reactix_React.readRefM(dictMonadDelay)(v.value0))(function (f) {
                  return readFocus(f)(dictMonadDelay)(Data_Unit.unit);
              });
          };
          throw new Error("Failed pattern match at Toestand.Boxes (line 24, column 1 - line 32, column 65): " + [ v.constructor.name ]);
      };
  });
  var listenWith = function (dictRead) {
      return function (l) {
          return function (r) {
              return function (box) {
                  return Toestand_Classes.listen(dictRead)((function () {
                      var $58 = Toestand_Changes.mapChange(r);
                      return function ($59) {
                          return l($58($59));
                      };
                  })())(box);
              };
          };
      };
  };
  var useFocused = function (dictReadWrite) {
      return function (r) {
          return function (w) {
              return function (box) {
                  var write$prime = function (v) {
                      return function __do() {
                          var c = Toestand_Classes.read(dictReadWrite.Read0())(Reactix_React.monadDelayEffect)(box)();
                          return writeWith(dictReadWrite)(w)(v)(c)(box)();
                      };
                  };
                  var read$prime = function (dictMonadDelay) {
                      return function (v) {
                          return readWith(dictReadWrite.Read0())(r)(box)(dictMonadDelay);
                      };
                  };
                  var listen$prime = function (l) {
                      return listenWith(dictReadWrite.Read0())(l)(r)(box);
                  };
                  var f = {
                      read: function (dictMonadDelay) {
                          return read$prime(dictMonadDelay);
                      },
                      listen: listen$prime,
                      write: write$prime
                  };
                  return Data_Functor.map(Reactix_React.functorHooks)(Focus.create)(Reactix_Hooks.useRef(f));
              };
          };
      };
  };
  exports["useBox"] = useBox;
  exports["useFocused"] = useFocused;
  exports["useLive"] = useLive;
  exports["readBox"] = readBox;
  exports["writeBox"] = writeBox;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Formula"] = $PS["Formula"] || {};
  var exports = $PS["Formula"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Effect = $PS["Effect"];
  var Reactix_DOM_HTML = $PS["Reactix.DOM.HTML"];
  var Reactix_React = $PS["Reactix.React"];
  var Reactix_SyntheticEvent = $PS["Reactix.SyntheticEvent"];
  var Record_Builder = $PS["Record.Builder"];
  var Toestand_Boxes = $PS["Toestand.Boxes"];
  var Toestand_Changes = $PS["Toestand.Changes"];
  var Toestand_Classes = $PS["Toestand.Classes"];                
  var viewTextCpt = function (dictRead) {
      var cpt = function (v) {
          return function (v1) {
              return Data_Functor.map(Reactix_React.functorHooks)(Reactix_DOM_HTML.text)(Toestand_Boxes.useLive(dictRead)(Toestand_Changes.unequal(Data_Eq.eqString))(v.text));
          };
      };
      return Reactix_React["memo'"](Reactix_React.hooksComponent("viewText")(cpt));
  };
  var viewText = function (dictRead) {
      return function (props) {
          return Reactix_React.createElement(Reactix_React.memoIsComponent)(viewTextCpt(dictRead))(props)([  ]);
      };
  };
  var bindInputCpt = function (dictReadWrite) {
      return function (dictCons2) {
          return function (dictCons) {
              var cpt = function (v) {
                  return function (v1) {
                      var change = function (e) {
                          return Data_Functor["void"](Effect.functorEffect)(Toestand_Classes.write(dictReadWrite.Write1())(Reactix_SyntheticEvent.unsafeEventValue(e))(v.value));
                      };
                      var adjust = function (val) {
                          return Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder)(Record_Builder.insert()()(new Data_Symbol.IsSymbol(function () {
                              return "on";
                          }))(Data_Symbol.SProxy.value)({
                              change: change
                          }))(Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder)(Record_Builder.insert()()(new Data_Symbol.IsSymbol(function () {
                              return "defaultValue";
                          }))(Data_Symbol.SProxy.value)(val))(Record_Builder["delete"](new Data_Symbol.IsSymbol(function () {
                              return "value";
                          }))()()(Data_Symbol.SProxy.value)));
                      };
                      return Control_Bind.bind(Reactix_React.bindHooks)(Toestand_Boxes.useLive(dictReadWrite.Read0())(Toestand_Changes.unequal(Data_Eq.eqString))(v.value))(function (val) {
                          return Control_Applicative.pure(Reactix_React.applicativeHooks)(Reactix_DOM_HTML.input(Record_Builder.build(adjust(val))(v)));
                      });
                  };
              };
              return Reactix_React["memo'"](Reactix_React.hooksComponent("bindInput")(cpt));
          };
      };
  };
  var bindInput = function (dictReadWrite) {
      return function (dictCons2) {
          return function (dictCons) {
              return function (props) {
                  return Reactix_React.createElement(Reactix_React.memoIsComponent)(bindInputCpt(dictReadWrite)(dictCons2)(dictCons))(props)([  ]);
              };
          };
      };
  };
  var bindCheckboxCpt = function (dictReadWrite) {
      return function (dictCons3) {
          return function (dictCons) {
              var cpt = function (v) {
                  return function (v1) {
                      var adjust = function (val) {
                          var changeChecked = Record_Builder.modify()()(new Data_Symbol.IsSymbol(function () {
                              return "checked";
                          }))(Data_Symbol.SProxy.value)(Data_Function["const"](val));
                          var change = function (e) {
                              return Data_Functor["void"](Effect.functorEffect)(Toestand_Classes.write(dictReadWrite.Write1())(!val)(v.checked));
                          };
                          var addType = Record_Builder.insert()()(new Data_Symbol.IsSymbol(function () {
                              return "type";
                          }))(Data_Symbol.SProxy.value)("checkbox");
                          var addOn = Record_Builder.insert()()(new Data_Symbol.IsSymbol(function () {
                              return "on";
                          }))(Data_Symbol.SProxy.value)({
                              change: change
                          });
                          return Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder)(addType)(Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder)(addOn)(changeChecked));
                      };
                      return Control_Bind.bind(Reactix_React.bindHooks)(Toestand_Boxes.useLive(dictReadWrite.Read0())(Toestand_Changes.unequal(Data_Eq.eqBoolean))(v.checked))(function (val) {
                          return Control_Applicative.pure(Reactix_React.applicativeHooks)(Reactix_DOM_HTML.input(Record_Builder.build(adjust(val))(v)));
                      });
                  };
              };
              return Reactix_React["memo'"](Reactix_React.hooksComponent("bindCheckbox")(cpt));
          };
      };
  };
  var bindCheckbox = function (dictReadWrite) {
      return function (dictCons3) {
          return function (dictCons) {
              return function (props) {
                  return Reactix_React.createElement(Reactix_React.memoIsComponent)(bindCheckboxCpt(dictReadWrite)(dictCons3)(dictCons))(props)([  ]);
              };
          };
      };
  };
  exports["viewText"] = viewText;
  exports["bindInput"] = bindInput;
  exports["bindCheckbox"] = bindCheckbox;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Gargantext.Prelude"] = $PS["Gargantext.Prelude"] || {};
  var exports = $PS["Gargantext.Prelude"];     
  var Read = function (read) {
      this.read = read;
  };
  var read = function (dict) {
      return dict.read;
  };
  exports["Read"] = Read;
  exports["read"] = read;
})(PS);
(function(exports) {
  exports._parseJSON = JSON.parse;

  exports._undefined = undefined;

  exports._unsafeStringify = JSON.stringify;
})(PS["Simple.JSON"] = PS["Simple.JSON"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Simple.JSON"] = $PS["Simple.JSON"] || {};
  var exports = $PS["Simple.JSON"];
  var $foreign = $PS["Simple.JSON"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Apply = $PS["Control.Apply"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Category = $PS["Control.Category"];
  var Control_Monad_Except = $PS["Control.Monad.Except"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Control_Semigroupoid = $PS["Control.Semigroupoid"];
  var Data_Bifunctor = $PS["Data.Bifunctor"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Either = $PS["Data.Either"];
  var Data_Function = $PS["Data.Function"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Semigroup = $PS["Data.Semigroup"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Data_TraversableWithIndex = $PS["Data.TraversableWithIndex"];
  var Effect_Exception = $PS["Effect.Exception"];
  var Effect_Uncurried = $PS["Effect.Uncurried"];
  var Effect_Unsafe = $PS["Effect.Unsafe"];
  var Foreign = $PS["Foreign"];
  var Foreign_Index = $PS["Foreign.Index"];
  var Foreign_Object = $PS["Foreign.Object"];
  var Record = $PS["Record"];
  var Record_Builder = $PS["Record.Builder"];
  var Type_Proxy = $PS["Type.Proxy"];
  var WriteForeignFields = function (writeImplFields) {
      this.writeImplFields = writeImplFields;
  };
  var WriteForeign = function (writeImpl) {
      this.writeImpl = writeImpl;
  };
  var ReadForeignFields = function (getFields) {
      this.getFields = getFields;
  };
  var ReadForeign = function (readImpl) {
      this.readImpl = readImpl;
  };
  var writeImplFields = function (dict) {
      return dict.writeImplFields;
  };
  var writeImpl = function (dict) {
      return dict.writeImpl;
  };
  var writeJSON = function (dictWriteForeign) {
      var $87 = writeImpl(dictWriteForeign);
      return function ($88) {
          return $foreign["_unsafeStringify"]($87($88));
      };
  };
  var writeForeignString = new WriteForeign(Foreign.unsafeToForeign);
  var writeForeignObject = function (dictWriteForeign) {
      return new WriteForeign((function () {
          var $89 = Foreign_Object.mapWithKey(Data_Function["const"](writeImpl(dictWriteForeign)));
          return function ($90) {
              return Foreign.unsafeToForeign($89($90));
          };
      })());
  };
  var writeForeignNumber = new WriteForeign(Foreign.unsafeToForeign);
  var writeForeignInt = new WriteForeign(Foreign.unsafeToForeign);
  var writeForeignForeign = new WriteForeign(Control_Category.identity(Control_Category.categoryFn));
  var writeForeignBoolean = new WriteForeign(Foreign.unsafeToForeign);
  var writeForeignArray = function (dictWriteForeign) {
      return new WriteForeign(function (xs) {
          return Foreign.unsafeToForeign(Data_Functor.map(Data_Functor.functorArray)(writeImpl(dictWriteForeign))(xs));
      });
  };                                                 
  var $$undefined = $foreign["_undefined"];
  var writeForeignMaybe = function (dictWriteForeign) {
      return new WriteForeign(Data_Maybe.maybe($$undefined)(writeImpl(dictWriteForeign)));
  };
  var recordWriteForeign = function (dictRowToList) {
      return function (dictWriteForeignFields) {
          return new WriteForeign(function (rec) {
              var steps = writeImplFields(dictWriteForeignFields)(Type_Proxy["Proxy"].value)(rec);
              return Foreign.unsafeToForeign(Record_Builder.build(steps)({}));
          });
      };
  };
  var readString = new ReadForeign(Foreign.readString(Data_Identity.monadIdentity));
  var readNumber = new ReadForeign(Foreign.readNumber(Data_Identity.monadIdentity));
  var readInt = new ReadForeign(Foreign.readInt(Data_Identity.monadIdentity));
  var readImpl = function (dict) {
      return dict.readImpl;
  };
  var readMaybe = function (dictReadForeign) {
      return new ReadForeign((function () {
          var readNullOrUndefined = function (v) {
              return function (value) {
                  if (Foreign.isNull(value) || Foreign.isUndefined(value)) {
                      return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Maybe.Nothing.value);
                  };
                  return Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Data_Maybe.Just.create)(v(value));
              };
          };
          return readNullOrUndefined(readImpl(dictReadForeign));
      })());
  };
  var readObject = function (dictReadForeign) {
      return new ReadForeign((function () {
          var readObject$prime = function (value) {
              if (Foreign.tagOf(value) === "Object") {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Foreign.unsafeFromForeign(value));
              };
              if (Data_Boolean.otherwise) {
                  return Foreign.fail(Data_Identity.monadIdentity)(new Foreign.TypeMismatch("Object", Foreign.tagOf(value)));
              };
              throw new Error("Failed pattern match at Simple.JSON (line 197, column 7 - line 197, column 51): " + [ value.constructor.name ]);
          };
          return Control_Bind.composeKleisliFlipped(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))((function () {
              var $93 = Data_Traversable.sequence(Foreign_Object.traversableObject)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity));
              var $94 = Foreign_Object.mapWithKey(Data_Function["const"](readImpl(dictReadForeign)));
              return function ($95) {
                  return $93($94($95));
              };
          })())(readObject$prime);
      })());
  };                                                                                                                                      
  var readFieldsNil = new ReadForeignFields(function (v) {
      return function (v1) {
          return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Control_Category.identity(Record_Builder.categoryBuilder));
      };
  });                                                                           
  var readBoolean = new ReadForeign(Foreign.readBoolean(Data_Identity.monadIdentity));
  var readArray = function (dictReadForeign) {
      return new ReadForeign((function () {
          var readAtIdx = function (i) {
              return function (f) {
                  return Control_Monad_Except.withExcept(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Foreign.ErrorAtIndex.create(i)))(readImpl(dictReadForeign)(f));
              };
          };
          return Control_Bind.composeKleisliFlipped(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_TraversableWithIndex.traverseWithIndex(Data_TraversableWithIndex.traversableWithIndexArray)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(readAtIdx))(Foreign.readArray(Data_Identity.monadIdentity));
      })());
  };
  var parseJSON = (function () {
      var $102 = Data_Bifunctor.lmap(Data_Bifunctor.bifunctorEither)((function () {
          var $105 = Control_Applicative.pure(Data_List_Types.applicativeNonEmptyList);
          return function ($106) {
              return $105(Foreign.ForeignError.create(Effect_Exception.message($106)));
          };
      })());
      var $103 = Effect_Uncurried.runEffectFn1($foreign["_parseJSON"]);
      return function ($104) {
          return Control_Monad_Except_Trans.ExceptT(Data_Identity.Identity($102(Effect_Unsafe.unsafePerformEffect(Effect_Exception["try"]($103($104))))));
      };
  })();
  var readJSON = function (dictReadForeign) {
      var $107 = Control_Bind.composeKleisliFlipped(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(readImpl(dictReadForeign))(parseJSON);
      return function ($108) {
          return Control_Monad_Except.runExcept($107($108));
      };
  }; 
  var nilWriteForeignFields = new WriteForeignFields(function (v) {
      return function (v1) {
          return Control_Category.identity(Record_Builder.categoryBuilder);
      };
  });
  var getFields = function (dict) {
      return dict.getFields;
  };
  var readRecord = function (dictRowToList) {
      return function (dictReadForeignFields) {
          return new ReadForeign(function (o) {
              return Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Data_Function.flip(Record_Builder.build)({}))(getFields(dictReadForeignFields)(Type_Proxy["Proxy"].value)(o));
          });
      };
  };
  var consWriteForeignFields = function (dictIsSymbol) {
      return function (dictWriteForeign) {
          return function (dictWriteForeignFields) {
              return function (dictCons) {
                  return function (dictLacks) {
                      return function (dictCons1) {
                          return new WriteForeignFields(function (v) {
                              return function (rec) {
                                  var rest = writeImplFields(dictWriteForeignFields)(Type_Proxy["Proxy"].value)(rec);
                                  var value = writeImpl(dictWriteForeign)(Record.get(dictIsSymbol)()(Data_Symbol.SProxy.value)(rec));
                                  var result = Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder)(Record_Builder.insert()()(dictIsSymbol)(Data_Symbol.SProxy.value)(value))(rest);
                                  return result;
                              };
                          });
                      };
                  };
              };
          };
      };
  };
  var applyEither = function (dictSemigroup) {
      return function (v) {
          return function (v1) {
              if (v instanceof Data_Either.Left && v1 instanceof Data_Either.Right) {
                  return new Data_Either.Left(v.value0);
              };
              if (v instanceof Data_Either.Left && v1 instanceof Data_Either.Left) {
                  return new Data_Either.Left(Data_Semigroup.append(dictSemigroup)(v.value0)(v1.value0));
              };
              if (v instanceof Data_Either.Right && v1 instanceof Data_Either.Left) {
                  return new Data_Either.Left(v1.value0);
              };
              if (v instanceof Data_Either.Right && v1 instanceof Data_Either.Right) {
                  return new Data_Either.Right(v.value0(v1.value0));
              };
              throw new Error("Failed pattern match at Simple.JSON (line 241, column 1 - line 241, column 90): " + [ v.constructor.name, v1.constructor.name ]);
          };
      };
  };
  var exceptTApply = function (dictSemigroup) {
      return function (dictApplicative) {
          return function (fun) {
              return function (a) {
                  return Control_Monad_Except_Trans.ExceptT(Control_Apply.apply(dictApplicative.Apply0())(Data_Functor.map((dictApplicative.Apply0()).Functor0())(applyEither(dictSemigroup))(Control_Monad_Except_Trans.runExceptT(fun)))(Control_Monad_Except_Trans.runExceptT(a)));
              };
          };
      };
  };
  var readFieldsCons = function (dictIsSymbol) {
      return function (dictReadForeign) {
          return function (dictReadForeignFields) {
              return function (dictLacks) {
                  return function (dictCons) {
                      return new ReadForeignFields(function (v) {
                          return function (obj) {
                              var rest = getFields(dictReadForeignFields)(Type_Proxy["Proxy"].value)(obj);
                              var name = Data_Symbol.reflectSymbol(dictIsSymbol)(Data_Symbol.SProxy.value);
                              var withExcept$prime = Control_Monad_Except.withExcept(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Foreign.ErrorAtProperty.create(name)));
                              var first = Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(withExcept$prime(Control_Bind.bindFlipped(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(readImpl(dictReadForeign))(Foreign_Index.readProp(Data_Identity.monadIdentity)(name)(obj))))(function (value) {
                                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Record_Builder.insert()()(dictIsSymbol)(Data_Symbol.SProxy.value)(value));
                              });
                              return exceptTApply(Data_List_Types.semigroupNonEmptyList)(Data_Identity.applicativeIdentity)(Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Control_Semigroupoid.compose(Record_Builder.semigroupoidBuilder))(first))(rest);
                          };
                      });
                  };
              };
          };
      };
  };
  exports["readJSON"] = readJSON;
  exports["writeJSON"] = writeJSON;
  exports["ReadForeign"] = ReadForeign;
  exports["readImpl"] = readImpl;
  exports["WriteForeign"] = WriteForeign;
  exports["writeImpl"] = writeImpl;
  exports["readNumber"] = readNumber;
  exports["readInt"] = readInt;
  exports["readString"] = readString;
  exports["readBoolean"] = readBoolean;
  exports["readArray"] = readArray;
  exports["readMaybe"] = readMaybe;
  exports["readObject"] = readObject;
  exports["readRecord"] = readRecord;
  exports["readFieldsCons"] = readFieldsCons;
  exports["readFieldsNil"] = readFieldsNil;
  exports["writeForeignForeign"] = writeForeignForeign;
  exports["writeForeignString"] = writeForeignString;
  exports["writeForeignInt"] = writeForeignInt;
  exports["writeForeignNumber"] = writeForeignNumber;
  exports["writeForeignBoolean"] = writeForeignBoolean;
  exports["writeForeignArray"] = writeForeignArray;
  exports["writeForeignMaybe"] = writeForeignMaybe;
  exports["writeForeignObject"] = writeForeignObject;
  exports["recordWriteForeign"] = recordWriteForeign;
  exports["consWriteForeignFields"] = consWriteForeignFields;
  exports["nilWriteForeignFields"] = nilWriteForeignFields;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Simple.JSON.Generics.EnumSumRep"] = $PS["Simple.JSON.Generics.EnumSumRep"] || {};
  var exports = $PS["Simple.JSON.Generics.EnumSumRep"];
  var Control_Alt = $PS["Control.Alt"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Generic_Rep = $PS["Data.Generic.Rep"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Foreign = $PS["Foreign"];
  var Simple_JSON = $PS["Simple.JSON"];                
  var GenericEnumSumRep = function (genericEnumReadForeign) {
      this.genericEnumReadForeign = genericEnumReadForeign;
  };
  var genericEnumReadForeign = function (dict) {
      return dict.genericEnumReadForeign;
  };
  var sumEnumSumRep = function (dictGenericEnumSumRep) {
      return function (dictGenericEnumSumRep1) {
          return new GenericEnumSumRep(function (f) {
              return Control_Alt.alt(Control_Monad_Except_Trans.altExceptT(Data_List_Types.semigroupNonEmptyList)(Data_Identity.monadIdentity))(Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Data_Generic_Rep.Inl.create)(genericEnumReadForeign(dictGenericEnumSumRep)(f)))(Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Data_Generic_Rep.Inr.create)(genericEnumReadForeign(dictGenericEnumSumRep1)(f)));
          });
      };
  };
  var enumSumRep = function (dictGeneric) {
      return function (dictGenericEnumSumRep) {
          return function (f) {
              return Data_Functor.map(Control_Monad_Except_Trans.functorExceptT(Data_Identity.functorIdentity))(Data_Generic_Rep.to(dictGeneric))(genericEnumReadForeign(dictGenericEnumSumRep)(f));
          };
      };
  };
  var constructorEnumSumRep = function (dictIsSymbol) {
      return new GenericEnumSumRep(function (f) {
          var name = Data_Symbol.reflectSymbol(dictIsSymbol)(Data_Symbol.SProxy.value);
          return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Simple_JSON.readImpl(Simple_JSON.readString)(f))(function (s) {
              var $5 = s === name;
              if ($5) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Generic_Rep.NoArguments.value);
              };
              return Foreign.fail(Data_Identity.monadIdentity)(Foreign.ForeignError.create("Enum string " + (s + (" did not match expected string " + name))));
          });
      });
  };
  exports["enumSumRep"] = enumSumRep;
  exports["sumEnumSumRep"] = sumEnumSumRep;
  exports["constructorEnumSumRep"] = constructorEnumSumRep;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Gargantext.Types"] = $PS["Gargantext.Types"] || {};
  var exports = $PS["Gargantext.Types"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Array = $PS["Data.Array"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Eq_Generic = $PS["Data.Eq.Generic"];
  var Data_Generic_Rep = $PS["Data.Generic.Rep"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_Int = $PS["Data.Int"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Ord_Generic = $PS["Data.Ord.Generic"];
  var Data_Show = $PS["Data.Show"];
  var Data_Show_Generic = $PS["Data.Show.Generic"];
  var Data_String_Common = $PS["Data.String.Common"];
  var Data_Symbol = $PS["Data.Symbol"];
  var Foreign = $PS["Foreign"];
  var Gargantext_Prelude = $PS["Gargantext.Prelude"];
  var Reactix_React = $PS["Reactix.React"];
  var Simple_JSON = $PS["Simple.JSON"];
  var Simple_JSON_Generics_EnumSumRep = $PS["Simple.JSON.Generics.EnumSumRep"];
  var MonoTerm = (function () {
      function MonoTerm() {

      };
      MonoTerm.value = new MonoTerm();
      return MonoTerm;
  })();
  var MultiTerm = (function () {
      function MultiTerm() {

      };
      MultiTerm.value = new MultiTerm();
      return MultiTerm;
  })();
  var MapTerm = (function () {
      function MapTerm() {

      };
      MapTerm.value = new MapTerm();
      return MapTerm;
  })();
  var StopTerm = (function () {
      function StopTerm() {

      };
      StopTerm.value = new StopTerm();
      return StopTerm;
  })();
  var CandidateTerm = (function () {
      function CandidateTerm() {

      };
      CandidateTerm.value = new CandidateTerm();
      return CandidateTerm;
  })();
  var TabDocs = (function () {
      function TabDocs() {

      };
      TabDocs.value = new TabDocs();
      return TabDocs;
  })();
  var TabNgramType = (function () {
      function TabNgramType(value0) {
          this.value0 = value0;
      };
      TabNgramType.create = function (value0) {
          return new TabNgramType(value0);
      };
      return TabNgramType;
  })();
  var TabTrash = (function () {
      function TabTrash() {

      };
      TabTrash.value = new TabTrash();
      return TabTrash;
  })();
  var TabMoreLikeFav = (function () {
      function TabMoreLikeFav() {

      };
      TabMoreLikeFav.value = new TabMoreLikeFav();
      return TabMoreLikeFav;
  })();
  var TabMoreLikeTrash = (function () {
      function TabMoreLikeTrash() {

      };
      TabMoreLikeTrash.value = new TabMoreLikeTrash();
      return TabMoreLikeTrash;
  })();
  var InitialClosed = (function () {
      function InitialClosed() {

      };
      InitialClosed.value = new InitialClosed();
      return InitialClosed;
  })();
  var Opened = (function () {
      function Opened() {

      };
      Opened.value = new Opened();
      return Opened;
  })();
  var Closed = (function () {
      function Closed() {

      };
      Closed.value = new Closed();
      return Closed;
  })();
  var SessionId = function (x) {
      return x;
  };
  var Occurrences = (function () {
      function Occurrences() {

      };
      Occurrences.value = new Occurrences();
      return Occurrences;
  })();
  var PTabPatents = (function () {
      function PTabPatents() {

      };
      PTabPatents.value = new PTabPatents();
      return PTabPatents;
  })();
  var PTabBooks = (function () {
      function PTabBooks() {

      };
      PTabBooks.value = new PTabBooks();
      return PTabBooks;
  })();
  var PTabCommunication = (function () {
      function PTabCommunication() {

      };
      PTabCommunication.value = new PTabCommunication();
      return PTabCommunication;
  })();
  var DateAsc = (function () {
      function DateAsc() {

      };
      DateAsc.value = new DateAsc();
      return DateAsc;
  })();
  var DateDesc = (function () {
      function DateDesc() {

      };
      DateDesc.value = new DateDesc();
      return DateDesc;
  })();
  var TitleAsc = (function () {
      function TitleAsc() {

      };
      TitleAsc.value = new TitleAsc();
      return TitleAsc;
  })();
  var TitleDesc = (function () {
      function TitleDesc() {

      };
      TitleDesc.value = new TitleDesc();
      return TitleDesc;
  })();
  var ScoreAsc = (function () {
      function ScoreAsc() {

      };
      ScoreAsc.value = new ScoreAsc();
      return ScoreAsc;
  })();
  var ScoreDesc = (function () {
      function ScoreDesc() {

      };
      ScoreDesc.value = new ScoreDesc();
      return ScoreDesc;
  })();
  var TermAsc = (function () {
      function TermAsc() {

      };
      TermAsc.value = new TermAsc();
      return TermAsc;
  })();
  var TermDesc = (function () {
      function TermDesc() {

      };
      TermDesc.value = new TermDesc();
      return TermDesc;
  })();
  var SourceAsc = (function () {
      function SourceAsc() {

      };
      SourceAsc.value = new SourceAsc();
      return SourceAsc;
  })();
  var SourceDesc = (function () {
      function SourceDesc() {

      };
      SourceDesc.value = new SourceDesc();
      return SourceDesc;
  })();             
  var Annuaire = (function () {
      function Annuaire() {

      };
      Annuaire.value = new Annuaire();
      return Annuaire;
  })();
  var Corpus = (function () {
      function Corpus() {

      };
      Corpus.value = new Corpus();
      return Corpus;
  })();
  var Dashboard = (function () {
      function Dashboard() {

      };
      Dashboard.value = new Dashboard();
      return Dashboard;
  })();
  var $$Error = (function () {
      function $$Error() {

      };
      $$Error.value = new $$Error();
      return $$Error;
  })();
  var Folder = (function () {
      function Folder() {

      };
      Folder.value = new Folder();
      return Folder;
  })();
  var FolderPrivate = (function () {
      function FolderPrivate() {

      };
      FolderPrivate.value = new FolderPrivate();
      return FolderPrivate;
  })();
  var FolderPublic = (function () {
      function FolderPublic() {

      };
      FolderPublic.value = new FolderPublic();
      return FolderPublic;
  })();
  var FolderShared = (function () {
      function FolderShared() {

      };
      FolderShared.value = new FolderShared();
      return FolderShared;
  })();
  var Graph = (function () {
      function Graph() {

      };
      Graph.value = new Graph();
      return Graph;
  })();
  var Individu = (function () {
      function Individu() {

      };
      Individu.value = new Individu();
      return Individu;
  })();
  var Node = (function () {
      function Node() {

      };
      Node.value = new Node();
      return Node;
  })();
  var NodeContact = (function () {
      function NodeContact() {

      };
      NodeContact.value = new NodeContact();
      return NodeContact;
  })();
  var NodeList = (function () {
      function NodeList() {

      };
      NodeList.value = new NodeList();
      return NodeList;
  })();
  var NodeUser = (function () {
      function NodeUser() {

      };
      NodeUser.value = new NodeUser();
      return NodeUser;
  })();
  var Nodes = (function () {
      function Nodes() {

      };
      Nodes.value = new Nodes();
      return Nodes;
  })();
  var Phylo = (function () {
      function Phylo() {

      };
      Phylo.value = new Phylo();
      return Phylo;
  })();
  var Team = (function () {
      function Team() {

      };
      Team.value = new Team();
      return Team;
  })();
  var Texts = (function () {
      function Texts() {

      };
      Texts.value = new Texts();
      return Texts;
  })();
  var Tree = (function () {
      function Tree() {

      };
      Tree.value = new Tree();
      return Tree;
  })();
  var Url_Document = (function () {
      function Url_Document() {

      };
      Url_Document.value = new Url_Document();
      return Url_Document;
  })();
  var NodeFile = (function () {
      function NodeFile() {

      };
      NodeFile.value = new NodeFile();
      return NodeFile;
  })();
  var NodeFrameCalc = (function () {
      function NodeFrameCalc() {

      };
      NodeFrameCalc.value = new NodeFrameCalc();
      return NodeFrameCalc;
  })();
  var NodeFrameNotebook = (function () {
      function NodeFrameNotebook() {

      };
      NodeFrameNotebook.value = new NodeFrameNotebook();
      return NodeFrameNotebook;
  })();
  var NodeFrameWrite = (function () {
      function NodeFrameWrite() {

      };
      NodeFrameWrite.value = new NodeFrameWrite();
      return NodeFrameWrite;
  })();
  var NodeFrameVisio = (function () {
      function NodeFrameVisio() {

      };
      NodeFrameVisio.value = new NodeFrameVisio();
      return NodeFrameVisio;
  })();
  var NodePublic = (function () {
      function NodePublic(value0) {
          this.value0 = value0;
      };
      NodePublic.create = function (value0) {
          return new NodePublic(value0);
      };
      return NodePublic;
  })();
  var Authors = (function () {
      function Authors() {

      };
      Authors.value = new Authors();
      return Authors;
  })();
  var Sources = (function () {
      function Sources() {

      };
      Sources.value = new Sources();
      return Sources;
  })();
  var Institutes = (function () {
      function Institutes() {

      };
      Institutes.value = new Institutes();
      return Institutes;
  })();
  var Terms = (function () {
      function Terms() {

      };
      Terms.value = new Terms();
      return Terms;
  })();
  var NodePath = (function () {
      function NodePath(value0, value1, value2) {
          this.value0 = value0;
          this.value1 = value1;
          this.value2 = value2;
      };
      NodePath.create = function (value0) {
          return function (value1) {
              return function (value2) {
                  return new NodePath(value0, value1, value2);
              };
          };
      };
      return NodePath;
  })();
  var LeftHanded = (function () {
      function LeftHanded() {

      };
      LeftHanded.value = new LeftHanded();
      return LeftHanded;
  })();
  var RightHanded = (function () {
      function RightHanded() {

      };
      RightHanded.value = new RightHanded();
      return RightHanded;
  })();
  var Histo = (function () {
      function Histo() {

      };
      Histo.value = new Histo();
      return Histo;
  })();
  var Scatter = (function () {
      function Scatter() {

      };
      Scatter.value = new Scatter();
      return Scatter;
  })();
  var ChartPie = (function () {
      function ChartPie() {

      };
      ChartPie.value = new ChartPie();
      return ChartPie;
  })();
  var ChartBar = (function () {
      function ChartBar() {

      };
      ChartBar.value = new ChartBar();
      return ChartBar;
  })();
  var ChartTree = (function () {
      function ChartTree() {

      };
      ChartTree.value = new ChartTree();
      return ChartTree;
  })();
  var CTabTerms = (function () {
      function CTabTerms() {

      };
      CTabTerms.value = new CTabTerms();
      return CTabTerms;
  })();
  var CTabSources = (function () {
      function CTabSources() {

      };
      CTabSources.value = new CTabSources();
      return CTabSources;
  })();
  var CTabAuthors = (function () {
      function CTabAuthors() {

      };
      CTabAuthors.value = new CTabAuthors();
      return CTabAuthors;
  })();
  var CTabInstitutes = (function () {
      function CTabInstitutes() {

      };
      CTabInstitutes.value = new CTabInstitutes();
      return CTabInstitutes;
  })();
  var TabCorpus = (function () {
      function TabCorpus(value0) {
          this.value0 = value0;
      };
      TabCorpus.create = function (value0) {
          return new TabCorpus(value0);
      };
      return TabCorpus;
  })();
  var TabPairing = (function () {
      function TabPairing(value0) {
          this.value0 = value0;
      };
      TabPairing.create = function (value0) {
          return new TabPairing(value0);
      };
      return TabPairing;
  })();
  var TabDocument = (function () {
      function TabDocument(value0) {
          this.value0 = value0;
      };
      TabDocument.create = function (value0) {
          return new TabDocument(value0);
      };
      return TabDocument;
  })();
  var AddNode = (function () {
      function AddNode() {

      };
      AddNode.value = new AddNode();
      return AddNode;
  })();
  var Form = (function () {
      function Form() {

      };
      Form.value = new Form();
      return Form;
  })();
  var GraphRecompute = (function () {
      function GraphRecompute() {

      };
      GraphRecompute.value = new GraphRecompute();
      return GraphRecompute;
  })();
  var Query = (function () {
      function Query() {

      };
      Query.value = new Query();
      return Query;
  })();
  var UpdateNgramsCharts = (function () {
      function UpdateNgramsCharts() {

      };
      UpdateNgramsCharts.value = new UpdateNgramsCharts();
      return UpdateNgramsCharts;
  })();
  var UpdateNode = (function () {
      function UpdateNode() {

      };
      UpdateNode.value = new UpdateNode();
      return UpdateNode;
  })();
  var UploadFile = (function () {
      function UploadFile() {

      };
      UploadFile.value = new UploadFile();
      return UploadFile;
  })();
  var IsRunning = (function () {
      function IsRunning() {

      };
      IsRunning.value = new IsRunning();
      return IsRunning;
  })();
  var IsPending = (function () {
      function IsPending() {

      };
      IsPending.value = new IsPending();
      return IsPending;
  })();
  var IsReceived = (function () {
      function IsReceived() {

      };
      IsReceived.value = new IsReceived();
      return IsReceived;
  })();
  var IsStarted = (function () {
      function IsStarted() {

      };
      IsStarted.value = new IsStarted();
      return IsStarted;
  })();
  var IsFailure = (function () {
      function IsFailure() {

      };
      IsFailure.value = new IsFailure();
      return IsFailure;
  })();
  var IsFinished = (function () {
      function IsFinished() {

      };
      IsFinished.value = new IsFinished();
      return IsFinished;
  })();
  var IsKilled = (function () {
      function IsKilled() {

      };
      IsKilled.value = new IsKilled();
      return IsKilled;
  })();
  var V0 = (function () {
      function V0() {

      };
      V0.value = new V0();
      return V0;
  })();
  var V10 = (function () {
      function V10() {

      };
      V10.value = new V10();
      return V10;
  })();
  var V11 = (function () {
      function V11() {

      };
      V11.value = new V11();
      return V11;
  })();
  var toggleSidePanelState = function (v) {
      if (v instanceof InitialClosed) {
          return Opened.value;
      };
      if (v instanceof Closed) {
          return Opened.value;
      };
      if (v instanceof Opened) {
          return Closed.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 690, column 1 - line 690, column 57): " + [ v.constructor.name ]);
  };
  var termSizes = [ {
      desc: "All types",
      mval: Data_Maybe.Nothing.value
  }, {
      desc: "One-word terms",
      mval: new Data_Maybe.Just(MonoTerm.value)
  }, {
      desc: "Multi-word terms",
      mval: new Data_Maybe.Just(MultiTerm.value)
  } ];
  var termLists = [ {
      desc: "All terms",
      mval: Data_Maybe.Nothing.value
  }, {
      desc: "Map terms",
      mval: new Data_Maybe.Just(MapTerm.value)
  }, {
      desc: "Stop terms",
      mval: new Data_Maybe.Just(StopTerm.value)
  }, {
      desc: "Candidate terms",
      mval: new Data_Maybe.Just(CandidateTerm.value)
  } ];
  var termListName = function (v) {
      if (v instanceof MapTerm) {
          return "Map List";
      };
      if (v instanceof StopTerm) {
          return "Stop List";
      };
      if (v instanceof CandidateTerm) {
          return "Candidate List";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 92, column 1 - line 92, column 35): " + [ v.constructor.name ]);
  };
  var switchHanded = function (v) {
      return function (v1) {
          return function (v2) {
              if (v2 instanceof LeftHanded) {
                  return v;
              };
              if (v2 instanceof RightHanded) {
                  return v1;
              };
              throw new Error("Failed pattern match at Gargantext.Types (line 25, column 1 - line 25, column 48): " + [ v.constructor.name, v1.constructor.name, v2.constructor.name ]);
          };
      };
  };
  var reverseHanded = function (v) {
      return function (a) {
          if (v instanceof LeftHanded) {
              return Data_Array.reverse(a);
          };
          if (v instanceof RightHanded) {
              return a;
          };
          throw new Error("Failed pattern match at Gargantext.Types (line 29, column 1 - line 29, column 56): " + [ v.constructor.name, a.constructor.name ]);
      };
  };
  var publicize = function (v) {
      if (v instanceof NodePublic) {
          return new NodePublic(v.value0);
      };
      return new NodePublic(v);
  };
  var progressPercent = function (v) {
      var perc = (function () {
          var v1 = Data_Array.head(v.log);
          if (v1 instanceof Data_Maybe.Nothing) {
              return 0.0;
          };
          if (v1 instanceof Data_Maybe.Just) {
              var nom = Data_Int.toNumber(v1.value0.failed + v1.value0.succeeded | 0);
              var denom = Data_Int.toNumber((v1.value0.failed + v1.value0.succeeded | 0) + v1.value0.remaining | 0);
              return (100.0 * nom) / denom;
          };
          throw new Error("Failed pattern match at Gargantext.Types (line 668, column 12 - line 673, column 60): " + [ v1.constructor.name ]);
      })();
      return perc;
  };
  var nodeTypePath = function ($copy_v) {
      var $tco_done = false;
      var $tco_result;
      function $tco_loop(v) {
          if (v instanceof Folder) {
              $tco_done = true;
              return "folder";
          };
          if (v instanceof FolderPrivate) {
              $tco_done = true;
              return "folderPrivate";
          };
          if (v instanceof FolderShared) {
              $tco_done = true;
              return "folderShared";
          };
          if (v instanceof FolderPublic) {
              $tco_done = true;
              return "folderPublic";
          };
          if (v instanceof Annuaire) {
              $tco_done = true;
              return "annuaire";
          };
          if (v instanceof Corpus) {
              $tco_done = true;
              return "corpus";
          };
          if (v instanceof Dashboard) {
              $tco_done = true;
              return "dashboard";
          };
          if (v instanceof Url_Document) {
              $tco_done = true;
              return "document";
          };
          if (v instanceof $$Error) {
              $tco_done = true;
              return "ErrorNodeType";
          };
          if (v instanceof Graph) {
              $tco_done = true;
              return "graph";
          };
          if (v instanceof Phylo) {
              $tco_done = true;
              return "phylo";
          };
          if (v instanceof Individu) {
              $tco_done = true;
              return "individu";
          };
          if (v instanceof Node) {
              $tco_done = true;
              return "node";
          };
          if (v instanceof Nodes) {
              $tco_done = true;
              return "nodes";
          };
          if (v instanceof NodeUser) {
              $tco_done = true;
              return "user";
          };
          if (v instanceof NodeContact) {
              $tco_done = true;
              return "contact";
          };
          if (v instanceof Tree) {
              $tco_done = true;
              return "tree";
          };
          if (v instanceof NodeList) {
              $tco_done = true;
              return "lists";
          };
          if (v instanceof Texts) {
              $tco_done = true;
              return "texts";
          };
          if (v instanceof Team) {
              $tco_done = true;
              return "team";
          };
          if (v instanceof NodeFrameWrite) {
              $tco_done = true;
              return "write";
          };
          if (v instanceof NodeFrameCalc) {
              $tco_done = true;
              return "calc";
          };
          if (v instanceof NodeFrameNotebook) {
              $tco_done = true;
              return "code";
          };
          if (v instanceof NodeFrameVisio) {
              $tco_done = true;
              return "visio";
          };
          if (v instanceof NodePublic) {
              $copy_v = v.value0;
              return;
          };
          if (v instanceof NodeFile) {
              $tco_done = true;
              return "file";
          };
          throw new Error("Failed pattern match at Gargantext.Types (line 303, column 1 - line 303, column 35): " + [ v.constructor.name ]);
      };
      while (!$tco_done) {
          $tco_result = $tco_loop($copy_v);
      };
      return $tco_result;
  };
  var modeTabType = function (v) {
      if (v instanceof Authors) {
          return CTabAuthors.value;
      };
      if (v instanceof Institutes) {
          return CTabInstitutes.value;
      };
      if (v instanceof Sources) {
          return CTabSources.value;
      };
      if (v instanceof Terms) {
          return CTabTerms.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 558, column 1 - line 558, column 37): " + [ v.constructor.name ]);
  };
  var modeFromString = function (v) {
      if (v === "Authors") {
          return new Data_Maybe.Just(Authors.value);
      };
      if (v === "Institutes") {
          return new Data_Maybe.Just(Institutes.value);
      };
      if (v === "Sources") {
          return new Data_Maybe.Just(Sources.value);
      };
      if (v === "Terms") {
          return new Data_Maybe.Just(Terms.value);
      };
      return Data_Maybe.Nothing.value;
  };
  var isPublic = function (v) {
      if (v instanceof NodePublic) {
          return true;
      };
      if (v instanceof FolderPublic) {
          return true;
      };
      return false;
  };
  var flipHanded = function (l) {
      return function (r) {
          return function (v) {
              if (v instanceof LeftHanded) {
                  return Reactix_React.fragment([ r, l ]);
              };
              if (v instanceof RightHanded) {
                  return Reactix_React.fragment([ l, r ]);
              };
              throw new Error("Failed pattern match at Gargantext.Types (line 33, column 1 - line 33, column 60): " + [ l.constructor.name, r.constructor.name, v.constructor.name ]);
          };
      };
  };
  var fldr = function ($copy_v) {
      return function ($copy_v1) {
          var $tco_var_v = $copy_v;
          var $tco_done = false;
          var $tco_result;
          function $tco_loop(v, v1) {
              if (v instanceof NodeUser && !v1) {
                  $tco_done = true;
                  return "fa fa-user-circle";
              };
              if (v instanceof NodeUser && v1) {
                  $tco_done = true;
                  return "fa fa-user";
              };
              if (v instanceof Folder && !v1) {
                  $tco_done = true;
                  return "fa fa-folder";
              };
              if (v instanceof Folder && v1) {
                  $tco_done = true;
                  return "fa fa-folder-open-o";
              };
              if (v instanceof FolderPrivate && v1) {
                  $tco_done = true;
                  return "fa fa-lock";
              };
              if (v instanceof FolderPrivate && !v1) {
                  $tco_done = true;
                  return "fa fa-lock-circle";
              };
              if (v instanceof FolderShared && v1) {
                  $tco_done = true;
                  return "fa fa-share-alt";
              };
              if (v instanceof FolderShared && !v1) {
                  $tco_done = true;
                  return "fa fa-share-circle";
              };
              if (v instanceof Team && v1) {
                  $tco_done = true;
                  return "fa fa-users";
              };
              if (v instanceof Team && !v1) {
                  $tco_done = true;
                  return "fa fa-users-closed";
              };
              if (v instanceof FolderPublic && v1) {
                  $tco_done = true;
                  return "fa fa-globe-circle";
              };
              if (v instanceof FolderPublic && !v1) {
                  $tco_done = true;
                  return "fa fa-globe";
              };
              if (v instanceof Corpus && v1) {
                  $tco_done = true;
                  return "fa fa-book";
              };
              if (v instanceof Corpus && !v1) {
                  $tco_done = true;
                  return "fa fa-book-circle";
              };
              if (v instanceof Phylo) {
                  $tco_done = true;
                  return "fa fa-code-fork";
              };
              if (v instanceof Graph) {
                  $tco_done = true;
                  return "fa fa-hubzilla";
              };
              if (v instanceof Texts) {
                  $tco_done = true;
                  return "fa fa-newspaper-o";
              };
              if (v instanceof Dashboard) {
                  $tco_done = true;
                  return "fa fa-signal";
              };
              if (v instanceof NodeList) {
                  $tco_done = true;
                  return "fa fa-list";
              };
              if (v instanceof NodeFile) {
                  $tco_done = true;
                  return "fa fa-file";
              };
              if (v instanceof Annuaire && v1) {
                  $tco_done = true;
                  return "fa fa-address-card-o";
              };
              if (v instanceof Annuaire && !v1) {
                  $tco_done = true;
                  return "fa fa-address-card";
              };
              if (v instanceof NodeContact && v1) {
                  $tco_done = true;
                  return "fa fa-address-card-o";
              };
              if (v instanceof NodeContact && !v1) {
                  $tco_done = true;
                  return "fa fa-address-card";
              };
              if (v instanceof NodeFrameWrite && v1) {
                  $tco_done = true;
                  return "fa fa-file-text-o";
              };
              if (v instanceof NodeFrameWrite && !v1) {
                  $tco_done = true;
                  return "fa fa-file-text";
              };
              if (v instanceof NodeFrameCalc && v1) {
                  $tco_done = true;
                  return "fa fa-calculator";
              };
              if (v instanceof NodeFrameCalc && !v1) {
                  $tco_done = true;
                  return "fa fa-calculator";
              };
              if (v instanceof NodeFrameNotebook && v1) {
                  $tco_done = true;
                  return "fa fa-file-code-o";
              };
              if (v instanceof NodeFrameNotebook && !v1) {
                  $tco_done = true;
                  return "fa fa-code";
              };
              if (v instanceof NodeFrameVisio && v1) {
                  $tco_done = true;
                  return "fa fa-video-camera";
              };
              if (v instanceof NodeFrameVisio && !v1) {
                  $tco_done = true;
                  return "fa fa-video-camera";
              };
              if (v instanceof NodePublic) {
                  $tco_var_v = v.value0;
                  $copy_v1 = v1;
                  return;
              };
              if (v1) {
                  $tco_done = true;
                  return "fa fa-folder-open";
              };
              if (!v1) {
                  $tco_done = true;
                  return "fa fa-folder-o";
              };
              throw new Error("Failed pattern match at Gargantext.Types (line 229, column 1 - line 229, column 38): " + [ v.constructor.name, v1.constructor.name ]);
          };
          while (!$tco_done) {
              $tco_result = $tco_loop($tco_var_v, $copy_v1);
          };
          return $tco_result;
      };
  };
  var asyncTaskTypePath = function (v) {
      if (v instanceof AddNode) {
          return "async/nobody/";
      };
      if (v instanceof Form) {
          return "add/form/async/";
      };
      if (v instanceof GraphRecompute) {
          return "async/recompute/";
      };
      if (v instanceof Query) {
          return "query/";
      };
      if (v instanceof UpdateNgramsCharts) {
          return "ngrams/async/charts/update/";
      };
      if (v instanceof UpdateNode) {
          return "update/";
      };
      if (v instanceof UploadFile) {
          return "async/file/add/";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 590, column 1 - line 590, column 45): " + [ v.constructor.name ]);
  };
  var $dollar_WriteForeignTabType_151 = new Simple_JSON.WriteForeign(function (v) {
      if (v instanceof TabCorpus && v.value0 instanceof TabDocs) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Docs");
      };
      if (v instanceof TabCorpus && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabAuthors)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Authors");
      };
      if (v instanceof TabCorpus && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabInstitutes)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Institutes");
      };
      if (v instanceof TabCorpus && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabSources)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Sources");
      };
      if (v instanceof TabCorpus && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabTerms)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Terms");
      };
      if (v instanceof TabCorpus && v.value0 instanceof TabMoreLikeFav) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("MoreFav");
      };
      if (v instanceof TabCorpus && v.value0 instanceof TabMoreLikeTrash) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("MoreTrash");
      };
      if (v instanceof TabCorpus && v.value0 instanceof TabTrash) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Trash");
      };
      if (v instanceof TabDocument && v.value0 instanceof TabDocs) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Docs");
      };
      if (v instanceof TabDocument && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabAuthors)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Authors");
      };
      if (v instanceof TabDocument && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabInstitutes)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Institutes");
      };
      if (v instanceof TabDocument && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabSources)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Sources");
      };
      if (v instanceof TabDocument && (v.value0 instanceof TabNgramType && v.value0.value0 instanceof CTabTerms)) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Terms");
      };
      if (v instanceof TabDocument && v.value0 instanceof TabMoreLikeFav) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("MoreFav");
      };
      if (v instanceof TabDocument && v.value0 instanceof TabMoreLikeTrash) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("MoreTrash");
      };
      if (v instanceof TabDocument && v.value0 instanceof TabTrash) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("Trash");
      };
      if (v instanceof TabPairing) {
          return Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("TabPairing");
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 513, column 1 - line 530, column 86): " + [ v.constructor.name ]);
  });
  var $dollar_WriteForeignApiVersion_129 = new Simple_JSON.WriteForeign(function (v) {
      if (v instanceof V0) {
          return Foreign.unsafeToForeign(Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("v0"));
      };
      if (v instanceof V10) {
          return Foreign.unsafeToForeign(Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("v1.0"));
      };
      if (v instanceof V11) {
          return Foreign.unsafeToForeign(Simple_JSON.writeImpl(Simple_JSON.writeForeignString)("v1.1"));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 429, column 1 - line 432, column 60): " + [ v.constructor.name ]);
  });
  var $dollar_ShowTermSize_100 = new Data_Show.Show(function (v) {
      if (v instanceof MonoTerm) {
          return "MonoTerm";
      };
      if (v instanceof MultiTerm) {
          return "MultiTerm";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 66, column 1 - line 68, column 31): " + [ v.constructor.name ]);
  });
  var $dollar_ShowTabSubType_146 = function (dictShow) {
      return new Data_Show.Show(function (v) {
          if (v instanceof TabDocs) {
              return "Docs";
          };
          if (v instanceof TabNgramType) {
              return Data_Show.show(dictShow)(v.value0);
          };
          if (v instanceof TabTrash) {
              return "Trash";
          };
          if (v instanceof TabMoreLikeFav) {
              return "MoreFav";
          };
          if (v instanceof TabMoreLikeTrash) {
              return "MoreTrash";
          };
          throw new Error("Failed pattern match at Gargantext.Types (line 497, column 1 - line 502, column 38): " + [ v.constructor.name ]);
      });
  };
  var $dollar_ShowSessionId_97 = new Data_Show.Show(function (v) {
      return v;
  });
  var nodePath = function (v) {
      var id = Data_Maybe.maybe("")(function (j) {
          return "/" + Data_Show.show(Data_Show.showInt)(j);
      })(v.value2);
      return nodeTypePath(v.value1) + ("/" + (Data_Show.show($dollar_ShowSessionId_97)(v.value0) + id));
  };
  var $dollar_ShowPTabNgramType_140 = new Data_Show.Show(function (v) {
      if (v instanceof PTabPatents) {
          return "Patents";
      };
      if (v instanceof PTabBooks) {
          return "Books";
      };
      if (v instanceof PTabCommunication) {
          return "Communication";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 462, column 1 - line 465, column 43): " + [ v.constructor.name ]);
  });   
  var $dollar_ShowNodeType_117 = new Data_Show.Show(function (v) {
      if (v instanceof NodeUser) {
          return "NodeUser";
      };
      if (v instanceof Folder) {
          return "NodeFolder";
      };
      if (v instanceof FolderPrivate) {
          return "NodeFolderPrivate";
      };
      if (v instanceof FolderShared) {
          return "NodeFolderShared";
      };
      if (v instanceof FolderPublic) {
          return "NodeFolderPublic";
      };
      if (v instanceof Annuaire) {
          return "NodeAnnuaire";
      };
      if (v instanceof NodeContact) {
          return "NodeContact";
      };
      if (v instanceof Corpus) {
          return "NodeCorpus";
      };
      if (v instanceof Dashboard) {
          return "NodeDashboard";
      };
      if (v instanceof Url_Document) {
          return "NodeDocument";
      };
      if (v instanceof $$Error) {
          return "NodeError";
      };
      if (v instanceof Graph) {
          return "NodeGraph";
      };
      if (v instanceof Phylo) {
          return "NodePhylo";
      };
      if (v instanceof Individu) {
          return "NodeIndividu";
      };
      if (v instanceof Node) {
          return "Node";
      };
      if (v instanceof Nodes) {
          return "Nodes";
      };
      if (v instanceof Tree) {
          return "NodeTree";
      };
      if (v instanceof Team) {
          return "NodeTeam";
      };
      if (v instanceof NodeList) {
          return "NodeList";
      };
      if (v instanceof Texts) {
          return "NodeDocs";
      };
      if (v instanceof NodeFrameWrite) {
          return "NodeFrameWrite";
      };
      if (v instanceof NodeFrameCalc) {
          return "NodeFrameCalc";
      };
      if (v instanceof NodeFrameNotebook) {
          return "NodeFrameNotebook";
      };
      if (v instanceof NodeFrameVisio) {
          return "NodeFrameVisio";
      };
      if (v instanceof NodePublic) {
          return "NodePublic" + Data_Show.show($dollar_ShowNodeType_117)(v.value0);
      };
      if (v instanceof NodeFile) {
          return "NodeFile";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 168, column 1 - line 196, column 36): " + [ v.constructor.name ]);
  });
  var $dollar_WriteForeignNodeType_116 = new Simple_JSON.WriteForeign((function () {
      var $872 = Simple_JSON.writeImpl(Simple_JSON.writeForeignString);
      var $873 = Data_Show.show($dollar_ShowNodeType_117);
      return function ($874) {
          return $872($873($874));
      };
  })());
  var prettyNodeType = function (nt) {
      return Data_String_Common.replace("Node")(" ")(Data_String_Common.replace("Folder")(" ")(Data_Show.show($dollar_ShowNodeType_117)(nt)));
  };
  var $dollar_ShowChartType_122 = new Data_Show.Show(function (v) {
      if (v instanceof Histo) {
          return "chart";
      };
      if (v instanceof Scatter) {
          return "scatter";
      };
      if (v instanceof ChartBar) {
          return "bar";
      };
      if (v instanceof ChartPie) {
          return "pie";
      };
      if (v instanceof ChartTree) {
          return "tree";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 393, column 1 - line 399, column 28): " + [ v.constructor.name ]);
  });
  var $dollar_ShowCTabNgramType_135 = new Data_Show.Show(function (v) {
      if (v instanceof CTabTerms) {
          return "Terms";
      };
      if (v instanceof CTabSources) {
          return "Sources";
      };
      if (v instanceof CTabAuthors) {
          return "Authors";
      };
      if (v instanceof CTabInstitutes) {
          return "Institutes";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 451, column 1 - line 455, column 37): " + [ v.constructor.name ]);
  });   
  var showTabType$prime = function (v) {
      if (v instanceof TabCorpus) {
          return Data_Show.show($dollar_ShowTabSubType_146($dollar_ShowCTabNgramType_135))(v.value0);
      };
      if (v instanceof TabDocument) {
          return Data_Show.show($dollar_ShowTabSubType_146($dollar_ShowCTabNgramType_135))(v.value0);
      };
      if (v instanceof TabPairing) {
          return Data_Show.show($dollar_ShowTabSubType_146($dollar_ShowPTabNgramType_140))(v.value0);
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 115, column 1 - line 115, column 34): " + [ v.constructor.name ]);
  };
  var $dollar_ShowApiVersion_130 = new Data_Show.Show(function (v) {
      if (v instanceof V0) {
          return "v0";
      };
      if (v instanceof V10) {
          return "v1.0";
      };
      if (v instanceof V11) {
          return "v1.1";
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 434, column 1 - line 437, column 20): " + [ v.constructor.name ]);
  });
  var $dollar_ReadTermSize_101 = new Gargantext_Prelude.Read(function (v) {
      if (v === "MonoTerm") {
          return new Data_Maybe.Just(MonoTerm.value);
      };
      if (v === "MultiTerm") {
          return new Data_Maybe.Just(MultiTerm.value);
      };
      return Data_Maybe.Nothing.value;
  });
  var $dollar_ReadTermList_108 = new Gargantext_Prelude.Read(function (v) {
      if (v === "MapTerm") {
          return new Data_Maybe.Just(MapTerm.value);
      };
      if (v === "StopTerm") {
          return new Data_Maybe.Just(StopTerm.value);
      };
      if (v === "CandidateTerm") {
          return new Data_Maybe.Just(CandidateTerm.value);
      };
      return Data_Maybe.Nothing.value;
  });
  var $dollar_ReadNodeType_118 = new Gargantext_Prelude.Read(function (v) {
      if (v === "NodeUser") {
          return new Data_Maybe.Just(NodeUser.value);
      };
      if (v === "NodeFolder") {
          return new Data_Maybe.Just(Folder.value);
      };
      if (v === "NodeFolderPrivate") {
          return new Data_Maybe.Just(FolderPrivate.value);
      };
      if (v === "NodeFolderShared") {
          return new Data_Maybe.Just(FolderShared.value);
      };
      if (v === "NodeFolderPublic") {
          return new Data_Maybe.Just(FolderPublic.value);
      };
      if (v === "NodeAnnuaire") {
          return new Data_Maybe.Just(Annuaire.value);
      };
      if (v === "NodeDashboard") {
          return new Data_Maybe.Just(Dashboard.value);
      };
      if (v === "Document") {
          return new Data_Maybe.Just(Url_Document.value);
      };
      if (v === "NodeGraph") {
          return new Data_Maybe.Just(Graph.value);
      };
      if (v === "NodePhylo") {
          return new Data_Maybe.Just(Phylo.value);
      };
      if (v === "Individu") {
          return new Data_Maybe.Just(Individu.value);
      };
      if (v === "Node") {
          return new Data_Maybe.Just(Node.value);
      };
      if (v === "Nodes") {
          return new Data_Maybe.Just(Nodes.value);
      };
      if (v === "NodeCorpus") {
          return new Data_Maybe.Just(Corpus.value);
      };
      if (v === "NodeContact") {
          return new Data_Maybe.Just(NodeContact.value);
      };
      if (v === "Tree") {
          return new Data_Maybe.Just(Tree.value);
      };
      if (v === "NodeTeam") {
          return new Data_Maybe.Just(Team.value);
      };
      if (v === "NodeList") {
          return new Data_Maybe.Just(NodeList.value);
      };
      if (v === "NodeTexts") {
          return new Data_Maybe.Just(Texts.value);
      };
      if (v === "Annuaire") {
          return new Data_Maybe.Just(Annuaire.value);
      };
      if (v === "NodeFrameWrite") {
          return new Data_Maybe.Just(NodeFrameWrite.value);
      };
      if (v === "NodeFrameCalc") {
          return new Data_Maybe.Just(NodeFrameCalc.value);
      };
      if (v === "NodeFrameNotebook") {
          return new Data_Maybe.Just(NodeFrameNotebook.value);
      };
      if (v === "NodeFrameVisio") {
          return new Data_Maybe.Just(NodeFrameVisio.value);
      };
      if (v === "NodeFile") {
          return new Data_Maybe.Just(NodeFile.value);
      };
      return Data_Maybe.Nothing.value;
  });
  var $dollar_ReadForeignNodeType_115 = new Simple_JSON.ReadForeign(function (f) {
      return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Foreign.readString(Data_Identity.monadIdentity)(f))(function (s) {
          var v = Gargantext_Prelude.read($dollar_ReadNodeType_118)(s);
          if (v instanceof Data_Maybe.Nothing) {
              return Foreign.fail(Data_Identity.monadIdentity)(Foreign.ErrorAtProperty.create(s)(new Foreign.ForeignError("unknown property")));
          };
          if (v instanceof Data_Maybe.Just) {
              return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(v.value0);
          };
          throw new Error("Failed pattern match at Gargantext.Types (line 163, column 5 - line 165, column 25): " + [ v.constructor.name ]);
      });
  });
  var $dollar_ReadForeignAsyncTaskLog_178 = Simple_JSON.readRecord()(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "events";
  }))(Simple_JSON.readArray(Simple_JSON.readString))(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "failed";
  }))(Simple_JSON.readInt)(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "remaining";
  }))(Simple_JSON.readInt)(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "succeeded";
  }))(Simple_JSON.readInt)(Simple_JSON.readFieldsNil)()())()())()())()());
  var $dollar_GenericTermSize__98 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof MonoTerm) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof MultiTerm) {
          return new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value);
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 59, column 1 - line 59, column 35): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return MonoTerm.value;
      };
      if (x instanceof Data_Generic_Rep.Inr) {
          return MultiTerm.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 59, column 1 - line 59, column 35): " + [ x.constructor.name ]);
  });
  var $dollar_GenericTermList__102 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof MapTerm) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof StopTerm) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof CandidateTerm) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 84, column 1 - line 84, column 35): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return MapTerm.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return StopTerm.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inr) {
          return CandidateTerm.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 84, column 1 - line 84, column 35): " + [ x.constructor.name ]);
  });
  var $dollar_ReadForeignTermList_106 = new Simple_JSON.ReadForeign(Simple_JSON_Generics_EnumSumRep.enumSumRep($dollar_GenericTermList__102)(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "MapTerm";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "StopTerm";
  })))(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "CandidateTerm";
  }))))));
  var $dollar_ShowTermList_107 = new Data_Show.Show(Data_Show_Generic.genericShow($dollar_GenericTermList__102)(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "MapTerm";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "StopTerm";
  })))(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "CandidateTerm";
  }))))));
  var $dollar_WriteForeignTermList_105 = new Simple_JSON.WriteForeign((function () {
      var $878 = Simple_JSON.writeImpl(Simple_JSON.writeForeignString);
      var $879 = Data_Show.show($dollar_ShowTermList_107);
      return function ($880) {
          return $878($879($880));
      };
  })());  
  var $dollar_GenericTabSubType__142 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof TabDocs) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof TabNgramType) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(x.value0));
      };
      if (x instanceof TabTrash) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)));
      };
      if (x instanceof TabMoreLikeFav) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))));
      };
      if (x instanceof TabMoreLikeTrash) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value))));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 469, column 1 - line 469, column 41): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return TabDocs.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return new TabNgramType(x.value0.value0);
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inl)) {
          return TabTrash.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0 instanceof Data_Generic_Rep.Inl))) {
          return TabMoreLikeFav.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0 instanceof Data_Generic_Rep.Inr))) {
          return TabMoreLikeTrash.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 469, column 1 - line 469, column 41): " + [ x.constructor.name ]);
  });
  var $dollar_GenericSidePanelState__179 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof InitialClosed) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof Opened) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof Closed) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 686, column 1 - line 686, column 41): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return InitialClosed.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return Opened.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inr) {
          return Closed.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 686, column 1 - line 686, column 41): " + [ x.constructor.name ]);
  });
  var $dollar_GenericSessionId__95 = new Data_Generic_Rep.Generic(function (x) {
      return x;
  }, function (x) {
      return x;
  });
  var $dollar_GenericScoreType__119 = new Data_Generic_Rep.Generic(function (x) {
      return Data_Generic_Rep.NoArguments.value;
  }, function (x) {
      return Occurrences.value;
  });
  var $dollar_ShowScoreType_121 = new Data_Show.Show(Data_Show_Generic.genericShow($dollar_GenericScoreType__119)(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "Occurrences";
  }))));
  var $dollar_GenericPTabNgramType__137 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof PTabPatents) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof PTabBooks) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof PTabCommunication) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 459, column 1 - line 459, column 40): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return PTabPatents.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return PTabBooks.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inr) {
          return PTabCommunication.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 459, column 1 - line 459, column 40): " + [ x.constructor.name ]);
  });
  var $dollar_GenericOrderBy__123 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof DateAsc) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof DateDesc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof TitleAsc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)));
      };
      if (x instanceof TitleDesc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))));
      };
      if (x instanceof ScoreAsc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)))));
      };
      if (x instanceof ScoreDesc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))))));
      };
      if (x instanceof TermAsc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)))))));
      };
      if (x instanceof TermDesc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))))))));
      };
      if (x instanceof SourceAsc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)))))))));
      };
      if (x instanceof SourceDesc) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value)))))))));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 418, column 1 - line 418, column 34): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return DateAsc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return DateDesc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inl)) {
          return TitleAsc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0 instanceof Data_Generic_Rep.Inl))) {
          return TitleDesc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl)))) {
          return ScoreAsc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl))))) {
          return ScoreDesc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl)))))) {
          return TermAsc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl))))))) {
          return TermDesc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl)))))))) {
          return SourceAsc.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr)))))))) {
          return SourceDesc.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 418, column 1 - line 418, column 34): " + [ x.constructor.name ]);
  });            
  var $dollar_ShowOrderBy_124 = new Data_Show.Show(Data_Show_Generic.genericShow($dollar_GenericOrderBy__123)(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "DateAsc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "DateDesc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "TitleAsc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "TitleDesc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "ScoreAsc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "ScoreDesc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "TermAsc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "TermDesc";
  })))(Data_Show_Generic.genericShowSum(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "SourceAsc";
  })))(Data_Show_Generic.genericShowConstructor(Data_Show_Generic.genericShowArgsNoArguments)(new Data_Symbol.IsSymbol(function () {
      return "SourceDesc";
  })))))))))))));
  var $dollar_GenericMode__152 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof Authors) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof Sources) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof Institutes) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)));
      };
      if (x instanceof Terms) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value)));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 552, column 1 - line 552, column 31): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return Authors.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return Sources.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inl)) {
          return Institutes.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inr)) {
          return Terms.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 552, column 1 - line 552, column 31): " + [ x.constructor.name ]);
  });   
  var $dollar_GenericHanded__93 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof LeftHanded) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof RightHanded) {
          return new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value);
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 37, column 1 - line 37, column 33): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return LeftHanded.value;
      };
      if (x instanceof Data_Generic_Rep.Inr) {
          return RightHanded.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 37, column 1 - line 37, column 33): " + [ x.constructor.name ]);
  });
  var $dollar_GenericAsyncTask__165 = new Data_Generic_Rep.Generic(function (x) {
      return x;
  }, function (x) {
      return x;
  });
  var $dollar_GenericAsyncTaskWithType__169 = new Data_Generic_Rep.Generic(function (x) {
      return x;
  }, function (x) {
      return x;
  });
  var $dollar_GenericAsyncTaskType__157 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof AddNode) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof Form) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof GraphRecompute) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)));
      };
      if (x instanceof Query) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))));
      };
      if (x instanceof UpdateNgramsCharts) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)))));
      };
      if (x instanceof UpdateNode) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))))));
      };
      if (x instanceof UploadFile) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value))))));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 582, column 1 - line 582, column 40): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return AddNode.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return Form.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inl)) {
          return GraphRecompute.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0 instanceof Data_Generic_Rep.Inl))) {
          return Query.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl)))) {
          return UpdateNgramsCharts.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl))))) {
          return UpdateNode.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr))))) {
          return UploadFile.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 582, column 1 - line 582, column 40): " + [ x.constructor.name ]);
  });
  var $dollar_ReadForeignAsyncTaskType_158 = new Simple_JSON.ReadForeign(Simple_JSON_Generics_EnumSumRep.enumSumRep($dollar_GenericAsyncTaskType__157)(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "AddNode";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "Form";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "GraphRecompute";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "Query";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "UpdateNgramsCharts";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "UpdateNode";
  })))(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "UploadFile";
  }))))))))));
  var $dollar_GenericAsyncTaskStatus__161 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof IsRunning) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof IsPending) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof IsReceived) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)));
      };
      if (x instanceof IsStarted) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))));
      };
      if (x instanceof IsFailure) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value)))));
      };
      if (x instanceof IsFinished) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value))))));
      };
      if (x instanceof IsKilled) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value))))));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 609, column 1 - line 609, column 42): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return IsRunning.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return IsPending.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0 instanceof Data_Generic_Rep.Inl)) {
          return IsReceived.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0 instanceof Data_Generic_Rep.Inl))) {
          return IsStarted.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl)))) {
          return IsFailure.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inl))))) {
          return IsFinished.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && (x.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0 instanceof Data_Generic_Rep.Inr && (x.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr && x.value0.value0.value0.value0.value0 instanceof Data_Generic_Rep.Inr))))) {
          return IsKilled.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 609, column 1 - line 609, column 42): " + [ x.constructor.name ]);
  });
  var $dollar_ReadForeignAsyncTaskStatu_162 = new Simple_JSON.ReadForeign(Simple_JSON_Generics_EnumSumRep.enumSumRep($dollar_GenericAsyncTaskStatus__161)(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsRunning";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsPending";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsReceived";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsStarted";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsFailure";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsFinished";
  })))(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "IsKilled";
  }))))))))));
  var $dollar_ReadForeignAsyncProgress_175 = Simple_JSON.readRecord()(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "id";
  }))(Simple_JSON.readString)(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "log";
  }))(Simple_JSON.readArray($dollar_ReadForeignAsyncTaskLog_178))(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "status";
  }))($dollar_ReadForeignAsyncTaskStatu_162)(Simple_JSON.readFieldsNil)()())()())()());
  var $dollar_ReadForeignAsyncTask_167 = Simple_JSON.readRecord()(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "id";
  }))(Simple_JSON.readString)(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "status";
  }))($dollar_ReadForeignAsyncTaskStatu_162)(Simple_JSON.readFieldsNil)()())()());
  var $dollar_ReadForeignAsyncTaskWithT_171 = Simple_JSON.readRecord()(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "task";
  }))($dollar_ReadForeignAsyncTask_167)(Simple_JSON.readFieldsCons(new Data_Symbol.IsSymbol(function () {
      return "typ";
  }))($dollar_ReadForeignAsyncTaskType_158)(Simple_JSON.readFieldsNil)()())()());
  var $dollar_GenericApiVersion__127 = new Data_Generic_Rep.Generic(function (x) {
      if (x instanceof V0) {
          return new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value);
      };
      if (x instanceof V10) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inl(Data_Generic_Rep.NoArguments.value));
      };
      if (x instanceof V11) {
          return new Data_Generic_Rep.Inr(new Data_Generic_Rep.Inr(Data_Generic_Rep.NoArguments.value));
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 427, column 1 - line 427, column 37): " + [ x.constructor.name ]);
  }, function (x) {
      if (x instanceof Data_Generic_Rep.Inl) {
          return V0.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inl) {
          return V10.value;
      };
      if (x instanceof Data_Generic_Rep.Inr && x.value0 instanceof Data_Generic_Rep.Inr) {
          return V11.value;
      };
      throw new Error("Failed pattern match at Gargantext.Types (line 427, column 1 - line 427, column 37): " + [ x.constructor.name ]);
  });
  var $dollar_ReadForeignApiVersion_128 = new Simple_JSON.ReadForeign(Simple_JSON_Generics_EnumSumRep.enumSumRep($dollar_GenericApiVersion__127)(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "V0";
  })))(Simple_JSON_Generics_EnumSumRep.sumEnumSumRep(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "V10";
  })))(Simple_JSON_Generics_EnumSumRep.constructorEnumSumRep(new Data_Symbol.IsSymbol(function () {
      return "V11";
  }))))));
  var $dollar_EqTermSize_99 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericTermSize__98)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))));
  var $dollar_EqTermList_103 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericTermList__102)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)))));
  var $dollar_OrdTermList_104 = new Data_Ord.Ord(function () {
      return $dollar_EqTermList_103;
  }, Data_Ord_Generic.genericCompare($dollar_GenericTermList__102)(Data_Ord_Generic.genericOrdSum(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))(Data_Ord_Generic.genericOrdSum(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments)))));
  var $dollar_EqTabSubType_143 = function (dictEq) {
      return new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericTabSubType__142)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqArgument(dictEq)))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)))))));
  };
  var $dollar_EqSidePanelState_180 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericSidePanelState__179)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)))));
  var $dollar_EqSessionId_96 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericSessionId__95)(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqArgument(Data_Eq.eqString))));
  var $dollar_EqScoreType_120 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericScoreType__119)(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)));
  var $dollar_EqPTabNgramType_138 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericPTabNgramType__137)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)))));
  var $dollar_EqNodeType_114 = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof Annuaire && y instanceof Annuaire) {
              return true;
          };
          if (x instanceof Corpus && y instanceof Corpus) {
              return true;
          };
          if (x instanceof Dashboard && y instanceof Dashboard) {
              return true;
          };
          if (x instanceof $$Error && y instanceof $$Error) {
              return true;
          };
          if (x instanceof Folder && y instanceof Folder) {
              return true;
          };
          if (x instanceof FolderPrivate && y instanceof FolderPrivate) {
              return true;
          };
          if (x instanceof FolderPublic && y instanceof FolderPublic) {
              return true;
          };
          if (x instanceof FolderShared && y instanceof FolderShared) {
              return true;
          };
          if (x instanceof Graph && y instanceof Graph) {
              return true;
          };
          if (x instanceof Individu && y instanceof Individu) {
              return true;
          };
          if (x instanceof Node && y instanceof Node) {
              return true;
          };
          if (x instanceof NodeContact && y instanceof NodeContact) {
              return true;
          };
          if (x instanceof NodeList && y instanceof NodeList) {
              return true;
          };
          if (x instanceof NodeUser && y instanceof NodeUser) {
              return true;
          };
          if (x instanceof Nodes && y instanceof Nodes) {
              return true;
          };
          if (x instanceof Phylo && y instanceof Phylo) {
              return true;
          };
          if (x instanceof Team && y instanceof Team) {
              return true;
          };
          if (x instanceof Texts && y instanceof Texts) {
              return true;
          };
          if (x instanceof Tree && y instanceof Tree) {
              return true;
          };
          if (x instanceof Url_Document && y instanceof Url_Document) {
              return true;
          };
          if (x instanceof NodeFile && y instanceof NodeFile) {
              return true;
          };
          if (x instanceof NodeFrameCalc && y instanceof NodeFrameCalc) {
              return true;
          };
          if (x instanceof NodeFrameNotebook && y instanceof NodeFrameNotebook) {
              return true;
          };
          if (x instanceof NodeFrameWrite && y instanceof NodeFrameWrite) {
              return true;
          };
          if (x instanceof NodeFrameVisio && y instanceof NodeFrameVisio) {
              return true;
          };
          if (x instanceof NodePublic && y instanceof NodePublic) {
              return Data_Eq.eq($dollar_EqNodeType_114)(x.value0)(y.value0);
          };
          return false;
      };
  });
  var $dollar_EqMode_154 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericMode__152)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))))));
  var $dollar_OrdMode_155 = new Data_Ord.Ord(function () {
      return $dollar_EqMode_154;
  }, Data_Ord_Generic.genericCompare($dollar_GenericMode__152)(Data_Ord_Generic.genericOrdSum(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))(Data_Ord_Generic.genericOrdSum(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))(Data_Ord_Generic.genericOrdSum(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))(Data_Ord_Generic.genericOrdConstructor(Data_Ord_Generic.genericOrdNoArguments))))));
  var $dollar_EqHanded_94 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericHanded__93)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))));
  var $dollar_EqCTabNgramType_133 = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof CTabTerms && y instanceof CTabTerms) {
              return true;
          };
          if (x instanceof CTabSources && y instanceof CTabSources) {
              return true;
          };
          if (x instanceof CTabAuthors && y instanceof CTabAuthors) {
              return true;
          };
          if (x instanceof CTabInstitutes && y instanceof CTabInstitutes) {
              return true;
          };
          return false;
      };
  });
  var $dollar_EqTabType_148 = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof TabCorpus && y instanceof TabCorpus) {
              return Data_Eq.eq($dollar_EqTabSubType_143($dollar_EqCTabNgramType_133))(x.value0)(y.value0);
          };
          if (x instanceof TabPairing && y instanceof TabPairing) {
              return Data_Eq.eq($dollar_EqTabSubType_143($dollar_EqPTabNgramType_138))(x.value0)(y.value0);
          };
          if (x instanceof TabDocument && y instanceof TabDocument) {
              return Data_Eq.eq($dollar_EqTabSubType_143($dollar_EqCTabNgramType_133))(x.value0)(y.value0);
          };
          return false;
      };
  });
  var $dollar_EqAsyncTaskType_159 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericAsyncTaskType__157)(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqSum(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments))(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqNoArguments)))))))));
  var $dollar_EqAsyncTaskStatus_164 = new Data_Eq.Eq(function (x) {
      return function (y) {
          if (x instanceof IsRunning && y instanceof IsRunning) {
              return true;
          };
          if (x instanceof IsPending && y instanceof IsPending) {
              return true;
          };
          if (x instanceof IsReceived && y instanceof IsReceived) {
              return true;
          };
          if (x instanceof IsStarted && y instanceof IsStarted) {
              return true;
          };
          if (x instanceof IsFailure && y instanceof IsFailure) {
              return true;
          };
          if (x instanceof IsFinished && y instanceof IsFinished) {
              return true;
          };
          if (x instanceof IsKilled && y instanceof IsKilled) {
              return true;
          };
          return false;
      };
  });
  var $dollar_EqAsyncTask_168 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericAsyncTask__165)(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqArgument(Data_Eq.eqRec()(Data_Eq.eqRowCons(Data_Eq.eqRowCons(Data_Eq.eqRowNil)()(new Data_Symbol.IsSymbol(function () {
      return "status";
  }))($dollar_EqAsyncTaskStatus_164))()(new Data_Symbol.IsSymbol(function () {
      return "id";
  }))(Data_Eq.eqString))))));
  var $dollar_EqAsyncTaskWithType_172 = new Data_Eq.Eq(Data_Eq_Generic.genericEq($dollar_GenericAsyncTaskWithType__169)(Data_Eq_Generic.genericEqConstructor(Data_Eq_Generic.genericEqArgument(Data_Eq.eqRec()(Data_Eq.eqRowCons(Data_Eq.eqRowCons(Data_Eq.eqRowNil)()(new Data_Symbol.IsSymbol(function () {
      return "typ";
  }))($dollar_EqAsyncTaskType_159))()(new Data_Symbol.IsSymbol(function () {
      return "task";
  }))($dollar_EqAsyncTask_168))))));
  var $dollar_EqApiVersion_131 = new Data_Eq.Eq(function (v) {
      return function (v1) {
          if (v instanceof V10 && v1 instanceof V10) {
              return true;
          };
          if (v instanceof V11 && v1 instanceof V11) {
              return true;
          };
          return false;
      };
  });
  exports["LeftHanded"] = LeftHanded;
  exports["RightHanded"] = RightHanded;
  exports["switchHanded"] = switchHanded;
  exports["reverseHanded"] = reverseHanded;
  exports["flipHanded"] = flipHanded;
  exports["SessionId"] = SessionId;
  exports["MonoTerm"] = MonoTerm;
  exports["MultiTerm"] = MultiTerm;
  exports["termSizes"] = termSizes;
  exports["MapTerm"] = MapTerm;
  exports["StopTerm"] = StopTerm;
  exports["CandidateTerm"] = CandidateTerm;
  exports["termListName"] = termListName;
  exports["termLists"] = termLists;
  exports["showTabType'"] = showTabType$prime;
  exports["Annuaire"] = Annuaire;
  exports["Corpus"] = Corpus;
  exports["Dashboard"] = Dashboard;
  exports["Error"] = $$Error;
  exports["Folder"] = Folder;
  exports["FolderPrivate"] = FolderPrivate;
  exports["FolderPublic"] = FolderPublic;
  exports["FolderShared"] = FolderShared;
  exports["Graph"] = Graph;
  exports["Node"] = Node;
  exports["NodeContact"] = NodeContact;
  exports["NodeList"] = NodeList;
  exports["NodeUser"] = NodeUser;
  exports["Phylo"] = Phylo;
  exports["Team"] = Team;
  exports["Texts"] = Texts;
  exports["Tree"] = Tree;
  exports["Url_Document"] = Url_Document;
  exports["NodeFile"] = NodeFile;
  exports["NodeFrameCalc"] = NodeFrameCalc;
  exports["NodeFrameNotebook"] = NodeFrameNotebook;
  exports["NodeFrameWrite"] = NodeFrameWrite;
  exports["NodeFrameVisio"] = NodeFrameVisio;
  exports["NodePublic"] = NodePublic;
  exports["fldr"] = fldr;
  exports["publicize"] = publicize;
  exports["isPublic"] = isPublic;
  exports["nodeTypePath"] = nodeTypePath;
  exports["Occurrences"] = Occurrences;
  exports["NodePath"] = NodePath;
  exports["nodePath"] = nodePath;
  exports["Histo"] = Histo;
  exports["Scatter"] = Scatter;
  exports["ChartPie"] = ChartPie;
  exports["ChartBar"] = ChartBar;
  exports["ChartTree"] = ChartTree;
  exports["DateAsc"] = DateAsc;
  exports["DateDesc"] = DateDesc;
  exports["TitleAsc"] = TitleAsc;
  exports["TitleDesc"] = TitleDesc;
  exports["ScoreAsc"] = ScoreAsc;
  exports["ScoreDesc"] = ScoreDesc;
  exports["TermAsc"] = TermAsc;
  exports["TermDesc"] = TermDesc;
  exports["SourceAsc"] = SourceAsc;
  exports["SourceDesc"] = SourceDesc;
  exports["V10"] = V10;
  exports["CTabTerms"] = CTabTerms;
  exports["CTabSources"] = CTabSources;
  exports["CTabAuthors"] = CTabAuthors;
  exports["CTabInstitutes"] = CTabInstitutes;
  exports["PTabPatents"] = PTabPatents;
  exports["PTabBooks"] = PTabBooks;
  exports["PTabCommunication"] = PTabCommunication;
  exports["TabDocs"] = TabDocs;
  exports["TabNgramType"] = TabNgramType;
  exports["TabTrash"] = TabTrash;
  exports["TabMoreLikeFav"] = TabMoreLikeFav;
  exports["TabMoreLikeTrash"] = TabMoreLikeTrash;
  exports["TabCorpus"] = TabCorpus;
  exports["TabPairing"] = TabPairing;
  exports["TabDocument"] = TabDocument;
  exports["Authors"] = Authors;
  exports["Sources"] = Sources;
  exports["Institutes"] = Institutes;
  exports["Terms"] = Terms;
  exports["modeTabType"] = modeTabType;
  exports["modeFromString"] = modeFromString;
  exports["Form"] = Form;
  exports["Query"] = Query;
  exports["UpdateNgramsCharts"] = UpdateNgramsCharts;
  exports["UpdateNode"] = UpdateNode;
  exports["UploadFile"] = UploadFile;
  exports["asyncTaskTypePath"] = asyncTaskTypePath;
  exports["IsFailure"] = IsFailure;
  exports["IsFinished"] = IsFinished;
  exports["IsKilled"] = IsKilled;
  exports["progressPercent"] = progressPercent;
  exports["prettyNodeType"] = prettyNodeType;
  exports["InitialClosed"] = InitialClosed;
  exports["Opened"] = Opened;
  exports["Closed"] = Closed;
  exports["toggleSidePanelState"] = toggleSidePanelState;
  exports["$_EqHanded_94"] = $dollar_EqHanded_94;
  exports["$_EqSessionId_96"] = $dollar_EqSessionId_96;
  exports["$_ShowSessionId_97"] = $dollar_ShowSessionId_97;
  exports["$_EqTermSize_99"] = $dollar_EqTermSize_99;
  exports["$_ShowTermSize_100"] = $dollar_ShowTermSize_100;
  exports["$_ReadTermSize_101"] = $dollar_ReadTermSize_101;
  exports["$_EqTermList_103"] = $dollar_EqTermList_103;
  exports["$_OrdTermList_104"] = $dollar_OrdTermList_104;
  exports["$_WriteForeignTermList_105"] = $dollar_WriteForeignTermList_105;
  exports["$_ReadForeignTermList_106"] = $dollar_ReadForeignTermList_106;
  exports["$_ShowTermList_107"] = $dollar_ShowTermList_107;
  exports["$_ReadTermList_108"] = $dollar_ReadTermList_108;
  exports["$_EqNodeType_114"] = $dollar_EqNodeType_114;
  exports["$_ReadForeignNodeType_115"] = $dollar_ReadForeignNodeType_115;
  exports["$_WriteForeignNodeType_116"] = $dollar_WriteForeignNodeType_116;
  exports["$_ShowNodeType_117"] = $dollar_ShowNodeType_117;
  exports["$_ReadNodeType_118"] = $dollar_ReadNodeType_118;
  exports["$_EqScoreType_120"] = $dollar_EqScoreType_120;
  exports["$_ShowScoreType_121"] = $dollar_ShowScoreType_121;
  exports["$_ShowChartType_122"] = $dollar_ShowChartType_122;
  exports["$_ShowOrderBy_124"] = $dollar_ShowOrderBy_124;
  exports["$_ReadForeignApiVersion_128"] = $dollar_ReadForeignApiVersion_128;
  exports["$_WriteForeignApiVersion_129"] = $dollar_WriteForeignApiVersion_129;
  exports["$_ShowApiVersion_130"] = $dollar_ShowApiVersion_130;
  exports["$_EqApiVersion_131"] = $dollar_EqApiVersion_131;
  exports["$_ShowCTabNgramType_135"] = $dollar_ShowCTabNgramType_135;
  exports["$_ShowTabSubType_146"] = $dollar_ShowTabSubType_146;
  exports["$_EqTabType_148"] = $dollar_EqTabType_148;
  exports["$_WriteForeignTabType_151"] = $dollar_WriteForeignTabType_151;
  exports["$_EqMode_154"] = $dollar_EqMode_154;
  exports["$_OrdMode_155"] = $dollar_OrdMode_155;
  exports["$_EqAsyncTaskStatus_164"] = $dollar_EqAsyncTaskStatus_164;
  exports["$_ReadForeignAsyncTask_167"] = $dollar_ReadForeignAsyncTask_167;
  exports["$_ReadForeignAsyncTaskWithT_171"] = $dollar_ReadForeignAsyncTaskWithT_171;
  exports["$_EqAsyncTaskWithType_172"] = $dollar_EqAsyncTaskWithType_172;
  exports["$_ReadForeignAsyncProgress_175"] = $dollar_ReadForeignAsyncProgress_175;
  exports["$_EqSidePanelState_180"] = $dollar_EqSidePanelState_180;
})(PS);
(function(exports) {
  "use strict";

  exports.window = function () {
    return window;
  };
})(PS["Web.HTML"] = PS["Web.HTML"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Web.HTML"] = $PS["Web.HTML"] || {};
  var exports = $PS["Web.HTML"];
  var $foreign = $PS["Web.HTML"];
  exports["window"] = $foreign.window;
})(PS);
(function(exports) {
  "use strict";

  exports.hash = function (location) {
    return function () {
      return location.hash;
    };
  };

  // ----------------------------------------------------------------------------

  exports.href = function (location) {
    return function () {
      return location.href;
    };
  };
})(PS["Web.HTML.Location"] = PS["Web.HTML.Location"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Web.HTML.Location"] = $PS["Web.HTML.Location"] || {};
  var exports = $PS["Web.HTML.Location"];
  var $foreign = $PS["Web.HTML.Location"];
  exports["hash"] = $foreign.hash;
  exports["href"] = $foreign.href;
})(PS);
(function(exports) {
  "use strict";

  exports.location = function (window) {
    return function () {
      return window.location;
    };
  };

  exports.localStorage = function (window) {
    return function () {
      return window.localStorage;
    };
  };
})(PS["Web.HTML.Window"] = PS["Web.HTML.Window"] || {});
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Web.HTML.Window"] = $PS["Web.HTML.Window"] || {};
  var exports = $PS["Web.HTML.Window"];
  var $foreign = $PS["Web.HTML.Window"];
  var Unsafe_Coerce = $PS["Unsafe.Coerce"];
  var toEventTarget = Unsafe_Coerce.unsafeCoerce;
  exports["toEventTarget"] = toEventTarget;
  exports["location"] = $foreign.location;
  exports["localStorage"] = $foreign.localStorage;
})(PS);
(function($PS) {
  // Generated by purs version 0.14.2
  "use strict";
  $PS["Gargantext.Utils"] = $PS["Gargantext.Utils"] || {};
  var exports = $PS["Gargantext.Utils"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Either = $PS["Data.Either"];
  var Data_Eq = $PS["Data.Eq"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Sequence_Ordered = $PS["Data.Sequence.Ordered"];
  var Data_Set = $PS["Data.Set"];
  var Data_Show = $PS["Data.Show"];
  var Data_String_CodePoints = $PS["Data.String.CodePoints"];
  var Data_String_CodeUnits = $PS["Data.String.CodeUnits"];
  var Data_String_Common = $PS["Data.String.Common"];
  var Data_String_Pattern = $PS["Data.String.Pattern"];
  var Web_HTML = $PS["Web.HTML"];
  var Web_HTML_Location = $PS["Web.HTML.Location"];
  var Web_HTML_Window = $PS["Web.HTML.Window"];                
  var On = (function () {
      function On(value0, value1) {
          this.value0 = value0;
          this.value1 = value1;
      };
      On.create = function (value0) {
          return function (value1) {
              return new On(value0, value1);
          };
      };
      return On;
  })();
  var zeroPad = function (pad) {
      return function (num) {
          var zeros$prime = function (v) {
              if (v === 0) {
                  return "";
              };
              return "0" + zeros$prime(v - 1 | 0);
          };
          var numDigits = Data_String_CodePoints.length(Data_Show.show(Data_Show.showInt)(num));
          var zeros = (function () {
              var $25 = numDigits < pad;
              if ($25) {
                  return zeros$prime(pad - numDigits | 0);
              };
              return "";
          })();
          return zeros + Data_Show.show(Data_Show.showInt)(num);
      };
  };
  var toggleSet = function (dictOrd) {
      return function (a) {
          return function (s) {
              if (Data_Set.member(dictOrd)(a)(s)) {
                  return Data_Set["delete"](dictOrd)(a)(s);
              };
              if (Data_Boolean.otherwise) {
                  return Data_Set.insert(dictOrd)(a)(s);
              };
              throw new Error("Failed pattern match at Gargantext.Utils (line 46, column 1 - line 46, column 52): " + [ a.constructor.name, s.constructor.name ]);
          };
      };
  };
  var queryMatchesLabel = function (q) {
      return function (l) {
          return Data_String_CodeUnits.contains(Data_String_Pattern.Pattern(Data_String_Common.toLower(q)))(Data_String_Common.toLower(l));
      };
  };
  var mapLeft = function (v) {
      return function (v1) {
          if (v1 instanceof Data_Either.Left) {
              return new Data_Either.Left(v(v1.value0));
          };
          if (v1 instanceof Data_Either.Right) {
              return new Data_Either.Right(v1.value0);
          };
          throw new Error("Failed pattern match at Gargantext.Utils (line 82, column 1 - line 82, column 62): " + [ v.constructor.name, v1.constructor.name ]);
      };
  };
  var href = function __do() {
      var w = Web_HTML.window();
      var loc = Web_HTML_Window.location(w)();
      return Web_HTML_Location.href(loc)();
  };
  var glyphicon = function (t) {
      return "btn glyphitem fa fa-" + t;
  };
  var glyphiconActive = function (icon) {
      return function (b) {
          return glyphicon(icon) + (function () {
              if (b) {
                  return " active";
              };
              return "";
          })();
      };
  };
  var csrfMiddlewareToken = "Wy52D2nor8kC1r1Y4GrsrSIxQ2eqW8UwkdiQQshMoRwobzU4uldknRUhP0j4WcEM";
  var $dollar_EqOn_11 = function (dictEq) {
      return new Data_Eq.Eq(function (v) {
          return function (v1) {
              return Data_Eq.eq(dictEq)(v.value0)(v1.value0);
          };
      });
  };
  var $dollar_OrdOn_12 = function (dictOrd) {
      return new Data_Ord.Ord(function () {
          return $dollar_EqOn_11(dictOrd.Eq0());
      }, function (v) {
          return function (v1) {
              return Data_Ord.compare(dictOrd)(v.value0)(v1.value0);
          };
      });
  };
  var sortWith = function (dictFunctor) {
      return function (dictFoldable) {
          return function (dictUnfoldable) {
              return function (dictOrd) {
                  return function (f) {
                      var $54 = Data_Functor.map(dictFunctor)(function (v) {
                          return v.value1;
                      });
                      var $55 = Data_Sequence_Ordered.toUnfoldable(dictFunctor)(dictUnfoldable);
                      var $56 = Data_Foldable.foldr(dictFoldable)(function (x) {
                          return Data_Sequence_Ordered.insert($dollar_OrdOn_12(dictOrd))(new On(f(x), x));
                      })(Data_Sequence_Ordered.empty);
                      return function ($57) {
                          return $54($55($56($57)));
                      };
                  };
              };
          };
      };
  };
  exports["csrfMiddlewareToken"] = csrfMiddlewareToken;
  exports["toggleSet"] = toggleSet;
  exports["glyphicon"] = glyphicon;
  exports["glyphiconActive"] = glyphiconActive;
  exports["zeroPad"] = zeroPad;
  exports["queryMatchesLabel"] = queryMatchesLabel;
  exports["mapLeft"] = mapLeft;
  exports["sortWith"] = sortWith;
  exports["href"] = href;
})(PS);
(function($PS) {
  "use strict";
  $PS["Gargantext.Utils.JSON"] = $PS["Gargantext.Utils.JSON"] || {};
  var exports = $PS["Gargantext.Utils.JSON"];
  var Control_Applicative = $PS["Control.Applicative"];
  var Control_Bind = $PS["Control.Bind"];
  var Control_Monad_Except = $PS["Control.Monad.Except"];
  var Control_Monad_Except_Trans = $PS["Control.Monad.Except.Trans"];
  var Data_Boolean = $PS["Data.Boolean"];
  var Data_Foldable = $PS["Data.Foldable"];
  var Data_Functor = $PS["Data.Functor"];
  var Data_Identity = $PS["Data.Identity"];
  var Data_Int = $PS["Data.Int"];
  var Data_List = $PS["Data.List"];
  var Data_List_Types = $PS["Data.List.Types"];
  var Data_Map_Internal = $PS["Data.Map.Internal"];
  var Data_Maybe = $PS["Data.Maybe"];
  var Data_Ord = $PS["Data.Ord"];
  var Data_Sequence = $PS["Data.Sequence"];
  var Data_Traversable = $PS["Data.Traversable"];
  var Data_TraversableWithIndex = $PS["Data.TraversableWithIndex"];
  var Data_Tuple = $PS["Data.Tuple"];
  var Data_Unfoldable = $PS["Data.Unfoldable"];
  var Foreign = $PS["Foreign"];
  var Foreign_Object = $PS["Foreign.Object"];
  var Simple_JSON = $PS["Simple.JSON"];                
  var writeSequence = function (dictWriteForeign) {
      return function (xs) {
          return Foreign.unsafeToForeign(Data_Functor.map(Data_Sequence.functorSeq)(Simple_JSON.writeImpl(dictWriteForeign))(xs));
      };
  };
  var writeList = function (dictWriteForeign) {
      return function (xs) {
          return Foreign.unsafeToForeign(Data_Functor.map(Data_List_Types.functorList)(Simple_JSON.writeImpl(dictWriteForeign))(xs));
      };
  };
  var readSequence = function (dictReadForeign) {
      return function (f) {
          var readAtIdx = function (i) {
              return function (f$prime) {
                  return Control_Monad_Except.withExcept(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Foreign.ErrorAtIndex.create(i)))(Simple_JSON.readImpl(dictReadForeign)(f$prime));
              };
          };
          return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Foreign.readArray(Data_Identity.monadIdentity)(f))(function (arr) {
              return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_TraversableWithIndex.traverseWithIndex(Data_TraversableWithIndex.traversableWithIndexArray)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(readAtIdx)(arr))(function (y) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Sequence.fromFoldable(Data_Foldable.foldableArray)(y));
              });
          });
      };
  };
  var readMapInt = function (dictReadForeign) {
      return function (f) {
          var readObject$prime = function (value) {
              if (Foreign.tagOf(value) === "Object") {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Foreign.unsafeFromForeign(value));
              };
              if (Data_Boolean.otherwise) {
                  return Foreign.fail(Data_Identity.monadIdentity)(Foreign.TypeMismatch.create("Object")(Foreign.tagOf(value)));
              };
              throw new Error("Failed pattern match at Gargantext.Utils.JSON (line 57, column 5 - line 57, column 56): " + [ value.constructor.name ]);
          };
          return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(readObject$prime(f))(function (v) {
              var v1 = Data_Functor.map(Data_Functor.functorArray)(function (v2) {
                  var v4 = Data_Int.fromString(v2.value0);
                  if (v4 instanceof Data_Maybe.Nothing) {
                      return Foreign.fail(Data_Identity.monadIdentity)(Foreign.ErrorAtProperty.create(v2.value0)(new Foreign.ForeignError("Cannot convert to int")));
                  };
                  if (v4 instanceof Data_Maybe.Just) {
                      return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Simple_JSON.readImpl(dictReadForeign)(v2.value1))(function (v$prime) {
                          return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(new Data_Tuple.Tuple(v4.value0, v$prime));
                      });
                  };
                  throw new Error("Failed pattern match at Gargantext.Utils.JSON (line 48, column 47 - line 52, column 71): " + [ v4.constructor.name ]);
              })(Foreign_Object.toUnfoldable(Data_Unfoldable.unfoldableArray)(v));
              return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_Traversable.sequence(Data_Traversable.traversableArray)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(v1))(function (seq) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_Map_Internal.fromFoldable(Data_Ord.ordInt)(Data_Foldable.foldableArray)(seq));
              });
          });
      };
  };
  var readList = function (dictReadForeign) {
      return function (f) {
          var readAtIdx = function (i) {
              return function (f$prime) {
                  return Control_Monad_Except.withExcept(Data_Functor.map(Data_List_Types.functorNonEmptyList)(Foreign.ErrorAtIndex.create(i)))(Simple_JSON.readImpl(dictReadForeign)(f$prime));
              };
          };
          return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Foreign.readArray(Data_Identity.monadIdentity)(f))(function (arr) {
              return Control_Bind.bind(Control_Monad_Except_Trans.bindExceptT(Data_Identity.monadIdentity))(Data_TraversableWithIndex.traverseWithIndex(Data_TraversableWithIndex.traversableWithIndexArray)(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(readAtIdx)(arr))(function (y) {
                  return Control_Applicative.pure(Control_Monad_Except_Trans.applicativeExceptT(Data_Identity.monadIdentity))(Data_List.fromFoldable(Data_Foldable.foldableArray)(y));
              });
          });
      };
  };
  exports["readSequence"] = readSequence;
  exports["writeSequence"] = writeSequence;
  exports["readList"] = readList;
  exports["writeList"] = writeList;
  exports["readMapInt"] = readMapInt;
})(PS);
(function(exports) {
  'use strict';

  function addRootElement(rootElem) {
    document.body.insertBefore(
      rootElem,
      document.body.lastElementChild.nextElementSibling
    );
  }

  function getSelection(_u) {
    return window.getSelection();
  }

  function stringify(j, indent) {
    return JSON.stringify(j, null, indent);
  }

  function postMessage(obj, msg, src) {
      obj.contentWindow.postMessage(msg, src);
  }

  function setCookie(c) {
    document.cookie = c;
  }

  function domRectFromRect(obj) {
    return DOMRectReadOnly.fromRect(obj)
  }                                    
  exports._stringify = 