{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}

module Gargantext.API.Routes.Named.Share (
  -- * Routes types
    ShareNode(..)
  , Unpublish(..)
  , ShareURL(..)

  -- * API types (which appears in the routes)
  , ShareNodeParams(..)
  ) where

import Data.Aeson
import Data.Swagger
import Data.Text (Text)
import GHC.Generics
import Gargantext.Database.Admin.Types.Node
import Gargantext.Utils.Aeson qualified as GUA
import Prelude
import Servant
import Test.QuickCheck

newtype ShareURL mode = ShareURL
  { shareUrlEp :: mode :- Summary "Fetch URL for sharing a node"
                       :> QueryParam "type" NodeType
                       :> QueryParam "id" NodeId
                       :> Get '[JSON] Text
  } deriving Generic


newtype ShareNode mode = ShareNode
  { shareNodeEp :: mode :- Summary " Share Node with username"
                        :> ReqBody '[JSON] ShareNodeParams
                        :> Post    '[JSON] Int
  } deriving Generic


newtype Unpublish mode = Unpublish
  { unpublishEp :: mode :- Summary " Unpublish Node" :> Capture "node_id" NodeId :> Put '[JSON] Int
  } deriving Generic

--
-- API Types
--
data ShareNodeParams = ShareTeamParams   { username :: Text  }
                     | SharePublicParams { node_id  :: NodeId }
  deriving (Generic)

--
-- Instances
--

-- TODO unPrefix "pn_" FromJSON, ToJSON, ToSchema, adapt frontend.
instance FromJSON  ShareNodeParams where
  parseJSON = genericParseJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })
instance ToJSON    ShareNodeParams where
  toJSON = genericToJSON (defaultOptions { sumEncoding = GUA.defaultTaggedObject })
instance ToSchema  ShareNodeParams
instance Arbitrary ShareNodeParams where
  arbitrary = elements [ ShareTeamParams "user1"
                       , SharePublicParams (UnsafeMkNodeId 1)
                       ]
