{-|
Module      : Gargantext.Core.Text.Convert
Description : All parsers of Gargantext in one file.
Copyright   : (c) CNRS, 2017
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Format Converter.

-}

{-# LANGUAGE PackageImports    #-}

module Gargantext.Core.Text.Convert (risPress2tsvWrite)
    where

import Gargantext.Core.Text.Corpus.Parsers (parseFile, FileFormat(..), FileType(..))
import Gargantext.Core.Text.Corpus.Parsers.TSV (writeDocs2Tsv)
import Gargantext.Prelude


risPress2tsvWrite :: FilePath -> IO ()
risPress2tsvWrite f = do
  eContents <- parseFile RisPresse Plain (f <> ".ris")
  case eContents of
    Right contents -> writeDocs2Tsv (f <> ".csv") contents
    Left e         -> panicTrace $ "Error: " <> e



