{-|
Module      : Parsers.Date
Description : 
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Here is a longer description of this module, containing some
commentary with @some markup@.
-}


module Test.Parsers.Date where


import Test.Hspec

import Data.Time.Clock (UTCTime(..), secondsToDiffTime)
import Data.Time.Calendar.OrdinalDate (fromOrdinalDate)

-----------------------------------------------------------
import Gargantext.Prelude
import Gargantext.Core.Text.Corpus.Parsers.Date (dateSplit)

-----------------------------------------------------------

testDateSplit :: Spec
testDateSplit = do
  describe "Test date split" $ do
    it "works for simple date parsing" $ do
      let utc = UTCTime { utctDay = fromOrdinalDate 2010 4
                        , utctDayTime = secondsToDiffTime 0 }
      dateSplit "2010-01-04" `shouldBe` Right (utc, (2010, 1, 4))

    it "throws error for year-month" $ do
      dateSplit "2010-01" `shouldSatisfy` isLeft
