
{-# LANGUAGE TypeOperators #-}
{-# LANGUAGE DeriveGeneric #-}

module Gargantext.API.Routes.Named where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Auth (ForgotPasswordAsyncParams)
import Gargantext.API.Admin.Auth.Types
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Routes.Named.Public
import Gargantext.API.Routes.Named.Private
import Servant.API ((:>), (:-), JSON, ReqBody, Post, Get, QueryParam)
import Servant.API.Description (Summary)
import Servant.API.NamedRoutes

type GargAPI = NamedRoutes (MkGargAPI (GargAPIVersion GargAPI'))


data MkGargAPI sub mode = MkGargAPI
  { mkGargAPI :: mode :- "api" :> Summary "API " :> NamedRoutes sub
  } deriving Generic


data GargAPIVersion sub mode = GargAPIVersion
  { gargAPIVersion :: mode :- "v1.0" :> Summary "Garg API Version " :> NamedRoutes sub
  } deriving Generic


data GargAPI' mode = GargAPI'
  { gargAuthAPI                :: mode :- NamedRoutes AuthAPI
  , gargForgotPasswordAPI      :: mode :- "forgot-password" :> NamedRoutes ForgotPasswordAPI
  , gargForgotPasswordAsyncAPI :: mode :- "async" :> "forgot-password" :> NamedRoutes ForgotPasswordAsyncAPI
  , gargVersionAPI             :: mode :- NamedRoutes GargVersion
  , gargPrivateAPI             :: mode :- NamedRoutes GargPrivateAPI
  , gargPublicAPI              :: mode :- "public" :> NamedRoutes GargPublicAPI
  } deriving Generic


data AuthAPI mode = AuthAPI
  { authEp :: mode :- "auth"  :> Summary "AUTH API"
                              :> ReqBody '[JSON] AuthRequest
                              :> Post    '[JSON] AuthResponse
  } deriving Generic


data ForgotPasswordAPI mode = ForgotPasswordAPI
  { forgotPasswordPostEp :: mode :- Summary "Forgot password POST API"
                                 :> ReqBody '[JSON] ForgotPasswordRequest
                                 :> Post '[JSON] ForgotPasswordResponse
  , forgotPasswordGetEp  :: mode :- Summary "Forgot password GET API"
                                 :> QueryParam "uuid" Text
                                 :> Get '[JSON] ForgotPasswordGet
  } deriving Generic


data ForgotPasswordAsyncAPI mode = ForgotPasswordAsyncAPI
  { forgotPasswordAsyncEp :: mode :- Summary "Forgot password asnc"
                                  :> AsyncJobs JobLog '[JSON] ForgotPasswordAsyncParams JobLog
  } deriving Generic


data GargVersion mode = GargVersion
  { gargVersionEp :: "version" :> Summary "Backend version" :> Get '[JSON] Text
  } deriving Generic
