Editor Setup
=============

This document tells you how to turn VSCodium into a Haskell integrated
development environment (IDE). Hopefully, the process looks roughly the same
with any editor that supports the language server protocol (LSP).

1. Install [the VSCodium editor](https://vscodium.com/#install)
2. Install [direnv](https://direnv.net/docs/installation.html) on your system
3. Install [GHCup](https://www.haskell.org/ghcup/install/).
   During the installation process, it will ask you whether to install
   haskell-language-server (HLS); accept.
4. Install the following VSCodium extensions using VSCodium's built-in
   package manager (the "Extensions" tab on the left):
   - [direnv](https://open-vsx.org/vscode/item?itemName=mkhl.direnv).
     Warning: there are several extensions with that name; choose the one by `mkhl`
   - [Haskell](https://open-vsx.org/vscode/item?itemName=haskell.haskell)

Restart VSCodium, open the `haskell-gargantext` project. Wait a few seconds;
you might get a popup telling you that GHCup needs to download some version
of GHC; accept.

Now *if everything went well*, you should have Haskell intellisense working
in your editor: hover over a symbol to get its type and documentation,
right-click a symbol and click "Jump to definition" to jump to its definition,
etc.

Sadly, there is a good chance that something did go wrong. To help you
troubleshoot, here's a rundown of what should have happened under the hood when
you opened the project — assuming I didn't misunderstand anything:
1. The `direnv` extension sees the `.envrc` file at the root of the project,
   and sets the environment variables accordingly (all `.envrc` actually says
   is to use a Nix shell).
2. The `haskell` extension looks up what version of GHC is needed and tells that
   to GHCup.
3. If needed, GHCup downloads the right version of GHC for the project and adds
   it to its collection of GHC compilers in `~/.ghcup/ghc/`
4. Now the `haskell` extension has everything it needs.

Things to try if something goes wrong
--------------------------------------

- Make sure that you have compiled the project before.

- The current HLS version might be too recent to work with your GHC version.
  To check that and use an adequate HLS version:
  - Check out the project's GHC version around the beginning of `cabal.project`;
  - Look up the corresponding "Last supporting HLS version" in [this table](https://haskell-language-server.readthedocs.io/en/latest/support/ghc-version-support.html#current-ghc-version-support-status).
    For instance, if the project's GHC version is 9.4.7, you need HLS v2.5.0.0 *at most*.
  - Tell GHCup to compile the corresponding version of HLS based the corresponding version of GHC,
    with the following command (again, using GHC 9.4.7 as an example):
    ```shell
    $ ghcup compile hls --version 2.5.0.0 --ghc 9.4.7
    ```
  Now in principle the VSCodium `haskell` extension should have everything
  it needs to provide Intellisense.
