{-|
Module      : Core.AsyncUpdates
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.AsyncUpdates
  ( test
  , qcTests )
where

import Data.Aeson qualified as A
import Gargantext.Core.AsyncUpdates.CentralExchange.Types
import Gargantext.Core.AsyncUpdates.Dispatcher.Types
import Gargantext.Prelude
import Test.Hspec
import Test.Instances ()
import Test.Tasty
import Test.Tasty.QuickCheck qualified as QC


test :: Spec
test = do
  describe "check if json serialization of CEMessage works" $ do
    it "UpdateTreeFirstLevel serialization" $ do
      let ce = UpdateTreeFirstLevel 15
      A.decode (A.encode ce) `shouldBe` (Just ce)

qcTests :: TestTree
qcTests =
  testGroup "Notifications QuickCheck tests" $ do
    [ QC.testProperty "CEMessage aeson encoding" $ \m -> A.decode (A.encode (m :: CEMessage)) == Just m
      , QC.testProperty "Topic aeson encoding" $ \t -> A.decode (A.encode (t :: Topic)) == Just t
      , QC.testProperty "Message aeson encoding" $ \m -> A.decode (A.encode (m :: Message)) == Just m
      , QC.testProperty "WSRequest aeson encoding" $ \ws -> A.decode (A.encode (ws :: WSRequest)) == Just ws ]
