{-|
Module      : Gargantext.API.Node.Get
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

Polymorphic Get Node API

-}

{-# OPTIONS_GHC -fno-warn-deprecations #-}

{-# LANGUAGE TemplateHaskell    #-}
{-# LANGUAGE TypeOperators      #-}

module Gargantext.API.Node.Get
      where

import Data.Aeson
import Data.Swagger
import Gargantext.Database.Admin.Types.Node
import Gargantext.Prelude
import Test.QuickCheck.Arbitrary

------------------------------------------------------------------------
data GetNodeParams = GetNodeParams { node_id  :: NodeId 
                                   , nodetype :: NodeType
                                   }
    deriving (Generic)

------------------------------------------------------------------------
instance FromJSON  GetNodeParams where
  parseJSON = genericParseJSON (defaultOptions { sumEncoding = ObjectWithSingleField })

instance ToJSON    GetNodeParams where
  toJSON = genericToJSON (defaultOptions { sumEncoding = ObjectWithSingleField })
  
instance ToSchema  GetNodeParams
instance Arbitrary GetNodeParams where
  arbitrary = GetNodeParams <$> arbitrary <*> arbitrary

------------------------------------------------------------------------
