{-|
Module      : Gargantext.API..Types
Description : Ngrams List Types
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

{-# OPTIONS_GHC -fprint-potential-instances #-}
{-# OPTIONS_GHC -Wno-orphans #-}

module Gargantext.API.Types where

import Data.Aeson
import Data.Either (Either(..))
import Data.List.NonEmpty (NonEmpty ((:|)))
import Data.Text (Text)
import Data.Typeable
import Gargantext.API.Ngrams.Types ()
import Gargantext.API.Node.Document.Export.Types ()
import Gargantext.Core.Viz.Graph.Types (Graph(..))
import Network.HTTP.Media ((//), (/:))
import Prelude (($))
import Servant.API.ContentTypes ( Accept(..) , MimeRender(..) , MimeUnrender(..) )
import Servant.HTML.Blaze qualified as Blaze
import Servant.Swagger.UI.Core
import Servant.XML.Conduit qualified as S
import qualified Data.ByteString.Lazy.Char8 as BS8
import qualified Data.Text.Encoding as E
import qualified Prelude

data HTML deriving (Typeable)
instance Accept HTML where
  contentTypes _ = "text" // "html" /: ("charset", "utf-8") :| ["text" // "html"]
instance MimeRender HTML BS8.ByteString where
  mimeRender _ = Prelude.id
instance MimeUnrender HTML BS8.ByteString where
    mimeUnrender _ bs = Right bs
instance MimeRender HTML Text where
    mimeRender _ bs = BS8.fromStrict $ E.encodeUtf8 bs
instance MimeUnrender HTML Text where
    mimeUnrender _ bs = Right $ E.decodeUtf8 $ BS8.toStrict bs
instance {-# OVERLAPPABLE #-} ToJSON a => MimeRender HTML a where
  mimeRender _ = encode
instance MimeUnrender Blaze.HTML (SwaggerUiHtml dir api) where
  mimeUnrender _ bs = Right (SwaggerUiHtml $ E.decodeUtf8 $ BS8.toStrict bs)
instance MimeUnrender S.XML Graph where
  mimeUnrender _ = eitherDecode
