{-|
Module      : Core.AsyncUpdates
Description :
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

-}

module Test.Core.AsyncUpdates where

import Data.Aeson qualified as A
import Gargantext.Core.AsyncUpdates.CentralExchange.Types
import Gargantext.Prelude
import Test.Hspec

test :: Spec
test = do
  describe "check if json serialization of CEMessage works" $ do
    it "UpdateTreeFirstLevel serialization" $ do
      let ce = UpdateTreeFirstLevel 15
      A.decode (A.encode ce) `shouldBe` (Just ce)
