/**
 * Sigma.js WebGL Renderer Node Program
 * =====================================
 *
 * Simple program rendering nodes as triangles.
 * It does not extend AbstractNodeProgram, which works very differently, and
 * really targets the gl.POINTS drawing methods.
 * @module
 */

import { NodeDisplayData } from "sigma/types";
import { floatColor } from "sigma/utils";
import TriangleProgram from "./sigmajs-triangle-abstract";

const POINTS = 12;
const ATTRIBUTES = 5;

const ANGLE_1_1 = - (1 * Math.PI) / 4;
const ANGLE_1_2 =   (1 * Math.PI) / 4;
const ANGLE_1_3 =   (3 * Math.PI) / 4;
const ANGLE_2_1 =   (3 * Math.PI) / 4;
const ANGLE_2_2 =   (5 * Math.PI) / 4;
const ANGLE_2_3 =   (7 * Math.PI) / 4;

export default class NodeProgram extends TriangleProgram {
  constructor(gl) {
    super(gl, POINTS, ATTRIBUTES);
  }

  triangleDefinitions(data) {
    const gray = '#aaa';
    const size = data.size / 1.7;  // experimental...
    const contourSize = size + 0.8;  // experimental...

    return [ { x: data.x, y: data.y, size: contourSize, color: gray, angles: [ANGLE_1_1, ANGLE_1_2, ANGLE_1_3] },
             { x: data.x, y: data.y, size: contourSize, color: gray, angles: [ANGLE_2_1, ANGLE_2_2, ANGLE_2_3] },
             { x: data.x, y: data.y, size: size, color: data.color, angles: [ANGLE_1_1, ANGLE_1_2, ANGLE_1_3] },
             { x: data.x, y: data.y, size: size, color: data.color, angles: [ANGLE_2_1, ANGLE_2_2, ANGLE_2_3] } ];
  }
}
