{-|
Module      : Gargantext.API.Node.Phylo.Export.Types
Description : Types for Gargantext.API.Node.Phylo.Export
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE TypeOperators   #-}

module Gargantext.API.Node.Phylo.Export.Types where

import Data.Aeson (ToJSON, encode)
import Data.Aeson.TH (deriveJSON)
-- import Data.Csv (DefaultOrdered(..), ToNamedRecord(..), (.=), header, namedRecord)
import Data.Swagger ( genericDeclareNamedSchema, ToParamSchema(..), ToSchema(..) )
-- import Data.Text qualified as T
-- import Data.Text.Encoding qualified as TE
import Gargantext.Core.Types ( Node, TODO )
import Gargantext.Core.Utils.Prefix (unPrefix, unPrefixSwagger)
import Gargantext.Database.Admin.Types.Hyperdata.Phylo ( HyperdataPhylo(..) )
import Gargantext.Database.Admin.Types.Node (PhyloId)
-- import Gargantext.Database.Schema.Node (NodePoly(..))
-- import Gargantext.Utils.Servant (ZIP)
-- import Gargantext.Utils.Zip (zipContentsPure)
import Protolude
import Servant ((:>), (:<|>), Get, Header, Headers(..), JSON, MimeRender(..), Summary) --, PlainText


-- | Phylo Export
data PhyloExport =
  PhyloExport { _pe_phylos    :: [Phylo]
              , _pe_garg_version :: Text
              } deriving (Generic)

-- | This is to represent a zipped phylo export. We want to have doc_id in zipped file name.
data PhyloExportDOT =
  PhyloExportDOT  { _ped_dexp   :: PhyloExport
                  , _ped_doc_id :: PhyloId 
                  } deriving (Generic)

data PhyloExportJSON = 
  PhyloExportJSON { _pej_pexp     :: PhyloExport
                  , _pej_phy_id   :: PhyloId
                  } deriving (Generic)
    
    
data Phylo =
  Phylo { _p_phylo    :: Node HyperdataPhylo
        , _p_hash     :: Hash
        } deriving (Generic)

--instance Read Phylo where
--  read "" = panic "not implemented"
-- instance DefaultOrdered Phylo where
--   headerOrder _ = header ["Publication Day"
--                          , "Publication Month"
--                          , "Publication Year"
--                          , "Authors"
--                          , "Title"
--                          , "Source"
--                          , "Abstract"]
-- instance ToNamedRecord Phylo where
--   toNamedRecord (Phylo { _p_phylo = Node { .. }}) =
--     namedRecord
--     [ "Publication Day" .= _hd_publication_day _node_hyperdata
--     , "Publication Month" .= _hd_publication_month _node_hyperdata
--     , "Publication Year" .= _hd_publication_year _node_hyperdata
--     , "Authors" .= _hd_authors _node_hyperdata
--     , "Title" .= _hd_title _node_hyperdata
--     , "Source" .= (TE.encodeUtf8 <$> _hd_source _node_hyperdata)
--     , "Abstract" .= (TE.encodeUtf8 <$> _hd_abstract _node_hyperdata) ]


type Hash = Text
-------
instance ToSchema PhyloExport where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_pe_")

instance ToSchema PhyloExportDOT where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_ped_")
  
instance ToSchema Phylo where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_p_")


-------
instance ToParamSchema PhyloExport where
  toParamSchema _ = toParamSchema (Proxy :: Proxy TODO)

instance ToParamSchema PhyloExportDOT where
  toParamSchema _ = toParamSchema (Proxy :: Proxy TODO)

instance ToParamSchema Phylo where
  toParamSchema _ = toParamSchema (Proxy :: Proxy TODO)

--------------------------------------------------
type API = Summary "Phylo Export"
            :> "export"
            :> ( "json"
                 :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] User)
               :<|> "dot"
                 :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] User)
                )

data User = User
  { _us_name :: Text
  , _us_age :: Int
  , _us_email :: Text
  } deriving (Eq, Show, Generic)

instance ToJSON User

instance ToSchema User where
  declareNamedSchema = genericDeclareNamedSchema (unPrefixSwagger "_us_")

instance ToParamSchema User where
  toParamSchema _ = toParamSchema (Proxy :: Proxy TODO)

instance MimeRender JSON User where
  mimeRender _ = encode

$(deriveJSON (unPrefix "_p_") ''Phylo)
$(deriveJSON (unPrefix "_pe_") ''PhyloExport)


------

-- Needs to be here because of deriveJSON TH above

-- pedFileName :: PhyloExportDOT -> Text
-- pedFileName (PhyloExportDOT { .. }) = "GarganText_DocsList-" <> show _ped_doc_id <> ".dot"
    
-- instance MimeRender ZIP PhyloExportDOT where
--   mimeRender _ dexpz@(PhyloExportDOT { .. }) =
--     zipContentsPure (T.unpack $ pedFileName dexpz) (encode _ped_dexp)
