{-# LANGUAGE DeriveGeneric #-}
{-# LANGUAGE TypeOperators #-}
module Gargantext.API.Routes.Named.Public where

import GHC.Generics
import Gargantext.API.Public qualified as Public
import Gargantext.API.Routes.Named.File
import Gargantext.Database.Admin.Types.Node ( NodeId )
import Servant.API

data GargPublicAPI mode = GargPublicAPI
  { publicHomeAPI :: mode :- NamedRoutes HomeAPI
  , publicNodeAPI :: mode :- NamedRoutes NodeAPI
  } deriving Generic

data HomeAPI mode = HomeAPI
  { homeEp :: mode :- Summary "Public Home API" :> Get '[JSON] [Public.PublicData]
  } deriving Generic

data NodeAPI mode = NodeAPI
  { nodeEp :: mode :- Summary "Public Node API" :> Capture "node" NodeId :> "file" :> NamedRoutes FileAPI
  } deriving Generic
