{-|
Module      : Gargantext.API.WebSockets
Description : WebSockets API
Copyright   : (c) CNRS, 2024-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX
-}

{-# LANGUAGE TypeOperators #-}

module Gargantext.API.WebSockets
where

import Data.Text (pack)
import Network.WebSockets (PendingConnection, acceptRequest, sendTextData, withPingThread)
import Protolude
import Servant
import Servant.API.WebSocket qualified as WS


type API = "ws" :> WS.WebSocketPending

server :: Server API
server = streamData
 where
  streamData :: MonadIO m => PendingConnection -> m ()
  streamData pc = do
    c <- liftIO $ acceptRequest pc
    liftIO $ withPingThread c 10 (pure ()) $ do
      forM_ [1..] $ \i -> do
        sendTextData c (pack $ show (i :: Int)) >> threadDelay (1*ms)
  ms = 1000000
