module Gargantext.Utils.EtherCalc where

import Affjax.Web (Error, Response, defaultRequest, request)
import Affjax.ResponseFormat as ResponseFormat
import Data.Either (Either(..))
import Data.HTTP.Method (Method(GET))
import Effect.Aff (Aff)
import Gargantext.Prelude

type Base = String
type NodeId = String

downloadTSV :: Base -> NodeId -> Aff (Either Error (Response String))
downloadTSV base nodeId = do
  let req = defaultRequest
            { url = base <> "/" <> nodeId <> ".tsv"
            , responseFormat = ResponseFormat.string
            , method = Left GET }
  request req
