{-|
Module      : Gargantext.Core.AsyncUpdates.CentralExchange.Types
Description : Types for asynchronous notifications (central exchange)
Copyright   : (c) CNRS, 2017-Present
License     : AGPL + CECILL v3
Maintainer  : team@gargantext.org
Stability   : experimental
Portability : POSIX

https://gitlab.iscpif.fr/gargantext/haskell-gargantext/issues/341

Docs:
https://dev.sub.gargantext.org/#/share/Notes/187918    
-}

module Gargantext.Core.AsyncUpdates.CentralExchange.Types where

import Data.Aeson ((.:), (.=), object, withObject)
import Data.Aeson.Types (prependFailure, typeMismatch)
import Gargantext.Core.Types (NodeId)
import Gargantext.Prelude
    
{-

Central exchange is a service, which gathers messages from various
places and informs the Dispatcher (which will then inform users about
various events).
    
-}

-- INTERNAL MESSAGES
data CEMessage =
  UpdateTreeFirstLevel NodeId
  deriving (Show, Eq)


instance FromJSON CEMessage where
  parseJSON = withObject "CEMessage" $ \o -> do
    type_ <- o .: "type"
    case type_ of
      "update_tree_first_level" -> do
        node_id <- o .: "node_id"
        pure $ UpdateTreeFirstLevel node_id
      s -> prependFailure "parsing type failed, " (typeMismatch "type" s)

instance ToJSON CEMessage where
  toJSON (UpdateTreeFirstLevel node_id) = object [
      "type"    .= toJSON ("update_tree_first_level" :: Text)
    , "node_id" .= toJSON node_id
    ]
