{ callPackage, openssl, python3, enableNpm ? true, nodejs, path }:

let
  buildNodejs = callPackage "${path}/pkgs/development/web/nodejs/nodejs.nix" {
    inherit openssl;
    python = python3;
  };

in
buildNodejs {
  inherit enableNpm;
  version = "20.3.1";
  sha256 = "sha256-EqgtswZpeVm0OJs1Gl+XhImGsTE/mQGw4LPYz08/mZE=";
  patches = [
    ./nodejs-patches/revert-arm64-pointer-auth.patch
    ./nodejs-patches/disable-darwin-v8-system-instrumentation-node19.patch
    ./nodejs-patches/bypass-darwin-xcrun-node16.patch
    ./nodejs-patches/node-npm-build-npm-package-logic.patch
  ];
}
