{-# LANGUAGE OverloadedStrings #-}

module Test.Offline.TomlConfig (tests) where

import Database.PostgreSQL.Simple qualified as PGS
import Gargantext.Database.Prelude
import Prelude
import Test.Tasty
import Test.Tasty.HUnit
import Test.Utils

tests :: TestTree
tests = testGroup "TomlConfig" [
  testGroup "Parsing" [
    testCase "databaseParameters can be parsed from Toml" test_databaseParameters
  ]
  ]

test_databaseParameters :: Assertion
test_databaseParameters = do
  params   <- databaseParameters "test-data/test_config.toml"
  PGS.connectPort params @??= 5432
