# GarganText "Code of Conduct"

The GarganText Project, the contributors of the GarganText eco-system,
have adopted a code of conduct for participants to any modes of
communication within the project.

## Be respectful

In a project the size of GarganText, inevitably there will be people
with whom you may disagree, or find it difficult to cooperate. Accept
that, but even so, remain respectful. Disagreement is no excuse for poor
behaviour or personal attacks, and a community in which people feel
threatened is not a healthy community.

## Assume good faith

GarganText Contributors have many ways of reaching our common goal of
a free digital ecosystem which may differ from your ways. Assume that
other people are working towards this goal.

Note that many of our Contributors are not native English speakers
or may have different cultural backgrounds.

## Be collaborative

GarganText is a large and complex project; there is always more to
learn within GarganText. It's good to ask for help when you need it.
Similarly, offers for help should be seen in the context of our shared
goal of improving GarganText.

When you make something for the benefit of the project, be willing
to explain to others how it works, so that they can build on your work
to make it even better.

## Try to be concise

Keep in mind that what you write once will be read by many others
persons. Writing a short email means people can understand the
conversation as efficiently as possible. When a long explanation is
necessary, consider adding a summary.

Try to bring new arguments to a conversation so that each comment
adds something unique to the thread, keeping in mind that the rest of
the thread still contains the other messages with arguments that have
already been made.

Try to stay on topic, especially in discussions that are already
fairly large.

## Be open

Most ways of communication used within GarganText allow for public and
private communication. You should preferably use public methods of
communication for GarganText-related messages, unless posting something
sensitive.

This applies to messages for help or GarganText-related support,
too; not only is a public support request much more likely to
result in an answer to your question, it also makes sure that any
inadvertent mistakes made by people answering your question will be
more easily detected and corrected.

While this code of conduct should be adhered to by participants,
we recognize that sometimes people may have a bad day, or be unaware
of some of the guidelines in this code of conduct. When that happens,
you may reply to them and point out this code of conduct. Such messages
may be in public or in private, whatever is most appropriate. However,
regardless of whether the message is public or not, it should still
adhere to the relevant parts of this code of conduct; in particular, it
should not be abusive or disrespectful. Assume good faith; it is more
likely that participants are unaware of their bad behaviour than that
they intentionally try to degrade the quality of the discussion.

Serious or persistent offenders will be temporarily or permanently
banned from communicating through GarganText's ecosystem. Complaints
should be made (in private) to the administrators of the GarganText
communication forum in question. To find contact information for these
administrators, please see the page on GarganText's organizational
structure.
