# coding: utf-8

import sys
import chardet
import csv
import re

def getSeparator(fileAddress):

    with open(fileAddress,"r", encoding='utf-8-sig') as file:
        line = file.readline()

        if ',' in line :
            return ','
        
        if ';' in line :
            return ';'
        
    return '\t'

def correctedSequence(text, separator):
    tmp = text.replace("\"", "\"\"")
    find = separator in text or "\"" in text or "\n" in text
    if find:
        if text[len(text) - 1] == "\n" :
            tmp = tmp[:-1]
        tmp = "\"" + tmp + "\""
    return tmp

def getValues(items):
    authors = items["Authors"]
    title = items["Title"]
    source = items["Source"]
    abstract = items["Abstract"]
    year = items["Year"]
    return authors, title, source, abstract, year

def tsvAddOthersColumns(tsv,fileName, separator):
    with open("csv/" + fileName, 'r') as file:
        reader = csv.DictReader(file, delimiter = separator)
        for row in reader:
            for name, value in row.items():
                name = name.replace("\ufeff", "")
                if name not in ["Authors", "Title", "Source", "Abstract", "Year"] :
                    tsv += "\t" + correctedSequence(name, separator)
            tsv += "\n" 
            break
    return tsv

def tsvAddOthers(tsv, items, separator):
    for name, value in items:
        if name not in ["Authors", "Title", "Source", "Abstract", "Year"] :
            tsv += "\t" + correctedSequence(value, separator)

def HarzingToTsv(fileName, separator):
    tsv = "authors\tsource\tpublication_year\tpublication_month\tpublication_day\ttitle\tabstract"
    tsv = tsvAddOthersColumns(tsv, fileName, separator)
    with open("csv/" + fileName, 'r') as file:
        reader = csv.DictReader(file, delimiter = separator)
        for row in reader:
            tmp = ""
            first = True
            authors, title, source, abstract, year = getValues(dict(row.items()))
            tsv += correctedSequence(authors, separator) + "\t" + correctedSequence(source, separator) + "\t" + year + "\t"+ "1" + "\t" + "1" + "\t"
            tsv += correctedSequence(title, separator) + "\t"
            last = len(row.items()) == 7 
            tsv +=  correctedSequence(abstract, separator)
            if last :
                tsv = tsvAddOthers(tsv, row.items(), separator)
            tsv += "\n"
    with open("tsv/" + fileName.replace(".csv", ".tsv"),"w", encoding='utf-8-sig') as file:
        file.write(tsv)
        print("Your tsv has been created successfully")


def main():

    if len(sys.argv) == 2:

        fileName = sys.argv[1]
        separator = getSeparator("csv/" + fileName)
        HarzingToTsv(fileName, separator)

if __name__ == '__main__':
    sys.exit(main()) 