import streamlit as st
import pandas as pd
from st_pages import show_pages_from_config, add_indentation


def base(page):

    st.set_page_config(
        page_title="GarganTools | " + page,
        page_icon="img/isc-pif_logo.png",
    )

    st.markdown(
        f'''
            <style>
                .reportview-container .sidebar-content {{
                    padding-top: {1}rem;
                }}
                .reportview-container .main .block-container {{
                    padding-top: {1}rem;
                }}
            </style>
            ''', unsafe_allow_html=True)

    # Load Banner image
    st.image('img/gargantool_banner.jpg')

    # Reduce size on border
    st.markdown("""
        <style>
               .block-container {
                    padding-top: 2rem;
                    padding-bottom: 0rem;
                    padding-left: 1rem;
                    padding-right: 1rem;
                }
        </style>
        """, unsafe_allow_html=True)

    # Load the language file

    def load_bundle(lang):
        df = pd.read_csv("lang/text_" + page + ".csv")
        df = df.query(f"locale == '{lang}'")

        tmp = {}
        for i in range(len(df)):
            tmp[df.key.to_list()[i]] = df.value.to_list()[i]
        return tmp

    # Load the language file
    def update_lang(lang):
        st.session_state.general_text_dict = load_bundle(lang)
        st.session_state.general_language = lang

    # Test if it's first connection on page or else if the last page was this one
    if 'general_session_page' not in st.session_state.keys():
        st.session_state.general_text_dict = load_bundle('fr')
        st.session_state.general_language = 'fr'
        st.session_state.general_session_page = page
        show_pages_from_config()

    elif st.session_state.general_session_page != page:
        st.session_state.general_text_dict = load_bundle(
            st.session_state.general_language)
        st.session_state.general_session_page = page
        show_pages_from_config()

        # Delete every key who aren't fron this file
        for key in st.session_state.keys():
            if 'general_' not in key:
                del st.session_state[key]

    add_indentation()
    # select the lang
    coltitle, col = st.columns([4, 1])
    with coltitle:
        st.write(st.session_state.general_text_dict['title'])
    with col:
        _, col1, col2 = st.columns([1, 1, 1])
        with col1:
            st.button(':fr:', on_click=update_lang, args=('fr',))
        with col2:
            st.button(':us:', on_click=update_lang, args=('en',))
