finalPkgs: previousPkgs: {
  # WARNING: the nixpkgs pinned brings igraph-0.10.7 not igraph-0.10.4
  # as expected by haskell-igraph-0.10.4
  # Note that igraph uses the lapack and blas alternative selector packages
  # which default to using openblas.
  igraph = (previousPkgs.igraph.override {
    # fop pulls openjdk, scipy, blas… just to build PDF docs,
    fop = null;
  }).overrideAttrs (previousAttrs: {
    cmakeFlags = previousAttrs.cmakeFlags ++ [
      # Disable Open Multi-Processing, to let GHC handle the kernel threads.
      "-DIGRAPH_OPENMP_SUPPORT=OFF"
    ];
  });
  # Dependency of igraph
  plfit = previousPkgs.plfit.overrideAttrs (previousAttrs: {
    cmakeFlags = previousAttrs.cmakeFlags ++ [
      # Disable Open Multi-Processing, to let GHC handle the kernel threads.
      "-DPLFIT_USE_OPENMP=OFF"
    ];
  });
}
