{-# LANGUAGE TemplateHaskell #-}
{-# LANGUAGE TypeOperators   #-}

module Gargantext.API.Routes.Named.Document (
  -- * Routes types
    DocumentsFromWriteNodesAPI(..)
  , DocumentUploadAPI(..)
  , DocumentExportAPI(..)
  , DocumentExportEndpoints(..)

  -- * API types
  , Params(..)
  , DocumentUpload(..)
  ) where

import Data.Text (Text)
import GHC.Generics
import Gargantext.API.Admin.Orchestrator.Types
import Gargantext.API.Node.Document.Export.Types
import Gargantext.API.Node.DocumentsFromWriteNodes.Types ( Params(..) )
import Gargantext.API.Node.DocumentUpload.Types ( DocumentUpload(..),  )
import Gargantext.Utils.Servant (ZIP)
import Servant

newtype DocumentExportAPI mode = DocumentExportAPI
  { documentExportAPI :: mode :- Summary "Document Export" :> "export" :> NamedRoutes DocumentExportEndpoints
  } deriving Generic

data DocumentExportEndpoints mode = DocumentExportEndpoints
  { exportJSONEp :: mode :- "json"
                         :> Get '[JSON] (Headers '[Servant.Header "Content-Disposition" Text] DocumentExport)
  , exportJSONZipEp :: mode :- "json.zip"
                            :> Get '[ZIP] (Headers '[Servant.Header "Content-Disposition" Text] DocumentExportZIP)
  , exportTSVEp :: mode :- "tsv"
                        :> Get '[PlainText] (Headers '[Servant.Header "Content-Disposition" Text] Text)
  } deriving Generic

newtype DocumentsFromWriteNodesAPI mode = DocumentsFromWriteNodesAPI
  { docFromWriteNodesEp :: mode :- Summary " Documents from Write nodes."
                                :> NamedRoutes (AsyncJobs JobLog '[JSON] Params JobLog)
  } deriving Generic


newtype DocumentUploadAPI mode = DocumentUploadAPI
  { uploadDocAsyncEp :: mode :- Summary " Document upload"
                             :> "document"
                             :> "upload"
                             :> "async"
                             :> NamedRoutes (AsyncJobs JobLog '[JSON] DocumentUpload JobLog)
  } deriving Generic
