{ lib, ... }:
{
  modules = [
    ({ pkgs, ... }: {
      # Start StanfordCoreNLPServer to pass the Hspec tests
      # Use `nix run` instead of `inputs.coreNLP` directly
      # to avoid downloading it if not running garg-test-hspec
      packages.gargantext.components.tests.garg-test-hspec.preCheck = ''
        export GARGANTEXT_CORENLP_SERVER="${pkgs.nixFlakes}/bin/nix run .#coreNLP"
      '';

      packages.gargantext.components.tests.garg-test-hspec.testFlags = [
        # FIXME:
        # test/Test/Database/Operations.hs:64:7:
        # 1) Database.Read/Writes, Corpus creation, Can add documents to a Corpus
        #      uncaught exception: HttpException
        #      HttpExceptionRequest Request {
        #        host                 = "localhost"
        #        port                 = 9000
        #        secure               = False
        #        requestHeaders       = [("Accept","application/json")]
        #        path                 = "/"
        #        queryString          = "?properties=%7B%22annotators%22:%22tokenize,ssplit,pos,ner%22,%22outputFormat%22:%22json%22%7D"
        #        method               = "POST"
        #        proxy                = Nothing
        #        rawBody              = False
        #        redirectCount        = 10
        #        responseTimeout      = ResponseTimeoutDefault
        #        requestVersion       = HTTP/1.1
        #        proxySecureMode      = ProxySecureWithConnect
        #      }
        #       (ConnectionFailure Network.Socket.connect: <socket: 18>: does not exist (Connection refused))
        "--match"
        "'!/Database/Read/Writes/Corpus creation/Can add documents to a Corpus/'"
      ];

      # Beware those failures are non-deterministic.
      # For reproducing it may help to use a project's variant like "coverage":
      #     $ nix -L build .#project.projectVariants.coverage.hsPkgs.gargantext.components.tests.garg-test-tasty
      #     $ for i in {1..100}; do result/bin/garg-test-tasty --hide-successes || break; done
      # Note that testFlags are only applied on checks.*, not on tests.*
      packages.gargantext.components.tests.garg-test-tasty = {
        build-tools = [
          pkgs.graphviz
        ];
        testFlags = [
          "--pattern"
          ("'" + lib.concatStringsSep " && " [
            # FAIL: (non-deterministic)
            # Graph Clustering
            #     Cross
            #       Partition test:                                                 FAIL (0.14s)
            #         uncaught exception: ErrorCall
            #         *** Internal error in package accelerate ***
            #         *** Please submit a bug report at https://github.com/AccelerateHS/accelerate/issues
            #         Encountered a duplicate 'Tag'
            #           81: Tag 1, 77: Tag 1, 79: Tag 1, 84: Tag 1
            #         CallStack (from HasCallStack):
            #           internalError: Data.Array.Accelerate.Trafo.Sharing:2274:19
            #           buildInitialEnvExp: Data.Array.Accelerate.Trafo.Sharing:2702:17
            #           determineScopesExp: Data.Array.Accelerate.Trafo.Sharing:2608:17
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2636:26
            #           scopesFun1: Data.Array.Accelerate.Trafo.Sharing:2429:60
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2490:33
            #           travF2MEA: Data.Array.Accelerate.Trafo.Sharing:2406:38
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2464:33
            #           travEA: Data.Array.Accelerate.Trafo.Sharing:2397:38
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2509:34
            #           travF2A2: Data.Array.Accelerate.Trafo.Sharing:2405:38
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2490:33
            #           travF2MEA: Data.Array.Accelerate.Trafo.Sharing:2406:38
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2490:33
            #           travF2MEA: Data.Array.Accelerate.Trafo.Sharing:2406:38
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2331:46
            #           determineScopesSharingAcc: Data.Array.Accelerate.Trafo.Sharing:2718:17
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2818:33
            #           travAE: Data.Array.Accelerate.Trafo.Sharing:2767:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2790:32
            #           travE2: Data.Array.Accelerate.Trafo.Sharing:2749:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2780:30
            #           travE1: Data.Array.Accelerate.Trafo.Sharing:2766:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2789:32
            #           travE2: Data.Array.Accelerate.Trafo.Sharing:2749:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2780:30
            #           travE1: Data.Array.Accelerate.Trafo.Sharing:2751:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2800:32
            #           travE3: Data.Array.Accelerate.Trafo.Sharing:2760:36
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2712:56
            #           determineScopesSharingExp: Data.Array.Accelerate.Trafo.Sharing:2696:60
            #           determineScopesExp: Data.Array.Accelerate.Trafo.Sharing:2608:17
            #           scopesExp: Data.Array.Accelerate.Trafo.Sharing:2636:26
            #           scopesFun1: Data.Array.Accelerate.Trafo.Sharing:2400:60
            #           scopesAcc: Data.Array.Accelerate.Trafo.Sharing:2331:46
            #           determineScopesSharingAcc: Data.Array.Accelerate.Trafo.Sharing:2317:37
            #           determineScopesAcc: Data.Array.Accelerate.Trafo.Sharing:3101:5
            #           recoverSharingAcc: Data.Array.Accelerate.Trafo.Sharing:240:34
            #           convertOpenAcc: Data.Array.Accelerate.Trafo.Sharing:162:35
            #           convertAccWith: Data.Array.Accelerate.Trafo:71:37
            "!/Partition test/"

            # FIXME: FAIL (non-deterministic)
            #     Starting 1 job runners.
            #     Starting 1 job runners.
            #     expected: [Nothing,Just 10,Just 5]
            #      but got: [Nothing,Nothing,Nothing]
            "!/can fetch the latest job status/"

            # FIXME: FAIL (non-deterministic)
            # expected: [Just 100]
            #  but got: [Nothing]
            # expected: [Just 50]
            #  but got: [Nothing]
            "!/can spin two separate jobs and track their status separately/"

            # FIXME: FAIL
            # -- | Build the coocurency matrix for 62 unit of time
            # -- | Group 22 docs by 62 unit of time
            # Exception:
            # *** Internal error in package accelerate ***
            # *** Please submit a bug report at https://github.com/AccelerateHS/accelerate/issues
            # Encountered a duplicate 'Tag'
            #   208: Tag 1, 212: Tag 1, 210: Tag 1, 205: Tag 1
            "!/phyloCleopatre returns expected data/"

            # FIXME: FAIL
            # huge error diff
            "!/phylo2dot2json.is deterministic/"

            # FIXME: FAIL
            # Exception: /nix/store/yx2cnkj4hq6zk867nkvpffvyd9qy2slp-gargantext-test-garg-test-tasty-0.0.7.1.1-data/share/ghc-9.4.7/x86_64-linux-ghc-9.4.7/gargantext-0.0.7.1.1/test-data/phylo/GarganText_NgramsList-187482.csv: openBinaryFile: does not exist (No such file or directory)
            #"!/toPhylo.is deterministic/"

            # FIXME: recursively call cabal
            "!/test vector works/"

            # FIXME: FAIL (deterministic when coverage is enabled):
            # nix -L build .#project.projectVariants.haskell-nix-ghc.flake"'".ciJobs.coverage.gargantext
            #
            # check if similarities optimizations are well implemented
            #     uncaught exception: ErrorCall
            #     *** Internal error in package accelerate ***
            #     *** Please submit a bug report at https://github.com/AccelerateHS/accelerate/issues
            #     Encountered a duplicate 'Tag'
            #       259: Tag 1, 261: Tag 1
            "!/Conditional/"
          ] + "'")
        ];
      };
    })
  ];
}
